'*******************************************************************************
'*                                                                             *
'*   GALIRC.BAS                                                                *
'*                                                                             *
'*   Copyright (C) 1995 Galacticomm, Inc.        All rights reserved.          *
'*                                                                             *
'*   .BAS file for the Internet Relay Chat client app.                         *
'*                                                                             *
'*                                                  - Scott Brinker 7/26/95    *
'*                                                                             *
'*                                                                             *
'*******************************************************************************

Option Explicit

Global Const NICKLEN = 9                ' max length of an IRC nick(name)
Global Const IRCNAMELEN = 50            ' max length of an IRC description
Global Const CHNSIZ = 63                ' max length of an IRC channel name
Global Const SERVLEN = 127              ' max length of an IRC server address

                                        ' indices into IRC ircolor() array
Global Const PUBNIC = 0                 '   public message, nick
Global Const PUBTXT = 1                 '   public message, message
Global Const PRVNIC = 2                 '   private message, nick
Global Const PRVTXT = 3                 '   private message, message
Global Const ACTNIC = 4                 '   action message, nick
Global Const ACTTXT = 5                 '   action message, message
Global Const EOLNIC = 6                 '   enter/leave/change nick, nick
Global Const EOLTXT = 7                 '   enter/leave/change nick, message
Global Const GENTXT = 8                 '   general purpose text messages

Global Const LBORDER = 2                ' left border for printing (in pixels)
Global Const BBORDER = 2                ' bottom border for printing (in pixels)

Global nick As String * NICKLEN         ' user's IRC nick(name)
Global ircnam As String * IRCNAMELEN    ' user's IRC description
Global serv As String * SERVLEN         ' user's IRC server
Global port As Integer                  ' user's TCP/IP port

Global chan As String * CHNSIZ          ' user's current IRC channel name
Global whocmd As String * 127           ' command to "refresh" who list
Global lstcmd As String * 127           ' command to "refresh" channel list

Global lstchn As String * 10            ' channel for list box
Global lstuct As String * 3             ' channel user count for list box

Global whodun As Integer                ' is who list finished?

Global ircolor(9) As Long               ' array of IRC message colors

Global banned() As String               ' array of banned IRC channels
Global nbanned As Integer               ' number of banned IRC channels

Global supdcb As Integer                ' suppress disconnect gmsgbox ?

Global sbbuf As String                  ' scrollback buffer
Global sbsiz As Long                    ' current size of scrollback buffer

                                        ' handy string variables
Global nl As String                     '   NL/CR
Global tb As String                     '   TAB

Type rect                               ' Win SDK RECT structure declaration
    Left As Integer
    Top As Integer
    right As Integer
    bottom As Integer
End Type

Declare Function ScrollDC Lib "User" (ByVal hDC As Integer, ByVal dx As Integer, ByVal dy As Integer, lprcScroll As rect, lprcClip As rect, ByVal hRgnUpdate As Integer, ByVal lprcUpdate As Long) As Integer

Function banchan (ByVal chan As String) As Integer
' eliminates channel name from channel listing, joining, etc.

    Dim i As Integer

    banchan = False
    For i = 0 To nbanned - 1
        If InStr(1, chan, banned(i)) <> 0 Then
            banchan = True
            Exit Function
        End If
    Next i
End Function

Sub banthese (ByVal list As String)
' build list of banned channels

    Dim i As Integer

    nbanned = itemcnt(list) - 1
    ReDim banned(nbanned)
    For i = 0 To nbanned - 1
        banned(i) = itemidx(list, i)
    Next i
End Sub

Private Function fndbrk (ByVal remstg As String, pictbox As PictureBox, ByVal wid As Integer)
' determine break position for line wrapping
' remstg: current part of string being printed
' pictbox: picture box being printed to
' wid: maximum text width allowed (in pixels)
' returns: position in string where break should occur

    Dim remlen As Integer, brkpos As Integer
    Dim i As Integer, j As Integer

    remlen = Len(remstg)
    For i = remlen To 1 Step -1
        If pictbox.TextWidth(Left$(remstg, i)) <= wid Then
            brkpos = i
            For j = i To 1 Step -1
                If Mid$(remstg, j, 1) = " " Then
                    brkpos = j - 1
                    Exit For
                End If
            Next j
            Exit For
        End If
    Next i
    fndbrk = brkpos
End Function

Sub hdlirc (ByVal dpknam As String, ByVal dpkval As String, pictbox As PictureBox)
' handle message data from IRC agent
' dpknam: dpk name, indicating what type of data received
' dpkval: data received from agent
' pictbox: picturebox to print to

    Dim pfxstg As String, sfxstg As String
    Dim remstg As String, pstg As String
    Dim maxhgt As Integer, pfxhgt As Integer, sfxhgt As Integer
    Dim wid As Integer, brkpos As Integer
    Dim firstline As Integer
    Dim pfxcolor As Long, sfxcolor As Long

    supips dpknam, dpkval, pfxstg, pfxcolor, sfxstg, sfxcolor
    pictbox.ForeColor = sfxcolor    ' this is where you could set the font
    sfxhgt = pictbox.TextHeight(sfxstg)
    maxhgt = sfxhgt
    If pfxstg <> "" Then
        pictbox.ForeColor = pfxcolor ' this is where you could set the font
        pfxhgt = pictbox.TextHeight(pfxstg)
        If pfxhgt > maxhgt Then
            maxhgt = pfxhgt
        End If
        wid = pictbox.ScaleWidth - 2 * LBORDER - pictbox.TextWidth(pfxstg)
        If wid >= pictbox.TextWidth("W") Then
            junk = prtipic(pictbox, pfxstg, LBORDER, False, maxhgt, BBORDER)
        Else
            junk = prtipic(pictbox, pfxstg, LBORDER, True, maxhgt, BBORDER)
            wid = pictbox.ScaleWidth - 2 * LBORDER
            maxhgt = sfxhgt
        End If
        pictbox.ForeColor = sfxcolor ' this is where you could set the font
    Else
        wid = pictbox.ScaleWidth - 2 * LBORDER
    End If
    If wid >= pictbox.TextWidth("W") Then
        remstg = RTrim$(sfxstg)
        firstline = True
        Do While pictbox.TextWidth(remstg) > wid
            brkpos = fndbrk(remstg, pictbox, wid)
            If firstline Then
                junk = prtipic(pictbox, Left$(remstg, brkpos), LBORDER, True, maxhgt, BBORDER)
                wid = pictbox.ScaleWidth - pictbox.TextWidth(String$(4, " "))
                firstline = False
            Else
                pstg = String$(4, " ") & Left$(remstg, brkpos)
                junk = prtipic(pictbox, pstg, LBORDER, True, pictbox.TextHeight(pstg), BBORDER)
            End If
            remstg = LTrim$(Right$(remstg, Len(remstg) - brkpos))
        Loop
        If firstline Then
            junk = prtipic(pictbox, remstg, LBORDER, True, maxhgt, BBORDER)
        Else
            junk = prtipic(pictbox, String$(4, " ") & remstg, LBORDER, True, pictbox.TextHeight(remstg), BBORDER)
        End If
    End If
End Sub

Function prtipic (pictbox As PictureBox, ByVal stg As String, ByVal lbrder As Integer, ByVal nwline As Integer, ByVal prthgt As Integer, ByVal bbrder As Integer) As Integer
' print text to a picture box
' pictbox: picture box to print to
' stg: string to print
' lbrder: left printing border (in pixels)
' nwline: go to next line after printing?
' prthgt: height required to print this text
' bbrder: bottom printing border (in pixels)
' returns: amount it had to scroll by (0 if didn't need to)

    Dim amtscld As Integer, savy As Integer

    amtscld = sclpict(pictbox, lbrder, bbrder, prthgt)
    If pictbox.CurrentX = 0 Then
        pictbox.CurrentX = lbrder
    End If
    savy = pictbox.CurrentY
    If pictbox.TextHeight(stg) < prthgt Then
        pictbox.CurrentY = pictbox.CurrentY + (prthgt - pictbox.TextHeight(stg))
    End If
    If nwline Then
        pictbox.Print stg
        pictbox.CurrentY = savy + prthgt
    Else
        pictbox.Print stg;
        pictbox.CurrentY = savy
    End If
    prtipic = amtscld
End Function

Private Function sclpict (pictbox As PictureBox, ByVal lbrder As Integer, ByVal bbrder As Integer, ByVal prthgt As Integer) As Integer
' scroll picture box
' lbrder: left/right print border of picture box
' bbrder: bottom/top print border of picture box
' prthgt: height of latest text to print

    Dim dy As Integer, savx As Integer, savy As Integer
    Dim scrollrect As rect

    If pictbox.CurrentY > pictbox.ScaleHeight - bbrder - prthgt Then
        If pictbox.CurrentY < pictbox.ScaleHeight - bbrder Then
            dy = prthgt - (pictbox.ScaleHeight - bbrder - pictbox.CurrentY)
        Else
            dy = prthgt
        End If
        scrollrect.Top = bbrder
        scrollrect.Left = lbrder
        scrollrect.bottom = pictbox.ScaleHeight - bbrder
        scrollrect.right = pictbox.ScaleWidth - lbrder
        junk = ScrollDC(pictbox.hDC, 0, -dy, scrollrect, scrollrect, 0, 0)
        savx = pictbox.CurrentX
        pictbox.Line (0, pictbox.ScaleHeight - bbrder - prthgt)-(pictbox.ScaleWidth, pictbox.ScaleHeight), pictbox.BackColor, BF
        savy = pictbox.CurrentY
        pictbox.CurrentX = savx
        pictbox.CurrentY = savy - bbrder - prthgt
    End If
    sclpict = dy
End Function

Private Sub supips (ByVal dpknam As String, ByVal dpkval As String, pfxstg As String, pfxcolor As Long, sfxstg As String, sfxcolor As Long)
' set up prefix/suffix strings and font colors for display
' dpknam: dpk received from agent, indicates type of data
' dpkval: data received from agent
' pfxstg: formatted prefix for printing
' pfxcolor: font color information for pfxstg
' sfxstg: formatted suffix for printing
' sfxcolor: font color information for sfxstg
' implicit output: entries in ircolor(), if user doesn't have a
'                  particular color

    Dim pfxcidx As Integer, sfxcidx As Integer

    Select Case dpknam
    Case "sau:pubmsg"
        pfxstg = "From " & itemidx(dpkval, 0) & ": "
        pfxcidx = PUBNIC
        sfxstg = itemidx(dpkval, 1)
        sfxcidx = PUBTXT
    Case "sau:privmsg"
        pfxstg = "From " & itemidx(dpkval, 0) & " (private): "
        pfxcidx = PRVNIC
        sfxstg = itemidx(dpkval, 1)
        sfxcidx = PRVTXT
    Case "sau:onpubact"
        pfxstg = itemidx(dpkval, 0) & " "
        pfxcidx = ACTNIC
        sfxstg = itemidx(dpkval, 1)
        sfxcidx = ACTTXT
    Case "sau:onprvact"
        pfxstg = itemidx(dpkval, 0) & " (privately) "
        pfxcidx = ACTNIC
        sfxstg = itemidx(dpkval, 1)
        sfxcidx = ACTTXT
    Case "sau:join"
        pfxstg = itemidx(dpkval, 0)
        pfxcidx = EOLNIC
        If pfxstg = Trim$(nick) Then
            pfxstg = ""
            sfxstg = "You have just joined channel " & itemidx(dpkval, 2) & "."
            ircmain!chnbox = Trim$(itemidx(dpkval, 2))
            ircmain!wmwholst.Enabled = True
        Else
            sfxstg = " just joined channel " & itemidx(dpkval, 2) & " with you."
        End If
        sfxcidx = EOLTXT
    Case "sau:onname"
        pfxstg = "Users on channel " & itemidx(dpkval, 0) & ": "
        pfxcidx = GENTXT
        sfxstg = itemidx(dpkval, 1)
        sfxcidx = GENTXT
    Case "sau:onquit"
        pfxstg = itemidx(dpkval, 0)
        pfxcidx = EOLNIC
        sfxstg = " just quit this channel (""" & itemidx(dpkval, 1) & """)."
        sfxcidx = EOLTXT
    Case "sau:part"
        pfxstg = itemidx(dpkval, 0)
        pfxcidx = EOLNIC
        If pfxstg = Trim$(nick) Then
            pfxstg = ""
            sfxstg = "You have just parted channel " & itemidx(dpkval, 2) & "."
            ircmain!chnbox = ""
            ircmain!wmwholst.Enabled = False
        Else
            sfxstg = " just parted from channel " & itemidx(dpkval, 2) & "."
        End If
        sfxcidx = EOLTXT
    Case "sau:onnotic"
        pfxstg = itemidx(dpkval, 0) & ": "
        pfxcidx = GENTXT
        sfxstg = itemidx(dpkval, 1)
        sfxcidx = GENTXT
    Case "sau:defnum"
        pfxstg = "*** "
        pfxcidx = GENTXT
        sfxstg = itemidx(dpkval, 0)
        sfxcidx = GENTXT
    Case "sau:ukick"
        pfxstg = ""
        pfxcidx = EOLNIC
        sfxstg = "You have been kicked from " & itemidx(dpkval, 0)
        sfxstg = sfxstg & " by " & itemidx(dpkval, 1)
        sfxstg = sfxstg & " (""" & itemidx(dpkval, 2) & """)."
        sfxcidx = EOLTXT
        ircmain!chnbox = ""
        ircmain!wmwholst.Enabled = False
    Case "sau:onkick"
        pfxstg = itemidx(dpkval, 0)
        pfxcidx = EOLNIC
        sfxstg = " has been kicked from channel " & itemidx(dpkval, 1)
        sfxstg = sfxstg & " by " & itemidx(dpkval, 2)
        sfxstg = sfxstg & " (""" & itemidx(dpkval, 3) & """)."
        sfxcidx = EOLTXT
    Case "sau:ontopic"
        pfxstg = "Channel topic: "
        pfxcidx = GENTXT
        sfxstg = itemidx(dpkval, 0)
        sfxcidx = GENTXT
    Case "sau:oninvit"
        pfxstg = itemidx(dpkval, 0)
        pfxcidx = PRVNIC
        sfxstg = " is inviting you to channel " & itemidx(dpkval, 1) & "."
        sfxcidx = PRVTXT
    Case "sau:onnick"
        pfxstg = itemidx(dpkval, 0)
        pfxcidx = EOLNIC
        sfxstg = " has changed nickname to " & itemidx(dpkval, 1) & " now."
        sfxcidx = EOLTXT
    Case "sau:cmode"
        pfxstg = itemidx(dpkval, 0)
        pfxcidx = GENTXT
        sfxstg = "has changed a mode on channel " & itemidx(dpkval, 1) & " to: " & itemidx(dpkval, 2)
        sfxcidx = GENTXT
    Case "sau:on341"
        pfxstg = ""
        sfxstg = "Inviting " & itemidx(dpkval, 0) & " to " & itemidx(dpkval, 1) & "."
        sfxcidx = GENTXT
    Case "local"
        pfxstg = "From " & Trim$(nick) & ": "
        pfxcidx = PUBNIC
        sfxstg = Trim$(dpkval)
        sfxcidx = PUBTXT
    Case "locact"
        pfxstg = Trim$(nick) & " "
        pfxcidx = ACTNIC
        sfxstg = Trim$(dpkval)
        sfxcidx = ACTTXT
    Case "waiting"
        pfxstg = ""
        sfxstg = "(Waiting to connect to server, use File...Quit to try a different location.)"
        sfxcidx = GENTXT
    End Select
    If pfxstg <> "" Then
        pfxcolor = ircolor(pfxcidx)
    End If
    If sfxstg <> "" Then
        sfxcolor = ircolor(sfxcidx)
    End If
End Sub

