'****************************************************************************
'*                                                                          *
'*  GALFOMAN.BAS                                                            *
'*                                                                          *
'*  Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  Miscellaneous functions and variables used by the forum manager.        *
'*                                                                          *
'*                                                  - J. Alvrus 4/22/96     *
'*                                                                          *
'****************************************************************************

Option Explicit

Global Const MGRAPID = "GALFOMAN"   ' forum manager App-ID
Global Const MAINFRMPOSID = "mainform" ' main forum posiload()/posisave() ID string

Function getaxes (ByVal fornam As String, ByVal dftaxes As Integer)
' by hook or by crook, get user's correct forum access
' fornam:   name of forum to get access in
' dftaxes:  use this if can't read forum info

    Dim forinf As foruminf

    If getforinf(forinf, fornam) Then
        getaxes = infaxes(forinf)
    Else
        getaxes = dftaxes
    End If
End Function

Function grpidstr (ByVal grpid As Integer) As String
' generate properly-formatted group ID string

    grpidstr = Format$(grpid, "00000")
End Function

Sub loadgrplin (lst As Control, grparr() As grpinfmem)
' load a group information array into an outline control
' lst:      outline control to load
' grparr:   array of group information structures

    Dim i As Integer, curparid As Integer
    Dim tmps As String

    winrefresh lst.hWnd, False
    lst.Clear
    lst.AddItem ROOTGRPSTR, 0
    lst.Indent(0) = 1
    curparid = ROOTGRPID
    lst.ListIndex = 0
    For i = 1 To ningarr(grparr()) - 1
        If grparr(i).parid <> curparid Then
            lst.ListIndex = getgidx(grparr(i).parid, grparr())
            curparid = grparr(lst.ListIndex).grpid
        End If
        tmps = grplinitem(Trim$(grparr(i).name), Trim$(grparr(i).topic))
        lst.AddItem tmps
        lst.Expand(lst.ListIndex) = True
    Next
    lst.ListIndex = 0
    winrefresh lst.hWnd, True
    lst.Refresh
End Sub

Sub setflstbmp (lstbox As Control, ByVal idx As Integer, ByVal axes As Integer)
' set forum list picture

    If (axes And FISECHO) <> 0 Then
        lstbox.Picture(idx) = mainform!echobmp
    Else
        lstbox.Picture(idx) = mainform!forumbmp
    End If
End Sub

Sub showdetails (fdetfrm As Form, ByVal forum As String)
' show details on a forum
' fdetfrm: form to use to show details
' forum: name of forum to show details on

    Dim i As Integer
    Dim echostr As String
    Dim fdet() As viewfdpk

    If appconnect() Then
        screen.MousePointer = HOURGLASS
        ReDim fdet(0)
        If sreadpk(FDETDPK & Trim$(forum), Len(fdet(0)), fdet(0)) <> 0 Then
            Load fdetfrm
            stpnls fdet(0).info
            fdetfrm.Caption = "Details on the " & Trim$(dblamp(getminf(fdet(0).info, FNAME))) & " Forum"
            fdetfrm!forop = dblamp(getminf(fdet(0).info, FFOROP))
            fdetfrm!topic = dblamp(getminf(fdet(0).info, FTOPIC))
            fdetfrm!nmsgs = fdet(0).nmsgs
            fdetfrm!nthrs = fdet(0).nthrs
            fdetfrm!nfils = fdet(0).nfiles
            fdetfrm!msglif = fdet(0).msglif
            fdetfrm!chgmsg = fdet(0).chgmsg
            fdetfrm!chgrdm = fdet(0).chgrdm
            fdetfrm!chgatt = fdet(0).chgatt
            fdetfrm!chgadl = fdet(0).chgadl
            fdetfrm!chgupk = fdet(0).chgupk
            fdetfrm!chgdpk = fdet(0).chgdpk
            If fdet(0).necho = 0 Then
                fdetfrm!echolst.Visible = False
                fdetfrm!echolbl.Visible = False
                fdetfrm!parmframe.Height = 2055
                applyoff fdetfrm!detframe, fdetfrm!parmframe, TOP2BOTTOM, -SAMEDIST
                applyoff fdetfrm!clsbtn, fdetfrm!detframe, TOP2BOTTOM, -DIFFDIST
                applyoff fdetfrm!hlpbtn, fdetfrm!detframe, TOP2BOTTOM, -DIFFDIST
                mdinisiz fdetfrm, fdetfrm.ScaleWidth, fdetfrm!hlpbtn.Top + fdetfrm!hlpbtn.Height + DIFFDIST
            Else
                echostr = getminf(fdet(0).info, FEADDRS)
                For i = 0 To fdet(0).necho - 1
                    fdetfrm!echolst.AddItem itemidxd(echostr, i, ";")
                Next
                fdetfrm!echolst.ListIndex = 0
                fdetfrm!echolbl.ForeColor = WINDOW_TEXT
            End If
            fdetfrm!detinfo = cvt4dsp(getminf(fdet(0).info, FDESC), True)
            screen.MousePointer = DEFAULT
            fdetfrm.Show 1
        End If
        Erase fdet
        screen.MousePointer = DEFAULT
    End If
End Sub

