'*************************************************************************
'*                                                                       *
'*   GALFILB.BAS                                                         *
'*                                                                       *
'*   Copyright (c) 1994-1997 Galacticomm, Inc.   All Rights Reserved.    *
'*                                                                       *
'*   File Library adaptation of Dynamic ListBox Toolset API              *
'*                                                                       *
'*                                             - D. Pitchford  9/20/94   *
'*                                                                       *
'*************************************************************************

Option Explicit

'************************** global declarations ********************************

Global Const LBOXBACK = -1      ' fill listbox prefix cache
Global Const LBOXBOTH = 0       ' fill listbox both caches
Global Const LBOXFORE = 1       ' fill listbox suffix cache

Global lbfore As Integer        ' currently reading forwards
Global lbback As Integer        ' currently reading in reverse
Global lbfid As Integer         ' request id for forward reads
Global lbbid As Integer         ' request id for reverse reads

Global lbsuf As String          ' Dynapak minimum match requirement
Global ambles As String         ' Preserved preambles
Global nolbmore As Integer      ' is set to True to make lbmore() ineffectual

'************************** local declarations *********************************

Dim lblbox As Control           ' ListBox in use
Dim valbox As Control           ' ListBox in use holding values
Dim lbcbak As Control           ' CallBack control in use
Dim lbpfx As String             ' Dynapak name, w/o key

Dim lboxkey() As String         ' array of dynapak keys
Dim lboxnum As Integer          ' # elements in lboxkey() array
Dim lboxtop As Integer          ' lboxkey() index of top element in listbox
Dim indextop As Integer         ' current topindex of listbox
Dim lboxsiz As Integer          ' # elements on display
Dim cachesiz As Integer         ' # elements to keep ahead, behind
Dim backwards As Integer        ' true to reverse search polarity

Dim fdeny As String             ' last denied forward namdpk
Dim bdeny As String             ' last denied forward namdpk

Function isblank (ByVal entry As String) As Integer
' determine whether listbox entry is a blank filler

    Select Case Left$(entry, 1)
    Case "", Chr$(9)
        isblank = True
    Case Else
        isblank = False
    End Select
End Function

Sub lbappend (item As String, key As String)
' add an item to the end of the listbox
' key: dynapak key (sa:suffix <key>)

    Dim i As Integer, lsavti As Integer, vsavti As Integer

    If lboxnum = lboxsiz + 2 * cachesiz Then
        lsavti = lblbox.TopIndex - 1
        vsavti = valbox.TopIndex - 1
        winrefresh lblbox.hWnd, False
        winrefresh valbox.hWnd, False
        nolbmore = True
        lblbox.RemoveItem 0
        valbox.RemoveItem 0
        lboxnum = lboxnum - 1
        For i = 1 To lboxnum
            lboxkey(i - 1) = lboxkey(i)
        Next i
        Do
            If lblbox.ListCount > 0 Then
                If isblank(lblbox.List(lblbox.ListCount - 1)) Then
                    lblbox.RemoveItem lblbox.ListCount - 1
                    valbox.RemoveItem lblbox.ListCount - 1
                Else
                    Exit Do
                End If
            Else
                Exit Do
            End If
        Loop
        lblbox.TopIndex = lsavti
        valbox.TopIndex = vsavti
        junk = lbindex(lblbox.TopIndex)
        nolbmore = False
        winrefresh valbox.hWnd, True
        winrefresh lblbox.hWnd, True
    End If
    lboxkey(lboxnum) = key
    lboxnum = lboxnum + 1
    For i = lblbox.ListCount - 1 To 0 Step -1
        If Not isblank(lblbox.List(i)) Then
            valbox.AddItem item, i + 1
            lblbox.AddItem xlate(ival(lblbox.Parent!Label1(0).Tag), item), i + 1
            Exit Sub
        End If
    Next i
    valbox.AddItem item, 0
    lblbox.AddItem xlate(ival(lblbox.Parent!Label1(0).Tag), item), 0
End Sub

Function lbcallback (evtstg As String, ByVal reqid As Integer, ByVal deny As Integer, libname As String, filname As String, coslib As String) As Integer
' callback handler for listbox reads

    Dim savti As Integer
    Dim hilite As Integer
    Dim fdet As fsdpk, resp As String

    Select Case evtstg
    Case "Session shutdown"
        lbcallback = False
        Exit Function
    Case "Dynapak received", "Dynapak available"
        If lblbox.ListCount > 0 Then
            If isblank(lblbox.List(0)) And isblank(lblbox.List(lblbox.ListCount - 1)) Then
                hilite = True
            Else
                hilite = False
            End If
        Else
            hilite = False
        End If
        If Not sview Then
            junk = cbkrsp(Len(fdet), fdet)
            resp = filname & Chr$(9) & libname & Chr$(9) & Trim$(Str$(fdet.cost)) & Chr$(9)
            resp = resp & Format$(fdet.size, "#,##0") & Chr$(9)
            resp = resp & Trim$(Str$(fdet.filedt)) & Chr$(9)
            resp = resp & Trim$(Str$(fdet.addedt)) & Chr$(9)
            resp = resp & Trim$(Str$(fdet.numdls)) & Chr$(9)
            resp = resp & coslib & Chr$(9) & itemidx(fdet.data, 0) & Chr$(9)
        Else
            resp = filname
        End If
        If reqid = lbfid Then
            If Not deny Then
                If Not sview Then
                    lbappend resp, ambles & namdpk()
                    svlstadd resp
                Else
                    lbappend resp, libname
                End If
                fdeny = ""
            Else
                fdeny = namdpk()
            End If
            lbfore = lbfore - 1
            If lbfore <= 0 Then
                lbfore = 0
                lbfid = -1
                If Not sview Then
                    lbmore LBOXFORE
                End If
            End If
            If hilite And Not deny Then
                lblbox.ListIndex = lblbox.LastAdded
                On Error Resume Next
                lblbox.SetFocus
                On Error GoTo 0
            End If
        ElseIf reqid = lbbid Then
            If Not deny Then
                If Not sview Then
                    lbpreface resp, ambles & namdpk()
                Else
                    lbpreface resp, libname
                End If
                bdeny = ""
            Else
                bdeny = namdpk()
            End If
            lbback = lbback - 1
            If hilite And Not deny Then
                lblbox.ListIndex = lblbox.LastAdded
            End If
            If lbback <= 0 Then
                lbback = 0
                lbbid = -1
                If Not sview Then
                    lbmore LBOXBACK
                End If
            End If
        End If
    Case "No more dynapaks", "Offline read denied", "Request aborted", "Connection down"
        If reqid <> -1 Then
            If reqid = lbfid Then
                lbfore = 0
                lbfid = -1
                winrefresh lblbox.hWnd, False
                nolbmore = True
                savti = lblbox.TopIndex
                Do
                    If lblbox.ListCount > 0 Then
                        If isblank(lblbox.List(lblbox.ListCount - 1)) Then
                            valbox.RemoveItem lblbox.ListCount - 1
                            lblbox.RemoveItem lblbox.ListCount - 1
                        Else
                            Exit Do
                        End If
                    Else
                        Exit Do
                    End If
                Loop
                lblbox.TopIndex = savti
                nolbmore = False
                winrefresh lblbox.hWnd, True
                If svlstels >= 0 Then
                    svlstnxt = ""
                End If
            ElseIf reqid = lbbid Then
                lbbid = -1
                lbback = 0
            End If
        End If
    End Select
    lbcallback = True
End Function

Sub lbinit (lb As Control, rb As Control, ByVal csize As Integer, cbak As Control, ByVal pfx As String, ByVal suf As String, ByVal rev As Integer)
' clears and initializes the lboxkey() array and listbox
' lb: listbox control
' csize: size each of of prefix and suffix caches

    Dim s As String, i As Integer

    lbfid = -1
    lbbid = -1
    Set lblbox = lb
    Set valbox = rb
    cachesiz = csize
    Set lbcbak = cbak
    lbpfx = pfx
    lbsuf = suf
    backwards = rev
    ambles = ""
    fdeny = ""
    bdeny = ""
    s = Left$(pfx, Len(pfx) - Len(suf))
    For i = Len(s) To 1 Step -1
        If Mid$(s, i, 1) = ")" Then
            ambles = Left$(s, i)
            Exit For
        End If
    Next i
    lboxsiz = lbnlines()
    lboxnum = 0
    nolbmore = True
    lblbox.Clear
    valbox.Clear
    nolbmore = False
    indextop = 0
    lboxtop = 0
    ReDim lboxkey(lboxsiz + 2 * cachesiz)
End Sub

Function lbkey (ByVal first As Integer) As String
' returns the highest or lowest key from the dynapak key array

    Dim key As String

    If first Then
        If bdeny = "" Then
            key = lboxkey(0)
        Else
            key = ambles & bdeny
        End If
    ElseIf lboxnum > 0 Then
        If fdeny = "" Then
            key = lboxkey(lboxnum - 1)
        Else
            key = ambles & fdeny
        End If
    Else
        key = ""
    End If
    lbkey = key
End Function

Sub lbmore (ByVal which As Integer)
' gets the next records, in either direction.
' which: LBOXBACK, prefix; LBOXFORE, suffix; LBOXBOTH, both prefix & suffix

    If nolbmore Then
        Exit Sub
    End If
    Select Case which
    Case LBOXBACK
        lbmored True, lbpfx
    Case LBOXBOTH
        lbmored False, lbpfx
        lbmored True, lbpfx
    Case LBOXFORE
        lbmored False, lbpfx
    End Select
End Sub

Sub lbmored (ByVal pre As Integer, ByVal namdpk As String)
' do the actual directional read of the dynapak
' pre: do less-than read
' namdpk: override dynapak name

    Dim i As Integer
    Dim res As String

    i = lbneeded(pre)
    If i > 0 Then
        res = lbkey(pre)
        If res = "" Then
            res = namdpk
        End If
        If backwards Then
            If Not pre Then
                If lbfid <> -1 Then
                    Exit Sub
                End If
                lbfore = i
                If Not sview Then
                    lbfid = rltdpk(wtspace(res), wtspace(lbsuf), i, lbcbak)
                Else
                    svread True, lbfid, res, i
                End If
            Else
                If lbbid <> -1 Then
                    Exit Sub
                End If
                lbback = i
                If Not sview Then
                    lbbid = rgtdpk(wtspace(res), wtspace(lbsuf), i, lbcbak)
                Else
                    svread False, lbbid, res, i
                End If
            End If
        Else
            If pre Then
                If lbbid <> -1 Then
                    Exit Sub
                End If
                lbback = i
                If Not sview Then
                    lbbid = rltdpk(wtspace(res), wtspace(lbsuf), i, lbcbak)
                Else
                    svread True, lbbid, res, i
                End If
            Else
                If lbfid <> -1 Then
                    Exit Sub
                End If
                lbfore = i
                If Not sview Then
                    lbfid = rgtdpk(wtspace(res), wtspace(lbsuf), i, lbcbak)
                Else
                    svread False, lbfid, res, i
                End If
            End If
        End If
    End If
End Sub

Function lbneeded (ByVal back As Integer) As Integer
' returns how many items are needed to fill the cache in a
'  specific direction (back=True; prefix.  False; suffix)

    Dim Count As Integer

    Count = 0
    If back And (lbback = 0) Then   ' need any for prefix cache?
        Count = cachesiz - lboxtop
    ElseIf (Not back) And (lbfore = 0) Then  ' need any for suffix cache?
        Count = lboxtop + lboxsiz + cachesiz - lboxnum
    End If
    If Count > 0 Then
        lbneeded = Count
    Else
        lbneeded = 0
    End If
End Function

Function lbnlines () As Integer
' returns number of lines in the listbox

    Dim threed As Integer

    If lblbox.ListStyle = 1 Then
        threed = 60
    Else
        threed = 0
    End If
    lbnlines = (lblbox.Height - 30) / (lblbox.Parent.TextHeight("junk") + threed)
End Function

Sub lbpreface (item As String, key As String)
' add item to the beginning of a listbox invisibly
' key: dynapak key (sa:suffix <key>)

    Dim i As Integer, vsavti As Integer, lsavti As Integer

    lblbox.ReFreshOnUpdate = False
    winrefresh lblbox.hWnd, False
    winrefresh valbox.hWnd, False
    nolbmore = True
    lsavti = lblbox.TopIndex
    vsavti = valbox.TopIndex
    If lboxnum = lboxsiz + 2 * cachesiz Then
        Do
            If lblbox.ListCount > 0 Then
                If isblank(lblbox.List(lblbox.ListCount - 1)) Then
                    valbox.RemoveItem lblbox.ListCount - 1
                    lblbox.RemoveItem lblbox.ListCount - 1
                Else
                    Exit Do
                End If
            Else
                Exit Do
            End If
        Loop
        valbox.RemoveItem valbox.ListCount - 1
        lblbox.RemoveItem lblbox.ListCount - 1
        If svlstels >= 0 Then
            svlstchp = svlstchp + 1
        End If
        lblbox.TopIndex = lsavti
        valbox.TopIndex = vsavti
        lboxnum = lboxnum - 1
    End If
    For i = lboxnum To 1 Step -1
        lboxkey(i) = lboxkey(i - 1)
    Next i
    lboxnum = lboxnum + 1
    lboxkey(0) = key
    valbox.AddItem item, 0
    lblbox.AddItem xlate(ival(lblbox.Parent!Label1(0).Tag), item), 0
    lblbox.TopIndex = lsavti + 1
    valbox.TopIndex = vsavti + 1
    nolbmore = False
    winrefresh valbox.hWnd, True
    winrefresh lblbox.hWnd, True
    lblbox.ReFreshOnUpdate = True
End Sub

Sub lbresize ()
' resizes the key arrays based on capacity of listbox

    Dim limit As Integer, i As Integer, ti As Integer
    Dim numdisp As Integer

    numdisp = lbnlines()
    If numdisp <= 0 Then
        Exit Sub
    End If
    lboxsiz = numdisp
    limit = lboxsiz + 2 * cachesiz
    If lboxnum > limit Then
        limit = lboxnum - limit
        lboxnum = lboxnum - limit
        ti = lblbox.TopIndex
        nolbmore = True
        For i = 1 To limit
            If lblbox.ListCount > 0 Then
                valbox.RemoveItem lblbox.ListCount - 1
                lblbox.RemoveItem lblbox.ListCount - 1
            End If
        Next i
        nolbmore = False
        lblbox.TopIndex = ti
    End If
    ReDim Preserve lboxkey(lboxsiz + 2 * cachesiz)
End Sub

Sub lbtopidx (ByVal TopIndex As Integer)
' decides whether the listbox needs elements, since the TopIndex changed

    Dim filldir As Integer

    filldir = lbindex(TopIndex)
    If filldir < 0 Then
        lbmore LBOXBACK
    ElseIf filldir > 0 Then
        lbmore LBOXFORE
    End If
End Sub

Sub svread (ByVal pre As Integer, reqid As Integer, ByVal key As String, ByVal ntimes As Integer)

    Dim i As Integer, j As Integer, rec As savdatrec, item As String

    i = ival(key)
    If pre Then
        reqid = -2
    Else
        reqid = -3
    End If
    On Error GoTo datoops
    For j = 0 To ntimes - 1
        If pre Then
            i = i - 1
        Else
            i = i + 1
        End If
        If i >= 1 And i < savhdr.nrecs Then
            Get #savf, i + 1, rec
            item = svitem(rec)
            junk = lbcallback("Dynapak received", reqid, False, Str$(i), item, "")
        Else
            junk = lbcallback("No more dynapaks", reqid, False, "", "", "")
            Exit Sub
        End If
    Next j
    Exit Sub
datoops:
    junk = lbcallback("No more dynapaks", reqid, False, "", "", "")
    sview = False
    Close #savf
    Exit Sub
End Sub

Function lbindex (ByVal newtop As Integer) As Integer
' stores new TopIndex for the listbox (passed in)
' returns integer showing increase or decrease from previous value

    lboxtop = lboxtop + (newtop - indextop)
    lbindex = newtop - indextop
    indextop = newtop
End Function

Sub lbiniat (ByVal key As String, ByVal maxkeylen As Integer)
' init listbox, start listing at a certain key point
' note:lbinit must have been called once before
' key: key portion of dynapak (sa:suf <key>)
' maxkeylen: maximum length of key for olthan()

    Dim forepfx As String
    Dim nlines As Integer, i As Integer

    If lbfid <> -1 Then
        abodpk lbfid
        lbfore = 0
        lbfid = -1
    End If
    If lbbid <> -1 Then
        abodpk lbbid
        lbback = 0
        lbbid = -1
    End If
    If key <> "" Then
        If backwards Then
            forepfx = lbpfx & ogthan(key, maxkeylen)
        Else
            forepfx = lbpfx & olthan(key, maxkeylen)
        End If
    Else
        forepfx = lbpfx
    End If
    lbinit lblbox, valbox, cachesiz, lbcbak, lbpfx, lbsuf, backwards
    nlines = lbnlines()
    For i = 0 To nlines
        lblbox.AddItem ""
        valbox.AddItem ""
    Next i
    lbmored False, forepfx
    If Not sameas(forepfx, lbpfx) Then
        lbmored True, lbpfx & key
    End If
End Sub

