'*******************************************************************************
'*                                                                             *
'*   GALFIL.BAS                                                                *
'*                                                                             *
'*   Copyright (c) 1994-1997 Galacticomm, Inc.           All rights reserved.  *
'*                                                                             *
'*   File Libraries General Routines                                           *
'*                                                                             *
'*                                                  - D. Pitchford 9/8/94      *
'*                                                                             *
'*******************************************************************************

Option Explicit

Global Const LIBAPPID = "GALFIL"
Global Const LIBFILPF = "sa=GALFIL;uf:download "    ' download prefix
Global Const LIBLOCPF = "sa=GALFIL;ul:fl "          ' local prefix
Global Const VBFLDESCSZ = 40        ' short description size
Global Const VBFLLDESCS = 79        ' long description line size
Global Const VBDESCSIZ = 901        ' long description size

Global Const SAVLSTMP = "TEMP$$$$.$$$"  ' saved list temporary

Global Const DETINAM = 0            ' index for list option: filename
Global Const DETILIB = 1            ' index for list option: Library
Global Const DETIPOP = 2            ' index for list option: popularity
Global Const DETIADD = 3            ' index for list option: date added
Global Const DETISIZ = 4            ' index for list option: size
Global Const DETIDAT = 5            ' index for list option: file date
Global Const DETICST = 6            ' index for list option: cost
Global Const DETIDSC = 7            ' index for list option: description

Global Const NUMIIDXS = 8           ' total number of list options

Global Const MORESUM = 200          ' number of elements per list-box read
Global Const MORELIST = 600         ' max number of elements allowed in list-box

Const XLDATLEN = 600                    ' size for misc. data elements

Const FSDPKLEN = VBUIDSIZ + VBDESCSIZ   ' large size for file data

Type libdetails                     ' library details userdef type
    totfiles As Long                ' # of files in Library
    addtoday As Integer             ' # added today
    addweek As Integer              ' # added this week
    maxfil As Long                  ' max files allowed in Library
    maxbyt As Long                  ' max bytes allowed in Library
    maxbup As Long                  ' max upload size
    data As String * XLDATLEN       ' misc string data
End Type

Type fsdpk                          ' file details userdef type
    cost As Long                    ' apx. cost to download
    size As Long                    ' file size
    dltime As Integer               ' apx. minutes to download
    flags As Integer                ' bitflags, see below
    filedt As Double                ' date & time of file
    addedt As Double                ' date & time added
    numdls As Long                  ' number of downloads
    data As String * FSDPKLEN       ' description, or uploader & full desc.
End Type

Global Const FSDTVIEW = 1           ' flag: file is text
Global Const FSDCVIEW = 2           ' flag: file is compressed
Global Const FSDLIBOP = 4           ' flag: user has libop authority over file
Global Const FSDISDOS = 8           ' flag: file is in DOSONLY Lib

Type llistinf                       ' userdef type for library info
    numfiles As Long                ' # of files in Library
    flags As Integer                ' bitflags, see below
    desc As String * VBFLDESCSZ     ' library description
End Type

Global Const LLISDOS = 1            ' flag for sau:llist; DOS-ONLY Library
Global Const LLISUPL = 2            ' flag for sau:llist; Lib is uploadable
Global Const LLISLOP = 4            ' flag for sau:llist; Libop access
Global Const LLISACD = 8            ' flag for sau:llist; Library on CD
Global Const LLISHID = 16           ' flag for sau:llist; Library is ordinarily hidden

Type libcsed                        ' userdef type for create/edit Library
    flags As Integer                ' bitflags, see below
    created As Double               ' date & time created
    dlchge As Long                  ' per-file charge d/l
    kdlchge As Long                 ' per-K charge d/l
    royal As Integer                ' royalty percentage
    maxfil As Long                  ' max # files in Library
    maxbyt As Long                  ' max # bytes in Library
    maxbup As Long                  ' max upload size
    data As String * XLDATLEN       ' misc string data
End Type

Global Const ELIDOS = 1             ' DOS-Only
Global Const ELIRON = 2             ' Read-Only
Global Const ELIHID = 4             ' Hidden
Global Const ELISCD = 8             ' On CD
Global Const ELIADD = 16            ' Audit downloads
Global Const ELIADU = 32            ' Audit uploads
Global Const ELINCD = 64            ' No-charge A/A downloads
Global Const ELINCU = 128           ' No-charge A/A uploads
Global Const ELIAUD = 256           ' Audit all (ynopt)
Global Const ELIFUD = 512           ' Always no-charge A/A uploads (ynopt)

Type upltype                        ' upload array type
    fname As String                 ' filename uploading as
    path As String                  ' locally accessible path
    libname As String               ' destination library
    desc As String                  ' file description, if any
End Type

Global ulqueue() As upltype         ' dynamic array of uploads

Global ulqrid As Integer            ' request id for upload queue

Global Const SAVRECSZ = 100         ' saved list record size

Type savdathdr                      ' header record for saved list data file
    version As Integer              ' saved list version number
    nrecs As Long                   ' number of records
    sltag As Integer                ' numeric ival() of searcher!Label1(0).Tag
    sftag As String                 ' nominal searcher.Tag
    sstag As String                 ' nominal searcher!SSList1.Tag
End Type

Global savhdr As savdathdr          ' current header for records being saved

Type savdatrec                      ' data record for saved list data file
    filname As String * 12          ' file name
    libname As String * 8           ' library name
    cost As Long                    ' cost to download
    size As Long                    ' file size
    fdate As Double                 ' date and time of file
    udate As Double                 ' date and time file was added
    numdls As Long                  ' number of downloads
    coslib As String * 8            ' cosmetic libname
    desc As String * VBFLDESCSZ     ' file description
End Type

Global savf As Integer              ' File number for saved list
Global sview As Integer             ' currently viewing saved list

Global joinings() As String         ' libraries joined to things, using
Global rjoins() As String           ' libraries joined to things, reading
Global jrid As Integer              ' request id for joins dpk read

Global srchoff(7) As Single         ' calcoff()s for the child search form

Global tabwid(NUMIIDXS) As Integer  ' width of search's column, in twips
Global tabcwid(NUMIIDXS) As Integer ' width of search's column, in chars
Global tabstg(NUMIIDXS) As String   ' header for search's column

Global svlstels As Integer          ' number of elements accumulated in list
                                    ' -1 disables, -2 is ok but file is closed
Global svlstfil As Integer          ' file pointer for saved list
Global svlstchp As Integer          ' number of elements chopped off of the
                                    ' bottom of currently displayed list
Global svlstnxt As String           ' highest so far

Global svsav As Integer             ' saved list values
Global svt As Single                ' saved list top
Global svl As Single                ' saved list left
Global svw As Single                ' saved list width
Global svh As Single                ' saved list height
Global svs As Integer               ' saved list windowstate

Global dolater As Integer           ' dldir: download later
Global dolaunch As Integer          ' dldir: launch?

Global tbid As Integer              ' toolbar id from regtb()
Global Ok2Close As Integer          ' Flag for closing of lib details form

Sub addulq (ByVal libname As String, ByVal filname As String, ByVal path As String, ByVal desc As String)
' add an entry to the upload queue

    Dim idx As Integer

    If connect("default") Then
        idx = UBound(ulqueue)
        ReDim Preserve ulqueue(idx + 1)
        ulqueue(idx).fname = filname
        ulqueue(idx).libname = libname
        ulqueue(idx).path = path
        ulqueue(idx).desc = desc
        chkulq
    End If
End Sub

Function after (ByVal stg As String, ByVal before As String) As String
' returns the portion of string after passed portion

    Dim pos As Integer
    pos = InStr(stg, before)
    If pos > 0 Then
        stg = Mid$(stg, pos + Len(before))
    Else
        stg = ""
    End If
    after = Trim$(stg)
End Function

Sub chkulq ()
' check upload queue: if not empty, and not busy, upload a file

    Dim dpknam As String
    Static once As Integer

    Do
        If ulqrid <> -1 Or UBound(ulqueue) = 0 Or once Then
            Exit Sub
        End If
        If canreadfm(ulqueue(0).path) Then
            Exit Do
        Else
            once = True
            junk = gmsgbox("Could not open " & UCase$(ulqueue(0).path) & " for upload.", MB_ICONEXCLAMATION, "Upload a File")
            rmvulq 0
            once = False
        End If
    Loop
    once = True
    If connect("default") Then
        dpknam = ulqueue(0).libname & " " & ulqueue(0).fname
        ulqrid = wrtdpk("sauf:upload " & dpknam, STGLEN, ulqueue(0).path, libmdi!ulqcbk)
        dspprg ulqrid
    Else
        ReDim ulqueue(0)
    End If
    once = False
End Sub

Function element (index As Integer, listitem As String, tabchr As String) As String
    Dim litem As String
    Dim i As Integer
    Dim fin As Integer

    i = index
    litem = listitem
    Do
        fin = InStr(litem, tabchr)
        If fin > 0 Then
            litem = Right$(litem, Len(litem) - fin - (Len(tabchr) - 1))
            If i = 0 Then
                element = Left$(litem, fin - 1)
                Exit Function
            End If
        Else
            element = litem
            Exit Function
        End If
        i = i - 1
    Loop
End Function

Function filnotin (coslib As String, lb As Control, libname As String) As Integer
' return whether to include in list, and set display libname

    Dim i As Integer

    coslib = libname
    If itemcnt(lb.Tag) > 1 Then
        filnotin = True
        For i = 0 To itemcnt(lb.Tag) - 1
            If libisin(libname, itemidx(lb.Tag, i)) Then
                filnotin = False
                coslib = itemidx(lb.Tag, i)
                Exit For
            End If
        Next i
    Else
        If lb.Tag <> "*" Then
            coslib = lb.Tag
        End If
        filnotin = False
    End If
End Function

Function flinfo (ByVal libname As String) As Integer
' bring up library information on a specified library
' returns false if no such lib

    Dim libdets As libdetails
    Dim n As Single, i As Integer, ld As String

    If sreadpk("(c=p)sau:linfo " & libname, Len(libdets), libdets) = 0 Then
        If Not connected() Then
            If connect("default") Then
                flinfo = flinfo(libname)
                Exit Function
            End If
        End If
        flinfo = False
        Exit Function
    End If
    If libdets.totfiles = 0 And libdets.addtoday = 0 And libdets.addweek = 0 Then
        libinfo!Label14.Visible = False
        libinfo!Label11.Visible = False
        libinfo!Label12.Visible = False
        libinfo!Label15.Visible = False
        libinfo!Label7.Visible = False
        libinfo!Label16.Visible = False
        n = libinfo!Frame3D2.Width / 2
        libinfo!Label8.Left = n - libinfo!Label8.Width
        libinfo!Label2.Left = n + 75
        libinfo!Label1.Left = n - libinfo!Label1.Width
        libinfo!Label4.Left = n + 75
        libinfo!Label9.Left = n - libinfo!Label9.Width
        libinfo!Label3.Left = n + 75
    Else
        libinfo!Label14 = Trim$(Str$(libdets.totfiles))
        libinfo!Label11 = Trim$(Str$(libdets.addtoday))
        libinfo!Label12 = Trim$(Str$(libdets.addweek))
    End If
    libinfo!Label2 = Trim$(Str$(libdets.maxfil))
    libinfo!Label4 = Trim$(Str$(libdets.maxbyt)) & " bytes"
    libinfo!Label3 = Trim$(Str$(libdets.maxbup)) & " bytes"
    libinfo.Caption = "The " & UCase$(libname) & " Library"
    libinfo!Frame3D1.Caption = itemidx(libdets.data, 0)
    ld = cvt4dsp(itemidx(libdets.data, 1), False)
    While Left$(ld, 2) = Chr$(13) & Chr$(10)
        ld = Mid$(ld, 3)
    Wend
    libinfo!Label5 = ld
    libinfo!Label6 = itemidx(libdets.data, 2)
    If libinfo!Label5 = "" Then
        libinfo!Frame3D2.Caption = libinfo!Frame3D1.Caption
    Else
        libinfo!Frame3D1.Visible = True
        libinfo!Frame3D1.Top = libinfo!Frame3D2.Top
        libinfo!Frame3D2.Top = libinfo!Frame3D1.Top + libinfo!Frame3D1.Height + DIFFDIST
    End If
    libinfo!Command1.Top = libinfo!Frame3D2.Top + libinfo!Frame3D2.Height + DIFFDIST
    n = libinfo.ScaleHeight - (libinfo!Command1.Top + libinfo!Command1.Height + DIFFDIST)
    If n < libinfo.Height Then
        libinfo.Height = libinfo.Height - n
    End If
    repoctr libinfo, libmdi
    libinfo.Show 1
    flinfo = True
End Function

Function libisin (libname As String, libset As String)
' is library joined to passed library?

    Dim i As Integer, j As Integer

    If sameas(libname, libset) Then
        libisin = True
        Exit Function
    End If
    libisin = False
    For i = 0 To UBound(joinings) - 1
        If sameas(libname, itemidx(joinings(i), 0)) Then
            For j = 1 To itemcnt(joinings(i)) - 1
                If sameas(libset, itemidx(joinings(i), j)) Then
                    libisin = True
                    Exit For
                End If
            Next j
            Exit Function
        End If
    Next i
End Function

Sub loadsearch (ByVal tag1 As String, ByVal tag2 As String, ByVal tag3 As String)
' mechanism to load the searcher form

    nolbmore = True
    Load searcher
    searcher.Tag = tag1
    searcher!SSList1.Tag = tag2
    searcher!Label1(0).Tag = tag3
    nolbmore = False
End Sub

Sub maintain (ByVal libname As String, ByVal opt1 As String, ByVal opt2 As String)
' maintain library
' libname: library to maintain, or "" for all
' opt1: "0" = files not logged in, "1" = files missing
' opt2: "0" = do nothing, "1" = do something (unapprove),
'       "2" = like "1", but approve files if logging in

    Dim liblen As Integer

    If Len(libname) > 0 Then
        liblen = STGLEN
    Else
        liblen = 0
    End If
    If sameas(opt1, "0") Then
        results.Caption = "Searching for Files Not Logged In"
    Else
        results.Caption = "Searching for Missing Files"
    End If
    results!cancel.Tag = Str$(wrtdpk("sau:maint " & opt1 & " " & opt2, liblen, libname, results!CallBack1))
    results.Width = 7500
    repoctr results, libmdi
    results.Show 1
End Sub

Sub openslist (ByVal fname As String)

    Dim numerr As Integer, rec As savdatrec, i As Integer
    Dim s As String, item As String, flen As Long

    On Error Resume Next
    savf = FreeFile
    SetAttr fname, 0
    Open fname For Random Access Read As #savf Len = SAVRECSZ
    numerr = Err
    flen = LOF(savf)
    On Error GoTo 0
    If numerr <> 0 Or flen = 0& Then
        Close #savf
        If Not sameas(fname, "$") Then
            junk = gmsgbox("Sorry, cannot open " & UCase$(fname), MB_ICONEXCLAMATION, "Open File Listing")
        End If
        Exit Sub
    End If
    libmdi.Enabled = False
    libmdi.MousePointer = HOURGLASS
    On Error GoTo hdrerr
    Get #savf, 1, savhdr
    loadsearch Trim$(savhdr.sftag), Trim$(savhdr.sstag), Str$(savhdr.sltag)
    searcher!SSList2.Tag = fname
    If Not sameas(fname, "$") Then
        searcher!Command4.Visible = False
    Else
        If svsav Then
            searcher.WindowState = svs
            If svs = 0 Then
                searcher.Top = svt
                searcher.Left = svl
                searcher.Height = svh
                searcher.Width = svw
            End If
        End If
    End If
    svsav = False
    retab searcher
    setbut searcher
    On Error GoTo mainerr
    If savhdr.nrecs < 200 Then
        For i = 2 To savhdr.nrecs
            Get #savf, i, rec
            item = svitem(rec)
            searcher!SSList2.AddItem item
        Next i
        Close #savf
        sview = False
    Else
        sview = True
        lbinit searcher!SSList1, searcher!SSList2, 100, searcher!CallBack1, " ", "", False
        lbmore LBOXFORE
    End If
    synclists searcher
    libmdi.Enabled = True
    libmdi.MousePointer = DEFAULT
    Exit Sub
hdrerr:
    junk = gmsgbox(fname & " is not in the correct file format.", MB_ICONEXCLAMATION, "Open File List")
    If isloaded(searcher) Then
        Unload searcher
    End If
mainerr:
    Close #savf
    If isloaded(searcher) Then
        synclists searcher
    End If
    libmdi.Enabled = True
    libmdi.MousePointer = DEFAULT
    Exit Sub

End Sub

Sub readjoins ()
' cause join history to be read in

    If jrid <> -1 Or Not connected() Then
        Exit Sub
    End If
    ReDim rjoins(0)
    jrid = rgtdpk(wtspace("sau:ljoinings "), wtspace("ljoinings "), 32000, libmdi!CallBack1)
End Sub

Sub retab (frm As Form)
' repostitions labels on searcher form

    Dim opts As Integer
    Dim i As Integer
    Dim curtab As Integer
    Dim ctr As Integer
    Dim boxright As Single, diff As Single
    Dim retstg As String

    retstg = itemidx(frm.Tag, 0)
    If Len(retstg) > 0 Then
        If sameas(retstg, "fso ") Then
            libmdi!mnushdr.Enabled = False
        Else
            libmdi!mnushdr.Enabled = True
        End If
    End If
    opts = ival(frm!Label1(0).Tag)
    curtab = 0
    ctr = 0
    retstg = ""
    For i = 1 To NUMIIDXS
        Unload frm!Label1(i)
        Load frm!Label1(i)
    Next i
    For i = 0 To NUMIIDXS - 1
        If (opts And 2 ^ i) Then
            frm!Label1(ctr + 1).Left = curtab
            frm!Label1(ctr + 1).Width = frm.TextWidth(tabstg(i))
            frm!Label1(ctr + 1) = dblamp(tabstg(i))
            frm!Label1(ctr + 1).Visible = True
            curtab = curtab + tabwid(i)
            frm!SSList1.TabPos(ctr) = curtab
            frm!SSList1.TabType(ctr) = 1
            ctr = ctr + 1
        End If
    Next i
    For i = NUMIIDXS To 15
        frm!SSList1.TabPos(i) = frm!SSList1.TabPos(i - 1)
        frm!SSList1.TabType(i) = 1
    Next i
End Sub

Sub rmvulq (ByVal idx As Integer)
' remove an upload from the queue

    Dim i As Integer

    If i >= 0 And UBound(ulqueue) > 0 Then
        For i = idx To UBound(ulqueue) - 2
            ulqueue(i) = ulqueue(i + 1)
        Next i
        ReDim Preserve ulqueue(UBound(ulqueue) - 1)
    End If
End Sub

Sub selcbk (evtstg As String, ByVal restrictions As String, lbox As Control, rid As Integer, frm As Form, but As Control)

    Dim llinf As llistinf           ' instance of Type llistinf
    Dim dstr As String, desc As String, libname  As String
    Dim i As Integer

    Select Case evtstg
    Case "Dynapak received", "Dynapak available"
        junk = cbkrsp(Len(llinf), llinf)
        libname = after(namdpk(), "llist ")
        If llinf.flags And LLISDOS Then
            dstr = "DOS"
        Else
            dstr = ""
        End If
        Select Case itemidx(restrictions, 0)
        Case "nodcd" ' no DOS-Only or Lib on CD
            If llinf.flags And LLISDOS Then
                Exit Sub
            End If
            If llinf.flags And LLISACD Then
                Exit Sub
            End If
        Case "nodos" ' doesn't show DOS-Only Libraries
            If llinf.flags And LLISDOS Then
                Exit Sub
            End If
        Case "upload" ' shows only uploadable Libraries
            If (llinf.flags And LLISUPL) = False Then
                Exit Sub
            End If
        Case "exclude" ' excludes named lib and libs not a libop of
            For i = 1 To itemcnt(restrictions) - 1
                If (llinf.flags And LLISLOP) = 0 Or sameas(libname, itemidx(restrictions, i)) Then
                    Exit Sub
                End If
            Next i
        End Select
        i = InStr(llinf.desc, Chr$(0))
        If InStr(llinf.desc, Chr$(0)) > 0 Then
            desc = itemidxd(llinf.desc, 0, Chr$(0))
        Else
            desc = Trim$(llinf.desc)
        End If
        lbox.AddItem UCase$(after(namdpk(), "llist ")) & Chr$(9) & desc & Chr$(9) & dstr
        If (lbox.ListCount Mod MORESUM) = 0 Then
            If Not but.Visible Then
                but.Visible = True
                frm.Height = frm.Height + (but.Top + but.Height + DIFFDIST - frm.ScaleHeight)
            End If
            but.Tag = namdpk()
            abodpk rid
            but.Enabled = True
        End If
    Case "Request aborted"
        rid = -1
    Case "No more dynapaks"
        rid = -1
        If frm Is sellib Then
            If sellib!SSList1.ListCount = 0 Then
                If (Len(sellib!Label1.Tag) > 0) And connected() Then
                    freeup
                    junk = gmsgbox(sellib!Label1.Tag, MB_ICONEXCLAMATION, sellib.Caption)
                    Unload sellib
                End If
            End If
        End If
    End Select
End Sub

Sub selmore (but As Control, lbox As Control, cbk As Control, reqid As Integer, ByVal xfirst As Integer)
' select to list more Libraries
' but: selection button control
' lbox: listbox involved
' cbk: callback involved
' reqid: requiest id (passed by reference) on source form
' xfirst: whether to exempt the first entry from being deleted
'         if the listbox gets >= MORELIST elements

    Dim ti As Integer, li As Integer, i As Integer

    If but.Enabled And but.Visible Then
        but.Enabled = False
        If lbox.ListCount >= MORELIST Then
            li = lbox.ListIndex - MORESUM
            If li < 0 Then
                li = 0
            End If
            ti = lbox.TopIndex - MORESUM
            If ti < 0 Then
                ti = 0
            End If
            winrefresh lbox.hWnd, False
            If xfirst Then
                For i = 1 To MORESUM
                    lbox.RemoveItem 1
                Next i
            Else
                For i = 1 To MORESUM
                    lbox.RemoveItem 0
                Next i
            End If
            lbox.ListIndex = li
            lbox.TopIndex = ti
            winrefresh lbox.hWnd, True
        End If
        If reqid = -1 Then
            reqid = rgtdpk(wtspace("(c=p)" & but.Tag), wtspace("llist "), -1, cbk)
        End If
    End If
End Sub

Sub setbut (frm As Form)
' set buttons on search form dim or otherwise depending on listbox contents

    If frm!SSList1.ListIndex <> -1 Then
        If Not isblank(frm!SSList1.List(0)) Then
            frm!Command6.Enabled = True
            frm!Command2.Enabled = True
            Exit Sub
        End If
    End If
    frm!Command2.Enabled = False
    frm!Command6.Enabled = False
End Sub

Function srchrsz (frm As Form) As Integer
' resize search form

    Dim maxwid As Single

    srchrsz = False
    If frm.WindowState = 0 And frm.ScaleHeight < 3000 Then
        frm.Height = frm.Height + (3000 - frm.ScaleHeight)
        Exit Function
    End If
    maxwid = 2 * DIFFDIST + 4 * SAMEDIST + frm!Command2.Width + frm!Command6.Width + frm!Command3.Width + frm!Command4.Width + frm!Command1.Width
    If frm.ScaleWidth < maxwid Then
        If frm.WindowState = 2 Then
            frm.WindowState = 0
            Exit Function
        End If
        If frm.WindowState = 0 Then
            frm.Width = frm.Width + (maxwid - frm.ScaleWidth)
            Exit Function
        End If
    End If
    applyoff frm!Picture1, frm!SSList1, LEFT2LEFT, -3 * Screen.TwipsPerPixelX
    applyoff frm!SSList1, Nothing, RIGHT2RIGHT, DIFFDIST
    applyoff frm!Picture1, frm!SSList1, RIGHT2RIGHT, 0
    applyoff frm!SSList1, frm!Picture1, TOP2BOTTOM, 0
    applyoff frm!Command6, frm!SSList1, LEFT2LEFT, 0
    applyoff frm!Command6, Nothing, TOP2BOTTOM, DIFFDIST + frm!Command2.Height
    applyoff frm!Command2, Nothing, TOP2BOTTOM, DIFFDIST + frm!Command2.Height
    applyoff frm!Command3, Nothing, TOP2BOTTOM, DIFFDIST + frm!Command2.Height
    applyoff frm!Command4, Nothing, TOP2BOTTOM, DIFFDIST + frm!Command2.Height
    applyoff frm!Command1, Nothing, TOP2BOTTOM, DIFFDIST + frm!Command2.Height
    applyoff frm!SSList1, frm!Command2, BOTTOM2TOP, DIFFDIST
    applyoff frm!Command1, frm!SSList1, LEFT2RIGHT, frm!Command1.Width
    applyoff frm!Command2, frm!Command6, LEFT2RIGHT, -SAMEDIST
    applyoff frm!Command3, frm!Command2, LEFT2RIGHT, -SAMEDIST
    applyoff frm!Command4, frm!Command1, LEFT2LEFT, frm!Command4.Width + SAMEDIST
    applyoff frm!SSList2, frm!SSList1, TOP2TOP, 0
    applyoff frm!SSList2, frm!SSList1, BOTTOM2BOTTOM, 0
    srchrsz = True
End Function

Function strsrep (ByVal item As String, ByVal o As String, ByVal n As String)
' replace a string in a string with a string

    Dim origlen As Integer, oldi As Integer, i As Integer

    origlen = Len(item)
    i = 0
    Do
        oldi = i
        i = InStr(item, o)
        If i > 0 Then
            item = Left$(item, i - 1) & n & Mid$(item, i + Len(o))
        End If
    Loop While i > 0 And i > oldi And Len(item) < 2 * origlen
    strsrep = item
End Function

Function svitem (rec As savdatrec) As String
' return formatted string for record

    Dim item As String

    item = Trim$(rec.filname)
    item = item & Chr$(9) & Trim$(rec.libname)
    item = item & Chr$(9) & Trim$(Str$(rec.cost))
    item = item & Chr$(9) & Format$(rec.size, "#,##0")
    item = item & Chr$(9) & Trim$(Str$(rec.fdate))
    item = item & Chr$(9) & Trim$(Str$(rec.udate))
    item = item & Chr$(9) & Trim$(Str$(rec.numdls))
    item = item & Chr$(9) & Trim$(rec.coslib)
    item = item & Chr$(9) & Trim$(rec.desc)
    svitem = item
End Function

Sub svlstadd (ByVal info As String)
' create/add elements to offline list

    Dim i As Integer
    Dim rec As savdatrec

    If Not connected() Or svlstels < 0 Then
        Exit Sub
    End If
    If svlstels = 0 Then
        On Error GoTo errhdl2
        svlstfil = FreeFile
        svlstchp = 0
        On Error Resume Next
        SetAttr SAVLSTMP, 0
        Kill SAVLSTMP
        On Error GoTo errhdl2
        Open SAVLSTMP For Random Access Write As #svlstfil Len = SAVRECSZ
        On Error GoTo errhdl
        savhdr.version = 0
        savhdr.nrecs = 1
        savhdr.sftag = searcher.Tag
        If itemcnt(searcher!SSList1.Tag) > 1 Then
            savhdr.sstag = "*"
        Else
            savhdr.sstag = searcher!SSList1.Tag
        End If
        savhdr.sltag = searcher!Label1(0).Tag
        Put #svlstfil, 1, savhdr
        Close #svlstfil
        SetAttr SAVLSTMP, ATTR_HIDDEN
        On Error GoTo errhdl2
        svlstfil = FreeFile
        Open SAVLSTMP For Random Access Write As #svlstfil Len = SAVRECSZ
    End If
    If svlstchp > 0 Then
        svlstchp = svlstchp - 1
    Else
        On Error GoTo 0
        'On Error GoTo errhdl
        rec.filname = itemidx(info, 0)
        rec.libname = itemidx(info, 1)
        rec.cost = lval(itemidx(info, 2))
        rec.size = lval(Format$(itemidx(info, 3), ""))
        rec.fdate = Val(itemidx(info, 4))
        rec.udate = Val(itemidx(info, 5))
        rec.numdls = lval(itemidx(info, 6))
        rec.coslib = itemidx(info, 7)
        rec.desc = Trim$(itemidx(info, 8))
        i = InStr(rec.desc, Chr$(0))
        If i > 0 Then
            rec.desc = Left$(rec.desc, i)
        End If
        savhdr.nrecs = savhdr.nrecs + 1
        Put #svlstfil, savhdr.nrecs, rec
        svlstels = svlstels + 1
        svlstnxt = lbkey(False)
    End If
    On Error GoTo 0
    Exit Sub
errhdl:
    Close #svlstfil
errhdl2:
    svlstels = -1
    searcher!Command4.Enabled = False
    On Error GoTo 0
    Exit Sub
End Sub

Sub svlstend ()
' end keeping of saved list

    If svlstels > 0 Then
        Close #svlstfil
    End If
    On Error Resume Next
    SetAttr SAVLSTMP, 0
    Kill SAVLSTMP
    On Error GoTo 0
    svlstels = 0
End Sub

Function syncitem (frm As Form, ByVal key As Integer, ByVal ct As Integer) As String

    Dim bld As String

    bld = ""
    If key And (2 ^ DETINAM) Then
        bld = bld + itemidx(frm!SSList2.List(ct), 0) + Chr$(9)
    End If
    If key And (2 ^ DETILIB) Then
        bld = bld + itemidx(frm!SSList2.List(ct), 7) + Chr$(9)
    End If
    If key And (2 ^ DETIPOP) Then
        bld = bld + itemidx(frm!SSList2.List(ct), 6) + Chr$(9)
    End If
    If key And (2 ^ DETIADD) Then
        bld = bld + Format$(itemidx(frm!SSList2.List(ct), 5), DATEFMT) + Chr$(9)
    End If
    If key And (2 ^ DETISIZ) Then
        bld = bld + itemidx(frm!SSList2.List(ct), 3) + Chr$(9)
    End If
    If key And (2 ^ DETIDAT) Then
        bld = bld + Format$(itemidx(frm!SSList2.List(ct), 4), DATEFMT) + Chr$(9)
    End If
    If key And (2 ^ DETICST) Then
        bld = bld + itemidx(frm!SSList2.List(ct), 2) + Chr$(9)
    End If
    If key And (2 ^ DETIDSC) Then
        bld = bld + itemidx(frm!SSList2.List(ct), 8) + Chr$(9)
    End If
    If Right$(bld, 1) = Chr$(9) Then
        bld = Left$(bld, Len(bld) - 1)
    End If
    syncitem = bld
End Function

Sub synclists (frm As Form)

    Dim savti As Integer, savli As Integer

    savti = frm!SSList1.TopIndex
    savli = frm!SSList1.ListIndex
    winrefresh frm!SSList1.hWnd, False
    frm!SSList1.Clear
    Do While frm!SSList2.ListCount > frm!SSList1.ListCount
        frm!SSList1.AddItem xlate(ival(frm!Label1(0).Tag), frm!SSList2.List(frm!SSList1.ListCount))
    Loop
    If savti > -1 And savti < frm!SSList1.ListCount Then
        frm!SSList1.TopIndex = savti
    End If
    If savli > -1 And savli < frm!SSList1.ListCount Then
        frm!SSList1.ListIndex = savli
    ElseIf frm!SSList1.ListCount > 0 Then
        frm!SSList1.ListIndex = 0
    End If
    winrefresh frm!SSList1.hWnd, True
End Sub

Sub translate (ByVal f As String, ByVal t As String, ByVal flags As Integer)
' translate a .GFL format file into .TXT using the filter

    Dim ff As Integer, tf As Integer, i As Integer
    Dim hdr As savdathdr, rec As savdatrec
    Dim item As String, ncols As Integer, pos() As Integer
    Dim info As String, infloop As Integer

    ff = FreeFile
    On Error GoTo xlaterr
    Open f For Random Access Read As #ff Len = SAVRECSZ
    Get #ff, 1, hdr
    Get #ff, hdr.nrecs + 1, rec
    tf = FreeFile
    Open t For Output As #tf
    item = ""
    ncols = 0
    ReDim pos(NUMIIDXS)
    For i = 0 To NUMIIDXS - 1
        If (flags And 2 ^ i) Then
            item = item & Left$(tabstg(i) & Space$(40), tabcwid(i)) & " "
            pos(ncols) = tabcwid(i)
            ncols = ncols + 1
        End If
    Next i
    Print #tf, Trim$(item)
    ncols = 0
    item = ""
    For i = 0 To NUMIIDXS - 1
        If (flags And 2 ^ i) Then
            item = item & String$(pos(ncols), "=") & " "
            ncols = ncols + 1
        End If
    Next i
    Print #tf, Trim$(item)
    For infloop = 2 To hdr.nrecs
        Get #ff, infloop, rec
        info = xlate(flags, svitem(rec))
        ncols = 0
        item = ""
        For i = 0 To NUMIIDXS - 1
            If (flags And 2 ^ i) Then
                item = item & Left$(itemidx(info, ncols) & Space$(40), pos(ncols)) & " "
                ncols = ncols + 1
            End If
        Next i
        Print #tf, Trim$(item)
    Next infloop
    Close #ff
    Close #tf
    Exit Sub
xlaterr:
    Close #ff
    Close #tf
    junk = gmsgbox("Couldn't translate list into " & t, MB_ICONEXCLAMATION, Error$)
    Exit Sub
End Sub

Sub ulfile (ByVal libname As String, ByVal isdos As Integer)
' upload a file

    Dim path As String, s As String
    Dim numfiles As Integer, i As Integer

    path = ulpath()
    If path <> "" Then
        editul!Label19 = dblamp(libname)
        If InStr(path, " ") = 0 Then ' one file
            If isdos Then
                addulq libname, fnpart(path), path, ""
            Else
                editul!Label17 = dblamp(UCase$(path))
                editul!Text1 = ""
                editul.Show 1
                If sameas(editul.Tag, "ok") Then
                    addulq libname, fnpart(path), path, editul!Text1
                End If
                Unload editul
            End If
        Else
            numfiles = itemcntd(path, " ") - 1
            s = itemidxd(path, 0, " ")
            If Right$(s, 1) <> "\" Then
                s = s & "\"
            End If
            For i = 0 To numfiles - 1
                If isdos Then
                    addulq libname, itemidxd(path, i + 1, " "), s & itemidxd(path, i + 1, " "), ""
                Else
                    If Not sameas(editul.Tag, "okall") Then
                        editul.Tag = ""
                        editul!Command1.Left = editul!Text1.Left + editul!Text1.Width / 2 - editul!Command1.Width / 2
                        editul!okbut.Left = editul!Command1.Left - SAMEDIST - editul!okbut.Width
                        editul!Command2.Left = editul!Command1.Left + SAMEDIST + editul!Command1.Width
                        editul!Command2.Visible = True
                        editul!Label17 = dblamp(UCase$(s & itemidxd(path, i + 1, " ")))
                        editul.Show 1
                    End If
                    If sameas(editul.Tag, "ok") Or sameas(editul.Tag, "okall") Then
                        addulq libname, itemidxd(path, i + 1, " "), s & itemidxd(path, i + 1, " "), editul!Text1
                        editul!Text1.SelStart = 0
                        editul!Text1.SelLength = Len(editul!Text1)
                    End If
                End If
            Next i
            If Not isdos Then
                Unload editul
            End If
        End If
    End If
End Sub

Function ulpath () As String
' get path for file to upload

    Dim path As String
    Dim i As Integer

    ulpath = ""
    fdlgxchg.CancelError = False
    fdlgxchg.DefaultExt = ""
    fdlgxchg.DialogTitle = "Upload a File"
    fdlgxchg.filename = "*.*"
    fdlgxchg.Filter = "All Files (*.*)|*.*"
    fdlgxchg.filterindex = 0
    fdlgxchg.flags = OFN_PATHMUSTEXIST + OFN_SHOWHELP + OFN_ALLOWMULTISELECT
    fdlgxchg.MaxFileSize = 4096
    filedlg fdlgupld, "upload"
    If Len(fdlgxchg.filename) > 0 And Not usrcancel Then
        path = fdlgxchg.filename
        If InStr(path, " ") = 0 Then ' one file
            i = Len(path) - Len(fdlgxchg.Filetitle)
            If i > 0 Then
                ulpath = path
            End If
        Else ' multi-file
            ulpath = path
        End If
    End If
End Function

Sub updsellib (ByVal libname As String, ByVal shortdesc As String)
' updates select-lib list with new short description of library

    Dim i As Integer

    If isloaded(sellib) Then
        For i = 0 To sellib!SSList1.ListCount - 1
            If sameas(libname, itemidx(sellib!SSList1.List(i), 0)) Then
               sellib!SSList1.List(i) = itemidx(sellib!SSList1.List(i), 0) & Chr$(9) & shortdesc
               Exit Sub
            End If
        Next i
    End If
End Sub

Function xlate (ByVal key As Integer, ByVal item As String) As String
' come up with line to display to user

    Dim bld As String, s As String

    bld = ""
    If key And (2 ^ DETINAM) Then
        bld = bld & itemidx(item, 0) & Chr$(9)
    End If
    If key And (2 ^ DETILIB) Then
        bld = bld & itemidx(item, 7) & Chr$(9) ' cosmetic lib
    End If
    If key And (2 ^ DETIPOP) Then
        bld = bld & itemidx(item, 6) & Chr$(9)
    End If
    If key And (2 ^ DETIADD) Then
        s = itemidx(item, 5)
        If Trim$(s) = "0" Then
            bld = bld & "Unapp'd" & Chr$(9)
        Else
            bld = bld & Format$(Int(Val(s)), DATEFMT) & Chr$(9)
        End If
    End If
    If key And (2 ^ DETISIZ) Then
        bld = bld & itemidx(item, 3) & Chr$(9)
    End If
    If key And (2 ^ DETIDAT) Then
        bld = bld & Format$(Val(itemidx(item, 4)), DATEFMT) & Chr$(9)
    End If
    If key And (2 ^ DETICST) Then
        bld = bld & itemidx(item, 2) & Chr$(9)
    End If
    If key And (2 ^ DETIDSC) Then
        bld = bld & itemidx(item, 8) & Chr$(9)
    End If
    If Right$(bld, 1) = Chr$(9) Then
        bld = Left$(bld, Len(bld) - 1)
    End If
    xlate = bld
End Function

