VERSION 2.00
Begin Form viewtext
   BackColor       =   &H00C0C0C0&
   Caption         =   "View Text File Contents"
   ClientHeight    =   3840
   ClientLeft      =   1230
   ClientTop       =   1995
   ClientWidth     =   8520
   Height          =   4275
   HelpContextID   =   10
   Icon            =   0
   Left            =   1155
   MinButton       =   0   'False
   ScaleHeight     =   3840
   ScaleWidth      =   8520
   Top             =   1635
   Width           =   8670
   Begin CommandButton Command1 
      Cancel          =   -1  'True
      Caption         =   "Close"
      Default         =   -1  'True
      Height          =   360
      Left            =   3780
      TabIndex        =   3
      Top             =   3360
      Width           =   960
   End
   Begin VScrollBar VScroll1 
      Height          =   2640
      LargeChange     =   15
      Left            =   8160
      Max             =   0
      TabIndex        =   2
      TabStop         =   0   'False
      Top             =   360
      Visible         =   0   'False
      Width           =   240
   End
   Begin CallBack CallBack1 
      Left            =   1740
      Top             =   3300
   End
   Begin TextBox Text1 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Galacticomm"
      FontSize        =   9
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2895
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   1  'Horizontal
      TabIndex        =   0
      Top             =   360
      Width           =   8055
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Contents of "
      Height          =   240
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   7065
   End
End
'*******************************************************************************
'*                                                                             *
'*   FLVTEXT.FRM                                                               *
'*                                                                             *
'*   Copyright (c) 1994-1997 Galacticomm, Inc.           All rights reserved.  *
'*                                                                             *
'*   View Contents of Text File Form                                           *
'*                                                                             *
'*                                                  - D. Pitchford 9/8/94      *
'*                                                                             *
'*******************************************************************************

Option Explicit

Const TBLEN = 30000&        ' length allowed displayed in textbox at once.
                            '   must be divisible by three.
Const TOOLONGSTR = "<<< The text is too long to display until the file has been received completely. >>>"

Dim ltb As Long             ' length of data rcv by notification
Dim toolong As Integer      ' bool: is datalen > TBLEN
Dim caching As Integer      ' bool: in mode of paging thru a completely xferred file
Dim headblock As Integer    ' number of TBLEN/3 sized block at which the textbox starts
Dim scrolval As Integer     ' referent for vertical scroll bar
Dim scrolrec As Integer     ' prevents test for cache fills on scroll bar
Dim llno As Integer         ' number of lines in first of 3 blocks in TBLEN
Dim hlno As Integer         ' number of lines in last of the 3 blocks
Dim dragline As Integer     ' starting line number, when dragging

Sub CallBack1_CallBack (evtstg As String, reqid As Integer)
' the callback handler, to receive and display the file dpk

    Dim s As String                 ' util. string
    Dim F As Integer                ' file pointer
    Dim lfil As Long                ' length of file

    Select Case evtstg
    Case "Dynapak received"
        Text1.Tag = "-1"
        freeup
        DoEvents
        On Error GoTo filerr1
        F = FreeFile
        Open Tag For Input As F
        On Error GoTo filerr2
        lfil = LOF(F)
        If lfil > TBLEN Then
            toolong = True
            lfil = TBLEN
        Else
            toolong = False
        End If
        On Error GoTo eofchar
retry:
        s = Input$(lfil - 1, F)
        On Error Resume Next
        s = s & Input$(1, F)
        On Error GoTo filerr2
        Close F
        On Error GoTo 0
        If Right$(s, 1) = Chr$(13) Then
            s = s + Chr$(10)
        ElseIf Right$(s, 1) = Chr$(26) Then
            s = Left$(s, Len(s) - 1)
        End If
        pretext Text1.hWnd
        Text1.Text = s
        posttext
        Text1.Refresh
        rstnumln
        If toolong Then
            caching = True
            docache
        End If
        VScroll1.Tag = "1"
    Case "Notification"
        If ltb < TBLEN Then
            s = cbkrspv()
            If Len(s) > TBLEN - ltb Then
                s = Left$(s, TBLEN - ltb)
            End If
            If Left$(s, 1) = Chr$(10) Then
                s = Right$(s, Len(s) - 1)
            End If
            If Right$(s, 1) = Chr$(13) Then
                s = s & Chr$(10)
            End If
            ltb = ltb + Len(s)
            VScroll1.Max = VScroll1.Max + countlines(s)
            pretext Text1.hWnd
            Text1.Text = Text1.Text & s
            posttext
        ElseIf Not toolong Then
            pretext Text1.hWnd
            Text1.Text = Text1.Text & Chr$(13) & Chr$(10) & Chr$(13) & Chr$(10) & TOOLONGSTR
            posttext
            Text1.Refresh
            toolong = True
        End If
    Case "Offline read denied", "Request aborted"
        Text1.Tag = "-1"
        freeup
        Unload Me
    End Select
    Exit Sub
eofchar:
    If Err = 62 Then
        lfil = lfil - 1
        If lfil > 0 Then
            Seek F, 1
            Resume retry
        End If
    End If
filerr2:
    Close F
filerr1:
    On Error GoTo 0
    Unload Me
    Exit Sub
End Sub

Sub Command1_Click ()
' ok, cancel

    Unload Me
End Sub

Function countlines (txt As String) As Integer
' counts and returns the number of cr/lf pairs in passed text

    Dim txtpos As Integer           ' starting position (-2)
    Dim counter As Integer          ' ongoing count

    counter = 0
    txtpos = -1
    Do
        txtpos = InStr(txtpos + 2, txt, Chr$(13) & Chr$(10))
        counter = counter + 1
    Loop While txtpos > 0
    countlines = counter
End Function

Sub docache ()
' decides whether or not to read for the cache and which direction

    If caching And Len(Text1.Text) > TBLEN / 3 * 2 Then
        If VScroll1.Value < llno Then
            If headblock > 0 Then
                getmore False  ' scrolling "up"
            End If
        ElseIf VScroll1.Value > VScroll1.Max - hlno Then
            getmore True       ' scrolling "down"
        End If
    End If
End Sub

Sub Form_Load ()
' load procedure, sets default values.

    repoctr Me, fdetails
    VScroll1.Tag = "0"
    scrolval = 0
    ltb = 0&
    If Text1.FontName <> "Galacticomm" Then
        On Error Resume Next
        Text1.FontName = "Galacticomm"
        If Text1.FontName <> "Galacticomm" Then
            Text1.FontName = "Gcomm Tmode"
            If Text1.FontName <> "Gcomm Tmode" Then
                Text1.FontName = "Courier New"
            End If
        End If
        On Error GoTo 0
    End If
    Text1.FontSize = 7  ' ensure proper min. size, usu. 9ish
    junk = sndmsg(Text1.hWnd, EM_SETREADONLY, 1, 0&)
    headblock = 0
    toolong = False
    caching = False
    VScroll1.Visible = True
    Text1.Visible = True
    Text1.FontSize = 8.5
End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)
' aborts dpk request before closing if needed

    If (UnloadMode = 0 Or UnloadMode = 1) And ival(Text1.Tag) <> -1 Then
        abodpk ival(Text1.Tag)
    End If
End Sub

Sub Form_Resize ()
' resizes text box on form and places all controls properly.

    Dim n As Single                 ' util. Single

    Text1.Top = DIFFDIST
    Text1.Left = DIFFDIST
    VScroll1.Top = DIFFDIST
    n = ScaleHeight - Text1.Top - 2 * DIFFDIST - Command1.Height
    If n <= 0 Then
        n = 60
    End If
    Text1.Height = n
    If n > 240 Then             ' 240: height of Text1's horiz. scrollbar
        VScroll1.Height = n - 240
    Else
        VScroll1.Height = 60
    End If
    n = ScaleWidth - Text1.Left - VScroll1.Width - DIFFDIST - Screen.TwipsPerPixelX
    If n <= 0 Then
        n = 60
    End If
    Text1.Width = n
    VScroll1.Left = Text1.Left + Text1.Width - Screen.TwipsPerPixelX
    Command1.Left = Text1.Left + Text1.Width / 2 - Command1.Width / 2
    Command1.Top = Text1.Top + Text1.Height + DIFFDIST
End Sub

Sub getmore (bottom As Integer)
' add more text to the bottom or top of the textbox

    Dim F As Integer            ' file handler
    Dim newtext As String       ' new text just read
    Dim filen As Long           ' file length
    Dim seekpos As Long         ' seek position
    Dim readsize As Long        ' amount to read in
    Dim linum As Long           ' temp line number

    On Error GoTo errmore1
    F = FreeFile
    Open Tag For Input As F
    On Error GoTo errmore2
    readsize = TBLEN / 3
    linum = sndmsg(Text1.hWnd, EM_GETFIRSTVISIBLELINE, 0, 0&)
    If bottom Then
        filen = LOF(F)
        seekpos = readsize * (3 + headblock) + 1
        If (seekpos > filen) Then
            Close F
            On Error GoTo 0
            Exit Sub
        End If
        If filen - seekpos < readsize Then
            readsize = filen - seekpos
        End If
        junk = sndmsg(Text1.hWnd, 11, 0, 0&)    ' redraw off
        Text1.Text = Right$(Text1.Text, TBLEN / 3 * 2)
        If Left$(Text1.Text, 1) = Chr$(10) Then
            Text1.Text = Right$(Text1.Text, Len(Text1.Text) - 1)
        End If
        headblock = headblock + 1
        Seek F, seekpos
        newtext = Input$(readsize, F)
        If Right$(newtext, 1) = Chr$(13) Then
            newtext = newtext & Chr$(10)
        End If
        If Left$(newtext, 1) = Chr$(10) Then
            newtext = Right$(newtext, Len(newtext) - 1)
        End If
        Text1.Text = Text1.Text & newtext
        linum = linum - llno + 1
        rstnumln
    Else
        headblock = headblock - 1
        seekpos = readsize * headblock + 1
        junk = sndmsg(Text1.hWnd, 11, 0, 0&)    ' redraw off
        Seek F, seekpos
        Text1.Text = Input$(TBLEN, F)
        If Right$(Text1.Text, 1) = Chr$(13) Then
            Text1.Text = Text1.Text & Chr$(10)
        End If
        If Left$(Text1.Text, 1) = Chr$(10) Then
            Text1.Text = Right$(Text1.Text, Len(Text1.Text) - 1)
        End If
        rstnumln
        linum = linum + llno - 1
    End If
    If linum < 0 Then
        linum = 0
    ElseIf linum > VScroll1.Max Then
        linum = VScroll1.Max
    End If
    scrolval = 0
    junk = sndmsg(Text1.hWnd, 11, 1, 0&)    ' redraw on
    VScroll1.Value = linum
    Close F
quitmore:   ' quit normally, or after error
    On Error GoTo 0
    Exit Sub
errmore2:   ' error while file is open
    Close F
errmore1:   ' error while file is not open
    Unload Me
    Resume quitmore
End Sub

Sub rstnumln ()
' resets necessary statistics for scrolling and caching

    Dim numlines As Integer     ' # of lines in Text1

    If Len(Text1.Text) > TBLEN / 3 * 2 Then
        llno = countlines(Left$(Text1.Text, TBLEN / 3))
        hlno = countlines(Right$(Text1.Text, TBLEN / 3) & Chr$(10))
    End If
    numlines = countlines(Left$(Text1.Text, Len(Text1.Text)))
    If numlines > 0 Then
        VScroll1.Max = numlines
    End If
End Sub

Sub Text1_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
' store starting first line # to be restored after drag

    dragline = sndmsg(Text1.hWnd, EM_GETFIRSTVISIBLELINE, 0, 0&)
End Sub

Sub Text1_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
' restore first line # after drag

    Dim diff As Long

    diff = dragline - sndmsg(Text1.hWnd, EM_GETFIRSTVISIBLELINE, 0, 0&)
    scrolval = scrolval - diff
    scrolrec = True
    VScroll1.Value = scrolval
    scrolrec = False
End Sub

Sub VScroll1_Change ()
' scrolls the text box while looking out for the caching

    VScroll1_Scroll
    If Not scrolrec Then
        scrolrec = True
        docache
        Text1.SetFocus
        scrolrec = False
    End If
End Sub

Sub VScroll1_Scroll ()
' does the work of calling the API to scroll the text box

    Dim diff As Long            ' scroll difference

    diff = VScroll1.Value - scrolval
    scrolval = VScroll1.Value
    junk = sndmsg(Text1.hWnd, EM_LINESCROLL, 0, diff)
End Sub

