VERSION 2.00
Begin Form fxvform
   BackColor       =   &H00C0C0C0&
   Caption         =   "Fax Viewer"
   ClientHeight    =   6225
   ClientLeft      =   7290
   ClientTop       =   3045
   ClientWidth     =   5355
   Height          =   6915
   Icon            =   FAXVIEW.FRX:0000
   Left            =   7230
   LinkTopic       =   "Form1"
   ScaleHeight     =   6225
   ScaleWidth      =   5355
   Top             =   2415
   Width           =   5475
   Begin PictureBox faxholder
      ClipControls    =   0   'False
      Height          =   5000
      Left            =   0
      ScaleHeight     =   4965
      ScaleWidth      =   5025
      TabIndex        =   5
      Top             =   0
      Width           =   5055
      Begin PictureBox fax
         AutoRedraw      =   -1  'True
         BorderStyle     =   0  'None
         ClipControls    =   0   'False
         Height          =   5000
         Left            =   0
         ScaleHeight     =   4995
         ScaleWidth      =   5025
         TabIndex        =   6
         Top             =   0
         Width           =   5025
      End
   End
   Begin Timer fxtimer
      Enabled         =   0   'False
      Interval        =   100
      Left            =   60
      Top             =   5700
   End
   Begin HScrollBar fxhscroll
      Height          =   315
      Left            =   0
      TabIndex        =   2
      Top             =   4980
      Visible         =   0   'False
      Width           =   5055
   End
   Begin VScrollBar fxvscroll
      Height          =   5000
      Left            =   5055
      TabIndex        =   3
      Top             =   0
      Visible         =   0   'False
      Width           =   315
   End
   Begin SSPanel panel2
      Alignment       =   6  'Center - TOP
      BevelOuter      =   0  'None
      BorderWidth     =   0
      FloodShowPct    =   0   'False
      FloodType       =   1  'Left To Right
      ForeColor       =   &H00000000&
      Height          =   860
      Left            =   540
      TabIndex        =   4
      Top             =   5340
      Width           =   4335
      Begin SSPanel gauge
         BackColor       =   &H00808080&
         BevelOuter      =   1  'Inset
         FloodType       =   1  'Left To Right
         ForeColor       =   &H00FFFFFF&
         Height          =   300
         Left            =   90
         TabIndex        =   7
         Top             =   480
         Visible         =   0   'False
         Width           =   4150
      End
      Begin CommandButton faxnext
         Caption         =   "&Next  >>"
         Enabled         =   0   'False
         Height          =   360
         Left            =   2220
         TabIndex        =   1
         Top             =   250
         Width           =   960
      End
      Begin CommandButton faxback
         Caption         =   "<<  &Back"
         Enabled         =   0   'False
         Height          =   360
         Left            =   1140
         TabIndex        =   0
         Top             =   250
         Width           =   960
      End
   End
   Begin Menu mfile
      Caption         =   "&File"
      Begin Menu pfmenu
         Caption         =   "&Print fax page..."
         Shortcut        =   ^P
      End
      Begin Menu sep3
         Caption         =   "-"
      End
      Begin Menu efmenu
         Caption         =   "E&xit"
      End
   End
   Begin Menu mview
      Caption         =   "&View"
      Begin Menu bfmenu
         Caption         =   "Snap to &Window"
         Checked         =   -1  'True
      End
      Begin Menu mfmenu
         Caption         =   "F&ull Size"
      End
   End
   Begin Menu mhelp
      Caption         =   "&Help"
      HelpContextID   =   3
   End
End
'***************************************************************************
'*                                                                         *
'*   FAXVIEW.FRM                                                           *
'*                                                                         *
'*   Copyright (c) 1995-1996 Galacticomm, Inc.    All Rights Reserved.     *
'*                                                                         *
'*   This is the C/S fax application fax viewer form used to view and      *
'*   and print fax images                                                  *
'*                                                                         *
'*                                                   - J. Delekto 12/11/95 *
'*                                                                         *
'***************************************************************************

Option Explicit

Declare Function MoveTo Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer) As Long
Declare Function LineTo Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer) As Integer

Const FXVWFRMID = "faxviewform"

Const LOADING = &H1         ' Currently loading a fax page
Const PAINTING = &H2        ' Currently painting the image
Const MODING = &H4          ' Currently changing video modes

Const DOLOAD = &H1          ' Do a fax page load
Const DOPAINT = &H2         ' Do a picturebox paint
Const DOMODE = &H4          ' Mode Change
Const DOEXIT = &H8          ' Exit the application

Const SCROLL = 0            ' Scroll Viewing Mode
Const STRETCH = 1           ' Stretch to window View Mode

Dim TimerDone As Integer    ' Flag to tell when the timer shuts down
Dim ReadFileNum             ' File number for ReadPage()

Sub bfmenu_Click ()
     If (MsgFlags And MODING) <> 0 Or bfmenu.Checked Then
          Exit Sub
     End If
     mfmenu.Checked = False
     bfmenu.Checked = True
     ViewMode = STRETCH
     DoMsg = DoMsg Or DOMODE
End Sub

Sub efmenu_Click ()
     Unload Me
End Sub

Sub fax_Resize ()
     If Me.WindowState = MINIMIZED Or ViewMode = SCROLL Then
          Exit Sub
     End If
     fax.Cls
     fax.ScaleWidth = PELWIDTH
     fax.ScaleHeight = PELHEIGHT
     DoMsg = DoMsg Or DOPAINT
End Sub

Sub faxback_Click ()
    If CurPage > 0 Then
        CurPage = CurPage - 1
        DoMsg = DoMsg Or DOLOAD
    End If
    If CurPage = 0 Then
        faxback.Enabled = False
    End If
    If CurPage < NumPages Then
        faxnext.Enabled = True
    End If
End Sub

Sub faxholder_Resize ()
     If ViewMode = SCROLL Then
          fxhscroll.Visible = True
          fxvscroll.Visible = True
     Else
          fax.Cls
          fax.ScaleWidth = PELWIDTH
          fax.ScaleHeight = PELHEIGHT
     End If
End Sub

Sub faxnext_Click ()
     If CurPage < NumPages Then
          CurPage = CurPage + 1
          DoMsg = DoMsg Or DOLOAD
     End If
     If CurPage = NumPages Then
          faxnext.Enabled = False
     End If
    If CurPage > 0 Then
        faxback.Enabled = True
    End If
End Sub

Sub Form_Load ()
     Dim initloop As Integer

     posiload Me, FXVWFRMID
     CancelAll = False
     ReDim FLines(BASESIZE - 1, 0)
     OldYBase = 0
     ViewMode = STRETCH
     InitMode ViewMode
     DoMsg = 0
     MsgFlags = 0
     ReDim plines(0)
     TimerDone = False
     fxtimer.Enabled = True
     fxtimer.Interval = 100
     NumPages = OpenFile(IMGFIL)
     If NumPages > 0 Then
          faxnext.Enabled = True
     End If
     CurPage = 0
     DoMsg = DoMsg Or DOLOAD
End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)

     CancelAll = True
     fxtimer.Interval = 0
     fxtimer.Enabled = False
     DoMsg = DOEXIT
     posisave Me, FXVWFRMID, True
     If (MsgFlags And LOADING) <> 0 Then
          Close ReadFileNum
     End If
     On Error Resume Next
     Kill IMGFIL
     On Error GoTo 0
     Do While Not TimerDone
          fxtimer_timer
          DoEvents
     Loop
     ReDim FLines(0, 0)
End Sub

Sub Form_Resize ()
     Dim DrawLoop As Long
     Dim prow As Integer, pcol As Integer, poff As Integer
     Dim barwidth As Integer, barheight As Integer

     If Me.WindowState = MINIMIZED Then
          Exit Sub
     End If
     If ViewMode = SCROLL Then
          barwidth = fxvscroll.Width
          barheight = fxhscroll.Height
     Else
          barwidth = 0
          barheight = 0
     End If
     faxholder.Height = ValProp(Me.ScaleHeight - panel2.Height - barheight)
     faxholder.Width = ValProp(Me.ScaleWidth - barwidth)
     If ViewMode = STRETCH Then
          fax.Height = faxholder.Height
          fax.Width = faxholder.Width
     End If
     If ViewMode = SCROLL Then
          fxvscroll.Top = Me.ScaleTop
          fxvscroll.Left = faxholder.Width + 1
          fxvscroll.Height = faxholder.Height
          fxhscroll.Top = faxholder.Height + 1
          fxhscroll.Left = Me.ScaleLeft
          fxhscroll.Width = faxholder.Width
          fxhscroll.Max = fax.Width - faxholder.Width
          fxvscroll.Max = fax.Height - faxholder.Height
          fxvscroll.Visible = True
          fxhscroll.Visible = True
     End If
     panel2.Left = ((Me.ScaleWidth) - panel2.Width) / 2
     panel2.Top = faxholder.Height + barheight + 1
     If ViewMode = STRETCH Then
          DoMsg = DoMsg Or DOPAINT
     End If
End Sub

Sub fxhscroll_Change ()
     fax.Left = -fxhscroll.Value
End Sub

Sub fxhscroll_Scroll ()
     fxhscroll_Change
End Sub

Sub fxtimer_timer ()
     TimerDone = False
     If (DoMsg And DOMODE) <> 0 Then
          If (MsgFlags And MODING) = 0 Then
               DoMsg = DoMsg And (Not DOMODE)
               InitMode ViewMode
          End If
     End If
     If (DoMsg And DOLOAD) <> 0 Then
          If (MsgFlags And LOADING) = 0 Then
               DoMsg = DoMsg And (Not DOLOAD)
               fax.Cls
               ReadPage CurPage
          End If
     End If
     If (DoMsg And DOPAINT) <> 0 Then
          If (MsgFlags And PAINTING) = 0 Then
               DoMsg = DoMsg And (Not DOPAINT)
               PaintFax
          End If
     End If
     If (DoMsg And DOEXIT) <> 0 Then
          TimerDone = True
          Exit Sub
     End If
End Sub

Sub fxvscroll_Change ()
     fax.Top = -fxvscroll.Value
End Sub

Sub fxvscroll_Scroll ()
     fxvscroll_Change
End Sub

Sub InitMode (mode As Integer)
' Setup fax viewing form for either full-size or snap-to-window (SCROLL and STRETCH, respectively)

    Dim barwidth As Single
    Dim barheight As Single

    mview.Enabled = False
    MsgFlags = MsgFlags Or MODING
    fax.Left = 0
    fax.Top = 0
    fax.AutoRedraw = True
    If mode = SCROLL Then
        barwidth = fxvscroll.Width
        barheight = fxhscroll.Height
    Else
        barwidth = 0
        barheight = 0
    End If
    faxholder.Height = ValProp(Me.ScaleHeight - panel2.Height - barheight)
    faxholder.Width = ValProp(Me.ScaleWidth - barwidth)
    If mode = STRETCH Then
        fax.Height = faxholder.Height
        fax.Width = faxholder.Width
    End If
    If mode = SCROLL Then
        fax.Cls
        fax.ScaleMode = 1
        fax.Height = screen.TwipsPerPixelY * PELHEIGHT
        fax.Width = screen.TwipsPerPixelX * PELWIDTH
        fxvscroll.Min = 0
        fxhscroll.Min = 0
        fxvscroll.SmallChange = 8 * screen.TwipsPerPixelY
        fxhscroll.SmallChange = 8 * screen.TwipsPerPixelX
        fxvscroll.LargeChange = 16 * screen.TwipsPerPixelY
        fxhscroll.LargeChange = 16 * screen.TwipsPerPixelX
        fax.ScaleMode = 3
        fxvscroll.Top = Me.ScaleTop
        fxvscroll.Left = faxholder.Width + 1
        fxvscroll.Height = faxholder.Height
        fxhscroll.Top = faxholder.Height + 1
        fxhscroll.Left = Me.ScaleLeft
        fxhscroll.Width = faxholder.Width
        fxhscroll.Max = fax.Width - faxholder.Width
        fxvscroll.Max = fax.Height - faxholder.Height
        fxvscroll.Visible = True
        fxhscroll.Visible = True
    Else
        fax.ScaleMode = 0
        fxvscroll.Visible = False
        fxhscroll.Visible = False
        fax.ScaleHeight = PELHEIGHT
        fax.ScaleWidth = PELWIDTH
        fax.Height = ValProp(Me.ScaleHeight - panel2.Height)
        fax.Width = Me.ScaleWidth
    End If
    panel2.Left = ((Me.ScaleWidth) - panel2.Width) / 2
    panel2.Top = faxholder.Height + barheight + 1
    mview.Enabled = True
    MsgFlags = MsgFlags And (Not MODING)
    DoMsg = DoMsg Or DOPAINT
End Sub

Sub mfmenu_Click ()
     If (MsgFlags And MODING) <> 0 Or mfmenu.Checked Then
          Exit Sub
     End If
     mfmenu.Checked = True
     bfmenu.Checked = False
     ViewMode = SCROLL
     DoMsg = DoMsg Or DOMODE
End Sub

Sub mhelp_Click ()
    dohelp mhelp, HELP_CONTEXT
End Sub

Function OpenFile (Filename As String) As Integer
' Open a fax coordinate file

    Dim fstr As String
    Dim pages As Integer, pcloop As Integer
    Dim pagelen As Long
    Dim FileNum

    FileNum = FreeFile
    FaxFile = Filename
    fstr = Dir$(IMGFIL, 0)
    If Len(fstr) > 0 Then
        On Error Resume Next
        Open Filename For Binary Access Read As FileNum
        Get FileNum, , pages
        If Err <> 0 Then
            Close FileNum
            Exit Function
        End If
        pages = pages - 1
        ReDim plines(pages)
        For pcloop = 0 To pages
            Get FileNum, , pagelen
            If Err <> 0 Then
                Close FileNum
                Exit Function
            End If
            plines(pcloop) = pagelen
        Next pcloop
        Close FileNum
        On Error GoTo 0
        OpenFile = pages
    End If
End Function

Sub PaintFax ()
' Draw the fax image in the viewer

    Dim DrawLoop As Long, templines As Long, pctinc As Long
    Dim prow As Integer, pcol As Integer, poff As Integer
    Dim oldpoint As Long, status As Integer

    If Me.WindowState = MINIMIZED Or (FaxLines = 0) Or (MsgFlags And LOADING) <> 0 Then
        Exit Sub
    End If
    If (MsgFlags And PAINTING) <> 0 Then
        DoMsg = DoMsg Or DOPAINT
        Exit Sub
    End If
    On Error GoTo v1error
    Me.Caption = "Fax Viewer (Drawing fax....)"
    MsgFlags = MsgFlags Or PAINTING
    templines = FaxLines
    fax.AutoRedraw = True
    fax.Visible = False
    gauge.FloodPercent = 0
    gauge.FloodShowPct = True
    ProgDisp True
    If ViewMode = SCROLL Then
        fax.ScaleMode = 3
    End If
    pctinc = (FaxLines + 1) \ 100
    For DrawLoop = 0 To templines
        DoEvents
        fxtimer_timer
        If CancelAll Then

            MsgFlags = MsgFlags And (Not PAINTING)
            Exit Sub
            Me.Caption = "Fax Viewer (Page " & Trim$(Str$(CurPage + 1)) & "/" & Trim$(Str$(NumPages + 1)) & ")"
        End If
        prow = FLines(XBase(DrawLoop), YBase(DrawLoop)).row
        pcol = FLines(XBase(DrawLoop), YBase(DrawLoop)).col
        poff = FLines(XBase(DrawLoop), YBase(DrawLoop)).offst
        If ViewMode = SCROLL Then
        ' using Windows API for speed
            oldpoint = MoveTo(fax.hDC, pcol, prow)
            status = LineTo(fax.hDC, poff, prow)
        Else
            fax.Line (pcol, prow)-(poff, prow)
        End If
        If (DoMsg And DOMODE) <> 0 Or (DoMsg And DOPAINT) <> 0 Then
            MsgFlags = MsgFlags And (Not PAINTING)
            Me.Caption = "Fax Viewer (Page " & Trim$(Str$(CurPage + 1)) & "/" & Trim$(Str$(NumPages + 1)) & ")"
            ProgDisp False
            Exit Sub
        End If
        If (DrawLoop Mod pctinc) = 0 Then
        gauge.FloodPercent = (DrawLoop * 100) \ (FaxLines + 1)
        End If
    Next DrawLoop
    gauge.FloodShowPct = False
    gauge.FloodPercent = 0
    ProgDisp False
    If ViewMode = SCROLL Then
        fax.ScaleMode = 1
    End If
    fax.Visible = True
    Me.Caption = "Fax Viewer (Page " & Trim$(Str$(CurPage + 1)) & "/" & Trim$(Str$(NumPages + 1)) & ")"
    MsgFlags = MsgFlags And (Not PAINTING)
    On Error GoTo 0
    Exit Sub
v1error:
    freeup
    poperror "Insufficient memory to run Fax Viewer.  Close other applications and try again.  If Fax Viewer still won't run, close the Fax/Online application and re-enter it.", ""
    Unload Me
    Exit Sub
End Sub

Sub pfmenu_Click ()
     Dim ncopies As String
     Dim prtloop As Integer

     ncopies = formfunc(gcspdlg, "1" & Chr$(9) & "Print Fax")
     If ival(ncopies) > 0 Then
          For prtloop = 1 To ival(ncopies)
               PrintFax
          Next prtloop
     End If
End Sub

Sub PrintFax ()
' call the modal print dialogue to print a fax image

     fxtimer.Enabled = False
     prpfrm.Show 1
     fxtimer.Enabled = True
End Sub

Sub ProgDisp (onval As Integer)
    If onval Then
        faxback.Top = 60
        faxnext.Top = 60
        gauge.Visible = True
    Else
        gauge.Visible = False
        faxback.Top = 250
        faxnext.Top = 250
    End If
End Sub

Sub ReadPage (page As Integer)
' read in a full page of fax file coordinates

    Dim frow As Integer, fcol As Integer, foff As Integer
    Dim xelem As Integer, yelem As Integer, pctinc As Long
    Dim DrawLoop As Long
    Dim fileoff As Long
    Dim oldpoint As Long, status As Integer

    If (MsgFlags And LOADING) <> 0 Then
        DoMsg = DoMsg Or DOLOAD
        Exit Sub
    End If
    If (page > NumPages) Or (page < 0) Then
        Exit Sub
    End If
    MsgFlags = MsgFlags Or LOADING
    Me.Caption = "Fax Viewer (Loading Image....)"
    gauge.FloodPercent = 0
    gauge.FloodShowPct = True
    ProgDisp True
    pfmenu.Enabled = False
    fileoff = (NumPages + 1) * 4 + 2 + 1
    If page > 0 Then
        fileoff = fileoff + (plines(page - 1) * 6)
    End If
    FaxLines = 0
    If ViewMode = SCROLL Then
        fax.ScaleMode = 3
    End If
    ReadFileNum = FreeFile
    On Error Resume Next
    Open FaxFile For Binary Access Read As ReadFileNum
    Seek ReadFileNum, fileoff
    pctinc = plines(page) \ 100
    For DrawLoop = 1 To plines(page)
        DoEvents
        fxtimer_timer       ' Disk I/O slows timer down, so call it here
        If CancelAll Then
            FaxLines = 0
            Close ReadFileNum
            MsgFlags = MsgFlags And (Not LOADING)
            DoMsg = DoMsg And (Not DOLOAD)
            Exit Sub
        End If
        On Error Resume Next
        Get ReadFileNum, , frow
        Get ReadFileNum, , fcol
        Get ReadFileNum, , foff
        If Err <> 0 Then
            Close ReadFileNum
            MsgFlags = MsgFlags And (Not LOADING)
            Exit Sub
        End If
        xelem = XBase(FaxLines)
        yelem = YBase(FaxLines)
        If yelem > OldYBase Then
            OldYBase = yelem
            ReDim Preserve FLines(BASESIZE - 1, YBase(FaxLines))
        End If
        FLines(xelem, yelem).row = frow
        FLines(xelem, yelem).col = fcol
        FLines(xelem, yelem).offst = foff
        If (DoMsg And DOLOAD) <> 0 Then
            FaxLines = 0
            Close ReadFileNum
            MsgFlags = MsgFlags And (Not LOADING)
            Me.Caption = "Fax Viewer (Page " & Trim$(Str$(CurPage + 1)) & "/" & Trim$(Str$(NumPages + 1)) & ")"
            ProgDisp False
            Exit Sub
        End If
        FaxLines = FaxLines + 1
        If (DrawLoop Mod pctinc) = 0 Then
        gauge.FloodPercent = (DrawLoop * 100) \ plines(page)
        End If
    Next DrawLoop
    Close ReadFileNum
    On Error GoTo 0
    gauge.FloodShowPct = False
    gauge.FloodPercent = 0
    ProgDisp False
    If ViewMode = SCROLL Then
        fax.ScaleMode = 1
    Else
        fax.ScaleWidth = PELWIDTH
        fax.ScaleHeight = PELHEIGHT
        fax.ScaleMode = 0
    End If
    FaxLines = FaxLines - 1
    pfmenu.Enabled = True
    Me.Caption = "Fax Viewer (Page " & Trim$(Str$(CurPage + 1)) & "/" & Trim$(Str$(NumPages + 1)) & ")"
    DoMsg = DoMsg Or DOPAINT
    MsgFlags = MsgFlags And (Not LOADING)
End Sub

Function ValProp (NewVal As Single) As Single
' return a valid property value (used when resizing controls)

     If NewVal < 1 Then
          ValProp = 1
     Else
          ValProp = NewVal
     End If
End Function

