'***************************************************************************
'*                                                                         *
'*   FAXSTUFF.BAS                                                          *
'*                                                                         *
'*   Copyright (c) 1995-1996 Galacticomm, Inc.    All Rights Reserved.     *
'*                                                                         *
'*   This module contains special global constants, variables and shared   *
'*   shared utility subs and functions for the C/S fax application.        *
'*                                                                         *
'*                                                   - J. Delekto 11/28/95 *
'*                                                                         *
'***************************************************************************

Option Explicit

' point structure
Type pointstruct
     pointx As Integer
     pointy As Integer
End Type

' FaxLine structure for fax images composed of lines
Type FaxLine
     row As Integer     ' pixel row
     col As Integer     ' pixel column
     offst As Integer   ' length (offset of line)
End Type

Declare Sub GetCaretPos Lib "User" (lpPoint As pointstruct)

Global Const BASESIZE = 32761   ' viewer base index size

' Subsection constants for message boxes follow
Global Const FOTITL = 0     ' "Fax/Online"
Global Const CCTITL = 1     ' "Check Credit"
Global Const AFTITL = 2     ' "Add File"
Global Const SFTITL = 3     ' "Send Fax"
Global Const ATTITL = 4     ' "Attach Fax"
Global Const ADTITL = 5     ' "Add Fax"
Global Const EDTITL = 6     ' "Edit Fax"
Global Const DFTITL = 7     ' "Delete Fax"
Global Const RFTITL = 8     ' "Receive Fax"
Global Const HITITL = 9     ' "Helpful Information"
Global Const VWTITL = 10    ' "Fax Viewer"

' Error constants for message boxes follow
Global Const CONERR = 0     ' Connection lost error (fatal)
Global Const NFCERR = 1     ' Connection lost error (non-fatal)
Global Const NOAERR = 2     ' Agent not available on server (fatal)
Global Const TMFERR = 3     ' Too many fax files attached (non-fatal)
Global Const NVFERR = 4     ' Not a valid filename (non-fatal)
Global Const NACERR = 5     ' not allowed access to server (fatal)
Global Const DLCERR = 6     ' Data lost during credit check write (non-fatal)
Global Const DLSERR = 7     ' Data lost during fax send write (non-fatal)
Global Const NFVERR = 8     ' No fax file received for viewing

' Dynapak overrides
Global Const PCACHE = "(c=p)"

' Dynapak name constants for reads and writes
Global Const FILVFY = "sau:filvfy "     ' verify file on server dynapak
Global Const CRDCHK = "sau:crdchk"      ' check credits dynapak
Global Const FAXFNA = "sau:faxfnm "     ' get fax filenames dynapak
Global Const FAXSKY = "sau:faxkey"      ' check fax key dynapak
Global Const FAXDAT = "sau:faxdat"      ' fax data transfer dynapak
Global Const FAXEDT = "sau:faxedt"      ' fax edit data dynapak
Global Const FAXADF = "sau:faxadd"      ' fax add data dynapak
Global Const FAXCHN = "sau:faxchn"      ' fax channel search dynapak
Global Const FAXRCV = "sau:faxrcv"      ' unsolicited fax ready to receive
Global Const FAXVEW = "sauf:faxvew "    ' view fax dynapak
Global Const FXVNFY = "sau:fxvnfy "     ' notify fax viewer received all info
Global Const FAXDEL = "sau:faxdel"      ' delete fax from database dynapak
Global Const FAXRFS = "sa:faxrfs"       ' unsolicited fax list refresh dynapak
Global Const FAXPNF = "sau:faxpnf"      ' fax phone # information
Global Const FAXCFG = "saul:faxcfg"     ' fax save configuration dynapak

' constants for special messages.
' if you change these, remember to change them on the agent.
Global Const ERRSPV = "error"       ' response for errer
Global Const OKRSPV = "ok"          ' response for ok
Global Const CLIRSP = 0             ' client side error
Global Const SVRRSP = 1             ' server side error
Global Const OKVALUE = 0            ' built message is an ok
Global Const ERVALUE = 1            ' built message is an error
Global Const IGNORE = 0             ' built message is ignored for server
Global Const ENFATAL = 0            ' non-fatal error (server side)
Global Const EFATAL = 1             ' fatal error (server side)

Global Const PELWIDTH = 1728        ' Absolute fax width for page
Global Const PELHEIGHT = 1072       ' Absolute fax length for page

Global Const IMGFIL = "FAXIMG.FXF"  ' fax image lines filename

Global FormOff As Single        ' form offset for menu
Global NL As String             ' Newline character string
Global DTAB As String           ' Tab character as string
Global fapchng As Integer       ' used to determine if fax has been changed
Global faxinfochg As Integer    ' used when add or edit fax info modified
Global CurTextBox As TextBox    ' current textbox for copy and paste
Global FaxUnloaded As Integer   ' Fax form already unloading
Global RcvReqId As Integer      ' Fax receive request ID for enabling abort
Global AddFrFlag As Integer     ' Add the frame if necessary and window was minimized

' Below are the globals used for the fax viewer
Global FaxLines As Long         ' Number of lines for CurPage
Global OldYBase As Integer      ' Old value of second dimension
Global plines() As Long         ' Lines per page array
Global FLines() As FaxLine      ' Faxline structure array
Global ViewMode As Integer      ' Viewing Mode, Scroll or Stretch
Global EditMode As Integer      ' Editing Mode of fax image
Global NumPages As Integer      ' Total number of pages in fax
Global CurPage As Integer       ' Current page in opened fax
Global FaxFile As String        ' Filename of fax file
Global vwfxfr As Integer        ' dynapak request ID for view files
Global rcvcnfop As Integer      ' add fax via remote machine flag

Global MsgFlags As Integer      ' Current active messages processing
Global DoMsg As Integer         ' Messages waiting to be processed
Global CancelAll As Integer     ' Cancel any pending operations

' Definitions for error and subsection names
Global boxmsgs(8) As String     ' error messages for pop-up
Global subnams(10) As String    ' substate names for pop-up

' Definitions for pluralized word arrays
Global pagstr1 As String        ' plural pages string
Global pagstr2 As String        ' singular pages string

Const CNFCHGF = &H1     ' confirm charges flag bit
Const CNFQUEF = &H2     ' confirm queue notification bit
Const CNFADDF = &H4     ' add fax notification bit
Const CNFEDTF = &H8     ' edit fax notification bit
Const CNFDELF = &H10    ' delete fax notification bit
Const CNFRMTF = &H20    ' remote fax selection bit

Sub GetInit ()
    Dim Value As String
    Dim cheight As Single

    If Trim$(faxmnfrm!faxfrom.Text) = "" Then
        Value = sreadpkv("(c=p)su:userinfo name")
        Select Case evtdpk()
        Case "Dynapak received", "Dynapak available"
            faxmnfrm!faxfrom.Text = Value
        Case Else
            faxmnfrm!faxfrom.Text = ""
        End Select
        fapchng = False
    End If
    If SysopKey() Then
        faxmnfrm!attflbl.Visible = True
        faxmnfrm!attfile.Visible = True
        faxmnfrm!faxedit.Visible = True
        faxmnfrm!faxadd.Visible = True
        faxmnfrm!delfax.Visible = True
        faxmnfrm!mbar1.Visible = True
        faxmnfrm!cnfadd.Visible = True
        faxmnfrm!cnfedt.Visible = True
        faxmnfrm!cnfdel.Visible = True
        faxmnfrm!sdframe.Visible = True
        faxmnfrm!adframe.Visible = True
        If faxmnfrm.WindowState <> MINIMIZED then
            cheight = faxmnfrm!cpframe.Height + faxmnfrm!tmframe.Height + faxmnfrm!sdframe.Height + faxmnfrm!butpic.Height + 5 * DIFFDIST
            faxmnfrm.Height = cheight + (faxmnfrm.Height - faxmnfrm.ScaleHeight)
        End If
        faxmnfrm!sdframe.Top = faxmnfrm!tmframe.Top + faxmnfrm!tmframe.Height + DIFFDIST
        faxmnfrm!adframe.Top = faxmnfrm!tmframe.Top + faxmnfrm!tmframe.Height + DIFFDIST
        faxmnfrm!butpic.Top = faxmnfrm!sdframe.Top + faxmnfrm!sdframe.Height + DIFFDIST
    Else
        faxmnfrm!attflbl.Visible = False
        faxmnfrm!attfile.Visible = False
        faxmnfrm!faxedit.Visible = False
        faxmnfrm!faxadd.Visible = False
        faxmnfrm!delfax.Visible = False
        faxmnfrm!mbar1.Visible = False
        faxmnfrm!cnfadd.Visible = False
        faxmnfrm!cnfedt.Visible = False
        faxmnfrm!cnfdel.Visible = False
        faxmnfrm.attlist.Height = faxmnfrm!adframe.Height - (4 * DIFFDIST)
    End If
End Sub

Sub hndmsg (errstr As String, subloc As Integer, btype As Integer, apside As Integer, clistat As Integer)
' errstr    = variant containing error code, or string
' subloc    = subtitle index for message boxes
' btype     = box type value (i.e., icon, ok, etc..)
' apside    = error generated from client or server
' clistat   = client generated -- (error, or ok?)

    Dim rspval As String, msgstr As String
    Dim Value As Integer

    freeup
    If apside = SVRRSP Then
        rspval = itemidx(errstr, 0)
        msgstr = itemidx(errstr, 1)
        Value = ival(itemidx(errstr, 2))
    Else
        If clistat = OKVALUE Then
            rspval = OKRSPV
        Else
            rspval = ERRSPV
        End If
        msgstr = itemidx(errstr, 0)
        Value = ival(itemidx(errstr, 1))
    End If
    If apside = SVRRSP Then     ' server side error handler
        If Len(msgstr) > 0 Then
            junk = gmsgbox(msgstr, btype, subnams(subloc))
        End If
        If rspval = ERRSPV Then
            If Value = EFATAL Then
                freeup
                Unload faxmnfrm
                Exit Sub
            End If
        End If
    Else                        ' client side error handler
        junk = gmsgbox(msgstr, btype, subnams(subloc))
        If rspval = ERRSPV Then
            Select Case Value
                Case NOAERR
                    freeup
                    Unload faxmnfrm
                Case NACERR
                    freeup
                    Unload faxmnfrm
                Case Else
                    Exit Sub
               End Select
          End If
     End If
End Sub

Function faxhval (ByVal hstr As String) As Integer
' return the integer value of a hex string

    faxhval = ival("&H" & Trim$(hstr))
End Function

Sub InitVars ()
' Initial fax application local and global variables
    NL = Chr$(10)
    DTAB = Chr$(9)
' subtask names for error boxes follow
    subnams(FOTITL) = "Fax/Online"
    subnams(CCTITL) = "Check Credit"
    subnams(AFTITL) = "Attach File"
    subnams(SFTITL) = "Send Fax"
    subnams(ATTITL) = "Attach Fax"
    subnams(ADTITL) = "Add Fax"
    subnams(EDTITL) = "Edit Fax"
    subnams(DFTITL) = "Delete Fax"
    subnams(RFTITL) = "Receive Fax"
    subnams(HITITL) = "Helpful Information"
    subnams(VWTITL) = "Fax Viewer"
' error messages follow
    boxmsgs(CONERR) = "Connection to server lost.  Please re-establish connection and try again."
    boxmsgs(NFCERR) = boxmsgs(0)
    boxmsgs(NOAERR) = "Fax/Online agent is not present on this Worldgroup server."
    boxmsgs(TMFERR) = "Too many faxes are attached.  Please remove some and try again."
    boxmsgs(NVFERR) = "Invalid filename was entered.  Please try a different name."
    boxmsgs(NACERR) = "You are not allowed access to Fax/Online on this server."
    boxmsgs(DLCERR) = "Credit information was lost while communicating with the server.  Please try your request again."
    boxmsgs(DLSERR) = "Fax information was lost while communicating with the server.  If you do not receive notification, you may need to resend your fax."
    boxmsgs(NFVERR) = "Fax viewing file was not received by the server.  Please notify the System Operator."
    pagstr1 = DTAB & " pages"
    pagstr2 = DTAB & " page"
' fax information flags
    fapchng = False
    faxinfochg = False
    FaxUnloaded = False
    AddFrFlag = False
End Sub

Sub LoadConfig ()
' Load local dynapak configuration option(s)
    Dim fstring As String, evtstr As String
    Dim flags As Integer

    fstring = sreadpkv(FAXCFG)
    If Len(fstring) <> 0 Then
        flags = ival(fstring)
        faxmnfrm!cnfchg.Checked = ((flags And CNFCHGF) <> 0)
        faxmnfrm!cnfque.Checked = ((flags And CNFQUEF) <> 0)
        faxmnfrm!cnfadd.Checked = ((flags And CNFADDF) <> 0)
        faxmnfrm!cnfedt.Checked = ((flags And CNFEDTF) <> 0)
        faxmnfrm!cnfdel.Checked = ((flags And CNFDELF) <> 0)
        rcvcnfop = ((flags And CNFRMTF) <> 0)
    Else
        faxmnfrm!cnfchg.Checked = True
        faxmnfrm!cnfque.Checked = True
        faxmnfrm!cnfadd.Checked = True
        faxmnfrm!cnfedt.Checked = True
        faxmnfrm!cnfdel.Checked = True
        rcvcnfop = False
    End If
End Sub

Function onlread (dynpak As String) As String
' enforce a dynapak read to be done while connected to the server

     Dim Value As String, retval As String

     If connect("default") Then
          Value = sreadpkv(dynpak)
          Select Case evtdpk()
          Case "Dynapak received"
               onlread = Value
          Case Else
               onlread = "*OFF*"
          End Select
     Else
          onlread = "*OFF*"
     End If
End Function

Function onlwrite (dynpak As String, cdata As String) As String
' enforce a dynapak write to be done while connected to the server

    Dim Value As String

    If connect("default") Then
        Value = swrtdpkv(dynpak, STGLEN, cdata)
        Select Case evtdpk()
        Case "Write ok"
            onlwrite = Value
        Case "Offline write denied"
            onlwrite = "*OFF*"
        Case "Write may be incomplete"
            onlwrite = "*INC*"
        Case "Write denied"
            onlwrite = "*DENY*"
        Case Else
            onlwrite = "*OFF*"
        End Select
    Else
        onlwrite = "*OFF*"
    End If
End Function

Sub SaveConfig ()
' Save local dynapak configuration option(s)
    Dim flags As Integer
    Dim dpkval As String

    flags = 0
    If faxmnfrm!cnfchg.Checked Then
        flags = flags Or CNFCHGF
    End If
    If faxmnfrm!cnfque.Checked Then
        flags = flags Or CNFQUEF
    End If
    If faxmnfrm!cnfadd.Checked Then
        flags = flags Or CNFADDF
    End If
    If faxmnfrm!cnfedt.Checked Then
        flags = flags Or CNFEDTF
    End If
    If faxmnfrm!cnfdel.Checked Then
        flags = flags Or CNFDELF
    End If
    If rcvcnfop Then
        flags = flags Or CNFRMTF
    End If
    dpkval = Trim$(Str$(flags))
    junk = swrtdpkv(FAXCFG, STGLEN, dpkval)
End Sub

Function SysopKey () As Integer
' Check to see if C/S user has fax user 'sysop' key for maintaining the fax database

    Dim faxkey As String

    faxkey = sreadpkv(PCACHE & FAXSKY)
    Select Case evtdpk()
    Case "Dynapak received", "Dynapak available"
        If faxkey = OKRSPV Then
            SysopKey = True
        Else
            SysopKey = False
        End If
    Case Else
        SysopKey = False
    End Select
End Function

Sub TexSel (mybox As TextBox)
' Select the contents of a textbox control

     mybox.SelStart = 0
     mybox.SelLength = Len(mybox.Text)
End Sub

Function XBase (index As Long) As Integer
' convert large array index into first dimensional element

    Dim bcheck As Long

    bcheck = index Mod BASESIZE
    If bcheck <= BASESIZE Then
        XBase = index Mod BASESIZE
    Else
        XBase = 0   ' This should not happen, but will avoid overflows
    End If
End Function

Function YBase (index As Long) As Integer
' Convert a large index into a second dimensional element

    Dim bcheck As Long

    bcheck = index \ BASESIZE
    If bcheck <= BASESIZE Then
        YBase = index \ BASESIZE
    Else
        YBase = 0   ' This should not happen, but will avoid overflows
    End If
End Function

