VERSION 2.00
Begin Form comment 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Fax Memo"
   ClientHeight    =   3210
   ClientLeft      =   2640
   ClientTop       =   3345
   ClientWidth     =   7995
   Height          =   3615
   HelpContextID   =   21
   Icon            =   FAXCMT.FRX:0000
   KeyPreview      =   -1  'True
   Left            =   2580
   MinButton       =   0   'False
   ScaleHeight     =   3210
   ScaleWidth      =   7995
   Top             =   3000
   Width           =   8115
   Begin SSPanel butpic 
      Alignment       =   1  'Left Justify - MIDDLE
      BevelOuter      =   0  'None
      ForeColor       =   &H00000000&
      Height          =   360
      Left            =   2340
      TabIndex        =   1
      Top             =   2760
      Width           =   3060
      Begin CommandButton cancelbut 
         BackColor       =   &H00C0C0C0&
         Cancel          =   -1  'True
         Caption         =   "Cancel"
         Height          =   360
         Left            =   1020
         TabIndex        =   2
         Top             =   0
         Width           =   960
      End
      Begin CommandButton okbut 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&OK"
         Height          =   360
         Left            =   0
         TabIndex        =   3
         Top             =   0
         Width           =   960
      End
      Begin CommandButton helpbut 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Help"
         Height          =   360
         HelpContextID   =   2
         Left            =   2100
         TabIndex        =   4
         Top             =   0
         Width           =   960
      End
   End
   Begin Timer movetimer 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   120
      Top             =   2760
   End
   Begin HScrollBar hscroll 
      Height          =   255
      Left            =   60
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   2400
      Width           =   7635
   End
   Begin VScrollBar vscroll 
      Height          =   2295
      Left            =   7680
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   120
      Width           =   255
   End
   Begin PictureBox cmtpic 
      Height          =   2295
      Left            =   60
      ScaleHeight     =   2265
      ScaleWidth      =   7605
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   120
      Width           =   7635
      Begin TextBox cmttxt 
         BorderStyle     =   0  'None
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Fixedsys"
         FontSize        =   9
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   32767
         Left            =   0
         MaxLength       =   14400
         MultiLine       =   -1  'True
         TabIndex        =   0
         Top             =   0
         Width           =   7875
      End
   End
End
'***************************************************************************
'*                                                                         *
'*   FAXCMT.FRM                                                            *
'*                                                                         *
'*   Copyright (c) 1995-1996 Galacticomm, Inc.    All Rights Reserved.     *
'*                                                                         *
'*   This is the C/S fax application comment form, used to enter and edit  *
'*   fax comments.                                                         *
'*                                                                         *
'*                                                   - J. Alvrus  11/28/95 *
'*                                                                         *
'***************************************************************************

Option Explicit

Const CMTFRMID = "commentform"
Const EM_LINEINDEX = &H40B
Const EM_LINELENGTH = &H411
Const EM_LINEFROMCHAR = &H419
Const MXLLEN = 72

Dim minw As Single, minh As Single
Dim ok2change As Integer
Dim lineh As Integer
Dim charw As Integer
Dim respstr As String

Sub cancelbut_Click ()
    Unload Me
End Sub

Sub cmtpic_GotFocus ()
    On Error Resume Next
    cmttxt.SetFocus
End Sub

Sub cmttxt_Change ()
    If ok2change Then
        vscroll.Max = gettxtnlin(cmttxt) - 1
        showcaret
    End If
End Sub

Sub cmttxt_KeyDown (KeyCode As Integer, Shift As Integer)
    eatctrltab KeyCode, Shift
    If KeyCode <> 0 Then
        movetimer.Enabled = True
    End If
End Sub

Sub cmttxt_LostFocus ()
    snagtab cmttxt, Space$(8 - (gettxtx(cmttxt) Mod 8))
End Sub

Sub cmttxt_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button And KEY_LBUTTON Then
        showcaret
    End If
End Sub

Sub Form_Activate ()
    cmttxt_Change   ' sets up scroll bar and caret
End Sub

Sub Form_KeyDown (KeyCode As Integer, Shift As Integer)
    Dim pt As pointstruct
    Dim tmpx As Integer, tmpy As Integer
    Dim curline As Integer, lvis As Integer, ltot As Integer

    Select Case KeyCode
    Case KEY_PRIOR      ' Page Up
        If Shift = 0 Then
            GetCaretPos pt
            tmpx = (pt.pointx * screen.TwipsPerPixelX) / charw
            tmpy = (pt.pointy * screen.TwipsPerPixelY) / lineh
            lvis = Int(cmtpic.ScaleHeight / lineh)
            If tmpy > lvis Then
                tmpy = tmpy - lvis + 1
            Else
                tmpy = 0
            End If
            settxtpos cmttxt, tmpx, tmpy
            If vscroll.Value > vscroll.LargeChange Then
                vscroll.Value = vscroll.Value - vscroll.LargeChange
            Else
                vscroll.Value = 0
            End If
            showcaret
        End If
        KeyCode = 0
    Case KEY_NEXT       ' Page Down
        If Shift = 0 Then
            GetCaretPos pt
            tmpx = (pt.pointx * screen.TwipsPerPixelX) / charw
            tmpy = (pt.pointy * screen.TwipsPerPixelY) / lineh
            lvis = Int(cmtpic.ScaleHeight / lineh)
            ltot = gettxtnlin(cmttxt)
            If tmpy + lvis < ltot Then
                tmpy = tmpy + lvis - 1
            Else
                tmpy = ltot - 1
            End If
            settxtpos cmttxt, tmpx, tmpy
            If vscroll.Value < vscroll.Max - vscroll.LargeChange Then
                vscroll.Value = vscroll.Value + vscroll.LargeChange
            Else
                vscroll.Value = vscroll.Max
            End If
            showcaret
        End If
        KeyCode = 0
    End Select
End Sub

Sub Form_Load ()
    respstr = ""
    setffont Me, cmttxt
    lineh = Me.TextHeight(" ")
    charw = Me.TextWidth(" ")
    cmttxt.Height = 32767 * screen.TwipsPerPixelY
    cmttxt.Width = charw * MXLLEN
    minh = butpic.Height + cmtpic.Top + 2 * lineh + hscroll.Height + 2 * SAMEDIST
    minw = butpic.Width + (2 * cmtpic.Left)
    vscroll.SmallChange = 1
    hscroll.SmallChange = charw
    hscroll.LargeChange = Me.TextWidth(Space$(10))
    ok2change = False
    cmttxt = formxchg
    ok2change = True
    posiload Me, CMTFRMID
End Sub

Sub Form_Resize ()
    Dim tmpsw As Single, tmpw As Single
    Dim tmpsh As Single, tmph As Single

    If Me.WindowState = MINIMIZED Then
        Exit Sub
    End If
    tmpsw = ScaleWidth
    If tmpsw < minw Then
        tmpsw = minw
    End If
    tmpw = tmpsw - 2 * cmtpic.Left
    tmpsh = ScaleHeight
    If tmpsh < minh Then
        tmpsh = minh
    End If
    tmph = tmpsh - cmtpic.Top - butpic.Height - 2 * SAMEDIST
    cmtpic.Width = tmpw - vscroll.Width + screen.TwipsPerPixelX
    vscroll.Left = cmtpic.Left + tmpw - vscroll.Width
    If cmtpic.ScaleWidth < cmttxt.Width Then
        hscroll.Visible = True
        hscroll.Top = cmtpic.Top + tmph - hscroll.Height
        hscroll.Width = cmtpic.Width
        hscroll.Max = cmttxt.Width - cmtpic.ScaleWidth
        cmtpic.Height = tmph - hscroll.Height + screen.TwipsPerPixelY
        vscroll.Height = cmtpic.Height
    Else
        hscroll.Visible = False
        cmtpic.Height = tmph
        vscroll.Height = tmph
    End If
    butpic.Move (tmpsw - butpic.Width) / 2, cmtpic.Top + tmph + SAMEDIST
    vscroll.LargeChange = cmtpic.Height \ lineh - 1
    vscroll.Max = gettxtnlin(cmttxt) - 1
End Sub

Sub Form_Unload (Cancel As Integer)
    posisave Me, CMTFRMID, True
    formxchg = respstr
End Sub

Function gettxtnlin (c As TextBox) As Long
'get number of lines in a TextBox

    gettxtnlin = sndmsg(c.hWnd, EM_GETLINECOUNT, 0, 0&)
End Function

Function gettxtx (c As TextBox) As Long
'get character x coordinate of TextBox SelStart (zero-based)

    gettxtx = c.SelStart - sndmsg(c.hWnd, EM_LINEINDEX, gettxty(c), 0&)
End Function

Function gettxty (c As TextBox) As Long
' get character y coordinate of TextBox SelStart (zero-based)

    If c.SelStart = Len(c.Text) Then
        gettxty = gettxtnlin(c) - 1
    Else
        gettxty = sndmsg(c.hWnd, EM_LINEFROMCHAR, c.SelStart, 0&)
    End If
End Function

Sub helpbut_Click ()
    On Error Resume Next
    cmttxt.SetFocus
    dohelp helpbut, HELP_CONTEXT
End Sub

Sub hscroll_Change ()
    cmttxt.Left = -hscroll.Value
End Sub

Sub hscroll_Scroll ()
    hscroll_Change
End Sub

Sub movetimer_Timer ()
    movetimer.Enabled = False
    showcaret
End Sub

Sub okbut_Click ()
    respstr = "OK" & DTAB & cmttxt
    Unload Me
End Sub

Sub settxtpos (c As TextBox, ByVal xpos As Integer, ByVal ypos As Integer)
' put caret at specific coordinates

    Dim lstart As Long, maxx As Long

    lstart = sndmsg(c.hWnd, EM_LINEINDEX, ypos, 0)
    maxx = sndmsg(c.hWnd, EM_LINELENGTH, lstart, 0)
    If xpos > maxx Then
        xpos = maxx
    End If
    c.SelStart = lstart + xpos
End Sub

Sub showcaret ()
' make sure caret is displayed in text box

    Dim pt As pointstruct
    Dim tmpx As Long, tmpy As Long
    Dim tmpval As Single

    GetCaretPos pt
    tmpx = pt.pointx * screen.TwipsPerPixelX
    tmpy = pt.pointy * screen.TwipsPerPixelY
    If tmpx < -cmttxt.Left Then
        hscroll.Value = hscroll.LargeChange * Int(tmpx / hscroll.LargeChange)
    ElseIf tmpx >= -cmttxt.Left + cmtpic.ScaleWidth Then
        tmpval = hscroll.LargeChange * (Int((tmpx - cmtpic.ScaleWidth) / hscroll.LargeChange) + 1)
        If tmpval > hscroll.Max Then
            tmpval = hscroll.Max
        End If
        hscroll.Value = tmpval
    End If
    If tmpy < -cmttxt.Top Then
        vscroll.Value = Int(tmpy / lineh)
    ElseIf tmpy > -cmttxt.Top + cmtpic.ScaleHeight - lineh Then
        vscroll.Value = Int((tmpy - cmtpic.ScaleHeight) / lineh) + 2
    End If
End Sub

Sub vscroll_Change ()
    cmttxt.Top = -(lineh * vscroll.Value)
End Sub

Sub vscroll_Scroll ()
    vscroll_Change
End Sub

