/***************************************************************************
 *                                                                         *
 *   TXTVBL.C                                                              *
 *                                                                         *
 *   Copyright (c) 1991-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the default suite of "text variables" that comes with         *
 *   Worldgroup Baseline Edition.                                          *
 *                                                                         *
 *                                                 - C. Robert  2/7/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"

void EXPORT init__txtvbl(void);

char *tvar_userid(void),*tvar_portno(void),
     *tvar_channo(void),*tvar_usrnam(void),
     *tvar_usrad1(void),*tvar_usrad2(void),
     *tvar_usrad3(void),*tvar_usrad4(void),
     *tvar_usrpho(void),*tvar_systyp(void),
     *tvar_ansifl(void),*tvar_scnwid(void),
     *tvar_scnbrk(void),*tvar_usrage(void),
     *tvar_usrsex(void),*tvar_credat(void),
     *tvar_usedat(void),*tvar_curcls(void),
     *tvar_tckavl(void),*tvar_tcktot(void),
     *tvar_tckpai(void),*tvar_timonl(void),
     *tvar_timcal(void),*tvar_timday(void),
     *tvar_usdtdy(void),*tvar_dyslft(void),
     *tvar_dbtlmt(void),*tvar_bdrate(void),
     *tvar_ccrate(void),*tvar_pagnam(void),
     *tvar_parpag(void),*tvar_mnuttl(void),
     *tvar_sydate(void),*tvar_sytime(void),
     *tvar_sysnam(void),*tvar_syscmp(void),
     *tvar_sysad1(void),*tvar_sysad2(void),
     *tvar_syspho(void),*tvar_sysrst(void),
     *tvar_chhour(void),*tvar_chgmin(void),
     *tvar_regnum(void),*tvar_nmline(void),
     *tvar_ninuse(void),*tvar_ncalls(void),
     *tvar_dwnlds(void),*tvar_nuplds(void),
     *tvar_msgtot(void),*tvar_emlopn(void),
     *tvar_sigopn(void),*tvar_numact(void),
     *tvar_nummal(void),*tvar_numfem(void),
     *tvar_numcor(void),*tvar_numans(void),
     *tvar_vrsion(void),*tvar_minonl(void);

void EXPORT
init__txtvbl(void)                 /* initialize & register text variables */
{
     register_textvar("USERID",tvar_userid);
     register_textvar("PORT",tvar_portno);
     register_textvar("CHANNEL",tvar_channo);
     register_textvar("NAME",tvar_usrnam);
     register_textvar("COMPANY",tvar_usrad1);
     register_textvar("ADDRESS1",tvar_usrad2);
     register_textvar("ADDRESS2",tvar_usrad3);
     register_textvar("ADDRESS3",tvar_usrad4);
     register_textvar("PHONE",tvar_usrpho);
     register_textvar("SYSTEM_TYPE",tvar_systyp);
     register_textvar("ANSI",tvar_ansifl);
     register_textvar("SCREEN_WIDTH",tvar_scnwid);
     register_textvar("SCREEN_LENGTH",tvar_scnbrk);
     register_textvar("AGE",tvar_usrage);
     register_textvar("SEX",tvar_usrsex);
     register_textvar("CREATION_DATE",tvar_credat);
     register_textvar("LAST_ON",tvar_usedat);
     register_textvar("CLASS",tvar_curcls);
     register_textvar("CREDITS",tvar_tckavl);
     register_textvar("CREDITS_EVER",tvar_tcktot);
     register_textvar("PAID_EVER",tvar_tckpai);
     register_textvar("TIME_ONLINE",tvar_timonl);
     register_textvar("CALL_TIME_LIMIT",tvar_timcal);
     register_textvar("DAY_TIME_LIMIT",tvar_timday);
     register_textvar("TIME_TODAY",tvar_usdtdy);
     register_textvar("DAYS_LEFT",tvar_dyslft);
     register_textvar("DEBT_LIMIT",tvar_dbtlmt);
     register_textvar("BAUD",tvar_bdrate);
     register_textvar("CREDIT_RATE",tvar_ccrate);
     register_textvar("PAGE",tvar_pagnam);
     register_textvar("PARENT",tvar_parpag);
     register_textvar("TITLE",tvar_mnuttl);
     register_textvar("DATE",tvar_sydate);
     register_textvar("TIME",tvar_sytime);
     register_textvar("SYSTEM_NAME",tvar_sysnam);
     register_textvar("SYSTEM_COMPANY",tvar_syscmp);
     register_textvar("SYSTEM_ADDRESS1",tvar_sysad1);
     register_textvar("SYSTEM_ADDRESS2",tvar_sysad2);
     register_textvar("SYSTEM_PHONE",tvar_syspho);
     register_textvar("RESTRICTED_PHO",tvar_sysrst);
     register_textvar("CHARGE_PER_HOUR",tvar_chhour);
     register_textvar("MINIMUM_CHARGE",tvar_chgmin);
     register_textvar("REG_NUMBER",tvar_regnum);
     register_textvar("NUMBER_OF_LINES",tvar_nmline);
     register_textvar("OTHERS_ONLINE",tvar_ninuse);
     register_textvar("TOTAL_CALLS",tvar_ncalls);
     register_textvar("DOWNLOADS",tvar_dwnlds);
     register_textvar("UPLOADS",tvar_nuplds);
     register_textvar("TOTAL_MESSAGES",tvar_msgtot);
     register_textvar("OPEN_FORUM_MSGS",tvar_sigopn);
     register_textvar("OPEN_EMAIL_MSGS",tvar_emlopn);
     register_textvar("TOTAL_ACCOUNTS",tvar_numact);
     register_textvar("TOTAL_MALE",tvar_nummal);
     register_textvar("TOTAL_FEMALE",tvar_numfem);
     register_textvar("TOTAL_CORP",tvar_numcor);
     register_textvar("TOTAL_ANSI",tvar_numans);
     register_textvar("BBS_VERSION",tvar_vrsion);
     register_textvar("MIN_ONLINE",tvar_minonl);
}

char *
tvar_userid(void)                  /* current User-ID text variable        */
{
     return(usaptr->userid);
}

char *
tvar_portno(void)                  /* current user's port number text vbl  */
{
     return(spr("%d",usrnum));
}

char *
tvar_channo(void)                  /* current user's chan number text vbl  */
{
     return(strupr(spr("%x",channel[usrnum])));
}

char *
tvar_usrnam(void)                  /* current user's real name text vbl    */
{
     return(usaptr->usrnam);
}

char *
tvar_usrad1(void)                  /* current user's company name text vbl */
{
     return(usaptr->usrad1);
}

char *
tvar_usrad2(void)                  /* current user's address line 1 t. vbl */
{
     return(usaptr->usrad2);
}

char *
tvar_usrad3(void)                  /* current user's address line 2 t. vbl */
{
     return(usaptr->usrad3);
}

char *
tvar_usrad4(void)                  /* current user's address line 3 t. vbl */
{
     return(usaptr->usrad4);
}

char *
tvar_usrpho(void)                  /* current user's phone number t. vbl   */
{
     return(usaptr->usrpho);
}

char *
tvar_systyp(void)                  /* current user's system type text vbl  */
{
     return(sysstg[usaptr->systyp]);
}

char *
tvar_ansifl(void)                  /* current user's ANSI setting text vbl */
{
     return(ansstg[usaptr->ansifl]);
}

char *
tvar_scnwid(void)                  /* current user's screen width text vbl */
{
     return(spr("%d",usaptr->scnwid));
}

char *
tvar_scnbrk(void)                  /* current user's screen len text vbl   */
{
     return(usaptr->scnbrk == CTNUOS ? "(continuous)"
            : spr("%d",usaptr->scnbrk));
}

char *
tvar_usrage(void)                  /* current user's age text variable     */
{
     if (usaptr->age > 0) {
          return(spr("%d",usaptr->age));
     }
     else {
          return("N/A");
     }
}

char *
tvar_usrsex(void)                  /* current user's sex text variable     */
{
     return(usaptr->sex == 'M' ? "Male" : usaptr->sex == 'F' ? "Female"
          : "Unknown");
}

char *
tvar_credat(void)                  /* current user's creation date txt vbl */
{
     return(ncdate(usaptr->credat));
}

char *
tvar_usedat(void)                  /* current user's last logon text vbl   */
{
     return(ncdate(usaptr->usedat));
}

char *
tvar_curcls(void)                  /* current user's class text variable   */
{
     return(usaptr->curcls);
}

char *
tvar_tckavl(void)                  /* current user's credits text variable */
{
     return(usaptr->creds > 0L ? spr("+%ld",usaptr->creds)
            : l2as(usaptr->creds));
}

char *
tvar_tcktot(void)                  /* current user's total creds ever tvbl */
{
     return(l2as(usaptr->totcreds));
}

char *
tvar_tckpai(void)                  /* current user's total paid ever tvbl  */
{
     return(l2as(usaptr->totpaid));
}

char *
tvar_timonl(void)                  /* current user's time online text vbl  */
{                                  /* (see also tvar_minonl())             */
     int mins;

     mins=(usrptr->minut4+2)/4;
     return(spr("%d minute%c",mins,mins != 1 ? 's' : '\0'));
}

char *
tvar_timcal(void)                  /* current user's time allowed per call */
{
     return(usrptr->cltptr->limcal == -1 ? "UNLIMITED"
            : spr("%d minutes",usrptr->cltptr->limcal));
}

char *
tvar_timday(void)                  /* current user's time allowed per day  */
{
     return(usrptr->cltptr->limday == -1 ? "UNLIMITED"
            : spr("%d minutes",usrptr->cltptr->limday));
}

char *
tvar_usdtdy(void)                  /* current user's time used today t. vbl*/
{
     long mins;

     mins=(usaptr->timtdy+30L)/60L;
     return(spr("%ld minute%c",mins,mins != 1L ? 's' : '\0'));
}

char *
tvar_dyslft(void)                  /* current user's days left in class tvb*/
{
     struct clstab *tabptr;

     tabptr=usrptr->cltptr;
     return((tabptr->flags&DAYEXP) ? spr("%d",usaptr->daystt) : "UNLIMITED");
}

char *
tvar_dbtlmt(void)                  /* current user's debt limit text vbl   */
{
     struct clstab *tabptr;

     tabptr=usrptr->cltptr;
     return(tabptr->dbtlmt == -1L ? "UNLIMITED" : tabptr->dbtlmt > 0L
            ? spr("%ld",tabptr->dbtlmt) : "None");
}

char *
tvar_bdrate(void)                  /* current user's baud rate text vbl    */
{
     return(l2as(extptr->baud));
}

char *
tvar_ccrate(void)                  /* current user's cred consume rate tvbl*/
{
     return(spr("%u",usrptr->crdrat));
}

char *
tvar_pagnam(void)                  /* current user's menu page name tvbl   */
{
     struct usrmnu *mnupag;

     mnupag=mnuoff(usrnum);
     return(mnupag->curpag[0] == '\0' ? "Logon" : mnupag->curpag);
}

char *
tvar_parpag(void)                  /* current user's parent page name tvbl */
{
     struct usrmnu *mnupag;

     mnupag=mnuoff(usrnum);
     return(mnupag->parpag[0] == '\0' ? "None" : mnupag->parpag);
}

char *
tvar_mnuttl(void)                  /* current user's menu page title tvbl  */
{
     struct usrmnu *mnupag;

     mnupag=mnuoff(usrnum);
     return(mnupag->curpag[0] == '\0' ? "Logon"
            : mnupag->mnuttl[0] == '\0' ? mnupag->curpag : mnupag->mnuttl);
}

char *
tvar_sydate(void)                  /* current system date text variable    */
{
     return(ncedat(today()));
}

char *
tvar_sytime(void)                  /* current system time text variable    */
{
     return(nctime(now()));
}

char *
tvar_sysnam(void)                  /* system name text variable            */
{
     return(bbsttl);
}

char *
tvar_syscmp(void)                  /* system company name text variable    */
{
     return(company);
}

char *
tvar_sysad1(void)                  /* system adress line 1 text variable   */
{
     return(addres1);
}

char *
tvar_sysad2(void)                  /* system adress line 2 text variable   */
{
     return(addres2);
}

char *
tvar_syspho(void)                  /* system phone text variable           */
{
     return(dataph);
}

char *
tvar_sysrst(void)                  /* system restricted phone text variable*/
{
     return(liveph);
}

char *
tvar_chhour(void)                  /* system charge per hour text variable */
{
     return(chghour);
}

char *
tvar_chgmin(void)                  /* system minimum charge text variable  */
{
     return(chgmin);
}

char *
tvar_regnum(void)                  /* system registration number text var  */
{
     return(bturno);
}

char *
tvar_nmline(void)                  /* system number of lines defined tvar  */
{
     return(spr("%d",nterms));
}

char *
tvar_ninuse(void)                  /* system number of other users online  */
{
     int othusn,retval;
     struct user *othusp;

     retval=0;
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (incusr(othusn,FALSE,FALSE) > VACANT) {
               retval++;
          }
     }
     return(spr("%d",retval));
}

char *
tvar_ncalls(void)                  /* system number of calls to date       */
{
     return(l2as(sv2.totcalls));
}

char *
tvar_dwnlds(void)                  /* system number of downloads to date   */
{
     return(l2as(sv.dwnlds));
}

char *
tvar_nuplds(void)                  /* system number of uploads to date     */
{
     return(l2as(sv.uplds));
}

char *
tvar_msgtot(void)                  /* system number of messages to date    */
{
     return(l2as(sv.msgtot));
}

char *
tvar_sigopn(void)                  /* system number of open forum messages */
{
     return(spr("%u",sv.sigopn));
}

char *
tvar_emlopn(void)                  /* system number of open email messages */
{
     return(spr("%u",sv.emlopn));
}

char *
tvar_numact(void)                  /* system total number of user accounts */
{
     return(spr("%u",sv2.numact));
}

char *
tvar_nummal(void)                  /* system total number of male accounts */
{
     return(spr("%u",sv2.numact-sv2.numfem));
}

char *
tvar_numfem(void)                  /* system total number of female accts  */
{
     return(spr("%u",sv2.numfem));
}

char *
tvar_numcor(void)                  /* system total number of corporate usrs*/
{
     return(spr("%u",sv2.numcor));
}

char *
tvar_numans(void)                  /* system total number of ANSI users    */
{
     return(spr("%u",sv2.numans));
}

char *
tvar_vrsion(void)                  /* BBS version                          */
{
     return(version);
}

char *
tvar_minonl(void)                  /* current user's minutes online        */
{                                  /* (just number, see also tvar_timonl())*/
     int mins;

     mins=(usrptr->minut4+2)/4;
     return(spr("%d",mins));
}

