/***************************************************************************
 *                                                                         *
 *   PLBTVSTF.C                                                            *
 *                                                                         *
 *   Copyright (c) 1987-1995 GALACTICOMM, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This file contains a library of routines for accessing BTRIEVE files  *
 *   with fixed or variable length records, compatible with the Phar Lap   *
 *   286 DOS extender protected mode environment.                          *
 *                                                                         *
 *                                            - T. Stryker 3/7/90          *
 *   Dup Ins/Upd, File Create, Misc others    - S. Brinker/R. Skurnick     *
 *   Phar Lap 286 Extender support            - R. A. Rose 12/19/91        *
 *   Locking/transaction support              - TJS/CLR/RLS 6/18/94        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "plstuff.h"
#include "dos.h"

#define FILREV "$Revision:   1.0.1.0.1.0  $"

int _plmerror=0;              /* Last Phar Lap Memory Error                */

int btrlgrec=0;               /* largest record size                       */

extern
jmp_buf disaster;             /* master error-recovery longjmp save block  */

struct btvblk *bb;                      /* current btvu file pointer set   */
static struct btvblk *bbstk[BBSTSZ];    /* setbtv()/rstbtv() stack         */
static int status;                      /* status code returned by btvu()  */
static int bbomode=PRIMBV;              /* opnbtv() file-open mode         */
static char *gpbptr;                    /* general purpose buffer pointer  */
static int gpbseg;                      /* real-mode segment of the above  */
static int *statusptr;                  /* status code returned by btvu()  */
static int statusseg;                   /* real-mode segment of the above  */
static int lastlen;                     /* length of last record read in   */

struct filspc {               /* Btrieve STAT command file spec            */
     int reclen;
     int pagsiz;
     int numofx;
     long numofr;
     int flags;
     int reserved;
     int unupag;
};

struct keyspc {               /* Btrieve STAT command key specs            */
     int keypos;
     int keylen;
     int flags;
     long numofk;
     int dontcare;
     long reserved;
};
#define ANOSEG  0x10          /* keyspc.flags bit for key has another seg  */

struct statbf {               /* STAT command ret buf layout               */
     struct filspc fs;
     struct keyspc ks[SEGMAX];
     char altcol[265];
};

static
struct btvdat {   /* btrieve parameter block structure for use with INT 0x7B */
     int datbufoff;
     int datbufseg;
     int dbflen;
     int posp38off;
     int posp38seg;
     int posblkoff;
     int posblkseg;
     int funcno;
     int keyoff;
     int keyseg;
     char keylen;
     char keyno;
     int statptoff;
     int statptseg;
     int magic;
} *btvdatptr;
static int btvdatseg;              /* real-mode segment of the above       */

void eclint(int inum,REGS16 *regs);
int btvu(int funcno,int datbufseg,int keyseg,int keyno,int rlen);
void maksur(int size);
int clckln(void);
STATIC void posbtverr(char *recptr,char *stg);
STATIC void btverr(char *who);

int (*btvuptr)(int funcno,int datbufseg,int keyseg,int keyno,int rlen)=btvu;
void (*btverrptr)(char *who)=btverr;
                                   /* vector for low level Btrieve funcs   */

void
eclalcrem(                         /* allocate real-mode dynamic memory    */
int size,                          /*   (make both real seg and selector)  */
int *seg,
char **sel)
{
     SEL pmsel;
     int rv;

     DosBlockIntr();
     if ((rv=DosAllocRealSeg((ULONG)size,(PUSHORT)seg,&pmsel)) != 0) {
          DosUnblockIntr();
          catastro("REAL-MODE MEMORY POOL EXHAUSTED (rv=%d, %d bytes)",rv,size);
     }
     DosUnblockIntr();
     *sel=MK_FP(pmsel,0);
     return;
}

BTVFILE *
opnbtv(                            /* open a Btrieve file; return ptr.     */
char *filnam,                      /* name of file to open                 */
int maxlen)                        /* maximum length of recs in file       */
{
     return(opnbtvl(filnam,maxlen,NULL));
}

BTVFILE *
opnbtvl(                           /* open a Btr file low lvl; return ptr. */
char *filnam,                      /* name of file to open                 */
int maxlen,                        /* maximum length of recs in file       */
char *owner)                       /* owner name of Btr file (NULL if none)*/
{
     int tptr;
     static char *ownbuf;
     static int obfseg=0;

     if (obfseg == 0) {
          eclalcrem(16,&obfseg,&ownbuf);
     }
     if (maxlen > btrlgrec) {
          btrlgrec=maxlen;
     }
     if (statusptr == NULL) {
          eclalcrem(sizeof(int),&statusseg,(char **)&statusptr);
          eclalcrem(sizeof(struct btvdat),&btvdatseg,(char **)&btvdatptr);
     }
     eclalcrem(sizeof(struct btvblk),&tptr,(char **)&bb);
     bb->realseg=tptr;

     bb->filnam=alcmem(strlen(filnam)+1);
     strcpy(bb->filnam,filnam);
     bb->reclen=maxlen;
     maksur(bb->reclen);
     bb->data=alcmem(maxlen);
     maksur(strlen(filnam)+1);
     strcpy(gpbptr,filnam);
     if (owner == NULL) {
          setmem(ownbuf,16,0);
     }
     else {
          stzcpy(ownbuf,owner,9);
     }
     while ((*btvuptr)(0,obfseg,gpbseg,bbomode,strlen(ownbuf)+1) == 85) {
     }
     if (status != 0) {
          (*btverrptr)("OPEN");
     }
     eclalcrem(clckln(),&bb->keyseg,&bb->key);
     setbtv(bb);
     return(bb);
}

#define GPBP ((struct statbf *)gpbptr)

int
clckln(void)                  /* calculate all key lengths in curr file    */
{                             /*   (and return the max of them all)        */
     static int kbfseg=0;
     int i,keyno,klen,maxofa;
     char *tmp;

     if (kbfseg == 0) {
          eclalcrem(64,&kbfseg,&tmp);
     }
     maksur(sizeof(struct statbf));
     if ((*btvuptr)(15,gpbseg,kbfseg,0,sizeof(struct statbf)) != 0) {
          (*btverrptr)("STAT");
     }
     maxofa=0;
     for (i=0,keyno=0 ; keyno < GPBP->fs.numofx ; i++,keyno++) {
          klen=GPBP->ks[i].keylen;
          while (GPBP->ks[i].flags&ANOSEG) {
               klen+=GPBP->ks[++i].keylen;
          }
          bb->keylns[keyno]=klen;
          if (klen > maxofa) {
               maxofa=klen;
          }
     }
     return(maxofa+1);
}

void
maksur(                       /* make sure that gen purp buff is big enough*/
int size)
{
     static int gpbsiz=0;

     if (size > gpbsiz) {
     /*   if (gpbsiz > 0) {   HACK */
     /*        free(gpbptr);  HACK */
     /*   }                   HACK */
          eclalcrem(size,&gpbseg,&gpbptr);
          gpbsiz=size;
     }
}

void
omdbtv(                       /* set opnbtv() file-open mode               */
int mode)                     /* mode in which to open the btrieve file    */
{
     bbomode=mode;
}

void
setbtv(                       /* set a Btrieve data block for use          */
struct btvblk *bbptr)         /* btrieve pointer to make current           */
{
     movmem(bbstk,bbstk+1,sizeof(struct btvblk *)*(BBSTSZ-1));
     *bbstk=bb;
     bb=bbptr;
}

void
rstbtv(void)                  /* restore last btrieve data block for use   */
{
     bb=*bbstk;
     movmem(bbstk+1,bbstk,sizeof(struct btvblk *)*(BBSTSZ-1));
}

void
bxabtv(                       /* begin transaction                         */
int loktyp)                   /* file lock type for 1st op in transaction  */
{
     if ((*btvuptr)(19+loktyp,0,0,0,0) != 0) {
          (*btverrptr)("BEGIN-XACTION");
     }
}

void
exabtv(void)                  /* end transaction                           */
{
     if ((*btvuptr)(20,0,0,0,0) != 0) {
          (*btverrptr)("END-XACTION");
     }
}

int
qrybtv(                       /* query Btrieve operations utility          */
void *key,                    /* key value to use for query                */
int keynum,                   /* key number to query by                    */
int qryopt)                   /* what type of query operation to perform   */
{
     if (bb == NULL) {
          return(0);
     }
     if (key != NULL) {
          movmem(key,bb->key,goodblk(key,bb->keylns[keynum]));
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if ((*btvuptr)(qryopt,0,bb->keyseg,keynum,bb->reclen) != 0) {
          if (status == 4 || status == 9) {
               return(0);
          }
          (*btverrptr)("QUERY");
     }
     return(1);
}

int
qnpbtv(                       /* query next/previous Btrieve utility       */
int getopt)                   /* what type of query option to perform      */
{
     if (bb == NULL) {
          return(0);
     }
     if ((*btvuptr)(getopt-50,gpbseg,bb->keyseg,bb->lastkn,bb->reclen) != 0) {
          if (status == 4 || status == 9) {
               return(0);
          }
          posbtverr(NULL,"QUERY-NP");
     }
     movmem(gpbptr,bb->data,bb->reclen);
     return(1);
}

void
getbtv(                            /* get Btrieve operations utility       */
void *recptr,                      /* ptr to area to retrieve record into  */
void *key,                         /* key value to use for retrieve record */
int keynum,                        /* key number of key to work with       */
int getopt)                        /* get operation to be performed        */
{
     getbtvl(recptr,key,keynum,getopt,0);
}

void
getbtvl(                           /* get Btrieve operations util (w/lock) */
void *recptr,                      /* ptr to area to retrieve record into  */
void *key,                         /* key value to use for retrieve record */
int keynum,                        /* key number of key to work with       */
int getopt,                        /* get operation to be performed        */
int loktyp)                        /* lock type to use for this operation  */
{
     if (bb == NULL) {
          return;
     }
     if (recptr == NULL) {
          recptr=bb->data;
     }
     if (key != NULL && bb != NULL) {
          movmem(key,bb->key,goodblk(key,bb->keylns[keynum]));
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if ((*btvuptr)(getopt+loktyp,gpbseg,bb->keyseg,keynum,bb->reclen) != 0) {
          posbtverr(recptr,"GET");
     }
     movmem(gpbptr,recptr,btvdatptr->dbflen);
}

int
obtbtv(                            /* "acquire" Btrieve operations utility */
void *recptr,                      /* ptr to area to retrieve record into  */
void *key,                         /* key value to use for retrieve record */
int keynum,                        /* key number of key to work with       */
int obtopt)                        /* get operation to be performed        */
{
     return(obtbtvl(recptr,key,keynum,obtopt,0));
}

int
obtbtvl(                           /* "acquire" operation utility (w/lock) */
void *recptr,                      /* ptr to area to retrieve record into  */
void *key,                         /* key value to use for retrieve record */
int keynum,                        /* key number of key to work with       */
int obtopt,                        /* get operation to be performed        */
int loktyp)                        /* lock type to use for this operation  */
{
     if (bb == NULL) {
          return(0);
     }
     if (recptr == NULL) {
          recptr=bb->data;
     }
     if (key != NULL && bb != NULL) {
          movmem(key,bb->key,goodblk(key,bb->keylns[keynum]));
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if ((*btvuptr)(obtopt+loktyp,gpbseg,bb->keyseg,keynum,bb->reclen) != 0) {
          if (status == 4 || status == 9 || wslbtv()) {
               return(0);
          }
          posbtverr(recptr,"OBTAIN");
     }
     movmem(gpbptr,recptr,btvdatptr->dbflen);
     return(1);
}

int
anpbtv(                       /* "acquire" next/previous (case sensitive)  */
void *recptr,                 /* ptr to area to retrieve record into       */
int anpopt)                   /* operation to be performed                 */
{
     return(anpbtvlk(recptr,1,anpopt,0));
}

int
anpbtvl(                      /* "acquire" next/previous Btrieve utility   */
void *recptr,                 /* ptr to area to retrieve record into       */
int chkcas,                   /* check case in strcmp() operation?         */
int anpopt)                   /* operation to be performed                 */
{
     return(anpbtvlk(recptr,chkcas,anpopt,0));
}

int
anpbtvlk(                     /* "acquire" next/previous utility (w/ lock) */
void *recptr,                 /* ptr to area to retrieve record into       */
int chkcas,                   /* check case in strcmp() operation?         */
int anpopt,                   /* operation to be performed                 */
int loktyp)                   /* lock type to use for this operation       */
{
     if (bb == NULL) {
          return(0);
     }
     movmem(bb->key,bb->data,bb->keylns[bb->lastkn]);
     if (obtbtvl(recptr,NULL,-1,anpopt,loktyp)) {
          return(chkcas ? strcmp(bb->data,bb->key) == 0
                        : stricmp(bb->data,bb->key) == 0);
     }
     return(0);
}

int
llnbtv(void)                  /* return the length of the last record read */
{
     return(lastlen);
}

long
absbtv(void)                  /* return current Btrieve file position      */
{
     if (bb == NULL) {
          return(0L);
     }
     maksur(sizeof(long));
     if ((*btvuptr)(22,gpbseg,0,0,sizeof(long)) != 0) {
          (*btverrptr)("ABSOLUTE");
     }
     return(*(long *)gpbptr);
}

void
gabbtv(                       /* get Btrieve record from a file position   */
void *recptr,                 /* ptr to area to retrieve record into       */
long abspos,                  /* absolute position to used for get-absolute*/
int keynum)                   /* key number to use for this get-absolute   */
{
     gabbtvl(recptr,abspos,keynum,0);
}

void
gabbtvl(                      /* get Btrieve record from file pos (w/lock) */
void *recptr,                 /* ptr to area to retrieve record into       */
long abspos,                  /* absolute position to used for get-absolute*/
int keynum,                   /* key number to use for this get-absolute   */
int loktyp)                   /* lock type to use for this operation       */
{
     if (bb == NULL) {
          return;
     }
     if (!aabbtvl(recptr,abspos,keynum,loktyp)) {
          posbtverr(recptr,"GET-ABSOLUTE");
     }
}

int
aabbtv(                       /* "acquire" a record from a file position   */
void *recptr,                 /* ptr to area to retrieve record into       */
long abspos,                  /* absolute position to used for acq-absolute*/
int keynum)                   /* key number to use for this acq-absolute   */
{
     return(aabbtvl(recptr,abspos,keynum,0));
}

int
aabbtvl(                      /* "acquire" a record from file pos (w/lock) */
void *recptr,                 /* ptr to area to retrieve record into       */
long abspos,                  /* absolute position to used for acq-absolute*/
int keynum,                   /* key number to use for this acq-absolute   */
int loktyp)                   /* lock type to use for this operation       */
{
     if (bb == NULL) {
          return(0);
     }
     if (recptr == NULL) {
          recptr=bb->data;
     }
     *(long *)gpbptr=abspos;
     bb->lastkn=keynum;
     (*btvuptr)(23+loktyp,gpbseg,bb->keyseg,keynum,bb->reclen);
     if (status == 22) {
          gpbptr[bb->reclen-1]='\0';
          status=0;
     }
     if (status == 0) {
          movmem(gpbptr,recptr,btvdatptr->dbflen);
     }
     return(status == 0);
}

int
stpbtv(                       /* "step" based btrieve operations           */
void *recptr,                 /* ptr to area to retrieve record into       */
int stpopt)                   /* step option to be performed               */
{
     return(stpbtvl(recptr,stpopt,0));
}

int
stpbtvl(                      /* "step" based btrieve operations           */
void *recptr,                 /* ptr to area to retrieve record into       */
int stpopt,                   /* step option to be performed               */
int loktyp)                   /* lock type to use for this operation       */
{
     if (recptr == NULL) {
          recptr=bb->data;
     }
     if ((*btvuptr)(stpopt+loktyp,gpbseg,NULL,0,bb->reclen) != 0) {
          if (status == 9 || wslbtv()) {
               return(0);
          }
          else {
               posbtverr(recptr,"STEP");
          }
     }
     movmem(gpbptr,recptr,btvdatptr->dbflen);
     return(1);
}

void
updbtv(                       /* "update" a Btrieve record                 */
void *recptr)                 /* ptr to area for record update             */
{
     upvbtv(recptr,bb->reclen);
}

void
upvbtv(                       /* "update" a variable-length Btrieve record */
void *recptr,                 /* ptr to area for record update             */
int length)                   /* length of data buffer for updating        */
{
     if (bb == NULL) {
          return;
     }
     if (recptr == NULL) {
          recptr=bb->data;
     }
     maksur(length);
     movmem(recptr,gpbptr,goodblk(recptr,length));
     if ((*btvuptr)(3,gpbseg,bb->keyseg,bb->lastkn,length) != 0) {
          (*btverrptr)("UPDATE");
     }
}

int
dupdbtv(                      /* "update" w/ no catastro's for duplicates  */
void *recptr)                 /* does not support variable length records  */
{
     int length;

     length=bb->reclen;
     if (recptr == NULL) {
          recptr=bb->data;
     }
     maksur(length);
     movmem(recptr,gpbptr,goodblk(recptr,length));
     switch ((*btvuptr)(3,gpbseg,bb->keyseg,bb->lastkn,length)) {
     case 0:
          return(1);
     case 5:
          return(0);
     default:
          (*btverrptr)("UPDATE");
          return(0);
     }
}

void
insbtv(                       /* insert a new Btrieve record               */
void *recptr)
{
     invbtv(recptr,bb->reclen);
}

void
invbtv(                       /* insert new variable length Btrieve record */
void *recptr,
int length)
{
     if (bb == NULL) {
          return;
     }
     if (recptr == NULL) {
          recptr=bb->data;
     }
     maksur(length);
     movmem(recptr,gpbptr,goodblk(recptr,length));
     if ((*btvuptr)(2,gpbseg,bb->keyseg,0,length) != 0) {
          (*btverrptr)("INSERT");
     }
}

int
dinsbtv(                      /* "insert" w/ no catastro's for duplicates  */
void *recptr)                 /* does not support variable length records  */
{
     int length;

     length=bb->reclen;
     if (recptr == NULL) {
          recptr=bb->data;
     }
     maksur(length);
     movmem(recptr,gpbptr,goodblk(recptr,length));
     switch ((*btvuptr)(2,gpbseg,bb->keyseg,0,length)) {
     case 0:
          return(1);
     case 5:
          return(0);
     default:
          (*btverrptr)("INSERT");
          return(0);
     }
}

void
delbtv(void)                  /* delete the current Btrieve record         */
{
     if (bb == NULL) {
          return;
     }
     if ((*btvuptr)(4,0,0,bb->lastkn,bb->reclen) != 0) {
          (*btverrptr)("DELETE");
     }
}

void
clsbtv(                       /* close specified Btrieve file              */
struct btvblk *bbp)
{
     char *filnam;

     if (goodptr(bb=bbp) && bb->filnam != NULL) {
          filnam=bb->filnam;
          bb->filnam=NULL;
          if ((*btvuptr)(1,0,0,0,0) != 0) {
               catastro("BTRIEVE CLOSE ERROR %d ON FILE \"%s\"",status,filnam);
          }
          DosFreeSeg(FP_SEG(bb->key));
          free(bb->data);
          free(filnam);
          DosFreeSeg(FP_SEG(bb));
     }
}

void
crtbtv(                                 /* create a btrieve file           */
char *filnam,                           /* name of file to be created      */
void *databuf,                          /* buffer holding creation parms   */
int lendbuf,                            /* length of data buffer           */
int keyno)                              /* parameter used in creating file */
{
     int tptr;
     BTVFILE *crtbb=NULL;

     eclalcrem(sizeof(BTVFILE),&tptr,(char **)&crtbb);
     setmem(crtbb,sizeof(BTVFILE),0);
     crtbb->realseg=tptr;
     crtbb->reclen=lendbuf;
     maksur(lendbuf);
     movmem(databuf,gpbptr,goodblk(databuf,lendbuf));
     eclalcrem(strlen(filnam)+1,&crtbb->keyseg,&crtbb->key);
     strcpy(crtbb->key,filnam);
     setbtv(crtbb);
     if ((*btvuptr)(14,gpbseg,crtbb->keyseg,keyno,crtbb->reclen) != 0) {
          crtbb->filnam=filnam;
          (*btverrptr)("CREATE");
     }
     rstbtv();
     DosFreeSeg(FP_SEG(crtbb->key));
     DosFreeSeg(FP_SEG(crtbb));
}

#define GIBP ((struct statbf *)gpbptr)

long
cntrbtv(void)                 /* get number of records in a btrieve file   */
{
     static int kbfseg=0;
     char *tmp;

     if (kbfseg == 0) {
          eclalcrem(64,&kbfseg,&tmp);
     }
     maksur(sizeof(struct statbf));
     if ((*btvuptr)(15,gpbseg,kbfseg,0,sizeof(struct statbf)) != 0) {
          (*btverrptr)("STAT");
     }
     return(GIBP->fs.numofr);
}

int
rlenbtv(void)                 /* Record length of a btrieve file           */
{
     static int kbfseg=0;
     char *tmp;

     if (kbfseg == 0) {
          eclalcrem(64,&kbfseg,&tmp);
     }
     maksur(sizeof(struct statbf));
     if ((*btvuptr)(15,gpbseg,kbfseg,0,sizeof(struct statbf)) != 0) {
          (*btverrptr)("STAT");
     }
     return(GIBP->fs.reclen);
}

void
unlbtv(                            /* unlock record(s) operation           */
long abspos,                       /* absolute position for multiple locks */
int keynum)                        /* unlock key number (flavor of unlock) */
{
     if (keynum == -1) {
          maksur(sizeof(long));
          *(long *)gpbptr=abspos;
          (*btvuptr)(27,gpbseg,0,keynum,sizeof(long));
     }
     else {
          (*btvuptr)(27,0,0,keynum,0);
     }
     if (status != 0) {
          (*btverrptr)("UNLOCK");
     }
}

int
wslbtv(void)                       /* op failed cuz record/file was locked */
{
     switch (status) {
     case 84:                           /* record already locked           */
     case 85:                           /* file locked                     */
          return(1);
     }
     return(0);
}

STATIC void
posbtverr(                         /* possible btrieve error               */
char *recptr,                      /*  (don't crash on overflow, truncate) */
char *stg)
{
     if (status != 22) {
          (*btverrptr)(stg);
     }
     if (recptr == NULL) {
          bb->data[bb->reclen-1]='\0';
     }
     else {
          gpbptr[bb->reclen-1]='\0';
     }
     status=0;
}

STATIC void
btverr(                       /* print out any btrieve error messages      */
char *who)                    /* (default value for (*btverrptr)())        */
{
     char buff[40];

     sprintf(buff,"%s ERROR %d",who,status);
     catastro("BTRIEVE %s ON FILE \"%s\"",buff,bb->filnam);
}

int
btvu(                                    /* underlying Btrieve cmd interface */
int funcno,                              /* (default value for (*btvuptr)()) */
int datbufseg,
int keyseg,
int keyno,
int rlen)
{
     REGS16 eclregs;
     static int btrvup=0,alrcat=0;

     if (!btrvup) {
          memset(&eclregs,0,sizeof(REGS16));
          eclregs.ax=0x357B;
          eclint(0x21,&eclregs);
          if (eclregs.bx != 0x33) {
               if (alrcat) {
                    return(0);
               }
               alrcat=1;
               catastro("Run BTRIEVE first, before running this program!");
          }
          btrvup=1;
     }
     btvdatptr->datbufoff=0;
     btvdatptr->datbufseg=datbufseg;
     btvdatptr->dbflen=rlen;
     btvdatptr->posp38off=38;
     btvdatptr->posp38seg=bb->realseg;
     btvdatptr->posblkoff=0;
     btvdatptr->posblkseg=bb->realseg;
     btvdatptr->funcno=funcno;
     btvdatptr->keyoff=0;
     btvdatptr->keyseg=keyseg;
     btvdatptr->keylen=(char)255;
     btvdatptr->keyno=(char)keyno;
     btvdatptr->statptoff=0;
     btvdatptr->statptseg=statusseg;
     *statusptr=0;
     btvdatptr->magic=24950;
     memset(&eclregs,0,sizeof(REGS16));
     eclregs.dx=0;
     eclregs.ds=btvdatseg;
     eclint(0x7B,&eclregs);
     lastlen=btvdatptr->dbflen;
     return(status=*statusptr);
}

void
eclint(                            /* protected to real interrupt          */
int inum,
REGS16 *regs)
{
     DosRealIntr(inum,regs,0L,0);
}
