/***************************************************************************
 *                                                                         *
 *   PHASEDBG.H                                                            *
 *                                                                         *
 *   Copyright (c) 1994-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Track the phases of the server, for better debugging, tracking, etc.  *
 *   Do this by bracketing important phases or application-specific        *
 *   processing with BEG_PHASE() and END_PHASE() macros.  These            *
 *   macros generate no code if DEBUG is not #-defined.  They generate     *
 *   interceptable vector calls if DEBUG is turned on.                     *
 *                                                                         *
 *                                            - R. Stein 10/14/94          *
 *                                                                         *
 ***************************************************************************/

#define NUMPHS 16                  /* phase beginnings & endings tracked   */

struct phasedbg {                  /* phase tracking information           */
     char *name;                   /* name of phase                        */
     long num;                     /* phase-specific number or pointer     */
     int usrnum;                   /* user number (usrnum)                 */
     int usrcls;                   /* user meta-state (usrptr->class)      */
     int usrsta;                   /* user state (usrptr->state)           */
     int usrsbs;                   /* user substate (usrptr->substt)       */
     int flags;                    /* see below                            */
};

#define PDBBEG 0x0001              /* on=begin, off=end                    */

#ifdef DEBUG
#define BEG_PHASE(name,num) (*beg_phase)(name,(long)num)
#define END_PHASE(name,num) (*end_phase)(name,(long)num)
#else
#define BEG_PHASE(name,num) ((void)0)
#define END_PHASE(name,num) ((void)0)
#endif

extern
void (*beg_phase)(char *name,long num);           /* BEG_PHASE() vector    */
extern
void (*end_phase)(char *name,long num);           /* END_PHASE() vector    */

void
rptphs(                            /* report on the past NUMPHS phases     */
FILE *fp);                         /* file to send report to (FOPWA-opened)*/

struct phasedbg *
pstphs(                            /* get information on a past phase      */
int index);                        /* 0=most recent, NUMPHS-1=earliest     */
                                   /* returns pointer to phasedbg struct   */
                                   /* or NULL=phase debugging not enabled  */

