/***************************************************************************
 *                                                                         *
 *   INTEGROU.H                                                            *
 *                                                                         *
 *   Copyright (c) 1992-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   These routines perform the dynamic integration functions built into   *
 *   MenuTree.                                                             *
 *                                                                         *
 *     void iniint(void);          initialize module integrator biz        *
 *     char **avlmods(BOOL csedit);return an array of ptrs to module names *
 *     void clrefs(void);          clear all module reference counts       *
 *     void incref(char *modnam);  increment count of references to modnam *
 *     void decref(char *modnam);  decrement count of references to modnam *
 *     void finint(void);          write MJRBBS.CFG, MDF.REF, BBSINT.REF,  *
 *                                      and ACTMDFS.LST                    *
 *     void reqchk(void);          just the "required" check from finint() *
 *                                 1=ok, 0=missing required modules        *
 *                                                                         *
 *   It is recommended to call iniint() prior to opening BBSMENU.DAT, and  *
 *   to call finint() after closing BBSMENU.DAT.  The rest of the time,    *
 *   avlmods() provides a list of the available module names.  incref()    *
 *   should be called each time an additional reference is made to one     *
 *   of these modules, and decref() should be called each time an existing *
 *   reference is deleted.  This way, when the number of references to a   *
 *   module drops to zero, it will be removed from MJRBBS.CFG.  reqchk()   *
 *   need not be called unless not calling finint() and BBSREQ.FLG exists. *
 *   The reqchk() routine provides a quick check of the "required:"        *
 *   relations between MDF files and pops up a warning window if           *
 *   "required" mods are not present.                                      *
 *                                                                         *
 *   General plan of attack: if MDF files or BBSMENU.DAT have changed      *
 *   since the last time finint() was called, reconstruct MJRBBS.CFG.      *
 *   Do this by reading in all MDF data, checking for duplicate module     *
 *   names (and resolving any conflicts on the spot through pop-up menus   *
 *   and such), then making sure that our module reference counts can      *
 *   be relied upon (which consists of making sure that MDF.REF matches    *
 *   the latest version of BBSMENU.DAT and using its reference counts if   *
 *   so; otherwise re-tallying them from scratch).  Upon exit, eliminate   *
 *   duplicate DLL's and write Btrieve data and DLL list to MJRBBS.CFG.    *
 *   BBSINT.REF is a record of all the .MDF date/time/size info present    *
 *   when MJRBBS.CFG was written, and ACTMDFS.LST is a list of the         *
 *   currently active .MDFs (those not "replaced"), for use by BBSFNDO     *
 *   and CNF.                                                              *
 *                                                                         *
 *   Note: clrefs() should only be called when the caller is about to      *
 *   make a complete pass through all menu pages, calling incref() as      *
 *   appropriate to reconstruct the complete reference count array.        *
 *                                                                         *
 *                                            - T. Stryker 2/12/92         *
 *                                                                         *
 ***************************************************************************/

#define DNMSIZ  (24+1)        /* developer name size                       */
#define DELIMS ", \t;"        /* valid delimiters for DLL & EXE lists      */
#define MAXDLL 5              /* max # of DLL's per MDF                    */
#define MAXMDF 5              /* max # of MDF's in required/replaces/etc.  */
#define ALLMDF "Everyone"     /* keyword for "all MDF's"                   */
#define MMMODN "Menuing System" /* Main Menu's module name (no MDF for it) */

extern
int nmdfs;                    /* number of modules found in .MDF files     */
extern
int nmods;                    /* number of modules referenced altogether   */
extern
char **modnmv;                /* list of module names from .MDF files      */

extern
struct moddat {               /* module data                               */
     char modnam[MNMSIZ];     /* module name in English                    */
     char mdfnam[FNSIZE];     /* module definition (.MDF) file name/csappid*/
     char devnam[DNMSIZ];     /* developer name                            */
     char instal[FNSIZE];     /* install-utility name (if exists)          */
     char usrtxt[FNEXSZ];     /* addition to online user manual (if exists)*/
     char dllnam[MAXDLL][FNSIZE];  /* DLL's constituting this module       */
     char mdfreq[MAXMDF][FNSIZE];  /* MDF's required to run this module    */
     char mdfrep[MAXMDF][FNSIZE];  /* MDF's replaced by this module        */
     char ineed[MAXMDF][FNSIZE];   /* mods that this one needs to be init'd*/
     char needme[MAXMDF][FNSIZE];  /* mods that need this one to be init'd */
     char defico[FNSIZE];     /* default icon name if any (.ICO assumed)   */
     int flags;               /* fun facts to know and tell                */
     int btrsiz;              /* size of Btrieve buffer this module needs  */
     int btrfls;              /* number of Btrieve files this module needs */
     int nrefs;               /* no. of references in MenuTree to this guy */
     struct lingo *lp;        /* language information, if any              */
     char *msgs;              /* dynamic list of .MSG file names           */
} *moddat;                    /* dynam alloc'd array of module data        */

                              /* moddat "flags" bits:                      */
#define UNCOND  0x01          /* unconditionally include DLL's at run time */
#define INTERN  0x02          /* "internal" module; don't show in MenuTree */
#define REQUIR  0x04          /* this MDF's DLL's are required by somebody */
#define HASCLX  0x08          /* this MDF has a client-side EXE            */
#define ISINRF  0x10          /* this MDF is already recorded in BBSINT.REF*/
#define CSONLY  0x20          /* this MDF is "internal" to ASCII/ANSI      */
#define CSTART  0x40          /* this MDF is a C/S "startup app"           */
#define HADIND  0x80          /* this MDF had an "I need" line in it       */

extern
struct refstf {               /* reference-count (MDF.REF) file header     */
     int nmods;               /* number of moddat structs after the fndblk */
     struct fndblk fb;        /* time/date etc. of BBSMENU.DAT this tracks */
} refstf;

void iniint(void);            /* initialize module integrator biz          */
char **avlmods(BOOL csedit);  /* return an array of ptrs to module names   */
void clrefs(void);            /* clear all module reference counts         */
void incref(char *modnam);    /* increment count of references to modnam   */
void decref(char *modnam);    /* decrement count of references to modnam   */
void finint(void);            /* write MJRBBS.CFG, MDF.REF, BBSINT.REF,    */
                              /*        and BBSMDFS.LST                    */
void wrtmjr(void);            /* writes MJRBBS.CFG                         */
void reqchk(void);            /* just the "required" check from finint()   */
int refsok(void);             /* module references ok? (1 or 0)            */
void ctrefs(void);            /* re-count module references                */
char *gtmdfnam(char *appname);/* given module name, return mdf name        */
void markfile(char *filname,struct fndblk *fb,BOOL fromend);
                              /* mark file with BBSMENU.DAT's fndblk  */

#define MISSREQ "BBSREQ.FLG"  /* file to signal missing required modules   */
