/***************************************************************************
 *                                                                         *
 *   GMEUTL.H                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This file contains declarations for common and utility functions used *
 *   by and for the GME (from GMEUTL.C and GMEONL.C)                       *
 *                                                                         *
 *                                           - J. Alvrus   8/4/94          *
 *                                                                         *
 ***************************************************************************/

#define GMEMDF "GALME.MDF"         /* GME .MDF file name                   */
#define XINFSZ 1024                /* extended return info buffer size     */

                                   /* general-purpose GME states           */
#define START    0                 /*   starting state for all GME requests*/
#define READING  1                 /*   reading something                  */
#define WRITING  2                 /*   writing something                  */
#define SRCHING  3                 /*   searching for something            */

struct rdctx {                     /* message reading context              */
     int seq;                      /*   sequence in use                    */
     unsigned fid;                 /*   current forum ID                   */
     long mid;                     /*   current message ID                 */
     long tid;                     /*   current thread ID                  */
     char uid[UIDSIZ];             /*   User-ID doing reading              */
};

struct qikwork {                   /* !QUICK list distribution state info  */
     int qikctr;                   /*   index of last addr used            */
     struct qikdat *qikbuf;        /*   pointer to !QUICK list buffer      */
};

struct msswork {                   /* !MASS list distribution state info   */
     long fpos;                    /*   accbb file position                */
     BOOL more;                    /*   is there another address?          */
};

struct syswork {                   /* sysop list distribution state info   */
     FILE *fp;                     /*   list file                          */
     long fpos;                    /*   list file position                 */
};

union diststf {                    /* dist list state info structure       */
     struct qikwork q;
     struct msswork m;
     struct syswork s;
};

struct gmework {                   /* GME per-request work area            */
     int state1;                   /*   state of current level 1 request   */
     int state2;                   /*   state of current level 2 request   */
     int state3;                   /*   state of current level 3 request   */
     int flags;                    /*   flags field                        */
     void (*callback)(int,int);    /*   callback handler for request status*/
     FILE *fp;                     /*   source or general use file         */
     FILE *fpout;                  /*   destination file                   */
     long fpos;                    /*   general use file position          */
     long rdfpos;                  /*   btrieve file pos of current msg    */
     long basechg;                 /*   base or total write-message charge */
     long rcpchg;                  /*   what to charge recip for autofwd   */
     long attsiz;                  /*   size of attachment                 */
     long orgmid;                  /*   original message ID                */
     long dstprim;                 /*   msg ID of primary distributed msg  */
     int attchg;                   /*   charge for attachment              */
     int apkchg;                   /*   per-k charge for attachment        */
     int rrrchg;                   /*   charge for return receipt          */
     int prichg;                   /*   charge for "priority"              */
     int orgflg;                   /*   original message flags             */
     int tmpflg;                   /*   temporary storage for flags        */
     int counter;                  /*   general use counter                */
     int fdfnum;                   /*   forum data file being examined     */
     int reclen;                   /*   general use record length          */
     int echonum;                  /*   echo number being processed        */
     unsigned rqid;                /*   request ID of this work area       */
     unsigned orgfor;              /*   original forum ID of message       */
     unsigned cfdate;              /*   copied file date stamp             */
     unsigned cftime;              /*   copied file time stamp             */
     unsigned char dstdly;         /*   distribution delay counter         */
     struct otscan *curscn;        /*   scan context of work area          */
     char *ccptr;                  /*   current cc: list position          */
     char dlstnam[DLNMSZ];         /*   current dist list name             */
     char auxto[UIDSIZ];           /*   auxiliary to field (for autofwd)   */
     char auxhist[HSTSIZ];         /*   auxiliary history field (for dist) */
     char orgatt[MAXPATH];         /*   original attachment path+file name */
     char auxatt[MAXPATH];         /*   auxiliary attachment name          */
     char cpyatt[MAXPATH];         /*   destination path when copying atts */
     struct rdctx rdctx;           /*   read context of work area          */
     union diststf d;              /*   distribution state info buffer     */
     unsigned antirq;              /*   bitwise inverse of request ID      */
};
                                   /* work area flags                      */
#define ADROK    0x0001            /*   to address is valid & accessible   */
#define ATTOK    0x0002            /*   ok to attach a file to message     */
#define RRROK    0x0004            /*   ok to request return receipt       */
#define PRIOK    0x0008            /*   ok to send message as priority     */
#define QIKLST   0x0010            /*   message is to !QUICK dist list     */
#define MASSLST  0x0020            /*   message is to !MASS dist list      */
#define SYSLST   0x0040            /*   message is to sysop dist list      */
#define CPY2E    0x0080            /*   copy forum message to E-mail       */
#define FWDMSG   0x0100            /*   message being auto-forwarded       */
#define CYCFLG   0x0200            /*   cycle necessary                    */
#define NOECHO   0x0400            /*   do not echo this message           */
#define PRIMDONE 0x8000            /*   finished writing "primary" message */

extern
unsigned _reclen;                  /* message file record length           */
extern
FILE *gmemb;                       /* GME CNF options file block pointer   */
extern
char *utltxt;                      /* GME utility message text buffer      */
extern
struct message *utlmsg;            /* GME utility message header structure */
extern
struct gmework *utlwork;           /* GME utility work area                */
extern
struct fordef *utldef;             /* GME utility forum definition         */
extern
char *extinf;                      /* extended return information buffer   */
extern
unsigned hirqidx;                  /* highest request array index          */
extern
char *gmerqarr;                    /* pointer to open request array        */
extern
int ngmelk;                        /* number of slots in lock array        */
extern
struct gmelock {                   /* GME lock structure                   */
     unsigned rqid;                /*   request ID associated with lock    */
     unsigned forum;               /*   forum ID locked                    */
     long msgid;                   /*   message ID locked                  */
} *gmelkarr;                       /* pointer to lock array                */
extern
unsigned numsl;                    /* number of sysop dist lists           */
extern
struct slinfo {                    /* sysop dist list info structure       */
     char name[DLNMSZ];            /*   list name                          */
     char key[KEYSIZ];             /*   list key                           */
     int surchg;                   /*   list surcharge                     */
} *losl;                           /* array of sysop dist list info structs*/

void
iniutl(void);                      /* initialize GME utilities             */

void
clsutl(void);                      /* close GME utilities                  */

void
addrq(                             /* add request to list of OK requests   */
struct gmework *work);             /*   pointer to request work area       */

void
remrq(                             /* remove request from OK list          */
struct gmework *work);             /*   pointer to request work area       */

void
callback(                          /* call callback handler if any         */
struct gmework *work,              /*   being used by this work area       */
int evt,                           /*   event to report                    */
int res,                           /*   result code to report              */
char *info);                       /*   string to put in extinf            */

BOOL                               /*   returns TRUE if a conflict         */
gmecfl(                            /* check for any conflict               */
struct gmework *work,              /*   work area in use                   */
unsigned forum,                    /*   forum ID w/possible conflict       */
long msgid);                       /*   message ID w/possible conflict     */

BOOL                               /*   was lock successful?               */
gmelok(                            /* put a lock on a message or forum     */
struct gmework *work,              /*   work area associated w/lock        */
unsigned forum,                    /*   forum ID to lock                   */
long msgid);                       /*   message ID to lock                 */

void
gmeulk(                            /* unlock a message or forum            */
struct gmework *work,              /*   work area associated w/lock        */
unsigned forum,                    /*   forum ID to lock                   */
long msgid);                       /*   message ID to lock                 */

void
gmeulkr(                           /* remove all locks assoc with a request*/
struct gmework *work);             /*   work area associated w/request     */

void
hdlntfy(                           /* handle new message notification hook */
char *ntfytyp,                     /*   notification type string           */
struct gmework *work,              /*   work area in use                   */
struct message *msg);              /*   header of new message              */

struct qscfg *                     /*   pointer to quickscan data          */
othqsp(                            /* get a user's quickscan configuration */
char *uid);                        /*   User-ID to find                    */
                                   /* (for one-cycle, no qscbb access only)*/

int                                /*   returns index or NOIDX if none     */
qsoldest(                          /* get oldest real entry w/ or w/out acc*/
struct qscfg *qsc);                /*   pointer to quickscan               */

long
newmid(void);                      /* generate a new message ID            */

long
cmptid(                            /* compute thread ID                    */
struct message *msg);              /*   message header                     */

long
emltid(                            /* generate an E-mail thread ID         */
struct message *msg);              /*   message header (to,from,topic)     */

long
fortid(                            /* generate a forum thread ID           */
struct message *msg);              /*   message header (topic)             */

void
addhist(                           /* add to message history               */
char *history,                     /*   current history string             */
char *newhist);                    /*   string to add                      */

BOOL                               /*   returns FALSE if couldn't open     */
opn4cpy(                           /* open files for copy                  */
struct gmework *work,              /*   work area to open files for        */
char *srcfil);                     /*   source file name                   */
                                   /*   (work->cpyatt is always dest)      */

int                                /*   returns standard GME status codes  */
copychunk(                         /* cycled file copy utility             */
struct gmework *work);             /*   work area in use                   */

void
wracc(                             /* write access level in compressd array*/
char *acarpt,                      /*   pointer to access-level array      */
int value,                         /*   value to write                     */
int idx);                          /*   index in array                     */

int
acclvl(                            /* get acc level from compressed array  */
char *acarpt,                      /*   pointer to array                   */
int idx);                          /*   index of access level              */

void
cantopen(                          /* audit failed file open               */
char *fname,                       /*   file that couldn't be opened       */
BOOL waswrt);                      /*   was the open for write             */

int                                /*   returns appropriate GME work flag  */
dlstyp(                            /* get dist list type                   */
char *to);                         /*   given to address                   */

int                                /*   returns standard GME status codes  */
inidist(                           /* initialize sending a dist list       */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg);              /*   new message structure              */

BOOL                               /*   returns TRUE there was another     */
nxtdist(                           /* get next entry in dist list          */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg);              /*   message header structure           */

void
clsdist(                           /* finish up distribution               */
struct gmework *work);             /*   GME work space (provided by caller)*/

BOOL                               /*   returns TRUE if started OK         */
inimssnd(                          /* start up !MASS dist                  */
struct gmework *work);             /*   work area to initialize            */

BOOL                               /*   returns TRUE if started OK         */
nxtmass(                           /* get next !MASS entry                 */
struct gmework *work,              /*   work area to use                   */
char *addr);                       /*   buffer for address                 */

void
clsmass(                           /* shut down !MASS distribution         */
struct gmework *work);             /*   work area used                     */

void
inilosl(void);                     /* initialize list of sysop lists       */

BOOL                               /*   returns TRUE if list added         */
add2losl(                          /* add to list of sysop dist lists      */
char *lstnam,                      /*   list name                          */
char *lstkey,                      /*   list key                           */
int lstchg);                       /*   list surcharge                     */

BOOL                               /*   returns TRUE if started OK         */
inislsnd(                          /* start up sysop list dist             */
struct gmework *work,              /*   work area to initialize            */
char *lstnam);                     /*   name of list                       */

void
clssys(                            /* close sysop distribution list        */
struct gmework *work);             /*   work area in use                   */

int
dlstidx(                           /* get index of list in list of lists   */
char *name);                       /*   sysop list name                    */

FILE *                             /*   returns file pointer               */
opndlst(                           /* open a sysop dist list file          */
char *name,                        /*   complete name (including @)        */
char *mode);                       /*   open mode to use                   */

char *                             /*   returns pointer to path & file name*/
dlstpfn(                           /* get path & file name of dist list    */
char *name);                       /*   complete name (including @)        */

void
clrfrom(                           /* "clear" from field of message        */
struct message *msg);              /*   message to clear                   */

void
uclfrom(                           /* un-"clear" from field of message     */
struct message *msg);              /*   message to unclear                 */

void
clrto(                             /* "clear" to field of message          */
struct message *msg);              /*   message to clear                   */

void
uclto(                             /* un-"clear" to field of message       */
struct message *msg);              /*   message to unclear                 */

char
lwclch(                            /* reversable clobber/unclobber of char */
char c);                           /*   character to clobber/unclobber     */

BOOL
isfnmc(                            /* is this a valid file name character? */
char c);                           /*   character to check                 */

char *                             /*   copy of pointer to destination     */
prf2str(                           /* copy prfbuf contents to a string     */
char *str,                         /*   string to copy into                */
unsigned len);                     /*   length of string                   */

char *                             /*   copy of pointer to string          */
new2ret(                           /* replace '\n' with '\r' in string     */
char *str);                        /*   string to replace                  */

BOOL                               /*   returns TRUE if string was found   */
strsrep(                           /* replace a stg in a stg w/ a stg      */
char *stg,                         /*   the string to search               */
char *from,                        /*   the string to be replaced          */
char *to);                         /*   the string to replace with         */

BOOL
gmeoffl(void);                     /* is the GME running in offline mode?  */

#ifdef DEBUG
BOOL
seqok(                             /* check for valid sequence code        */
int sequence,                      /*   sequence code                      */
int forum);                        /*   forum ID                           */

BOOL
ctxok(                             /* check for valid context setup        */
struct rdctx *ctx);                /*   context structure                  */
#endif
