/***************************************************************************
 *                                                                         *
 *   GMEOFF.C                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This file contains routines necessary to use the GME in offline       *
 *   utilities.                                                            *
 *                                                                         *
 *                                           - J. Alvrus   6/9/94          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gme.h"
#include "gmeutl.h"
#include "gmeloc.h"
#include "gmeoff.h"

#define FILREV "$Revision:   1.0.1.0.1.0  $"

int nterms;                        /* number of channels (always 1)        */

struct sysvbl sv;                  /* global system vars (loaded and saved)*/

static
BTVFILE *svbb;                     /* Btrieve file ptr for system vars     */

void
iniogme(void)                      /* initialize offline GME               */
{
     nterms=1;
     svbb=opnbtv("bbsvbl.dat",sizeof(struct sysvbl));
     stzcpy(sv.key,"key",sizeof(sv.key));
     geqbtv(&sv,sv.key,0);
     inimsg(OPTSIZE);
     iniutl();
     iniloc();
}

void
clsogme(                           /* close down offline GME               */
BOOL updfors)                      /*   update all the Forums on disk?     */
{
     clsloc(updfors);
     clsutl();
     setbtv(svbb);
     geqbtv(NULL,sv.key,0);
     updbtv(&sv);
     clsbtv(svbb);
}

BOOL
gmeoffl(void)                      /* is the GME running in offline mode?  */
{
     return(TRUE);
}

char *
getmsg(                            /* get a message                        */
int msgnum)                        /*   ...by message number               */
{
     return(rawmsg(msgnum));
}

void
shocst(                            /* offline stub for the real shocst()   */
char *tex1,                        /*   first line of audit entry          */
char *tex2,                        /*   second line of audit entry         */
char *parm1,                       /*   printf()-style parameters          */
char *parm2,
char *parm3)
{
     (void)tex1;
     (void)tex2;
     (void)parm1;
     (void)parm2;
     (void)parm3;
}

BOOL                               /*   returns TRUE if a conflict         */
gencfl(                            /* stub for the real gencfl()           */
void *workb,                       /*   work area in use                   */
unsigned forum,                    /*   forum ID to check                  */
long msgid)                        /*   msg ID to check (0L for forum only)*/
{
     (void)workb;
     (void)forum;
     (void)msgid;
     return(FALSE);
}

BOOL                               /*   was lock successful?               */
gmelok(                            /* stub for the real gmelok()           */
struct gmework *work,              /*   work area associated w/lock        */
unsigned forum,                    /*   forum ID to lock                   */
long msgid)                        /*   message ID to lock                 */
{
     (void)work;
     (void)forum;
     (void)msgid;
     return(TRUE);
}

void
gmeulk(                            /* stub for the real gmeulk()           */
struct gmework *work,              /*   work area associated w/lock        */
unsigned forum,                    /*   forum ID to unlock                 */
long msgid)                        /*   message ID to unlock               */
{
     (void)work;
     (void)forum;
     (void)msgid;
}

void
gmeulkr(                           /* stub for the real gmeulkr()          */
struct gmework *work)              /*   work area associated w/request     */
{
     (void)work;
}

void
clsdist(                           /* stub for the real clsdist()          */
struct gmework *work)              /*   GME work space (provided by caller)*/
{
     (void)work;
}
