/***************************************************************************
 *                                                                         *
 *   GMECORE.C                                                             *
 *                                                                         *
 *   Copyright (c) 1994-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Galacticomm Messaging Engine core.  It contains interface *
 *   functions for other modules to access GME, and other core functions.  *
 *                                                                         *
 *                                            - J. Alvrus   6/13/94        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "galme.h"
#include "gme.h"
#include "gmeutl.h"
#include "gmeloc.h"
#include "gmecore.h"
#include "datutils.h"

#define FILREV "$Revision:   1.0.1.2.1.5  $"

/* GME State Codes */
#define DISTING  SRCHING+1
#define WRTPRIM  SRCHING+2
#define NXTDIST  SRCHING+3
#define SNDEXP   SRCHING+4
#define SNDIST   SRCHING+5
#define SNDECHO  SRCHING+6
#define SNDLOC   SRCHING+7
#define CPYEML   SRCHING+8
#define WRTECPY  SRCHING+9
#define UPDORG   SRCHING+10
#define STRTCPY  SRCHING+11
#define COPYATT  SRCHING+12
#define SENDOFF  SRCHING+13
#define DELETNG  SRCHING+14
#define GETOUT   SRCHING+15
#define GENRRR   SRCHING+16
#define REGET    SRCHING+17
#define GOWRITE  SRCHING+18
#define NXTECHO  SRCHING+19
#define STARTCC  SRCHING+20
#define NEXTCC   SRCHING+21
#define CCACPY   SRCHING+22
#define WRITCC   SRCHING+23
#define DISTCC   SRCHING+24

#define anycc(s) ((s) != NULL && *(s) != '\0')

extern
char msysid[SIDSIZ];               /* 4-byte system ID (from GCSPSRV.C)    */

int nexp=0;                        /* number of registered exporters       */
struct exporter **exphlr=NULL;     /* array of registered exporters        */

/* Forum CNF options */
int forccr,                   /* default forum credit consumption rate     */
    forlif,                   /* default lifetime of a forum message (days)*/
    fmschg,                   /* default credit charge to write forum msg  */
    fmrchg,                   /* default credit charge to read forum msg   */
    fulchg,                   /* default credit charge per file upload     */
    fkuchg,                   /* default per-kbyte charge per file upload  */
    fdlchg,                   /* default credit charge per file download   */
    fkdchg;                   /* default per-kbyte charge per file download*/
BOOL fopmfd,                  /* allow forum-ops to modify forum defs?     */
     fdnaud,                  /* do audit trail entry for each forum dnld? */
     fupaud,                  /* do audit trail entry for each forum upld? */
     autqsc;                  /* automatically have new forums in qscfgs?  */
char *forsys,                 /* Sysop privileged forum usage key          */
     *forprv;                 /* privileged forum usage key                */
unsigned dftfor;              /* default forum ID                          */

/* E-mail CNF options */
unsigned char dstdly;         /* cycle-based distribution delay            */
int emschg,                   /* credit charge per E-mail msg written      */
    eatchg,                   /* additional charge for attachment          */
    epkchg,                   /* additional per-kbyte charge for attachment*/
    rrrchg,                   /* additional charge for return receipt      */
    prichg,                   /* additional charge for priority message    */
    lstchg,                   /* credit charge for using distribution list */
    emrchg,                   /* credit charge per E-mail msg read         */
    edachg,                   /* charge for attachment download            */
    edkchg,                   /* per-kbyte charge for attachment download  */
    dfpref;                   /* default user preferences                  */
BOOL supu2s,                  /* signups generate E-mail to Sysop?         */
     supe2u,                  /* signups generate E-mail to user?          */
     e2urrr,                  /* ret. rec. on new-user E-mail if enabled   */
     alweat,                  /* allow E-mail file attachments?            */
     alwrrr,                  /* allow E-mail return receipts requests?    */
     alwpri,                  /* allow priority E-mail messages?           */
     chgfwd,                  /* charge recipient for auto-forward charges */
     ednaud,                  /* do audit trail entry for each E-mail dnld?*/
     eupaud,                  /* do audit trail entry for each E-mail upld?*/
     strxck;                  /* do strict exporter prefix checking        */
char *nuemtp,                 /* topic of new-user E-mail to sysop         */
     *e2utpc,                 /* topic of new-user E-mail to user          */
     *e2uatt,                 /* attachment to E-mail to user              */
     *e2uanm,                 /* name of attachment to E-mail to user      */
     *emlkey,                 /* key required to write E-mail              */
     *eatkey,                 /* key required to upload E-mail attachments */
     *rrrkey,                 /* key required to request return receipts   */
     *prikey,                 /* key required to send priority messages    */
     *qikkey,                 /* key required to use !QUICK list           */
     *massky,                 /* key required to use !MASS list            */
     *edstky,                 /* key required to edit sysop-defined lists  */
     *rrtpc;                  /* return receipt topic                      */

/* other CNF options */
char dlstpth[MAXPATH];        /* path to sysop distribution lists          */

/* special function hooks */
BOOL (*hdlimphook)(struct message *,char *,char *)=NULL;
                                   /* redirect imported message hook       */
void (*newmsghook)(char *,struct message *,char *)=NULL;
                                   /* new message notification hook        */

STATIC void ck4gpf(void);
STATIC void emlnewu(void);

void
inicore(void)                      /* initialize GME core module           */
{
     normspec(dlstpth,rawmsg(DLSTPTH));
     forccr=numopt(FORCCR,-32767,32767);
     forlif=numopt(FORLIF,-1,32767);
     fmschg=numopt(FMSCHG,-32767,32767);
     fmrchg=numopt(FMRCHG,-32767,32767);
     fulchg=numopt(FULCHG,-32767,32767);
     fkuchg=numopt(FKUCHG,-32767,32767);
     fdlchg=numopt(FDLCHG,-32767,32767);
     fkdchg=numopt(FKDCHG,-32767,32767);
     fopmfd=ynopt(FOPMFD);
     autqsc=ynopt(AUTQSC);
     forsys=stgopt(FORSYS);
     forprv=stgopt(FORPRV);
     fdnaud=ynopt(FDNAUD);
     fupaud=ynopt(FUPAUD);
     if ((dftfor=getfid(getmsg(DFTFOR))) == EMLID) {
          catastro("Default forum \"%s\" does not exist!  Check Level 4 CNF option DFTFOR",
                   getmsg(DFTFOR));
     }
     dfpref=0;
     if (ynopt(DFCARP)) {
          dfpref|=CLARPL;
     }
     switch (tokopt(DFLONP,"NEVER","PROMPT","ALWAYS",NULL)) {
     case 3:
          dfpref|=GORTIN;
     case 2:
          dfpref|=P4NEWM;
     }
     if (ynopt(DFFORP)) {
          dfpref|=FORUM2;
     }
     switch (tokopt(DFQUOP,"NEVER","PROMPT","ALWAYS",NULL)) {
     case 3:
          dfpref|=ALWQUO;
     case 2:
          dfpref|=MSGQUO;
     }
     if (!ynopt(DFBRWP)) {
          dfpref|=CMBHDR;
     }
     switch (tokopt(DFCMTP,"NEVER","PROMPT","ALWAYS",NULL)) {
     case 3:
          dfpref|=ALWCMT;
     case 2:
          dfpref|=CFWCMT;
     }
     supu2s=ynopt(SUPU2S);
     if (supu2s) {
          nuemtp=stgopt(NUEMTP);
     }
     supe2u=ynopt(SUPE2U);
     if (supe2u) {
          e2utpc=stgopt(E2UTPC);
          e2uatt=stgopt(E2UATT);
          e2uanm=stgopt(E2UANM);
          e2urrr=ynopt(E2URRR);
     }
     emlkey=stgopt(EMLKEY);
     emschg=numopt(EMSCHG,-32767,32767);
     eatkey=stgopt(EATKEY);
     eatchg=numopt(EATCHG,-32767,32767);
     epkchg=numopt(EPKCHG,-32767,32767);
     rrrkey=stgopt(RRRKEY);
     rrrchg=numopt(RRRCHG,-32767,32767);
     prikey=stgopt(PRIKEY);
     prichg=numopt(PRICHG,-32767,32767);
     qikkey=stgopt(QIKKEY);
     massky=stgopt(MASSKY);
     edstky=stgopt(EDSTKY);
     lstchg=numopt(LSTCHG,0,32767);
     dstdly=(unsigned char)numopt(DSTDLY,0,255);
     alweat=ynopt(ALWEAT);
     alwrrr=ynopt(ALWRRR);
     alwpri=ynopt(ALWPRI);
     chgfwd=ynopt(CHGFWD);
     eupaud=ynopt(EUPAUD);
     stpans(rrtpc=stgopt(RRTPC));
     emrchg=numopt(EMRCHG,-32767,32767);
     edachg=numopt(EDACHG,-32767,32767);
     edkchg=numopt(EDKCHG,-32767,32767);
     ednaud=ynopt(EDNAUD);
     if (emlsdrou == NULL) {
          emlsdrou=emlnewu;
     }
     strxck=ynopt(STRXCK);
     rtkick(1,ck4gpf);
}

STATIC void
ck4gpf(void)                  /* send email to sysop if GP.FLG exists      */
{
     if (fnd1st(&gmefb,"GP.FLG",0)) {
          setmem(utlmsg,sizeof(struct message),0);
          utlmsg->forum=EMLID;
          strcpy(utlmsg->from,"Sysop");
          strcpy(utlmsg->to,"Sysop");
          strcpy(utlmsg->topic,"Reboot occurred after GP");
          utlmsg->flags=FILATT+FILAPV+FILIND;
          strcpy(utlmsg->attname,"GP.OUT");
          setmbk(gmemb);
          stlcpy(utltxt,getmsg(GPNOTI),TXTLEN);
          rstmbk();
          inigmerq(utlwork);
          while (gsndmsg(utlwork,utlmsg,utltxt,"GP.OUT") == GMEAGAIN) {
               /* this is OK here since it's only once, at startup */
          }
          unlink("GP.FLG");
     }
}

STATIC void
emlnewu(void)                      /* send E-mail regarding new user       */
{
     int svcl;
     char *tmps;

     setmbk(gmemb);
     svcl=clingo;
     clingo=0;
     if (supu2s) {
          setmem(utlmsg,sizeof(struct message),0);
          utlmsg->forum=EMLID;
          stlcpy(utlmsg->from,usaptr->userid,UIDSIZ);
          strcpy(utlmsg->to,"Sysop");
          stlcpy(utlmsg->topic,nuemtp,TPCSIZ);
          utlmsg->flags=NOMOD+NODEL;
          prfmsg(NUEMHD);
          shwusr(usaptr);
          new2ret(prf2str(utltxt,TXTLEN));
          inigmerq(utlwork);
          while (gsndmsg(utlwork,utlmsg,utltxt,NULL) == GMEAGAIN) {
               /* prefer not to do this but don't have option to cycle */
          }
          if (onsys(utlmsg->to)) {
               prfmlt(NEWUEM,usaptr->userid);
               injoth();
          }
     }
     if (supe2u) {
          setmem(utlmsg,sizeof(struct message),0);
          utlmsg->forum=EMLID;
          ininew(utlmsg);
          strcpy(utlmsg->from,"Sysop");
          stlcpy(utlmsg->to,usaptr->userid,UIDSIZ);
          stlcpy(utlmsg->topic,e2utpc,TPCSIZ);
          utlmsg->thrid=cmptid(utlmsg);
          tmps=NULL;
          utlmsg->flags=(e2urrr ? RECREQ : 0L);
          if (*e2uatt != '\0') {
               utlmsg->flags|=(FILATT+FILAPV+FILIND);
               stlcpy(utlmsg->attname,e2uanm,FLNSIZ);
               tmps=e2uatt;
          }
          stlcpy(utltxt,getmsg(E2UTXT),TXTLEN);
          inigmerq(utlwork);
          while (gme1wnm(utlwork,utlmsg,utltxt,tmps) == GMEAGAIN) {
               /* prefer not to do this but don't have option to cycle */
          }
          *utlwork->cpyatt='\0';
          clsgmerq(utlwork);
     }
     clingo=svcl;
}

int                                /*   returns standard GME status codes  */
inifdef(                           /* initialize forum def w/defaults      */
void *workb,                       /*   GME work space (provided by caller)*/
struct fordsk *newdef)             /*   memory area to initialize          */
{
     int rc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(newdef != NULL);
     switch (work->state3) {
     case START:
          if (!haskey(forsys)) {
               clsgmerq(work);
               return(GMEACC);
          }
          setmem(newdef,sizeof(struct fordsk),0);
          stlcpy(newdef->forop,usaptr->userid,UIDSIZ);
          stlcpy(newdef->attpath,DFFAPTH,MAXDIR);
          stlcpy(newdef->forlok,forprv,KEYSIZ);
          newdef->dfnpv=DFDFNPV;
          newdef->dfprv=DFDFPRV;
          newdef->mxnpv=DFMXNPV;
          newdef->msglif=forlif;
          newdef->chgmsg=fmschg;
          newdef->chgatt=fulchg;
          newdef->chgadl=fdlchg;
          newdef->ccr=forccr;
          newdef->pfnlvl=DFTPFN;
          work->state3=SRCHING;
     case SRCHING:
          rc=recfdf(work,newdef->datfil);
          if (rc != GMEAGAIN) {
               clsgmerq(work);
          }
          return(rc);
     default:
          catastro("GME level 3 state corrupted in inifdef(), state=%d",
                   work->state3);
     }
     return(GMEERR);
}

int                                /*   returns standard GME status codes  */
creatfor(                          /* create a new forum                   */
void *workb,                       /*   GME work space (provided by caller)*/
struct fordsk *newdef,             /*   new forum definition structure     */
char *desc,                        /*   descriptive text                   */
char *echoes)                      /*   pointer to array of echo addresses */
{                                  /*   (may be NULL if no echoes)         */
     int rc;
     struct gmework *work=(struct gmework *)workb;

     #ifdef DEBUG
          int i;
          adr_t *tmpecho;
     #endif
     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(newdef != NULL);
     ASSERT(desc != NULL);
     ASSERT(strlen(newdef->name) > 0 && strlen(newdef->name) < FORNSZ);
     ASSERT(strlen(newdef->forop) > 0 && strlen(newdef->forop) < UIDSIZ);
     ASSERT(strlen(newdef->datfil) > 0 && strlen(newdef->datfil) < MAXPATH);
     ASSERT(strlen(newdef->attpath) < MAXDIR);
     #ifdef DEBUG
          if (newdef->necho > 0) {
               ASSERT(newdef->necho <= MAXECHO);
               ASSERT(echoes != NULL);
               tmpecho=(adr_t *)echoes;
               for (i=0 ; i < newdef->necho ; ++i) {
                    ASSERT(strlen(tmpecho[i]) < MAXADR);
               }
          }
     #endif
     ASSERT(strlen(desc) < MAXFDESC);
     ASSERT(strlen(desc)+newdef->necho*MAXADR < MAXFDV);
     ASSERT(!(newdef->dfprv&1) && newdef->dfprv >= NOAXES
         && newdef->dfprv <= (haskey(forsys) ? OPAXES : COAXES));
     ASSERT(!(newdef->mxnpv&1) && newdef->mxnpv >= NOAXES
         && newdef->mxnpv <= (haskey(forsys) ? OPAXES : COAXES));
     ASSERT(!(newdef->dfnpv&1) && newdef->dfnpv >= NOAXES
         && newdef->dfnpv <= (haskey(forsys) ? OPAXES : COAXES));
     ASSERT(newdef->pfnlvl >= 0 && newdef->pfnlvl <= DFTPFN);
     ASSERT(newdef->necho >= 0 && newdef->necho < MAXECHO);
     switch (work->state3) {
     case START:
          if (!haskey(forsys)) {
               clsgmerq(work);
               return(GMEERR);
          }
          if (fnmxst(newdef->name)) {
               clsgmerq(work);
               return(GMEDUP);
          }
          if (uidxst(newdef->forop)) {
               stlcpy(newdef->forop,accbb->key,UIDSIZ);
          }
          else {
               clsgmerq(work);
               return(GMENFND);
          }
          strupr(newdef->datfil);
          strupr(newdef->attpath);
          strupr(newdef->forlok);
          work->state3=WRITING;
     case WRITING:
          rc=gme1crf(work,newdef,desc,echoes);
          if (rc != GMEAGAIN) {
               clsgmerq(work);
          }
          return(rc);
     default:
          catastro("GME level 3 state corrupted in creatfor(), state=%d",
                   work->state3);
     }
     return(GMEERR);
}

struct fordef *                    /*   pointer to temporary buffer        */
getdefp(                           /* get pointer to forum definition      */
unsigned forum)                    /*   forum ID of def to get             */
{
     return(getdefb(forum,utldef));
}

struct fordef *                    /*   pointer to destination buffer      */
getdefb(                           /* copy forum def into a work buffer    */
unsigned forum,                    /*   forum ID of def to get             */
struct fordef *workdef)            /*   pointer to work buffer             */
{
     struct fordef *tmpdef;

     ASSERT(workdef != NULL);
     tmpdef=getdef(forum);
     if (tmpdef != NULL) {
          movmem(tmpdef,workdef,sizeof(struct fordef));
          return(workdef);
     }
     return(NULL);
}

struct fordef *                    /*   pointer to temporary buffer        */
fiddefp(                           /* ptr to forum def in forum ID order   */
unsigned idx)                      /*   index of forum ID                  */
{
     return(fiddefb(idx,utldef));
}

struct fordef *                    /*   pointer to destination buffer      */
fiddefb(                           /* get forum def in forum ID order      */
unsigned idx,                      /*   index of forum ID                  */
struct fordef *workdef)            /*   pointer to work buffer             */
{
     struct fordef *tmpdef;

     ASSERT(workdef != NULL);
     tmpdef=fiddef(idx);
     if (tmpdef != NULL) {
          movmem(tmpdef,workdef,sizeof(struct fordef));
          return(workdef);
     }
     return(NULL);
}

struct fordef *                    /*   pointer to temporary buffer        */
seqdefp(                           /* get pointer to forum def in sequence */
unsigned seqid)                    /*   sequence ID of forum               */
{
     return(seqdefb(seqid,utldef));
}

struct fordef *                    /*   pointer to destination buffer      */
seqdefb(                           /* get forum def into buffer in sequence*/
unsigned seqid,                    /*   sequence ID of forum               */
struct fordef *workdef)            /*   pointer to work buffer             */
{
     struct fordef *tmpdef;

     ASSERT(workdef != NULL);
     tmpdef=seqdef(seqid);
     if (tmpdef != NULL) {
          movmem(tmpdef,workdef,sizeof(struct fordef));
          return(workdef);
     }
     return(NULL);
}

struct fordef *                    /*   pointer to temporary buffer        */
nxtdefp(                           /* get ptr to next forum definition     */
char *name)                        /*   given name to start with           */
{
     return(nxtdefb(name,utldef));
}

struct fordef *                    /*   pointer to destination buffer      */
nxtdefb(                           /* copy next forum def into a work buf  */
char *name,                        /*   given name to start with           */
struct fordef *workdef)            /*   pointer to work buffer             */
{
     int i;

     ASSERT(workdef != NULL);
     i=nxtfnmi(name);
     if (i != NOIDX) {
          movmem(idxdef(i),workdef,sizeof(struct fordef));
          return(workdef);
     }
     return(NULL);
}

struct fordef *                    /*   pointer to temporary buffer        */
prvdefp(                           /* get ptr to prev forum definition     */
char *name)                        /*   given name to start with           */
{
     return(prvdefb(name,utldef));
}

struct fordef *                    /*   pointer to destination buffer      */
prvdefb(                           /* copy prev forum def into a work buf  */
char *name,                        /*   given name to start with           */
struct fordef *workdef)            /*   pointer to work buffer             */
{
     int i;

     ASSERT(workdef != NULL);
     i=prvfnmi(name);
     if (i != NOIDX) {
          movmem(idxdef(i),workdef,sizeof(struct fordef));
          return(workdef);
     }
     return(NULL);
}

void
getecho(                           /* copy forum's echoes into work buffer */
unsigned forum,                    /*   forum ID to get                    */
char *echoes)                      /*   pointer to work buffer             */
{
     struct fordef *defptr;

     ASSERT(fidxst(forum));
     ASSERT(echoes != NULL);
     defptr=getdef(forum);
     if (defptr->echoes == NULL) {
          *echoes='\0';
     }
     else {
          movmem(defptr->echoes,echoes,MAXADR*defptr->necho);
     }
}

void
getdesc(                           /* copy forum's desc into work buffer   */
unsigned forum,                    /*   forum ID to get                    */
char *desc)                        /*   pointer to work buffer             */
{
     char *tmpptr;

     ASSERT(fidxst(forum));
     ASSERT(desc != NULL);
     if ((tmpptr=gme1fdsc(forum)) == NULL) {
          *desc='\0';
     }
     else {
          stlcpy(desc,tmpptr,MAXFDESC);
     }
}

void
getallf(                           /* get all info about a forum           */
unsigned forum,                    /*   forum ID to get                    */
struct fordsk *workdef,            /*   on-disk forum definition format    */
char *desc,                        /*   buffer for description             */
char *echoes)                      /*   buffer for echoes                  */
{
     ASSERT(fidxst(forum));
     ASSERT(workdef != NULL);
     ASSERT(desc != NULL);
     ASSERT(echoes != NULL);
     gme1afi(forum,workdef,desc,echoes);
}

int                                /*   returns standard GME status codes  */
cfgfacc(                           /* configure default access             */
unsigned forum,                    /*   for this forum                     */
struct foracc *acc)                /*   forum access structure             */
{
     struct fordef *tmpdef;

     ASSERT(fidxst(forum));
     ASSERT(acc != NULL);
     if (foracc(forum) < OPAXES) {
          return(GMEACC);
     }
     tmpdef=getdef(forum);
     tmpdef->dfnpv=(unsigned char)acc->dfnpv;
     tmpdef->dfprv=(unsigned char)acc->dfprv;
     tmpdef->mxnpv=(unsigned char)acc->mxnpv;
     stlcpy(tmpdef->forlok,acc->forlok,KEYSIZ);
     return(GMEOK);
}

int                                /*   returns standard GME status codes  */
modfor(                            /* modify a forum                       */
void *workb,                       /*   GME work space (provided by caller)*/
struct fordef *newdef,             /*   modified forum description         */
char *desc,                        /*   descriptive text                   */
char *echoes)                      /*   pointer to array of echo addresses */
{                                  /*(desc & echoes may be NULL if no chng)*/
     int rc;
     struct gmework *work=(struct gmework *)workb;
     #ifdef DEBUG
     int i;
     adr_t *tmpecho;
     #endif

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(newdef != NULL);
     ASSERT(strlen(newdef->name) > 0 && strlen(newdef->name) < FORNSZ);
     ASSERT(strlen(newdef->forop) > 0 && strlen(newdef->forop) < UIDSIZ);
     #ifdef DEBUG
          if (newdef->necho > 0) {
               ASSERT(newdef->necho <= MAXECHO);
               if (echoes != NULL) {
                    tmpecho=(adr_t *)echoes;
                    for (i=0 ; i < newdef->necho ; ++i) {
                         ASSERT(strlen(tmpecho[i]) < MAXADR);
                    }
               }
          }
          if (desc != NULL) {
               ASSERT(strlen(desc) < MAXFDESC);
               ASSERT(strlen(desc)+newdef->necho*MAXADR < MAXFDV);
          }
     #endif
     ASSERT(newdef->dfprv == getdef(newdef->forum)->dfprv
         || (!(newdef->dfprv&1)
             && newdef->dfprv <= (haskey(forsys) ? OPAXES : COAXES)));
     ASSERT(newdef->mxnpv == getdef(newdef->forum)->mxnpv
         || (!(newdef->mxnpv&1)
             && newdef->mxnpv <= (haskey(forsys) ? OPAXES : COAXES)));
     ASSERT(newdef->dfnpv == getdef(newdef->forum)->dfnpv
         || (!(newdef->dfnpv&1)
             && newdef->dfnpv <= (haskey(forsys) ? OPAXES : COAXES)));
     ASSERT(newdef->pfnlvl <= DFTPFN);
     ASSERT(newdef->necho >= 0 && newdef->necho < MAXECHO);
     switch (work->state3) {
     case START:
          if (!fidxst(newdef->forum)) {
               clsgmerq(work);
               return(GMENFND);
          }
          if (foracc(newdef->forum) < (fopmfd ? OPAXES : SYAXES)) {
               clsgmerq(work);
               return(GMEACC);
          }
          if (gmecfl(work,newdef->forum,0L)) {
               clsgmerq(work);
               return(GMEUSE);
          }
          if (uidxst(newdef->forop)) {
               stlcpy(newdef->forop,accbb->key,UIDSIZ);
          }
          else {
               clsgmerq(work);
               return(GMENFND);
          }
          strupr(newdef->forlok);
          work->state3=WRITING;
     case WRITING:
          if ((rc=gme1modf(work,newdef,desc,echoes)) != GMEAGAIN) {
               clsgmerq(work);
          }
          return(rc);
     default:
          catastro("GME level 3 corrupted state in modfor(), state=%d",
                   work->state3);
     }
     return(GMEERR);
}

int                                /*   returns standard GME status codes  */
delfor(                            /* delete a forum                       */
void *workb,                       /*   GME work space (provided by caller)*/
unsigned forum)                    /*   forum ID to delete                 */
{
     int rc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     switch (work->state3) {
     case START:
          if (!haskey(forsys)) {
               clsgmerq(work);
               return(GMEACC);
          }
          if (forum == dftfor) {
               clsgmerq(work);
               return(GMENDEL);
          }
          if (!fidxst(forum)) {
               clsgmerq(work);
               return(GMENFND);
          }
          if (gmecfl(work,forum,0L)) {
               clsgmerq(work);
               return(GMEUSE);
          }
          work->state3=WRITING;
     case WRITING:
          if ((rc=gme1dlf(work,forum)) != GMEAGAIN) {
               clsgmerq(work);
          }
          return(rc);
     default:
          catastro("GME level 3 state corrupted in delfor(), state=%d",
                   work->state3);
     }
     return(GMEERR);
}

int                                /*   returns VAL code                   */
valadr(                            /* validate address                     */
void *workb,                       /*   GME work space                     */
char *from,                        /*   User-ID writing the message        */
char *to,                          /*   to address                         */
unsigned forum)                    /*   forum message being written in     */
{
     int rc;
     unsigned i;
     struct qscfg *qsc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(to != NULL);
     ASSERT(forum == EMLID || fidxst(forum));
     work->flags&=~ADROK;
     rc=VALNO;
     if (massage(from,to,forum)) {
          if (forum == EMLID && uhskey(from,emlkey)) {
               if (isforum(to)) {
                    ASSERT(getfid(to+1) != EMLID);
                    qsc=othqsp(from);
                    i=getfid(to+1);
                    if (qforac(qsc,i) >= WRAXES) {
                         work->basechg=getdef(i)->chgmsg;
                         if (gtstcrd(from,work->basechg,FALSE)) {
                              work->flags|=ADROK;
                              rc=VALYES;
                         }
                         else {
                              rc=VALCRD;
                         }
                    }
                    else {
                         rc=VALACC;
                    }
               }
               else if (isdlst(to)) {
                    ASSERT(dlstxst(to)); /* massage() should check */
                    if (*to == '@') {
                         if ((work->fp=opndlst(to,FOPRA)) == NULL) {
                              return(VALNO);
                         }
                         fgets((char *)tmpbuf,TMPBSZ,work->fp);
                         if (!sameto(DLKRQS,(char *)tmpbuf)) {
                              rc=VALNO;
                         }
                         else if (uhskey(from,unpad(skpwht(
                                       &((char *)tmpbuf)[sizeof(DLKRQS)-1])))) {
                              fscanf(work->fp,DLCHGS,&work->basechg);
                              if (gtstcrd(from,work->basechg+emschg,FALSE)) {
                                   work->flags|=ADROK;
                                   rc=VALYES;
                              }
                              else {
                                   rc=VALCRD;
                              }
                         }
                         else {
                              rc=VALACC;
                         }
                         fclose(work->fp);
                         work->fp=NULL;
                    }
                    else if (sameas(to,"!quick")) {
                         if (uhskey(from,qikkey)) {
                              work->basechg=lstchg;
                              if (gtstcrd(from,work->basechg+emschg,FALSE)) {
                                   work->flags|=ADROK;
                                   rc=VALYES;
                              }
                              else {
                                   rc=VALCRD;
                              }
                         }
                         else {
                              rc=VALACC;
                         }
                    }
                    else {
                         ASSERT(sameas(to,"!mass"));
                         if (uhskey(from,massky)) {
                              work->basechg=lstchg;
                              if (gtstcrd(from,work->basechg+emschg,FALSE)) {
                                   work->flags|=ADROK;
                                   rc=VALYES;
                              }
                              else {
                                   rc=VALCRD;
                              }
                         }
                         else {
                              rc=VALACC;
                         }
                    }
               }
               else if (isexpa(to)) {
                    ASSERT(expidx(to) != NOIDX);
                    i=expidx(to);
                    if (uhskey(from,exphlr[i]->wrtkey)) {
                         work->basechg=emschg+exphlr[i]->wrtchg;
                         if (gtstcrd(from,work->basechg,FALSE)) {
                              work->flags|=ADROK;
                              rc=VALYES;
                         }
                         else {
                              rc=VALCRD;
                         }
                    }
                    else {
                         rc=VALACC;
                    }
               }
               else {
                    ASSERT(uidxst(to));
                    work->basechg=emschg;
                    if (gtstcrd(from,work->basechg,FALSE)) {
                         work->flags|=ADROK;
                         rc=VALYES;
                    }
                    else if (sameas(to,"sysop")) {
                         work->basechg=0;
                         work->flags|=ADROK;
                         rc=VALYES;
                    }
                    else {
                         rc=VALCRD;
                    }
               }
          }
          else if (forum == EMLID) {
               if (sameas(to,"sysop")) {
                    work->basechg=0;
                    work->flags|=ADROK;
                    rc=VALYES;
               }
               else {
                    rc=VALACC;
               }
          }
          else {
               ASSERT(fidxst(forum));
               qsc=othqsp(from);
               ASSERT(qsc != NULL);
               if (qforac(qsc,forum) >= WRAXES) {
                    work->basechg=getdef(forum)->chgmsg;
                    if (gtstcrd(from,work->basechg,FALSE)) {
                         work->flags|=ADROK;
                         rc=VALYES;
                    }
                    else {
                         rc=VALCRD;
                    }
               }
               else {
                    rc=VALACC;
               }
          }
     }
     return(rc);
}

int                                /*   returns VAL code                   */
valatt(                            /* validate file attachments            */
void *workb,                       /*   GME work space                     */
char *from,                        /*   User-ID writing the message        */
char *to,                          /*   to address                         */
unsigned forum)                    /*   forum message being written in     */
{
     int rc;
     unsigned i;
     struct qscfg *qsc;
     struct fordef *tmpdef;
     struct exporter *tmpexp;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(to != NULL);
     ASSERT(forum == EMLID || fidxst(forum));
     work->flags&=~ATTOK;
     rc=VALNO;
     if (!(work->flags&ADROK)) {
          return(rc);
     }
     if (forum != EMLID || (forum == EMLID && isforum(to))) {
          #ifdef DEBUG
               if (forum == EMLID) {
                    ASSERT(fnmxst(to+1));
               }
          #endif
          qsc=othqsp(from);
          i=(forum == EMLID) ? getfid(to+1) : forum;
          if (qforac(qsc,i) >= ULAXES) {
               tmpdef=getdef(i);
               work->attchg=tmpdef->chgatt;
               work->apkchg=tmpdef->chgupk;
               if (gtstcrd(from,work->basechg+work->attchg+work->apkchg,
                           FALSE)) {
                    work->flags|=ATTOK;
                    rc=VALYES;
               }
               else {
                    rc=VALCRD;
               }
          }
          else {
               rc=VALACC;
          }
     }
     else if (alweat) {
          if (uhskey(from,eatkey)) {
               if (isexpa(to)) {
                    ASSERT(expidx(to) != NOIDX);
                    i=expidx(to);
                    tmpexp=exphlr[i];
                    if (tmpexp->flags&EXPATT) {
                         if (uhskey(from,tmpexp->attkey)) {
                              work->attchg=eatchg+tmpexp->attchg;
                              work->apkchg=epkchg+tmpexp->apkchg;
                              if (gtstcrd(from,work->basechg+work->attchg
                                              +work->apkchg,FALSE)) {
                                   work->flags|=ATTOK;
                                   rc=VALYES;
                              }
                              else {
                                   rc=VALCRD;
                              }
                         }
                         else {
                              rc=VALACC;
                         }
                    }
               }
               else if (isdlst(to)) {
                    work->attchg=0;
                    work->apkchg=0;
                    work->flags|=ATTOK;
                    rc=VALYES;
               }
               else {
                    work->attchg=eatchg;
                    work->apkchg=epkchg;
                    if (gtstcrd(from,work->basechg+work->attchg+work->apkchg,
                                FALSE)) {
                         work->flags|=ATTOK;
                         rc=VALYES;
                    }
                    else {
                         rc=VALCRD;
                    }
               }
          }
          else {
               rc=VALACC;
          }
     }
     return(rc);
}

int                                /*   returns VAL code                   */
valrrr(                            /* validate return receipt request      */
void *workb,                       /*   GME work space                     */
char *from,                        /*   User-ID writing the message        */
char *to,                          /*   to address                         */
unsigned forum)                    /*   forum message being written in     */
{
     int rc;
     struct exporter *tmpexp;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(to != NULL);
     ASSERT(forum == EMLID || fidxst(forum));
     work->flags&=~RRROK;
     rc=VALNO;
     if ((work->flags&ADROK) && forum == EMLID
      && alwrrr && !isforum(to)) {
          if (uhskey(from,rrrkey)) {
               if (isexpa(to)) {
                    ASSERT(expidx(to) != NOIDX);
                    tmpexp=exphlr[expidx(to)];
                    if (tmpexp->flags&EXPRRR) {
                         if (uhskey(from,tmpexp->rrrkey)) {
                              work->rrrchg=rrrchg+tmpexp->rrrchg;
                              if (gtstcrd(from,work->basechg+work->rrrchg,
                                          FALSE)) {
                                   work->flags|=RRROK;
                                   rc=VALYES;
                              }
                              else {
                                   rc=VALCRD;
                              }
                         }
                         else {
                              rc=VALACC;
                         }
                    }
               }
               else if (isdlst(to)) {
                    work->rrrchg=0;
                    work->flags|=RRROK;
                    rc=VALYES;
               }
               else if (gtstcrd(from,work->basechg+(work->rrrchg=rrrchg),
                                FALSE)) {
                    work->flags|=RRROK;
                    rc=VALYES;
               }
               else {
                    rc=VALCRD;
               }
          }
          else {
               rc=VALACC;
          }
     }
     return(rc);
}

int                                /*   returns VAL code                   */
valpri(                            /* validate priority messaging          */
void *workb,              /*   GME work space                     */
char *from,                        /*   User-ID writing the message        */
char *to,                          /*   to address                         */
unsigned forum)                    /*   forum message being written in     */
{
     int rc;
     struct exporter *tmpexp;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(to != NULL);
     ASSERT(forum == EMLID || fidxst(forum));
     work->flags&=~PRIOK;
     rc=VALNO;
     if ((work->flags&ADROK) && forum == EMLID
      && alwpri && !isforum(to)) {
          if (uhskey(from,prikey)) {
               if (isexpa(to)) {
                    ASSERT(expidx(to) != NOIDX);
                    tmpexp=exphlr[expidx(to)];
                    if (tmpexp->flags&EXPPRI) {
                         if (uhskey(from,tmpexp->prikey)) {
                              work->prichg=prichg+tmpexp->prichg;
                              if (gtstcrd(from,work->basechg+work->prichg,
                                          FALSE)) {
                                   work->flags|=PRIOK;
                                   rc=VALYES;
                              }
                              else {
                                   rc=VALCRD;
                              }
                         }
                         else {
                              rc=VALACC;
                         }
                    }
               }
               else if (isdlst(to)) {
                    work->prichg=0;
                    work->flags|=PRIOK;
                    rc=VALYES;
               }
               else if (gtstcrd(from,work->basechg+(work->prichg=prichg),
                                FALSE)) {
                    work->flags|=PRIOK;
                    rc=VALYES;
               }
               else {
                    rc=VALCRD;
               }
          }
          else {
               rc=VALACC;
          }
     }
     return(rc);
}

int                                /*   returns VAL code                   */
vfwdadr(                           /* validate address for forwarding      */
void *workb,                       /*   GME work space                     */
char *from,                        /*   User-ID doing the forwarding       */
char *to,                          /*   address to forward to              */
unsigned forum)                    /*   forum message being written in     */
{
     int rc;
     unsigned i;
     struct qscfg *qsc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(to != NULL);
     ASSERT(forum == EMLID || fidxst(forum));
     work->flags&=~ADROK;
     rc=VALNO;
     if (massage(from,to,forum)) {
          if (forum == EMLID && uhskey(from,emlkey)) {
               if (isforum(to)) {
                    ASSERT(getfid(to+1) != EMLID);
                    qsc=othqsp(from);
                    i=getfid(to+1);
                    if (qforac(qsc,i) >= WRAXES) {
                         if (chgfwd) {
                              work->basechg=getdef(i)->chgmsg-emschg;
                              work->basechg=max(work->basechg,0L);
                         }
                         else {
                              work->basechg=0L;
                         }
                         if (gtstcrd(from,work->basechg,FALSE)) {
                              work->flags|=ADROK;
                              rc=VALYES;
                         }
                         else {
                              rc=VALCRD;
                         }
                    }
                    else {
                         rc=VALACC;
                    }
               }
               else if (isdlst(to)) {
                    rc=VALNO;
               }
               else if (isexpa(to)) {
                    ASSERT(expidx(to) != NOIDX);
                    i=expidx(to);
                    if (uhskey(from,exphlr[i]->wrtkey)) {
                         if (chgfwd) {
                              work->basechg=max(exphlr[i]->wrtchg,0L);
                         }
                         else {
                              work->basechg=0L;
                         }
                         if (gtstcrd(from,work->basechg,FALSE)) {
                              work->flags|=ADROK;
                              rc=VALYES;
                         }
                         else {
                              rc=VALCRD;
                         }
                    }
                    else {
                         rc=VALACC;
                    }
               }
               else {
                    ASSERT(uidxst(to));
                    work->basechg=0L;
                    work->flags|=ADROK;
                    rc=VALYES;
               }
          }
          else if (forum == EMLID) {
               if (sameas(to,"sysop")) {
                    work->basechg=0;
                    work->flags|=ADROK;
                    rc=VALYES;
               }
               else {
                    rc=VALACC;
               }
          }
          else {
               ASSERT(fidxst(forum));
               qsc=othqsp(from);
               if (qforac(qsc,forum) >= WRAXES) {
                    if (chgfwd) {
                         work->basechg=getdef(forum)->chgmsg-emschg;
                         work->basechg=max(work->basechg,0L);
                    }
                    else {
                         work->basechg=0L;
                    }
                    if (gtstcrd(from,work->basechg,FALSE)) {
                         work->flags|=ADROK;
                         rc=VALYES;
                    }
                    else {
                         rc=VALCRD;
                    }
               }
               else {
                    rc=VALACC;
               }
          }
     }
     return(rc);
}

int                                /*   returns VAL code                   */
vfwdatt(                           /* validate attachment for forwarding   */
void *workb,                       /*   GME work space                     */
char *from,                        /*   User-ID writing the message        */
char *to,                          /*   to address                         */
unsigned forum)                    /*   forum message being written in     */
{
     int rc;
     unsigned i;
     struct qscfg *qsc;
     struct fordef *tmpdef;
     struct exporter *tmpexp;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(to != NULL);
     ASSERT(forum == EMLID || fidxst(forum));
     work->flags&=~ATTOK;
     rc=VALNO;
     if (!(work->flags&ADROK)) {
          return(rc);
     }
     if (forum != EMLID || (forum == EMLID && isforum(to))) {
          #ifdef DEBUG
               if (forum == EMLID) {
                    ASSERT(fnmxst(to+1));
               }
          #endif
          qsc=othqsp(from);
          i=(forum == EMLID) ? getfid(to+1) : forum;
          if (qforac(qsc,i) >= ULAXES) {
               tmpdef=getdef(i);
               if (chgfwd) {
                    work->attchg=tmpdef->chgatt-eatchg;
                    work->apkchg=tmpdef->chgupk-epkchg;
                    work->attchg=max(work->attchg,0);
                    work->apkchg=max(work->apkchg,0);
               }
               else {
                    work->attchg=0;
                    work->apkchg=0;
               }
               if (gtstcrd(from,work->basechg+work->attchg+work->apkchg,
                           FALSE)) {
                    work->flags|=ATTOK;
                    rc=VALYES;
               }
               else {
                    rc=VALCRD;
               }
          }
          else {
               rc=VALACC;
          }
     }
     else if (alweat) {
          if (uhskey(from,eatkey)) {
               if (isexpa(to)) {
                    ASSERT(expidx(to) != NOIDX);
                    i=expidx(to);
                    tmpexp=exphlr[i];
                    if (tmpexp->flags&EXPATT) {
                         if (uhskey(from,tmpexp->attkey)) {
                              if (chgfwd) {
                                   work->attchg=max(tmpexp->attchg,0);
                                   work->apkchg=max(tmpexp->apkchg,0);
                              }
                              else {
                                   work->attchg=0;
                                   work->apkchg=0;
                              }
                              if (gtstcrd(from,work->basechg+work->attchg
                                              +work->apkchg,FALSE)) {
                                   work->flags|=ATTOK;
                                   rc=VALYES;
                              }
                              else {
                                   rc=VALCRD;
                              }
                         }
                         else {
                              rc=VALACC;
                         }
                    }
               }
               else if (isdlst(to)) {
                    rc=VALNO;
               }
               else {
                    work->attchg=0;
                    work->apkchg=0;
                    work->flags|=ATTOK;
                    rc=VALYES;
               }
          }
          else {
               rc=VALACC;
          }
     }
     return(rc);
}

int                                /*   returns VAL code                   */
vfwdpri(                           /* validate priority message for fwding */
void *workb,                       /*   GME work space                     */
char *from,                        /*   User-ID writing the message        */
char *to,                          /*   to address                         */
unsigned forum)                    /*   forum message being written in     */
{
     int rc;
     struct exporter *tmpexp;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(to != NULL);
     ASSERT(forum == EMLID || fidxst(forum));
     work->flags&=~PRIOK;
     rc=VALNO;
     if ((work->flags&ADROK) && forum == EMLID
      && alwpri && !isforum(to)) {
          if (uhskey(from,prikey)) {
               if (isexpa(to)) {
                    ASSERT(expidx(to) != NOIDX);
                    tmpexp=exphlr[expidx(to)];
                    if (tmpexp->flags&EXPPRI) {
                         if (uhskey(from,tmpexp->prikey)) {
                              if (chgfwd) {
                                   work->prichg=max(tmpexp->prichg,0);
                              }
                              else {
                                   work->prichg=0;
                              }
                              if (gtstcrd(from,work->basechg+work->prichg,
                                          FALSE)) {
                                   work->flags|=PRIOK;
                                   rc=VALYES;
                              }
                              else {
                                   rc=VALCRD;
                              }
                         }
                         else {
                              rc=VALACC;
                         }
                    }
               }
               else if (isdlst(to)) {
                    rc=VALNO;
               }
               else {
                    work->flags|=PRIOK;
                    rc=VALYES;
               }
          }
          else {
               rc=VALACC;
          }
     }
     return(rc);
}

void
clrwrt(                            /* clr write-specific flds of work area */
struct gmework *work)              /*   GME work space in use              */
{
     work->flags&=~(ADROK|ATTOK|RRROK|PRIOK|FWDMSG|CPY2E|SYSLST|QIKLST
                    |MASSLST|CYCFLG|PRIMDONE);
     work->basechg=0L;
     work->rcpchg=0L;
     work->attchg=0;
     work->apkchg=0;
     work->rrrchg=0;
     work->prichg=0;
     *work->cpyatt='\0';
}

int                                /*   returns standard GME status codes  */
gsndmsg(                           /* send message (non-user specific)     */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt)                      /*   path+file name of att (if any)     */
{
     int rc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     ASSERT(strlen(text) < TXTLEN);
     ASSERT(msg->forum == EMLID || fidxst(msg->forum));
     switch (work->state3) {
     case START:
          chkrqs(work,msg);
          chkfor(msg);
          iniamsg(msg);
          work->state3=WRITING;
          if (msg->flags&FILATT) {
               if (msg->forum == EMLID && isexpa(msg->to)) {
                    stlcpy(work->cpyatt,expasp(msg->to,msg),MAXPATH);
                    if (msg->flags&FILIND) {
                         work->state3=STRTCPY;
                         return(GMEAGAIN);
                    }
                    if (sameas(normspec((char *)tmpbuf,filatt),
                               normspec((char *)tmpbuf+MAXPATH,work->cpyatt))) {
                         stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                    }
                    else {
                         unlink(work->cpyatt);
                         if (rename(filatt,work->cpyatt) == 0) {
                              stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                         }
                         else {
                              work->state3=STRTCPY;
                              return(GMEAGAIN);
                         }
                    }
               }
               else {
                    stlcpy(work->auxatt,filatt,MAXPATH);
                    *work->cpyatt='\0';
               }
          }
     case WRITING:
          rc=gme2wnm(work,msg,text,work->auxatt);
          if (rc != GMEAGAIN) {
               if (rc > GMEAGAIN) {
                    hdlntfy(WRITENOT,work,msg);
               }
               clsgmerq(work);
          }
          return(rc);
     case STRTCPY:
          work->state3=COPYATT;
          if (!opn4cpy(work,filatt)) {
               clsgmerq(work);
               return(GMENOAT);
          }
     case COPYATT:
          rc=copychunk(work);
          if (rc > GMEAGAIN) {
               work->state3=WRITING;
               if (!(msg->flags&FILIND)) {
                    unlink(filatt);
               }
               stlcpy(work->auxatt,work->cpyatt,MAXPATH);
               rc=GMEAGAIN;
          }
          else if (rc < GMEAGAIN) {
               clsgmerq(work);
          }
          return(rc);
     default:
          catastro("GME level 3 state corrupted in gsndmsg(), state=%d",
                   work->state3);
     }
     ASSERT(FALSE);
     clsgmerq(work);
     return(GMEERR);     /* this should never happen */
}

int                                /*   returns standard GME status codes  */
sendmsg(                           /* send a new message from current user */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt,                      /*   path+file name of att (if any)     */
char *cclist)                      /*   list of cc: addresses              */
{
     int rc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     ASSERT(strlen(text) < TXTLEN);
     ASSERT(msg->forum == EMLID || fidxst(msg->forum));
     while (TRUE) {
          switch (work->state3) {
          case START:
               if ((rc=chksnd(work,msg,filatt)) != GMEOK) {
                    clsgmerq(work);
                    return(rc);
               }
               work->orgflg=(int)msg->flags;
               if (msg->flags&FILATT) {
                    stlcpy(work->orgatt,filatt,MAXPATH);
               }
               if (!(msg->forum == EMLID && isdlst(msg->to)) && anycc(cclist)) {
                    stlcpy(work->auxhist,msg->history,HSTSIZ);
               }
               ininew(msg);
               chkrqs(work,msg);
               chkfor(msg);
               setflgs(msg,msg->from);
               msg->thrid=0;
               work->orgmid=msg->msgid;
               work->state3=GOWRITE;
               if (msg->flags&FILATT) {
                    if (anycc(cclist)) {
                         gmelok(work,msg->forum,msg->msgid);
                    }
                    if (msg->forum == EMLID && isexpa(msg->to)) {
                         stlcpy(work->cpyatt,expasp(msg->to,msg),MAXPATH);
                         if ((msg->flags&FILIND) || anycc(cclist)) {
                              work->state3=STRTCPY;
                              return(GMEAGAIN);
                         }
                         if (sameas(normspec((char *)tmpbuf,filatt),
                                    normspec((char *)tmpbuf+MAXPATH,
                                             work->cpyatt))) {
                              stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                         }
                         else {
                              unlink(work->cpyatt);
                              if (rename(filatt,work->cpyatt) == 0) {
                                   stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                              }
                              else {
                                   work->state3=STRTCPY;
                                   return(GMEAGAIN);
                              }
                         }
                    }
                    else {
                         stlcpy(work->auxatt,filatt,MAXPATH);
                         *work->cpyatt='\0';
                    }
               }
               break;
          case STRTCPY:
               callback(work,EVTCPYS,GMEOK,work->cpyatt);
               work->state3=COPYATT;
               if (!opn4cpy(work,filatt)) {
                    clsgmerq(work);
                    return(GMENOAT);
               }
          case COPYATT:
               rc=copychunk(work);
               if (rc > GMEAGAIN) {
                    callback(work,EVTCPYD,GMEOK,work->cpyatt);
                    work->state3=GOWRITE;
                    stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                    rc=GMEAGAIN;
               }
               else if (rc < GMEAGAIN) {
                    clsgmerq(work);
               }
               return(rc);
          case GOWRITE:
               if (msg->forum == EMLID && isdlst(msg->to)) {
                    work->state3=DISTING;
               }
               else {
                    callback(work,EVTSTRT,GMEOK,msg->to);
                    work->state3=WRITING;
                    if (!gdedcrd(msg->from,work->basechg,FALSE,FALSE)) {
                         clsgmerq(work);
                         return(GMECRD);
                    }
               }
               break;
          case DISTING:
               rc=gme2dst(work,msg,text,filatt);
               if (rc > GMEAGAIN) {
                    wrtaud(work,msg);
                    if (anycc(cclist)) {
                         callback(work,EVTDSTD,rc,NULL);
                         rc=GMEAGAIN;
                         work->state3=STARTCC;
                         msg->flags=(long)work->orgflg;
                         stlcpy(work->orgatt,dlname(msg),MAXADR);
                         clrwrt(work);
                    }
                    else {
                         clsgmerq(work);
                    }
               }
               else if (rc < GMEAGAIN) {
                    clsgmerq(work);
               }
               return(rc);
          case WRITING:
               rc=gme2wnm(work,msg,text,work->auxatt);
               if (rc > GMEAGAIN) {
                    wrtaud(work,msg);
                    hdlntfy(WRITENOT,work,msg);
                    if (anycc(cclist)) {
                         clrwrt(work);
                         msg->flags=(long)work->orgflg;
                         if ((msg->flags&FILATT) && !isexpa(msg->to)) {
                              stlcpy(work->orgatt,dlname(msg),MAXPATH);
                         }
                         stlcpy(msg->history,work->auxhist,HSTSIZ);
                         if (work->flags&FWDMSG) {
                              rstafwd(work,msg);
                              callback(work,EVTDONE,GMEAFWD,NULL);
                         }
                         else {
                              callback(work,EVTDONE,rc,msg->to);
                         }
                         rc=GMEAGAIN;
                         work->state3=STARTCC;
                    }
                    else {
                         if (work->flags&FWDMSG) {
                              rstafwd(work,msg);
                              rc=GMEAFWD;
                         }
                         clsgmerq(work);
                    }
               }
               else if (rc < GMEAGAIN) {
                    if (!(work->flags&PRIMDONE)) {
                         gdedcrd(msg->from,-work->basechg,FALSE,TRUE);
                    }
                    clsgmerq(work);
               }
               return(rc);
          case STARTCC:            /* just so you know where it goes       */
          default:
               return(gme3cc(work,msg,text,cclist));
          }
     }
}

int                                /*   returns standard GME status codes  */
reply(                             /* reply to current message in context  */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure           */
char *text,                        /*   new message text                   */
char *filatt,                      /*   path+file name of att (if any)     */
char *cclist)                      /*   list of cc: addresses              */
{
     int rc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     ASSERT(strlen(text) < TXTLEN);
     ASSERT(msg->forum == EMLID || fidxst(msg->forum));
     while (TRUE) {
          switch (work->state3) {
          case START:
               ASSERT(msg->forum != EMLID
                   || (!isforum(msg->to) && !isdlst(msg->to)));
               if ((rc=chksnd(work,msg,filatt)) != GMEOK) {
                    clsgmerq(work);
                    return(rc);
               }
               work->orgflg=(int)msg->flags;
               if (msg->flags&FILATT) {
                    stlcpy(work->orgatt,filatt,MAXPATH);
               }
               addhist(msg->history,spr(RPLTO,l2as(work->rdctx.mid)));
               if (anycc(cclist)) {
                    stlcpy(work->auxhist,msg->history,HSTSIZ);
               }
               chkrqs(work,msg);
               if (msg->forum == EMLID && !isexpa(msg->to)) {
                    if (grabmsg(work,utlmsg,utltxt)) {
                         msg->rplto.sysid=(long)utlmsg->forum;
                         msg->rplto.msgid=utlmsg->msgid;
                    }
                    else {
                         msg->rplto.sysid=(long)work->rdctx.fid;
                         msg->rplto.msgid=work->rdctx.mid;
                    }
               }
               else {
                    msg->rplto=msg->gmid;
               }
               iniamsg(msg);
               setflgs(msg,msg->from);
               work->orgmid=msg->msgid;
               work->state3=GOWRITE;
               if (msg->flags&FILATT) {
                    if (anycc(cclist)) {
                         gmelok(work,msg->forum,msg->msgid);
                    }
                    if (msg->forum == EMLID && isexpa(msg->to)) {
                         stlcpy(work->cpyatt,expasp(msg->to,msg),MAXPATH);
                         if ((msg->flags&FILIND) || anycc(cclist)) {
                              work->state3=STRTCPY;
                              return(GMEAGAIN);
                         }
                         if (sameas(normspec((char *)tmpbuf,filatt),
                                    normspec((char *)tmpbuf+MAXPATH,
                                             work->cpyatt))) {
                              stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                         }
                         else {
                              unlink(work->cpyatt);
                              if (rename(filatt,work->cpyatt) == 0) {
                                   stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                              }
                              else {
                                   work->state3=STRTCPY;
                                   return(GMEAGAIN);
                              }
                         }
                    }
                    else {
                         stlcpy(work->auxatt,filatt,MAXPATH);
                         *work->cpyatt='\0';
                    }
               }
               break;
          case STRTCPY:
               callback(work,EVTCPYS,GMEOK,work->cpyatt);
               work->state3=COPYATT;
               if (!opn4cpy(work,filatt)) {
                    clsgmerq(work);
                    return(GMENOAT);
               }
          case COPYATT:
               rc=copychunk(work);
               if (rc > GMEAGAIN) {
                    callback(work,EVTCPYD,GMEOK,work->cpyatt);
                    work->state3=GOWRITE;
                    stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                    rc=GMEAGAIN;
               }
               else if (rc < GMEAGAIN) {
                    clsgmerq(work);
               }
               return(rc);
          case GOWRITE:
               callback(work,EVTSTRT,GMEOK,msg->to);
               work->state3=WRITING;
               if (!gdedcrd(msg->from,work->basechg,FALSE,FALSE)) {
                    clsgmerq(work);
                    return(GMECRD);
               }
          case WRITING:
               rc=gme2wnm(work,msg,text,work->auxatt);
               if (rc > GMEAGAIN) {
                    wrtaud(work,msg);
                    hdlntfy(REPLYNOT,work,msg);
                    work->state3=UPDORG;
                    rc=GMEAGAIN;
               }
               else if (rc < GMEAGAIN) {
                    if (!(work->flags&PRIMDONE)) {
                         gdedcrd(msg->from,-work->basechg,FALSE,TRUE);
                    }
                    clsgmerq(work);
               }
               return(rc);
          case UPDORG:
               rc=GMEOK;
               if (grabmsg(work,utlmsg,utltxt)) {
                    if (utlmsg->forum != EMLID
                     && utlmsg->forum == msg->forum) {
                         ++utlmsg->nrpl;
                         updmsg(work,utlmsg,utltxt);
                    }
                    if (work->rdctx.fid == EMLID
                     && (othqsp(msg->from)->flags&CLARPL)) {
                         if (utlmsg->forum == EMLID) {
                              clrto(utlmsg);
                              if (utlmsg->flags&FRCLR) {
                                   clrfrom(utlmsg);
                              }
                              updmsg(work,utlmsg,utltxt);
                         }
                         else {
                              gme1dlm(work);
                         }
                    }
               }
               if (anycc(cclist)) {
                    if ((msg->flags&FILATT) && !isexpa(msg->to)) {
                         stlcpy(work->orgatt,dlname(msg),MAXPATH);
                    }
                    if (work->flags&FWDMSG) {
                         rstafwd(work,msg);
                         callback(work,EVTDONE,GMEAFWD,NULL);
                    }
                    else {
                         callback(work,EVTDONE,rc,msg->to);
                    }
                    work->state3=STARTCC;
                    return(GMEAGAIN);
               }
               else {
                    rc=GMEOK;
                    if (work->flags&FWDMSG) {
                         rstafwd(work,msg);
                         rc=GMEAFWD;
                    }
                    clsgmerq(work);
                    return(rc);
               }
          case STARTCC:            /* just so you know where it goes       */
          default:
               return(gme3cc(work,msg,text,cclist));
          }
     }
}

int                                /*   returns standard GME status codes  */
gme3cc(                            /* send cc:s when writing or replying   */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure           */
char *text,                        /*   message text                       */
char *cclist)                      /*   list of cc: addresses              */
{
     int rc;

     while (TRUE) {
          switch (work->state3) {
          case STARTCC:
               callback(work,EVTCCST,GMEOK,NULL);
               addhist(msg->history,spr(CCOF,l2as(work->orgmid)));
               stlcpy(work->auxhist,msg->history,HSTSIZ);
               setmem(&msg->rplto,sizeof(struct globid),0);
               work->ccptr=cclist;
               work->state3=NEXTCC;
          case NEXTCC:
               if (!nextcc(work,msg)) {
                    clsgmerq(work);
                    return(GMEOK);
               }
               addchg(work,msg);
               if (!gtstcrd(msg->from,work->basechg,FALSE)) {
                    if (msg->forum == EMLID) {
                         callback(work,EVTDONE,GMECRD,msg->to);
                    }
                    else {
                         callback(work,EVTDONE,GMECRD,
                                  spr("/%s",getfnm(msg->forum)));
                    }
                    break;
               }
               chkrqs(work,msg);
               chkfor(msg);
               iniamsg(msg);
               setflgs(msg,msg->from);
               msg->thrid=0L;
               if (msg->flags&FILATT) {
                    if (!(msg->flags&FILIND) || isexpa(msg->to)) {
                         if (isexpa(msg->to)) {
                              stlcpy(work->cpyatt,expasp(msg->to,msg),MAXPATH);
                         }
                         else {
                              stlcpy(work->cpyatt,ulname(msg),MAXPATH);
                         }
                         work->state3=CCACPY;
                         callback(work,EVTCPYS,GMEOK,work->cpyatt);
                         if (!opn4cpy(work,work->orgatt)) {
                              callback(work,EVTCPYD,GMENOAT,work->cpyatt);
                              *work->cpyatt='\0';
                              noatt(msg);
                              work->state3=SENDOFF;
                         }
                    }
                    else {
                         work->state3=SENDOFF;
                         stlcpy(work->auxatt,work->orgatt,MAXPATH);
                         *work->cpyatt='\0';
                    }
               }
               else {
                    work->state3=SENDOFF;
                    *work->cpyatt='\0';
               }
               break;
          case CCACPY:
               rc=copychunk(work);
               if (rc != GMEAGAIN) {
                    callback(work,EVTCPYD,rc,work->cpyatt);
                    if (rc < GMEAGAIN) {
                         noatt(msg);
                    }
                    work->state3=SENDOFF;
                    rc=GMEAGAIN;
               }
               return(rc);
          case SENDOFF:
               if (isdlst(msg->to)) {
                    work->state3=DISTCC;
                    if (*work->cpyatt != '\0') {
                         stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                         *work->cpyatt='\0';
                    }
               }
               else {
                    if (gdedcrd(msg->from,work->basechg,FALSE,FALSE)) {
                         if (*work->cpyatt != '\0') {
                              stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                              *work->cpyatt='\0';
                         }
                         work->flags&=~PRIMDONE;
                         work->state3=WRITCC;
                    }
                    else {
                         if (msg->forum == EMLID) {
                              callback(work,EVTDONE,GMECRD,msg->to);
                         }
                         else {
                              callback(work,EVTDONE,GMECRD,
                                       spr("/%s",getfnm(msg->forum)));
                         }
                         unlink(work->cpyatt);
                         work->state3=NEXTCC;
                         return(GMEAGAIN);
                    }
               }
               break;
          case WRITCC:
               rc=gme2wnm(work,msg,text,work->auxatt);
               if (rc != GMEAGAIN) {
                    if (rc > GMEAGAIN) {
                         hdlntfy(CCOPYNOT,work,msg);
                         if (work->flags&FWDMSG) {
                              rstafwd(work,msg);
                              callback(work,EVTDONE,GMEAFWD,NULL);
                         }
                         else if (msg->forum == EMLID) {
                              callback(work,EVTDONE,rc,msg->to);
                         }
                         else {
                              callback(work,EVTDONE,rc,
                                       spr("/%s",getfnm(msg->forum)));
                         }
                    }
                    else if (rc < GMEAGAIN) {
                         if (msg->forum == EMLID) {
                              callback(work,EVTDONE,rc,msg->to);
                         }
                         else {
                              callback(work,EVTDONE,rc,
                                       spr("/%s",getfnm(msg->forum)));
                         }
                         if (!(work->flags&PRIMDONE)) {
                              gdedcrd(msg->from,-work->basechg,FALSE,TRUE);
                              if ((msg->flags&FILATT) && !(msg->flags&FILIND)) {
                                   unlink(work->auxatt);
                              }
                         }
                    }
                    work->state3=NEXTCC;
                    rc=GMEAGAIN;
                    stlcpy(msg->history,work->auxhist,HSTSIZ);
               }
               return(rc);
          case DISTCC:
               rc=gme2dst(work,msg,text,work->auxatt);
               if (rc != GMEAGAIN) {
                    callback(work,EVTDSTD,rc,NULL);
                    if (rc < GMEAGAIN) {
                         unlink(work->auxatt);
                    }
                    work->state3=NEXTCC;
                    rc=GMEAGAIN;
                    stlcpy(work->auxhist,msg->history,HSTSIZ);
               }
               return(rc);
          default:
               catastro("GME level 3 state corrupted in gme3cc(), state=%d",
                        work->state3);
          }
     }
}

BOOL                               /*   returns TRUE if a cc: to send      */
nextcc(                            /* set up to send next cc:              */
struct gmework *work,              /*   GME work space in use              */
struct message *msg)               /*   message header structure           */
{
     while (TRUE) {
          msg->forum=EMLID;
          msg->flags=(long)work->orgflg;
          clrwrt(work);
          if (work->ccptr == NULL) {
               return(FALSE);
          }
          work->ccptr=parscc(msg->to,work->ccptr);
          callback(work,EVTSTRT,GMEOK,msg->to);
          if (isforum(msg->to)) {
               msg->flags&=~(RECREQ+PRIMSG);
          }
          if (stripit(work,msg)) {
               return(TRUE);
          }
     }
}

int                                /*   returns standard GME status codes  */
copymsg(                           /* send copy of current msg in context  */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header buffer              */
char *text)                        /*   message text buffer                */
{
     int rc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     ASSERT(strlen(text) < TXTLEN);
     ASSERT(msg->forum == EMLID || fidxst(msg->forum));
     while (TRUE) {
          switch (work->state3) {
          case START:
               if (msg->forum == EMLID && isdlst(msg->to)) {
                    work->state3=START;
                    clrwrt(work);
                    return(GMENCFL);
               }
               if (!gdedcrd(work->rdctx.uid,work->basechg,FALSE,FALSE)) {
                    work->state3=START;
                    clrwrt(work);
                    return(GMECRD);
               }
               if (!grabmsg(work,utlmsg,utltxt)) {
                    clrwrt(work);
                    work->state3=START;
                    return(GMEERR);
               }
               work->flags&=~PRIMDONE;
               if (msg->flags&FILATT) {
                    stlcpy(work->auxatt,dlname(utlmsg),MAXPATH);
               }
               if ((rc=chkcf(work,msg,work->auxatt)) != GMEOK) {
                    work->state3=START;
                    clrwrt(work);
                    return(rc);
               }
               addhist(msg->history,spr(COPYBY,work->rdctx.uid));
               chkrqs(work,msg);
               chkfor(msg);
               inicfmsg(msg);
               setflgs(msg,work->rdctx.uid);
               msg->thrid=0L;
               setmem(&msg->rplto,sizeof(struct globid),0);
               if (msg->forum == EMLID && !isexpa(msg->to)) {
                    clrfrom(msg);
               }
               work->state3=WRITING;
               if (msg->flags&FILATT) {
                    if (!(msg->flags&FILIND) || isexpa(msg->to)) {
                         if (isexpa(msg->to)) {
                              stlcpy(work->cpyatt,expasp(msg->to,msg),MAXPATH);
                         }
                         else {
                              stlcpy(work->cpyatt,ulname(msg),MAXPATH);
                         }
                         callback(work,EVTCPYS,GMEOK,work->cpyatt);
                         work->state3=COPYATT;
                         if (!opn4cpy(work,work->auxatt)) {
                              rc=GMENOAT;
                              work->state3=GETOUT;
                         }
                    }
               }
               break;
          case COPYATT:
               rc=copychunk(work);
               if (rc > GMEAGAIN) {
                    callback(work,EVTCPYD,GMEOK,work->cpyatt);
                    stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                    work->state3=WRITING;
                    rc=GMEAGAIN;
               }
               else if (rc < GMEAGAIN) {
                    work->state3=GETOUT;
                    break;
               }
               return(rc);
          case WRITING:
               rc=gme2wnm(work,msg,text,work->auxatt);
               if (rc != GMEAGAIN) {
                    work->state3=GETOUT;
                    if (rc > GMEAGAIN) {
                         hdlntfy(MCOPYNOT,work,msg);
                         if (work->flags&FWDMSG) {
                              rstafwd(work,msg);
                              rc=GMEAFWD;
                         }
                    }
                    break;
               }
               return(rc);
          case GETOUT:
               uclfrom(msg);
               if (rc < GMEAGAIN && !(work->flags&PRIMDONE)) {
                    gdedcrd(work->rdctx.uid,-work->basechg,FALSE,TRUE);
                    unlink(work->cpyatt);
               }
               clrwrt(work);
               work->state3=START;
               return(rc);
          default:
               catastro("GME level 3 state corrupted in copymsg(), state=%d",
                        work->state3);
          }
     }
}

int                                /*   returns standard GME status codes  */
fwdmsg(                            /* forward current message in context   */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure           */
char *text)                        /*   message text                       */
{
     int rc;
     struct gmework *work=(struct gmework *)workb;
     BOOL therenow;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     ASSERT(strlen(text) < TXTLEN);
     ASSERT(msg->forum == EMLID || fidxst(msg->forum));
     while (TRUE) {
          switch (work->state3) {
          case START:
               if (msg->forum == EMLID && isdlst(msg->to)) {
                    clrwrt(work);
                    work->state3=START;
                    return(GMENCFL);
               }
               if (!gdedcrd(work->rdctx.uid,work->basechg,FALSE,FALSE)) {
                    clrwrt(work);
                    work->state3=START;
                    return(GMECRD);
               }
               if (!grabmsg(work,utlmsg,utltxt)) {
                    clrwrt(work);
                    work->state3=START;
                    return(GMEERR);
               }
               if (gmecfl(work,utlmsg->forum,utlmsg->msgid)) {
                    clrwrt(work);
                    work->state3=START;
                    return(GMEUSE);
               }
               work->flags&=~PRIMDONE;
               if (msg->flags&FILATT) {
                    stlcpy(work->auxatt,dlname(utlmsg),MAXPATH);
               }
               if ((rc=chkcf(work,msg,work->auxatt)) != GMEOK) {
                    work->state3=START;
                    clrwrt(work);
                    return(rc);
               }
               addhist(msg->history,spr(FWDBY,work->rdctx.uid));
               chkrqs(work,msg);
               chkfor(msg);
               inicfmsg(msg);
               setflgs(msg,work->rdctx.uid);
               msg->thrid=0L;
               setmem(&msg->rplto,sizeof(struct globid),0);
               if (msg->forum == EMLID && !isexpa(msg->to)) {
                    clrfrom(msg);
               }
               work->state3=WRITING;
               if (msg->flags&FILATT) {
                    if (!(msg->flags&FILIND)
                     || (msg->forum == EMLID && isexpa(msg->to))) {
                         if (msg->forum == EMLID && isexpa(msg->to)) {
                              stlcpy(work->cpyatt,expasp(msg->to,msg),MAXPATH);
                         }
                         else {
                              stlcpy(work->cpyatt,ulname(msg),MAXPATH);
                         }
                         therenow=sameas(normspec((char *)tmpbuf,work->auxatt),
                                         normspec((char *)tmpbuf+MAXPATH,
                                                  work->cpyatt));
                         if (!(msg->flags&FILIND) && !therenow) {
                              unlink(work->cpyatt);
                         }
                         if (!(msg->flags&FILIND) && (therenow
                           || rename(work->auxatt,work->cpyatt) == 0)) {
                              stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                         }
                         else {
                              callback(work,EVTCPYS,GMEOK,work->cpyatt);
                              work->state3=COPYATT;
                              if (!opn4cpy(work,work->auxatt)) {
                                   rc=GMENOAT;
                                   work->state3=GETOUT;
                              }
                         }
                    }
               }
               break;
          case COPYATT:
               rc=copychunk(work);
               if (rc > GMEAGAIN) {
                    callback(work,EVTCPYD,GMEOK,work->cpyatt);
                    stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                    work->state3=WRITING;
                    rc=GMEAGAIN;
               }
               else if (rc < GMEAGAIN) {
                    work->state3=GETOUT;
                    break;
               }
               return(rc);
          case WRITING:
               rc=gme2wnm(work,msg,text,work->auxatt);
               if (rc != GMEAGAIN) {
                    if (rc > GMEAGAIN) {
                         hdlntfy(FORWDNOT,work,msg);
                         work->state3=DELETNG;
                         rc=GMEAGAIN;
                    }
                    else {
                         work->state3=GETOUT;
                         break;
                    }
               }
               return(rc);
          case DELETNG:
               if (gme1dlm(work)) {
                    if (work->flags&FWDMSG) {
                         rstafwd(work,msg);
                         rc=GMEAFWD;
                    }
                    else {
                         rc=GMEOK;
                    }
               }
               else {
                    rc=GMEERR;
               }
          case GETOUT:
               uclfrom(msg);
               if (rc < GMEAGAIN && !(work->flags&PRIMDONE)) {
                    gdedcrd(work->rdctx.uid,-work->basechg,FALSE,TRUE);
                    unlink(work->cpyatt);
               }
               clrwrt(work);
               work->state3=START;
               return(rc);
          default:
               catastro("GME level 3 state corrupted in fwdmsg(), state=%d",
                        work->state3);
          }
     }
}

int                                /*   returns standard GME status codes  */
gme2dst(                           /* send dist list                       */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt)                      /*   path+file name of att (if any)     */
{
     int rc;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     ASSERT(strlen(text) < TXTLEN);
     while (TRUE) {
          switch (work->state2) {
          case START:
               ASSERT(msg->forum == EMLID);
               callback(work,EVTDSTS,GMEOK,msg->to);
               if ((rc=inidist(work,msg)) != GMEOK) {
                    work->state2=START;
                    return(rc);
               }
               if (!gdedcrd(msg->from,work->basechg,FALSE,FALSE)) {
                    work->state2=START;
                    return(GMECRD);
               }
               work->dstprim=msg->msgid;
               msg->thrid=cmptid(msg);
               work->tmpflg=(int)msg->flags;
               stlcpy(work->auxhist,msg->history,HSTSIZ);
               work->state2=WRTPRIM;
               gmelok(work,msg->forum,msg->msgid);
               return(GMEAGAIN);
          case WRTPRIM:
               rc=gme1wnm(work,msg,text,filatt);
               if (rc < GMEAGAIN) {
                    gdedcrd(msg->from,-work->basechg,FALSE,TRUE);
                    clsdist(work);
                    work->state2=START;
               }
               else if (rc > GMEAGAIN) {
                    work->flags|=PRIMDONE;
                    if (msg->flags&FILATT) {
                         if (msg->flags&FILIND) {
                              stlcpy(work->auxatt,filatt,MAXPATH);
                         }
                         else {
                              stlcpy(work->auxatt,dlname(msg),MAXPATH);
                              work->tmpflg|=(int)FILIND;
                         }
                    }
                    work->state2=DSTDLY;
                    work->dstdly=0;
                    rc=GMEAGAIN;
               }
               return(rc);
          case DSTDLY:
               if (work->dstdly++ < dstdly) {
                    return(GMEAGAIN);
               }
          case NXTDIST:
               if (nxtdist(work,msg)) {
                    callback(work,EVTSTRT,GMEOK,msg->to);
                    work->flags&=~(ADROK|ATTOK|RRROK|PRIOK|FWDMSG|CPY2E);
                    *work->cpyatt='\0';
                    msg->forum=EMLID;
                    msg->flags=(long)work->tmpflg;
                    if (isdlst(msg->to)) {
                         callback(work,EVTDONE,GMENCFL,msg->to);
                    }
                    if (!isdlst(msg->to) && stripit(work,msg)) {
                         stlcpy(msg->history,work->auxhist,HSTSIZ);
                         if (work->flags&SYSLST) {
                              addhist(msg->history,spr(SDLMSG,work->dlstnam));
                         }
                         else {
                              addhist(msg->history,DSTMSG);
                         }
                         chkrqs(work,msg);
                         chkfor(msg);
                         addchg(work,msg);
                         iniamsg(msg);
                         setflgs(msg,msg->from);
                         msg->thrid=cmptid(msg);
                         if (gdedcrd(msg->from,work->basechg,FALSE,FALSE)) {
                              if ((work->flags&FWDMSG) && work->rcpchg != 0L
                               && !gdedcrd(work->auxto,work->rcpchg,FALSE,FALSE)) {
                                   stlcpy(msg->to,work->auxto,UIDSIZ);
                                   work->flags&=~FWDMSG;
                              }
                              if (isexpa(msg->to)) {
                                   if (msg->flags&FILATT) {
                                        work->state2=STRTCPY;
                                   }
                                   else {
                                        work->state2=SNDEXP;
                                   }
                              }
                              else {
                                   work->state2=SNDIST;
                              }
                         }
                         else {
                              if (msg->forum == EMLID) {
                                   callback(work,EVTDONE,GMECRD,msg->to);
                              }
                              else {
                                   callback(work,EVTDONE,GMECRD,
                                            spr("/%s",getfnm(msg->forum)));
                              }
                         }
                    }
                    rc=GMEAGAIN;
               }
               else {
                    msg->forum=EMLID;
                    msg->msgid=work->dstprim;
                    stlcpy(msg->to,work->dlstnam,DLNMSZ);
                    stlcpy(msg->history,work->auxhist,HSTSIZ);
                    msg->flags=(long)work->tmpflg;
                    clsdist(work);
                    work->state2=START;
                    rc=GMEOK;
               }
               return(rc);
          case STRTCPY:
               work->state2=COPYATT;
               stlcpy(work->cpyatt,expasp(msg->to,msg),MAXPATH);
               callback(work,EVTCPYS,GMEOK,work->cpyatt);
               if (!opn4cpy(work,work->auxatt)) {
                    noatt(msg);
                    work->state2=SNDEXP;
                    *work->cpyatt='\0';
                    break;
               }
               break;
          case COPYATT:
               rc=copychunk(work);
               if (rc > GMEAGAIN) {
                    callback(work,EVTCPYD,GMEOK,work->cpyatt);
                    if (isexpa(msg->to)) {
                         work->state2=SNDEXP;
                    }
                    else {
                         work->state2=SNDIST;
                    }
                    rc=GMEAGAIN;
               }
               else if (rc < GMEAGAIN) {
                    work->state2=START;
               }
               return(rc);
          case SNDEXP:
               rc=sndexp(msg->to,msg,text,work->cpyatt);
               if (rc > GMEAGAIN) {
                    hdlntfy(DISTRNOT,work,msg);
                    *work->cpyatt='\0';
               }
               if ((work->flags&FWDMSG) && rc > GMEAGAIN) {
                    rstafwd(work,msg);
                    callback(work,EVTDONE,GMEAFWD,NULL);
               }
               else {
                    callback(work,EVTDONE,rc,msg->to);
               }
               if (rc <= GMEAGAIN) {
                    unlink(work->cpyatt);
                    if ((work->flags&FWDMSG) && work->rcpchg != 0) {
                         gdedcrd(work->auxto,-work->rcpchg,FALSE,TRUE);
                    }
               }
               work->state2=DSTDLY;
               work->dstdly=0;
               return(GMEAGAIN);
          case SNDIST:
               rc=gme1wap(work,EMLID,work->dstprim,FALSE,msg,work->auxatt);
               if (rc != GMEAGAIN) {
                    if (rc > GMEAGAIN) {
                         hdlntfy(DISTRNOT,work,msg);
                    }
                    if ((work->flags&FWDMSG) && rc > GMEAGAIN) {
                         rstafwd(work,msg);
                         callback(work,EVTDONE,GMEAFWD,NULL);
                    }
                    else if (msg->forum == EMLID) {
                         callback(work,EVTDONE,rc,msg->to);
                    }
                    else {
                         callback(work,EVTDONE,rc,
                                  spr("/%s",getfnm(msg->forum)));
                    }
                    if (rc < GMEAGAIN) {
                         gdedcrd(msg->from,-work->basechg,FALSE,TRUE);
                    }
                    if (msg->forum != EMLID && iniecho(work,msg)) {
                         work->state2=SNDECHO;
                    }
                    else {
                         work->state2=DSTDLY;
                         work->dstdly=0;
                    }
                    rc=GMEAGAIN;
               }
               return(rc);
          case SNDECHO:
               rc=gme1echo(work,msg,text,work->auxatt);
               if (rc != GMEAGAIN) {
                    work->state2=DSTDLY;
                    work->dstdly=0;
               }
               return(GMEAGAIN);
          default:
               catastro("GME level 2 state corrupted in gme2dst(), state=%d",
                        work->state2);
          }
     }
}

int                                /*   returns standard GME status codes  */
gme2wnm(                           /* send a message                       */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt)                      /*   path+file name of att (if any)     */
{
     int rc;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     ASSERT(strlen(text) < TXTLEN);
     ASSERT(msg->forum == EMLID || fidxst(msg->forum));
     while (TRUE) {
          switch (work->state2) {
          case START:
               if (msg->thrid == 0L) {
                    msg->thrid=cmptid(msg);
               }
               if ((work->flags&FWDMSG) && work->rcpchg != 0L
                && !gdedcrd(work->auxto,work->rcpchg,FALSE,FALSE)) {
                    stlcpy(msg->to,work->auxto,UIDSIZ);
                    work->flags&=~FWDMSG;
               }
               if (msg->forum == EMLID && isexpa(msg->to)) {
                    work->state2=SNDEXP;
               }
               else {
                    work->state2=SNDLOC;
               }
               break;
          case SNDEXP:
               rc=sndexp(msg->to,msg,text,filatt);
               if (rc > GMEAGAIN) {
                    *work->cpyatt='\0';
                    work->flags|=PRIMDONE;
               }
               work->state2=START;
               return(rc);
          case SNDLOC:
               rc=gme1wnm(work,msg,text,filatt);
               if (rc != GMEAGAIN) {
                    work->state2=START;
                    if (rc > GMEAGAIN) {
                         work->flags|=PRIMDONE;
                         if (msg->forum != EMLID) {
                              if (iniecho(work,msg)) {
                                   work->state2=SNDECHO;
                                   stlcpy(work->auxatt,dlname(msg),MAXPATH);
                                   rc=GMEAGAIN;
                              }
                              else if (work->flags&CPY2E) {
                                   work->state2=CPYEML;
                                   rc=GMEAGAIN;
                              }
                         }
                    }
               }
               return(rc);
          case SNDECHO:
               rc=gme1echo(work,msg,text,work->auxatt);
               if (rc != GMEAGAIN) {
                    work->state2=START;
                    if (work->flags&CPY2E) {
                         work->state2=CPYEML;
                         rc=GMEAGAIN;
                    }
               }
               return(rc);
          case CPYEML:
               work->state2=WRTECPY;
               work->orgfor=msg->forum;
               msg->forum=EMLID;
               clrfrom(msg);
          case WRTECPY:
               rc=gme1wap(work,work->orgfor,msg->msgid,TRUE,msg,work->auxatt);
               if (rc != GMEAGAIN) {
                    work->state2=START;
                    msg->forum=work->orgfor;
                    uclfrom(msg);
               }
               return(rc);
          default:
               catastro("GME level 2 state corrupted in gme2wnm(), state=%d",
                        work->state2);
          }
     }
}

BOOL                               /*   returns FALSE if can't send at all */
stripit(                           /* val a msg & strip unavail features   */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg)               /*   message header to strip            */
{
     switch (valadr(work,msg->from,msg->to,msg->forum)) {
     case VALNO:
          callback(work,EVTDONE,GMENFND,msg->to);
          return(FALSE);
     case VALACC:
          callback(work,EVTDONE,GMEACC,msg->to);
          return(FALSE);
     case VALCRD:
          callback(work,EVTDONE,GMECRD,msg->to);
          return(FALSE);
     }
     if (msg->flags&PRIMSG) {
          switch (valpri(work,msg->from,msg->to,msg->forum)) {
          case VALNO:
          case VALACC:
          case VALCRD:
               msg->flags&=~PRIMSG;
               break;
          }
     }
     if (msg->flags&RECREQ) {
          switch (valrrr(work,msg->from,msg->to,msg->forum)) {
          case VALNO:
          case VALACC:
          case VALCRD:
               msg->flags&=~RECREQ;
               break;
          }
     }
     if (msg->flags&FILATT) {
          switch (valatt(work,msg->from,msg->to,msg->forum)) {
          case VALNO:
          case VALACC:
          case VALCRD:
               noatt(msg);
               break;
          }
     }
     return(TRUE);
}

long
normchg(                           /* compute charges for a "normal" msg   */
struct message *msg,               /*   message header to check            */
long attsiz)                       /*   size of attachment (if any)        */
{
     long total;

     total=emschg;
     if (msg->flags&FILATT) {
          total+=eatchg+epkchg*(attsiz/1024);
     }
     if (msg->flags&RECREQ) {
          total+=rrrchg;
     }
     if (msg->flags&PRIMSG) {
          total+=prichg;
     }
     return(total);
}

char *                             /*   path & file name to place file in  */
ulname(                            /* path & file name to upload att to    */
struct message *msg)               /*   header of message to attach to     */
{
     unsigned tmpfid;

     ASSERT(msg != NULL);
     ASSERT(msg->forum == EMLID || fidxst(msg->forum));
     if (msg->forum == EMLID && isforum(msg->to)) {
          tmpfid=getfid(msg->to+1);
          return(spr("%s\\%s",attpth(tmpfid),tmpanam(NULL)));
     }
     else {
          return(spr("%s\\%s",attpth(msg->forum),tmpanam(NULL)));
     }
}

char *                             /*   path & file name of attachment     */
dlname(                            /* path & file name to dnload att from  */
struct message *msg)               /*   header of message with attachment  */
{
     return(gdlname((msg->flags&FILIND) != 0L,msg->forum,msg->msgid));
}

char *                             /*   path & file name of attachment     */
gdlname(                           /* gen path & file name to dnload att   */
BOOL indirect,                     /*   attachment is indirect             */
unsigned forum,                    /*   forum message is in                */
long msgid)                        /*   message ID                         */
{
     static char nambuf[MAXPATH];

     if (indirect) {
          indasp(nambuf,forum,msgid);
     }
     else {
          dirasp(nambuf,forum,msgid);
     }
     return(nambuf);
}

char *                             /*   pointer to string buffer           */
indasp(                            /* get path+file name of indirect att   */
char *buf,                         /*   string buffer for path             */
unsigned forum,                    /*   forum message is in                */
long msgid)                        /*   message ID of message              */
{
     FILE *fp;

     buf[0]='\0';
     if ((fp=fopen(attpfn(forum,msgid),FOPRA)) != NULL) {
          fgets(buf,MAXPATH,fp);
          fclose(fp);
     }
     return(buf);
}

char *                             /*   pointer to string buffer           */
dirasp(                            /* get path+file name of direct att     */
char *buf,                         /*   string buffer for path             */
unsigned forum,                    /*   forum message is in                */
long msgid)                        /*   message ID of message              */
{
     stlcpy(buf,attpfn(forum,msgid),MAXPATH);
     return(buf);
}

void
wrtaud(                            /* do new-message audit stuff           */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg)               /*   new message structure              */
{
     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     ASSERT(msg->forum == EMLID || fidxst(msg->forum));
     if (msg->forum == EMLID) {
           if (msg->flags&FILATT) {
               ++sv.uplds;
               if (eupaud) {                          /* relies on AUDSIZ+20 */
                    shocst("E-MAIL ATTACHMENT UPLOAD",/* buffer in shocst()  */
                           "%.29s uploaded %.12s to %.29s",
                           msg->from,msg->attname,
                           work->flags&FWDMSG ? work->auxto : msg->to);
               }
          }
     }
     else {
           if (msg->flags&FILATT) {
               ++sv.uplds;
               if (fupaud) {                          /* relies on AUDSIZ+20 */
                    shocst("FORUM ATTACHMENT UPLOAD", /* buffer in shocst()  */
                           "%.29s uploaded %.12s to %.15s",
                           msg->from,msg->attname,getfnm(msg->forum));
               }
          }
     }
}

int                                /*   returns standard GME result codes  */
tagatt(                            /* create tag for message attachment    */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure           */
char *tag)                         /*   file tag buffer to use             */
{
     struct gmetag *tmptag;
     struct fordef *tmpdef;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(msg != NULL);
     ASSERT(msg->forum == EMLID || fidxst(msg->forum));
     ASSERT(msg->flags&FILATT);
     ASSERT(tag != NULL);
     tmptag=(struct gmetag *)tag;
     if (fnd1st(&gmefb,dlname(msg),0)) {
          tmptag->fid=msg->forum;
          tmptag->mid=msg->msgid;
          tmptag->pos=(msg->forum == work->rdctx.fid ? work->rdfpos : 0L);
          if (tmptag->fid == EMLID) {
               tmptag->chg=edachg+edkchg*(gmefb.size/1024);
               if (!gtstcrd(work->rdctx.uid,tmptag->chg,FALSE)) {
                    return(GMECRD);
               }
          }
          else {
               if (gforac(work->rdctx.uid,tmptag->fid) < DLAXES) {
                    return(GMEACC);
               }
               if (!(msg->flags&FILAPV)
                && gforac(work->rdctx.uid,msg->forum) < OPAXES) {
                    return(GMENAPV);
               }
               tmpdef=getdef(tmptag->fid);
               tmptag->chg=tmpdef->chgadl+tmpdef->chgdpk*(gmefb.size/1024);
               if (!gtstcrd(work->rdctx.uid,tmptag->chg,FALSE)) {
                    return(GMECRD);
               }
          }
          return(GMEOK);
     }
     return(GMENFND);
}

long
msgintg(                           /* what's the message ID associated     */
char *tag)                         /*   with this tag?                     */
{
     return(((struct gmetag *)tag)->mid);
}

unsigned
forintg(                           /* what's the forum ID associated       */
char *tag)                         /*   with this tag?                     */
{
     return(((struct gmetag *)tag)->fid);
}

BOOL                               /*   ok to start download?              */
dlstart(                           /* current user starts tagged att dnload*/
char *tag)                         /*   file tag structure in use          */
{
     ASSERT(tag != NULL);
     ASSERT(((struct gmetag *)tag)->fid == EMLID
         || fidxst(((struct gmetag *)tag)->fid));
     return(dedcrd(((struct gmetag *)tag)->chg,FALSE));
}

void
dlabt(                             /* current user aborted att download    */
char *tag)                         /*   file tag structure in use          */
{
     ASSERT(tag != NULL);
     ASSERT(((struct gmetag *)tag)->fid == EMLID
         || fidxst(((struct gmetag *)tag)->fid));
     dedcrd(-((struct gmetag *)tag)->chg,TRUE);
}

void
dldone(                            /* current user finished att download   */
char *tag)                         /*   file tag structure in use          */
{
     ASSERT(tag != NULL);
     dlaud(usaptr->userid,tag);
}

BOOL                               /*   ok to download?                    */
gdlatt(                            /* tagged attachment downloaded for user*/
char *userid,                      /*   User-ID attachment downloaded for  */
char *tag)                         /*   file tag structure in use          */
{
     ASSERT(tag != NULL);
     if (gdedcrd(userid,((struct gmetag *)tag)->chg,FALSE,FALSE)) {
          dlaud(userid,tag);
          return(TRUE);
     }
     return(FALSE);
}

void
dlaud(                             /* audit a download                     */
char *userid,                      /*   User-ID attachment downloaded for  */
char *tag)                         /*   tag used for download              */
{
     struct gmetag *tmptag;
     struct message *tmpmsg;

     ASSERT(userid != NULL);
     ASSERT(tag != NULL);
     tmptag=(struct gmetag *)tag;
     ASSERT(tmptag->fid == EMLID || fidxst(tmptag->fid));
     ++sv.dwnlds;
     if (tmptag->fid == EMLID) {
          if (ednaud) {
               tmpmsg=tagmsg(tag);
               shocst("E-MAIL ATTACHMENT DOWNLOAD",   /* relies on AUDSIZ+20 */
                      "%.29s downld %.12s from %.29s",/* buffer in shocst()  */
                      userid,tmpmsg->attname,tmpmsg->from);
          }
     }
     else {
          if (fdnaud) {
               tmpmsg=tagmsg(tag);
               shocst("FORUM ATTACHMENT DOWNLOAD",    /* relies on AUDSIZ+20 */
                      "%.29s downld %.12s from %.15s",/* buffer in shocst()  */
                      userid,tmpmsg->attname,getfnm(tmpmsg->forum));
          }
     }
}

struct message *                   /*   pointer to temporary msg struct    */
tagmsg(                            /* get tagged message                   */
char *tag)                         /*   file tag structure in use          */
{
     struct gmetag *tmptag;

     ASSERT(tag != NULL);
     tmptag=(struct gmetag *)tag;
     ASSERT(tmptag->fid == EMLID || fidxst(tmptag->fid));
     inigmerq(utlwork);
     inormrd(utlwork,usaptr->userid,tmptag->fid,tmptag->mid);
     utlwork->rdfpos=tmptag->pos;
     if (grabmsg(utlwork,utlmsg,utltxt)) {
          clsgmerq(utlwork);
          return(utlmsg);
     }
     clsgmerq(utlwork);
     return(NULL);
}

long
firstnew(                          /* get first new message #              */
char *userid,                      /*   for this user ID                   */
unsigned forum)                    /*   in this forum                      */
{
     int i;
     long tmphi;
     struct qscfg *qsc;

     ASSERT(forum == EMLID || fidxst(forum));
     if (forum == EMLID) {
          return(usaptr->emllim);
     }
     else {
          qsc=othqsp(userid);
          i=qsidx(qsc,forum);
          if (i == NOIDX) {
               return(0L);
          }
          else {
               tmphi=igethi(qsc,i);
               return(tmphi < 0 ? -tmphi : tmphi);
          }
     }
}

void
inormrd(                           /* initialize "normal" read context     */
void *workb,                       /*   work area to initialize            */
char *userid,                      /*   user ID doing reading              */
unsigned forum,                    /*   forum to read from                 */
long msgid)                        /*   message to start at                */
{
     ASSERT(workb != NULL);
     ASSERT(gmerqopn(workb));
     ASSERT(forum == EMLID || fidxst(forum));
     inictx(workb,userid,forum == EMLID ? ESQTOU : FSQFOR,forum,msgid,0L);
}

void
forctx(                            /* change forum of read context         */
void *workb,                       /*   work area in use                   */
unsigned forum,                    /*   forum to change to                 */
int sequence)                      /*   new sequence to establish          */
{
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(seqok(sequence,forum));
     work->rdctx.fid=forum;
     work->rdctx.seq=sequence;
     work->rdfpos=0L;
     gmeulkr(work);
}

void
seqctx(                            /* change sequence of read context      */
void *workb,                       /*   work area in use                   */
int sequence)                      /*   sequence to change to              */
{
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(seqok(sequence,work->rdctx.fid));
     work->rdctx.seq=sequence;
     work->rdfpos=0L;
     gmeulkr(work);
}

void
msgctx(                            /* change cur message of read context   */
void *workb,                       /*   work area in use                   */
long msgid)                        /*   message ID to change to            */
{
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     work->rdctx.mid=msgid;
     work->rdfpos=0L;
     gmeulkr(work);
}

void
thrctx(                            /* change thread of read context        */
void *workb,                       /*   work area in use                   */
long thrid)                        /*   thread ID to change to             */
{
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     work->rdctx.tid=thrid;
     work->rdfpos=0L;
     gmeulkr(work);
}

void
inictx(                            /* initialize read context              */
void *workb,                       /*   work area to initialize            */
char *userid,                      /*   user ID doing reading              */
int sequence,                      /*   sequence to use                    */
unsigned forum,                    /*   forum to read from                 */
long msgid,                        /*   message to start at                */
long thrid)                        /*   thread to use (if any)             */
{
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(seqok(sequence,forum));
     ASSERT(forum == EMLID || fidxst(forum));
     ASSERT(msgid >= 0L);
     work->rdctx.seq=sequence;
     work->rdctx.fid=forum;
     work->rdctx.mid=msgid;
     work->rdctx.tid=thrid;
     stlcpy(work->rdctx.uid,userid,UIDSIZ);
     work->rdfpos=0L;
}

int                                /*   returns standard GME status codes  */
readpar(                           /* read parent of message               */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text)                        /*   message body text buffer           */
{
     unsigned tmpfid;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     switch (work->state3) {
     case START:
          if (work->rdctx.fid == EMLID) {
               if (work->rdctx.seq != ESQFRU
                && !gtstcrd(work->rdctx.uid,emrchg,FALSE)) {
                    return(GMECRD);
               }
          }
          else {
               if (gforac(work->rdctx.uid,work->rdctx.fid) < RDAXES) {
                    return(GMEACC);
               }
               if (!gtstcrd(work->rdctx.uid,getdef(work->rdctx.fid)->chgrdm,
                            FALSE)) {
                    return(GMECRD);
               }
          }
          gmeulkr(work);
          if (grabmsg(work,utlmsg,utltxt)) {
               if (utlmsg->rplto.msgid != 0L) {
                    if (work->rdctx.fid == EMLID) {
                         tmpfid=(unsigned)utlmsg->rplto.sysid;
                         if (tmpfid != EMLID) {
                              if (!fidxst(tmpfid)) {
                                   return(GMENFND);
                              }
                              if (gforac(work->rdctx.uid,tmpfid) < RDAXES) {
                                   return(GMEACC);
                              }
                         }
                    }
                    return(gme1rdg(work,&utlmsg->rplto,msg,text));
               }
               return(GMENFND);
          }
          return(GMEERR);
     default:
          catastro("GME level 3 state corrupted in readpar(), state=%d",
                   work->state3);
     }
     ASSERT(FALSE);
     clsgmerq(work);
     return(GMEERR);     /* this should never happen */
}

int                                /*   returns standard GME status codes  */
thrinfo(                           /* read info on a thread (orig message) */
void *workb,                       /*   GME work space (provided by caller)*/
int direct,                        /*   direction (0=same, 1=next, -1=prev)*/
unsigned *nmsgs,                   /*   number of messages in thread       */
struct message *msg,               /*   message header structure buffer    */
char *text)                        /*   message body text buffer           */
{
     int rc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(direct == 0 || direct == -1 || direct == 1);
     ASSERT(work->rdctx.fid == EMLID || nmsgs != NULL);
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     switch (work->state3) {
     case START:
          if (work->rdctx.fid != EMLID) {
               if (gforac(work->rdctx.uid,work->rdctx.fid) < RDAXES) {
                    work->state3=START;
                    return(GMEACC);
               }
          }
          work->state3=READING;
     case READING:
          rc=gme1rti(work,direct,nmsgs,msg,text);
          if (rc != GMEAGAIN) {
               work->state3=START;
          }
          return(rc);
     default:
          catastro("GME level 3 state corrupted in thrinfo(), state=%d",
                   work->state3);
     }
     ASSERT(FALSE);
     clsgmerq(work);
     return(GMEERR);     /* this should never happen */
}

int                                /*   returns standard GME status codes  */
readmsg(                           /* read current message in context      */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text)                        /*   message body text buffer           */
{
     int rc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     while (TRUE) {
          switch (work->state3) {
          case START:
               if (work->rdctx.fid == EMLID) {
                    if (work->rdctx.seq != ESQFRU
                     && !gtstcrd(work->rdctx.uid,emrchg,FALSE)) {
                         work->state3=START;
                         return(GMECRD);
                    }
               }
               else {
                    if (gforac(work->rdctx.uid,work->rdctx.fid) < RDAXES) {
                         work->state3=START;
                         return(GMEACC);
                    }
                    if (!gtstcrd(work->rdctx.uid,getdef(work->rdctx.fid)->chgrdm,
                                 FALSE)) {
                         work->state3=START;
                         return(GMECRD);
                    }
               }
               gmeulkr(work);
               if (work->rdctx.seq == FSQSCN) {
                    work->state3=SRCHING;
               }
               else {
                    work->state3=READING;
               }
               break;
          case READING:
               rc=gme1rdm(work,RDEXCT,msg,text);
               if (rc != GMEAGAIN) {
                    work->state3=START;
               }
               return(rc);
          case SRCHING:
               rc=gme2scn(work,RDEXCT,msg,text);
               if (rc != GMEAGAIN) {
                    work->state3=START;
               }
               return(rc);
          default:
               catastro("GME level 3 state corrupted in readmsg(), state=%d",
                        work->state3);
          }
     }
}

int                                /*   returns standard GME status codes  */
nearmsg(                           /* read nearest to cur msg in context   */
void *workb,                       /*   GME work space (provided by caller)*/
int nearop,                        /*   get near "style" to use            */
struct message *msg,               /*   message header structure buffer    */
char *text)                        /*   message body text buffer           */
{
     int rc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     switch (work->state3) {
     case START:
          if (work->rdctx.seq == FSQSCN) {
               work->state3=START;
               return(GMEERR);
          }
          if (work->rdctx.fid == EMLID) {
               if (work->rdctx.seq != ESQFRU
                && !gtstcrd(work->rdctx.uid,emrchg,FALSE)) {
                    work->state3=START;
                    return(GMECRD);
               }
          }
          else {
               if (gforac(work->rdctx.uid,work->rdctx.fid) < RDAXES) {
                    work->state3=START;
                    return(GMEACC);
               }
               if (!gtstcrd(work->rdctx.uid,getdef(work->rdctx.fid)->chgrdm,
                            FALSE)) {
                    work->state3=START;
                    return(GMECRD);
               }
          }
          gmeulkr(work);
          work->state3=READING;
     case READING:
          switch (nearop) {
          case LEGT:
               rc=gme1rdm(work,RDLEGT,msg,text);
               break;
          case LTGE:
               rc=gme1rdm(work,RDLTGE,msg,text);
               break;
          case GELT:
               rc=gme1rdm(work,RDGELT,msg,text);
               break;
          case GTLE:
               rc=gme1rdm(work,RDGTLE,msg,text);
               break;
          default:
               ASSERT(FALSE);
               break;
          }
          if (rc != GMEAGAIN) {
               work->state3=START;
          }
          return(rc);
     default:
          catastro("GME level 3 state corrupted in nearmsg(), state=%d",
                   work->state3);
     }
     ASSERT(FALSE);
     clsgmerq(work);
     return(GMEERR);     /* this should never happen */
}

int                                /*   returns standard GME status codes  */
nextmsg(                           /* read next message in context         */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text)                        /*   message body text buffer           */
{
     int rc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     while (TRUE) {
          switch (work->state3) {
          case START:
               if (work->rdctx.fid == EMLID) {
                    if (work->rdctx.seq != ESQFRU
                     && !gtstcrd(work->rdctx.uid,emrchg,FALSE)) {
                         work->state3=START;
                         return(GMECRD);
                    }
               }
               else {
                    if (gforac(work->rdctx.uid,work->rdctx.fid) < RDAXES) {
                         work->state3=START;
                         return(GMEACC);
                    }
                    if (!gtstcrd(work->rdctx.uid,getdef(work->rdctx.fid)->chgrdm,
                                 FALSE)) {
                         work->state3=START;
                         return(GMECRD);
                    }
               }
               gmeulkr(work);
               if (work->rdctx.seq == FSQSCN) {
                    work->state3=SRCHING;
               }
               else {
                    work->state3=READING;
               }
               break;
          case READING:
               rc=gme1rdm(work,RDNEXT,msg,text);
               if (rc != GMEAGAIN) {
                    work->state3=START;
               }
               return(rc);
          case SRCHING:
               rc=gme2scn(work,RDNEXT,msg,text);
               if (rc != GMEAGAIN) {
                    work->state3=START;
               }
               return(rc);
          default:
               catastro("GME level 3 state corrupted in nextmsg(), state=%d",
                        work->state3);
          }
     }
}

int                                /*   returns standard GME status codes  */
prevmsg(                           /* read previous message in context     */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text)                        /*   message body text buffer           */
{
     int rc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     while (TRUE) {
          switch (work->state3) {
          case START:
               if (work->rdctx.fid == EMLID) {
                    if (work->rdctx.seq != ESQFRU
                     && !gtstcrd(work->rdctx.uid,emrchg,FALSE)) {
                         work->state3=START;
                         return(GMECRD);
                    }
               }
               else {
                    if (gforac(work->rdctx.uid,work->rdctx.fid) < RDAXES) {
                         work->state3=START;
                         return(GMEACC);
                    }
                    if (!gtstcrd(work->rdctx.uid,getdef(work->rdctx.fid)->chgrdm,
                                 FALSE)) {
                         work->state3=START;
                         return(GMECRD);
                    }
               }
               gmeulkr(work);
               if (work->rdctx.seq == FSQSCN) {
                    work->state3=SRCHING;
               }
               else {
                    work->state3=READING;
               }
               break;
          case READING:
               rc=gme1rdm(work,RDPREV,msg,text);
               if (rc != GMEAGAIN) {
                    work->state3=START;
               }
               return(rc);
          case SRCHING:
               rc=gme2scn(work,RDPREV,msg,text);
               if (rc != GMEAGAIN) {
                    work->state3=START;
               }
               return(rc);
          default:
               catastro("GME level 3 state corrupted in prevmsg(), state=%d",
                        work->state3);
          }
     }
}

int                                /*   returns standard GME status codes  */
nextseq(                           /* read next message in a sequence      */
void *workb,                       /*   GME work space (provided by caller)*/
int sequence,                      /*   sequence to use                    */
struct message *msg,               /*   message header structure buffer    */
char *text)                        /*   message body text buffer           */
{
     int rc,savseq;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     while (TRUE) {
          switch (work->state3) {
          case START:
               if (work->rdctx.fid == EMLID) {
                    if (work->rdctx.seq != ESQFRU
                     && !gtstcrd(work->rdctx.uid,emrchg,FALSE)) {
                         work->state3=START;
                         return(GMECRD);
                    }
               }
               else {
                    if (gforac(work->rdctx.uid,work->rdctx.fid) < RDAXES) {
                         work->state3=START;
                         return(GMEACC);
                    }
                    if (!gtstcrd(work->rdctx.uid,getdef(work->rdctx.fid)->chgrdm,
                                 FALSE)) {
                         work->state3=START;
                         return(GMECRD);
                    }
               }
               savseq=work->rdctx.seq;
               work->rdctx.seq=sequence;
               gmeulkr(work);
               if (sequence == FSQSCN) {
                    work->state3=SRCHING;
               }
               else {
                    work->state3=READING;
               }
               break;
          case READING:
               rc=gme1rdm(work,RDNEXT,msg,text);
               work->rdctx.seq=savseq;
               if (rc != GMEAGAIN) {
                    work->state3=START;
               }
               return(rc);
          case SRCHING:
               rc=gme2scn(work,RDNEXT,msg,text);
               work->rdctx.seq=savseq;
               if (rc != GMEAGAIN) {
                    work->state3=START;
               }
               return(rc);
          default:
               catastro("GME level 3 state corrupted in nextseq(), state=%d",
                        work->state3);
          }
     }
}

int                                /*   returns standard GME status codes  */
prevseq(                           /* read previous message in a sequence  */
void *workb,                       /*   GME work space (provided by caller)*/
int sequence,                      /*   sequence to use                    */
struct message *msg,               /*   message header structure buffer    */
char *text)                        /*   message body text buffer           */
{
     int rc,savseq;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     while (TRUE) {
          switch (work->state3) {
          case START:
               if (work->rdctx.fid == EMLID) {
                    if (work->rdctx.seq != ESQFRU
                     && !gtstcrd(work->rdctx.uid,emrchg,FALSE)) {
                         work->state3=START;
                         return(GMECRD);
                    }
               }
               else {
                    if (gforac(work->rdctx.uid,work->rdctx.fid) < RDAXES) {
                         work->state3=START;
                         return(GMEACC);
                    }
                    if (!gtstcrd(work->rdctx.uid,getdef(work->rdctx.fid)->chgrdm,
                                 FALSE)) {
                         work->state3=START;
                         return(GMECRD);
                    }
               }
               savseq=work->rdctx.seq;
               work->rdctx.seq=sequence;
               gmeulkr(work);
               if (sequence == FSQSCN) {
                    work->state3=SRCHING;
               }
               else {
                    work->state3=READING;
               }
               break;
          case READING:
               rc=gme1rdm(work,RDPREV,msg,text);
               work->rdctx.seq=savseq;
               if (rc != GMEAGAIN) {
                    work->state3=START;
               }
               return(rc);
          case SRCHING:
               rc=gme2scn(work,RDPREV,msg,text);
               work->rdctx.seq=savseq;
               if (rc != GMEAGAIN) {
                    work->state3=START;
               }
               return(rc);
          default:
               catastro("GME level 3 state corrupted in prevseq(), state=%d",
                        work->state3);
          }
     }
}

int                                /*   returns standard GME status codes  */
gme2scn(                           /* scan for a message                   */
struct gmework *work,              /*   GME work space (provided by caller)*/
int direct,                        /*   read direction code                */
struct message *msg,               /*   message header structure buffer    */
char *text)                        /*   message body text buffer           */
{
     int rc;
     long tmpmid;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(work->rdctx.seq == FSQSCN);
     ASSERT(work->curscn != NULL);
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     switch (work->state2) {
     case START:
          work->orgfor=work->rdctx.fid;
          work->orgmid=work->rdctx.mid;
          work->state2=SRCHING;
     case SRCHING:
          work->rdctx.seq=FSQFOR;
          switch (direct) {
          case RDEXCT:
               rc=gme1rdm(work,direct,msg,text);
               if (rc != GMEAGAIN) {
                    work->state2=START;
                    if (rc == GMEOK && !chkscn(work,msg,text)) {
                         work->state2=START;
                         rc=GMENFND;
                    }
               }
               break;
          case RDNEXT:
               switch (rc=gme1rdm(work,direct,msg,text)) {
               case GMEAGAIN:
                    break;
               case GMEOK:
                    tmpmid=fstscnm(work->rdctx.uid,work->curscn,msg->forum);
                    if (msg->msgid <= tmpmid || !chkscn(work,msg,text)) {
                         if (msg->msgid <= tmpmid) {
                              msgctx(work,tmpmid);
                         }
                         callback(work,EVTNEWM,GMEOK,NULL);
                         rc=GMEAGAIN;
                    }
                    break;
               case GMENFND:
                    if (nxtscnf(work)) {
                         callback(work,EVTNEWF,GMEOK,getfnm(work->rdctx.fid));
                         rc=GMEAGAIN;
                    }
                    break;
               default:
                    work->state2=START;
                    work->rdctx.fid=work->orgfor;
                    work->rdctx.mid=work->orgmid;
                    work->rdfpos=0L;
                    break;
               }
               break;
          case RDPREV:
               switch (rc=gme1rdm(work,direct,msg,text)) {
               case GMEAGAIN:
                    break;
               case GMEOK:
                    tmpmid=fstscnm(work->rdctx.uid,work->curscn,msg->forum);
                    if (msg->msgid > tmpmid) {
                         if (!chkscn(work,msg,text)) {
                              callback(work,EVTNEWM,GMEOK,NULL);
                              rc=GMEAGAIN;
                         }
                         break;
                    }
                    else {
                         rc=GMENFND;
                    }
               case GMENFND:
                    if (prvscnf(work)) {
                         callback(work,EVTNEWF,GMEOK,getfnm(work->rdctx.fid));
                         rc=GMEAGAIN;
                    }
                    break;
               default:
                    work->state2=START;
                    work->rdctx.fid=work->orgfor;
                    work->rdctx.mid=work->orgmid;
                    work->rdfpos=0L;
                    break;
               }
               break;
          case RDLEGT:
          case RDLTGE:
          case RDGELT:
          case RDGTLE:
               rc=GMEERR;
               break;
          default:
               ASSERT(FALSE);
               clsgmerq(work);
               rc=GMEERR;
               break;
          }
          work->rdctx.seq=FSQSCN;
          if (rc != GMEAGAIN) {
               work->state2=START;
          }
          return(rc);
     default:
          catastro("GME level 2 state corrupted in gme2scn(), state=%d",
                   work->state2);
     }
     ASSERT(FALSE);
     clsgmerq(work);
     return(GMEERR);     /* this should never happen */
}

BOOL                               /*   returns TRUE if another forum      */
nxtscnf(                           /* set up for next forum in scan        */
struct gmework *work)              /*   GME work space (provided by caller)*/
{
     int i,j;
     int nfors,nfortot;
     unsigned *forlst;
     struct fordef *ford;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(work->curscn != NULL);
     nfors=work->curscn->nforums;
     forlst=work->curscn->forlst;
     if (work->curscn->flags&SCALL) {
          ASSERT(fididx(work->rdctx.fid) != NOIDX);
          nfortot=numforums();
          for (i=fididx(work->rdctx.fid)+1 ; i < nfortot ; i++) {
               ford=idxdef(i);
               ASSERT(ford != NULL);
               if (gforac(work->rdctx.uid,ford->forum) >= RDAXES) {
                    for (j=0 ; j < nfors ; j++) {
                         if (forlst[j] == ford->forum) {
                              break;
                         }
                    }
                    if (j == nfors) {
                         work->rdctx.fid=ford->forum;
                         break;
                    }
               }
          }
          if (i == nfortot) {
               return(FALSE);
          }
     }
     else {
          if (work->rdctx.fid == forlst[nfors-1]) {
               return(FALSE);
          }
          for (i=0 ; i < nfors-1 ; ++i) {
               if (work->rdctx.fid == forlst[i]) {
                    break;
               }
          }
          if (i == nfors-1) {
               ASSERT(FALSE);
               return(FALSE);
          }
          for (++i ; i < nfors ; ++i) {
               if (fidxst(forlst[i])
                && gforac(work->rdctx.uid,forlst[i]) >= RDAXES) {
                    work->rdctx.fid=forlst[i];
                    break;
               }
          }
          if (i == nfors) {
               return(FALSE);
          }
     }
     msgctx(work,fstscnm(work->rdctx.uid,work->curscn,work->rdctx.fid));
     return(TRUE);
}

BOOL                               /*   returns TRUE if another forum      */
prvscnf(                           /* set up for previous forum in scan    */
struct gmework *work)              /*   GME work space (provided by caller)*/
{
     int i,j;
     int nfors;
     unsigned *forlst;
     struct fordef *ford;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(work->curscn != NULL);
     nfors=work->curscn->nforums;
     forlst=work->curscn->forlst;
     if (work->curscn->flags&SCALL) {
          ASSERT(fididx(work->rdctx.fid) != NOIDX);
          for (i=fididx(work->rdctx.fid)-1 ; i > -1 ; i--) {
               ford=idxdef(i);
               ASSERT(ford != NULL);
               if (gforac(work->rdctx.uid,ford->forum) >= RDAXES) {
                    for (j=0 ; j < nfors ; j++) {
                         if (forlst[j] == ford->forum) {
                              break;
                         }
                    }
                    if (j == nfors) {
                         work->rdctx.fid=ford->forum;
                         break;
                    }
               }
          }
          if (i == -1) {
               return(FALSE);
          }
     }
     else {
          if (work->rdctx.fid == forlst[0]) {
               return(FALSE);
          }
          for (i=1 ; i < nfors ; ++i) {
               if (work->rdctx.fid == forlst[i]) {
                    break;
               }
          }
          if (i == nfors) {
               ASSERT(FALSE);
               return(FALSE);
          }
          for (--i ; i >= 0 ; --i) {
               if (fidxst(forlst[i])
                && gforac(work->rdctx.uid,forlst[i]) >= RDAXES) {
                    work->rdctx.fid=forlst[i];
                    break;
               }
          }
          if (i < 0) {
               return(FALSE);
          }
     }
     msgctx(work,LASTM);
     return(TRUE);
}

unsigned                           /*   returns EMLID of no forums         */
fstscnf(                           /* get first forum ID                   */
char *userid,                      /*   User-ID doing scan                 */
struct otscan *ots)                /*   in this search                     */
{
     int i;
     struct fordef *tmpdef;

     ASSERT(ots != NULL);
     if (ots->flags&SCALL) {
          tmpdef=nxtdefp("");
          while (tmpdef != NULL) {
               if (gforac(userid,tmpdef->forum) >= RDAXES
                && scnfidx(ots,tmpdef->forum) == NOIDX) {
                    return(tmpdef->forum);
               }
               tmpdef=nxtdefp(tmpdef->name);
          }
     }
     else {
          for (i=0 ; i < ots->nforums ; ++i) {
               ASSERT(fidxst(ots->forlst[i]));
               if (gforac(userid,ots->forlst[i]) >= RDAXES) {
                    return(ots->forlst[i]);
               }
          }
     }
     return(EMLID);
}

int                                /*   returns NOIDX if not found         */
scnfidx(                           /* get index of forum                   */
struct otscan *ots,                /*   in this scan                       */
unsigned forum)                    /*   forum ID to find                   */
{
     int i;

     for (i=0 ; i < ots->nforums ; ++i) {
          if (ots->forlst[i] == forum) {
               return(i);
          }
     }
     return(NOIDX);
}

long
fstscnm(                           /* get first message #                  */
char *userid,                      /*   User-ID doing scan                 */
struct otscan *ots,                /*   in this scan                       */
unsigned forum)                    /*   in this forum (in scan)            */
{
     long stmid,tmpmid;

     stmid=ots->stmsgid;
     if (ots->flags&SCNEW) {
          tmpmid=firstnew(userid,forum);
          if (tmpmid > stmid) {
               stmid=tmpmid;
          }
     }
     return(stmid);
}

BOOL
chkscn(                            /* check if message is in one-time scan */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text)                        /*   message body text buffer           */
{
     char kwdlst[MAXSKWD];
     char srchstr[MAXSKWD];

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(work->curscn != NULL);
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     if ((work->curscn->flags&SCNEW)
      && msg->msgid <= firstnew(work->rdctx.uid,msg->forum)) {
          return(FALSE);
     }
     if ((work->curscn->flags&SCATT) && !(msg->flags&FILAPV)) {
          return(FALSE);
     }
     if ((work->curscn->flags&SCTOU) && !sameas(msg->to,work->rdctx.uid)) {
          return(FALSE);
     }
     if ((work->curscn->flags&SCFRU) && !sameas(msg->from,work->rdctx.uid)) {
          return(FALSE);
     }
     if (msg->msgid <= work->curscn->stmsgid) {
          return(FALSE);
     }
     if (*work->curscn->keywds != '\0') {
          if (!parsrch(work->curscn->keywds,kwdlst,srchstr)) {
               return(FALSE);
          }
          return(chkwds(hdrstr(msg),text,kwdlst,srchstr));
     }
     return(TRUE);
}

BOOL                               /*   returns FALSE if invalid search str*/
parsrch(                           /* parse search string                  */
char *usrstr,                      /*   string user typed in               */
char *kwdbuf,                      /*   buffer to store keywords in        */
char *search)                      /*   buffer to store search template    */
{
     int loop,loop2;
     char *current,*new;
     char tmpstr[MAXSKWD];

     ASSERT(usrstr != NULL);
     ASSERT(kwdbuf != NULL);
     ASSERT(search != NULL);
     if (strlen(usrstr) >= MAXSKWD) {
          return(FALSE);
     }
     stlcpy(tmpstr,usrstr,MAXSKWD);
     unpad(tmpstr);
     while (strsrep(tmpstr,"?","")) {
     }
     while (samend(tmpstr," OR")) {
          tmpstr[strlen(tmpstr)-3]='\0';
     }
     while (samend(tmpstr," AND")) {
          tmpstr[strlen(tmpstr)-4]='\0';
     }
     while (samend(tmpstr," XOR")) {
          tmpstr[strlen(tmpstr)-4]='\0';
     }
     while (samend(tmpstr," NOT")) {
          tmpstr[strlen(tmpstr)-4]='\0';
     }
     while (strsrep(tmpstr," AND "," & ")) {
     }
     while (strsrep(tmpstr," OR "," | ")) {
     }
     while (strsrep(tmpstr," XOR "," ^ ")) {
     }
     while (strsrep(tmpstr," NOT "," ! ")) {
     }
     if (sameto("NOT ",tmpstr)) {
          strsrep(tmpstr,"NOT ","!");
     }
     stlcpy(kwdbuf,tmpstr,MAXSKWD);
     unpad(kwdbuf);
     strrpl(kwdbuf,'&',' ');
     strrpl(kwdbuf,'|',' ');
     strrpl(kwdbuf,'^',' ');
     strrpl(kwdbuf,'!',' ');
     strrpl(kwdbuf,'(',' ');
     strrpl(kwdbuf,')',' ');
     while (strsrep(kwdbuf,"  "," ")) {
     }
     while (*kwdbuf == ' ') {
          movmem(&kwdbuf[1],kwdbuf,strlen(&kwdbuf[1])+1);
     }
     stlcpy(search,tmpstr,MAXSKWD);
     for (loop=0 ; TRUE ; ++loop) {
          current=itemidxd(kwdbuf,loop," ");
          if (*current == '\0') {
               break;
          }
          strsrep(search,current,"?");
     }
     do {
          loop2=0;
          while (strsrep(search," ","")) {
               loop2=1;
          }
          while (strsrep(search,"??","?&?")) {
               loop2=1;
          }
          while (strsrep(search,"?!","?&!")) {
               loop2=1;
          }
          while (strsrep(search,"&&","&")) {
               loop2=1;
          }
          while (strsrep(search,"!&","!")) {
               loop2=1;
          }
          while (strsrep(search,"&|","|")) {
               loop2=1;
          }
          while (strsrep(search,"|&","|")) {
               loop2=1;
          }
          while (strsrep(search,"&^","^")) {
               loop2=1;
          }
          while (strsrep(search,"^&","^")) {
               loop2=1;
          }
          while (strsrep(search,"!!","")) {
               loop2=1;
          }
          while (strsrep(search,"()","")) {
               loop2=1;
          }
          while (strsrep(search,"(&","(")) {
               loop2=1;
          }
          while (strsrep(search,"(|","(")) {
               loop2=1;
          }
          while (strsrep(search,"(^","(")) {
               loop2=1;
          }
          while (strsrep(search,"&)",")")) {
               loop2=1;
          }
          while (strsrep(search,"|)",")")) {
               loop2=1;
          }
          while (strsrep(search,"||","|")) {
               loop2=1;
          }
          while (strsrep(search,"^)",")")) {
               loop2=1;
          }
          while (strsrep(search,"^^","^")) {
               loop2=1;
          }
     } while (loop2);
     loop2=0;
     for (new=search ; *new != '\0' ; new++) {
          if (*new == '(') {
               loop2++;
          }
          else if (*new == ')') {
               loop2--;
          }
          if (loop2 < 0) {
               break;
          }
     }
     if (loop2 != 0) {
          return(FALSE);
     }
     while (search[0] == '|') {
          movmem(&search[1],search,strlen(&search[1])+1);
     }
     while (search[0] == '^') {
          movmem(&search[1],search,strlen(&search[1])+1);
     }
     while (search[0] == '&') {
          movmem(&search[1],search,strlen(&search[1])+1);
     }
     while (search[strlen(search)-1] == '!') {
          search[strlen(search)-1]='\0';
     }
     return(TRUE);
}

char *                             /*   returns ptr to string buffer       */
hdrstr(                            /* generate msg header string for search*/
struct message *msg)               /*   message header structure buffer    */
{
     ASSERT(msg != NULL);
     ASSERT(fidxst(msg->forum));
     setmbk(gmemb);
     clrprf();
     prfmsg(SCNHDR,
            datlin(msg->crdate,msg->crtime),
            getfnm(msg->forum),
            msg->from,
            l2as(msg->msgid),
            msg->to,
            (msg->flags&EXEMPT) ? "*EXEMPT*" : "",
            msg->topic,
            (msg->flags&FILATT) ? spr("File: %s",msg->attname) : "",
            *msg->history == '\0' ? "" : spr("(%s)",msg->history),
            nrstr(msg->nrpl));
     rstmbk();
     prf2str(utltxt,TXTLEN);
     clrprf();
     return(utltxt);
}

char *
datlin(                            /* build date/time string               */
unsigned date,                     /*   from DOS packed date               */
unsigned time)                     /*   and DOS packed time                */
{
     static char retval[40];

     strcpy(retval,prnday(date,9));
     strcat(retval,", ");
     strcat(retval,prndat(22,date,','));
     strcat(retval,"  ");
     strcat(retval,prntim(2,time));
     return(retval);
}

char *
nrstr(                             /* generate "number of replies" string  */
int nr)                            /*   number of replies                  */
{
     ASSERT(nr >= 0);
     switch (nr) {
     case 0:
          return("");
     case 1:
          return("(1 reply)");
     default:
          return(spr("(%d replies)",nr));
     }
}

BOOL
chkwds(                            /* check if a string matches keywords   */
char *hstr,                        /*   message header to check            */
char *tstr,                        /*   message text to check              */
char *kwds,                        /*   ' '-delimited keyword list         */
char *srch)                        /*   search template string             */
{
     int i;
     char *cp,*wd;
     char template[MAXSKWD];

     ASSERT(hstr != NULL);
     ASSERT(tstr != NULL);
     ASSERT(kwds != NULL);
     ASSERT(srch != NULL);
     stlcpy(template,srch,MAXSKWD);
     for (i=0,cp=template; TRUE ; ++i) {
          cp=strchr(cp,'?');
          wd=itemidxd(kwds,i," ");
          if (cp == NULL || *wd == '\0') {
               break;
          }
          if (wrdinstr(wd,hstr) || wrdinstr(wd,tstr)) {
               *cp='1';
          }
          else {
               *cp='0';
          }
     }
     return(deparse(template));
}

BOOL
wrdinstr(                          /* is a word in a string?               */
char *wordstr,                     /*   word to search for                 */
char *srchstr)                     /*   string to search in                */
{
     unsigned i,wordlen,srchlen,looplim;

     ASSERT(wordstr != NULL);
     ASSERT(srchstr != NULL);
     if (sameto(wordstr,srchstr)) {
          return(TRUE);
     }
     wordlen=strlen(wordstr);
     srchlen=strlen(srchstr);
     if (wordlen > srchlen) {
          return(FALSE);
     }
     looplim=srchlen-wordlen+1;
     for (i=1,++srchstr ; i < looplim ; ++i,++srchstr) {
          if (sameto(wordstr,srchstr) && isspace(srchstr[-1])) {
               return(TRUE);
          }
     }
     return(FALSE);
}

BOOL
deparse(                           /* reduces and/or/not primitive to y/n  */
char *p)                           /*   keyword primitive (!0&(0|!(1^0)))  */
{
     char image[MAXSKWD];

     while (strlen(p) > 1) {
          stlcpy(image,p,MAXSKWD);
          do {
               do {
                    do {
                         do {
                              do {
                              } while (strsrep(p,"(1)","1")
                                 || strsrep(p,"(0)","0"));
                         } while (strsrep(p,"!1","0") || strsrep(p,"!0","1"));
                    } while (strsrep(p,"1&1","1") || strsrep(p,"1&0","0")
                       || strsrep(p,"0&1","0") || strsrep(p,"0&0","0"));
               } while (strsrep(p,"1^1","0") || strsrep(p,"1^0","1")
                  || strsrep(p,"0^1","1") || strsrep(p,"0^0","0"));
          } while (strsrep(p,"1|1","1") || strsrep(p,"1|0","1")
             || strsrep(p,"0|1","1") || strsrep(p,"0|0","0"));
          if (strchr(p,'1') == NULL && strchr(p,'0') == NULL
           || sameas(p,image)) {
               return(FALSE);
          }
     }
     return(*p == '1');
}

int                                /*   returns standard GME status codes  */
markread(                          /* mark a message as read               */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text)                        /*   message body text buffer           */
{
     int i,rc;
     long tmphi;
     struct qscfg *qsc;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     switch (work->state3) {
     case START:
          if (msg->forum == EMLID) {
               if (work->rdctx.seq != ESQFRU) {
                    gdedcrd(work->rdctx.uid,emrchg,FALSE,TRUE);
               }
          }
          else {
               ASSERT(fidxst(msg->forum));
               gdedcrd(work->rdctx.uid,getdef(msg->forum)->chgrdm,FALSE,TRUE);
          }
          if (work->rdctx.fid == EMLID) {
               if (work->rdctx.seq == ESQTOU
                || (work->rdctx.seq == ESQTHR
                 && sameas(msg->to,work->rdctx.uid))) {
                    if (onsysn(work->rdctx.uid,TRUE)) {
                         if (msg->msgid > othuap->emllim) {
                              othuap->emllim=msg->msgid;
                         }
                    }
                    else {
                         setbtv(accbb);
                         if (acqbtv(NULL,work->rdctx.uid,0)) {
                              othuap=(struct usracc *)accbb->data;
                              if (msg->msgid > othuap->emllim) {
                                   othuap->emllim=msg->msgid;
                                   updbtv(NULL);
                              }
                         }
                         rstbtv();
                    }
                    if (msg->flags&RECREQ) {
                         work->state3=GENRRR;
                         formrr(msg,text);
                         chkrqs(work,msg);
                    }
                    else {
                         work->state3=START;
                         return(GMEOK);
                    }
               }
               else {
                    work->state3=START;
                    return(GMEOK);
               }
          }
          else {
               qsc=othqsp(work->rdctx.uid);
               if (qsc == NULL) {
                    return(GMEERR);
               }
               i=qsidx(qsc,msg->forum);
               if (i == NOIDX) {
                    i=absadqs(qsc,msg->forum);
                    if (i != NOIDX) {
                         isethi(qsc,i,-msg->msgid);
                         if (qsoffln(qsc)) {
                              setbtv(qscbb);
                              upvbtv(qsc,qsrlen(qsc->nforums));
                              rstbtv();
                         }
                    }
               }
               else {
                    tmphi=igethi(qsc,i);
                    if (tmphi <= 0L) {
                         if (msg->msgid > -tmphi) {
                              isethi(qsc,i,-msg->msgid);
                              if (qsoffln(qsc)) {
                                   setbtv(qscbb);
                                   upvbtv(qsc,qsrlen(qsc->nforums));
                                   rstbtv();
                              }
                         }
                    }
                    else if (msg->msgid > tmphi) {
                         isethi(qsc,i,msg->msgid);
                         if (qsoffln(qsc)) {
                              setbtv(qscbb);
                              upvbtv(qsc,qsrlen(qsc->nforums));
                              rstbtv();
                         }
                    }
               }
               work->state3=START;
               return(GMEOK);
          }
     case GENRRR:
          rc=gme2wnm(work,msg,text,NULL);
          if (rc != GMEAGAIN) {
               if (rc > GMEAGAIN) {
                    hdlntfy(RTRCPNOT,work,msg);
                    work->state3=REGET;
                    return(GMEAGAIN);
               }
               work->state3=START;
          }
          return(rc);
     case REGET:
          work->state3=START;
          if (work->flags&FWDMSG) {
               rstafwd(work,msg);
               rc=GMEAFWD;
          }
          else {
               rc=GMERRG;
          }
          if (grabmsg(work,msg,text)) {
               msg->flags&=~RECREQ;
               if (msg->flags&FRCLR) {
                    clrfrom(msg);
               }
               updmsg(work,msg,text);
               uclfrom(msg);
               clrwrt(work);
               return(rc);
          }
          return(GMENRGM);
     default:
          catastro("GME level 3 state corrupted in markread(), state=%d",
                   work->state3);
     }
     ASSERT(FALSE);
     clsgmerq(work);
     return(GMEERR);     /* this should never happen */
}

void
formrr(                            /* form return receipt message          */
struct message *msg,               /*   message header structure to use    */
char *text)                        /*   text buffer to use                 */
{
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     setmbk(gmemb);
     msg->forum=EMLID;
     stlcpy(text,msg->from,MAXADR);
     stlcpy(msg->from,msg->to,MAXADR);
     stlcpy(msg->to,text,MAXADR);
     sprintf(text,getmsg(RRTEXT),msg->from,l2as(msg->msgid),
             ncedat(msg->crdate),nctime(msg->crtime),msg->topic);
     stlcpy(msg->topic,spr(rrtpc,l2as(msg->msgid)),TPCSIZ);
     msg->flags=(NOMOD|NODEL);
     ininew(msg);
     msg->thrid=cmptid(msg);
     rstmbk();
}

int                                /*   returns standard GME status codes  */
delmsg(                            /* delete current message in context    */
void *workb)                       /*   GME work space (provided by caller)*/
{
     BOOL toflg,frflg;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     switch (work->state3) {
     case START:
          if (chkcfl(work)) {
               work->state3=START;
               return(GMEUSE);
          }
          if (grabmsg(work,utlmsg,utltxt)) {
               toflg=sameas(utlmsg->to,work->rdctx.uid);
               frflg=sameas(utlmsg->from,work->rdctx.uid);
               if (work->rdctx.fid == EMLID) {
                    if ((utlmsg->flags&NODEL) && frflg && !toflg) {
                         work->state3=START;
                         return(GMENDEL);
                    }
                    else if (!(frflg || toflg)) {
                         work->state3=START;
                         return(GMENFND);
                    }
               }
               else {
                    if (gforac(work->rdctx.uid,work->rdctx.fid) < OPAXES
                     && !frflg) {
                         work->state3=START;
                         return(GMEACC);
                    }
               }
               work->state3=DELETNG;
          }
          else {
               work->state3=START;
               return(GMENFND);
          }
     case DELETNG:
          if (gme1dlm(work)) {
               work->state3=START;
               return(GMEOK);
          }
          else {
               work->state3=START;
               return(GMEERR);
          }
     default:
          catastro("GME level 3 state corrupted in delmsg(), state=%d",
                   work->state3);
     }
     ASSERT(FALSE);
     clsgmerq(work);
     return(GMEERR);     /* this should never happen */
}

int                                /*   returns standard GME status codes  */
modmsg(                            /* modify current message in context    */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text)                        /*   message body text buffer           */
{
     BOOL frflg;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     switch (work->state3) {
     case START:
          if (chkcfl(work)) {
               work->state3=START;
               return(GMEUSE);
          }
          if (grabmsg(work,utlmsg,utltxt)) {
               frflg=sameas(utlmsg->from,work->rdctx.uid);
               if (work->rdctx.fid == EMLID) {
                    if (frflg) {
                         if (utlmsg->flags&NOMOD) {
                              work->state3=START;
                              return(GMENMOD);
                         }
                    }
                    else {
                         work->state3=START;
                         return(GMENFND);
                    }
               }
               else {
                    if (gforac(work->rdctx.uid,work->rdctx.fid) < OPAXES
                     && !frflg) {
                         work->state3=START;
                         return(GMEACC);
                    }
               }
               work->state3=WRITING;
               stlcpy(utlmsg->topic,msg->topic,TPCSIZ);
               if (utlmsg->flags&FRCLR) {
                    clrfrom(utlmsg);
               }
               if (utlmsg->flags&TOCLR) {
                    clrto(utlmsg);
               }
          }
          else {
               work->state3=START;
               return(GMENFND);
          }
     case WRITING:
          if (updmsg(work,utlmsg,text)) {
               work->state3=START;
               return(GMEOK);
          }
          else {
               work->state3=START;
               return(GMEERR);
          }
     default:
          catastro("GME level 3 state corrupted in modmsg(), state=%d",
                   work->state3);
     }
     ASSERT(FALSE);
     clsgmerq(work);
     return(GMEERR);     /* this should never happen */
}

int                                /*   returns standard GME status codes  */
aprvmsg(                           /* approve/unapprove current message    */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text,                        /*   message body text buffer           */
BOOL approve)                      /*   TRUE=approve, FALSE=unapprove      */
{
     struct fordef *tmpdef;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(work->rdfpos != NULL);
     switch (work->state3) {
     case START:
          if (msg->forum == EMLID) {
               return(GMEERR);
          }
          if (gforac(work->rdctx.uid,msg->forum) < OPAXES) {
               return(GMEACC);
          }
          if (!(msg->flags&FILATT)) {
               return(GMENOAT);
          }
          if (approve) {
               msg->flags|=FILAPV;
          }
          else {
               msg->flags&=~FILAPV;
          }
          if (updmsg(work,msg,text)) {
               tmpdef=getdef(msg->forum);
               if (approve) {
                    --tmpdef->nw4app;
                    ++tmpdef->nfiles;
               }
               else {
                    ++tmpdef->nw4app;
                    --tmpdef->nfiles;
               }
               return(GMEOK);
          }
          else {
               return(GMEERR);
          }
     default:
          catastro("GME level 3 state corrupted in aprvmsg(), state=%d",
                   work->state3);
     }
     ASSERT(FALSE);
     clsgmerq(work);
     return(GMEERR);     /* this should never happen */
}

int                                /*   returns standard GME status codes  */
exmtmsg(                           /* exempt/unexempt current message      */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text,                        /*   message body text buffer           */
BOOL exempt)                       /*   TRUE=exempt, FALSE=unexempt        */
{
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(ctxok(&work->rdctx));
     ASSERT(work->rdfpos != NULL);
     switch (work->state3) {
     case START:
          if (msg->forum == EMLID) {
               return(GMEERR);
          }
          if (gforac(work->rdctx.uid,msg->forum) < OPAXES) {
               return(GMEACC);
          }
          if (exempt) {
               msg->flags|=EXEMPT;
          }
          else {
               msg->flags&=~EXEMPT;
          }
          if (updmsg(work,msg,text)) {
               return(GMEOK);
          }
          else {
               return(GMEERR);
          }
     default:
          catastro("GME level 3 state corrupted in exmtmsg(), state=%d",
                   work->state3);
     }
     ASSERT(FALSE);
     clsgmerq(work);
     return(GMEERR);     /* this should never happen */
}

int                                /*   returns VAL code                   */
setafwd(                           /* set auto-forwardee for current user  */
char *newfwde)                     /*   new auto-forwardee                 */
{
     int rc;
     struct qscfg *tmpqsp;

     tmpqsp=uqsptr(usrnum);
     if (*newfwde == '\0') {
          setmem(tmpqsp->fwdee,MAXADR,0);
          return(VALYES);
     }
     if (strlen(newfwde) >= MAXADR || isdlst(newfwde) || isforum(newfwde)) {
          return(VALNO);
     }
     inigmerq(utlwork);
     rc=valadr(utlwork,usaptr->userid,newfwde,EMLID);
     clsgmerq(utlwork);
     if (rc == VALCRD) {
          rc=VALYES;
     }
     if (rc == VALYES) {
          tmpqsp->fwdate=today();
          stlcpy(tmpqsp->fwdee,newfwde,MAXADR);
     }
     return(rc);
}

int                                /*   returns standard GME status codes  */
chksnd(                            /* check credits/access before sending  */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *filatt)                      /*   file attachment (if any)           */
{
     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     if (!(work->flags&ADROK)
     || (!(work->flags&ATTOK) && (msg->flags&FILATT))
     || (!(work->flags&RRROK) && (msg->flags&RECREQ))
     || (!(work->flags&PRIOK) && (msg->flags&PRIMSG))) {
          return(GMEERR);
     }
     if (msg->flags&FILATT) {
          ASSERT(filatt != NULL);
          ASSERT((msg->flags&FILIND)
              || sameto(attpth(msg->forum == EMLID && isforum(msg->to)
                             ? getfid(msg->to+1) : msg->forum),
                        normspec((char *)tmpbuf,filatt)));
          if (!fexist(filatt)) {
               return(GMEIVA);
          }
          work->attsiz=gmefb.size;
     }
     addchg(work,msg);
     if (!gtstcrd(msg->from,work->basechg,FALSE)) {
          return(GMECRD);
     }
     return(GMEOK);
}

int                                /*   returns standard GME status codes  */
chkcf(                             /* check credits/access for copy/forward*/
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *filatt)                      /*   file attachment (if any)           */
{
     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     if (!(work->flags&ADROK)
     || (!(work->flags&ATTOK) && (msg->flags&FILATT))
     || (!(work->flags&RRROK) && (msg->flags&RECREQ))
     || (!(work->flags&PRIOK) && (msg->flags&PRIMSG))) {
          return(GMEERR);
     }
     if (msg->flags&FILATT) {
          if (fexist(filatt)) {
               work->attsiz=gmefb.size;
          }
          else {
               msg->flags&=~(FILATT|FILIND|FILAPV);
          }
     }
     addchg(work,msg);
     return(GMEOK);
}

void
addchg(                            /* add up charges for current message   */
struct gmework *work,              /*   work area in use                   */
struct message *msg)               /*   new message structure              */
{
     work->basechg=sendchg(work,msg,work->attsiz);
}

long
sendchg(                           /* total charges to send a message      */
void *workb,                       /*   work area in use                   */
struct message *msg,               /*   new message structure              */
long attsiz)                       /*   attachment size                    */
{
     long totchg;
     struct gmework *work=(struct gmework *)workb;

     totchg=work->basechg;
     if (msg->flags&FILATT) {
          totchg+=work->attchg+(attsiz/1024L)*work->apkchg;
     }
     if (msg->flags&RECREQ) {
          totchg+=work->rrrchg;
     }
     if (msg->flags&PRIMSG) {
          totchg+=work->prichg;
     }
     return(totchg);
}

void
chkrqs(                            /* check recipient's quickscan          */
struct gmework *work,              /*   work area in use                   */
struct message *msg)               /*   new message structure              */
{                                  /* (checks autofwd & forum to E-mail)   */
     struct qscfg *tmpqsp;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     if (islocal(msg->to) && (tmpqsp=othqsp(msg->to)) != NULL) {
          if (msg->forum == EMLID) {
               if (*tmpqsp->fwdee != '\0') {
                    chkafwd(work,tmpqsp,msg);
               }
          }
          else if ((tmpqsp->flags&FORUM2)
                && qforac(tmpqsp,msg->forum) >= RDAXES) {
               work->flags|=CPY2E;
          }
     }
}

void
chkafwd(                           /* check out auto forwarding            */
struct gmework *work,              /*   work area in use                   */
struct qscfg *rcpqsp,              /*   pointer to recipient's quickscan   */
struct message *msg)               /*   new message structure              */
{
     int i;
     long tmpflg,rcpchg;
     struct exporter *exptr;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     ASSERT(msg->forum == EMLID);
     ASSERT(uidxst(msg->to));
     tmpflg=msg->flags;
     if (isexpa(rcpqsp->fwdee)) {
          i=expidx(rcpqsp->fwdee);
          if (i != NOIDX && uhskey(msg->to,exphlr[i]->wrtkey)) {
               exptr=exphlr[i];
               work->rcpchg=0L;
               rcpchg=exptr->wrtchg;
               if (msg->flags&FILATT) {
                    if ((exptr->flags&EXPATT)
                     && uhskey(msg->to,exptr->attkey)) {
                         rcpchg+=exptr->attchg;
                         rcpchg+=exptr->apkchg*(work->attsiz/1024);
                    }
                    else {
                         noatt(msg);
                    }
               }
               if (msg->flags&RECREQ) {
                    if ((exptr->flags&EXPRRR)
                     && uhskey(msg->to,exptr->rrrkey)) {
                         rcpchg+=exptr->rrrchg;
                    }
                    else {
                         msg->flags&=~RECREQ;
                    }
               }
               if (msg->flags&PRIMSG) {
                    if ((exptr->flags&EXPPRI)
                     && uhskey(msg->to,exptr->prikey)) {
                         rcpchg+=exptr->prichg;
                    }
                    else {
                         msg->flags&=~PRIMSG;
                    }
               }
               if (rcpchg > 0L && chgfwd) {
                    if (!gtstcrd(msg->to,rcpchg,FALSE)) {
                         msg->flags=tmpflg;
                         return;
                    }
                    work->rcpchg=rcpchg;
               }
          }
          else {
               return;
          }
     }
     else if (!(islocal(rcpqsp->fwdee) && uidxst(rcpqsp->fwdee)
             && ((struct usracc *)accbb->data)->credat <= rcpqsp->fwdate)) {
          *rcpqsp->fwdee='\0';
          if (qsoffln(rcpqsp)) {   /* assumes no qscbb access since othqsp */
               setbtv(qscbb);
               upvbtv(rcpqsp,qsrlen(rcpqsp->nforums));
               rstbtv();
               work->flags|=CYCFLG;
               msg->flags=tmpflg;
          }
          return;
     }
     work->flags|=FWDMSG;
     setmem(&msg->rplto,sizeof(struct globid),0);
     addhist(msg->history,spr(AUTFWD,msg->to));
     stlcpy(work->auxto,msg->to,UIDSIZ);
     stlcpy(msg->to,rcpqsp->fwdee,MAXADR);
}

void
rstafwd(                           /* restore msg->to after auto-forward   */
struct gmework *work,              /*   work area in use                   */
struct message *msg)               /*   message structure                  */
{                                  /*   (also puts fwdee in extinf)        */
     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     stlcpy(extinf,msg->to,MAXADR);
     stlcpy((char *)tmpbuf,msg->to,MAXADR);
     stlcpy(msg->to,work->auxto,UIDSIZ);
     stlcpy(work->auxto,(char *)tmpbuf,UIDSIZ);
     stlcpy(msg->history,work->auxhist,HSTSIZ);
}

void
chkfor(                            /* check for E-mail to a forum          */
struct message *msg)               /*   new message structure              */
{
     ASSERT(msg != NULL);
     if (msg->forum == EMLID && isforum(msg->to)) {
          ASSERT(fnmxst(msg->to+1));
          msg->forum=getfid(msg->to+1);
          strcpy(msg->to,ALLINF);
     }
}

void
ininew(                            /* initialize fields of a new message   */
struct message *msg)               /*   new message structure              */
{
     ASSERT(msg != NULL);
     iniamsg(msg);
     *msg->history='\0';
     setmem(&msg->rplto,sizeof(struct globid),0);
}

void
iniamsg(                           /* init auto-filled fields of a message */
struct message *msg)               /*   new message structure              */
{
     ASSERT(msg != NULL);
     msg->msgid=newmid();
     setgid(msg);
     msg->crdate=today();
     msg->crtime=now();
     msg->nrpl=0;
}

void
inicfmsg(                          /* init auto-filled fields for copy/fwd */
struct message *msg)               /*   message header structure           */
{
     ASSERT(msg != NULL);
     msg->msgid=newmid();
     setgid(msg);
     msg->nrpl=0;
}

void
setflgs(                           /* set only appropriate message flags   */
struct message *msg,               /*   for new message                    */
char *userid)                      /*   user-id sending message            */
{
     long tmpflg;

     ASSERT(msg != NULL);
     ASSERT(msg->forum == EMLID || fidxst(msg->forum));
     tmpflg=(msg->flags&FILATT);
     if (tmpflg&FILATT) {
          tmpflg|=(msg->flags&FILIND);
          if (msg->forum == EMLID || gforac(userid,msg->forum) >= COAXES) {
               tmpflg|=FILAPV;
          }
     }
     tmpflg|=(msg->flags&RECREQ);
     tmpflg|=(msg->flags&PRIMSG);
     msg->flags=tmpflg;
}

void
setgid(                            /* set global ID as local system        */
struct message *msg)               /*   message structure to set up        */
{
     movmem(msysid,&(msg->gmid.sysid),sizeof(long));
     msg->gmid.msgid=msg->msgid;
}

BOOL
iniecho(                           /* start up forum echoing               */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg)               /*   new message structure              */
{
     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     ASSERT(msg->forum != EMLID);
     if (work->flags&NOECHO) {
          return(FALSE);
     }
     if (getdef(msg->forum)->necho > 0) {
          work->echonum=0;
          return(TRUE);
     }
     return(FALSE);
}


int                                /*   returns standard GME status codes  */
gme1echo(                          /* send message to forum echoes         */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt)                      /*   path+file name of att (if any)     */
{
     int rc;
     long tmpflg;
     char *curecho;
     struct fordef *tmpdef;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     ASSERT(msg->forum != EMLID);
     ASSERT(text != NULL);
     while (TRUE) {
          switch (work->state1) {
          case START:
               work->state1=NXTECHO;
          case NXTECHO:
               tmpdef=getdef(msg->forum);
               ASSERT(work->echonum < tmpdef->necho);
               tmpflg=msg->flags;
               curecho=((adr_t *)tmpdef->echoes)[work->echonum];
               if (expidx(curecho) == NOIDX) {
                    invecho(curecho,getfnm(msg->forum));
                    work->state1=GETOUT;
                    break;
               }
               work->state1=WRITING;
               if (msg->flags&FILATT) {
                    ASSERT(filatt != NULL);
                    stlcpy(work->cpyatt,expasp(curecho,msg),MAXPATH);
                    work->state1=COPYATT;
                    if (!opn4cpy(work,filatt)) {
                         noatt(msg);
                         work->state1=WRITING;
                         *work->cpyatt='\0';
                    }
               }
               break;
          case COPYATT:
               rc=copychunk(work);
               if (rc > GMEAGAIN) {
                    work->state1=GOWRITE;
                    rc=GMEAGAIN;
               }
               else if (rc < GMEAGAIN) {
                    work->state1=GETOUT;
                    break;
               }
               return(rc);
          case GOWRITE:
               tmpdef=getdef(msg->forum);
               curecho=((adr_t *)tmpdef->echoes)[work->echonum];
               tmpflg=msg->flags;
          case WRITING:
               if (sndexp(curecho,msg,text,work->cpyatt) <= GMEAGAIN) {
                    invecho(curecho,getfnm(msg->forum));
                    unlink(work->cpyatt);
               }
               *work->cpyatt='\0';
               if (!(msg->flags&FILATT)) {
                    msg->flags=tmpflg;
               }
          case GETOUT:
               if (++work->echonum < tmpdef->necho) {
                    work->state1=NXTECHO;
                    rc=GMEAGAIN;
               }
               else {
                    rc=GMEOK;
                    work->state1=START;
               }
               return(rc);
          default:
               catastro("GME level 1 state corrupted in gme1echo(), state=%d",
                        work->state1);
          }
     }
}

void
invecho(                           /* audit invalid echo address           */
char *addr,                        /*   echo address                       */
char *fnam)                        /*   forum name                         */
{
     sprintf((char *)tmpbuf,"Forum: %s, Addr: %s",fnam,addr);
     ((char *)tmpbuf)[AUDSIZ-67+1]='\0'; /* 67 from shocst() */
     shocst("INVALID ECHO ADDRESS",(char *)tmpbuf);
}

int                                /*   returns VAL code                   */
wrtany(void)                       /* can current user E-mail anyone       */
{                                  /*   (other than Sysop)                 */
     if (haskey(emlkey)) {
          if (tstcrd(emschg)) {
               return(VALYES);
          }
          else {
               return(VALCRD);
          }
     }
     else {
          return(VALACC);
     }
}

int                                /*   returns standard access level code */
foracc(                            /* get current user's forum access level*/
unsigned fid)                      /*   given forum ID                     */
{
     return(qforac(uqsptr(usrnum),fid));
}

int                                /*   returns standard access level code */
gforac(                            /* get a user's forum access level      */
char *uid,                         /*   given any User-ID                  */
unsigned fid)                      /*   and forum ID                       */
{
     struct qscfg *qsc;

     qsc=othqsp(uid);
     if (qsc == NULL) {
          return(NOAXES);
     }
     return(qforac(qsc,fid));
}

int                                /*   returns standard access level code */
qforac(                            /* get a user's forum access level      */
struct qscfg *qsc,                 /*   given quickscan                    */
unsigned fid)                      /*   and forum ID                       */
{
     int i,acc;
     BOOL priv;
     struct fordef *tmpdef;

     ASSERT(qsc != NULL);
     ASSERT(*qsc->userid != '\0');
     ASSERT(fid != EMLID && fidxst(fid));
     if ((tmpdef=getdef(fid)) == NULL) {
          return(NOAXES);
     }
     if (uhskey(qsc->userid,forsys)) {
          return(SYAXES);
     }
     if (*tmpdef->forlok == '\0') {
          priv=uhskey(qsc->userid,forprv);
     }
     else {
          priv=uhskey(qsc->userid,tmpdef->forlok);
     }
     if (sameas(qsc->userid,tmpdef->forop)) {
          acc=OPAXES;
     }
     else {
          if ((i=qsidx(qsc,fid)) != NOIDX) {
               acc=acclvl(qsc->accmsg+qsc->nforums*sizeof(struct fmidky),i);
               ASSERT(acc == NOTSET || acc <= COAXES);
          }
          if (i == NOIDX || acc == NOTSET) {
               acc=priv ? tmpdef->dfprv : tmpdef->dfnpv;
          }
     }
     if (!priv && acc > tmpdef->mxnpv) {
          acc=tmpdef->mxnpv;
     }
     if (fid == dftfor && acc == NOAXES) {
          acc=RDAXES;
     }
     return(acc);
}

BOOL
valdest(                           /* is this a valid to address?          */
char *to,                          /*   to address                         */
unsigned dest)                     /*   destination (forum ID or E-mail)   */
{
     ASSERT(to != NULL);
     ASSERT(strlen(to) < MAXADR);
     #ifdef DEBUG
          if (dest != EMLID) {
               ASSERT(fidxst(dest));
          }
     #endif
     to=skpwht(to);
     if (dest == EMLID) {
          return(adrxst(to));
     }
     else {
          return(TRUE);
     }
}

BOOL                               /*   returns TRUE if a valid address    */
massage(                           /* convert address to final format      */
char *from,                        /*   User-ID of sender                  */
char *to,                          /*   to address                         */
unsigned dest)                     /*   destination (forum ID or E-mail)   */
{
     char *tmp;

     ASSERT(from != NULL);
     ASSERT(uidxst(from));
     ASSERT(to != NULL);
     ASSERT(strlen(to) < MAXADR);
     #ifdef DEBUG
          if (dest != EMLID) {
               ASSERT(fidxst(dest));
          }
     #endif
     if ((tmp=skpwht(to)) != to) {
          movmem(tmp,to,strlen(tmp)+1);
     }
     unpad(to);
     if (dest == EMLID) {
          return(fixadr(from,to));
     }
     else {
          if (*to == '\0') {
               strcpy(to,ALLINF);
               return(TRUE);
          }
          if (sameas(to,ALLINF)) {
               return(TRUE);
          }
          if (uidxst(to)) {
               stlcpy(to,accbb->key,UIDSIZ);
               return(TRUE);
          }
          if (getdef(dest)->necho != 0) {
               return(TRUE);
          }
          return(TRUE);
     }
}

BOOL
adrxst(                            /* does this address exist              */
char *adr)                         /*   address to check                   */
{
     if (isforum(adr) && fnmxst(adr+1)) {
          return(TRUE);
     }
     else if (isdlst(adr)) {
          return(dlstxst(adr));
     }
     else if (uidxst(adr)) {
          return(TRUE);
     }
     return(valexa(adr));
}

BOOL                               /*   returns TRUE if address exists     */
fixadr(                            /* fix up an address                    */
char *from,                        /*   User-ID of sender (NULL for any)   */
char *adr)                         /*   address to fix up                  */
{
     int i;

     ASSERT(adr != NULL);
     if (isforum(adr) && ((i=fnmidx(adr+1)) != NOIDX)) {
          stlcpy(adr+1,idxdef(i)->name,FORNSZ);
          return(TRUE);
     }
     else if (isdlst(adr)) {
          if (dlstxst(adr)) {
               strupr(adr);
               return(TRUE);
          }
          else {
               return(FALSE);
          }
     }
     else if (islocal(adr) && uidxst(adr)) {
          stlcpy(adr,accbb->key,UIDSIZ);
          return(TRUE);
     }
     else {
          return(masexa(from,adr));
     }
}

int                                /*   returns standard GME status codes  */
impmsg(                            /* import a message                     */
void *workb,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt)                      /*   path+file name of att (if any)     */
{
     int i,rc;
     char *cp;
     struct gmework *work=(struct gmework *)workb;

     while (TRUE) {
          switch (work->state3) {
          case START:
               if (msg->forum != EMLID && !fidxst(msg->forum)) {
                    clsgmerq(work);
                    return(GMEERR);
               }
               if (hdlimphook != NULL) {
                    if ((*hdlimphook)(msg,text,filatt)) {
                         clsgmerq(work);
                         return(GMEOK);
                    }
               }
               if (uidxst(msg->to)) {
                    stlcpy(msg->to,((struct usracc *)(accbb->data))->userid,
                           UIDSIZ);
               }
               else if (msg->forum == EMLID) {
                    clsgmerq(work);
                    return(GMENFND);
               }
               if (gidxst(msg->forum,&msg->gmid)) {
                    clsgmerq(work);
                    return(GMEDUP);
               }
               msg->msgid=newmid();
               msg->nrpl=0;
               if (msg->crdate == 0U && msg->crtime == 0U) {
                    msg->crdate=today();
                    msg->crtime=now();
               }
               msg->flags&=NONSYSF;
               work->state3=GOWRITE;
               if (msg->gmid.sysid == 0L || msg->gmid.msgid == 0L) {
                    setgid(msg);
                    setmem(&msg->rplto,sizeof(struct globid),0);
               }
               else if (msg->rplto.sysid != 0L && msg->rplto.msgid != 0L
                     && msg->forum != EMLID) {
                    inormrd(work,"",msg->forum,0);
                    if (gme1rdg(work,&msg->rplto,utlmsg,utltxt) == GMEOK) {
                         msg->thrid=utlmsg->thrid;
                         addhist(msg->history,spr(RPLTO,l2as(utlmsg->msgid)));
                    }
               }
          case GOWRITE:
               chkrqs(work,msg);
               if ((work->flags&FWDMSG) && msg->forum == EMLID
                && isexpa(msg->to)) {
                    i=expidx(msg->from);
                    if (i != NOIDX) {
                         cp=&msg->from[strlen(exphlr[i]->prefix)+1];
                         movmem(cp,msg->from,strlen(cp)+1);
                    }
               }
               work->flags|=NOECHO;
               work->state3=WRITING;
               if (msg->flags&FILATT) {
                    if (*msg->attname == '\0') {
                         stlcpy(msg->attname,attnam(msg->msgid),FLNSIZ);
                    }
                    if (msg->forum == EMLID && isexpa(msg->to)) {
                         stlcpy(work->cpyatt,expasp(msg->to,msg),MAXPATH);
                         if (msg->flags&FILIND) {
                              work->state3=STRTCPY;
                         }
                         else if (sameas(normspec((char *)tmpbuf,filatt),
                                         normspec((char *)tmpbuf+MAXPATH,
                                                  work->cpyatt))) {
                              stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                         }
                         else {
                              unlink(work->cpyatt);
                              if (rename(filatt,work->cpyatt) == 0) {
                                   stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                              }
                              else {
                                   work->state3=STRTCPY;
                              }
                         }
                    }
                    else {
                         stlcpy(work->cpyatt,ulname(msg),MAXPATH);
                         if (msg->flags&FILIND) {
                              stlcpy(work->auxatt,filatt,MAXPATH);
                         }
                         else {
                              unlink(work->cpyatt);
                              if (rename(filatt,work->cpyatt) == 0) {
                                   stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                              }
                              else {
                                   work->state3=STRTCPY;
                              }
                         }
                    }
               }
               break;
          case STRTCPY:
               work->state3=COPYATT;
               if (!opn4cpy(work,filatt)) {
                    clsgmerq(work);
                    return(GMENOAT);
               }
          case COPYATT:
               rc=copychunk(work);
               if (rc > GMEAGAIN) {
                    work->state3=WRITING;
                    if (!(msg->flags&FILIND)) {
                         unlink(filatt);
                    }
                    stlcpy(work->auxatt,work->cpyatt,MAXPATH);
                    rc=GMEAGAIN;
               }
               else if (rc < GMEAGAIN) {
                    clsgmerq(work);
               }
               return(rc);
          case WRITING:
               rc=gme2wnm(work,msg,text,work->auxatt);
               if (rc != GMEAGAIN) {
                    if (rc > GMEAGAIN) {
                         if (work->rdfpos != 0L
                          && grabmsg(work,utlmsg,utltxt)) {
                              ++utlmsg->nrpl;
                              updmsg(work,utlmsg,utltxt);
                         }
                         hdlntfy(IMPRTNOT,work,msg);
                         if (work->flags&FWDMSG) {
                              rstafwd(work,msg);
                              rc=GMEAFWD;
                         }
                    }
                    clsgmerq(work);
               }
               return(rc);
          default:
               catastro("GME level 3 state corrupted in impmsg(), state=%d",
                        work->state3);
          }
     }
}

void
register_exp(                      /* register an exporter                 */
struct exporter *exp)              /*   pointer to exporter control block  */
{
     int i,cmp;

     if (!valpfx(exp->prefix)) {
          catastro("Invalid exporter prefix: \"%s\"",exp->prefix);
     }
     for (i=0 ; i < nexp ; ++i) {
          cmp=stricmp(exphlr[i]->prefix,exp->prefix);
          if (cmp == 0) {
               catastro("Conflicting exporter prefixes: \"%s\"",exp->prefix);
          }
          else if (cmp > 0) {
               break;
          }
     }
     alcpar((void **)&exphlr,nexp,SMLBLK);
     movmem(&exphlr[i],&exphlr[i+1],sizeof(struct exporter *)*(nexp-i));
     exphlr[i]=exp;
     ++nexp;
}

BOOL
valpfx(                            /* is this a valid exporter prefix?     */
char *prefix)                      /*   prefix to check                    */
{
     return(isalnum(prefix[0]) && isalnum(prefix[1])
         && (prefix[2] == '\0' || (isalnum(prefix[2]) && prefix[3] == '\0')));
}

BOOL
expavl(void)                       /* are any exporters available?         */
{
     int i;

     for (i=0 ; i < nexp ; ++i) {
          if (haskey(exphlr[i]->wrtkey)) {
               return(TRUE);
          }
     }
     return(FALSE);
}

BOOL
valexa(                            /* is this a valid E-mail export addr?  */
char *to)                          /*   address to check                   */
{
     int i;

     ASSERT(to != NULL);
     ASSERT(strlen(to) < MAXADR);
     if (nexp == 0) {
          return(FALSE);
     }
     if (isexpa(to)) {
          i=expidx(to);
          if (i != NOIDX) {
               return((*exphlr[i]->valadr)(
                         skpwht(to+strlen(exphlr[i]->prefix)+1)));
          }
     }
     return(FALSE);
}

BOOL                               /*   returns TRUE if a valid address    */
masexa(                            /* convert export address to proper form*/
char *from,                        /*   User-ID of sender (NULL for any)   */
char *to)                          /*   address to check                   */
{
     int i,numyes;
     unsigned len;
     struct exporter *tmpexp,*lastexp;

     ASSERT(to != NULL);
     ASSERT(strlen(to) < MAXADR);
     if (nexp == 0) {
          return(FALSE);
     }
     if (isexpa(to)) {
          i=expidx(to);
          if (i != NOIDX) {
               return((from == NULL ? TRUE : uhskey(from,exphlr[i]->wrtkey))
                   && (*exphlr[i]->valadr)(
                         skpwht(to+strlen(exphlr[i]->prefix)+1)));
          }
          if (strxck) {
               return(FALSE);
          }
     }
     for (i=0,numyes=0 ; i < nexp ; ++i) {
          tmpexp=exphlr[i];
          if ((from == NULL || uhskey(from,tmpexp->wrtkey))
           && (*tmpexp->valadr)(to)) {
               ++numyes;
               lastexp=tmpexp;
          }
     }
     if (numyes == 1) {
          i=strlen(lastexp->prefix);
          len=strlen(to)+1;
          if (len > MAXADR-i-1) {
               len=MAXADR-i-1;
               to[len-1]='\0';
          }
          movmem(to,to+i+1,len);
          strcpy(to,lastexp->prefix);
          to[i]=':';
          return(TRUE);
     }
     return(FALSE);
}

int
numexp(void)                       /* get number of exporters on system    */
{
     return(nexp);
}

int                                /*   returns standard GME status codes  */
sndexp(                            /* send a message an exporter           */
char *to,                          /*   address to send message to         */
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt)                      /*   path+file name of att (if any)     */
{
     int i;

     if (to == NULL || *to == '\0') {
          to=msg->to;
     }
     i=expidx(to);
     if (i == NOIDX) {
          return(GMEERR);
     }
     return((*exphlr[i]->sndmsg)(&to[strlen(exphlr[i]->prefix)+1],msg,text,
                                 filatt));
}

int                                /*   returns NOIDX if not found         */
expidx(                            /* index of exporter in handler array   */
char *to)                          /*   address containing prefix          */
{
     int i;

     ASSERT(to != NULL);
     for (i=0 ; i < nexp ; ++i) {
          if (thisexp(exphlr[i],to)) {
               return(i);
          }
     }
     return(NOIDX);
}

BOOL
thisexp(                           /* does address refer to this exporter? */
struct exporter *exp,              /*   pointer to exporter control block  */
char *to)                          /*   address to check                   */
{
     return(to[strlen(exp->prefix)] == ':' && sameto(exp->prefix,to));
}

char *
expasp(                            /* get exporter attachment file spec    */
char *to,                          /*   address message is being sent to   */
struct message *msg)               /*   given message header structure     */
{
     int i;

     if (to == NULL || *to == '\0') {
          to=msg->to;
     }
     ASSERT(expidx(to) != NOIDX);
     i=expidx(to);
     if (exphlr[i]->flags&EXPATT) {
          return((*exphlr[i]->attspc)(to,msg));
     }
     return("");
}

struct expinfo *                   /*   returns pointer to static buffer   */
expinf(                            /* get info on an exporter              */
int idx)                           /*   given exporter index               */
{
     static struct expinfo expinfo;

     ASSERT(idx >= 0 && idx < nexp);
     return(exp2inf(exphlr[idx],&expinfo));
}

char *                             /*   ptr to temp area (may be msgbuf)   */
exphlp(                            /* get help message for an exporter     */
int idx)                           /*   given exporter index               */
{
     ASSERT(idx >= 0 && idx < nexp);
     return((*exphlr[idx]->helpmsg)());
}

struct expinfo *                   /*   returns pointer to destination     */
exp2inf(                           /* copy exporter struct to expinfo      */
struct exporter *exp,              /*   exporter structure                 */
struct expinfo *info)              /*   expinfo structure                  */
{
     ASSERT(exp != NULL);
     ASSERT(info != NULL);
     stlcpy(info->prefix,exp->prefix,PFXSIZ);
     stlcpy(info->name,exp->name,EXPNSZ);
     stlcpy(info->desc,exp->desc,EXPDSZ);
     stlcpy(info->exmp,exp->exmp,MAXADR);
     stlcpy(info->wrtkey,exp->wrtkey,KEYSIZ);
     info->wrtchg=exp->wrtchg;
     stlcpy(info->attkey,exp->attkey,KEYSIZ);
     info->attchg=exp->attchg;
     info->apkchg=exp->apkchg;
     stlcpy(info->rrrkey,exp->rrrkey,KEYSIZ);
     info->rrrchg=exp->rrrchg;
     stlcpy(info->prikey,exp->prikey,KEYSIZ);
     info->prichg=exp->prichg;
     info->flags=exp->flags;
     return(info);
}

