/***************************************************************************
 *                                                                         *
 *   GCSGAGT.C                                                             *
 *                                                                         *
 *   Copyright (c) 1994-1995 Galacticomm, Inc.        All rights reserved. *
 *                                                                         *
 *   This file contains all routines used to create and maintain           *
 *   information on generic agents, and to permit generic agents to read   *
 *   and write to the generic dynapak databas.                             *
 *                                                                         *
 *                                                  - C. Robert  6/21/94   *
 *                                                  - Bill Hyatt           *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "gcspsrv.h"
#include "majorbbs.h"
#include "gcsasys.h"
#include "bbserver.h"

#define   FILREV    "$Revision:   1.0.1.0.1.0  $"

#define   MAXGAS    500            /* maximum number of generic agents     */
#define   APPLIM    2147483647L    /* maximum number of bytes, each agent  */
#define   TOTLIM    2147483647L    /* maximum number of bytes, all agents  */
#define   GABLKS    20             /* generic agent alcrsz() block size    */
#define   GAGTDIR   "GCSGAGT\\"    /* path for generic agent files         */
#define   MAXGDR    (MAXPATH-FLNSIZ-1-AIDSIZ-1-1)
                                   /* maximum size of generic dpk file dir */

STATIC void garead(int direction,struct saunam *dpknam);
STATIC void gawrite(struct saunam *dpknam,unsigned length,void *value);
STATIC void gaxdone(void);
STATIC void gaabort(void);
STATIC BOOL fndgagt(char *appid);
STATIC void clsgenagt(void);

struct agent genagt={              /* agent information structure          */
     "",                           /*   appid                              */
     garead,                       /*   read-dynapak function pointer      */
     gawrite,                      /*   write-dynapak function pointer     */
     gaxdone,                      /*   file xfer-done function pointer    */
     gaabort                       /*   abort-request function pointer     */
};

char *gagtkey;                     /* key required to use generic agent    */

unsigned long tspace=0L;           /* total disk space being taken up      */

int ngagts=0,                      /* total number of generic agents       */
    ngalcd=0;                      /* total generic agents allocated for   */

struct gainfo {                    /* generic agent information structure  */
     char appid[AIDSIZ];           /*   appid                              */
     unsigned long space;          /*   disk space being taken up          */
} *genagts,                        /* in-memory list of generic agents     */
  *gagtptr;                        /* current generic agent pointer        */

struct gapreq {                    /* per-request memory for generic agent */
     unsigned long size;           /*   size of current write request      */
     char fspec[MAXPATH];          /*   filespec associated with request   */
     unsigned time;                /*   time stamp on filespec             */
     unsigned date;                /*   date stamp on filespec             */
     struct saunam dpknam;         /*   dynapak name                       */
};

#define garptr ((struct gapreq *)mrqptr)

void
inigenagt(void)                    /* initialize generic agent support     */
{
     struct saunam totsau;
     char crenam[MAXGDR];

     setmbk(gcsmb);
     gagtkey=stgopt(GAGTKEY);
     rstmbk();
     cnvd2s("s:spcgdpk",&totsau);
     readgdp(0,&totsau,sizeof(unsigned long),&tspace);
     stlcpy(crenam,GAGTDIR,min(strlen(GAGTDIR),MAXGDR));
     mkdir(crenam);
     dclmrq(sizeof(struct gainfo));
     hook_shutdown(clsgenagt);
}

STATIC void
garead(                            /* generic agent: field read-request    */
int direction,
struct saunam *dpknam)
{
     if (stdchk(gagtkey)) {
          r2rgdp(direction,dpknam);
          return;
     }
     rejectreq();
}

STATIC void
gawrite(                           /* generic agent: field write-request   */
struct saunam *dpknam,
unsigned length,
void *value)
{
     unsigned long oldlen;
     static struct fndblk fb;

     fndgagt(dpknam->appid);
     ASSERT(gagtptr != NULL);
     if (stdchk(gagtkey)) {
          movmem(dpknam,&garptr->dpknam,sizeof(struct saunam));
          oldlen=readgdp(0,dpknam,0,NULL);
          if ((dpknam->flags&FLGFIL) && fnd1st(&fb,GDPBTR->value,0)) {
               oldlen+=fb.size;
          }
          if ((dpknam->flags&FLGFIL) && length != 0) {
               if (tspace+FINFPTR->size+length <= TOTLIM+oldlen
                   && gagtptr->space+FINFPTR->size+length <= APPLIM+oldlen) {
                    unlink(GDPBTR->value);
                    stzcpy(garptr->fspec,
                           spr("%s%s\\%s",GAGTDIR,dpknam->appid,FINFPTR->name),
                           MAXPATH);
                    writegdp(dpknam,STGLEN,garptr->fspec);
                    ok2write(garptr->fspec);
                    garptr->time=FINFPTR->time;
                    garptr->date=FINFPTR->date;
                    garptr->size=strlen(garptr->fspec)+FINFPTR->size;
                    tspace-=min(oldlen,tspace);
                    tspace+=garptr->size;
                    gagtptr->space-=min(oldlen,gagtptr->space);
                    gagtptr->space+=garptr->size;
                    return;
               }
          }
          else if (tspace+length <= TOTLIM+oldlen
                   && gagtptr->space+length <= APPLIM+oldlen) {
               if (dpknam->flags&FLGFIL) {   /* deleting file dynapak */
                    unlink(GDPBTR->value);
               }
               writegdp(dpknam,length,value);
               rsp2write(TRUE,0,NULL);
               tspace-=min(oldlen,tspace);
               tspace+=length;
               gagtptr->space-=min(oldlen,gagtptr->space);
               gagtptr->space+=length;
               return;
          }
     }
     rejectreq();
}

STATIC void
gaxdone(void)                      /* generic agent: handle end of transfer*/
{
     if (iswrite()) {
          setdtd(garptr->fspec,garptr->time,garptr->date);
          rsp2write(TRUE,0,NULL);
     }
}

STATIC void
gaabort(void)                      /* generic agent: abort read/write req  */
{
     if (iswrite()) {
          unlink(garptr->fspec);
          writegdp(&garptr->dpknam,0,NULL);
          tspace-=min(garptr->size,tspace);
          gagtptr->space-=min(garptr->size,gagtptr->space);
     }
}

BOOL
newgenagt(                         /* add a new generic agent              */
char *appid)                       /*   appid to add generic agent for     */
{
     struct saunam appsau;
     unsigned long curspc=0L;

     if (!haskey(gagtkey) || ngagts >= MAXGAS) {
          return(FALSE);
     }
     if (fndgagt(appid)) {
          return(TRUE);
     }
     mkdir(spr("%s%s",GAGTDIR,appid));
     stzcpy(genagt.appid,appid,AIDSIZ);
     register_agent(&genagt);
     if (ngalcd <= ngagts) {
          if (ngalcd == 0) {
               genagts=(struct gainfo *)alcmem(sizeof(struct gainfo)*GABLKS);
          }
          else {
               genagts=(struct gainfo *)alcrsz(genagts,
                                        sizeof(struct gainfo)*ngalcd,
                                        sizeof(struct gainfo)*(ngalcd+GABLKS));
          }
          ngalcd+=GABLKS;
     }
     stzcpy(genagts[ngagts].appid,appid,AIDSIZ);
     cnvd2s(spr("s:spcgdpk %s",appid),&appsau);
     readgdp(0,&appsau,sizeof(unsigned long),&curspc);
     genagts[ngagts].space=curspc;
     ngagts++;
     return(TRUE);
}

STATIC BOOL
fndgagt(                           /* find a generic agent in table        */
char *appid)                       /*   appid of agent to find             */
{
     int i;

     for (i=0 ; i < ngagts ; i++) {
          if (sameas(appid,genagts[i].appid)) {
              gagtptr=&genagts[i];
              return(TRUE);
          }
     }
     gagtptr=NULL;
     return(FALSE);
}

STATIC void
clsgenagt(void)                    /* close down generic agent support     */
{
     int i;
     struct saunam totsau;

     for (i=0 ; i < ngagts ; i++) {
          cnvd2s(spr("s:spcgdpk %s",genagts[i].appid),&totsau);
          writegdp(&totsau,sizeof(unsigned long),&genagts[i].space);
     }
     cnvd2s("s:spcgdpk",&totsau);
     writegdp(&totsau,sizeof(unsigned long),&tspace);
}

