/***************************************************************************
 *                                                                         *
 *   GALFILH.H                                                             *
 *                                                                         *
 *   Copyright (c) 1993-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   File Libraries - Header for interface into the File Libraries         *
 *                                                                         *
 *                                                 - D. Pitchford  9/28/93 *
 *                                                                         *
 ***************************************************************************/

#define FLNAMESZ    9              /* size of Library names                */
#define FLDESCSZ   41              /* size of Library descriptions         */
#define FLLDESCS   80              /* size of long Library descriptions    */
#define FLFILENM   13              /* size of filenames                    */
#define FLKEYSIZ   13              /* size of keywords                     */
#define FLKEYLST   79              /* size of keyword string               */
#define FLNMCATS   10              /* number of top-level libs joinable    */
#define PATHSIZE   50              /* size of directory path               */
#define FLFILREC  105              /* record size of struct flfile & data  */
#define FLKEYREC   35              /* record size of keyword data          */
#define DATESZ      8              /* size of date, "srt" format           */
#define DESCSIZ   902              /* size of long description of a file   */
#define NLISTER    17              /* number of files to list on screen    */
#define NDESCLN    15              /* number of description lines [fsd]    */
#define SDESCLN    50              /* size of desc line incl. nul term.    */
#define MAXKWDS   200              /* number of keywords per file          */
#define NUMSZ       8              /* size of char array for # of d/ls     */
#define NUMSZP      "%07ld"        /* number of downloads, sprintf template*/
#define NOTAPPED    "0000000"      /* "srt" format date of unapproved file */
#define FLOWSTS    10              /* number of btuchi() calls to stack up */
#define NLDLIN      5              /* number of lines in long description  */
#define ULDAYS      7              /* number of days to count new files    */
#define MISCSIZE   80              /* size of flmisc text variable         */
#define NVIEWS    100              /* number of custom view extensions     */
#define SIZKWBUF   60              /* size of buffer for keyword data      */
#define ALPHALC    50              /* incremental allocation for **alphlibs*/

struct fluser {                    /* structure for saved user data        */
     char lib[FLNAMESZ];           /* last Library a user was in           */
     char proto[3];                /* default download transfer protocol   */
     int askme;                    /* ask to logoff after default transfer */
     int mytyp;                    /* user preference: search parameters   */
     int mylib;                    /* user preference: current/all libs    */
     int cdayin;                   /* cofdat() date of last Library access */
     char newdate[DATESZ];         /* date user last did the L list option */
     char spare[22];               /* spare space                          */
};

struct flusave {                   /* structure for saving user data       */
     char userid[UIDSIZ];          /* User-Id of user data belongs to      */
     char modnam[MNMSIZ];          /* "File Library" module key            */
     struct fluser udata;          /* data to save on above user           */
};

struct fllib {                     /* structure for Library data           */
     char libname[FLNAMESZ];       /* Library name                         */
     long flags;                   /* various saved bit flags              */
     int day;                      /* day this Library was created         */
     int time;                     /* time of day this Library was created */
     char libdesc[FLDESCSZ];       /* Library short description            */
     int appwait;                  /* number of files awaiting approval    */
     char keyreq[KEYSIZ];          /* key to see files at all              */
     char libop[KEYSIZ];           /* key to be a Lib-Op (blank is OK)     */
     char autoap[KEYSIZ];          /* key to auto-approve uploaded files   */
     char dlkey[KEYSIZ];           /* key to download files                */
     char ulkey[KEYSIZ];           /* key to upload files                  */
     char overw[KEYSIZ];           /* key to overwrite files               */
     char cat[FLNMCATS][FLNAMESZ]; /* top-level Libraries a member of      */
     char path[PATHSIZE];          /* name of alternate path, if any       */
     long dlchge;                  /* per-file charge for downloads        */
     long kdlchge;                 /* per-K charge for downloads           */
     long numfiles;                /* number of files in Library           */
     long totfiles;                /* number of files in Library + joined  */
     int royal;                    /* royalty percentage                   */
     int libs;                     /* number of joined Libraries           */
     long maxfil;                  /* maximum number of files in Library   */
     long maxbyt;                  /* maximum number of bytes in Library   */
     long maxbup;                  /* maximum upload size to Library       */
     char primary[UIDSIZ];         /* user who is primary Lib-Op           */
     int newfiles[ULDAYS];         /* added files in last x days, [0]=today*/
     long totbytes;                /* total number of bytes in Library     */
     unsigned cluster;             /* cluster size of Library drive        */
};

                                   /* a Library's various saved bit flags  */
#define FLGCBD 0x00000001L         /* ...copy-before-download              */
#define FLGRDO 0x00000002L         /* ...read-only lib                     */
#define FLGAUL 0x00000004L         /* ...audit uploads                     */
#define FLGADL 0x00000008L         /* ...audit downloads                   */
#define FLGFDL 0x00000010L         /* ...free downloads                    */
#define FLGFUL 0x00000020L         /* ...free uploads                      */
#define FLGDOS 0x00000040L         /* ...DOS-ONLY Library                  */
#define FLGHID 0x00000080L         /* ...hidden, join-only Library         */
#define LIBCHN 0x00000100L         /* ...Library changed, update soon      */
#define LIBONG 0x00000200L         /* ...ongoing change, update whenever   */

struct libdisk {                   /* structure for saving Library data    */
     struct fllib lib;             /* structure to save                    */
     char spare[240];              /* spare space                          */
     char ldesc[NLDLIN][FLLDESCS]; /* long description                     */
};

struct flfile {                    /* structure for individual file data   */
     char libname[FLNAMESZ];       /* Library the file is in               */
     char filname[FLFILENM];       /* the file name of the file            */
     char udate[DATESZ];           /* approval date, in "srt" format       */
     char numdls[NUMSZ];           /* number of downloads, NUMSZP format   */
     char fdate[DATESZ];           /* file date, "srt" format              */
     long siz;                     /* file size                            */
     int tim;                      /* file time                            */
     char ulby[UIDSIZ];            /* uploaded by                          */
     int utime;                    /* time of day file was approved        */
     char spare[FLFILREC-84];      /* spare space                          */
     char desc[DESCSIZ];           /* variable-length description field    */
};

struct taglib {                    /* structure for file tagging           */
     int status;                   /* state of this tagged file, see below */
     int usrnum;                   /* usrnum of tagging user               */
     char libname[FLNAMESZ];       /* actual Library name of tagged file   */
     char filname[FLFILENM];       /* file name of tagged file             */
     char udate[DATESZ];           /* approval date of file, "srt" format  */
     char reflib[FLNAMESZ];        /* reference Library of tagged file     */
     char wldspc[FLFILENM];        /* tag specification for wildcard tags  */
     long tagtime;                 /* time(NULL) the file was tagged       */
     long size;                    /* size of tagged file                  */
     long copied;                  /* amount copied so far                 */
     int nwld;                     /* number of wildcard files tagged      */
};

                                   /* status values, struct taglib         */
#define TGEMPTY  0                 /* ...empty and ready for new tag       */
#define TGLOCAL  1                 /* ...ready for d/l direct from storage */
#define TGINWAIT 2                 /* ...waiting to be copied              */
#define TGCOPY   3                 /* ...being copied to temp directory    */
#define TGDLTMP  4                 /* ...ready for d/l from temp directory */
#define TGOTHER  5                 /* ...waiting for outside control       */
#define TGSERVER 6                 /* ...under outside control             */
/* a negative value of one of the above definitions indicates completion   */

struct modeview {                  /* structure for file viewing modes     */
     char ext[4];                  /* extension to store view mode for     */
     int mode;                     /* view mode to use                     */
     void (*rouptr)();             /* view routine, if needed              */
};

/* seven structures for composite keys within the union in struct fluson,  */
/* and their corresponding btrieve key numbers                             */

struct key0 {                      /* LIBNAME/UDATE/FILNAME composite key  */
     char libname[FLNAMESZ];
     char udate[DATESZ];
     char filname[FLFILENM];
};
#define COMPLUF  0                 /* btrieve key for above structure      */

struct key1 {                      /* LIBNAME/FILNAME composite key        */
     char libname[FLNAMESZ];
     char filname[FLFILENM];
};
#define COMPLF   1                 /* btrieve key for above structure      */

struct key2 {                      /* KEYWORD/FILNAME/LIBNAME composite key*/
     char keyword[FLKEYSIZ];
     char filname[FLFILENM];
     char libkey[FLNAMESZ];
     char origkey[FLKEYSIZ];       /* reference, not part of key           */
     char libname[FLNAMESZ];       /* reference, not part of key           */
};
#define COMPKFL  0                 /* btrieve key for above structure      */

struct key3 {                      /* UDATE/FILNAME composite key          */
     char udate[DATESZ];
     char filname[FLFILENM];
     char libkey[FLNAMESZ];
     char libname[FLNAMESZ];       /* reference, not part of key           */
};
#define COMPUF   2                 /* btrieve key for above structure      */

struct key4 {                      /* FILNAME/LIBNAME composite key        */
     char filname[FLFILENM];
     char libkey[FLNAMESZ];
     char libname[FLNAMESZ];       /* reference, not part of key           */
     char exactfn[FLFILENM];       /* reference, not part of key           */
};
#define COMPFL   3                 /* btrieve key for above structure      */
#define COMPFL_K 1                 /* btrieve key for above structure(kwd) */

struct key5 {                      /* NUMDLS/LIBNAME/FILNAME composite key */
     char numdls[NUMSZ];
     char libkey[FLNAMESZ];
     char filname[FLFILENM];
     char libname[FLNAMESZ];       /* reference, not part of key           */
};
#define COMPNLF  4                 /* btrieve key for above structure      */

struct key6 {                      /* reference for DOS-Only Libraries     */
     char filname[FLFILENM];
     int date[NLISTER];
     int time[NLISTER];
     long size[NLISTER];
};

struct key7 {                      /* structure for keyword insertion      */
     char keyword[FLKEYSIZ];
     char filname[FLFILENM];
     char libname[FLNAMESZ];
};

union srch {                       /* joined Library search key union      */
     struct key0 key0;             /* libname/udate/filname                */
     struct key1 key1;             /* libname/filname                      */
};

union combo {                      /* the file key union                   */
     struct key0 key0;             /* libname/udate/filname                */
     struct key1 key1;             /* libname/filname                      */
     struct key2 key2;             /* keyword/filname/libname              */             /* libname/udate/filname                */
     struct key3 key3;             /* udate/filname                        */
     struct key4 key4;             /* filname/libname                      */
     struct key5 key5;             /* numdls/libname/filname               */
     struct key6 key6;             /* DOS-Only reference                   */
};

struct zvdat {                     /* C/S compressed file viewing context  */
     int state;                    /*   state within, 0=not being used now */
     char libname[FLNAMESZ];       /*   Library name of file being viewed  */
     char filname[FLFILENM];       /*   file name of file being viewed     */
     long size;                    /*   size of file being viewed          */
     FILE *fp;                     /*   open file pointer of file viewed   */
     char filid;                   /*   type of compression used           */
     long pos;                     /*   current file position              */
};

struct fluson {                    /* "user online" structure              */
     void (*rouptr)();             /* miscellaneous function pointer       */
     int keymeth;                  /* key method used                      */
     int styp;                     /* search type selected                 */
     long flags;                   /* various online bit flags             */
     char miscfil[FLFILENM];       /* miscellaneous file name              */
     char misclib[FLNAMESZ];       /* miscellaneous Library name           */
     char keylist[FLKEYLST];       /* keyword list string                  */
     int tagcnt;                   /* temporary tag counter                */
     long pos;                     /* file position for unzipping files    */
     long filen;                   /* file length for unzipping files      */
     int savetags;                 /* number of tagspecs saved during d/l  */
     char tagk;                    /* display key                          */
     int cursor;                   /* online tagbar                        */
     int miscflag;                 /* miscellaneous index or flag          */
     int kcount;                   /* keyword count                        */
     int nlibaxs;                  /* number of libs user has access to    */
     int index;                    /* miscellaneous index integer          */
     int force;                    /* lib select mode: top-level lib only? */
     int retstt;                   /* return or flag substate              */
     int pflg;                     /* asking state, download selection     */
     int hold;                     /* tag while viewing                    */
     int crdrat;                   /* saved for free upload/download       */
     int nozap;                    /* saved for free upload/download       */
     struct fndblk fb;             /* for miscellaneous fnd1st(), etc. use */
     int autol;                    /* auto login or approve all in prog.   */
     int dodesc;                   /* descriptions during login, see below */
     int atend;                    /* listing scroll flags, see below      */
     char lrange[FLNAMESZ];        /* searching what lib range             */
     long tot;                     /* amt. of file copy done               */
     char srcpath[PATHSIZE];       /* miscellaneous file path number 1     */
     char destpath[PATHSIZE];      /* miscellaneous file path number 2     */
     FILE *fsrc;                   /* miscellaneous file pointer number 1  */
     FILE *fdst;                   /* miscellaneous file pointer number 2  */
     int state;                    /* state for unzipping files            */
     char fdate[DATESZ];           /* DOS file date (FSD use)              */
     char udate[DATESZ];           /* upload date (FSD use)                */
     long siz;                     /* file size (FSD use)                  */
     int ftim;                     /* file time (FSD use)                  */
     long numdls;                  /* file number of downloads (FSD use)   */
     char ulby[UIDSIZ];            /* file uploader (FSD use)              */
     int timeul;                   /* upload time (FSD use)                */
     int prop;                     /* propellor spinner state (/-\|)       */
     int wtnum;                    /* wildcard tagging: number of files    */
     long wtsiz;                   /* wildcard tagging: cumulative size    */
     char savprot[3];              /* protocol saved for concatenation     */
     char newdate[DATESZ];         /* date for L list option, newest files */
     int tdline[NLISTER];          /* line number and tag status (+/-)     */
     struct key0 tags[NLISTER];    /* displayed tagged files, libs, dates  */
     struct key1 key1;             /* miscellaneous key, mostly Lib-Op use */
     struct key2 kwdy;             /* miscellaneous keyword data file key  */
     union combo u;                /* composite key collection             */
     int movstt;                   /* stat of move or copy of files        */
     char cskwds[FLKEYLST];        /* keyword list for c/s searches        */
     struct zvdat cszview;         /* c/s view-zipfile memory              */
     long csidx;                   /* c/s search index, dos & keyword      */
};

                                   /* flags for struct fluson              */
#define OFTGMAN 0x00000001L        /* ...entered tag manager from filefind */
#define ABOUPRF 0x00000002L        /* ...neutralize user/system prefs CNC  */
#define RETUOPM 0x00000004L        /* ...return to operator menu from u/l  */
#define LISTALL 0x00000008L        /* ...listing all libs to offline list  */
#define DATESRC 0x00000010L        /* ...listing by user range of dates    */
#define COMFILE 0x00000020L        /* ...file is viewable inside (ascii)   */
#define LONGDSC 0x00000040L        /* ...display long Library description  */
#define DBLCLCK 0x00000080L        /* ...detect double-clicking of files   */
#define REVSRCH 0x00000100L        /* ...searching files in reverse order  */
#define USRANSI 0x00000200L        /* ...searching files in ansi mode      */
#define STOPLST 0x00000400L        /* ...stop listing files for a moment   */
#define TLSTDSP 0x00000800L        /* ...element has been displayed on list*/
#define FULLTAG 0x00001000L        /* ...prevent more interactive tagging  */
#define AXSUSER 0x00002000L        /* ...user has created u/l subdirectory */
#define XDLBEEP 0x00004000L        /* ...user warned about download access */
#define MOVFLAG 0x00008000L        /* ...copy (as opposed to move) flag    */
#define NXTEQUL 0x00010000L        /* ...get next value equal to key       */
#define REUPLOD 0x00020000L        /* ...user is re-uploading a file       */
#define UNOINJO 0x00040000L        /* ...user is busy, before searching    */
#define ENTRCNC 0x00080000L        /* ...user is using cnc facility ("&")  */
#define WLDRSLV 0x00100000L        /* ...resolving wildcard sysop operation*/
#define ISEDLIB 0x00200000L        /* ...user is editing a library now     */
#define APPTHEM 0x00400000L        /* ...approve files as they are added   */
#define DELTHEM 0x00800000L        /* ...delete files as they are unlogged */
#define OFFUPLD 0x01000000L        /* ...log off after upload to Library   */
#define INMVCPY 0x02000000L        /* ...sysop is in process of move/copy  */
#define CONTEXT 0x04000000L        /* ...a c/s context has been secured    */

                                   /* values for dodesc in struct fluson   */
#define ASKDESC -1                 /* ...ask whether to enter a file desc. */
#define NEVRASK  0                 /* ...just log in all the files         */
#define DOADESC  1                 /* ...do the next file description      */
#define NIXDESC  2                 /* ...don't do the next file description*/

                                   /* values for atend in struct fluson    */
#define LSTFILS  0                 /* ...scrolling in either direction ok  */
#define LSTBACK  1                 /* ...at end, no scrolling forward      */
#define LSTFORE  2                 /* ...at beginning, no scrolling back   */
#define LSTONLY  3                 /* ...may not scroll in either direction*/
#define LSTNONE  4                 /* ...no files found in search/list     */

                                   /* values for submit() and viewing files*/
#define NOTVIEW  0                 /* ...tag file for download             */
#define DOWNLOD  1                 /* ...download file now                 */
#define CMPVIEW  2                 /* ...view with "V" protocol            */
#define LSTVIEW  3                 /* ...view with "L" protocol            */
#define ANSVIEW  4                 /* ...view with "A" protocol            */
#define CSTVIEW  5                 /* ...custom view routine, flo->rouptr  */

struct srcs {                      /* information for ongoing searches     */
     int nlibs;                    /*   number of Libraries in keys, or 0  */
     int nloaded;                  /*   number of Libraries loaded so far  */
     union srch *tn;               /*   "to next" unions of keys           */
     union srch *tp;               /*   "to previous" unions of keys       */
     union srch *fn;               /*   "from next" unions of keys         */
     union srch *fp;               /*   "from previous" unions of keys     */
     char unions[1];               /*   var-length data for above unions   */
};

#define NUINRS 4                   /* # of union arrays in above data area */

extern
struct libcsfil {                  /* files being d/l'ed by c/s users      */
     char libname[FLNAMESZ];       /*   Library name of file               */
     char filname[FLFILENM];       /*   file name of file, * for all       */
     int status;                   /*   file copy status, see below        */
     long time;                    /*   time value for CD copying          */
     long charge;                  /*   credits user was charged for d/l   */
} *lcsu,*lcsarr,*viewarr;          /* pointer, and per-user arrays         */

#define FREADY 1                   /* lcsarr status, file ready to d/l     */
#define CDFILE 2                   /* lcsarr status, CD file waiting       */
#define CDCOPY 3                   /* lcsarr status, CD file copying       */
#define CDDONE 4                   /* lcsarr status, copied file ready     */
#define CDDLOD 5                   /* lcsarr status, d/l of copied file    */
#define EXTCDF 6                   /* lcsarr status, special file copy     */
#define EXTCDC 7                   /* lcsarr status, external control      */

/* External CD management programs can work with C/S users also, they need */
/* to watch lcsarr[] (using setlcsu()) for files showing up as EXTCDF.     */
/* Then they must set lcsu->status to EXTCDC until the file has been       */
/* retrieved.  Afterwards, set to CDDONE telling the system that the file  */
/* is in the proper copydir ready for d/l.                                 */

extern
struct fluser *flu,                /* current user pointed to (disk)       */
              *fluarr;             /* memory array                         */

extern
struct fluson *flo;                /* online user pointed to               */

extern
struct flusave flusmem;            /* memory for loading/saving fluser     */

extern
struct fllib *curlib,              /* current Library in use               */
             **alphlibs;           /* alphabetical pointers to Libraries   */
extern
struct libdisk *libupd,            /* memory for loading/saving Libraries  */
               *libedt;            /* memory for editing Libraries         */

extern
struct taglib *ftag;               /* current tagged file                  */

extern
struct modeview mvarr[NVIEWS];     /* custom viewing routines              */

extern
struct key0 countkey;              /* key for counting uploads in Libraries*/

extern
struct key7 *kwbuf;                /* buffer for keyword insertion         */

extern
int srcpool;                       /* handle to pool of search structs     */
extern
int *srcharr;                      /* array of search handles, one per user*/
extern
struct srcs *srcu;                 /* ptr to cur (srcoff()'d) search struct*/

extern
union srch srcactive;              /* active, found record for speed-search*/

extern
int curfusr;                       /* cur (fluoff()'d) file library user   */

extern
FILE *flmsg,                       /* pointer for .msg file                */
     *csrc,                        /* pointer for general copying of files */
     *cdst,                        /* pointer for general copying of files */
     *movs,                        /* pointer for sysop copying of files   */
     *movd;                        /* pointer for sysop copying of files   */

extern
BTVFILE *flldat,                   /* data file for Libraries              */
        *flfdat,                   /* data file for files                  */
        *flkdat;                   /* data file for keywords               */

extern
char *arrower,                     /* cursor key detection flag            */
     *tempdir,                     /* default user upload temp directory   */
     *nochgkey,                    /* key to never be charged to d/l       */
     *listkey,                     /* key to be able to d/l file lists     */
     *nonkwds,                     /* non-keywords                         */
     *flsysop,                     /* key required to be Library sysop     */
     *defplop,                     /* default primary Lib-Op               */
     *copydir,                     /* destination directory, copied files  */
     *defdesc,                     /* default description for a Library    */
     *deflname,                    /* name of default Library              */
     *descedit,                    /* memory for file descriptions         */
     *dargv[MAXKWDS],              /* points to defdesc, as margv to input */
     *defproto,                    /* default d/l protocol for all users   */
     flmisc[MISCSIZE],             /* array for misc. test variable        */
     movflib[FLNAMESZ],            /* array for moving files from Library  */
     movtlib[FLNAMESZ],            /* array for moving files to Library    */
     movfnam[FLFILENM],            /* array for moving files file name     */
     countlib[FLNAMESZ],           /* Library currently being counted      */
     tagtmpp[TSHLEN+1],            /* memory for temporary wild file path  */
     tagtmpf[FLFILENM];            /* memory for temporary wild file name  */

extern
void *flomem,                      /* memory for users online              */
     *libmem,                      /* memory for Libraries                 */
     *libmem2,                     /* more memory for adding Libraries     */
     *ftagmem;                     /* memory for tagged files              */

extern
int numlib,                        /* number of libs memory allocated for  */
    numladd,                       /* max. number of libs to possibly add  */
    movstt,                        /* state of file move                   */
    flstt,                         /* state for the File Libraries         */
    longsrch,                      /* require brute force searches         */
    vdd,                           /* half of the vda declaration          */
    freeuls,                       /* if true, never charge while uploading*/
    dargc,                         /* count of parsed words by darsdesc()  */
    notifsys,                      /* if true, notify sysops of unapp files*/
    notiflop,                      /* if true, notify libops of unapp files*/
    numoflib,                      /* actual number of Libraries           */
    comeff,                        /* estimated communications efficiency  */
    ncatlibs,                      /* actual number of top-level Libraries */
    auditall,                      /* if true, audit all file transfers    */
    unifile,                       /* if true, require unique file names   */
    pfnceil,                       /* profanity ceiling for File Libraries */
    chgabt,                        /* if true, charge for aborted downloads*/
    defallib,                      /* search all Libraries from d/l prompt */
    systags,                       /* number of ftagmem to allocate        */
    defstyp,                       /* default search/list mode             */
    defslib,                       /* default search/list range, one/all   */
    movflag,                       /* flag for move/copy files, to copy?   */
    stplist,                       /* strip ansi always in file listings   */
    countuls[ULDAYS],              /* counter of Library files added daily */
    clnlevel,                      /* level of cleanup to run              */
    kwaut,                         /* flag, keywords being written now     */
    maxjoin,                       /* # of joined libs max for fast search */
    srcindex,                      /* index for found record in speed-srch */
    fltagf;                        /* is current file tag a Library tag    */

extern
long byteroom,                     /* bytes free for uploading to a Library*/
     thresh;                       /* bytes assured free, copydir's drive  */

extern
struct reserve *librsv;            /* File Libraries reservations domain   */

extern
char *libedits,                    /* FSD utility strings                  */
     *filedits,
     *libeditf,
     *fileditf;

extern
BOOL newjoins;                     /* are there new libraries joined?      */

void init_galfiluz(void);          /* initialize unzip submodule           */
int openzip(void);                 /* open zip file (unzip submodule)      */
int dizread(char *b);              /* read description file (unzip submod) */

#define flf ((struct flfile *)(flfdat->data))          /* macro: cur file  */
#define spc (*((struct taglib **)(ftgptr->tagspc)))    /* macro: cur tag   */
#define kyd ((struct key2 *)(flkdat->data))            /* macro: cur kwd   */
#define totags (ftuptr->numftg+flo->tagcnt)            /* macro: # tagged  */
#define nextrec(rev,e,x,y,z)  (rev ? (e ? alebtv(x,y,z) : altbtv(x,y,z)) : \
                                     (e ? agebtv(x,y,z) : agtbtv(x,y,z)))
#define nextqrec(rev,x,y,z) (rev ? alebtv(x,y,z) : agebtv(x,y,z))
#define DESCSNON "<please type a description here>"
#define DESCLNON "<please type more descriptive text here>"
#define DESCFNON "<Enter description, including keywords>"
#define DESCFNO2 "<The first line acts as a short description>"

                                   /* utilties for interface to the FSD    */
#define FLDDATE  0
#define FLDTIME  1
#define FLDNAME  2
#define FLDDOSO  3
#define FLDDESC  4
#define FLDDESC0 5
#define FLDDESC1 6
#define FLDDESC2 7
#define FLDDESC3 8
#define FLDDESC4 9
#define FLDPATH 10
#define FLDHID  11
#define FLDCBD  12
#define FLDRDO  13
#define FLDAUL  14
#define FLDADL  15
#define FLDFUL  16
#define FLDFDL  17
#define FLDCDF  18
#define FLDCDK  19
#define FLDROY  20
#define FLDMFL  21
#define FLDMBT  22
#define FLDMUP  23
#define FLDVIS  24
#define FLDDLD  25
#define FLDULD  26
#define FLDOVW  27
#define FLDAPU  28
#define FLDLOP  29
#define FLDPLOP 30
#define FLDEXIT 31

#define FFDNAME  0
#define FFDLIB   1
#define FFDDATE  2
#define FFDTIME  3
#define FFDSIZE  4
#define FFDDL    5
#define FFDULD   6
#define FFDULT   7
#define FFDDLT   8
#define FFDCHG   9
#define FFDUSER  10
#define FFDTXT00 11
#define FFDTXT01 12
#define FFDTXT02 13
#define FFDTXT03 14
#define FFDTXT04 15
#define FFDTXT05 16
#define FFDTXT06 17
#define FFDTXT07 18
#define FFDTXT08 19
#define FFDTXT09 20
#define FFDTXT10 21
#define FFDTXT11 22
#define FFDTXT12 23
#define FFDTXT13 24
#define FFDTXT14 25
#define FFDEXIT  26

/* GALFIL.C 26/01/94 16.36.56 */
void EXPORT init__galfil(void);
void initlibrsv(void);
void iniopts(void);
int psislibop(int unum,char *lock);
char *cnclib(void);
int isflop(struct fllib *libptr);
int scanlib(int user,struct fllib *libptr);
int wldgetag(void);
int dlbgnwld(void);
int tshlist(int tshcod);
int tshlib(int tshcod);
long dnlprc(long siz,struct fllib *libptr);
void fluoff(int unum);
void srcoff(void);
void scanlibs(void);
struct fllib *libfind(char *libname);
struct fllib *liboff(int libnum);
struct fllib *setuaxs(void);
int makwdlst(char *stg,char *filname);
int submit(char *libname,char *filname,char *reflib,int view,int quiet);
int updusr(struct fluser *fluptr);
char *userdir(int which);
int valname(char *libname);
int fileditv(int fldno,char *answer);
int lsinp(void);
void deresume(void);
int lslon(void);
void genlon(void);
int srcincx(void);
int srcgood(void);
int srcnext(void);
union srch *nextsrc(int nxteq);
void resetkey(char *libname,char *filname);
void rset(void);
int dosinsrt(struct fllib *libptr,char *path,struct fndblk *f);
int insfile(struct fllib *libptr,char *path,struct fndblk *f,char *appdate
            ,char *u,char *desc);
int keywordy(void);
int libeditv(int fldno,char *answer);
int valpath(char *path);
int taglist(void);
int zapcrd(int yes,long siz,struct fllib *dlib);
struct fllib *keylib(char *libfound,char *libname,int *retval);
struct fllib *nxtlib(void);
void optiprf(void);
void bgnfiled(int display);
int uwaitcpy(int unum);
void notifu(void);
int ntagged(char *uid);
void checkoth(void);
void ulcount(void);
void inicount(char *libname);
int addkwnow(void);
void addkw(char *keyword,char *filname,char *libname);
void keywdaut(int taskid);
int delkw(char *keyword,char *filname,char *libname);
void copyaut(int taskid);
void doalr(void);
void dsearch(int which,int x);
void fileditd(int save);
void fileditp(int msgno,int amode,int display);
void lsclean(void);
void lsdel(char *uid);
void lsend(void);
void purgecpy(int rmvdirs);
void lshang(void);
void genhup(void);
void cfilmova(void);
void movecyc(void);
BOOL cycdelib(int *stt,char *libname,char *filname);
void cdellib(void);
void crencyc(void);
int dupefile(void);
void autogone(void);
void cautolog(void);
void cunapp(void);
void capp(void);
void cbigcpy(void);
void csearch(void);
void cfildel(void);
void cflist(void);
void entrdesc(void);
void ccopying(void);
void cdizzy(void);
void cliblst(void);
void ckeyword(void);
void cwldsrch(void);
void cwldsys(void);
void cresolve(void);
void clstcyc(void);
void lssta(void);
void flagit(int fldspec,long flag);
char *dprfm(int msgno);
void srcdrec(int redisplay);
void unprop(void);
void srcinit(int mode,char *lib);
char *wldstuff(char *stg);
void srcpaus(int rebuild);
void srcukey(void);
void gosearch(void);
void libeditd(int save);
BOOL savelib(struct libdisk *sav);
void libeditp(int msgno,int amode);
void libkick(void);
void prfopt(int optno,int tot,int ctr);
void prfups(void);
void mainmenu(void);
void opmenu(void);
void promptin(void);
void retmenu(int opermenu);
void buildview(int item);
void retoin(void);
void retoinx(void);
void retoinl(void);
void rstcrd(void);
void setbusy(void);
void statstrt(void);
int getaufil(int wipe,int unapp);
int candlnow(char *libname,char *filname);
int chjoined(struct fllib *libptr,char *check);
int chjoin(struct fllib *libptr,struct fllib *newlib,int unjoin);
void listjoin(void);
int profane(char *stg);
int wldmatch(char *wild,char *sfnm);
int compwild(char *wildfile,char *filename);
int space(void);
void dncfin(int endok,long bytxfer,struct fllib *libptr);
int weirddir(char *dirpath);
int isansiu(void);
void touch(char *src,char *dest);
void untagall(char *libname,char *filname);
int exfile(struct fllib *libptr,struct key0 *key);
void cleanit(int total);
char *manytims(long howmany);
struct taglib *tagoff(int index);
char *isedtlib(void);
void countupl(void);
void chuldate(struct fllib *libptr,char *date,int add);
int dlfrom(char *libname);
int dlfroml(struct fllib *libptr);
void dlcant(void);
void setmisc(char *stg);
int viewmode(char *ext);
int register_modeview(char *ext,int mode,void (*rouptr)());
void cycinp(void);
int totnlibs(char *libname,int index);
int initsrc(int retstt);
int ccycidx(void);
void newpage(void);
/* GALFILUT.C 26/01/94 15.21.00 */
char *checkdir(char *path);
char *fixpath(char *path);
char *compkey(char *libname,char *filname);
char *rcompkey(char *libname,char *filname);
char *cutpunc(char *stg);
char *dat2srt(char *dt);
long dnlchg(long siz,char *libname);
char *dnlmin(long siz);
char *fzer(long num);
char *protocol(void);
char *srt2dat(char *dt);
char *tvcomeff(void);
char *tvctim(void);
char *tvdesc(void);
char *tvdesc0(void);
char *tvdesc1(void);
char *tvdesc2(void);
char *tvdesc3(void);
char *tvdesc4(void);
char *tvdnlmin(void);
char *tvfapp(void);
char *tvfdate(void);
char *tvfdates(void);
char *tvfname(void);
char *tvflib(void);
char *tvfnum(void);
char *tvfsize(void);
char *filsize(long size,long kval);
char *tvfsizek(void);
char *tvftimes(void);
char *tvfulby(void);
char *tvinit(void);
char *tvmisc(void);
char *tvname(void);
char *tvtagk(void);
char *tagk(void);
char *tvtags(void);
char *tvtshmsg(void);
char *tvudate(void);
char *tvbytu(void);
char *tvbytt(void);
char *tvbyto(void);
char *tvfilt(void);
int alrtag(char *libname,char *filname);
int amrlib(char *grp,char *fil);
int countc(char *stg,char chr);
int deparse(char *p);
int dotags(int quiet);
void setfull(int isfull);
int findbest(int stt);
int visilib(struct fllib *libptr);
char *visxlib(struct fllib *libptr,char *libmatch);
int keyfig(void);
int keyin(char *key);
int keysin(int start);
int kwdout(void);
int nlibtagd(void);
int okfname(char *filename);
int readline(FILE *ptr);
int srch1(void);
int srch2(void);
int strsrep(char *stg,char *from,char *to);
int ulfileq(int flag);
long dnlsec(long siz);
long dnlsecl(long siz,struct fllib *libptr);
struct fllib *nexthigh(char *oldlib);
void bubkwds(void);
void sortlibs(void);
void darsdesc(int limit,char chr);
char *lrange(char *libname);
void dispfhdr(int resetcur);
void dlcharge(long charge,struct fllib *l);
void dnlcount(char *libname,char *filname,long ct);
void dofiler(char *desc);
void gather(void);
void loadlibs(void);
void mopitup(void);
void moploop(void);
int notify(int logon);
void readin(int lines,FILE *fptr,char *stg);
void regtvars(void);
void removetg(int n);
void strcrep(char *stg,char from,char to);
void unbreak(void);
void iflstyp(char c);
void iflslib(char c);
void iaskword(char *stg);
void iaskname(char *stg);
int ifdesced(char *stg);
void iprefers(char c);
void imanmnu(char c);
void ibigcopy(char *stg);
void iwarnmrk(char *stg);
void idelfil(char *stg);
int isellib(char *stg);
int othrsin(char *libname);
int idellibn(char *stg);
int itagman(char *stg);
int ientdl(char *stg);
int fspex(char *stg,char *lib,int sub);
int ioverw(char *stg);
int ientul(char *stg);
int iulmod(char *stg);
int ucanmod(void);
void exitview(void);
void dcurs(int und);
int curspos(int set);
void clstags(void);
int ientret(char *stg);
int iviewasc(char chr);
void ifilistx(char *stg);
int ifilist(char *stg);
void itranspr(char chr);
void irename(char *stg);
void ichain(char chr);
void ijoin(char *stg);
void iflblist(char chr);
int inpfunc(void);
int editgo(char *filen);
int writable(struct fllib *libptr);
int lsmenu(void);
int fupfil(int code);
int parsrch(char *stg);
void retoin2(void);
void dnlstart(int logoff);
void rebuild(int cls);
void prtbuild(int start,int run);
void iappmenu(char chr);
void iunapp(char chr);
void idelmenu(char chr);
void imovmenu(char chr);
void imovpath(char *stg);
void ienuadnm(char *stg);
void idoso(char chr);
void iclibnam(char *stg);
int oprmenu(void);
char *inmvcpy(void);
void loadldsc(struct libdisk *libdptr);
void bgnlibed(void);
void cdsptags(void);
void wipetag(void);
int libchg(void);
void spinner(void);
void locsysfl(char *filname);
void notidl(void);
int notapped(char *udate);
long libroom(struct fllib *libptr);
char *libpath(struct fllib *libptr);
int haslibkey(struct fllib *libptr,char *keyname);
int usrupd(struct fllib *libptr,char *filname);
void chkjoin(void);
/* GALFILCS.C 13/09/94 10.00.00 */
void init_cslib(void);
int vewctn(void);
int csfbest(int mode,long time);
void csclean(int unum);
void sendres(char *restg);
void sendjoin(void);
void setlcsu(int unum);
