/***************************************************************************
 *                                                                         *
 *   GALFILCS.C                                                            *
 *                                                                         *
 *   Copyright (c) 1994-1995 Galacticomm, Inc.  All rights reserved.       *
 *                                                                         *
 *   This is the Galacticomm Client/Server File Library agent.             *
 *                                                                         *
 *                                              - D. Pitchford 9/7/94      *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "filexfer.h"
#include "reserve.h"
#include "galfilh.h"
#include "galfil.h"

#define FILREV "$Revision:   1.0.1.1.1.5  $"

#define dirbtv(d,x,y,z) (d == 0 ? acqbtv(x,y,z)\
                       : (d > 0 ? agtbtv(x,y,z) : altbtv(x,y,z)))

void filwrite(struct saunam *dpknam,unsigned length,void *value);
void filxdone(void);
void filabort(void);
void filread(int direction,struct saunam *dpknam);
struct fllib *dirlib(int direction,char *libname,BOOL visonly);
int findaxs(int direction,char *libname);
void filfs(int direction);
void fileinfo(void);
void download(void);
void upload(struct filinf *fd);
void moddesc(char *desc);
BOOL genchek(char *action,BOOL nodos,BOOL nocd);
void approve(char *datstr);
void rendel(char *newname);
void csmvcpy(BOOL move,char *destlib);
void csmcfile(void);
void viewcomp(void);
void viewtext(void);
int gotsrch(void);
void cntview(void);
void cycsrch(void);
void updsuff(char *suffix);
struct fsdpk *flfrsp(BOOL isdos,BOOL verbose);
void filibaxs(int direction);
void fillist(int direction);
void filunaps(int direction);
void filinfo(int direction);
void filjoin(int direction);
void filibedt(int direction);
void filjoins(int direction);
void wfiljoin(BOOL join);
void delalib(struct fllib *libptr);
void dlibrou(void);
void libedup(char *libname,struct fllib *libptr);
void sendjoin(void);
void reqcono(char *value);
void reqconn(char *value);
void reqcond(char *value);
void reqconf(char *value);
void reqconk(char *value);
void searcho(char *nam,int direction);
void searchn(char *nam,int direction);
void searchd(char *nam,int direction);
void searchf(char *nam,int direction);
void searchk(char *nam,int direction);
BOOL context(BOOL get);
BOOL hascontext(void);
int cslibrsv(char *lib,char *fil);
void copywait(void);
void sendfile(char *path);
void uplerror(void);
void finupl(void);
void cskwdins(void);
void filldesc(void);
BOOL isok2ul(BOOL reserve);
void delfile(void);
void delkwds(void);
void renkwds(void);
void inimaint(BOOL datype,BOOL write,BOOL approve,char *libname);
void maintit(void);
void dlerr(void);
void csunapan(void);

STATIC
struct agent filagt={              /* agent information structure          */
     "GALFIL",                     /*   appid                              */
     filread,                      /*   read-dynapak function pointer      */
     filwrite,                     /*   write-dynapak function pointer     */
     filxdone,                     /*   file xfer-done function pointer    */
     filabort                      /*   abort-request function pointer     */
};

#define XLDATLEN 600               /* max. length of space in xlibinfo     */

STATIC
struct xlibinfo {                  /* extended Library information struct  */
     long totfiles;                /*   total files in Library             */
     int addtoday;                 /*   files added today                  */
     int addweek;                  /*   files added this week              */
     long maxfil;                  /*   max files in Library               */
     long maxbyt;                  /*   max bytes in Library               */
     long maxbup;                  /*   max upload size                    */
     char data[XLDATLEN];          /*   space for strings                  */
} *xli;                            /* instance for reading information     */

STATIC
struct llistinf {                  /* Library information struct           */
     long numfiles;                /*   number of files in Library         */
     int flags;                    /*   bitflags (see below)               */
     char desc[FLDESCSZ];          /*   short Library description          */
} *lli;                            /* instance for reading information     */

#define LLISDOS 0x0001             /* flag for lli, DOS-Only Library       */
#define LLISUPL 0x0002             /* flag for lli, Lib uploadable to      */
#define LLISLOP 0x0004             /* flag for lli, LibOp access           */
#define LLISACD 0x0008             /* flag for lli, Library on CD          */
#define LLISHID 0x0010             /* flag for lli, Library hidden         */

struct libcsfil *lcsu,*lcsarr,*viewarr; /* files used by c/s users         */

STATIC
struct libcsed {
     int flags;                    /*   bitflags for Library, translated   */
     double created;               /*   VB date & time Library created     */
     long dlchge;                  /*   credit charge per file to download */
     long kdlchge;                 /*   credit charge per K to download    */
     int royal;                    /*   royalty percentage                 */
     long maxfil;                  /*   maximum # of files in Library      */
     long maxbyt;                  /*   maximum # of bytes in Library      */
     long maxbup;                  /*   maximum # of bytes per upload      */
     char data[XLDATLEN];          /*   space for strings                  */
} *eli;                            /* instance for reading information     */

#define ELIDOS 0x0001              /* flag for eli, DOS-Only Library       */
#define ELIRON 0x0002              /* flag for eli, Read-Only Library      */
#define ELIHID 0x0004              /* flag for eli, Hidden Library         */
#define ELISCD 0x0008              /* flag for eli, Library on CD          */
#define ELIADD 0x0010              /* flag for eli, Audit Downloads        */
#define ELIADU 0x0020              /* flag for eli, Audit Uploads          */
#define ELINCD 0x0040              /* flag for eli, No-charge Downloads    */
#define ELINCU 0x0080              /* flag for eli, No-charge Uploads      */
#define ELIAUD 0x0100              /* flag for eli, Always Audit UL/DL     */
#define ELIFUD 0x0200              /* flag for eli, Always Free Uploads    */

struct dlibrqi {                   /* delete-library request information   */
     int reqtype;                  /*   type of request, if needed         */
     int phase;                    /*   0=filedat 1=keywds 2=lib, then done*/
     char libname[FLNAMESZ];       /*   library being deleted              */
     char filname[FLFILENM];       /*   current file being deleted         */
};

#define dlqptr ((struct dlibrqi *)mrqptr)

struct srchrqi {                   /* cycled-search request information    */
     int reqtype;                  /*   type of request, if needed         */
     char libname[FLNAMESZ];       /*   library of last record             */
     char filname[FLFILENM];       /*   file of last record                */
     char other[FLKEYSIZ];         /*   date or # d/ls of last record      */
};                                 /*    (use max(DATESZ,NUMSZ,FLKEYSIZ)   */

#define srchptr ((struct srchrqi *)mrqptr)

struct ulrqi {                     /* write/file request information       */
     int reqtype;                  /*   type of request, if needed         */
     char libname[FLNAMESZ];       /*   library involved                   */
     char filname[FLFILENM];       /*   file involved                      */
     char newlib[FLNAMESZ];        /*   new library     (keywords)         */
     char newname[FLFILENM];       /*   new file name   (keywords)         */
     BOOL move;                    /*   file/kw move?    FALSE = copy      */
     BOOL app;                     /*   approve file on login (maint)      */
     unsigned date;                /*   date of file  (uploading)          */
     unsigned time;                /*   time of file  (uploading)          */
     long size;                    /*   size of file  (uploading)          */
     int status;                   /*   operation status                   */
     FILE *src;                    /*   source file pointer                */
     FILE *dst;                    /*   destination file pointer           */
     FILE *uzfp;                   /*   maint. file pointer                */
     struct fndblk fb;             /*   per-request dir data               */
};

#define ulptr ((struct ulrqi *)mrqptr)

#define ulkey(p) compkey(p->libname,p->filname)

#define ULRNON 0                   /* request type: none                   */
#define ULRUPL 1                   /* request type: upload                 */
#define ULRDNL 2                   /* request type: download               */
#define ULRTXT 3                   /* request type: viewtext               */
#define ULRMCP 4                   /* request type: move/copy              */
#define ULRMN0 5                   /* request type: maintenance type 0     */
#define ULRMN1 6                   /* request type: maintenance type 1     */
#define ULRZIP 7                   /* request type: unzipping in maint     */
#define ULRZPW 8                   /* request type: waiting to do desc     */

#define ULRVCM 20                  /* request type: viewing compressed     */

#define ULPONG 0                   /* upload status: file being sent       */
#define ULPCPY 1                   /* upload status: file being copied     */
#define ULPDAT 2                   /* upload status: data file insertion   */
#define ULPFIN 3                   /* upload status: finishing upload      */

#define MVCONG 0                   /* move/copy status: begin move/copy    */
#define MVCFIL 1                   /* move/copy status: copying bytes      */
#define MVCDAT 2                   /* move/copy status: file/lib data      */
#define MVCFIN 3                   /* move/copy status: finish up          */
#define MVCKWD 4                   /* move/copy status: keywords if needed */

struct fsdpk {                     /* file information return structure    */
     long cost;                    /*   approx. cost in credits to d/l     */
     long size;                    /*   file size                          */
     int dltime;                   /*   apx download time in minutes       */
     int flags;                    /*   flags on specific file             */
     double filedt;                /*   file's date and time               */
     double addedt;                /*   added date and time (0 = unapp'ed) */
     long numdls;                  /*   number of times downloaded         */
     char data[UIDSIZ+DESCSIZ];    /*   short desc. or uploader & full desc*/
} *fsdpkr;

#define FSDTVIEW 0x0001            /* flag, file is viewable text          */
#define FSDCVIEW 0x0002            /* flag, file is viewable compressed    */
#define FSDLIBOP 0x0004            /* flag, user has libop authority       */
#define FSDISDOS 0x0008            /* flag, file in DOS-Only Lib           */

int (*oldrsv)(char *,char *);      /* hook vector for old reserve call     */

BOOL newjoins=FALSE;               /* are there new libraries joined?      */

static char *uzbuf,                /* buffer for unzipping descriptions    */
            *lopcstg;              /* libop approve files command string   */

char *cslkey=NULL;                 /* key required for C/S access          */

static BOOL mainting=FALSE;        /* sysop currently using maint option?  */

void
init_cslib(void)                   /* initialize File Library for C/S mode */
{
     register_agent(&filagt);
     hook_connect(genlon);
     hook_disconnect(genhup);
     cslkey=stgopt(CSLKEY);
     lopcstg=stgopt(LOPCSTG);
     hook_announce(csunapan);
     dclmrq(sizeof(struct dlibrqi));
     dclmrq(sizeof(struct srchrqi));
     dclmrq(sizeof(struct ulrqi));
     xli=(struct xlibinfo *)alcmem(sizeof(struct xlibinfo));
     lli=(struct llistinf *)alcmem(sizeof(struct llistinf));
     eli=(struct libcsed *)alcmem(sizeof(struct libcsed));
     lcsarr=(struct libcsfil *)alczer(nterms*sizeof(struct libcsfil));
     viewarr=(struct libcsfil *)alczer(nterms*sizeof(struct libcsfil));
     uzbuf=alcmem(2049);
     oldrsv=librsv->amreading;
     librsv->amreading=cslibrsv;
}

STATIC void
filread(                           /* read-dynapak handler                 */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     char *dpkstg;

     setmbk(flmsg);
     fluoff(usrnum);
     *namtmp=*dpknam;
     dpkstg=cnvs2d(namtmp);
     if (!stdchk(cslkey)) {
          rejectreq();
          return;
     }
     if (!sameas(namtmp->usrid,usaptr->userid)) {
          if (samepato("sau:",dpkstg) || samepato("sauf:",dpkstg)) {
               rejectreq();
               return;
          }
     }
     ulptr->reqtype=ULRNON;
     if (samepato("sau:fs",dpkstg) && direction != 0) {
          filfs(direction);
          return;
     }
     if (samepato("sau:fileinfo ",dpkstg) && direction == 0) {
          fileinfo();
          return;
     }
     if (samepato("sauf:download ",dpkstg) && direction == 0 && forreal()) {
          download();
          return;
     }
     if (samepato("sau:viewcomp ",dpkstg) && direction == 0) {
          viewcomp();
          return;
     }
     if (samepato("sauf:viewtext ",dpkstg) && direction == 0) {
          viewtext();
          return;
     }
     if (samepato("sau:libaxs",dpkstg)
        && strlen(firstwd(namtmp->suffix)) == strlen("libaxs")) {
          filibaxs(direction);
          return;
     }
     if (samepato("sau:llist ",dpkstg)) {
          fillist(direction);
          return;
     }
     if (samepato("sau:lunaps ",dpkstg)) {
          filunaps(direction);
          return;
     }
     if (samepato("sau:linfo ",dpkstg)) {
          filinfo(direction);
          return;
     }
     if (samepato("sa:ljoin ",dpkstg)) {
          filjoin(direction);
          return;
     }
     if (samepato("sa:libedit ",dpkstg) && haskey(flsysop)) {
          filibedt(direction);
          return;
     }
     if (samepato("sau:ljoinings ",dpkstg)) {
          filjoins(direction);
          return;
     }
     rejectreq();
}

STATIC void
filwrite(                          /* write-dynapak handler                */
struct saunam *dpknam,             /*   dynapak name to write              */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value to write             */
{
     struct fllib *libptr;
     char *dpkstg,libname[FLNAMESZ],*s;
     BOOL join,datype,write,app;
     int i;

     setmbk(flmsg);
     fluoff(usrnum);
     *namtmp=*dpknam;
     dpkstg=cnvs2d(namtmp);
     if (!stdchk(cslkey)) {
          rejectreq();
          return;
     }
     if (!sameas(namtmp->usrid,usaptr->userid)) {
          if (samepato("sau:",dpkstg) || samepato("sauf:",dpkstg)) {
               rejectreq();
               return;
          }
     }
     ulptr->reqtype=ULRNON;
     if (haskey(flsysop)) {
          if (samepato("sau:maint ",dpkstg)) {
               firstwd(namtmp->suffix);
               datype=sameas(nextwd(),"1");
               write=!sameas(s=nextwd(),"0");
               app=sameas(s,"2");
               inimaint(datype,write,app,length == 0 ? "" : value);
               return;
          }
          if (samepato("sa:ljoin ",dpkstg) && length > 0) {
               if ((join=sameto("1",value)) != FALSE || sameto("0",value)) {
                    wfiljoin(join);
               }
               else {
                    rejectreq();
               }
               return;
          }
          if (samepato("sa:libedit ",dpkstg)) {
               stzcpy(libname,lastwd(namtmp->suffix),FLNAMESZ);
               libptr=libfind(strupr(libname));
               if (length == 0) { /* delete Library */
                    if (libptr != NULL) {
                         delalib(libptr);
                         return;
                    }
               }
               else {
                    setbtv(flldat);
                    setmem(libupd,sizeof(struct libdisk),0);
                    curlib=&libupd->lib;
                    if (acqbtv(libupd,libname,0)) {
                         if (libptr == NULL) {
                              prfmsg(NOCRTLIB);
                              r2wprf(FALSE);
                              return;
                         }
                    }
                    else {
                         if (libptr != NULL) {
                              prfmsg(NOEDTLIB);
                              r2wprf(FALSE);
                              return;
                         }
                         if (!valname(libname)) {
                              prfmsg(NAMEOLIB);
                              r2wprf(FALSE);
                              return;
                         }
                    }
                    curlib=&libupd->lib;
                    movmem(value,eli,sizeof(struct libcsed));
                    eli->data[XLDATLEN-1]='\0';
                    while (eli->data[i=strlen(eli->data)-1] == ' ') {
                         eli->data[i]='\0';
                    }
                    libedup(libname,libptr);
                    return;
               }
               rejectreq();
               return;
          }
     }
     if (samepato("sauf:upload ",dpkstg)) {
          upload(value);
          return;
     }
     if (samepato("sau:moddesc ",dpkstg)) {
          moddesc(length > 0 ? value : "");
          return;
     }
     if (samepato("sau:approve ",dpkstg)) {
          approve(length > 0 ? value : "");
          return;
     }
     if (samepato("sau:file ",dpkstg)) {
          rendel(length > 0 ? value : "");
          return;
     }
     if (samepato("sau:move ",dpkstg) && length > 0) {
          csmvcpy(TRUE,value);
          return;
     }
     if (samepato("sau:copy ",dpkstg) && length > 0) {
          csmvcpy(FALSE,value);
          return;
     }
     if (samepato("sau:fs",dpkstg)) {
          if (length == 0) {
               if (samepat("sau:fs",dpkstg)) { /* end of context */
                    context(FALSE);
                    rsp2write(TRUE,0,NULL);
               }
               else {
                    rejectreq();
               }
               return;
          }
          if (sameas(namtmp->suffix,"fso")) { /* request DOS-Only context */
               if (context(TRUE)) {
                    reqcono(value);
                    return;
               }
          }
          else if (sameas(namtmp->suffix,"fsn")) { /* request #D/Ls context */
               if (context(TRUE)) {
                    reqconn(value);
                    return;
               }
          }
          else if (sameas(namtmp->suffix,"fsd")) { /* request datesrch context */
               if (context(TRUE)) {
                    reqcond(value);
                    return;
               }
          }
          else if (sameas(namtmp->suffix,"fsf")) { /* request filename context */
               if (context(TRUE)) {
                    reqconf(value);
                    return;
               }
          }
          else if (sameas(namtmp->suffix,"fsk")) { /* request keyword context */
               if (context(TRUE)) {
                    reqconk(value);
                    return;
               }
          }
          else {
               rejectreq();
               return;
          }
          prfmsg(CSNOSRCH);
          r2wprf(FALSE);
          return;
     }
     rejectreq();
}

STATIC void
filxdone(void)                     /* file transfer-done handler           */
{
     struct fllib *libptr;
     long charge;

     setmbk(flmsg);
     switch (ulptr->reqtype) {
     case ULRUPL:
          if (isok2ul(FALSE)) {
               cycleme(finupl);
          }
          else {
               donewrit(0);
               unlink(spr("%s\\%s",userdir(1),ulptr->filname));
               r2wprf(FALSE);
          }
          break;
     case ULRTXT:
          setmem(&viewarr[usrnum],sizeof(struct libcsfil),0);
          break;
     case ULRDNL:
          libptr=libfind(lcsarr[usrnum].libname);
          if ((charge=lcsarr[usrnum].charge) != 0L && libptr->royal > 0) {
               setbtv(flfdat);
               if (acqbtv(NULL,
                  compkey(lcsarr[usrnum].libname,lcsarr[usrnum].filname),
                  COMPLF)
                  && !sameas(flf->ulby,"Sysop")) {
                    crdusr(flf->ulby,
                       l2as(charge*(long)libptr->royal/100L),0,0);
               }
               rstbtv();
          }
          sv.dwnlds++;
          if (libptr != NULL && (auditall || (libptr->flags&FLGADL))) {
               shocst("LIBRARY FILE DOWNLOAD","User %s download %s\\%s",
                  usaptr->userid,lcsarr[usrnum].libname,lcsarr[usrnum].filname);
          }
          dnlcount(lcsarr[usrnum].libname,lcsarr[usrnum].filname,-1L);
          lcsarr[usrnum].status=-abs(lcsarr[usrnum].status);
          csclean(usrnum);
     }
}

STATIC void
filabort(void)                     /* abort-request handler                */
{
     struct fllib *libptr;

     setmbk(flmsg);
     switch (ulptr->reqtype) {
     case ULRVCM:
          switch (flo->cszview.state) {
          case 0:
          case 1: /* VEWOPN */
               break;  /* file closed */
          default:
               fclose(flo->cszview.fp);
          }
          setmem(&viewarr[usrnum],sizeof(struct libcsfil),0);
          flo->cszview.state=0;
          break;
     case ULRUPL:
          if (ulptr->src != NULL) {
               fclose(ulptr->src);
               ulptr->src=NULL;
          }
          if (ulptr->dst != NULL) {
               fclose(ulptr->dst);
               ulptr->dst=NULL;
          }
          donewrit(0);
          unlink(spr("%s\\%s",userdir(1),ulptr->filname));
          libptr=libfind(ulptr->libname);
          if (libptr != NULL && (auditall || (libptr->flags&FLGAUL))) {
               shocst("LIBRARY FILE UPLOAD ABORTED",
                      "User %s aborted upld of %s\\%s",
                      usaptr->userid,ulptr->libname,ulptr->filname);
          }
          break;
     case ULRMCP:
          if (ulptr->src != NULL) {
               fclose(ulptr->src);
               ulptr->src=NULL;
          }
          if (ulptr->dst != NULL) {
               fclose(ulptr->dst);
               ulptr->dst=NULL;
          }
          donewrit(1);
          donewrit(2);
          break;
     case ULRDNL:
          if (lcsarr[usrnum].charge != 0L) {
               hdedcrd(usaptr,-lcsarr[usrnum].charge,0,1);
          }
          libptr=libfind(lcsarr[usrnum].libname);
          if (libptr != NULL && (auditall || (libptr->flags&FLGADL))) {
               shocst("LIBRARY FILE DOWNLOAD ABORTED",
                  "User %s aborted dnld of %s\\%s",usaptr->userid,
                                                   lcsarr[usrnum].libname,
                                                   lcsarr[usrnum].filname);
          }
          lcsarr[usrnum].status=-abs(lcsarr[usrnum].status);
          csclean(usrnum);
          break;
     case ULRMN0:
     case ULRMN1:
     case ULRZIP:
     case ULRZPW:
          mainting=FALSE;
          if (ulptr->uzfp != NULL) {
               fclose(ulptr->uzfp);
          }
          break;
     default:
          break;
     }
}

STATIC struct fllib *
dirlib(                            /* get nxt/prv/matching visible Library */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
char *libname,                     /*   Library name                       */
BOOL visonly)                      /*   visible Libraries only             */
{
     int i;
     struct fllib *libptr;

     if (direction == 0) {
          if ((libptr=libfind(libname)) != NULL) {
               if (visonly) {
                    if (!visilib(libptr)) {
                         libptr=NULL;
                    }
               }
               else {
                    if (!haslibkey(libptr,libptr->keyreq)) {
                         libptr=NULL;
                    }
               }
          }
     }
     else if (direction < 0) {
          for (i=numoflib-1 ; i >= 0 ; i--) {
               libptr=alphlibs[i];
               if (stricmp(libptr->libname,libname) < 0) {
                    if (visonly) {
                         if (visilib(libptr)) {
                              return(libptr);
                         }
                    }
                    else {
                         if (haslibkey(libptr,libptr->keyreq)) {
                              return(libptr);
                         }
                    }
               }
          }
          libptr=NULL;
     }
     else {
          for (i=0 ; i < numoflib ; i++) {
               libptr=alphlibs[i];
               if (stricmp(libptr->libname,libname) > 0) {
                    if (visonly) {
                         if (visilib(libptr)) {
                              return(libptr);
                         }
                    }
                    else {
                         if (haslibkey(libptr,libptr->keyreq)) {
                              return(libptr);
                         }
                    }
               }
          }
          libptr=NULL;
     }
     return(libptr);
}

STATIC int
findaxs(                           /* return appropriate Library access    */
int direction,                     /*   dynapak read direction             */
char *libname)                     /*   library name to key with           */
{
     int retval=0,loop;

     if (libname[0] == '\0' && direction == 0) {
          for (loop=0 ; loop < numoflib ; loop++) {
               if (isflop(curlib=liboff(loop))) {
                    retval=haskey(flsysop) ? 2 : 1;
                    break;
               }
          }
     }
     else {
          if ((curlib=dirlib(direction,libname,TRUE)) == NULL) {
               retval=-1;
          }
          else if (haskey(flsysop)) {
               retval=2;
          }
          else if (isflop(curlib)) {
               retval=1;
          }
     }
     return(retval);
}

STATIC void
filfs(
int direction)
{
     char *nam;

     if (!hascontext()) {
          rejectreq();
          return;
     }
     nam=skpwht(skpwrd(namtmp->suffix));
     if (sameto("fso ",namtmp->suffix)) {
          searcho(nam,direction);
          return;
     }
     if (sameto("fsn ",namtmp->suffix)) {
          searchn(nam,direction);
          return;
     }
     if (sameto("fsd ",namtmp->suffix)) {
          searchd(nam,direction);
          return;
     }
     if (sameto("fsf ",namtmp->suffix)) {
          searchf(nam,direction);
          return;
     }
     if (sameto("fsk ",namtmp->suffix)) {
          searchk(nam,direction);
          return;
     }
     rejectreq();
}

STATIC void
fileinfo(void)                     /* send all information on a file       */
{
     struct key1 key;
     struct fndblk fb;
     char curlib[FLNAMESZ];
     struct fllib *libptr;
     BOOL ok=FALSE;

     stzcpy(key.libname,firstwd(skpwht(skpwrd(namtmp->suffix))),FLNAMESZ);
     stzcpy(key.filname,nextwd(),FLFILENM);
     stzcpy(curlib,nextwd(),FLNAMESZ);
     setbtv(flfdat);
     if ((libptr=libfind(key.libname)) != NULL) {
          if (strlen(visxlib(libptr,curlib)) != 0) {
               if (libptr->flags&FLGDOS) {
                    fb=flo->fb;
                    if (fnd1st(&flo->fb,spr("%s\\%s",
                       libpath(libptr),key.filname),0)) {
                         fsdpkr=flfrsp(TRUE,TRUE);
                         ok=TRUE;
                    }
                    flo->fb=fb;
               }
               else if (acqbtv(flf,&key,COMPLF)) {
                    fsdpkr=flfrsp(FALSE,TRUE);
                    ok=TRUE;
               }
          }
     }
     rstbtv();
     if (ok) {
          rsp2read(namtmp,
            sizeof(struct fsdpk)-(UIDSIZ+DESCSIZ)+strlen(fsdpkr->data),fsdpkr);
     }
     else {
          rejectreq();
     }
}

STATIC void
download(void)                     /* download a file                      */
{
     struct key1 key;
     struct fndblk fb;
     char curlib[FLNAMESZ];
     struct fllib *libptr;
     BOOL ok=FALSE;

     stzcpy(key.libname,firstwd(skpwht(skpwrd(namtmp->suffix))),FLNAMESZ);
     stzcpy(key.filname,nextwd(),FLFILENM);
     stzcpy(curlib,nextwd(),FLNAMESZ);
     setbtv(flfdat);
     if ((libptr=libfind(key.libname)) != NULL) {
          if (strlen(visxlib(libptr,curlib)) != 0) {
               if (!haslibkey(libptr,libptr->dlkey)) {
                    ok=FALSE;
               }
               else if (libptr->flags&FLGDOS) {
                    fb=flo->fb;
                    if (fnd1st(&flo->fb,spr("%s\\%s",
                       libpath(libptr),key.filname),0)) {
                         ok=TRUE;
                    }
                    flo->fb=fb;
               }
               else if (acqbtv(flf,&key,COMPLF)) {
                    if (!notapped(flf->udate) || isflop(libptr)) {
                         ok=TRUE;
                    }
               }
          }
     }
     rstbtv();
     if (ok) {
          if ((othusn=w2read(key.libname,key.filname)) != NOCONFLICT) {
               prfmsg(CSNODL,key.libname,key.filname,
                  haskey(flsysop) ? uacoff(othusn)->userid : "someone");
               rejectreq();
               dlerr();
               return;
          }
          if (lcsarr[usrnum].status < 0) {
               csclean(usrnum);
          }
          else if (lcsarr[usrnum].status > 0) {
               prfmsg(CSCTDL,key.filname,lcsarr[usrnum].filname);
               rejectreq();
               dlerr();
               return;
          }
          stzcpy(lcsarr[usrnum].libname,key.libname,FLNAMESZ);
          stzcpy(lcsarr[usrnum].filname,key.filname,FLFILENM);
          lcsarr[usrnum].status=FREADY;
          lcsarr[usrnum].time=now();
          ulptr->reqtype=ULRDNL;
          if (!(libptr->flags&FLGDOS) && (libptr->flags&FLGCBD)) {
               lcsarr[usrnum].status=(libptr->path[0] == '\0')
                                                            ? EXTCDF : CDFILE;
               cycleme(copywait);
          }
          else {
               sendfile(spr("%s\\%s",libpath(libptr),key.filname));
          }
     }
     else {
          prfmsg(CSDLGONE,key.libname,key.filname);
          rejectreq();
          dlerr();
     }
}

STATIC void
upload(                            /* receive a file dpk upload            */
struct filinf *fd)                 /*   file data                          */
{
     char *s;

     firstwd(namtmp->suffix);
     stzcpy(ulptr->libname,strupr(nextwd()),FLNAMESZ);
     stzcpy(ulptr->filname,strupr(nextwd()),FLFILENM);
     /* we don't care what fd->name, the "actual" file name is */
     ulptr->date=fd->date;
     ulptr->time=fd->time;
     ulptr->size=fd->size;
     if (isok2ul(TRUE)) {
          mkdir(s=userdir(1));
          ulptr->status=ULPONG;
          ulptr->src=NULL;
          ulptr->dst=NULL;
          ulptr->reqtype=ULRUPL;
          ok2write(spr("%s\\%s",s,ulptr->filname));
     }
     else {
          r2wprf(FALSE);
     }
}

STATIC void
moddesc(                           /* receive a description, uploader, date*/
char *desc)
{
     struct fllib *libptr;
     char *s,*othinfo;
     BOOL ok=TRUE;
     long datpos;

     firstwd(namtmp->suffix);
     stzcpy(ulptr->libname,strupr(nextwd()),FLNAMESZ);
     stzcpy(ulptr->filname,strupr(nextwd()),FLFILENM);
     if ((libptr=libfind(ulptr->libname)) == NULL
        || strlen(visxlib(libptr,"")) == 0) {
          prfmsg(CSNOMODD);
          r2wprf(FALSE);
          return;
     }
     if (libptr->flags&FLGDOS) {
          prfmsg(CSNOMDOS);
          r2wprf(FALSE);
          return;
     }
     setbtv(flfdat);
     if (!acqbtv(NULL,ulkey(ulptr),COMPLF)) {
          prfmsg(CSNOMFNF);
          r2wprf(FALSE);
          return;
     }
     if ((othinfo=strchr(desc,'\t')) != NULL) {
          *othinfo++='\0';
     }
     if (!isflop(libptr)) {
          if (othinfo != NULL) {
               ok=FALSE;
          }
          else if (!sameas(usaptr->userid,flf->ulby)) {
               ok=FALSE;
          }
          else if (!notapped(flf->udate)
             && !haslibkey(libptr,libptr->autoap)) {
               ok=FALSE;
          }
     }
     if (!ok) {
          prfmsg(CSNOMDNY);
          r2wprf(FALSE);
          return;
     }
     if ((othusn=w2writ(libptr->libname,ulptr->filname,0)) != NOCONFLICT) {
          prfmsg(CSNOMRSV,ulptr->libname,ulptr->filname,
             haskey(flsysop) ? uacoff(othusn)->userid  : "someone");
          r2wprf(FALSE);
          return;
     }
     stzcpy(s=descedit,desc,DESCSIZ);
     do {
          while (*s == '\n') {
               strcpy(s,s+1);
          }
     } while (*s++ != '\0');
     darsdesc(NDESCLN,'\r');
     filldesc();
     if (othinfo != NULL) {
          s=itemidx(othinfo,0);
          s=(*s == '\0' ? NOTAPPED : dat2srt(s));
          if (notapped(flf->udate)) {
               libptr->appwait--;
          }
          chuldate(libptr,flf->udate,0);
          stzcpy(flf->udate,s,DATESZ);
          if (notapped(flf->udate)) {
               libptr->appwait++;
          }
          chuldate(libptr,flf->udate,1);
          s=itemidx(othinfo,1);
          if (*s != '\0') {
               datpos=absbtv();
               setbtv(accbb);
               if (qeqbtv(s,0)) {
                    stzcpy(flf->ulby,s,UIDSIZ);
               }
               rstbtv();
               if (!aabbtv(vdatmp,datpos,COMPLF)) {
                    catastro("BAD LIBRARY FILE DATA FILE POINTER (C/S)");
               }
          }
     }
     upvbtv(NULL,FLFILREC+strlen(flf->desc)+1);
     if (longsrch) {
          rsp2write(TRUE,0,"");
          donewrit(0);
     }
     else {
          cycleme(cskwdins);
     }
}

STATIC BOOL                        /*   returns FALSE for failed check     */
genchek(                           /* generic check of file rights for     */
char *action,                      /*   write operation.  action=operation */
BOOL nodos,                        /*   operation not for DOS-ONLY Libs    */
BOOL nocd)                         /*   operation not for CD libs          */
{
     struct fndblk fb;

     firstwd(namtmp->suffix);
     stzcpy(ulptr->libname,strupr(nextwd()),FLNAMESZ);
     stzcpy(ulptr->filname,strupr(nextwd()),FLFILENM);
     if ((curlib=libfind(ulptr->libname)) == NULL
        || strlen(visxlib(curlib,"")) == 0) {
          prfmsg(ACTNOLIB,action);
          return(FALSE);
     }
     if (!isflop(curlib)) {
          prfmsg(ACTNOAXS,action);
          return(FALSE);
     }
     if (curlib->flags&FLGDOS) {
          if (nodos) {
               prfmsg(ACTNODOS,action);
               return(FALSE);
          }
          if (!fnd1st(&fb,spr("%s\\%s",libpath(curlib),ulptr->filname),0)) {
               prfmsg(ACTFNF,action);
               return(FALSE);
          }
          ulptr->size=fb.size;
          ulptr->date=fb.date;
          ulptr->time=fb.time;
     }
     else {
          setbtv(flfdat);
          if (!acqbtv(NULL,ulkey(ulptr),COMPLF)) {
               prfmsg(ACTFNF,action);
               return(FALSE);
          }
          ulptr->size=flf->siz;
          ulptr->date=dcdate(srt2dat(flf->fdate));
          ulptr->time=flf->tim;
     }
     if (nocd && curlib->flags&FLGCBD) {
          prfmsg(ACTNONCD,action);
          return(FALSE);
     }
     if ((othusn=w2writ(ulptr->libname,ulptr->filname,1)) != NOCONFLICT) {
          prfmsg(ACTNORSV,action,
             haskey(flsysop) ? uacoff(othusn)->userid : "someone");
          return(FALSE);
     }
     return(TRUE);
}

STATIC void
approve(                           /* approve a file                       */
char *datstr)                      /*   MM/DD/YY date, or "" to unapprove  */
{
     char newdat[DATESZ],*action;

     action=(datstr[0] == '\0' ? "unapprove" : "approve");
     if (!genchek(action,TRUE,FALSE)) {
          r2wprf(FALSE);
          return;
     }
     if (datstr[0] == '\0') {
          stzcpy(newdat,NOTAPPED,DATESZ);
     }
     else {
          stzcpy(newdat,dat2srt(datstr),DATESZ);
          if (!sameas(srt2dat(newdat),datstr)) {
               prfmsg(ACTNODAT,action);
               donewrit(1);
               r2wprf(FALSE);
               return;
          }
     }
     if (notapped(flf->udate)) {
          curlib->appwait--;
     }
     chuldate(curlib,flf->udate,0);
     stzcpy(flf->udate,newdat,DATESZ);
     if (notapped(flf->udate)) {
          curlib->appwait++;
     }
     else {
          flf->utime=now();
     }
     chuldate(curlib,flf->udate,1);
     upvbtv(NULL,FLFILREC+strlen(flf->desc)+1);
     donewrit(1);
     rsp2write(TRUE,0,"");
}

STATIC void
rendel(                            /* rename or delete file                */
char *newname)                     /*   new name, or "" to delete          */
{
     char fname[FLFILENM],*f,*n,*s,*action;
     int lnn,lpp;

     action=(newname[0] == '\0' ? "delete" : "rename");
     if (!genchek(action,FALSE,newname[0] == '\0' ? FALSE : TRUE)) {
          r2wprf(FALSE);
          return;
     }
     if (newname[0] == '\0') { /* delete */
          if ((curlib->flags&FLGDOS) || longsrch) {
               delfile();
          }
          else {
               cycleme(delkwds);
          }
          return;
     }
     s=strchr(newname,'.');
     if (s != NULL) {
          lpp=(int)(s-newname);
     }
     lnn=strlen(newname);
     if ((s == NULL && lnn > 8) || lpp > 9 || lnn-lpp > 4) {
          prfmsg(RENNOFNM,"rename",newname);
          donewrit(1);
          r2wprf(FALSE);
          return;
     }
     setmem(fname,FLFILENM,0);
     for (n=newname,f=fname ; *n != '\0' ; n++,f++) {
          if (!isfiln(*n,fname) || strlen(fname) == FLFILENM-1) {
               prfmsg(RENNOFNM,"rename",newname);
               donewrit(1);
               r2wprf(FALSE);
               return;
          }
          *f=*n;
     }
     if ((othusn=w2writ(strupr(ulptr->libname),strupr(fname),2))
                                                              != NOCONFLICT) {
          prfmsg(RENNORSV,haskey(flsysop)
             ? uacoff(othusn)->userid : "someone");
          donewrit(1);
          r2wprf(FALSE);
          return;
     }
     if (curlib->flags&FLGDOS) {
          if (rename(spr("%s\\%s",libpath(curlib),ulptr->filname),
                     spr("%s\\%s",libpath(curlib),fname)) == 0) {
               donewrit(1);
               donewrit(2);
               rsp2write(TRUE,0,"");
               return;
          }
     }
     else {
          setbtv(flfdat);
          if (!acqbtv(NULL,compkey(ulptr->libname,fname),COMPLF)) {
               unlink(s=spr("%s\\%s",libpath(curlib),fname));
               if (rename(
                      spr("%s\\%s",libpath(curlib),ulptr->filname),s) == 0) {
                    if (acqbtv(NULL,ulkey(ulptr),COMPLF)) {
                         stzcpy(flf->filname,fname,FLFILENM);
                         upvbtv(NULL,FLFILREC+strlen(flf->desc)+1);
                    }
                    else {
                         prf("Lost record of old file during rename.");
                         donewrit(1);
                         donewrit(2);
                         r2wprf(FALSE);
                         return;
                    }
                    if (!longsrch) {
                         stzcpy(ulptr->newname,fname,FLFILENM);
                         stzcpy(ulptr->newlib,ulptr->libname,FLNAMESZ);
                         ulptr->move=TRUE;
                         cycleme(renkwds);
                    }
                    else {
                         donewrit(1);
                         donewrit(2);
                         rsp2write(TRUE,0,"");
                    }
                    rstbtv();
                    return;
               }
          }
          rstbtv();
     }
     prfmsg(RENNOWAY,ulptr->filname,fname);
     donewrit(1);
     donewrit(2);
     r2wprf(FALSE);
}

STATIC void
csmvcpy(                           /* move or copy file                    */
BOOL move,                         /*   whether to move                    */
char *destlib)                     /*   destination libname                */
{
     char *action;

     action=move ? "move" : "copy";
     if (!genchek(action,FALSE,TRUE)) {
          r2wprf(FALSE);
          return;
     }
     if ((curlib=libfind(destlib)) == NULL
        || strlen(visxlib(curlib,"")) == 0) {
          prfmsg(MVCNOLIB,action);
          donewrit(1);
          r2wprf(FALSE);
          return;
     }
     if (!isflop(curlib)) {
          prfmsg(MVCNOAXS,action);
          donewrit(1);
          r2wprf(FALSE);
          return;
     }
     if (curlib->flags&FLGCBD) {
          prfmsg(MVCNONCD,action);
          donewrit(1);
          r2wprf(FALSE);
          return;
     }
     ulptr->move=move;
     stzcpy(ulptr->newlib,strupr(destlib),FLNAMESZ);
     stzcpy(ulptr->newname,strupr(ulptr->filname),FLFILENM);
     ulptr->status=MVCONG;
     if ((othusn=w2writ(ulptr->newlib,ulptr->newname,2)) != NOCONFLICT) {
          prfmsg(MVCNORSV,
             haskey(flsysop) ? uacoff(othusn)->userid : "someone");
          donewrit(1);
          r2wprf(FALSE);
          return;
     }
     ulptr->reqtype=ULRMCP;
     cycleme(csmcfile);
}

STATIC void
csmcfile(void)                     /* grunt work of moving/copying file    */
{
     char *src,*dst;
     struct fllib *srcl,*dstl;
     int loop,byte;

     setmbk(flmsg);
     fluoff(usrnum);
     if ((srcl=libfind(ulptr->libname)) == NULL
        || (dstl=libfind(ulptr->newlib)) == NULL) {
          prfmsg(MVCERLIB);
          r2wprf(FALSE);
          donewrit(1);
          donewrit(2);
          return;
     }
     switch (ulptr->status) {
     case MVCONG:
          src=spr("%s\\%s",libpath(srcl),ulptr->filname);
          dst=spr("%s\\%s",libpath(dstl),ulptr->newname);
          if (!ulptr->move || rename(src,dst) != 0) {
               if (ulptr->move && (ulptr->dst=fopen(dst,FOPRB)) != NULL) {
                    fclose(ulptr->dst);
                    prfmsg(WARNMVCS);
                    r2wprf(FALSE);
                    donewrit(1);
                    donewrit(2);
                    return;
               }
               if ((ulptr->src=fopen(src,FOPRB)) == NULL) {
                    uplerror();
                    donewrit(1);
                    donewrit(2);
                    return;
               }
               if ((ulptr->dst=fopen(dst,FOPWB)) == NULL) {
                    uplerror();
                    donewrit(1);
                    donewrit(2);
                    return;
               }
               ulptr->status=MVCFIL;
          }
          else {
               ulptr->status=MVCDAT;
          }
          break;
     case MVCFIL:
          if (ulptr->src == NULL || ulptr->dst == NULL) {
               uplerror();
               donewrit(1);
               donewrit(2);
               return;
          }
          for (loop=0 ; loop < 1024 ; loop++) {
               byte=fgetc(ulptr->src);
               if (!feof(ulptr->src) && !ferror(ulptr->src)
                  && !ferror(ulptr->dst)) {
                    fputc(byte,ulptr->dst);
               }
               else {
                    loop=2000;
               }
          }
          if (loop >= 2000) {
               if (ulptr->src != NULL) {
                    fclose(ulptr->src);
                    ulptr->src=NULL;
               }
               if (ulptr->dst != NULL) {
                    fclose(ulptr->dst);
                    ulptr->dst=NULL;
               }
               src=spr("%s\\%s",libpath(srcl),ulptr->filname);
               dst=spr("%s\\%s",libpath(dstl),ulptr->newname);
               touch(src,dst);
               if (ulptr->move) {
                    unlink(src);
               }
               ulptr->status=MVCDAT;
          }
          break;
     case MVCDAT: /* data files */
          setbtv(flfdat);
          if (!(dstl->flags&FLGDOS)) {
               if (acqbtv(NULL,compkey(ulptr->newlib,ulptr->newname),COMPLF)) {
                    delbtv();
               }
          }
          if (!(srcl->flags&FLGDOS)) {
               if (!acqbtv(NULL,ulkey(ulptr),COMPLF)) {
                    prf("Error - source file data missing!");
                    /* highly unusual */
                    r2wprf(FALSE);
                    donewrit(1);
                    donewrit(2);
                    return;
               }
               if (ulptr->move) {
                    srcl->numfiles--;
                    srcl->totbytes-=clfit(ulptr->size,srcl->cluster);
                    if (notapped(flf->udate)) {
                         srcl->appwait--;
                    }
                    chuldate(srcl,flf->udate,0);
                    delbtv();
                    srcl->flags|=LIBCHN;
               }
          }
          if (!(dstl->flags&FLGDOS)) {
               stzcpy(flf->libname,strupr(ulptr->newlib),FLNAMESZ);
               stzcpy(flf->filname,strupr(ulptr->newname),FLFILENM);
               if (srcl->flags&FLGDOS) {
                    sprintf(flf->numdls,NUMSZP,0L);
                    stzcpy(flf->udate,dat2srt(ncdate(today())),DATESZ);
                    stzcpy(flf->ulby,usaptr->userid,UIDSIZ);
                    flf->utime=now();
                    stzcpy(flf->fdate,dat2srt(ncdate(ulptr->date)),DATESZ);
                    flf->tim=ulptr->time;
                    flf->siz=ulptr->size;
                    flf->desc[0]='\0';
               }
               invbtv(NULL,FLFILREC+strlen(flf->desc)+1);
               dstl->numfiles++;
               dstl->totbytes+=clfit(ulptr->size,dstl->cluster);
               if (notapped(flf->udate)) {
                    dstl->appwait++;
               }
               chuldate(dstl,flf->udate,1);
               dstl->flags|=LIBCHN;
          }
          ulptr->status=MVCFIN;
          break;
     case MVCFIN: /* keywords if necessary, else finish */
          if (longsrch || (srcl->flags&FLGDOS)) {
               donewrit(1);
               donewrit(2);
               rsp2write(TRUE,0,"");
               return;
          }
          ulptr->status=MVCKWD;
     case MVCKWD:
          renkwds();
     }
}

STATIC void
viewcomp(void)                     /* send all information on a file       */
{
     struct key1 key;
     struct fndblk fb;
     struct fllib *libptr;
     BOOL ok=FALSE;

     stzcpy(key.libname,firstwd(skpwht(skpwrd(namtmp->suffix))),FLNAMESZ);
     stzcpy(key.filname,nextwd(),FLFILENM);
     setbtv(flfdat);
     if ((libptr=libfind(key.libname)) != NULL
            && haslibkey(libptr,libptr->dlkey)) {
          if (flo->cszview.state != 0) {
               if (sameas(flo->cszview.libname,key.libname)
                  && sameas(flo->cszview.filname,key.filname)) {
                    ok=TRUE;
               }
          }
          else if (strlen(visxlib(libptr,"")) != 0) {
               if ((libptr->flags&FLGDOS) || acqbtv(flf,&key,COMPLF)) {
                    if (!(libptr->flags&FLGCBD)) {
                         if (fnd1st(&fb,spr("%s\\%s",
                            libpath(libptr),key.filname),0)) {
                              ok=TRUE;
                         }
                    }
               }
          }
     }
     rstbtv();
     if (ok) {
          stzcpy(viewarr[usrnum].libname,key.libname,FLNAMESZ);
          stzcpy(viewarr[usrnum].filname,key.filname,FLFILENM);
          if (flo->cszview.state == 0) {
               stzcpy(flo->cszview.libname,key.libname,FLNAMESZ);
               stzcpy(flo->cszview.filname,key.filname,FLFILENM);
               flo->cszview.state=1;
          }
          ulptr->reqtype=ULRVCM;
          cycleme(cntview);
          return;
     }
     rejectreq();
}

STATIC void
viewtext(void)                     /* transfer a text file for display     */
{
     struct key1 key;
     struct fndblk fb;
     struct fllib *libptr;
     char *fpath;
     BOOL ok=FALSE;

     stzcpy(key.libname,firstwd(skpwht(skpwrd(namtmp->suffix))),FLNAMESZ);
     stzcpy(key.filname,nextwd(),FLFILENM);
     setbtv(flfdat);
     if ((libptr=libfind(key.libname)) != NULL
            && haslibkey(libptr,libptr->dlkey)) {
          if (strlen(visxlib(libptr,"")) != 0) {
               if (w2read(key.libname,key.filname) == NOCONFLICT) {
                    if ((libptr->flags&FLGDOS) || acqbtv(flf,&key,COMPLF)) {
                         if (!(libptr->flags&FLGCBD)) {
                              if (fnd1st(&fb,fpath=spr("%s\\%s",
                                 libpath(libptr),key.filname),0)) {
                                   ok=TRUE;
                              }
                         }
                    }
               }
          }
     }
     rstbtv();
     if (ok) {
          if (forreal()) {
               stzcpy(viewarr[usrnum].libname,key.libname,FLNAMESZ);
               stzcpy(viewarr[usrnum].filname,key.filname,FLFILENM);
               ulptr->reqtype=ULRTXT;
          }
          rsp2read(namtmp,STGLEN,fpath);
     }
     else {
          rejectreq();
     }
}

STATIC void
cntview(void)
{
     struct saunam unsol;

     fluoff(usrnum);
     rsptmp[0]='\0';
     if (vewctn()) {
          if (rsptmp[0] == '\0') {
               return;
          }
          if (qroom(usrnum,NORMAL) && cnvd2s("sa:viewcomp",&unsol)) {
               senddpk(usrnum,"GALFIL",NORMAL,&unsol,STGLEN,rsptmp);
          }
     }
     else {
          setmem(&viewarr[usrnum],sizeof(struct libcsfil),0);
          flo->cszview.state=0;
          *namtmp=rqdptr->saunam;
          rsp2read(namtmp,STGLEN,"done");
     }
}

STATIC int
gotsrch(void)                      /* gets next search element             */
{
     int rv=0,i;
     BOOL vdamoved=FALSE;
     char klist[FLKEYLST],*s;

     if (flo->keymeth == 2 || (flo->keymeth == 4 && flo->styp == 6)) {
          movmem(vdaptr,vdatmp,vdasiz);
          vdamoved=TRUE;
          stzcpy(klist,flo->cskwds,FLKEYLST);
          for (i=0,s=firstwd(klist) ; i < flo->kcount ; i++,s=nextwd()) {
               stzcpy(&vdaptr[i*FLKEYSIZ],s,FLKEYSIZ);
          }
     }
     if (srcnext()) {
          rv=srcgood();
          if (rv != 0) {
               srcukey();
               if (vdamoved) {
                    movmem(vdatmp,vdaptr,vdasiz);
                    vdamoved=FALSE;
               }
               switch (flo->keymeth) {
               case 0:
                    stzcpy(srchptr->filname,flo->u.key0.filname,FLFILENM);
                    stzcpy(srchptr->other,flo->u.key0.udate,DATESZ);
                    if (flo->miscflag != 0 && !notapped(flo->u.key0.udate)) {
                         i=cofdat(dcdate(srt2dat(flo->u.key0.udate)));
                         if (flo->miscflag < 0
                            || cofdat(today()) - i > flo->miscflag) {
                              rv=0;
                         }
                    }
                    break;
               case 3:
                    stzcpy(srchptr->libname,flo->u.key3.libkey,FLNAMESZ);
                    stzcpy(srchptr->filname,flo->u.key3.filname,FLFILENM);
                    stzcpy(srchptr->other,flo->u.key3.udate,DATESZ);
                    if (flo->miscflag != 0 && !notapped(flo->u.key3.udate)) {
                         i=cofdat(dcdate(srt2dat(flo->u.key3.udate)));
                         if (flo->miscflag < 0
                            || cofdat(today()) - i > flo->miscflag) {
                              rv=0;
                         }
                    }
                    break;
               case 5:
                    stzcpy(srchptr->libname,flo->u.key5.libkey,FLNAMESZ);
                    stzcpy(srchptr->filname,flo->u.key5.filname,FLFILENM);
                    stzcpy(srchptr->other,flo->u.key5.numdls,NUMSZ);
                    break;
               case 1:
               case 6:
                    stzcpy(srchptr->filname,flo->u.key1.filname,FLFILENM);
                    break;
               case 2:
                    stzcpy(srchptr->libname,flo->u.key2.libkey,FLNAMESZ);
                    stzcpy(srchptr->filname,flo->u.key2.filname,FLFILENM);
                    stzcpy(srchptr->other,flo->u.key2.keyword,FLKEYSIZ);
                    break;
               case 4:
               case 7:
                    stzcpy(srchptr->libname,flo->u.key4.libkey,FLNAMESZ);
                    stzcpy(srchptr->filname,flo->u.key4.filname,FLFILENM);
                    break;
               }
          }
     }
     if (vdamoved) {
          movmem(vdatmp,vdaptr,vdasiz);
     }
     return(rv);
}

STATIC void
cycsrch(void)                      /* cycle search read request            */
{
     int result;

     fluoff(usrnum);
     if (!(flo->flags&CONTEXT)) {
          rejectreq();
          return;
     }
     flo->flags&=~(REVSRCH|NXTEQUL);
     flo->flags|=(rqdptr->direction < 0) ? REVSRCH : 0L;
     switch (flo->keymeth) {
     case 0:
          stzcpy(flo->u.key0.libname,flo->lrange,FLNAMESZ);
          stzcpy(flo->u.key0.filname,srchptr->filname,FLFILENM);
          stzcpy(flo->u.key0.udate,srchptr->other,DATESZ);
          break;
     case 3:
          stzcpy(flo->u.key3.libkey,srchptr->libname,FLNAMESZ);
          stzcpy(flo->u.key3.filname,srchptr->filname,FLFILENM);
          stzcpy(flo->u.key3.udate,srchptr->other,DATESZ);
          stzcpy(flo->u.key3.libname,flo->lrange,FLNAMESZ);
          break;
     case 5:
          flo->flags&=~REVSRCH;
          flo->flags|=(rqdptr->direction > 0) ? REVSRCH : 0L;
          stzcpy(flo->u.key5.libkey,srchptr->libname,FLNAMESZ);
          stzcpy(flo->u.key5.filname,srchptr->filname,FLFILENM);
          stzcpy(flo->u.key5.numdls,srchptr->other,NUMSZ);
          stzcpy(flo->u.key5.libname,flo->lrange,FLNAMESZ);
          break;
     case 1:
     case 6:
          stzcpy(flo->u.key1.filname,srchptr->filname,FLFILENM);
          stzcpy(flo->u.key1.libname,flo->lrange,FLNAMESZ);
          break;
     case 2:
          stzcpy(flo->u.key2.libkey,srchptr->libname,FLNAMESZ);
          stzcpy(flo->u.key2.filname,srchptr->filname,FLFILENM);
          stzcpy(flo->u.key2.keyword,srchptr->other,FLKEYSIZ);
          break;
     case 7:
     case 4:
          stzcpy(flo->u.key4.libkey,srchptr->libname,FLNAMESZ);
          stzcpy(flo->u.key4.filname,srchptr->filname,FLFILENM);
          stzcpy(flo->u.key4.libname,flo->lrange,FLNAMESZ);
          break;
     }
     if ((result=gotsrch()) != -1) {
          if (result == 1) {
               *namtmp=rqdptr->saunam;
               updsuff(namtmp->suffix);
               fsdpkr=flfrsp(FALSE,FALSE);
               rsp2read(namtmp,
                  sizeof(struct fsdpk)-(UIDSIZ+DESCSIZ)+strlen(fsdpkr->data),
                  fsdpkr);
          }
          else {
               rejectreq();
          }
     }
}

STATIC void
updsuff(                           /* update passed suffix from flf pointer*/
char *suffix)
{
     char *s;

     s=skpwht(skpwrd(suffix));
     switch (flo->keymeth) {
     case 0:
     case 3:
          sprintf(s,"%s %s %s",
             flf->udate[0] != '\0' ? flf->udate : NOTAPPED,
             flf->filname,
             flf->libname);
          break;
     case 5:
          sprintf(s,"%07ld %s %s",
             atol(flf->numdls),
             flf->libname,
             flf->filname);
          break;
     case 4:
          if (flo->styp != 6) {
               sprintf(s,"%s %s",
                  flf->filname,
                  flf->libname);
               break;
          }
     case 2:
          sprintf(s,"%s %s %s",
             flo->keymeth == 2 ? flo->u.key2.keyword : "-",
             flf->filname,
             flf->libname);
          break;
     case 1:
     case 6:
     case 7:
          sprintf(s,"%s %s",
             flf->filname,
             flf->libname);
          break;
     }
}

STATIC struct fsdpk *
flfrsp(                            /* builds response from file data       */
BOOL isdos,                        /*   is Library involved, DOS-Only?     */
BOOL verbose)                      /*   w/ or w/o uploader & full desc.    */
{
     struct fsdpk *rs;
     struct fllib *libptr;
     int loop;
     char *ext;

     rs=(struct fsdpk *)rsptmp;
     setmem(rs,sizeof(struct fsdpk),0);
     if (isdos) {
          if ((libptr=libfind(flo->lrange)) == NULL) {
               return(rs);
          }
          if (isflop(libptr)) {
               rs->flags|=FSDLIBOP;
          }
          if (libptr->flags&FLGDOS) {
               rs->flags|=FSDISDOS;
          }
          if (!(libptr->flags&FLGCBD)
             && (ext=strchr(flo->fb.name,'.')) != NULL) {
               ext++;
               switch (viewmode(ext)) {
               case CMPVIEW:
                    rs->flags|=FSDCVIEW;
                    break;
               case LSTVIEW:
               case ANSVIEW:
                    rs->flags|=FSDTVIEW;
                    break;
               }
          }
          rs->cost=libptr != NULL ? dnlprc(flo->fb.size,libptr) : 0L;
          rs->size=flo->fb.size;
          rs->dltime=atoi(dnlmin(rs->size));
          rs->filedt=d2vdat(flo->fb.date,flo->fb.time);
          rs->addedt=0.0;
          rs->numdls=0L;
          rs->data[0]='\0';
     }
     else {
          if ((libptr=libfind(flf->libname)) == NULL) {
               return(rs);
          }
          stzcpy(descedit,flf->desc,DESCSIZ);
          stpans(descedit);
          darsdesc(NDESCLN,'\r');
          if (isflop(libptr)) {
               rs->flags|=FSDLIBOP;
          }
          if (!(libptr->flags&FLGCBD)
             && (ext=strchr(flf->filname,'.')) != NULL) {
               ext++;
               switch (viewmode(ext)) {
               case CMPVIEW:
                    rs->flags|=FSDCVIEW;
                    break;
               case LSTVIEW:
               case ANSVIEW:
                    rs->flags|=FSDTVIEW;
                    break;
               }
          }
          rs->cost=libptr != NULL ? dnlprc(flf->siz,libptr) : 0L;
          rs->size=flf->siz;
          rs->dltime=atoi(dnlmin(rs->size));
          rs->filedt=d2vdat(dcdate(srt2dat(flf->fdate)),flf->tim);
          rs->addedt=notapped(flf->udate) ? 0.0 :
             d2vdat(dcdate(srt2dat(flf->udate)),flf->utime);
          rs->numdls=atol(flf->numdls);
          if (verbose) {
               stzcpy(rs->data,flf->ulby,UIDSIZ);
               strcat(rs->data,"\t");
               for (loop=0 ; loop < NDESCLN ; loop++) {
                    if (dargv[loop][0] != '\0') {
                         strcat(rs->data,dargv[loop]);
                         strcat(rs->data,"\r");
                    }
               }
          }
          else {
               strcpy(rs->data,dargv[0]);
          }
     }
     return(rs);
}

STATIC void
filibaxs(
int direction)
{
     char *s;
     int i;

     if ((i=findaxs(direction,skpwht(s=skpwrd(namtmp->suffix)))) == -1) {
          rejectreq();
          return;
     }
     sprintf(rsptmp,"%d",i);
     if (direction != 0) {
          sprintf(s," %s",curlib->libname);
     }
     rsp2read(namtmp,STGLEN,rsptmp);
}

STATIC void
fillist(
int direction)
{
     char *s;

     if ((curlib=dirlib(direction,
                             skpwht(s=skpwrd(namtmp->suffix)),TRUE)) == NULL) {
          rejectreq();
          return;
     }
     lli->numfiles=atol(tvfnum());
     lli->flags=(curlib->flags&FLGDOS) ? LLISDOS : 0;
     if (haslibkey(curlib,curlib->ulkey) && writable(curlib)) {
          lli->flags|=LLISUPL;
     }
     if (isflop(curlib)) {
          lli->flags|=LLISLOP;
     }
     if (curlib->flags&FLGCBD) {
          lli->flags|=LLISACD;
     }
     if (curlib->flags&FLGHID) {
          lli->flags|=LLISHID;
     }
     stzcpy(lli->desc,curlib->libdesc,FLDESCSZ);
     if (direction != 0) {
          sprintf(s," %s",curlib->libname);
     }
     rsp2read(namtmp,sizeof(struct llistinf)-FLDESCSZ+strlen(lli->desc),lli);
}

STATIC void
filunaps(
int direction)
{
     char *s;

     if ((curlib=dirlib(direction,
                             skpwht(s=skpwrd(namtmp->suffix)),TRUE)) == NULL) {
          rejectreq();
          return;
     }
     while ((curlib->flags&FLGDOS) != 0L
        || curlib->appwait == 0
        || !isflop(curlib)) {
          if (direction == 0
                  || (curlib=dirlib(direction,curlib->libname,TRUE)) == NULL) {
               rejectreq();
               return;
          }
     }
     sprintf(rsptmp,"%d",curlib->appwait);
     if (direction != 0) {
          sprintf(s," %s",curlib->libname);
     }
     rsp2read(namtmp,STGLEN,rsptmp);
}

STATIC void
filinfo(
int direction)
{
     char *s;
     int i;

     if ((curlib=dirlib(direction,
                             skpwht(s=skpwrd(namtmp->suffix)),TRUE)) == NULL) {
          rejectreq();
          return;
     }
     setmem(xli,sizeof(struct xlibinfo),0);
     xli->totfiles=atol(tvfnum());
     xli->addtoday=curlib->newfiles[0];
     xli->addweek=0;
     for (i=0 ; i < ULDAYS ; i++) {
          xli->addweek+=curlib->newfiles[i];
     }
     xli->maxfil=atol(tvfilt());
     xli->maxbyt=atol(tvbytt());
     xli->maxbup=atol(tvbytu());
     strcpy(xli->data,curlib->libdesc);
     strcat(xli->data,"\t");
     loadldsc(NULL);
     for (i=0 ; i < NLDLIN ; i++) {
          strcat(xli->data,libupd->ldesc[i]);
          strcat(xli->data,"\r");
     }
     strcat(xli->data,"\t");
     strcat(xli->data,curlib->primary[0] == '\0' ? "Sysop" : curlib->primary);
     if (direction != 0) {
          sprintf(s," %s",curlib->libname);
     }
     rsp2read(namtmp,sizeof(struct xlibinfo)-XLDATLEN+strlen(xli->data),xli);
}

STATIC void
filjoin(                           /* joined Library read handler          */
int direction)                     /*   with directional support           */
{
     char *s,*sptr,lib1[FLNAMESZ],lib2[FLNAMESZ];
     struct fllib *libptr;

     sptr=skpwht(s=skpwrd(namtmp->suffix));
     stzcpy(lib1,firstwd(sptr),FLNAMESZ);
     stzcpy(lib2,firstwd(skpwht(skpwrd(sptr))),FLNAMESZ);
     do {
          if ((libptr=dirlib(0,lib1,TRUE)) != NULL) {
               if ((libptr->flags&FLGDOS)
                  || (curlib=dirlib(direction,lib2,TRUE)) == NULL) {
                    libptr=NULL;
               }
               else {
                    stzcpy(lib2,curlib->libname,FLNAMESZ);
                    if (libptr != curlib && !(curlib->flags&FLGDOS)) {
                         sprintf(rsptmp,"%d\t%s",
                           chjoined(curlib,libptr->libname) ? 1 : 0,
                           curlib->libdesc);
                         if (direction != 0) {
                              sprintf(s," %s %s",libptr->libname,curlib->libname);
                         }
                         rsp2read(namtmp,STGLEN,rsptmp);
                         return;
                    }
               }
          }
          if (libptr == NULL) {
               if ((libptr=dirlib(direction,lib1,TRUE)) != NULL) {
                    stzcpy(lib1,libptr->libname,FLNAMESZ);
                    setmem(lib2,FLNAMESZ,0);
                    if (direction < 0) {
                         setmem(lib2,FLNAMESZ-1,0xFF);
                    }
               }
               else {
                    break;
               }
          }
     } while (direction != 0);
     rejectreq();
}

STATIC void
filibedt(
int direction)
{
     char *s;

     setbtv(flldat);
     if ((curlib=dirlib(direction,
                                skpwht(s=skpwrd(namtmp->suffix)),TRUE)) == NULL
        || !acqbtv(libupd,curlib->libname,0)) {
          rejectreq();
          return;
     }
     setmem(eli,sizeof(struct libcsed),0);
     if (curlib->flags&FLGDOS) {
          eli->flags|=ELIDOS;
     }
     if (curlib->flags&FLGRDO) {
          eli->flags|=ELIRON;
     }
     if (curlib->flags&FLGHID) {
          eli->flags|=ELIHID;
     }
     if (curlib->flags&FLGCBD) {
          eli->flags|=ELISCD;
     }
     if ((curlib->flags&FLGADL) || auditall) {
          eli->flags|=ELIADD;
     }
     if ((curlib->flags&FLGAUL) || auditall) {
          eli->flags|=ELIADU;
     }
     if (auditall) {
          eli->flags|=ELIAUD;
     }
     if ((curlib->flags&FLGFUL) || freeuls) {
          eli->flags|=ELINCU;
     }
     if (freeuls) {
          eli->flags|=ELIFUD;
     }
     if (curlib->flags&FLGFDL) {
          eli->flags|=ELINCD;
     }
     eli->created=d2vdat(curlib->day,curlib->time);
     eli->dlchge=curlib->dlchge;
     eli->kdlchge=curlib->kdlchge;
     eli->royal=curlib->royal;
     eli->maxfil=curlib->maxfil;
     eli->maxbyt=curlib->maxbyt;
     eli->maxbup=curlib->maxbup;
     sprintf(eli->data,
        "%s\t%s\t%s\r%s\r%s\r%s\r%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s",
        curlib->path,
        curlib->libdesc,
        libupd->ldesc[0],
        libupd->ldesc[1],
        libupd->ldesc[2],
        libupd->ldesc[3],
        libupd->ldesc[4],
        curlib->keyreq,
        curlib->libop,
        curlib->autoap,
        curlib->dlkey,
        curlib->ulkey,
        curlib->overw,
        curlib->primary);
     if (direction != 0) {
          sprintf(s," %s",curlib->libname);
     }
     rsp2read(namtmp,sizeof(struct libcsed)-XLDATLEN+strlen(eli->data),eli);
}

STATIC void
filjoins(                          /* Library joinings read handler        */
int direction)                     /*   with directional support           */
{
     int i;
     char *s,*libname;
     struct fllib *libptr;

     libname=skpwht(s=skpwrd(namtmp->suffix));
     do {
          if ((curlib=dirlib(direction,libname,FALSE)) == NULL
             || (direction == 0 && curlib->cat[0][0] == '\0')) {
               rejectreq();
               return;
          }
          libname=curlib->libname;
     } while (curlib->cat[0][0] == '\0');
     rsptmp[0]='\0';
     for (i=0 ; i < FLNMCATS ; i++) {
          if (curlib->cat[i][0] != '\0') {
               libptr=libfind(curlib->cat[i]);
               if (libptr != NULL && haslibkey(libptr,libptr->keyreq)) {
                    strcat(rsptmp,curlib->cat[i]);
                    strcat(rsptmp,"\t");
               }
          }
          else {
               break;
          }
     }
     if (direction != 0) {
          sprintf(s," %s",curlib->libname);
     }
     if ((i=strlen(rsptmp)-1) >= 0 && rsptmp[i] == '\t') {
          rsptmp[i]='\0';
     }
     rsp2read(namtmp,STGLEN,rsptmp);
}

STATIC void
wfiljoin(                          /* join a Library to another            */
BOOL join)                         /*   whether to join the Libraries      */
{                                  /*    as opposed to unjoin              */
     char *sptr;
     BOOL done;
     struct fllib *lib1,*lib2;

     lib1=libfind(firstwd(sptr=skpwht(skpwrd(namtmp->suffix))));
     lib2=libfind(firstwd(skpwht(skpwrd(sptr))));
     if (lib1 != lib2 && lib1 != NULL && lib2 != NULL
        && !(lib1->flags&FLGDOS) && !(lib2->flags&FLGDOS)) {
          done=chjoin(lib1,lib2,!join) ? TRUE : FALSE;
          if (done) {
               newjoins=TRUE;
          }
          rsp2write(done,0,NULL);
     }
     else {
          rejectreq();
     }
}

STATIC void
delalib(                           /* delete Library                       */
struct fllib *libptr)              /*   library pointer to delete          */
{
     if (othrsin(libptr->libname)) {
          prfmsg(LIBNODEL,othuap->userid);
     }
     else if ((othusn=w2writ(libptr->libname,"*",2)) != NOCONFLICT) {
          prfmsg(LIBNODEL,uacoff(othusn)->userid);
     }
     else if (sameas(libptr->libname,deflname)) {
          prfmsg(CANTDEFL);
     }
     else {
          dlqptr->phase=0;
          stzcpy(dlqptr->libname,libptr->libname,FLNAMESZ);
          untagall(libptr->libname,"");
          setmem(libptr,sizeof(struct fllib),0);
          sortlibs();
          scanlibs();
          donewrit(2);
          cycleme(dlibrou);
          sendres(spr("Deleting file records in %s Library:",
             dlqptr->libname));
          return;
     }
     r2wprf(FALSE);
}

STATIC void
dlibrou(void)                      /* cycleme() routine for lib deletion   */
{                                  /*   calls generic cycdelib()           */
     fluoff(usrnum);
     if (!cycdelib(&dlqptr->phase,dlqptr->libname,dlqptr->filname)) {
          rsp2write(TRUE,0,"");
     }
     else if (dlqptr->phase == 0) {
          sendres(spr("%s\\%s",dlqptr->libname,dlqptr->filname));
     }
}

STATIC void
libedup(                           /* create/update a Library              */
char *libname,
struct fllib *libptr)              /*   pointer to existing lib            */
{
     BOOL create;
     char *s,*e;
     int i;

     create=(libptr == NULL);
     if (!create) {
          libptr->flags&=~(LIBCHN|LIBONG);
          movmem(libptr,curlib,sizeof(struct fllib));
     }
     curlib->flags&=~(FLGRDO|FLGHID|FLGFDL|FLGCBD);
     if (create) {
          if (eli->flags&ELIDOS) {
               curlib->flags|=FLGDOS;
          }
          curlib->day=v2ddat(eli->created);
          curlib->time=v2dtim(eli->created);
          stzcpy(curlib->libname,libname,FLNAMESZ);
     }
     if (!auditall) {
          curlib->flags&=~(FLGAUL|FLGADL);
          if (eli->flags&ELIADD) {
               curlib->flags|=FLGADL;
          }
          if (eli->flags&ELIADU) {
               curlib->flags|=FLGAUL;
          }
     }
     if (!freeuls) {
          if (eli->flags&ELINCU) {
               curlib->flags|=FLGFUL;
          }
          else {
               curlib->flags&=~FLGFUL;
          }
     }
     if (eli->flags&ELIRON) {
          curlib->flags|=FLGRDO;
     }
     if (eli->flags&ELIHID) {
          curlib->flags|=FLGHID;
     }
     if (eli->flags&ELINCD) {
          curlib->flags|=FLGFDL;
     }
     if (eli->flags&ELISCD) {
          curlib->flags|=FLGCBD;
     }
     if (valpath(s=itemidx(eli->data,0))) {
          stzcpy(curlib->path,strupr(checkdir(s)),PATHSIZE);
     }
     stzcpy(curlib->libdesc,itemidx(eli->data,1),FLDESCSZ);
     s=itemidx(eli->data,2);
     for (i=0 ; i < NLDLIN ; i++) {
          if ((e=strchr(s,13)) == NULL) {
               e=&s[strlen(s)];
          }
          else {
               do {
                    *e++='\0';
               } while (*e == 0x0A);
          }
          stzcpy(libupd->ldesc[i],s,FLLDESCS);
          if (libupd->ldesc[i][0] == '\0' && *e != '\0') {
               i--;
          }
          s=e;
     }
     stzcpy(curlib->keyreq,itemidx(eli->data,3),KEYSIZ);
     stzcpy(curlib->libop,itemidx(eli->data,4),KEYSIZ);
     stzcpy(curlib->autoap,itemidx(eli->data,5),KEYSIZ);
     stzcpy(curlib->dlkey,itemidx(eli->data,6),KEYSIZ);
     stzcpy(curlib->ulkey,itemidx(eli->data,7),KEYSIZ);
     stzcpy(curlib->overw,itemidx(eli->data,8),KEYSIZ);
     setbtv(accbb);
     if (acqbtv(&acctmp,itemidx(eli->data,9),0)) {
          stzcpy(curlib->primary,acctmp.userid,UIDSIZ);
     }
     rstbtv();
     i=eli->royal;
     if (i >= 0 && i <= 100) {
          curlib->royal=i;
     }
     if (eli->dlchge >= -999999999L && eli->dlchge <= 999999999L) {
          curlib->dlchge=eli->dlchge;
     }
     if (eli->kdlchge >= -999999999L && eli->kdlchge <= 999999999L) {
          curlib->kdlchge=eli->kdlchge;
     }
     if (eli->maxfil >= 0L && eli->maxfil <= 999999999L) {
          curlib->maxfil=eli->maxfil;
     }
     if (eli->maxbyt >= 0L && eli->maxbyt <= 999999999L) {
          curlib->maxbyt=eli->maxbyt;
     }
     if (eli->maxbup >= 0L && eli->maxbup <= 999999999L) {
          curlib->maxbup=eli->maxbup;
     }
     savelib(libupd);
     rsp2write(TRUE,0,"");
}

void
sendres(                           /* send operation note via unsol. dpk   */
char *restg)                       /*   string to send                     */
{
     struct saunam unsol;

     if (qroom(usrnum,NORMAL) && cnvd2s("sa:results",&unsol)) {
          senddpk(usrnum,"GALFIL",NORMAL,&unsol,STGLEN,restg);
     }
}

STATIC void
reqcono(                           /* request context: DOS-Only Library    */
char *value)
{
     struct fllib *libptr;

     value=firstwd(value);
     clrprf();
     if ((libptr=libfind(value)) == NULL
         || !haslibkey(libptr,libptr->keyreq)) {
          prfmsg(LIBNOEXT);
          flo->flags&=~CONTEXT;
          r2wprf(FALSE);
     }
     else if (!(libptr->flags&FLGDOS)) {
          prfmsg(CONNODOS,value);
          flo->flags&=~CONTEXT;
          r2wprf(FALSE);
     }
     else {
          stzcpy(flo->lrange,libptr->libname,FLNAMESZ);
          setmem(&flo->u,sizeof(union combo),0);
          flo->csidx=0L;
          rsp2write(TRUE,0,"");
     }
}

STATIC void
reqconn(                           /* request context: # of D/Ls           */
char *value)
{
     struct fllib *libptr;

     value=firstwd(value);
     clrprf();
     if (value[0] != '*') {
          if ((libptr=libfind(value)) == NULL
              || !haslibkey(libptr,libptr->keyreq)) {
               prfmsg(LIBNOEXT);
               flo->flags&=~CONTEXT;
               r2wprf(FALSE);
               return;
          }
          stzcpy(flo->lrange,libptr->libname,FLNAMESZ);
     }
     else {
          stzcpy(flo->lrange,"",FLNAMESZ);
     }
     setmem(&flo->u,sizeof(union combo),0);
     stzcpy(flo->u.key5.libname,flo->lrange,FLNAMESZ);
     flo->keymeth=5;
     srcoff();
     srcu->nlibs=0;
     rsp2write(TRUE,0,"");
}

STATIC void
reqcond(                           /* request context: date search         */
char *value)
{
     char *s;
     struct fllib *libptr;

     s=itemidx(value,1);
     clrprf();
     setmem(&flo->u,sizeof(union combo),0);
     if (s[0] != '*') {
          if ((libptr=libfind(s)) == NULL
              || !haslibkey(libptr,libptr->keyreq)) {
               prfmsg(LIBNOEXT);
               flo->flags&=~CONTEXT;
               r2wprf(FALSE);
               return;
          }
          else if (libptr->flags&FLGDOS) {
               prfmsg(CONISDOS,s);
               flo->flags&=~CONTEXT;
               r2wprf(FALSE);
               return;
          }
          stzcpy(flo->lrange,libptr->libname,FLNAMESZ);
          if (scanlib(1,libptr)) {
               flo->keymeth=3;
          }
          else {
               flo->keymeth=0;
          }
          scanlib(0,libptr);
     }
     else {
          stzcpy(flo->lrange,"",FLNAMESZ);
          flo->keymeth=3;
     }
     srcoff();
     srcu->nlibs=0;
     flo->flags&=~DATESRC;
     if (sameas(s=itemidx(value,0),"Q")) {
          flo->flags|=DATESRC;
          stzcpy(flu->newdate,dat2srt(ncdate(today())),DATESZ);
     }
     else if (sameas(s,"U")) {
          flo->miscflag=-1; /* unapproved files only */
     }
     else {
          flo->miscflag=atoi(s);
     }
     rsp2write(TRUE,0,"");
}

STATIC void
reqconf(                           /* request context: filename search     */
char *value)
{
     char *s;
     struct fllib *libptr;

     flo->styp=0;
     s=itemidx(value,1);
     clrprf();
     setmem(&flo->u,sizeof(union combo),0);
     if (s[0] != '*') {
          if ((libptr=libfind(s)) == NULL
              || !haslibkey(libptr,libptr->keyreq)) {
               prfmsg(LIBNOEXT);
               flo->flags&=~CONTEXT;
               r2wprf(FALSE);
               return;
          }
          else if (libptr->flags&FLGDOS) {
               prfmsg(CONISDOS,value);
               flo->flags&=~CONTEXT;
               r2wprf(FALSE);
               return;
          }
          stzcpy(flo->lrange,libptr->libname,FLNAMESZ);
          if (scanlib(1,libptr)) {
               flo->keymeth=7;
          }
          else {
               flo->keymeth=6;
          }
          scanlib(0,libptr);
     }
     else {
          stzcpy(flo->lrange,"",FLNAMESZ);
          flo->keymeth=7;
     }
     srcoff();
     srcu->nlibs=0;
     if (sameas(s=itemidx(value,0),"*.*") || s[0] == '\0') {
          switch (flo->keymeth) {
          case 6:
               flo->keymeth=1;
               break;
          case 7:
               flo->keymeth=4;
               break;
          }
     }
     else {
          stzcpy(flo->miscfil,s,FLFILENM);
     }
     rsp2write(TRUE,0,"");
}

STATIC void
reqconk(                           /* request context: keyword search      */
char *value)
{
     struct fllib *libptr;
     char *s;
     int i;

     stzcpy(flo->cskwds,itemidx(value,0),FLKEYLST);
     movmem(vdaptr,vdatmp,vdasiz);
     flo->styp=4;
     clrprf();
     if (!parsrch(flo->cskwds)) {
          if (prfptr == prfbuf) {
               prfmsg(CONNOKWD);
          }
          flo->flags&=~CONTEXT;
          movmem(vdatmp,vdaptr,vdasiz);
          r2wprf(FALSE);
          return;
     }
     flo->cskwds[0]='\0';
     for (i=0 ; i < flo->kcount ; i++) {
          stzcat(flo->cskwds,spr("%s ",&vdaptr[i*FLKEYSIZ]),FLKEYLST);
     }
     if ((i=strlen(flo->cskwds)) > 0 && *(s=&flo->cskwds[i-1]) == ' ') {
          *s='\0';
     }
     movmem(vdatmp,vdaptr,vdasiz);
     setmem(&flo->u,sizeof(union combo),0);
     clrprf();
     s=itemidx(value,1);
     if (s[0] != '*') {
          if ((libptr=libfind(s)) == NULL
              || !haslibkey(libptr,libptr->keyreq)) {
               prfmsg(LIBNOEXT);
               flo->flags&=~CONTEXT;
               r2wprf(FALSE);
               return;
          }
          else if (libptr->flags&FLGDOS) {
               prfmsg(CONISDOS,value);
               flo->flags&=~CONTEXT;
               r2wprf(FALSE);
               return;
          }
          stzcpy(flo->lrange,libptr->libname,FLNAMESZ);
          switch (flo->styp) {
          case 4:
               flo->keymeth=2;
               stzcpy(flo->u.key2.keyword,firstwd(flo->cskwds),FLKEYSIZ);
               stzcpy(flo->u.key2.origkey,firstwd(flo->cskwds),FLKEYSIZ);
               break;
          case 6:
               flo->keymeth=4;
               break;
          }
     }
     else {
          stzcpy(flo->lrange,"",FLNAMESZ);
          switch (flo->styp) {
          case 4:
               flo->keymeth=2;
               stzcpy(flo->u.key2.keyword,firstwd(flo->cskwds),FLKEYSIZ);
               stzcpy(flo->u.key2.origkey,firstwd(flo->cskwds),FLKEYSIZ);
               break;
          case 6:
               flo->keymeth=4;
               break;
          }
     }
     srcoff();
     srcu->nlibs=0;
     rsp2write(TRUE,0,"");
}

STATIC void
searcho(                           /* search/list DOS-Only Lib             */
char *nam,
int direction)
{
     struct fllib *libptr;
     int cont;

     if (direction <= 0 || (libptr=libfind(flo->lrange)) == NULL) {
          rejectreq();
          return;
     }
     if (flo->csidx == 0L) {
          cont=fnd1st(&flo->fb,spr("%s\\*.*",libpath(libptr)),0);
     }
     else {
          cont=fndnxt(&flo->fb);
     }
     if (cont) {
          sprintf(rsptmp,"%s\t%s\t%ld\t%ld\t%lf",
             flo->fb.name,
             flo->lrange,
             dnlprc(flo->fb.size,libptr),
             flo->fb.size,
             d2vdat(flo->fb.date,flo->fb.time));
          sprintf(nam,"%05lX %s %s",
             flo->csidx++,libptr->libname,flo->fb.name);
          fsdpkr=flfrsp(TRUE,FALSE);
          rsp2read(namtmp,
            sizeof(struct fsdpk)-(UIDSIZ+DESCSIZ)+strlen(fsdpkr->data),fsdpkr);
     }
     else {
          rejectreq();
     }
}

STATIC void
searchn(                           /* search/list on # of D/Ls             */
char *nam,
int direction)
{
     int result;
     long l;
     char *s;

     if (flo->keymeth != 5) {
          rejectreq();
          return;
     }
     flo->flags&=~NXTEQUL;
     if (direction > 0) {
          flo->flags|=REVSRCH;
     }
     else {
          flo->flags&=~REVSRCH;
     }
     l=atol(s=firstwd(nam));
     if (l == 0L && stricmp(s,"9999999") > 0) {
          stzcpy(flo->u.key5.numdls,s,NUMSZ);
     }
     else {
          stzcpy(flo->u.key5.numdls,spr("%07ld",l),NUMSZ);
     }
     s=nextwd();
     stzcpy(flo->u.key5.libkey,s,FLNAMESZ);
     s=nextwd();
     stzcpy(flo->u.key5.filname,s,FLFILENM);
     stzcpy(flo->u.key5.libname,flo->lrange,FLNAMESZ);
     if ((result=gotsrch()) != -1) {
          if (result != 0) {
               updsuff(namtmp->suffix);
               fsdpkr=flfrsp(FALSE,FALSE);
               rsp2read(namtmp,
                  sizeof(struct fsdpk)-(UIDSIZ+DESCSIZ)+strlen(fsdpkr->data),
                  fsdpkr);
          }
          else {
               rejectreq();
          }
     }
     else {
          stzcpy(srchptr->libname,flo->u.key5.libkey,FLNAMESZ);
          stzcpy(srchptr->filname,flo->u.key5.filname,FLFILENM);
          stzcpy(srchptr->other,flo->u.key5.numdls,NUMSZ);
          cycleme(cycsrch);
     }
}

STATIC void
searchd(                           /* search/list on date added            */
char *nam,
int direction)
{
     int result;
     char *s;

     s=firstwd(nam);
     switch (flo->keymeth) {
     case 0:
          stzcpy(flo->u.key0.udate,s,DATESZ);
          s=nextwd();
          stzcpy(flo->u.key0.filname,s,FLFILENM);
          s=nextwd();
          stzcpy(flo->u.key0.libname,flo->lrange,FLNAMESZ);
          break;
     case 3:
          stzcpy(flo->u.key3.udate,s,DATESZ);
          s=nextwd();
          stzcpy(flo->u.key3.filname,s,FLFILENM);
          s=nextwd();
          stzcpy(flo->u.key3.libkey,s,FLNAMESZ);
          stzcpy(flo->u.key3.libname,flo->lrange,FLNAMESZ);
          break;
     default:
          rejectreq();
          return;
     }
     flo->flags&=~NXTEQUL;
     if (direction > 0) {
          flo->flags&=~REVSRCH;
     }
     else {
          flo->flags|=REVSRCH;
     }
     if ((result=gotsrch()) != -1) {
          if (result != 0) {
               updsuff(namtmp->suffix);
               fsdpkr=flfrsp(FALSE,FALSE);
               rsp2read(namtmp,
                  sizeof(struct fsdpk)-(UIDSIZ+DESCSIZ)+strlen(fsdpkr->data),
                  fsdpkr);
          }
          else {
               rejectreq();
          }
     }
     else {
          switch (flo->keymeth) {
          case 0:
               stzcpy(srchptr->filname,flo->u.key0.filname,FLFILENM);
               stzcpy(srchptr->other,flo->u.key0.udate,DATESZ);
               break;
          case 3:
               stzcpy(srchptr->libname,flo->u.key3.libkey,FLNAMESZ);
               stzcpy(srchptr->filname,flo->u.key3.filname,FLFILENM);
               stzcpy(srchptr->other,flo->u.key3.udate,DATESZ);
               break;
          }
          cycleme(cycsrch);
     }
}

STATIC void
searchf(                           /* search/list on filename              */
char *nam,
int direction)
{
     int result;
     char *s;

     s=firstwd(nam);
     switch (flo->keymeth) {
     case 6:
          if (*s == '\0') {
               wldstuff(flo->u.key1.filname);
               s=NULL;
          }
     case 1:
          if (s != NULL) {
               stzcpy(flo->u.key1.filname,s,FLFILENM);
          }
          stzcpy(flo->u.key1.libname,flo->lrange,FLNAMESZ);
          break;
     case 7:
          if (*s == '\0') {
               wldstuff(flo->u.key4.filname);
               s=NULL;
          }
     case 4:
          if (s != NULL) {
               stzcpy(flo->u.key4.filname,s,FLFILENM);
          }
          s=nextwd();
          stzcpy(flo->u.key4.libkey,s,FLNAMESZ);
          stzcpy(flo->u.key4.libname,flo->lrange,FLNAMESZ);
          break;
     default:
          rejectreq();
          return;
     }
     flo->flags&=~NXTEQUL;
     if (direction > 0) {
          flo->flags&=~REVSRCH;
     }
     else {
          flo->flags|=REVSRCH;
     }
     if ((result=gotsrch()) != -1) {
          if (result != 0) {
               updsuff(namtmp->suffix);
               fsdpkr=flfrsp(FALSE,FALSE);
               rsp2read(namtmp,
                  sizeof(struct fsdpk)-(UIDSIZ+DESCSIZ)+strlen(fsdpkr->data),
                  fsdpkr);
          }
          else {
               rejectreq();
          }
     }
     else {
          switch (flo->keymeth) {
          case 1:
          case 6:
               stzcpy(srchptr->filname,flo->u.key1.filname,FLFILENM);
               break;
          case 4:
          case 7:
               stzcpy(srchptr->libname,flo->u.key4.libkey,FLNAMESZ);
               stzcpy(srchptr->filname,flo->u.key4.filname,FLFILENM);
               break;
          }
          cycleme(cycsrch);
     }
}

STATIC void
searchk(                           /* search/list on keyword               */
char *nam,
int direction)
{
     int result;
     char *s;

     s=firstwd(nam);
     switch (flo->keymeth) {
     case 2:
          if (*s == '\0' || sameas(s,"-")) {
               stzcpy(flo->u.key2.keyword,flo->u.key2.origkey,FLKEYSIZ);
          }
          else {
               stzcpy(flo->u.key2.keyword,s,FLKEYSIZ);
          }
          s=nextwd();
          stzcpy(flo->u.key2.filname,s,FLFILENM);
          s=nextwd();
          stzcpy(flo->u.key2.libkey,s,FLNAMESZ);
          stzcpy(flo->u.key2.libname,flo->lrange,FLNAMESZ);
          break;
     case 4:
          s=nextwd();
          stzcpy(flo->u.key4.filname,s,FLFILENM);
          s=nextwd();
          stzcpy(flo->u.key4.libkey,s,FLNAMESZ);
          stzcpy(flo->u.key4.libname,flo->lrange,FLNAMESZ);
          break;
     default:
          rejectreq();
          return;
     }
     flo->csidx=atol(nextwd());
     flo->flags&=~NXTEQUL;
     if (direction > 0) {
          flo->flags&=~REVSRCH;
     }
     else {
          flo->flags|=REVSRCH;
     }
     if ((result=gotsrch()) != -1) {
          if (result != 0) {
               updsuff(namtmp->suffix);
               fsdpkr=flfrsp(FALSE,FALSE);
               rsp2read(namtmp,
                  sizeof(struct fsdpk)-(UIDSIZ+DESCSIZ)+strlen(fsdpkr->data),
                  fsdpkr);
          }
          else {
               rejectreq();
          }
     }
     else {
          switch (flo->keymeth) {
          case 2:
               stzcpy(srchptr->filname,flo->u.key2.filname,FLFILENM);
               stzcpy(srchptr->libname,flo->u.key2.libkey,FLNAMESZ);
               stzcpy(srchptr->other,flo->u.key2.keyword,FLKEYSIZ);
               break;
          case 4:
               stzcpy(srchptr->libname,flo->u.key4.libkey,FLNAMESZ);
               stzcpy(srchptr->filname,flo->u.key4.filname,FLFILENM);
               break;
          }
          cycleme(cycsrch);
     }
}

STATIC BOOL                        /*   returns FALSE if operation failed  */
context(                           /* secure/erase a context               */
BOOL get)                          /*   get: TRUE means secure, FALSE erase*/
{
     if (get) {
          if (flo->flags&CONTEXT) {
               return(FALSE);
          }
          flo->flags|=CONTEXT;
     }
     else {
          if (!(flo->flags&CONTEXT)) {
               return(FALSE);
          }
          flo->flags&=~CONTEXT;
     }
     return(TRUE);
}

STATIC BOOL
hascontext(void)                   /* whether there is a current context   */
{
     return((flo->flags&CONTEXT) ? TRUE : FALSE);
}

STATIC int
cslibrsv(                          /* c/s file reservation amreading() hook*/
char *lib,                         /*   Library name                       */
char *fil)                         /*   file name                          */
{
     int i;

     for (i=0 ; i < nterms ; i++) {
          if (sameas(lcsarr[i].libname,lib)
             || sameas(viewarr[i].libname,lib)) {
               if (sameas(fil,"*") || sameas(fil,lcsarr[i].filname)) {
                    return(i);
               }
          }
     }
     return((*oldrsv)(lib,fil));
}

STATIC void
copywait(void)                     /* waiting for file to copy from CD     */
{
     int stt;

     fluoff(usrnum);
     if ((stt=lcsarr[usrnum].status) < 0) {
          rejectreq();
          csclean(usrnum);
          return;
     }
     switch (stt) {
     case CDDONE:
          *namtmp=rqdptr->saunam;
          sendfile(spr("%s\\%s\\%s",copydir,
             lcsarr[usrnum].libname,lcsarr[usrnum].filname));
          if (lcsarr[usrnum].status == CDDONE) {
               lcsarr[usrnum].status=CDDLOD;
          }
          break;
     case EXTCDF:
          if (now()-lcsarr[usrnum].time > 60L) {
               rejectreq();
               lcsarr[usrnum].status=-lcsarr[usrnum].status;
               csclean(usrnum);
          }
     }
}

STATIC void
sendfile(                          /* send c/s user the requested file.    */
char *path)                        /*   path of file, checks it first      */
{                                  /*   assumes namtmp is correct, and     */
     struct fndblk fb;             /*   that lcsarr[] is filled            */
     long charge;

     if (fnd1st(&fb,path,0) && sameas(fb.name,filnpart(path))) {
          if (!tstcrd(dnlchg(fb.size,lcsarr[usrnum].libname))) {
               rejectreq();
               setmbk(flmsg);
               prfmsg(DNLNOCRD,lcsarr[usrnum].filname);
               dlerr();
               lcsarr[usrnum].status=-abs(lcsarr[usrnum].status);
               csclean(usrnum);
               return;
          }
          charge=dnlprc(fb.size,libfind(lcsarr[usrnum].libname));
          lcsarr[usrnum].charge=
             (charge == 0L ? 0L : hdedcrd(usaptr,charge,0,1));
          rsp2read(namtmp,STGLEN,path);
     }
     else {
          shocst("FILE LIBRARIES: MISSING FILE","%s\\%s is missing!",
             lcsarr[usrnum].libname,lcsarr[usrnum].filname);
          rejectreq();
          setmbk(flmsg);
          prfmsg(DNLNOFIL,lcsarr[usrnum].filname);
          dlerr();
          lcsarr[usrnum].status=-abs(lcsarr[usrnum].status);
          csclean(usrnum);
     }
}

int                                /*   returns: -1 or usrnum of c/s tag   */
csfbest(                           /* is there a better c/s tag waiting?   */
int mode,                          /*   mode: TGCOPY or TGINWAIT           */
long time)                         /*   time of best A/A tag if TGINWAIT   */
{                                  /*   or -1L if no best A/A time         */
     int i,better=-1;
     long best=0L,testime;

     for (i=0 ; i < nterms ; i++) {
          switch (mode) {
          case TGCOPY:
               if (lcsarr[i].status == CDCOPY) {
                    return(i);
               }
               break;
          case TGINWAIT:
               if (lcsarr[i].status == CDFILE) {
                    if (time == -1L || (testime=lcsarr[i].time) < time) {
                         if (better == -1 || testime < best) {
                              better=i;
                              best=testime;
                         }
                    }
               }
               break;
          default:
               return(-1);
          }
     }
     if (mode == TGINWAIT && better != -1) {
          return(better);
     }
     return(-1);
}

void
csclean(                           /* clean up c/s file tags               */
int unum)                          /*   usrnum of tag to clean up          */
{
     char *l,*f;
     struct taglib *tag;
     BOOL found=FALSE;
     int loop,stt;

     stt=lcsarr[unum].status;
     switch (-stt) {
     case CDCOPY:
          if (cdst != NULL) {
               fclose(cdst);
               cdst=NULL;
          }
          if (csrc != NULL) {
               fclose(csrc);
               csrc=NULL;
          }
          l=lcsarr[unum].libname;
          f=lcsarr[unum].filname;
          unlink(spr("%s\\%s\\%s",copydir,l,f));
          break;
     case CDDONE:
     case CDDLOD:
          l=lcsarr[unum].libname;
          f=lcsarr[unum].filname;
          for (loop=0 ; loop < systags ; loop++) {
               tag=tagoff(loop);
               if (tag->status > TGEMPTY) {
                    if (sameas(f,tag->filname) && sameas(l,tag->libname)) {
                         found=TRUE;
                         break;
                    }
               }
          }
          if (!found) {
               for (loop=0 ; loop < nterms ; loop++) {
                    if (loop != unum && lcsarr[loop].status > 0
                       && sameas(f,lcsarr[loop].filname)
                       && sameas(l,lcsarr[loop].libname)) {
                         found=TRUE;
                         break;
                    }
               }
               if (!found) {
                    unlink(spr("%s\\%s\\%s",copydir,l,f));
               }
          }
     }
     setmem(&lcsarr[unum],sizeof(struct libcsfil),0);
}

STATIC void
uplerror(void)                     /* caught a file copy error             */
{
     prf("1"); /* bad library */
     prfmsg(MVCERLB2,ulptr->libname);
     r2wprf(FALSE);
     donewrit(0);
     if (ulptr->src != NULL) {
          fclose(ulptr->src);
          ulptr->src=NULL;
     }
     if (ulptr->dst != NULL) {
          fclose(ulptr->dst);
          ulptr->dst=NULL;
     }
}

STATIC void
finupl(void)                       /* finish upload cycle                  */
{
     struct fndblk fb;
     struct fllib *libptr;
     char *src,*dst,*s;
     int loop,byte;
     BOOL upv;

     setmbk(flmsg);
     fluoff(usrnum);
     if ((libptr=libfind(ulptr->libname)) == NULL) {
          uplerror();
          return;
     }
     fluoff(usrnum);
     switch (ulptr->status) {
     case ULPONG: /* just finished upload, move file */
          src=spr("%s\\%s",userdir(1),ulptr->filname);
          setdtd(src,ulptr->time,ulptr->date);
          dst=spr("%s\\%s",libpath(libptr),ulptr->filname);
          if (rename(src,dst) != 0) {
               if ((ulptr->src=fopen(src,FOPRB)) == NULL) {
                    uplerror();   
                    return;
               }
               if ((ulptr->dst=fopen(dst,FOPWB)) == NULL) {
                    uplerror();
                    return;
               }
               ulptr->status=ULPCPY;
          }
          else {
               ulptr->status=(libptr->flags&FLGDOS) ? ULPFIN : ULPDAT;
          }
          break;
     case ULPCPY:
          if (ulptr->src == NULL || ulptr->dst == NULL) {
               uplerror();
               return;
          }
          for (loop=0 ; loop < 1024 ; loop++) {
               byte=fgetc(ulptr->src);
               if (!feof(ulptr->src) && !ferror(ulptr->src)
                  && !ferror(ulptr->dst)) {
                    fputc(byte,ulptr->dst);
               }
               else {
                    loop=2000;
               }
          }
          if (loop >= 2000) {
               if (ulptr->src != NULL) {
                    fclose(ulptr->src);
                    ulptr->src=NULL;
               }
               if (ulptr->dst != NULL) {
                    fclose(ulptr->dst);
                    ulptr->dst=NULL;
               }
               src=spr("%s\\%s",userdir(1),ulptr->filname);
               dst=spr("%s\\%s",libpath(libptr),ulptr->filname);
               touch(src,dst);
               unlink(src);
               ulptr->status=(libptr->flags&FLGDOS) ? ULPFIN : ULPDAT;
          }
          break;
     case ULPDAT:
          dst=spr("%s\\%s",libpath(libptr),ulptr->filname);
          if (!fnd1st(&fb,dst,0)) {
               uplerror();
               return;
          }
          setbtv(flfdat);
          upv=acqbtv(NULL,ulkey(ulptr),COMPLF);
          if (!upv) {
               setmem(flf,FLFILREC+DESCSIZ,0);
               stzcpy(flf->libname,libptr->libname,FLNAMESZ);
               stzcpy(flf->filname,ulptr->filname,FLFILENM);
          }
          s=haslibkey(libptr,libptr->autoap)
              ? dat2srt(ncdate(today())) : NOTAPPED;
          flf->siz=fb.size;
          if (upv) {
               libptr->numfiles--;
               libptr->totbytes-=clfit(flf->siz,libptr->cluster);
               if (notapped(flf->udate)) {
                    libptr->appwait--;
               }
               chuldate(libptr,flf->udate,0);
          }
          stzcpy(flf->udate,s,DATESZ);
          flf->utime=now();
          stzcpy(flf->fdate,dat2srt(ncdate(fb.date)),DATESZ);
          flf->tim=fb.time;
          stzcpy(flf->numdls,spr(NUMSZP,0L),NUMSZ);
          stzcpy(flf->ulby,usaptr->userid,UIDSIZ);
          if (!upv) {
               flf->desc[0]='\0';
          }
          if (upv) {
               upvbtv(NULL,FLFILREC+strlen(flf->desc)+1);
          }
          else {
               invbtv(NULL,FLFILREC+strlen(flf->desc)+1);
          }
          rstbtv();
          if (!upv && !longsrch) {
               if (makwdlst("",ulptr->filname)) { /* filename kwds only */
                    for (loop=0 ; loop < dargc ; loop++) {
                         addkw(dargv[loop],ulptr->filname,ulptr->libname);
                    }
               }
          }
          libptr->numfiles++;
          libptr->totbytes+=clfit(flf->siz,libptr->cluster);
          if (notapped(flf->udate)) {
               libptr->appwait++;
          }
          chuldate(libptr,flf->udate,1);
          libptr->flags|=LIBCHN;
          ulptr->status=ULPFIN;
          break;
     case ULPFIN:
          rsp2write(TRUE,0,"");
          donewrit(0);
          sv.uplds++;
          if (libptr != NULL && (auditall || (libptr->flags&FLGAUL))) {
               shocst("LIBRARY FILE UPLOAD","User %s uploaded %s\\%s",
                      usaptr->userid,ulptr->libname,ulptr->filname);
          }
     }
}

STATIC void
cskwdins(void)                     /* insert keywords in good time         */
{
     int loop;

     fluoff(usrnum);
     if (!delkw("",ulptr->filname,ulptr->libname)
        && kwbuf[0].keyword[0] == '\0') {
          setbtv(flfdat);
          if (acqbtv(NULL,ulkey(ulptr),COMPLF)) {
               if (makwdlst(flf->desc,flf->filname)) {
                    for (loop=0 ; loop < dargc ; loop++) {
                         addkw(dargv[loop],flf->filname,flf->libname);
                    }
               }
          }
          rsp2write(TRUE,0,"");
          donewrit(0);
     }
}

STATIC void
filldesc(void)                     /* fill flf->desc with dargv[] lines    */
{
     int loop,back;
     char *s;

     flf->desc[0]='\0';
     for (loop=0 ; loop < dargc && countc(flf->desc,'\r') < NDESCLN ; loop++) {
          if (strlen(dargv[loop]) < SDESCLN) {
               stzcat(flf->desc,spr("%s\r",dargv[loop]),DESCSIZ);
          }
          else {
               for (back=SDESCLN-1 ; back > SDESCLN-20 ; back--) {
                    s=&dargv[loop][back];
                    if (*s == ' ') {
                         break;
                    }
                    else {
                         s="";
                    }
               }
               if (*s == '\0') {
                    stzcat(flf->desc,spr("%.*s\r",SDESCLN-1,dargv[loop]),
                                                                      DESCSIZ);
                    dargv[loop]=&dargv[loop][SDESCLN-1];
               }
               else {
                    stzcat(flf->desc,spr("%.*s\r",back,dargv[loop]),DESCSIZ);
                    dargv[loop]=++s;
               }
               loop--;
          }
     }
}

STATIC BOOL                        /*   returns: false if unacceptable     */
isok2ul(                           /* is it acceptable to upload this file */
BOOL reserve)                      /*   whether to reserve the file now    */
{                                  /* if FALSE, prfbuf is filled.          */
     struct fllib *libptr;

     /* prf codes: 0 = no recourse 1=bad lib 2=filename change might help */

     if ((libptr=libfind(ulptr->libname)) == NULL
        || strlen(visxlib(libptr,"")) == 0) {
          prf("1"); /* bad library */
          prfmsg(LIBNOEXT);
          return(FALSE);
     }
     if (!haslibkey(libptr,libptr->ulkey) || !writable(libptr)) {
          prf("1"); /* bad library */
          prfmsg(UPLNOAXS,libptr->libname);
          return(FALSE);
     }
     if (!okfname(ulptr->filname)) {
          prf("2");
          prfmsg(RENNOFNM,"upload",ulptr->filname);
          return(FALSE);
     }
     if (!libptr->flags&FLGDOS) {
          setbtv(flfdat);
          if (acqbtv(flf,ulkey(ulptr),COMPLF)) {
               if (!haslibkey(libptr,libptr->overw)
                  && (!sameas(usaptr->userid,flf->ulby)
                      || (!notapped(flf->udate)
                          && !haslibkey(libptr,libptr->autoap)))) {
                    prf("2");
                    prfmsg(CANTOVER);
                    return(FALSE);
               }
          }
          rstbtv();
     }
     if (libroom(libptr) <= 0L && !haskey(flsysop)) {
          prf("0");
          prfmsg(UPLNOFRM,libptr->libname);
          return(FALSE);
     }
     if (ulptr->size > byteroom && !haskey(flsysop)) {
          prf("0");
          prfmsg(UPLF2BIG,ulptr->filname,libptr->libname);
          return(FALSE);
     }
     /* note: next one must be last because of w2writ() */
     if (reserve &&
        (othusn=w2writ(ulptr->libname,ulptr->filname,0)) != NOCONFLICT) {
          prf("2");
          prfmsg(ACTNORSV,"upload",
               haskey(flsysop) ? uacoff(othusn)->userid : "someone");
          return(FALSE);
     }
     return(TRUE);
}

STATIC void
delfile(void)                      /* delete btv record and DOS file       */
{
     struct fllib *libptr;

     if ((libptr=libfind(ulptr->libname)) != NULL) {
          if (!(libptr->flags&FLGCBD)) {
               unlink(spr("%s\\%s",libpath(libptr),ulptr->filname));
          }
          if (!(libptr->flags&FLGDOS)) {
               setbtv(flfdat);
               if (acqbtv(NULL,ulkey(ulptr),COMPLF)) {
                    libptr->numfiles--;
                    libptr->totbytes-=clfit(flf->siz,libptr->cluster);
                    if (notapped(flf->udate)) {
                         libptr->appwait--;
                    }
                    chuldate(libptr,flf->udate,0);
                    libptr->flags|=LIBCHN;
                    delbtv();
               }
               rstbtv();
          }
     }
     donewrit(1);
     rsp2write(TRUE,0,"");
}

STATIC void
delkwds(void)                      /* delete keyword records               */
{
     fluoff(usrnum);
     setbtv(flkdat);
     if (acqbtv(NULL,rcompkey(ulptr->libname,ulptr->filname),COMPFL_K)) {
          delbtv();
     }
     else {
          delfile();
     }
     rstbtv();
}

STATIC void
renkwds(void)
{
     struct key2 dat;
     long pos;
     struct fllib *srcl,*dstl;

     fluoff(usrnum);
     if ((srcl=libfind(ulptr->libname)) == NULL
        || (dstl=libfind(ulptr->newlib)) == NULL) {
          /* highly unusual */
          prf("Error while updating keywords - Library missing");
          donewrit(1);
          donewrit(2);
          r2wprf(FALSE);
          return;
     }
     if (srcl->flags&FLGDOS || (!ulptr->move && (dstl->flags&FLGDOS))) {
          donewrit(1);
          donewrit(2);
          rsp2write(TRUE,0,"");
          return;
     }
     setbtv(flkdat);
     if (acqbtv(&dat,rcompkey(ulptr->libname,ulptr->filname),COMPFL_K)) {
          if (ulptr->move) {
               delbtv();
               if (!(dstl->flags&FLGDOS)) {
                    stzcpy(dat.filname,ulptr->newname,FLFILENM);
                    stzcpy(dat.libkey,ulptr->newlib,FLNAMESZ);
                    insbtv(&dat);
               }
               return;
          }
          else {
               do {
                    pos=absbtv();
                    stzcpy(dat.libkey,ulptr->newlib,FLNAMESZ);
                    stzcpy(dat.filname,ulptr->newname,FLFILENM);
                    addkw(dat.keyword,dat.filname,dat.libkey);
                    aabbtv(&dat,pos,COMPFL_K);
               } while (aqnbtv(&dat) && sameas(dat.libkey,ulptr->libname));
          }
     }
     donewrit(1);
     donewrit(2);
     rsp2write(TRUE,0,"");
}

STATIC void
inimaint(                          /* initialize Library maintenance       */
BOOL datype,                       /*   read data, not files               */
BOOL write,                        /*   actually change vs. just list      */
BOOL approve,                      /*   approve file if we're logging in   */
char *libname)                     /*   lib to do, or "" for all           */
{
     struct fllib *libptr;

     if (libname[0] != '\0') {
          if ((libptr=libfind(libname)) == NULL) {
               prfmsg(ACTNOLIB,"maintain");
               r2wprf(FALSE);
               return;
          }
          if (libptr->flags&FLGCBD) {
               prfmsg(ACTNONCD,"maintain");
               r2wprf(FALSE);
               return;
          }
          if (libptr->flags&FLGDOS) {
               prfmsg(ACTNODOS,"maintain");
               r2wprf(FALSE);
               return;
          }
     }
     if (mainting) {
          prfmsg(MAINTING);
          r2wprf(FALSE);
          return;
     }
     mainting=TRUE;
     ulptr->reqtype=datype ? ULRMN1 : ULRMN0;
     setmem(ulptr->filname,FLFILENM,0);
     stzcpy(ulptr->newlib,libname,FLNAMESZ);
     ulptr->move=write;
     ulptr->app=approve;
     ulptr->uzfp=NULL;
     if (datype) {
          stzcpy(ulptr->libname,libname,FLNAMESZ);
     }
     else {
          setmem(ulptr->libname,FLNAMESZ,0);
     }
     cycleme(maintit);
}

STATIC void
maintit(void)                      /* ongoing Library maintenance          */
{
     struct fndblk fb;
     char misclib[FLNAMESZ],destpath[PATHSIZE];
     struct key1 key1;
     int miscflag,cont=0;
     FILE *fp;
     long oldflags;

     fluoff(usrnum);
     fb=flo->fb;
     movmem(flo->misclib,misclib,FLNAMESZ);
     movmem(flo->destpath,destpath,PATHSIZE);
     key1=flo->key1;
     miscflag=flo->miscflag;
     fp=flo->fsrc;
     oldflags=flo->flags&APPTHEM;
     flo->fb=ulptr->fb;
     stzcpy(flo->misclib,ulptr->newlib,FLNAMESZ);
     stzcpy(flo->key1.libname,ulptr->libname,FLNAMESZ);
     stzcpy(flo->key1.filname,ulptr->filname,FLFILENM);
     flo->miscflag=ulptr->reqtype == ULRMN1 ? 1 : 2;
     flo->fsrc=ulptr->uzfp;
     flo->flags&=~APPTHEM;
     if (ulptr->newlib[0] == '\0') {
          flo->miscflag+=2;
     }
     if (ulptr->move) {
          flo->miscflag=-flo->miscflag;
     }
     setmbk(flmsg);
     switch (ulptr->reqtype) {
     case ULRMN0:
          if (ulptr->app) {
               flo->flags|=APPTHEM;
          }
          else {
               flo->flags&=~APPTHEM;
          }
          cont=srch2();
          if (cont == 2) {
               ulptr->reqtype=ULRZIP;
          }
          break;
     case ULRMN1:
          cont=srch1();
          break;
     case ULRZIP:
          if (!dizread(uzbuf)) {
               ulptr->reqtype=ULRZPW;
          }
          cont=1;
          break;
     case ULRZPW:
          if (kwbuf[0].keyword[0] == '\0') {
               gather();
               if (ulptr->app) {
                    flo->flags|=APPTHEM;
               }
               else {
                    flo->flags&=~APPTHEM;
               }
               dofiler(descedit);
               ulptr->reqtype=ULRMN0;
          }
          cont=1;
          break;
     default:
          rsp2write(TRUE,0,"");
          cont=1;
     }
     ulptr->fb=flo->fb;
     stzcpy(ulptr->libname,flo->key1.libname,FLNAMESZ);
     stzcpy(ulptr->filname,flo->key1.filname,FLFILENM);
     ulptr->uzfp=flo->fsrc;
     if (cont == 0) {
          prf("done");
          mainting=FALSE;
          r2wprf(TRUE);
     }
     flo->fb=fb;
     movmem(misclib,flo->misclib,FLNAMESZ);
     movmem(destpath,flo->destpath,PATHSIZE);
     flo->key1=key1;
     flo->miscflag=miscflag;
     flo->fsrc=fp;
     flo->flags|=oldflags;
}

void
sendjoin(void)                     /* send joinings note via unsol. dpk    */
{
     struct saunam unsol;
     int i;
     struct user *up;

     if (cnvd2s("sa=GALFIL;:rejoin",&unsol)) {
          for (i=0 ; i < nterms ; i++) {
               up=&user[i];
               if (up->class > SUPIPG && (up->flags&ISGCSU)) {
                    if (qroom(i,NORMAL)) {
                         senddpk(i,"GALFIL",NORMAL,&unsol,STGLEN,"1");
                    }
               }
          }
     }
}

STATIC void
dlerr(void)                        /* send prfbuf d/l error to current usr */
{
     struct saunam unsol;

     depad(stp4cs(prfbuf));
     if (qroom(usrnum,NORMAL) && cnvd2s("sa=GALFIL;:dlerr",&unsol)) {
          senddpk(usrnum,"GALFIL",NORMAL,&unsol,STGLEN,prfbuf);
     }
}

STATIC void
csunapan(void)                     /* announce to Libops of unapp'd files  */
{
     int i,num;

     fluoff(usrnum);
     for (i=0,num=0 ; i < numoflib ; i++) {
          if (isflop(curlib=liboff(i)) && curlib->appwait > 0) {
               num+=curlib->appwait;
          }
     }
     if (num > 0) {
          setmbk(flmsg);
          if (num == 1) {
               prfmsg(CSLOPAN1);
          }
          else {
               prfmsg(CSLOPANN,num);
          }
          addannom(prfbuf,"GALFIL",lopcstg);
          rstmbk();
     }
     else {
          addanno("");
     }
}

void
setlcsu(                           /* set lcsu for generic reference       */
int unum)                          /*   usrnum to set it to                */
{
     ASSERT(unum >= 0 && unum < nterms);
     lcsu=&lcsarr[unum];
}
