/***************************************************************************
 *                                                                         *
 *   EFUTL.C                                                               *
 *                                                                         *
 *   Copyright (c) 1988-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   E-mail and Forums utilities and common functions (for both            *
 *   ASCII/ANSI and Client/Server).                                        *
 *                                                                         *
 *                                                - J. Alvrus 8/2/94       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gme.h"
#include "galmsg.h"
#include "emlfor.h"

#define FILREV "$Revision:   1.0.1.0.1.0  $"

FILE *efmb;                        /* E-mail/Forums .MSG file              */
struct fndblk effb;                /* general-purpose find block           */
struct qscfg *qsptr;               /* current user's quicscan              */
int *peruflg;                      /* per-user, non-VDA flags              */
struct message *msg;               /* current message header structure     */
char *msgtxt,                      /* current message text buffer          */
     *filatt,                      /* current file att path+file name      */
     *abvcmt,                      /* header above comment in message text */
     *blwcmt;                      /* header below comment in message text */
BOOL alwcpy;                       /* allow user to CC a message           */

int numscans;                      /* number of scan buffers available     */
STATIC int *scanchan;              /* array of channel # associated w/scan */
STATIC void *scanhead;             /* head of scan buffer array            */
struct otscan **usrscn=NULL;       /* per-user array of scan buffer ptrs   */

#define NOTINU -1                  /* scan buffer not-in-use code          */

void EXPORT
init__emlfor(void)
{
     int i;

     efmb=opnmsg("GALMSG.MCV");
     peruflg=(int *)alczer(nterms*sizeof(int));
     alwcpy=ynopt(ALWCPY);
     abvcmt=strdup(stpans(rawmsg(ABVCMT)));
     blwcmt=strdup(stpans(rawmsg(BLWCMT)));
     numscans=numopt(NSCNPOOL,-1,256);
     if (numscans < 0 || numscans > nterms) {
          numscans=nterms;
     }
     if (numscans > 0) {
          scanhead=alcblok(numscans,
                           sizeof(struct otscan)+sizeof(unsigned)*(maxqsf()-1));
          scanchan=(int *)alcmem(numscans*sizeof(int));
          for (i=0 ; i < numscans ; ++i) {
               scanchan[i]=NOTINU;
          }
     }
     usrscn=(struct otscan **)alczer(nterms*sizeof(struct otscan *));
     iniaa();
     inics();
}

struct otscan *                    /*   returns NULL if not available      */
rsvscan(                           /* reserve a scan buffer                */
int unum)                          /*   for this channel                   */
{
     int i;

     #ifdef DEBUG
          for (i=0 ; i < numscans ; ++i) {
               ASSERT(scanchan[i] != unum);
          }
     #endif
     for (i=0 ; i < numscans && scanchan[i] != NOTINU ; ++i) {
     }
     if (i == numscans) {
          return(NULL);
     }
     scanchan[i]=unum;
     return(ptrblok(scanhead,i));
}

void
unrscan(                           /* unreserve scan buffer                */
int unum)                          /*   for this channel                   */
{
     int i;

     for (i=0 ; i < numscans ; ++i) {
          if (scanchan[i] == unum) {
               scanchan[i]=NOTINU;
               #ifdef DEBUG
                    for ( ; i < numscans ; ++i) {
                         ASSERT(scanchan[i] != unum);
                    }
               #endif
               return;
          }
     }
     ASSERTM(FALSE,"attempt to unreserve an unreserved scan buffer");
}

BOOL                               /*   returns TRUE if recip notified     */
wrtnot(                            /* notify recipient of new mail to them */
char *to,                          /*   to whom the message was written    */
struct message *msg)               /*   message header structure           */
{
     ASSERT(msg != NULL);
     ASSERT(msg->forum == EMLID || fidxst(msg->forum));
     if (onsys(usaptr->userid)) {
          if (onsys(to) && !sameas(usaptr->userid,to)) {
               setmbk(efmb);
               if (msg->forum == EMLID) {
                    if (msg->flags&PRIMSG) {
                         prfmlt(PTOUPG,usaptr->userid);
                    }
                    else {
                         prfmlt(ETOUPG,usaptr->userid);
                    }
               }
               else {
                    prfmlt(FTOUPG,usaptr->userid,getfnm(msg->forum));
               }
               rstmbk();
               return(injoth());
          }
     }
     return(FALSE);
}

BOOL                               /*   returns TRUE if recip notified     */
cpynot(                            /* notify recipient of copy to them     */
char *to)                          /*   to whom the message was copied     */
{
     ASSERT(to != NULL);
     if (onsys(usaptr->userid)) {
          if (onsys(to) && !sameas(usaptr->userid,to)) {
               setmbk(efmb);
               prfmlt(CPYPG,usaptr->userid);
               rstmbk();
               return(injoth());
          }
     }
     return(FALSE);
}

BOOL                               /*   returns TRUE if recip notified     */
fwdnot(                            /* notify recipient of fwd to them      */
char *to)                          /*   to whom the message was forwarded  */
{
     ASSERT(to != NULL);
     if (onsys(usaptr->userid)) {
          if (onsys(to) && !sameas(usaptr->userid,to)) {
               setmbk(efmb);
               prfmlt(FWDPG,usaptr->userid);
               rstmbk();
               return(injoth());
          }
     }
     return(FALSE);
}

BOOL                               /*   returns TRUE if recip notified     */
rrgnot(                            /* notify sender of receipt generation  */
char *to)                          /*   to whom the return receipt was sent*/
{
     ASSERT(to != NULL);
     if (onsys(usaptr->userid)) {
          if (onsys(to) && !sameas(usaptr->userid,to)) {
               setmbk(efmb);
               prfmlt(RRGPG,usaptr->userid);
               rstmbk();
               return(injoth());
          }
     }
     return(FALSE);
}

char *
lf2cr(                             /* replace '\n' with '\r'               */
char *str)                         /*   in this string                     */
{
     return(strrpl(str,'\n','\r'));
}

