/***************************************************************************
 *                                                                         *
 *   EDITFSE.H                                                             *
 *                                                                         *
 *   Copyright (c) 1988-1995 GALACTICOMM, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This is the Full Screen/Line Editor module's internal header file.    *
 *                                                                         *
 *          Modifications for 6.0 - R. A. Rose 4/6/92                      *
 *             Full Screen Editor - R. A. Rose 11/9/90                     *
 *                                                                         *
 ***************************************************************************/

extern
struct fseusr {
     int signat;              /* User-ID Signature                         */
     char *topic;             /* Pointer to topic buffer                   */
     int tpcsiz;              /* Max size of topic field                   */
     char *txtbuf;            /* pointer to text buffer                    */
     int txtsiz;              /* size of current allowable text buffer     */
     int flags;               /* misc. editor use flags                    */
     int scnlen;              /* screen height for full screen editor      */
     int pfnlvl;              /* profanity level for user in effect        */
     int (*imradr)();         /* ptr to import-message routine in effect   */
     char *topscr;            /* ptr to top of screen (in memory)          */
     char *begstg;            /* start of current line being edited        */
     char *endstg;            /* pointer to first unused line              */
     char *mkstart;           /* start of marked block                     */
     char *mkend;             /* end of marked block                       */
     char *endbuf;            /* pointer to the zero at end of buffer      */
     char *tmpptr;            /* temporary position holder pointer         */
     int x;                   /* Cursor X position (counting from 1)       */
     int y;                   /* Cursor Y position (counting from 1)       */
     int substt;              /* Last fsechi state                         */
     int ech2go;              /* Amount of echo buffer left                */
     int stacnt;              /* Number of Status 3s in the buffer         */
     int termtyp;             /* Terminal Type                             */
     int winstar;             /* Window starting y                         */
     int winheig;             /* Window height                             */
     int cmd;                 /* BTUCHI to Real Commands                   */
     int txtlen;              /* cumulative length of current text buffer  */
     int nlines;              /* number of lines processed                 */
                              /* FSE: nlines=number of chars in line entry */
     int curlin;              /* line currently being edited               */
     int rpclen;              /* length of line to replace                 */
                              /* FSE: command after TAKONE & LINMOD        */
     int crllen;              /* target line length                        */
     int (*exitro)();         /* ptr to exit/quit routine in effect        */
     int rflags;              /* pointer to return flags                   */
     char tmpbuf[80];         /* Temporary buffer for each user            */
} *fsecpt;                    /* pointer to current fsechi users data      */

void chiscon(int chan);
void chimvcl(char *src,char *dst,register int cnt);
void chirmov(char *src,char *dst,register int cnt);
void chiouc(int btchn,char *stg,int cnt);
void chinum(int btchn,int val);

void clsedt(void);
void fse_edtimr(int (*imradr)());
void fse_edtpfn(int pfnlvl);
int fse_inedit(int usn,int (*exipnt)());
int fse_bgnedt(int siz,char *buf,int tsiz,char *topic,int (*whndun)(),int
         flags);
int stfse(int siz,char *buf,int tsiz,char *topic);
int stline(int siz,char *buf,int tsiz,char *topic);
int dunedt(void);
int worlen(char *ptr);
int fsepage(void);
void fsehup(void);
char fsechi(int chan,int c);
int ldunedt(void);
void rtfedt(void);
void rststf(void);
void edtmnu(void);
void edtpmt(void);
void hlpmnu(void);
int procln(void);
int morspc(void);
int hdlecm(void);
void bgnmsg(void);
void bgntpc(void);
void hdlhcm(void);
void rplcwt(void);
char *inword(char *stg1,char *stg2);
void dellin(void);
int chk4nl(int msg,long parm);
void apndtx(void);
void insttx(void);
void lstlns(int shwlines);
void extlin(void);
int vldlin(int msg);
void rplctx(void);
void rstrln(void);
void strtov(int siz,char *buf,int tsiz,char *topic);
int msgtpc(void);
int edttpc(void);
int uplmsg(char *afile,int flags);
