/***************************************************************************
 *                                                                         *
 *   DOSFACE.H                                                             *
 *                                                                         *
 *   Copyright (c) 1988-1995 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   This header file is for programs that use the modules in DOSFACE.C    *
 *   and the modules in the DOSCALLS segment of GCOMM.LIB.  These          *
 *   garden-variety routines perform common functions involving the        *
 *   operating system.                                                     *
 *                                                                         *
 *      ddmon(),ddday(),ddyear() macros unpack Packed date                 *
 *      dddate() macro packs month,day,year into date                      *
 *      In these macros, month is 1-12, day is 1-31, year is 1980-2069     *
 *                                                                         *
 *      dthour(),dtmin(),dtsec() macros unpack Packed time-of-day          *
 *      dttime() macro packs hour,min,sec into Packed time                 *
 *      In these macros, hour is 0-23, min is 0-59, sec is 0-58 (by 2s)    *
 *                                                                         *
 *      The fndblk structure is used by both fnd1st() and fndnxt().        *
 *      the FAMxxx constants may be used to form the attr parameter of     *
 *      fnd1st().                                                          *
 *                                                                         *
 *   Modules in DOSCALLS segment of GCOMM.LIB                              *
 *                                                                         *
 *      ok=fnd1st(fbptr,filspc,attr); Find first occurance of a filespec   *
 *      int ok;                       0=none found 1=one found             *
 *      struct fndblk *fbptr;         find block pointer (temp DTA)        *
 *      char *filspc;                 DOS path spec (may incl wild chars)  *
 *      char attr;                    Attribute mask                       *
 *                                                                         *
 *      ok=fndnxt(fbptr);             Find next occurance of same filespec *
 *      int ok;                       0=no more found 1=one more found     *
 *      struct fndblk *fbptr;         find block pointer (temp DTA)        *
 *                                                                         *
 *                                                                         *
 *                                               - RNStein 1/31/88         *
 *                                                                         *
 ***************************************************************************/

#define ddyear(date) ((((date)>>9)&0x007F)+1980)
#define ddmon(date)   (((date)>>5)&0x000F)
#define ddday(date)    ((date)    &0x001F)
#define dddate(mon,day,year) (((mon)<<5)+(day)+(((year)-1980)<<9))

#define dthour(time)  (((time)>>11)&0x001F)
#define dtmin(time)   (((time)>> 5)&0x003F)
#define dtsec(time)   (((time)<< 1)&0x003E)
#define dttime(hour,min,sec) (((hour)<<11)+((min)<<5)+((sec)>>1))

struct fndblk {                    /* used by fnd1st,fndnxt in datntim.c   */
     char junk[21];                /*                                      */
     char attr;                    /* file attribute (see masks below)     */
     unsigned time;                /* time in HHHHHMMMMMMSSSSS format      */
     unsigned date;                /* date in YYYYYYYMMMMDDDDD format      */
     long size;                    /* size in bytes                        */
     char name[12+1];              /* name of file "FFFFFFFF.EEE"          */
};

/*  File Attribute Masks  (used by fnd1st()) */
/*------------------------*/
#define FAMRON 0x01      /* File attribute:  read only                      */
#define FAMHID 0x02      /* File attribute:  hidden                         */
#define FAMSYS 0x04      /* File attribute:  system                         */
#define FAMVID 0x08      /* File attribute:  volume id                      */
#define FAMDIR 0x10      /* File attribute:  sub-directory                  */
#define FAMARC 0x20      /* File attribute:  archive                        */

/* DOSFACE.C 03/02/92 16.45.00 */
extern char moname[][4];
int today(void);
int daytoday(void);
int now(void);
char *ncdate(int date);
char *nctime(int time);
char *ncedat(int date);
char *ncudnt(int date,int time);
int dcdate(char *datstr);
int dctime(char *timstr);
int cofdat(int date);
int datofc(int count);

int fnd1st(struct fndblk *fbptr,char *filspc,char attr);
int fndnxt(struct fndblk *fbptr);
