/***************************************************************************
 *                                                                         *
 *   CSUINFED.C                                                            *
 *                                                                         *
 *   Copyright (C) 1994 Galacticomm, Inc.        All rights reserved.      *
 *                                                                         *
 *   This is the Galacticomm agent for Client/Server Account Display/Edit. *
 *                                                                         *
 *                                                - Bill Hyatt 7/13/94     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "bbssup.h"

#define FILREV "$Revision:   1.0.1.0.1.0  $"

#define MAXTKC 100000000L          /* max char count of tick xfer request  */
#define HASRKY 0x01                /* user has AD/E agent read key         */
#define HASWKY 0X02                /* user has AD/E agent write key        */

#define NOBDY -2                   /* this system doesn't ask for DOB      */

struct uincfg {                    /* acc disp/edit config info            */
     BOOL shwcrd;                  /*   show user's credits?               */
     BOOL shwnam;                  /*   show user's name?                  */
     BOOL shwcmp;                  /*   show user's company?               */
     BOOL shwadr;                  /*   show user's address?               */
     BOOL shwpho;                  /*   show user's phone number?          */
     BOOL edtbdy;                  /*   allow user to edit birthday?       */
     BOOL shwsex;                  /*   show user's sex?                   */
     BOOL shwsys;                  /*   show user's system type?           */
     BOOL lngchg;                  /*   allow user to change lang pref?    */
} uincfg;                          /* info to send to client               */

struct xfinfovb {                  /* credit-transfer info, VB form        */
     char tranfid[UIDSIZ-1];       /*   transferee's User-ID               */
     long tikreq;                  /*   amount of the transfer             */
};

STATIC void uinread(int direction,struct saunam *dpknam);
STATIC void uinwrite(struct saunam *dpknam,unsigned length,void *value);
STATIC void uinxdone(void);
STATIC void uinabort(void);

STATIC BOOL xfrcrd(struct xfinfovb *xfinfovb);
void inicsuin(void);

struct agent uinagt={              /* agent information structure          */
     "GALUIE",                     /* appid                                */
     uinread,                      /* read-dynapak function pointer        */
     uinwrite,                     /* write-dynapak function pointer       */
     uinxdone,                     /* file xfer-done function pointer      */
     uinabort                      /* abort-request function pointer       */
};

char *aderkey,                     /* key req'd to read from AD/E agent    */
     *adewkey;                     /* key req'd to write to AD/E agent     */

extern
int shwcrd,                        /* show users how many creds they have? */
    chgbdy;                        /* allow users to change birthdays?     */

extern
char *langchg;                     /* key required to change language pref */

extern
long mincxf;                       /* min credits a user may transfer      */

extern
FILE *supmb;                       /* BBSSUP.MCV                           */

void
inicsuin(void)
{
     register_agent(&uinagt);
     uincfg.shwcrd=(shwcrd ? VBTRUE : FALSE);
     uincfg.shwnam=(asktbl[TBLNAM][0] ? VBTRUE : FALSE);
     uincfg.shwcmp=(asktbl[TBLAD1][0] ? VBTRUE : FALSE);
     uincfg.shwadr=(asktbl[TBLAD2][0] ? VBTRUE : FALSE);
     uincfg.shwpho=(asktbl[TBLPHO][0] ? VBTRUE : FALSE);
     uincfg.edtbdy=(asktbl[TBLBDY][0] ? (chgbdy ? VBTRUE : FALSE) : NOBDY);
     uincfg.shwsex=(asktbl[TBLSEX][0] ? VBTRUE : FALSE);
     uincfg.shwsys=(asktbl[TBLSYS][0] ? VBTRUE : FALSE);
     aderkey=stgopt(ADERKEY);
     adewkey=stgopt(ADEWKEY);
}

STATIC void
uinread(                           /* read-dynapak handler                 */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     char *dpkstg;
     int adekys=0;

     if (stdchk("") && direction == 0) {
          dpkstg=cnvs2d(dpknam);
          if (sameas(dpkstg,"sau:key")) {
               if (haskey(aderkey)) {
                    adekys|=HASRKY;
               }
               if (haskey(adewkey)) {
                    adekys|=HASWKY;
               }
               rsp2read(dpknam,sizeof(int),&adekys);
               return;
          }
          else if (haskey(aderkey)) {
               if (sameas(dpkstg,"sa:uincfg")) {
                    uincfg.lngchg=(haskey(langchg) ? VBTRUE : FALSE);
                    rsp2read(dpknam,sizeof(struct uincfg),&uincfg);
                    return;
               }
          }
     }
     rejectreq();
}

STATIC void
uinwrite(                          /* write-dynapak handler                */
struct saunam *dpknam,             /*   dynapak name to write              */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value to write             */
{
     char *dpkstg;

     if (stdchk(adewkey) && sameas(dpknam->usrid,usaptr->userid)) {
          dpkstg=cnvs2d(dpknam);
          if (sameas(dpkstg,"sau:credxfr")) {
               if (length == sizeof(struct xfinfovb)) {
                    r2wprf(xfrcrd((struct xfinfovb *)value));
                    return;
               }
          }
     }
     rejectreq();
}

STATIC BOOL
xfrcrd(                            /* verify and transfer credits to user  */
struct xfinfovb *xfinfovb)         /*   credit transfer info               */
{
     char tranfid[UIDSIZ];
     long tikreq;
     int ison;

     setmbk(supmb);
     b2ccpy(tranfid,xfinfovb->tranfid,UIDSIZ);
     tikreq=xfinfovb->tikreq;
     if (usaptr->creds <= mincxf) {
          prfmsg(CSNOCRDX,l2as(mincxf));
          howbuy();
          return(FALSE);
     }
     if (tikreq < mincxf || tikreq > MAXTKC) {
          prfmsg(NUMBAD,l2as(mincxf),l2as(min(usaptr->creds-1,MAXTKC)));
          return(FALSE);
     }
     if (tikreq >= usaptr->creds) {
          prfmsg(NOTENO,l2as(usaptr->creds-1));
          howbuy();
          return(FALSE);
     }
     if (sameas(usaptr->userid,tranfid)) {
          prfmsg(NOTSELF);
          return(FALSE);
     }
     if ((ison=crdusr(tranfid,l2as(tikreq),0,0)) < 0) {
          prfmsg(INVACC,tranfid);
          return(FALSE);
     }
     prfmsg(DATATR,l2as(tikreq),usaptr->userid,tranfid);
     if (ison && !(usrptr->flags&INVISB)) {
          prfmlt(SENDUS,usaptr->userid,l2as(tikreq));
          if (injoth()) {
               prfmsg(NOTICE,tranfid);
          }
     }
     rdedcrd(tikreq,1);
     if (!haskey(syskey) && grpnum[usrnum] != 0) {  /* zap stats        */
          mdstats[usrptr->state].creds-=tikreq;     /* that were added  */
          sv3.crdghr[grpnum[usrnum]-1][dthour(now())]-=tikreq;
     }
     shocst("USER CREDIT TRANSFER","%s->%s (%s credits)",
               usaptr->userid,tranfid,l2as(tikreq));
     return(TRUE);
}

STATIC void
uinxdone(void)                     /* file transfer-done handler           */
{
}

STATIC void
uinabort(void)                     /* abort-request handler                */
{
}
