/***************************************************************************
 *                                                                         *
 *   CSEF.H                                                                *
 *                                                                         *
 *   Copyright (c) 1988-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Client/Server E-mail and Forums shared variable and function          *
 *   definitions.                                                          *
 *                                                                         *
 *                                                - J. Alvrus  10/20/94    *
 *                                                                         *
 ***************************************************************************/

#define FLDSEP '\1'                /* message dynapak field separator      */

#define WRTNEW "wrtnew"            /* new message dynapak suffix           */
#define WRTRPL "wrtrpl"            /* reply dynapak suffix                 */
#define CCLSFX "cclist "           /* cc: list dynapak suffix              */
#define UPLATT "msgatt "           /* new message attachment suffix        */

#define WRTBUSY  1000              /* error code for "write buffer in use" */
#define PFNERR   1001              /* error code for too much profanity    */
#define BADADR   1002              /* error code for bad address           */
#define CCEXP    FILAPV            /* cc: list coming for message flag     */
#define NOHDL    -1                /* returned from rsvarea() if none avail*/

struct emlacc {                    /* E-mail access dynapak structure      */
     int flags;                    /*   access flags                       */
     int ccmax;                    /*   max # cc:s per message             */
     long txtlen;                  /*   message text buffer size           */
};
                                   /* E-mail/Forums access flags           */
#define EAWRITE  0x0001            /*   write E-mail other than "Sysop"    */
#define EAATTACH 0x0002            /*   attach files to messages           */
#define EARECREQ 0x0004            /*   request return receipts            */
#define EAPRIMSG 0x0008            /*   write priority message             */
#define EAFOROP  0x0010            /*   perform Forum-Op operations        */
#define EAINDATT 0x0020            /*   make indirect attachments to msgs  */
#define EAMSLST  0x0040            /*   use !MASS list                     */
#define EAEDLST  0x0080            /*   create/edit server-side lists      */

struct cdetail {                   /* carrier detail dynapak structure     */
     char prefix[PFXSIZ-1];        /*   carrier prefix                     */
     char name[EXPNSZ-1];          /*   carrier name                       */
     int flags;                    /*   access flags                       */
     char info[1];
};

                                   /* C/S write request states             */
#define WAIT4CC  1                 /*   waiting for cc: list               */
#define WAIT4ATT 2                 /*   waiting for attachment             */
#define UPINGATT 3                 /*   uploading attachment               */
#define SENDING  4                 /*   writing message                    */

extern
struct wrtbuf {                    /* pool memory structure for msg writes */
     char filatt[MAXPATH];         /*   file attachment                    */
     char *cclist;                 /*   separately-allocated cc: list      */
     long primsg;                  /*   primary message ID                 */
     struct message msg;           /*   message header                     */
     char text[1];                 /*   message text buffer                */
} *wrtbuf;

struct uplinf {                    /* attachment upload info               */
     unsigned time;                /*   file time stamp                    */
     unsigned date;                /*   file date stamp                    */
     char attpath[MAXPATH];        /*   path being uploaded to             */
};

extern
struct rqinfo {                    /* C/S E-mail/Forums per-request struct */
     signed char stt;              /*   read direction/write state         */
     int othrqid;                  /*   request ID of associated dynapak   */
     unsigned char flags;          /*   request control flags              */
     int wrthdl;                   /*   handle of memory area for writing  */
     struct saunam dpknam;         /*   dynapak name storage               */
     union {
          char work[GMEWRKSZ];     /*   GME work area                      */
          struct uplinf uplinf;    /*   attachment upload info             */
          char tag[TSLENG];        /*   attachment download tag buffer     */
     } u;
} *rqiptr;                         /* E-mail/Forums per-req memory ptr     */

                                   /* E-mail/Forums per-request flags      */
#define INCLTXT 0x01               /*   current read req includes msg text */
#define ISREPLY 0x01               /*   current write request is a reply   */
#define WDSTING 0x02               /*   current write op is distribution   */
#define WCCING  0x04               /*   current write op is carbon copying */
#define WCPYING 0x08               /*   copying attachment                 */
/*      RECREQ  0x10                    msg had return-receipt requested   */
#define BUFINU  0x20               /*   request has reserved a write buffer*/

struct msgdpk {                    /* in-dynapak message structure         */
     int forum;                    /*   ID of forum message belongs to     */
     char axes;                    /*   access flags for forum this msg in */
     char fornam[FORNSZ-1];        /*   name of forum this message is in   */
     long msgid;                   /*   unique message identifier          */
     struct globid gmid;           /*   unique global message identifier   */
     long thrid;                   /*   ID of thread message is part of    */
     char attname[FLNSIZ-1];       /*   attached file name                 */
     double crdatim;               /*   message creation date and time     */
     struct globid rplto;          /*   global ID of msg this is a reply to*/
     int nrpl;                     /*   number of times replied to         */
     int flags;                    /*   message/attachment flag bits       */
     char info[1];                 /*   info field (see below)             */
};

struct newdpk {                    /* in-dynapak new message structure     */
     unsigned orgfor;              /*   forum original message was in      */
     unsigned forum;               /*   forum msg being written to         */
     long msgid;                   /*   unique message identifier          */
     struct globid gmid;           /*   unique global message identifier   */
     long thrid;                   /*   ID of thread message is part of    */
     char attname[FLNSIZ-1];       /*   attached file name                 */
     int flags;                    /*   message/attachment flag bits       */
     char info[1];                 /*   info field (see below)             */
};

struct wrterr {                    /* message write error structure        */
     int flags;                    /*   what feature(s) caused the error   */
     int rc;                       /*   type of error that occurred        */
};

                                   /* message write error flags            */
/*      PRIMSG  0x0001                  message is "priority"              */
#define FORUM   0x0002             /*   error in forum ID                  */
#define ADDRESS 0x0004             /*   error in address                   */
#define CCOPY   0x0008             /*   error in carbon copies             */
/*      RECREQ  0x0010                  error in return-receipt request    */
/*      FILIND  0x0020                  "indirect" att, direct has filespec*/
/*      FILATT  0x0040                  file is attached to this message   */
#define THEMSG  0x8000             /*   error occurred while writing msg   */

extern
int wrmpool,                       /* E-mail/Forums write msg pool handle  */
    csmaxcc;                       /* max # cc:s for C/S users             */

void
inicseml(void);                    /* initialize Client/Server E-mail agent*/

void
inicsfor(void);                    /* initialize Client/Server Forums agent*/

void
cssetup(void);                     /* set up stuff for C/S E-mail/Forums   */

void
efcurreq(                          /* set current request for E-mail/Forums*/
int reqid);                        /*   request ID to set to               */

BOOL                               /*   returns TRUE if a conflict         */
cscflchk(                          /* C/S conflict checker                 */
char *appid,                       /*   app ID to check for                */
void *work,                        /*   work area being used to read       */
unsigned forum,                    /*   forum ID w/possible conflict       */
long msgid);                       /*   message ID w/possible conflict     */

void
crd4att(void);                     /* cycled read message for att dl       */

void
rd4att(void);                      /* read message in prep for att dl      */

void
wrtnew(                            /* C/S write new message handler        */
struct saunam *dpknam,             /*   dynapak name in use                */
struct newdpk *new);               /*   dynapak contents                   */

void
wrtrpl(                            /* C/S write new message handler        */
struct saunam *dpknam,             /*   dynapak name in use                */
struct newdpk *new);               /*   dynapak contents                   */

void
gcclst(                            /* got cc: list for message             */
struct saunam *dpknam,             /*   dynapak name in use                */
char *cclist);                     /*   ';'-deliminated list of cc:s       */

void
uplatt(                            /* upload an attachment to a new msg    */
struct saunam *dpknam,             /*   dynapak name in use                */
struct filinf *finfo);             /*   file dynapak info structure        */

void
uladone(void);                     /* done uploading attachment to message */

void
uplabt(void);                      /* attachment upload aborted            */

void
wrtabt(void);                      /* message write request aborted        */

void
csfwd(                             /* C/S common forward-message function  */
struct saunam *dpknam,             /*   dynapak name in use                */
char *fwdinf);                     /*   address to fwd to/comments         */

void
cscopy(                            /* C/S common copy-message function     */
struct saunam *dpknam,             /*   dynapak name in use                */
char *cpyinf);                     /*   address to copy to/comments        */

int                                /*   returns GME status code            */
readir(                            /* read message with direction          */
int dir,                           /*   direction to read                  */
void *work,                        /*   GME work area                      */
struct message *msg,               /*   message header buffer              */
char *text);                       /*   message text buffer                */

void
cswrtup(void);                     /* set global ptrs to current write buf */

void
vdamsg(void);                      /* set msg and msgtxt to point at vdatmp*/

long
s2mn(                              /* converts string to msg# w/ error chk */
char *s);                          /*   string to convert                  */

int
s2rq(                              /* converts string to reqid w/error chk */
char *s);                          /*   string to convert                  */

char *                             /*   returns pointer to static buffer   */
longstr(                           /* convert long int to left-padded str  */
long n);                           /*   number to convert                  */

struct msgdpk *                    /*   returns copy of pointer to dest    */
msg2dpk(                           /* copy message to dynapak form         */
struct message *msg,               /*   message header                     */
char *text,                        /*   message text                       */
struct msgdpk *dmsg,               /*   message dynapak buffer             */
BOOL incltxt);                     /*   include message text in dmsg?      */

