/***************************************************************************
 *                                                                         *
 *   BTVSTF.H                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the header file for Btrieve utilities.                        *
 *                                                                         *
 *                                            - T. Stryker 6/24/86         *
 *                                                                         *
 ***************************************************************************/

#define SEGMAX  24                 /* max number of key segs per file      */
#define BBSTSZ  10                 /* setbtv()/rstbtv() btvptr stack size  */
#define MAXBTVP 56                 /* maximum length of btrieve path+file  */

struct btvblk {                    /* btrieve file data block definition   */
     long posblk[128/4];           /*   position block                     */
     char *filnam;                 /*   file name                          */
     int reclen;                   /*   maximum record length              */
     char *key;                    /*   key for searching, etc.            */
     char *data;                   /*   actual record contents             */
     int lastkn;                   /*   last key number used               */
     int keylns[SEGMAX];           /*   lengths of all possible keys       */
#ifdef ECLIPSE
     int realseg;                  /*   real segment of this data block    */
     int keyseg;                   /*   real segment of the key area       */
#endif
#ifdef PHARLAP
     int realseg;                  /*   real segment of this data block    */
     int keyseg;                   /*   real segment of the key area       */
#endif
};

extern
struct btvblk *bb;                 /* current btvu file pointer set        */

#define BTVFILE struct btvblk      /* shorthand for btrieve file structure */

                                   /* open modes passed to omdbtv()        */
#define PRIMBV  0                  /*   normal pre-image opnbtv() mode     */
#define ACCLBV -1                  /*   "accelerated" opnbtv() mode        */
#define RONLBV -2                  /*   read-only opnbtv() mode            */
#define VERFBV -3                  /*   vfy (read-after-write) opnbtv mode */
#define EXCLBV -4                  /*   "exclusive" opnbtv() mode          */

                                   /* file lock types for transactions     */
#define WAITBV   0                 /*   all ops within xaction should wait */
#define NOWTBV   200               /*    "   "     "     " should not wait */

                                   /* acquire/get/step operation lock types*/
#define SLWTBV 100                 /*   single record lock with wait       */
#define SLNWBV 200                 /*   single record lock with no wait    */
#define MLWTBV 300                 /*   multiple record lock with wait     */
#define MLNWBV 400                 /*   multiple record lock with no wait  */

#define qeqbtv(key,keynum) qrybtv(key, keynum,55)
#define qnxbtv()           qnpbtv(56)
#define qprbtv()           qnpbtv(57)
#define qgtbtv(key,keynum) qrybtv(key, keynum,58)
#define qgebtv(key,keynum) qrybtv(key, keynum,59)
#define qltbtv(key,keynum) qrybtv(key, keynum,60)
#define qlebtv(key,keynum) qrybtv(key, keynum,61)
#define qlobtv(keynum)     qrybtv(NULL,keynum,62)
#define qhibtv(keynum)     qrybtv(NULL,keynum,63)

#define gcrbtv(recp,keynum)     gabbtvl(recp,absbtv(),keynum,0)
#define geqbtv(recp,key,keynum) getbtvl(recp,key, keynum,5,0)
#define gnxbtv(recp)            getbtvl(recp,NULL,    -1,6,0)
#define gprbtv(recp)            getbtvl(recp,NULL,    -1,7,0)
#define ggtbtv(recp,key,keynum) getbtvl(recp,key, keynum,8,0)
#define ggebtv(recp,key,keynum) getbtvl(recp,key, keynum,9,0)
#define gltbtv(recp,key,keynum) getbtvl(recp,key, keynum,10,0)
#define glebtv(recp,key,keynum) getbtvl(recp,key, keynum,11,0)
#define globtv(recp,keynum)     getbtvl(recp,NULL,keynum,12,0)
#define ghibtv(recp,keynum)     getbtvl(recp,NULL,keynum,13,0)

#define acqbtv(recp,key,keynum) obtbtvl(recp,key, keynum,5,0)
#define aqnbtv(recp)            anpbtvlk(recp,          1,6,0)
#define aqpbtv(recp)            anpbtvlk(recp,          1,7,0)
#define anibtv(recp)            anpbtvlk(recp,          0,6,0)
#define apibtv(recp)            anpbtvlk(recp,          0,7,0)
#define agtbtv(recp,key,keynum) obtbtvl(recp,key, keynum,8,0)
#define agebtv(recp,key,keynum) obtbtvl(recp,key, keynum,9,0)
#define altbtv(recp,key,keynum) obtbtvl(recp,key, keynum,10,0)
#define alebtv(recp,key,keynum) obtbtvl(recp,key, keynum,11,0)
#define alobtv(recp,keynum)     obtbtvl(recp,NULL,keynum,12,0)
#define ahibtv(recp,keynum)     obtbtvl(recp,NULL,keynum,13,0)

#define slobtv(recp)            stpbtvl(recp,33,0)
#define snxbtv(recp)            stpbtvl(recp,24,0)
#define sprbtv(recp)            stpbtvl(recp,35,0)
#define shibtv(recp)            stpbtvl(recp,34,0)

/* Locking versions of the above functions:  */

#define gcrbtvl(recp,keynum,loktyp)     gabbtvl(recp,absbtv(),keynum,loktyp)
#define geqbtvl(recp,key,keynum,loktyp) getbtvl(recp,key, keynum,5,loktyp)
#define gnxbtvl(recp,loktyp)            getbtvl(recp,NULL,    -1,6,loktyp)
#define gprbtvl(recp,loktyp)            getbtvl(recp,NULL,    -1,7,loktyp)
#define ggtbtvl(recp,key,keynum,loktyp) getbtvl(recp,key, keynum,8,loktyp)
#define ggebtvl(recp,key,keynum,loktyp) getbtvl(recp,key, keynum,9,loktyp)
#define gltbtvl(recp,key,keynum,loktyp) getbtvl(recp,key, keynum,10,loktyp)
#define glebtvl(recp,key,keynum,loktyp) getbtvl(recp,key, keynum,11,loktyp)
#define globtvl(recp,keynum,loktyp)     getbtvl(recp,NULL,keynum,12,loktyp)
#define ghibtvl(recp,keynum,loktyp)     getbtvl(recp,NULL,keynum,13,loktyp)

#define acqbtvl(recp,key,keynum,loktyp) obtbtvl(recp,key, keynum,5,loktyp)
#define aqnbtvl(recp,loktyp)            anpbtvlk(recp,         1,6,loktyp)
#define aqpbtvl(recp,loktyp)            anpbtvlk(recp,         1,7,loktyp)
#define anibtvl(recp,loktyp)            anpbtvlk(recp,         0,6,loktyp)
#define apibtvl(recp,loktyp)            anpbtvlk(recp,         0,7,loktyp)
#define agtbtvl(recp,key,keynum,loktyp) obtbtvl(recp,key, keynum,8,loktyp)
#define agebtvl(recp,key,keynum,loktyp) obtbtvl(recp,key, keynum,9,loktyp)
#define altbtvl(recp,key,keynum,loktyp) obtbtvl(recp,key, keynum,10,loktyp)
#define alebtvl(recp,key,keynum,loktyp) obtbtvl(recp,key, keynum,11,loktyp)
#define alobtvl(recp,keynum,loktyp)     obtbtvl(recp,NULL,keynum,12,loktyp)
#define ahibtvl(recp,keynum,loktyp)     obtbtvl(recp,NULL,keynum,13,loktyp)

#define slobtvl(recp,loktyp)            stpbtvl(recp,33,loktyp)
#define snxbtvl(recp,loktyp)            stpbtvl(recp,24,loktyp)
#define sprbtvl(recp,loktyp)            stpbtvl(recp,35,loktyp)
#define shibtvl(recp,loktyp)            stpbtvl(recp,34,loktyp)

#define ulsbtv()                        unlbtv(NULL,0)
#define ulmbtv()                        unlbtv(absbtv(),-1)
#define ulobtv(f)                       unlbtv((f),-1)
#define ulabtv()                        unlbtv(NULL,-2)

#ifdef MSC_C
#define XREG                WORDREGS
#endif

/* BTVSTF.C 19/01/92 16.09.26 */
BTVFILE *opnbtv (char *filnam, int maxlen);
BTVFILE *opnbtvl (char *filnam, int maxlen, char *owner);
void omdbtv (int mode);
void setbtv (struct btvblk *bbptr);
void rstbtv (void);
void bxabtv(int loktyp);
void exabtv(void);
int qrybtv (void *key, int keynum, int qryopt);
int qnpbtv (int getopt);
void getbtv (void *recptr, void *key, int keynum, int getopt);
void getbtvl (void *recptr, void *key, int keynum, int getopt, int loktyp);
int obtbtv (void *recptr, void *key, int keynum, int obtopt);
int obtbtvl (void *recptr, void *key, int keynum, int obtopt, int loktyp);
int anpbtv (void *recptr, int anpopt);
int anpbtvl (void *recptr, int chkcas, int anpopt);
int anpbtvlk (void *recptr, int chkcas, int anpopt, int loktyp);
int llnbtv (void);
long absbtv (void);
void gabbtv (void *recptr, long abspos, int keynum);
void gabbtvl (void *recptr, long abspos, int keynum, int loktyp);
int aabbtv (void *recptr, long abspos, int keynum);
int aabbtvl (void *recptr, long abspos, int keynum, int loktyp);
int stpbtv (void *recptr, int stpopt);
int stpbtvl (void *recptr, int stpopt, int loktyp);
void updbtv (void *recptr);
void upvbtv (void *recptr, int length);
int dupdbtv (void *recptr);
void insbtv (void *recptr);
void invbtv (void *recptr, int length);
int dinsbtv (void *recptr);
void delbtv (void);
void clsbtv (struct btvblk *bbp);
void crtbtv (char *filnam, void *databuf, int lendbuf, int keyno);
long cntrbtv (void);
void sttbtv (int len);
int rlenbtv (void);
void unlbtv (long abspos, int keynum);
int wslbtv (void);
