/***************************************************************************
 *                                                                         *
 *   BBSMAINM.C                                                            *
 *                                                                         *
 *   Copyright (C) 1993 Consensus Systems, Inc.  All rights reserved.      *
 *   Copyright (C) 1993-1995 Galacticomm, Inc.  All rights reserved.       *
 *                                                                         *
 *   This is the Galacticomm Client/Server main menu agent.                *
 *                                                                         *
 *                                              - T. Stryker 11/26/93      *
 *                                                C. Robert                *
 *                                                B. Love                  *
 *                                                D. Pitchford 6/9/94      *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "bbsmainm.h"

#define FILREV "$Revision:   1.0.1.1.1.0  $"

void mmuwrite(struct saunam *dpknam,unsigned length,void *value);
void mmuxdone(void);
void mmuabort(void);
void mmuread(int direction,struct saunam *dpknam);
void dpkmenu(int direction);
void dpkstart(int direction);
void dpkiconf(int direction);
void dpkappif(int direction);
void dpkrecnt(void);
void dpkusron(void);
void dpkfpage(void);
void dpkexefl(void);
void dpksupfl(void);
void dpksupfs(void);
void dpkappth(void);
void dontzap(void);
void sendpage(char *override);
char *autosel(struct mnupag *autmnu);
BOOL hasaxs(struct mnupag *page);
void startups(void);
void invis(BOOL inv);
void pagestat(BOOL ison,BOOL isok);
void pageuser(char *uid,char *msg);
int pagcsusr(char *from,char *msg);
BOOL isintop(char *pagnam);
void gappnams(void);
char *appid(char *modnam);
void announce(int direction);
BOOL annvec(void);
void annvecyc(void);

#define ICONDIR  "WGSICONS\\"      /* local directory for icon files       */
#define ICONEXT  ".ICO"            /* extension for icon files             */
#define DEFICO   "WGSDEF"          /* default icon file name               */
#define IMGICO   "WGSIMAGE"        /* default system icon file name        */
#define PKEYSIZE (1+2*PNMSIZ)      /* menu page key size                   */
#define ICOPSIZE (MAXPATH+1+FNEXSZ)/* icon path with ; and suggestion fnam */
#define MDATSZ (TITLSZ+MAXSEL*(PNMSIZ+SHDSIZ+LNDSIZ+FNSIZE))
#define MAINMAPP "BBSMAINM"

STATIC
struct agent mmuagt={              /* agent information structure          */
     MAINMAPP,                     /*   appid                              */
     mmuread,                      /*   read-dynapak function pointer      */
     mmuwrite,                     /*   write-dynapak function pointer     */
     mmuxdone,                     /*   file xfer-done function pointer    */
     mmuabort                      /*   abort-request function pointer     */
};

struct cshdr {                     /* three page types after common data   */
     int pagetype;                 /*   page type 0=menu, 1=mod, 2=file    */
     char pagnam[PNMSIZ-1];        /*   page name                          */
     BOOL access;                  /*   has access to the page             */
     BOOL cango;                   /*   has access to FIND/GO the page     */
};

struct csmenu {                    /* menu page                            */
     struct cshdr hdr;             /*   common header to pages             */
     BOOL iconmenu;                /*   VBTRUE: icons   FALSE: listbox     */
     BOOL autosel;                 /*   autoselect menu                    */
     long ichange;                 /*   time code of changes to icons      */
     int nopts;                    /*   number of selections on the menu   */
     char data[MDATSZ];            /*   menu data                          */
};

#define csmenupg ((struct csmenu *)rsptmp)

struct csmod {                     /* module page                          */
     struct cshdr hdr;             /*   common header to pages             */
     int modutype;                 /*   mod type: 0=C/S 1=A/A              */
     char appid[AIDSIZ-1];         /*   appid of executable                */
     char cmdstg[CMDSIZ-1];        /*   command stg for entry to module    */
};

#define csmodpg ((struct csmod *)rsptmp)

struct csfile {                    /* file page                            */
     struct cshdr hdr;             /*   common header to pages             */
     char filname[FNEXSZ-1];       /*   file name (w/ ext.) being shown    */
     char caption[LNDSIZ-1];       /*   window caption to put on display   */
};

#define csfilepg ((struct csfile *)rsptmp)

STATIC
struct startup {                   /* singly linked list of startup apps   */
     char appid[AIDSIZ];                /* App-ID                          */
     struct startup *next;              /* next startup app                */
} *cssfirst=NULL;

struct options {                   /* main menu options                    */
     BOOL invis;                   /*   user is invisible (unsec.)         */
     BOOL pageon;                  /*   user's page is on/off              */
     BOOL pageok;                  /*   user is /P OK                      */
     BOOL caninv;                  /*   user can toggle invis (unsec.)     */
     BOOL canlook;                 /*   user can lookup users (unsec.)     */
     int pagint;                   /*   page interval in minutes           */
};

struct mmrqi {                     /* per request information              */
     int reqtype;                  /*   type of request                    */
     int index;                    /*   request index for announce()       */
};

/* NOTE: the size of this structure MUST match the #define ANNOSIZE        */

#define mmptr ((struct mmrqi *)mrqptr)

#define MMRQNULL 0                 /* ordinary request                     */
#define MMRQANNO 1                 /* announcement request                 */
#define MMRQMENU 2                 /* downloading main menu                */


static
struct appref {                    /* cross-reference app-id to module name*/
     char appid[AIDSIZ];           /*   appid                              */
     char modnam[MNMSIZ];          /*   module name                        */
} *apps;                           /*   app elements loaded                */

static
int numapps;                       /* number of elements in **dlls         */

extern
BTVFILE *mnubb;                    /* menu information btrieve file pointer*/

static
struct mnupag mnutmp,mnutmp2;      /* temporary menu pages for access check*/

static
char *wgsicon,                     /* actual bbs icon file name, w/o ext.  */
     *aboutmsg,                    /* message, if any, for About... box    */
     *eggappid,                    /* appid for easter egg                 */
     *longdesc,                    /* long description set by hasaxs()     */
     *shrtdesc;                    /* short description set by hasaxs()    */

static
struct saunam *rspdpk;             /* modifiable copy of req. dynapak hdr. */

void EXPORT
init__bbsmainm(void)               /* agent initialization routine         */
{
     FILE *msgfil;
     char *sptr;

     register_agent(&mmuagt);
     msgfil=opnmsg("BBSMAINM.MCV");
     dclmrq(sizeof(struct mmrqi));
     wgsicon=getmsg(ABOUTICO);
     if ((sptr=strchr(wgsicon,'.')) != NULL) {
          *sptr='\0';
     }
     if (*wgsicon == '\0') {
          wgsicon=IMGICO;
     }
     else {
          wgsicon=strcpy(alcmem(strlen(wgsicon)+1),wgsicon);
     }
     eggappid=stgopt(EGGIE);
     stp4cs(sptr=getmsg(ABOUTLIN));
     while (sptr[0] == '\n') {
          sptr++;
     }
     while (strlen(sptr) > 0 && sptr[strlen(sptr)-1] == '\n') {
          sptr[strlen(sptr)-1]='\0';
     }
     strcpy(aboutmsg=alcmem(strlen(sptr)+1),sptr);
     clsmsg(msgfil);
     setmem(&mnutmp,sizeof(struct mnupag),0);
     setmem(&mnutmp2,sizeof(struct mnupag),0);
     rspdpk=(struct saunam *)alcmem(sizeof(struct saunam));
     gappnams();
     startups();
     cspagerou=pagcsusr;
}

STATIC void
mmuread(                           /* read-dynapak handler                 */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     char *dpkstg;
     char icopath[ICOPSIZE];
     struct fndblk fb;
     struct options opts;

     *rspdpk=*dpknam;
     dpkstg=cnvs2d(rspdpk);
     mmptr->reqtype=MMRQNULL;
     if (samepato("sa:appinfo ",dpkstg)
         || samepato("saf:appfile ",dpkstg)) {
          dpkappif(direction);
          return;
     }
     if (!stdchk("")) {  /* ALL HANDLERS AFTER THIS POINT ARE stdchk()'D */
          rejectreq();
          return;
     }
     if (samepato("sau:announce ",dpkstg)) {
          announce(direction);
          return;
     }
     if (samepato("sau:menu ",dpkstg)) {
          dpkmenu(direction);
          return;
     }
     if (samepato("sa:startup ",dpkstg)) {
          dpkstart(direction);
          return;
     }
     if (samepato("sauf:iconfile ",dpkstg)) {
          dpkiconf(direction);
          return;
     }
     if (direction != 0) {  /* ALL HANDLERS AFTER THIS ARE NONDIRECTIONAL */
          rejectreq();
          return;
     }
     if (samepat("sa:recents",dpkstg)) {
          dpkrecnt();
          return;
     }
     if (samepat("sa:about",dpkstg)) {
          sprintf(vdatmp,"%s %s",bturno,aboutmsg);
          rsp2read(rspdpk,STGLEN,vdatmp);
          return;
     }
     if (samepat("sa:about eggie",dpkstg)) {
          rsp2read(rspdpk,STGLEN,eggappid);
          return;
     }
     if (samepat("saf:sysicon",dpkstg)) {
          sprintf(icopath,"%s%s%s",ICONDIR,wgsicon,ICONEXT);
          if (fnd1st(&fb,icopath,0) && fb.size < 2048L) {
               strcat(icopath,";");
               strcat(icopath,IMGICO);
               strcat(icopath,ICONEXT);
               rsp2read(rspdpk,STGLEN,icopath);
          }
          else {
               rejectreq();
          }
          return;
     }
     if (samepat("sau:options",dpkstg)) {
          opts.invis=(usrptr->flags&INVISB) ? VBTRUE : FALSE;
          opts.pageon=pageset != NULL
                                   && (*pageset)() == 3 ? VBTRUE : FALSE;
          opts.pageok=pageset != NULL
                                   && (*pageset)() == 1 ? VBTRUE : FALSE;
          opts.caninv=haskey(glbkeyi) ? VBTRUE : FALSE;
          opts.canlook=haskey(glbkey) ? VBTRUE : FALSE;
          opts.pagint=(gpirou == NULL ? gpagint : gpirou(usrnum))/60;
          rsp2read(rspdpk,sizeof(struct options),&opts);
          return;
     }
     if (samepat("sa:userson",dpkstg)) {
          dpkusron();
          return;
     }
     if (samepato("saf:fpage ",dpkstg)) {
          dpkfpage();
          return;
     }
     if (samepato("saf:exefile ",dpkstg)) {
          dpkexefl();
          return;
     }
     if (samepato("saf:supfile ",dpkstg)) {
          dpksupfl();
          return;
     }
     if (samepato("sa:supfiles ",dpkstg)) {
          dpksupfs();
          return;
     }
     if (samepato("sa:apppath ",dpkstg)) {
          dpkappth();
          return;
     }
     rejectreq();
}

STATIC void
dpkmenu(                           /* find menu page to return on request  */
int direction)                          /* read direction                  */
{
     char pagkey[PKEYSIZE];

     pagkey[0]='C';
     pagkey[1]='\0';
     if (sameto("menu ",rspdpk->suffix)) {
          stzcpy(&pagkey[1],&rspdpk->suffix[5],PNMSIZ);
     }
     setbtv(mnubb);
     switch (direction) {
     case 0:
          if (!acqbtv(menupg,pagkey,0)) {
               rejectreq();
               return;
          }
          break;
     case 1:
          if (!agtbtv(menupg,pagkey,0) || pagkey[0] != menupg->menutype[0]) {
               rejectreq();
               return;
          }
          break;
     case -1:
          if (!altbtv(menupg,pagkey,0) || pagkey[0] != menupg->menutype[0]) {
               rejectreq();
               return;
          }
          break;
     default:
          rejectreq();
          return;
     }
     sprintf(rspdpk->suffix,"menu %s",menupg->pagnam);
     sendpage("");
}

STATIC void
dpkstart(                          /* tell what appid's are startup apps   */
int direction)                          /* read direction                  */
{
     char *s;
     int idx;
     struct startup *cur;

     s=&rspdpk->suffix[8];
     idx=atoi(s)+direction;
     if (idx < 0) {
          rejectreq();
          return;
     }
     if ((s=strrchr(rspdpk->suffix,' ')) == NULL) {
          rejectreq();
          return;
     }
     sprintf(++s,"%02d",idx);
     cur=cssfirst;
     while (cur != NULL) {
          if (idx-- == 0) {
               rsp2read(rspdpk,STGLEN,cur->appid);
               return;
          }
          cur=cur->next;
     }
     rejectreq();
}

STATIC void
dpkiconf(                          /* transfer icon file                   */
int direction)                          /* read direction                  */
{
     struct fndblk fb;
     char pagkey[PKEYSIZE];
     char icopath[ICOPSIZE];
     char *s,*icofile;
     int idx,i,pg=0;

     pagkey[0]='C';
     stzcpy(&pagkey[1],&rspdpk->suffix[9],2*PNMSIZ);
     if ((s=strchr(pagkey,' ')) == NULL) {
          rejectreq();
          return;
     }
     *s++='\0';
     if (*s == '\0') {
          idx=0;
     }
     else {
          idx=atoi(s)+direction;
     }
     if (idx < 0 || idx >= MAXSEL) {
          rejectreq();
          return;
     }
     if ((s=strrchr(rspdpk->suffix,' ')) == NULL) {
          rejectreq();
          return;
     }
     sprintf(++s,"%02d",idx);
     setbtv(mnubb);
     if ((!sameas(mnutmp2.menutype,pagkey) && !acqbtv(&mnutmp2,pagkey,0))
        || (mnutmp2.flags&(MDLPAG|FILPAG))
        || !(mnutmp2.flags&DFTDSP)
        || !hasaxs(&mnutmp2)) {
          rejectreq();
          return;
     }
     do {
          s=autosel(&mnutmp2);
     } while (*s != '\0');
     for (i=0 ; i < mnutmp2.npages ; i++) {
          if (haskey(mnutmp2.page[i].keyreq)
            || mnutmp2.page[i].optdsp != 0) {
               if (pg == idx) {
                    break;
               }
               else {
                    pg++;
               }
          }
     }
     if (i >= mnutmp2.npages) {
          rejectreq();
          return;
     }
     icofile=mnutmp2.page[i].iconame;
     if (icofile[0] == '\0') {
          icofile=DEFICO;
     }
     sprintf(icopath,"%s%s%s",ICONDIR,icofile,ICONEXT);
     while (!fnd1st(&fb,icopath,0) || fb.size > 2048L) {
          if (icofile == DEFICO) {
               rejectreq();
               return;
          }
          else {
               icofile=DEFICO;
               sprintf(icopath,"%s%s%s",ICONDIR,icofile,ICONEXT);
          }
     }
     strcat(icopath,";");
     strcat(icopath,icofile);
     strcat(icopath,ICONEXT);
     rsp2read(rspdpk,STGLEN,icopath);
}

STATIC void
dpkfpage(void)                      /* transfer file page file             */
{
     struct fndblk fb;
     int i;
     BOOL good=FALSE;
     char fpath[MAXPATH];
     char pagkey[PKEYSIZE];
     static struct mnupag tmpag;

     pagkey[0]='C';
     stzcpy(&pagkey[1],&rspdpk->suffix[6],2*PNMSIZ);
     setbtv(mnubb);
     if (!acqbtv(&mnutmp2,pagkey,0)) {
          rejectreq();
          return;
     }
     if ((mnutmp2.flags&(AUTPAG|FILPAG)) == AUTPAG) {
          for (i=0 ; i < mnutmp2.npages; i++) {
               stzcpy(&pagkey[1],mnutmp2.page[i].destpage,PNMSIZ);
               if (acqbtv(&tmpag,pagkey,0) && hasaxs(&tmpag)) {
                    if (tmpag.flags&FILPAG) {
                         movmem(&tmpag,&mnutmp2,sizeof(struct mnupag));
                         good=TRUE;
                         break;
                    }
                    else {
                         rejectreq();
                         return;
                    }
               }
          }
          if (!good) {
               rejectreq();
               return;
          }
     }
     else if (!(mnutmp2.flags&FILPAG) || !hasaxs(&mnutmp2)) {
          rejectreq();
          return;
     }
     stzcpy(fpath,mnutmp2.fname,MAXPATH);
     if (!fnd1st(&fb,fpath,0)) {
          rejectreq();
          shocst("C/S FILE PAGE FILE MISSING","%s %s",mnutmp2.pagnam,fpath);
          return;
     }
     rsp2read(rspdpk,STGLEN,fpath);
}

STATIC void
dpkexefl(void)                     /* transfer app executable              */
{
     struct fndblk fb;
     struct saunam local;
     char appid[AIDSIZ],exepath[MAXPATH];

     stzcpy(appid,&rspdpk->suffix[8],AIDSIZ);
     setmem(&local,sizeof(struct saunam),0);
     stzcpy(local.appid,MAINMAPP,AIDSIZ);
     stzcpy(local.suffix,spr("appinfo %s",appid),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0) {
          rejectreq();
          return;
     }
     local.flags=FLGFIL;
     stzcpy(local.suffix,spr("appfile %s EXE",appid),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0) {
          rejectreq();
          return;
     }
     stzcpy(exepath,GDPBTR->value,MAXPATH);
     if (!fnd1st(&fb,exepath,0)) {
          rejectreq();
          return;
     }
     rsp2read(rspdpk,STGLEN,exepath);
}

STATIC void
dpksupfl(void)                     /* transfer support file                */
{
     struct saunam local;
     char *s,appid[AIDSIZ];
     int idx;

     if ((s=strrchr(rspdpk->suffix,' ')) != NULL) {
          *s++='\0';
          idx=atoi(s);
     }
     else {
          rejectreq();
          return;
     }
     stzcpy(appid,&rspdpk->suffix[8],AIDSIZ);
     setmem(&local,sizeof(struct saunam),0);
     stzcpy(local.appid,MAINMAPP,AIDSIZ);
     stzcpy(local.suffix,spr("appinfo %s",appid),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0
        || (s=strrchr(GDPBTR->value,'\n')) == NULL || idx >= atoi(++s)) {
          rejectreq();
          return;
     }
     local.flags=FLGFIL;
     stzcpy(local.suffix,spr("appfile %s %d",appid,idx),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0) {
          rejectreq();
          return;
     }
     rsp2read(rspdpk,STGLEN,GDPBTR->value);
}

STATIC void
dpksupfs(void)                     /* send all support file names          */
{
     char *s,appid[AIDSIZ];
     struct saunam local;
     int idx,nsupfl;

     setmem(&local,sizeof(struct saunam),0);
     stzcpy(local.appid,MAINMAPP,AIDSIZ);
     stzcpy(appid,&rspdpk->suffix[9],AIDSIZ);
     stzcpy(local.suffix,spr("appinfo %s",appid),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0
        || (s=strrchr(GDPBTR->value,'\n')) == NULL) {
          rejectreq();
          return;
     }
     nsupfl=atoi(++s);
     local.flags=FLGFIL;
     vdatmp[0]='\0';
     for (idx=0 ; idx < nsupfl ; idx++) {
          stzcpy(local.suffix,spr("appfile %s %d",appid,idx),SFXSIZ);
          if (readgdp(0,&local,0,NULL) == 0) {
               rejectreq();
               return;
          }
          strcat(vdatmp,GDPBTR->value);
          strcat(vdatmp," "); /* note: space is required after last element */
     }
     rsp2read(rspdpk,STGLEN,vdatmp);
}

STATIC void
dpkappif(                          /* return information on an app         */
int direction)                     /*   read direction                     */
{
     char *appid;

     if (!sameas(rspdpk->sysid,msysid)) {
          rejectreq();
          return;
     }
     appid=firstwd(skpwht(skpwrd(rspdpk->suffix)));
     if (sameas(appid,supappid) || sameas(appid,MAINMAPP)) {
          cycleme(dontzap);
          mmptr->reqtype=MMRQMENU;
     }
     if (!stdchk("") && !sameas(appid,supappid)) {
          rejectreq();
          return;
     }
     r2rgdp(direction,rspdpk);
}

STATIC void
dpkappth(void)                     /* send app exe file name and info.     */
{
     char appid[AIDSIZ],path[2*MAXPATH];
     struct saunam local;

     stzcpy(appid,&rspdpk->suffix[8],AIDSIZ);
     setmem(&local,sizeof(struct saunam),0);
     stzcpy(local.appid,MAINMAPP,AIDSIZ);
     stzcpy(local.suffix,spr("appinfo %s",appid),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0) {
          rejectreq();
          return;
     }
     local.flags=FLGFIL;
     stzcpy(local.suffix,spr("appfile %s EXE",appid),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0) {
          rejectreq();
     }
     else {
          stzcpy(path,GDPBTR->value,2*MAXPATH);
          stzcat(path," ",2*MAXPATH);
          stzcpy(local.suffix,spr("appinfo %s",appid),SFXSIZ);
          local.flags=0;
          if (readgdp(0,&local,0,NULL) == 0) {
               rejectreq();
          }
          else {
               stzcat(path,GDPBTR->value,2*MAXPATH);
               rsp2read(rspdpk,STGLEN,path);
          }
     }
}

STATIC void
dpkrecnt(void)                     /* info on one recent caller            */
{
     char *uid,*buf,*tim;
     int idx;
     struct recalls *rv;

     buf=prfbuf;
     for (idx=0 ; idx < nreccl ; idx++) {
          rv=&recents[idx];
          uid=rv->userid;
          if (uid[0] != '\0') {
               tim=nctime(rv->logon);
               *buf++=atoi(&tim[0])+32;
               *buf++=atoi(&tim[3])+32;
               *buf++=atoi(&tim[6])+32;
               tim=nctime(rv->logoff);
               *buf++=atoi(&tim[0])+32;
               *buf++=atoi(&tim[3])+32;
               *buf++=atoi(&tim[6])+32;
               sprintf(buf,"%s%c",uid,9);
               buf+=strlen(uid)+1;
          }
     }
     if (buf == prfbuf) {
          rejectreq();
     }
     else {
          rsp2read(rspdpk,(int)(buf-prfbuf),prfbuf);
     }
}

STATIC void
dpkusron(void)                     /* return all users online              */
{
     int idx;

     clrmlt();
     for (idx=0 ; idx < nterms ; idx++) {
          if (user[idx].class >= SUPLON && !(user[idx].flags&INVISB)) {
               prf("%s%s%c",spr("%02X",channel[idx]),uacoff(idx)->userid,9);
          }
     }
     rsp2read(rspdpk,STGLEN,prfbuf);
}

STATIC void
dontzap(void)                      /* prevent user from idling offline     */
{
     usrptr->usetmr=0;
     if (!(usrptr->flags&NOINJO)) {
          usrptr->flags|=NOINJO;  /* no pages while receiving system file  */
     }
}

STATIC void
sendpage(                          /* send the page found                  */
char *override)                         /* overriding page name for autsel */
{
     int i,typ;
     BOOL axs;
     char *s,*stg,*ldesc,*sdesc;
     struct cshdr *header;

     for (i=menupg->npages ; i < MAXSEL ; i++) {
          setmem(&menupg->page[i],sizeof(struct pglink),0);
     }
     if (menupg->flags&FILPAG) {
          typ=2;
          header=&csfilepg->hdr;
     }
     else if (menupg->flags&MDLPAG) {
          typ=1;
          header=&csmodpg->hdr;
     }
     else {
          if (*(s=autosel(menupg)) != '\0') {
               sendpage(s);
               return;
          }
          typ=0;
          header=&csmenupg->hdr;
     }
     c2bcpy(header->pagnam,override[0] == '\0' ? menupg->pagnam : override,
        PNMSIZ-1);
     longdesc="";
     shrtdesc="";
     axs=override[0] != '\0' || hasaxs(menupg);
     ldesc=longdesc; /* set by hasaxs() */
     sdesc=shrtdesc; /* set by hasaxs() */
     header->cango=((menupg->flags&CNGOTO) && haskey(menupg->golock)
        && override[0] == '\0' && axs);
     if (typ == 0 && axs && !header->cango
        && sameas(menupg->parpag,"TOP") && !sameas(menupg->pagnam,"TOP")) {
          axs=isintop(menupg->pagnam);
     }
     header->access=(axs ? VBTRUE : FALSE);
     header->cango=(header->cango ? VBTRUE : FALSE);
     header->pagetype=typ;
     switch (typ) {
     case 0: /* menu */
          csmenupg->iconmenu=((menupg->flags&DFTDSP) ? VBTRUE : FALSE);
          csmenupg->autosel=(override[0] != '\0' ? VBTRUE : FALSE);
          csmenupg->ichange=menupg->ichange;
          csmenupg->nopts=0;
          setmem(csmenupg->data,MDATSZ,0);
          if (!axs) {
               rsp2read(rspdpk,sizeof(struct csmenu)-MDATSZ,csmenupg);
               break;
          }
          sprintf(csmenupg->data,"%s\t",menupg->mnuttl);
          for (i=0 ; i < MAXSEL ; i++) {
               if ((haskey(menupg->page[i].keyreq)
                       || menupg->page[i].optdsp > 0)
                       && menupg->page[i].selchr != '\0') {
                    strcat(csmenupg->data,menupg->page[i].destpage);
                    strcat(csmenupg->data,"\t");
                    strcat(csmenupg->data,menupg->page[i].shortd);
                    strcat(csmenupg->data,"\t");
                    strcat(csmenupg->data,menupg->page[i].longd);
                    strcat(csmenupg->data,"\t");
                    strcat(csmenupg->data,menupg->page[i].iconame);
                    strcat(csmenupg->data,"\t");
                    csmenupg->nopts++;
               }
          }
          rsp2read(rspdpk,
             sizeof(struct csmenu)-MDATSZ+strlen(csmenupg->data),csmenupg);
          break;
     case 1: /* module */
          csmodpg->modutype=((menupg->flags&CSMPAG) ? 0 : 1);
          c2bcpy(csmodpg->appid,axs ? appid(menupg->modnam) : "",AIDSIZ-1);
          c2bcpy(csmodpg->cmdstg,axs ? menupg->cmdstg : "",CMDSIZ-1);
          rsp2read(rspdpk,sizeof(struct csmod),csmodpg);
          break;
     case 2: /* file */
          stg=axs ? menupg->fname : "";
          while ((s=strchr(stg,'\\')) != NULL) {
               stg=++s;
          }
          c2bcpy(csfilepg->filname,stg,FNEXSZ-1);
          stg=ldesc[0] == '\0' ? sdesc : ldesc;
          c2bcpy(csfilepg->caption,(axs ? stg : ""),LNDSIZ-1);
          rsp2read(rspdpk,sizeof(struct csfile),csfilepg);
          break;
     default:
          rejectreq();
     }
}

STATIC BOOL
isintop(                           /* page is selectable from TOP          */
char *pagnam)
{
     int i;
     static struct mnupag tmpag;

     setbtv(mnubb);
     if (acqbtv(&tmpag,"CTOP",0)) {
          for (i=0 ; i < tmpag.npages ; i++) {
               if (sameas(pagnam,tmpag.page[i].destpage)) {
                    return(TRUE);
               }
          }
     }
     return(FALSE);
}

STATIC char *
autosel(                           /* auto-select menu page support        */
struct mnupag *autmnu)
{
     int i;
     char pagkey[PKEYSIZE];
     static struct mnupag tmpag;
     static char oldnam[PNMSIZ];

     oldnam[0]='\0';
     if (autmnu->flags&AUTPAG) {
          pagkey[0]='C';
          setbtv(mnubb);
          for (i=0 ; i < autmnu->npages; i++) {
               stzcpy(&pagkey[1],autmnu->page[i].destpage,PNMSIZ);
               if (haskey(autmnu->page[i].keyreq) && pagkey[1] != '\0') {
                    if (acqbtv(&tmpag,pagkey,0)) {
                         stzcpy(oldnam,autmnu->pagnam,PNMSIZ);
                         movmem(&tmpag,autmnu,sizeof(struct mnupag));
                         return(oldnam);
                    }
               }
          }
     }
     return("");
}

STATIC BOOL
hasaxs(                            /* user has direct access to page       */
struct mnupag *page)                    /* page to test                    */
{
     BOOL access,found=FALSE;
     int i;

     setbtv(mnubb);
     if (sameas("TOP",page->pagnam)) {
          access=TRUE;
     }
     else {
          if (page->parpag[0] == '\0'
             || !acqbtv(&mnutmp,spr("C%s",page->parpag),0)) {
               access=TRUE;
          }
          else {
               access=FALSE;
               for (i=0 ; i < mnutmp.npages ; i++) {
                    if (sameas(mnutmp.page[i].destpage,page->pagnam)) {
                         found=TRUE;
                         access=haskey(mnutmp.page[i].keyreq);
                         longdesc=mnutmp.page[i].longd;
                         shrtdesc=mnutmp.page[i].shortd;
                         break;
                    }
               }
               if (!found && sameas(page->parpag,"TOP")) {
                    access=TRUE; /* orphan */
               }
          }
     }
     return(access);
}

STATIC void
startups(void)                     /* determine startup apps               */
{
     struct startup **cur;

     cur=&cssfirst;
     if (tfsopn("MJRBBS.CFG") == 0) {
          catastro("BBSMAINM: Can't find MJRBBS.CFG!");
     }
     while (tfsrdl() != TFSDUN) {
          if (tfstate == TFSLIN && tfspfx("CSTART=")) {
               *cur=(struct startup *)alczer(sizeof(struct startup));
               (*cur)->next=NULL;
               stzcpy((*cur)->appid,tfspst,AIDSIZ);
               cur=&(*cur)->next;
          }
     }
}

STATIC void
mmuwrite(                          /* write-dynapak handler                */
struct saunam *dpknam,             /*   dynapak name to write              */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value to write             */
{
     char *dpkstg;
     struct options opts;

     if (!stdchk("")) {
          rejectreq();
          return;
     }
     dpkstg=cnvs2d(dpknam);
     mmptr->reqtype=MMRQNULL;
     if (samepat("sau:options",dpkstg)) {
          if (length >= sizeof(struct options)) {
               movmem(value,&opts,sizeof(struct options));
               invis(opts.invis);
               pagestat(opts.pageon,opts.pageok);
               rsp2write(TRUE,0,NULL);
               return;
          }
     }
     if (sameas(dpknam->suffix,"page") && sameas(dpknam->sysid,msysid)) {
          pageuser(dpknam->usrid,value);
          return;
     }
     rejectreq();
}

STATIC void
mmuxdone(void)                     /* file transfer-done handler           */
{
     if (mmptr->reqtype == MMRQMENU) {
          usrptr->flags&=~NOINJO;  /* page on, main menu file received */
     }
}

STATIC void
mmuabort(void)                     /* abort-request handler                */
{
     if (mmptr->reqtype == MMRQMENU) {
          usrptr->flags&=~NOINJO;  /* page on, main menu file receive abort */
     }
}

STATIC void
invis(                             /* become visible/invisible             */
BOOL inv)
{
     if (haskey(glbkeyi)) {
          if (inv) {
               usrptr->flags|=INVISB;
               usaptr->flags|=GOINVB;
          }
          else {
               usrptr->flags&=~INVISB;
               usaptr->flags&=~GOINVB;
          }
     }
}

STATIC void
pagestat(                          /* set page on/off/ok                   */
BOOL ison,                              /* is to be set on?                */
BOOL isok)                              /* is to be set ok (priority)?     */
{
     if (spageset != NULL) {
          (*spageset)(ison,isok);
     }
}

STATIC void
pageuser(                          /* page user with message               */
char *uid,                              /* user to page                    */
char *msg)                              /* message to page                 */
{
     BOOL okpage;
     char usrid[UIDSIZ];

     if (pagerou == NULL) {
          rejectreq();
          return;
     }
     stzcpy(usrid,uid,UIDSIZ);
     okpage=((*pagerou)(usrid,msg) == 1) ? TRUE : FALSE;
     if (okpage) {
          clrprf();
     }
     r2wprf(okpage);
}

STATIC int
pagcsusr(                          /* page c/s user with a message         */
char *from,                             /* user the message is from        */
char *msg)                              /* message to send                 */
{
     setmem(rspdpk,sizeof(struct saunam),0);
     if (!(othusp->flags&NOINJO)) {
          if (cnvd2s(spr("su=%s;:pgf %s",othuap->userid,from),rspdpk)) {
               senddpk(othusn,MAINMAPP,NORMAL,rspdpk,STGLEN,msg);
               return(1);
          }
     }
     return(0);
}

STATIC void
gappnams(void)                     /* get module names vs. appids          */
{
     numapps=0;
     if (tfsopn("MJRBBS.CFG") == 0) {
          catastro("Can't find APP list (MJRBBS.CFG)!");
     }
     while (tfsrdl() != TFSDUN) {
          if (tfstate == TFSLIN && tfspfx("APP=")) {
               numapps++;
          }
     }
     if (numapps == 0) {
          return;
     }
     apps=(struct appref *)alczer(numapps*sizeof(struct appref));
     numapps=0;
     if (tfsopn("MJRBBS.CFG") == 0) {
          catastro("Can't find APP list (MJRBBS.CFG)!");
     }
     while (tfsrdl() != TFSDUN) {
          if (tfstate == TFSLIN && tfspfx("APP=")) {
               stzcpy(apps[numapps].appid,firstwd(tfspst),AIDSIZ);
               stzcpy(apps[numapps].modnam,skpwht(skpwrd(tfspst)),MNMSIZ);
               numapps++;
          }
     }
}

STATIC char *
appid(                             /* given module name, return its appid  */
char *modnam)
{
     int i;
     struct appref *dr;

     for (i=0 ; i < numapps ; i++) {
          dr=&apps[i];
          if (sameas(dr->modnam,modnam)) {
               return(dr->appid);
          }
     }
     return("");
}

STATIC void
announce(                          /* respond with announcements           */
int direction)                     /*   index direction                    */
{
     char *s;

     setmem(mrqptr,mrqsiz,0);
     mmptr->reqtype=MMRQANNO;
     s=skpwht(skpwrd(rspdpk->suffix));
     if (*s == '\0') {
          if (direction > 0) {
               mmptr->index=0;
          }
          else {
               rejectreq();
               return;
          }
     }
     else {
          mmptr->index=atoi(s)+direction;
     }
     if (!annvec()) {
          cycleme(annvecyc);
     }
}

STATIC BOOL                        /*   returns TRUE is request answered   */
annvec(void)                       /* call hook_announce vectors           */
{
     struct saunam sn;
     BOOL rv=FALSE;

     annomem=mrqptr+ANNOSIZE;
     if (mmptr->index <= ninarr(annohdl)) {
          *rsptmp='\0';
          if (mmptr->index == 0) {
               addanno(sv.lonmsg);
          }
          else {
               clrprf();
               (*(void (**)())arrelem(annohdl,mmptr->index-1))();
          }
          if (itemcnt(rsptmp) > 1) {
               if (strlen(itemidx(rsptmp,0)) > 0
                  && cnvd2s(spr("sau:announce %04d",mmptr->index),&sn)) {
                    rsp2read(&sn,STGLEN,rsptmp);
                    rv=TRUE;
               }
               else {
                    mmptr->index++;
                    setmem(annomem,mrqsiz-ANNOSIZE,0);
               }
          }
     }
     else {
          rejectreq();
          rv=TRUE;
     }
     return(rv);
}

STATIC void
annvecyc(void)                     /* cycleme() call annvec()              */
{
     annvec();
}

