/***************************************************************************
 *                                                                         *
 *   AAEFU.C                                                               *
 *                                                                         *
 *   Copyright (c) 1988-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   ASCII/ANSI E-mail and Forums utilities and common functions.          *
 *                                                                         *
 *                                                - J. Alvrus 8/2/94       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gme.h"
#include "filexfer.h"
#include "datutils.h"
#include "galmsg.h"
#include "emlfor.h"
#include "aaef.h"
#include "efhooks.h"

#define FILREV "$Revision:   1.0.1.1.1.1  $"

struct efvda *efvda=NULL;

void *efwork;                      /* GME request work area in VDA         */
struct qikdat *qikbuf;             /* !QUICK struct in VDA                 */
struct fordef *fdef;               /* forum def struct in VDA              */
struct fordsk *fdsk;               /* on-disk forum struct in VDA          */
char *desc,                        /* forum description buf in VDA         */
     *msgatr,                      /* ANSI message body color string       */
     *tagkey;                      /* key req. to tag attachments          */
adr_t *echo;                       /* forum echoes buffer in VDA           */
BOOL cb4hdr;                       /* A/A clear before message (non-browse)*/
int  cmthdrsz,                     /* size of combined comment headers     */
     ccmax,                        /* max # CCs to allow for A/A           */
     msgbyts;                      /* max msg text size (backward compat.) */

STATIC
quotfunc quoter=NULL;              /* current message quoting function     */
STATIC
ccadfunc ccadder=NULL;             /* current cc: list adder function      */

void edreply(void);
void quotem(void);
void dftquo(struct message *qmsg,char *qtxt,unsigned qlen);
unsigned linlen(char *ptr);
BOOL ccok(void);
int efuphl(int fupcode);
void add2lst(char *newadr);
char *addcclst(char *text,char *list);
char *dftadcc(char *text,char *list);
void sendit(void);
void wrtprg(int evt,int rc);
void wnotify(int rc);
void dnotify(int rc);
void sendone(int rc);
BOOL meddone(int edflgs);
void modit(void);
int efdnhl(int tshcode);
void addcmt(void);
BOOL cmtdone(int edflgs);
void fwdcpycb(int evt,int rc);
char *nrstr(int nr);
char *adrfld(char *adr,char *buf,int maxlen);
char *hststr(char *history);
char *datlin(unsigned date,unsigned time);
char *fnmlin(unsigned forum);
char *cfortvar(void);
int foppkey(int unum,char *lock);
unsigned ucurfor(int unum);

void
iniaa(void)                        /* initialize ASCII/ANSI stuff          */
{
     unsigned tmpvsz;

     msgbyts=txtlen();
     tmpvsz=(unsigned)(efvda->u.m.msgtxt-(char *)efvda)+txtlen()-1;
     dclvda(max(sizeof(struct efvda),tmpvsz));
     cb4hdr=ynopt(CB4HDR);
     tagkey=stgopt(TAGKEY);
     msgatr=stgopt(MSGATR);
     cmthdrsz=strlen(abvcmt)+strlen(blwcmt)+2*UIDSIZ;
     ccmax=numopt(CCMAX,0,32767);
     if (!setcfl(efcflck)) {
          catastro("Not enough memory to register E-mail/Forums conflict checker");
     }
     if (quoter == NULL) {
          setquoter(dftquo);
     }
     if (ccadder == NULL) {
          setccadder(dftadcc);
     }
     iniaaeml();
     iniaafor();
     register_textvar("CURRENT_FORUM",cfortvar);
     register_pseudok("_FORUMOP",foppkey);
}

BOOL
efcflck(                           /* E-mail/Forums conflict checker       */
void *work,                        /*   work area to check                 */
unsigned forum,                    /*   forum to check                     */
long msgid)                        /*   message ID to check                */
{
     int i,tmpusn,savusn;
     struct user *tmpusp,*savusp;
     struct qscfg *tmpqsp;
     struct efvda *tmpvda;

     savusn=usrnum;
     savusp=usrptr;
     if (msgid == 0L) {
          for (tmpusn=0,tmpusp=user ; tmpusn < nterms ; tmpusn++,tmpusp++) {
               if (tmpusp->class > SUPIPG) {
                    tmpvda=(struct efvda *)vdaoff(tmpusn);
                    if ((tmpusp->state == emlstate || tmpusp->state == forstate
                      || (peruflg[tmpusn]&(INEDIT|INFTF|INFSD|INEDHLP)))
                     && work != tmpvda->efwork) {
                         tmpqsp=uqsptr(tmpusn);
                         if (forum == tmpqsp->curfor) {
                              usrnum=savusn;
                              usrptr=savusp;
                              return(TRUE);
                         }
                         if (usrscn[tmpusn] != NULL) {
                              for (i=0 ; i < MAXPRV ; ++i) {
                                   if (forum == tmpvda->prvlst[i].fid) {
                                        usrnum=savusn;
                                        usrptr=savusp;
                                        return(TRUE);
                                   }
                              }
                         }
                    }
                    usrnum=tmpusn;
                    usrptr=tmpusp;
                    setftu();
                    for (i=0 ; i < ftuptr->numftg ; i++) {
                         if (ftgusr[i].tshndl == efdnhl
                          && forintg(ftgusr[i].tagspc) == forum) {
                              usrnum=savusn;
                              usrptr=savusp;
                              return(TRUE);
                         }
                    }
               }
          }
     }
     else {
          for (tmpusn=0,tmpusp=user ; tmpusn < nterms ; tmpusn++,tmpusp++) {
               if (tmpusp->class > SUPIPG) {
                    tmpvda=(struct efvda *)vdaoff(tmpusn);
                    if ((tmpusp->state == emlstate || tmpusp->state == forstate
                      || (peruflg[tmpusn]&(INEDIT|INFTF)))
                     && work != tmpvda->efwork) {
                         if (msgid == tmpvda->curmid
                          || msgid == tmpvda->prethr) {
                              usrnum=savusn;
                              usrptr=savusp;
                              return(TRUE);
                         }
                    }
                    usrnum=tmpusn;
                    usrptr=tmpusp;
                    setftu();
                    for (i=0 ; i < ftuptr->numftg ; i++) {
                         if (ftgusr[i].tshndl == efdnhl
                          && msgintg(ftgusr[i].tagspc) == msgid) {
                              usrnum=savusn;
                              usrptr=savusp;
                              return(TRUE);
                         }
                    }
               }
          }
     }
     usrnum=savusn;
     usrptr=savusp;
     return(FALSE);
}

unsigned                           /*   updated spinner position           */
spin(                              /* output a spinner                     */
unsigned count)                    /*   spinner position index             */
{
     static char spinner[]={"/-\\|"};

     ++count;
     if (count > 3) {
          count=0;
     }
     prf("\b%c",spinner[count]);
     return(count);
}

void
setmeup(void)                      /* set up E-mail/Forums files/pointers  */
{
     setmbk(efmb);
     efvda=(struct efvda *)vdaptr;
     efwork=efvda->efwork;
     qsptr=myqsptr();
     msg=&efvda->u.m.msg;
     msgtxt=efvda->u.m.msgtxt;
     filatt=efvda->u.m.filatt;
     qikbuf=&efvda->u.q.qik;
     fdef=&efvda->u.f.d.def;
     fdsk=&efvda->u.f.d.dsk;
     echo=(adr_t *)efvda->u.f.v.echo;
     desc=(char *)echo;
}

BOOL                               /*   returns TRUE if user warned        */
pfnwrn(void)                       /* warn user about profanity            */
{
     BOOL rc=FALSE;

     if (usrptr->pfnacc > MAXPFN) {
          byenow(MUCH2P);
          return(TRUE);
     }
     if (usrptr->pfnacc > WRNPFN && pfnlvl > 0) {
          prfmsg(RAUNCH);
          rc=TRUE;
     }
     else if (pfnlvl > 2) {
          prfmsg(PFNMSG);
          rc=TRUE;
     }
     if (rc) {
          outprf(usrnum);
          cncall();
          injacr();
     }
     return(rc);
}

void
gostt(                             /* prompt and change substate           */
int stt)                           /*   state to go to                     */
{
     struct otscan *ots;

     if (isripu() || shortm) {
          switch (stt) {
          case EMAINS:
               stt=EMAINM;
               break;
          case SPECFS:
               stt=SPECFN;
               break;
          case LSPECFS:
               stt=LSPECFN;
               break;
          case FMAINS:
               stt=FMAINM;
               break;
          case FINDS:
               stt=FINDM;
               break;
          case FOPMNS:
               stt=FOPMNU;
               break;
          case OPRMNS:
               stt=OPRMNU;
               break;
          }
     }
     switch (stt) {
     default:
          #ifdef DEBUG
               catastro("Update your state list in gostt() (state=%d)",stt);
          #endif
     case LONRDN:
     case EMAINM:
     case EMAINS:
     case ERTFQN:
     case ERTFQL:
     case ERFQF:
     case GONUM:
     case ESCAN:
     case SCNEND:
     case SCNENDX:
     case SCNBEG:
     case SCNBEGX:
     case ERDTO:
     case ERDFR:
     case ERDPAR:
     case EFREAD:
     case EFOREAD:
     case USEQUO:
     case WHOFWD:
     case RAFABT:
     case WHOCPY:
     case CMTPMT:
     case EWHOTO:
     case WHO2CC:
     case MODWHT:
     case DELMSN:
     case SPECFN:
     case SPECFS:
     case LSPECFN:
     case LSPECFS:
     case ENTFWD:
     case CHGFWD:
     case NEMPRF:
     case FMTPRF:
     case RMDPRF:
     case QUOPRF:
     case CARPRF:
     case CMTPRF:
     case L2EDPMT:
     case ACCLVK:
     case SYSENT:
     case QIKPMT:
     case STARTF:
     case STARTN:
     case FTDSCN:
     case FTSCAN:
     case FDSCAN:
     case FSCAN:
     case FSCBEG:
     case FSCBEGX:
     case FSCEND:
     case FSCENDX:
     case THRFBP:
     case FREAD:
     case FAREAD:
     case FTREAD:
     case FOREAD:
     case FORMTO:
     case FORETO:
     case FAUTH:
     case FOPRDA:
     case FOPRDU:
     case FOPRDX:
     case FINDM:
     case FINDS:
     case OTADF:
     case OTRMF:
     case OTNMSG:
     case OTATONL:
     case OT2UONL:
     case OTFUONL:
     case OTSMSG:
     case OTKWDS:
     case LSTWHAT:
     case LISTYP:
     case STRTLST:
     case QCADD:
     case QCDEL:
     case QSNMSG:
     case QSATONL:
     case QS2UONL:
     case QSFUONL:
     case QSSMSG:
     case QSKWDS:
     case WHATFOR:
     case FOPMNU:
     case FOPMNS:
     case OPRMNS:
     case FCRTNAM:
     case FSDCHG:
     case EDECHO:
     case ECH2ADD:
     case ECH2DEL:
     case FOR2DEL:
     case SETDFAC:
     case UID2SET:
     case FORUID:
     case SYSUID:
     case FSETACH:
     case SSETACH:
     case UCPYSRC:
     case UCPDST:
     case UCPDST2:
          prfmsg(stt);
          break;
     case SRCHMNU:
          ots=usrscn[usrnum];
          prfmsg(stt,ynstr(ots->flags,SCNEW),ynstr(ots->flags,SCATT),
                 ynstr(ots->flags,SCTOU),ynstr(ots->flags,SCFRU),
                 l2as(ots->stmsgid),ots->keywds);
          break;
     case QSCFGM:
          prfmsg(stt,ynstr(qsptr->flags,NEWMSG),ynstr(qsptr->flags,WATONL),
                 ynstr(qsptr->flags,TOMEONL),ynstr(qsptr->flags,FRMEONL),
                 l2as(qsptr->stmsg),qsptr->kwds);
          break;
     case OPRMNU:
          prfmsg(stt,curfnm(),curftpc());
          break;
     case CRTFORM:
          prfmsg(stt,fdsk->name,fdsk->topic);
          break;
     case EDTFMNU:
          prfmsg(stt,fdef->name,fdef->topic);
          break;
     case CNFDEL:
          prfmsg(stt,fdef->name,fdef->topic,fdef->nmsgs,fdef->nfiles);
          break;
     case CFGACCM:
          prfmsg(stt,curfnm(),curftpc(),accstr(efvda->u.a.dfnpv),
                 accstr(efvda->u.a.dfprv),accstr(efvda->u.a.mxnpv),
                 efvda->u.a.forlok);
          break;
     case MODLOC:
          prfmsg(stt,forprv);
          break;
     case FMAINM:
     case FMAINS:
          gfmain(stt == FMAINS);
          break;
     case POSTWRT:
          shopwm();
          break;
     case NAMATT:
          if (msg->attname[0] == '\0') {
               prfmsg(NAMATN);
          }
          else {
               prfmsg(NAMATT,msg->attname);
          }
          break;
     case DLNOW:
          prfmsg(ATTNOT,msg->attname,l2as(efvda->attsiz));
          prfmsg(stt);
          break;
     case LSTCHG:
          prfmsg(stt,MINLCH,MAXLCH);
          break;
     case QIKEDT:
          prfmsg(stt,efvda->count+1);
          break;
     case SETPRF:
          dsetprf(stt);
          break;
     }
     usrptr->substt=stt;
}

void
errhlp(                            /* display error/help message & reprompt*/
int ehmsg,                         /*   error/help message to display      */
int repmt)                         /*   reprompt with this message         */
{
     cncall();
     clrinp();
     prfmsg(ehmsg);
     gostt(repmt);
}

void
startlst(                          /* fire up a cycled listing process     */
BOOL (*nxtlst)(void),              /*   function to output next line       */
void (*whndun)(int rc))            /*   function to call when finished     */
{
     usrptr->substt=LISTING;
     efvda->cflags&=~LSTDONE;
     efvda->nxtlst=nxtlst;
     efvda->whndun=whndun;
     lister();
}

void
lister(void)                       /* cycled show-a-list process           */
{
     if (efvda->cflags&LSTDONE) {
          if (btuoba(usrnum) < OUTSIZ-LISTIL) {
               docyc(FALSE);
          }
          else {
               (*efvda->whndun)(FALSE);
               chkcyc();
          }
     }
     else {
          if (btuoba(usrnum) < MAXLSI) {
               docyc(FALSE);
          }
          else if ((*efvda->nxtlst)()) {
               outprf(usrnum);
               clrprf();
               docyc(FALSE);
          }
          else {
               efvda->cflags|=LSTDONE;
               if (btuoba(usrnum) < OUTSIZ-LISTIL) {
                    docyc(FALSE);
               }
               else {
                    (*efvda->whndun)(FALSE);
                    chkcyc();
               }
          }
     }
}

void
wrthlp(void)                       /* show help for who-to-write prompt    */
{
     int i,nexp;
     struct expinfo *tmpinf;

     switch (wrtany()) {
     case VALACC:
          prfmsg(NWSYSOP);
          break;
     case VALCRD:
          prfmsg(EWSYSOP);
          break;
     case VALYES:
          prfmsg(WEHLP);
          if (expavl()) {
               nexp=numexp();
               for (i=0 ; i < nexp ; ++i) {
                    tmpinf=expinf(i);
                    if (haskey(tmpinf->wrtkey)) {
                         prfmsg(WEXHLP,tmpinf->name,tmpinf->prefix,
                                tmpinf->exmp);
                    }
               }
          }
          prfmsg(WEHLP2);
          break;
     }
}

void
startwrt(                          /* start message write process          */
void (*whndun)(int rc))            /*   function to invoke when finished   */
{
     stlcpy(msg->from,usaptr->userid,MAXADR);
     efvda->whndun=whndun;
     efvda->numcc=0;
     efvda->flags&=~CCLST;
     efvda->flags&=~ISRPL;
     goedit(ED_CLRTXT+ED_CLRTOP);
}

void
startrpl(                          /* start reply process                  */
void (*whndun)(int rc))            /*   function to invoke when finished   */
{
     stlcpy(msg->to,msg->from,MAXADR);
     stlcpy(msg->from,usaptr->userid,MAXADR);
     efvda->whndun=whndun;
     efvda->numcc=0;
     efvda->flags&=~CCLST;
     efvda->flags|=ISRPL;
     edreply();
}

void
edreply(void)                      /* start editing reply w/possible quote */
{
     if ((qsptr->flags&MSGQUO)) {
          if (qsptr->flags&ALWQUO) {
               if (!(qsptr->flags&USRSET)) {
                    prfmsg(QUOUSD);
                    outprf(usrnum);
               }
               quotem();
               goedit(0);
          }
          else {
               gostt(USEQUO);
          }
     }
     else {
          goedit(ED_CLRTXT);
     }
}

void
susequo(void)                      /* state: use quoting when replying?    */
{
     switch (cncyesno()) {
     case 'Y':
          quotem();
          goedit(0);
          break;
     case 'N':
          goedit(ED_CLRTXT);
          break;
     default:
          cncall();
          prfmsg(YORN);
          gostt(USEQUO);
          break;
     }
}

void
goedit(                            /* start editing a message              */
int flags)                         /*   flags for editor                   */
{
     int pflvl;
     unsigned dstfor;

     peruflg[usrnum]|=INEDIT;
     efvda->savstt=usrptr->state;
     lf2cr(msgtxt);
     zpad(msgtxt,TXTLEN);          /* to avoid possible FSE comprbuf() err */
     bgnedt(TXTLEN,msgtxt,TPCSIZ,msg->topic,edtdone,flags);
     edtimr(efimr);
     dstfor=msg->forum;
     if (msg->forum == EMLID && isforum(msg->to)) {
          dstfor=getfid(&msg->to[1]);
     }
     if (dstfor != EMLID) {
          pflvl=getdefp(dstfor)->pfnlvl;
          if (pflvl != DFTPFN) {
               edtpfn(pflvl);
          }
     }
}

BOOL                               /*   returns TRUE if found spec'd msg   */
efimr(                             /* import message into editor           */
long msgid)                        /*   message ID to import               */
{
     int rc;
     void *tmpwork;
     struct message *tmpmsg;

     tmpwork=&((struct efvda *)vdatmp)->efwork;
     setmem(tmpwork,GMEWRKSZ,0);
     tmpmsg=&((struct efvda *)vdatmp)->u.m.msg;
     msgtxt=((struct efvda *)vdaptr)->u.m.msgtxt;
     inigmerq(tmpwork);
     if (peruflg[usrnum]&INEMAIL) {
          inormrd(tmpwork,usaptr->userid,EMLID,msgid);
          while ((rc=readmsg(tmpwork,tmpmsg,msgtxt)) == GMEAGAIN) {
               /* exact reads should not require more than 1 cycle */
          }
          if (rc != GMEOK) {
               seqctx(tmpwork,ESQFRU);
               while ((rc=readmsg(tmpwork,tmpmsg,msgtxt)) == GMEAGAIN) {
                    /* exact reads should not require more than 1 cycle */
               }
          }
     }
     else {
          inormrd(tmpwork,usaptr->userid,myqsptr()->curfor,msgid);
          while ((rc=readmsg(tmpwork,tmpmsg,msgtxt)) == GMEAGAIN) {
               /* exact reads should not require more than 1 cycle */
          }
     }
     clsgmerq(tmpwork);
     return(rc == GMEOK);
}

BOOL                               /*   returns TRUE to stay in module     */
edtdone(                           /* finished editing message             */
int edflgs)                        /*   edit result flags                  */
{
     setmeup();
     peruflg[usrnum]&=~INEDIT;
     usrptr->state=efvda->savstt;
     if (edflgs&ED_QUITEX) {
          prfmsg(WABORT);
          (*efvda->whndun)(TRUE);
     }
     else {
          chkitout();
          if ((efvda->flags&(ATTOK|RRROK|PRIOK))
           || ((peruflg[usrnum]&INEMAIL) && alwcpy
            && (ccmax > 0 || (usrptr->flags&MASTER)))) {
               gostt(POSTWRT);
          }
          else {
               sendit();
          }
     }
     efvda->dftchr=getdft();
     outprf(usrnum);
     return(TRUE);
}

void
chkitout(void)                     /* check available post-write options   */
{
     efvda->flags&=~(ATTOK+RRROK+PRIOK);
     if (valatt(efwork,msg->from,msg->to,msg->forum) == VALYES) {
          efvda->flags|=ATTOK;
     }
     if (valrrr(efwork,msg->from,msg->to,msg->forum) == VALYES) {
          efvda->flags|=RRROK;
     }
     if (valpri(efwork,msg->from,msg->to,msg->forum) == VALYES) {
          efvda->flags|=PRIOK;
     }
}

void
shopwm(void)                       /* show post-write menu                 */
{
     prfmsg(PWHDR);
     if (efvda->flags&ATTOK) {
          if (msg->flags&FILATT) {
               prfmsg(PWDET,msg->attname);
          }
          else {
               prfmsg(PWATT);
          }
     }
     if (efvda->flags&RRROK) {
          if (msg->flags&RECREQ) {
               prfmsg(PWCRR);
          }
          else {
               prfmsg(PWRRR);
          }
     }
     if (efvda->flags&PRIOK) {
          if (msg->flags&PRIMSG) {
               prfmsg(PWCHP);
          }
          else {
               prfmsg(PWRHP);
          }
     }
     if (ccok()) {
          prfmsg(PWCPY);
          if (efvda->numcc > 0) {
               if (efvda->flags&CCLST) {
                    prfmsg(PWNLC);
               }
               else {
                    prfmsg(PWYLC);
               }
          }
     }
     prfmsg(PWMOD);
     prfmsg(POSTWRT);
}

void
shopwh(void)                       /* show post-write help                 */
{
     prfmsg(PWHHDR);
     if (efvda->flags&ATTOK) {
          prfmsg(PWAHLP);
     }
     if (efvda->flags&RRROK) {
          prfmsg(PWRHLP);
     }
     if (efvda->flags&PRIOK) {
          prfmsg(PWPHLP);
     }
     if (ccok()) {
          prfmsg(PWCHLP);
     }
     prfmsg(PWHTLR);
}

BOOL
ccok(void)                         /* can user send cc: of this message?   */
{
     return(msg->forum == EMLID && alwcpy
         && (ccmax > 0 || (usrptr->flags&MASTER)));
}

void
spostwrt(void)                     /* state: E-mail/Forums post-write menu */
{
     switch (cncchr()) {
     case 'A':
          if ((efvda->flags&ATTOK) && !(msg->flags&FILATT)) {
               efupload();
          }
          else {
               errhlp(CNOTIL,POSTWRT);
          }
          break;
     case 'D':
          if ((efvda->flags&ATTOK) && (msg->flags&FILATT)) {
               prfmsg(DETING,msg->attname);
               if (!(msg->flags&FILIND)) {
                    unlink(filatt);
               }
               msg->flags&=~(FILATT|FILIND);
               setmem(msg->attname,FLNSIZ,0);
               setmem(filatt,MAXPATH,0);
               shopwm();
          }
          else {
               errhlp(CNOTIL,POSTWRT);
          }
          break;
     case 'R':
          if (efvda->flags&RRROK) {
               if (msg->flags&RECREQ) {
                    msg->flags&=~RECREQ;
               }
               else {
                    msg->flags|=RECREQ;
               }
          }
          else {
               prfmsg(CNOTIL);
          }
          shopwm();
          break;
     case 'P':
          if (efvda->flags&PRIOK) {
               if (msg->flags&PRIMSG) {
                    msg->flags&=~PRIMSG;
               }
               else {
                    msg->flags|=PRIMSG;
               }
          }
          else {
               prfmsg(CNOTIL);
          }
          shopwm();
          break;
     case 'C':
          if (ccok()) {
               gostt(WHO2CC);
          }
          else {
               errhlp(CNOTIL,POSTWRT);
          }
          break;
     case 'L':
          if (ccok() && efvda->numcc > 0) {
               if (efvda->flags&CCLST) {
                    efvda->flags&=~CCLST;
               }
               else {
                    efvda->flags|=CCLST;
               }
          }
          else {
               prfmsg(CNOTIL);
          }
          shopwm();
          break;
     case 'M':
          goedit(0);
          break;
     case '?':
          shopwh();
          shopwm();
          break;
     case '.':
          if (efvda->flags&CCLST) {
               addcclst(msgtxt,efvda->cclist);
          }
          sendit();
          break;
     default:
          errhlp(CNOTIL,POSTWRT);
          break;
     }
}

void
efupload(void)                     /* E-mail/Forums upload utility         */
{
     efvda->flags&=~FUPOK;
     stlcpy(filatt,ulname(msg),MAXPATH);
     ASSERT(!fexist(filatt));
     peruflg[usrnum]|=INFTF;
     efvda->savstt=usrptr->state;
     if (morcnc()) {
          fileup("attachment",cncall(),efuphl);
     }
     else {
          fileup("attachment","?",efuphl);
     }
     ftuptr->flags|=FTFREF;
}

int                                /*   response code                      */
efuphl(                            /* E-mail/Forums upload handler         */
int fupcode)                       /*   FTF action code                    */
{
     int rc=0;

     setmeup();
     switch (fupcode) {
     case FUPPTH:
          break;
     case FUPBEG:
          if (ftfscb->actfil > 0) {
               strcpy(ftfbuf,"You may only upload one attachment per message.");
          }
          else if (ftuptr->flags&FTBANG) {
               strcpy(ftfbuf,"You can not automatically log off when uploading attachments.");
          }
          else {
               stlcpy(msg->attname,ftfscb->fname,FLNSIZ);
               strupr(msg->attname);
               stlcpy(ftfbuf,filatt,MAXPATH);
               rc=1;
          }
          break;
     case FUPREF:
          msg->flags|=FILIND;
          unlink(filatt);
          stlcpy(filatt,ftfbuf,MAXPATH);
          stlcpy(msg->attname,filnpart(filatt),FLNSIZ);
          strupr(msg->attname);
          break;
     case FUPEND:
          efvda->flags|=FUPOK;
          msg->flags|=FILATT;
          if (msg->flags&FILIND) {
               ftfbuf[0]='\0';
          }
          else {
               stlcpy(ftfbuf,filatt,MAXPATH);
          }
          break;
     case FUPSKP:
          efvda->flags&=~FUPOK;
          msg->flags&=~(FILATT+FILIND);
          unlink(filatt);
          break;
     case FUPFIN:
          peruflg[usrnum]&=~INFTF;
          usrptr->state=efvda->savstt;
          if (efvda->flags&FUPOK) {
               gostt(NAMATT);
          }
          else {
               errhlp(NUPLD,POSTWRT);
          }
          efvda->dftchr=getdft();
          rc=1;
          break;
     case FUPHUP:
          break;
     default:
          ASSERT(FALSE);
     }
     return(rc);
}

void
snamatt(void)                      /* state: enter name of attachment      */
{
     char *tmpnam;

     if (morcnc() == '.') {
          cncchr();
          if (*msg->attname == '\0') {
               errhlp(NOBLANK,NAMATT);
          }
          else {
               gostt(POSTWRT);
          }
     }
     else if (morcnc() == '?') {
          cncchr();
          errhlp(ATNMHLP,NAMATT);
     }
     else {
          tmpnam=cncwrd();
          if (valfnm(tmpnam)) {
               stlcpy(msg->attname,strupr(tmpnam),FLNSIZ);
               gostt(POSTWRT);
          }
          else {
               errhlp(INVANM,NAMATT);
          }
     }
}

void
swhotocc(void)                     /* state: to whom to send cc            */
{
     int rc;
     char tmpadr[MAXADR];

     ASSERT(efvda->numcc <= ccmax || (usrptr->flags&MASTER));
     stlcpy(tmpadr,cncall(),MAXADR);
     if (sameas(tmpadr,"?")) {
          clrxrf();
          if (efvda->numcc == 0) {
               prfmsg(NOCCLST);
          }
          else {
               prfmsg(CCLIST,efvda->cclist);
          }
          gostt(POSTWRT);
          return;
     }
     if (efvda->numcc == ccmax && !(usrptr->flags&MASTER)) {
          prfmsg(CCDONE,ccmax);
          gostt(POSTWRT);
          return;
     }
     if (islocal(tmpadr)) {
          switch (hdluid(tmpadr)) {
          case UIDFND:
               stlcpy(tmpadr,uidxrf.userid,MAXADR);
               break;
          case UIDPMT:
               gostt(WHO2CC);
               return;
          case UIDCAL:
               return;
          default:
               ASSERT(FALSE);
          }
     }
     setmem(vdatmp,GMEWRKSZ,0);
     inigmerq(vdatmp);
     rc=valadr(vdatmp,usaptr->userid,tmpadr,msg->forum);
     clsgmerq(vdatmp);
     switch (rc) {
     case VALYES:
          add2lst(tmpadr);
          gostt(POSTWRT);
          break;
     case VALNO:
          errhlp(NOSUCH,POSTWRT);
          break;
     case VALACC:
          errhlp(NOWACC,POSTWRT);
          break;
     case VALCRD:
          cncall();
          prfmsg(NOWCRD);
          howbuy();
          gostt(POSTWRT);
          break;
     }
}

void
add2lst(                           /* add an address to cc: list           */
char *newadr)                      /*   new address to add                 */
{
     char *tmplst;

     if (efvda->cclist == NULL) {
          efvda->cclist=alczer(MAXADR);
          if (efvda->cclist == NULL) {
               errhlp(NOADCC,POSTWRT);
               return;
          }
          efvda->cclstsz=MAXADR;
          strcpy(efvda->cclist,newadr);
     }
     else {
          if (strlen(newadr)+strlen(efvda->cclist) > efvda->cclstsz) {
               tmplst=alcrsz(efvda->cclist,efvda->cclstsz,
                             efvda->cclstsz+MAXADR);
               if (tmplst == NULL) {
                    errhlp(NOADCC,POSTWRT);
                    return;
               }
               efvda->cclstsz+=MAXADR;
               efvda->cclist=tmplst;
          }
          tmplst=efvda->cclist+strlen(efvda->cclist);
          *tmplst++=';';
          strcpy(tmplst,newadr);
     }
     ++efvda->numcc;
}

ccadfunc                           /*   old cc: list adder                 */
setccadder(                        /* set add-cc:-list function            */
ccadfunc newccadder)               /*   new cc: list adder                 */
{
     ccadfunc tmp;

     tmp=ccadder;
     ccadder=newccadder;
     return(tmp);
}

char *                             /*   copy of pointer to text            */
addcclst(                          /* add cc: list to message text         */
char *text,                        /*   message text buffer                */
char *list)                        /*   ';'-delimited cc: list string      */
{
     return((*ccadder)(text,list));
}

char *                             /*   copy of pointer to text            */
dftadcc(                           /* default add cc: list to msg function */
char *text,                        /*   message text buffer                */
char *list)                        /*   ';'-delimited cc: list string      */
{
     char *cp;
     int txtlen,chunk;

     ASSERT(text != NULL);
     ASSERT(strlen(text) < TXTLEN);
     ASSERT(list != NULL);
     ASSERT(*list != '\0');
     txtlen=strlen(text);
     while (!(text[txtlen-1] == '\r' && text[txtlen-2] == '\r')
         && txtlen < TXTLEN) {
          text[txtlen++]='\r';
     }
     if (txtlen < TXTLEN-sizeof("cc: ")) {
          strcpy(&text[txtlen],"cc: ");
          txtlen+=sizeof("cc: ")-1;
          do {
               cp=skpwht(list);
               list=strchr(cp,';');
               chunk=(int)(list-cp);
               if (list == NULL) {
                    stlcpy(&text[txtlen],cp,TXTLEN-txtlen);
               }
               else if (txtlen < TXTLEN-(chunk+sizeof("\r    ")-1)) {
                    movmem(cp,&text[txtlen],chunk);
                    txtlen+=chunk;
                    ++list;
                    movmem("\r    ",&text[txtlen],sizeof("\r    ")-1);
                    txtlen+=sizeof("\r    ")-1;
               }
               else {
                    break;
               }
          } while (list != NULL);
     }
     else {
          text[txtlen]='\0';
     }
     return(text);
}

void
sendit(void)                       /* initiate message send process        */
{
     cncall();
     prfmsg(SNDSTRT);
     setgmecb(efwork,wrtprg);
     efvda->tmpmid=0L;
     efvda->cflags&=~(WDSTING|WCCING|WCPYING);
     if (efvda->flags&ISRPL) {
          usrptr->substt=RPLING;
     }
     else {
          usrptr->substt=SENDING;
     }
     docyc(FALSE);
}

void
sender(void)                       /* cycled message send process          */
{
     int rc;

     switch (rc=sendmsg(efwork,msg,msgtxt,filatt,efvda->cclist)) {
     case GMEAGAIN:
          if (efvda->cflags&WCPYING) {
               efvda->count=spin(efvda->count);
               outprf(usrnum);
          }
          docyc(FALSE);
          break;
     default:
          sendone(rc);
          break;
     }
}

void
replyr(void)                       /* cycled reply process                 */
{
     int rc;

     switch (rc=reply(efwork,msg,msgtxt,filatt,efvda->cclist)) {
     case GMEAGAIN:
          if (efvda->cflags&WCPYING) {
               efvda->count=spin(efvda->count);
               outprf(usrnum);
          }
          docyc(FALSE);
          break;
     default:
          sendone(rc);
          break;
     }
}

void
sendone(                           /* done sending a message               */
int rc)                            /*   result code from GME               */
{
     switch (rc) {
     case GMEAFWD:
     case GMEOK:
          if (!(efvda->cflags&(WDSTING|WCCING))) {
               wnotify(rc);
          }
          break;
     default:
          prfmsg(SENDERR,rc);
          break;
     }
     prfmsg(SENDTLR);
     if (efvda->cclist != NULL) {
          free(efvda->cclist);
          efvda->cclist=NULL;
     }
     efvda->cflags&=~(WDSTING|WCCING);
     (*efvda->whndun)(FALSE);
     chkcyc();
}

void
wrtprg(                            /* show progress of write operation     */
int evt,                           /*   current event                      */
int rc)                            /*   result of last write operation     */
{
     switch (evt) {
     case EVTCPYS:
          prfmsg(CPYATT);
          outprf(usrnum);
          efvda->cflags|=WCPYING;
          break;
     case EVTCPYD:
          prf("\b\n");
          outprf(usrnum);
          efvda->cflags&=~WCPYING;
          break;
     case EVTDSTS:
          prfmsg(DSTSTRT,gmexinf());
          outprf(usrnum);
          efvda->cflags|=WDSTING;
          break;
     case EVTDSTD:
          efvda->cflags&=~WDSTING;
          break;
     case EVTCCST:
          prfmsg(CCSTART);
          outprf(usrnum);
          efvda->cflags|=WCCING;
          break;
     case EVTDONE:
          if (efvda->tmpmid == 0L) {
               efvda->tmpmid=msg->msgid;
          }
          if (rc > GMEAGAIN) {
               if (efvda->cflags&WCCING) {
                    cnotify(rc);
               }
               else if (efvda->cflags&WDSTING) {
                    dnotify(rc);
               }
               else {
                    wnotify(rc);
               }
          }
          else if (!(efvda->cflags&WDSTING)) {
               switch (rc) {
               case GMECRD:
                    if (efvda->cflags&WCCING) {
                         prfmsg(CCNOCRD,msg->to);
                         outprf(usrnum);
                         break;
                    }
               default:
                    prfmsg(SENDERR,rc);
                    outprf(usrnum);
                    break;
               }
          }
          break;
     }
}

void
wnotify(                           /* do notification of message write     */
int rc)                            /*   result of write operation          */
{
     if (msg->forum != EMLID && (msg->flags&FILATT)) {
          if (msg->flags&FILAPV) {
               prfmsg(FILAVL);
          }
          else {
               prfmsg(FILNVL);
          }
     }
     prfmsg(SENTOK,l2as(msg->msgid));
     outprf(usrnum);
     if (rc == GMEAFWD) {
          wrtnot(gmexinf(),msg);
     }
     else {
          if (wrtnot(msg->to,msg)) {
               prfmsg(SNOTIFD,msg->to);
               outprf(usrnum);
          }
     }
}

void
dnotify(                           /* do notification of distributed msg   */
int rc)                            /*   result of write operation          */
{
     if (msg->forum != EMLID && (msg->flags&FILATT)) {
          if (msg->flags&FILAPV) {
               prfmsg(FILAVL);
          }
          else {
               prfmsg(FILNVL);
          }
     }
     prfmsg(DISTOK,l2as(msg->msgid),gmexinf());
     outprf(usrnum);
     if (rc == GMEAFWD) {
          wrtnot(gmexinf(),msg);
     }
     else {
          if (wrtnot(msg->to,msg)) {
               prfmsg(SNOTIFD,msg->to);
               outprf(usrnum);
          }
     }
}

void
fnotify(                           /* do notification of message forward   */
int rc)                            /*   result of forward operation        */
{
     if (msg->forum != EMLID && (msg->flags&FILATT)) {
          if (msg->flags&FILAPV) {
               prfmsg(FWDCAP);
          }
          else {
               prfmsg(FWDCNA);
          }
     }
     if (msg->forum == EMLID) {
          prfmsg(FWDCNF,l2as(efvda->curmid),l2as(msg->msgid),msg->to);
     }
     else {
          prfmsg(FWDCNF,l2as(efvda->curmid),l2as(msg->msgid),
                 spr("/%s",getfnm(msg->forum)));
     }
     outprf(usrnum);
     if (rc == GMEAFWD) {
          fwdnot(gmexinf());
     }
     else {
          if (fwdnot(msg->to)) {
               prfmsg(SNOTIFD,msg->to);
               outprf(usrnum);
          }
     }
}

void
cnotify(                           /* do notification of message copy      */
int rc)                            /*   result of copy operation           */
{
     if (msg->forum != EMLID && (msg->flags&FILATT)) {
          if (msg->flags&FILAPV) {
               prfmsg(FWDCAP);
          }
          else {
               prfmsg(FWDCNA);
          }
     }
     if (msg->forum == EMLID) {
          prfmsg(CPYCNF,l2as(efvda->tmpmid),l2as(msg->msgid),msg->to);
     }
     else {
          prfmsg(CPYCNF,l2as(efvda->tmpmid),l2as(msg->msgid),
                 spr("/%s",getfnm(msg->forum)));
     }
     outprf(usrnum);
     if (rc == GMEAFWD) {
          cpynot(gmexinf());
     }
     else {
          if (cpynot(msg->to)) {
               prfmsg(SNOTIFD,msg->to);
               outprf(usrnum);
          }
     }
}

void
startmod(                          /* initiate modification of message     */
void (*whndun)(int rc))            /*   function to call when finished     */
{
     int pflvl;

     peruflg[usrnum]|=INEDIT;
     efvda->savstt=usrptr->state;
     efvda->whndun=whndun;
     lf2cr(msgtxt);
     zpad(msgtxt,TXTLEN);          /* to avoid possible FSE comprbuf() err */
     bgnedt(TXTLEN,msgtxt,TPCSIZ,msg->topic,meddone,0);
     edtimr(efimr);
     if (msg->forum != EMLID) {
          pflvl=getdefp(msg->forum)->pfnlvl;
          if (pflvl != DFTPFN) {
               edtpfn(pflvl);
          }
     }
}

BOOL                               /*   returns TRUE to stay in module     */
meddone(                           /* finished editing msg being modified  */
int edflgs)                        /*   edit result flags                  */
{
     setmeup();
     peruflg[usrnum]&=~INEDIT;
     usrptr->state=efvda->savstt;
     if (edflgs&ED_QUITEX) {
          prfmsg(WABORT);
          (*efvda->whndun)(GMEAGAIN);
     }
     else {
          modit();
     }
     efvda->dftchr=getdft();
     outprf(usrnum);
     return(TRUE);
}

void
modit(void)                        /* initiate message modify process      */
{
     cncall();
     usrptr->substt=MODING;
     docyc(FALSE);
}

void
cmodr(void)                        /* cycled message modify process        */
{
     int rc;

     switch (rc=modmsg(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          docyc(FALSE);
          break;
     default:
          (*efvda->whndun)(rc);
          chkcyc();
          break;
     }
}

void
getprnt(                           /* initiate read parent message process */
void (*whndun)(int rc))            /*   function to call when finished     */
{
     usrptr->substt=CRDPRNT;
     efvda->whndun=whndun;
     cgetprnt();
}

void
cgetprnt(void)                     /* cycled read message parent process   */
{
     int rc;

     switch (rc=readpar(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          docyc(TRUE);
          return;
     default:
          (*efvda->whndun)(rc);
          break;
     }
     chkcyc();
}

void
getnear(                           /* initiate read near message process   */
int nearop,                        /*   get near "style" to use            */
void (*whndun)(int rc))            /*   function to call when finished     */
{
     usrptr->substt=CRDNEAR;
     efvda->nearop=nearop;
     efvda->whndun=whndun;
     cgetnear();
}

void
cgetnear(void)                     /* cycled read near message process     */
{
     int rc;

     switch (rc=nearmsg(efwork,efvda->nearop,msg,msgtxt)) {
     case GMEAGAIN:
          docyc(TRUE);
          return;
     default:
          (*efvda->whndun)(rc);
          break;
     }
     chkcyc();
}

void
reget(                             /* initiate re-read of current message  */
void (*whndun)(int rc))            /*   function to call when finished     */
{
     usrptr->substt=CREREAD;
     efvda->whndun=whndun;
     creget();
}

void
creget(void)                       /* cycled re-read of current message    */
{
     int rc;

     switch (rc=readmsg(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          docyc(TRUE);
          return;
     default:
          (*efvda->whndun)(rc);
          break;
     }
     chkcyc();
}

void
getnext(                           /* initiate read next message process   */
void (*whndun)(int rc))            /*   function to call when finished     */
{
     usrptr->substt=CRDNEXT;
     efvda->whndun=whndun;
     cgetnext();
}

void cgetnext(void)                /* cycled read next message process     */
{
     int rc;

     switch (rc=nextmsg(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          docyc(!srchipg());
          return;
     default:
          (*efvda->whndun)(rc);
     }
     chkcyc();
}

void
getprev(                           /* initiate get previous message process*/
void (*whndun)(int rc))            /*   function to call when finished     */
{
     usrptr->substt=CRDPREV;
     efvda->whndun=whndun;
     cgetprev();
}

void cgetprev(void)                /* cycled get previous message process  */
{
     int rc;

     switch (rc=prevmsg(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          docyc(!srchipg());
          return;
     default:
          (*efvda->whndun)(rc);
          break;
     }
     chkcyc();
}

BOOL
srchipg(void)                      /* is there a message search in progress*/
{
     return(usrscn[usrnum] != NULL);
}

void
xmtext(                            /* transmit text of message             */
void (*whndun)(int rc))            /*   function to call when finished     */
{
     char *cp;

     for (cp=msgtxt ; *cp != '\0' ; cp++) {
          if (*cp == '\r' && isalnum(*(cp+1))) {
               *cp='\n';
          }
     }
     btulok(usrnum,FALSE);
     efvda->whndun=whndun;
     efvda->txtptr=msgtxt;
     usrptr->substt=XMTING;
     btuxmt(usrnum,msgatr);
     if (strlen(msgtxt) > OUTSIZ-2) {
          efvda->cflags|=LONGMSG;
          btutru(usrnum,'\0');
     }
     else {
          efvda->cflags&=~LONGMSG;
          btutru(usrnum,'\r');
     }
     if (usrptr->flags&NOINJO) {
          efvda->cflags&=~INJOSAV;
     }
     else {
          efvda->cflags|=INJOSAV;
     }
     cxmtxt();
}

void
cxmtxt(void)                       /* cycled text transmit process         */
{
     unsigned outavl,lftlen,outlen;

     outavl=btuoba(usrnum);
     lftlen=strlen(efvda->txtptr);
     if (efvda->cflags&LONGMSG) {
          outlen=min(1024,lftlen);
          if (outlen > outavl-2) {
               usrptr->flags|=NOINJO;
               docyc(FALSE);
               return;
          }
     }
     else {
          if (lftlen > outavl-2) {
               docyc(FALSE);
               return;
          }
          outlen=lftlen;
     }
     if (*efvda->txtptr != '\0') {
          stlcpy(prfbuf,efvda->txtptr,outlen+1);
          btuxmt(usrnum,prfbuf);
          if (!(efvda->cflags&LONGMSG)) {
               btuoes(usrnum,TRUE);
          }
          clrprf();
          efvda->txtptr+=outlen;
     }
     if (*efvda->txtptr == '\0' && btuoba(usrnum) > 1024) {
          btuxmt(usrnum,"\r");
          xmtdone(FALSE);
     }
     else {
          if (*efvda->txtptr != '\0') {
               usrptr->flags|=NOINJO;
          }
          docyc(FALSE);
     }
}

void
xmtdone(                           /* done sending message text            */
BOOL aborted)                      /*   TRUE if user aborted output        */
{
     efvda->cflags|=XMTDONE;
     if (efvda->cflags&INJOSAV) {
          usrptr->flags&=~NOINJO;
     }
     (*efvda->whndun)(aborted);
     chkcyc();
}

void
markoff(                           /* mark message read, generate ret.rcp. */
void (*whndun)(int rc))            /*   function to call when finished     */
{
     usrptr->substt=CMARKRD;
     efvda->whndun=whndun;
     cmarkoff();
}

void
cmarkoff(void)                     /* cycled mark-message-read process     */
{
     int rc;

     switch (rc=markread(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          docyc(TRUE);
          return;
     default:
          (*efvda->whndun)(rc);
          break;
     }
     chkcyc();
}

void
sdlnow(                            /* state: query to download attachment  */
void (*whndun)(int rc))            /*   function to call when done         */
{
     switch (cncyesno()) {
     case 'Y':
          prfmsg(DLHDR);
          efdnload(whndun);
          break;
     case 'N':
          (*whndun)(0);
          break;
     default:
          errhlp(YORN,usrptr->substt);
          break;
     }
}

void
efdnload(                          /* E-mail/Forums download utility       */
void (*whndun)(int rc))            /*   function to call when finished     */
{
     int rc;

     efvda->whndun=whndun;
     peruflg[usrnum]|=INFTF;
     efvda->savstt=usrptr->state;
     if (ftgnew()) {
          switch (rc=tagatt(efwork,msg,ftgptr->tagspc)) {
          case GMEOK:
               ftgptr->flags=haskey(tagkey) ? FTGABL : 0;
               ftgptr->tshndl=efdnhl;
               break;
          default:
               switch (rc) {
               case GMEACC:
                    prfmsg(NDLACC);
                    break;
               case GMECRD:
                    prfmsg(NDLCRD);
                    break;
               case GMENFND:
                    prfmsg(NDLFIL,l2as(msg->msgid));
                    break;
               default:
                    ASSERT(FALSE);
               }
               peruflg[usrnum]&=~INFTF;
               (*whndun)(0);
               return;
          }
     }
     if (morcnc()) {
          ftgsbm(cncall());
     }
     else {
          ftgsbm("?");
     }
     if (usrptr->state == efvda->savstt && (peruflg[usrnum]&INFTF)) {
          peruflg[usrnum]&=~INFTF;
          (*whndun)(0);
     }
}

int                                /*   result code                        */
efdnhl(                            /* Handle downloads for E-mail & Forums */
int tshcode)                       /*   action code                        */
{
     int rc=FALSE;
     char *cp;
     FILE *fp;
     struct message *tmpmsg;

     setmeup();
     switch(tshcode) {
     case TSHDSC:
          tmpmsg=tagmsg(ftgptr->tagspc);
          if (tmpmsg == NULL) {
               strcpy(tshmsg,"file attached to a message that's now deleted!");
               break;
          }
          sprintf(tshmsg,"file \"%s\" attached to message #%ld",
                  tmpmsg->attname,tmpmsg->msgid);
          cp=tshmsg+strlen(tshmsg);
          if (tmpmsg->forum != EMLID) {
               sprintf(cp," in %s",getfnm(tmpmsg->forum));
          }
          else if (sameas(usaptr->userid,tmpmsg->from)) {
               sprintf(cp," to %s",tmpmsg->to);
          }
          else {
               sprintf(cp," from %s",tmpmsg->from);
          }
          break;
     case TSHVIS:
          tmpmsg=tagmsg(ftgptr->tagspc);
          if (tmpmsg != NULL) {
               fp=fopen(dlname(tmpmsg),FOPRB);
               if (fp != NULL) {
                    fread(tshmsg,1,TSHLEN,fp);
                    fclose(fp);
               }
          }
          rc=TRUE;
          break;
     case TSHSCN:
          break;
     case TSHNXT:
          break;
     case TSHBEG:
          tmpmsg=tagmsg(ftgptr->tagspc);
          if (tmpmsg == NULL) {
               strcpy(tshmsg,"The message has been deleted!");
          }
          else if (!fnd1st(&effb,cp=dlname(tmpmsg),0)) {
               sprintf(tshmsg,"The file that was attached to message #%ld "
                              "is now missing.",tmpmsg->msgid);
          }
          else if (!dlstart(ftgptr->tagspc)) {
               strcpy(tshmsg,"You don't have enough credits to download "
                             "this attachment.");
          }
          else {
               stlcpy(tshmsg,cp,TSHLEN);
               stlcpy(ftfscb->fname,tmpmsg->attname,FLNSIZ);
               rc=TRUE;
          }
          break;
     case TSHEND:
          dldone(ftgptr->tagspc);
          break;
     case TSHSKP:
          dlabt(ftgptr->tagspc);
          break;
     case TSHFIN:
          usrptr->state=efvda->savstt;
          peruflg[usrnum]&=~INFTF;
          (*efvda->whndun)(0);
          efvda->dftchr=getdft();
          rc=TRUE;
          break;
     case TSHHUP:
          break;
     case TSHUNT:
          break;
     default:
          ASSERT(FALSE);
     }
     return(rc);
}

quotfunc                      /*   old message quoter                      */
setquoter(                    /* set message quoter function               */
quotfunc newquoter)           /*   new message quoter                      */
{
     quotfunc tmp;

     tmp=quoter;
     quoter=newquoter;
     return(tmp);
}

void
quotem(void)                  /* "quote" the current in-memory message     */
{
     (*quoter)(msg,msgtxt,TXTLEN);
}

void
dftquo(                       /* default message quoter                    */
struct message *qmsg,         /*   header of message to quote              */
char *qtxt,                   /*   text buffer to quote                    */
unsigned qlen)                /*   length of text buffer                   */
{
     unsigned len;
     char *curlin,inits[]="  >";

     if ((curlin=strstr(qmsg->to,"{MBBS:")) != NULL) {
          curlin=skpwht(curlin+strlen("{MBBS:"));
     }
     else if (isexpa(qmsg->to)) {
          curlin=strchr(qmsg->to,':')+1;
     }
     else {
          curlin=qmsg->to;
     }
     inits[0]=toupper(curlin[0]);
     if (strchr(curlin,' ') == NULL) {
          inits[1]=toupper(curlin[1]);
     }
     else {
          inits[1]=toupper(*lastwd(curlin));
     }
     stpans(qtxt);
     curlin=qtxt;
     len=0;
     if (*curlin == '\n') {
          do {
               len++;
          } while (*(curlin+len) == '\n');
          movmem(curlin+len,curlin,strlen(curlin+len)+1);
     }
     while (strlen(qtxt)+strlen(inits) < qlen) {
          if ((len=linlen(curlin)) != 0) {
               movmem(curlin,curlin+strlen(inits),strlen(curlin)+1);
               movmem(inits,curlin,strlen(inits));
               if ((len+=strlen(inits)) > 79) {
                    movmem(curlin+len,curlin+79,strlen(curlin+len)+1);
                    len=79;
               }
          }
          if (*(curlin=curlin+len) == '\0' || *++curlin == '\0') {
               break;
          }
     }
}

unsigned
linlen(                            /* find length of line (up to first \r) */
char *ptr)                         /* pointer to line to get length of     */
{
     unsigned retval;

     for (retval=0 ; *ptr != '\r' && *ptr != '\0'; retval++,ptr++) {
          if (*ptr == '\n') {
               *ptr='\r';
               break;
          }
     }
     return(retval);
}

void
deletem(                           /* initiate cycled delete-message       */
void (*whndun)(int rc))            /*   function to call when finished     */
{
     efvda->whndun=whndun;
     usrptr->substt=DELING;
     docyc(TRUE);
}

void
cdelm(void)                        /* cycled delete message process        */
{
     int rc;

     switch (rc=delmsg(efwork)) {
     case GMEAGAIN:
          docyc(TRUE);
          return;
     default:
          (*efvda->whndun)(rc);
          break;
     }
     chkcyc();
}

void
cfhlp(void)                        /* show help for copy/forward prompt    */
{
     int i,nexp;
     struct expinfo *tmpinf;

     switch (wrtany()) {
     case VALACC:
          prfmsg(NWSYSOP);
          break;
     case VALCRD:
          prfmsg(EWSYSOP);
          break;
     case VALYES:
          prfmsg(CFHLP);
          if (expavl()) {
               nexp=numexp();
               for (i=0 ; i < nexp ; ++i) {
                    tmpinf=expinf(i);
                    if (haskey(tmpinf->wrtkey)) {
                         prfmsg(WEXHLP,tmpinf->name,tmpinf->prefix,
                                tmpinf->exmp);
                    }
               }
          }
          prfmsg(CFHLP2);
          break;
     }
}

void
comment(                           /* check for comments when copy/fwd     */
void (*whndun)(int rc))            /*   function to call when finished     */
{
     if ((qsptr->flags&CFWCMT) && strlen(msgtxt)+cmthdrsz+LINLEN < TXTLEN) {
          efvda->whndun=whndun;
          if (qsptr->flags&ALWCMT) {
               if (!(qsptr->flags&USRSET)) {
                    prfmsg(CMTNOW);
                    outprf(usrnum);
               }
               addcmt();
          }
          else {
               gostt(CMTPMT);
          }
     }
     else {
          (*whndun)(FALSE);
     }
}

void
scmtpmt(void)                      /* state: add comments when copy/fwd?   */
{
     switch (cncyesno()) {
     case 'Y':
          addcmt();
          break;
     case 'N':
          (*efvda->whndun)(FALSE);
          break;
     default:
          errhlp(YORN,CMTPMT);
          break;
     }
}

void
addcmt(void)                       /* start up editor to add comments      */
{
     char *cp;
     int pflvl;
     unsigned txtlen,dstfor;

     txtlen=strlen(msgtxt);
     efvda->cmtspc=TXTLEN-txtlen-1;
     movmem(msgtxt,&msgtxt[efvda->cmtspc],txtlen+1);
     sprintf(msgtxt,abvcmt,usaptr->userid);
     cp=msgtxt+strlen(msgtxt);
     txtlen=efvda->cmtspc-cmthdrsz;
     setmem(cp,txtlen,0);          /* to avoid possible FSE comprbuf() err */
     bgnedt(txtlen,cp,TPCSIZ,msg->topic,cmtdone,ED_CLRTXT+ED_FIXTOP);
     dstfor=msg->forum;
     if (msg->forum == EMLID && isforum(msg->to)) {
          dstfor=getfid(&msg->to[1]);
     }
     if (dstfor != EMLID) {
          pflvl=getdefp(dstfor)->pfnlvl;
          if (pflvl != DFTPFN) {
               edtpfn(pflvl);
          }
     }
     peruflg[usrnum]|=INEDIT;
}

BOOL                               /*   returns TRUE to stay in module     */
cmtdone(                           /* done editing comments                */
int edflgs)                        /*   edit result flags                  */
{
     setmeup();
     peruflg[usrnum]&=~INEDIT;
     if (!(edflgs&ED_QUITEX)) {
          sprintf(msgtxt+strlen(msgtxt),blwcmt,usaptr->userid);
          movmem(&msgtxt[efvda->cmtspc],msgtxt+strlen(msgtxt),
                 strlen(&msgtxt[efvda->cmtspc])+1);
     }
     (*efvda->whndun)((edflgs&ED_QUITEX) != 0);
     efvda->dftchr=getdft();
     outprf(usrnum);
     return(TRUE);
}

void
fwdit(                             /* initiate message forward process     */
void (*whndun)(int rc))            /*   function to invoke when finished   */
{
     cncall();
     setgmecb(efwork,fwdcpycb);
     efvda->whndun=whndun;
     usrptr->substt=FWDING;
     docyc(FALSE);
}

void
cfwdr(void)                        /* cycled message forward process       */
{
     int rc;

     switch (rc=fwdmsg(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          if (efvda->cflags&WCPYING) {
               efvda->count=spin(efvda->count);
               outprf(usrnum);
          }
          docyc(FALSE);
          break;
     default:
          (*efvda->whndun)(rc);
          chkcyc();
          break;
     }
}

void
copyit(                            /* initiate message copy process        */
void (*whndun)(int rc))            /*   function to invoke when finished   */
{
     cncall();
     setgmecb(efwork,fwdcpycb);
     efvda->whndun=whndun;
     usrptr->substt=COPYING;
     docyc(FALSE);
}

void
ccopyr(void)                       /* cycled message copy process          */
{
     int rc;

     switch (rc=copymsg(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          if (efvda->cflags&WCPYING) {
               efvda->count=spin(efvda->count);
               outprf(usrnum);
          }
          docyc(FALSE);
          break;
     default:
          (*efvda->whndun)(rc);
          chkcyc();
          break;
     }
}

void
fwdcpycb(                          /* show progress of forward/copy        */
int evt,                           /*   current event                      */
int rc)                            /*   result of last operation           */
{
     (void)rc;
     switch (evt) {
     case EVTCPYS:
          prfmsg(CPYATT);
          outprf(usrnum);
          efvda->cflags|=WCPYING;
          break;
     case EVTCPYD:
          prf("\b\n");
          outprf(usrnum);
          efvda->cflags&=~WCPYING;
          break;
     }
}

void
docyc(                             /* switch from input mode to cycle mode */
BOOL lock)                         /*   lock out input while cycling?      */
{
     if (!(efvda->cflags&DIDCYC)) {
          efvda->cflags&=~CKDCYC;
          if (morcnc()) {
               stlcpy(efvda->inpsav,cncall(),DFTIMX+1);
               clrprf();
          }
          else {
               *efvda->inpsav='\0';
          }
          if (lock) {
               btulok(usrnum,TRUE);
          }
     }
     efvda->cflags&=~DIDCYC;
     btuinj(usrnum,CYCLE);
}

void
cycall(void)                       /* cncall() equivalent for cycled proc  */
{
     if (efvda->cflags&DIDCYC) {
          *efvda->inpsav='\0';
     }
     else {
          cncall();
     }
}

void
chkcyc(void)                       /* return from cycling to input handler */
{
     if ((efvda->cflags&DIDCYC) && !(efvda->cflags&CKDCYC)) {
          efvda->cflags|=CKDCYC;
          efvda->dftchr=getdft();
          if (*efvda->inpsav == '\0') {
               efvda->cflags&=~DIDCYC;
               outprf(usrnum);
          }
          else {
               clrprf();
               btuinj(usrnum,CRSTG);
          }
          btulok(usrnum,FALSE);
     }
}

void
rstcnc(void)                       /* restore concat context after cycling */
{
     stlcpy(input,efvda->inpsav,DFTIMX+1);
     parsin();
     efvda->cflags&=~(DIDCYC+CKDCYC);
}

/* The following routine generates message summary lines like this:

Date: Monday, September 29, 1994  12:02am    *PRIORITY*        Electronic Mail
From: Marc Fountain                                           Msg#: 1234567890
  To: Chris Robert                                  *RETURN RECEIPT REQUESTED*
  Re: The best System I've ever used!                       File: MAJORBBS.EXE
      (Reply to #76543, Copy by Jack Alvrus, Fwd by Brian Step*)

     or this (Forum messages viewed from E-mail or Forums):

Date: Wednesday, September 31, 1994  12:02pm                Forum: TechSupport
From: Tim Stark                                               Msg#: 1234567890
  To: Bill Hyatt                                                      *EXEMPT*
  Re: the second law of thermodynamics...
                                                                 (123 replies)
*/

void
sumams(                            /* generate message summary lines       */
int txtblk,                        /*   level 6 text block to use          */
struct message *dspmsg)            /*   for given message                  */
{
     ASSERT(dspmsg != NULL);
     if (dspmsg->forum == EMLID) {
          prfmsg(txtblk,
            datlin(dspmsg->crdate,dspmsg->crtime),
            (dspmsg->flags&PRIMSG) ? "*PRIORITY*" : "",
            "Electronic Mail",
            adrfld(dspmsg->from,vdatmp,50),
            spr("Msg#: %ld",dspmsg->msgid),
            adrfld(dspmsg->to,vdatmp+MAXADR,40),
            (dspmsg->flags&RECREQ) ? "*RETURN RECEIPT REQUESTED*" : "",
            dspmsg->topic,
            (dspmsg->flags&FILATT) ? spr("File: %s",dspmsg->attname) : "",
            hststr(dspmsg->history),
            nrstr(dspmsg->nrpl));
     }
     else {
          prfmsg(txtblk,
            datlin(dspmsg->crdate,dspmsg->crtime),
            "",
            fnmlin(dspmsg->forum),
            adrfld(dspmsg->from,vdatmp,50),
            spr("Msg#: %ld",dspmsg->msgid),
            adrfld(dspmsg->to,vdatmp+MAXADR,40),
            (dspmsg->flags&EXEMPT) ? "*EXEMPT*" : "",
            dspmsg->topic,
            (dspmsg->flags&FILATT) ? spr("File: %s",dspmsg->attname) : "",
            hststr(dspmsg->history),
            nrstr(dspmsg->nrpl));
     }
     if (!(*(dspmsg->history) == '\0' && dspmsg->nrpl == 0)) {
          prf("\n");
     }
}

char *
datlin(                            /* build date/time string               */
unsigned date,                     /*   from DOS packed date               */
unsigned time)                     /*   and DOS packed time                */
{
     static char retval[40];

     strcpy(retval,prnday(date,9));
     strcat(retval,", ");
     strcat(retval,prndat(22,date,','));
     strcat(retval,"  ");
     strcat(retval,prntim(2,time));
     return(retval);
}

char *
fnmlin(                            /* generate forum name string           */
unsigned forum)                    /*   forum ID                           */
{
     static char s[FNMSIZ+sizeof("Forum: ")];

     strcpy(s,"Forum: ");
     stlcat(s,getfnm(forum),sizeof(s));
     return(s);
}

char *
hststr(                            /* history string formatter             */
char *history)                     /*   history string to format           */
{
     return(*history == '\0' ? "" : spr("(%s)",history));
}

char *
adrfld(                            /* massage address for display          */
char *adr,                         /*   address to display                 */
char *buf,                         /*   additional buffer to use if nec.   */
int maxlen)                        /*   max # chars alotted in slot        */
{
     int len;

     ASSERT(adr != NULL);
     ASSERT(buf != NULL);
     if (strlen(adr) < maxlen) {
          return(adr);
     }
     strcpy(buf,adr);
     len=(((strlen(buf)-maxlen)/80)+1)*80+maxlen+1;
     padfld(buf,len);
     return(buf);
}

char *
nrstr(                             /* generate "number of replies" string  */
int nr)                            /*   number of replies                  */
{
     ASSERT(nr >= 0);
     switch (nr) {
     case 0:
          return("");
     case 1:
          return("(1 reply)");
     default:
          return(spr("(%d replies)",nr));
     }
}


char *
anpstr(                            /* ALWAYS/NEVER/PROMPT string           */
int flags,                         /*   flag field to check                */
int pmtflg,                        /*   flag set when "PROMPT"             */
int alwflg)                        /*   flag set when "ALWAYS"             */
{
     if (flags&pmtflg) {
          if (flags&alwflg) {
               return("ALWAYS");
          }
          return("PROMPT");
     }
     return("NEVER");
}

char *
ynstr(                             /* YES/NO string                        */
int flags,                         /*   flag field to check                */
int ynflg)                         /*   flag set when "YES"                */
{
     if (flags&ynflg) {
          return("YES");
     }
     return("NO");
}

char *
rmodstr(                           /* read mode string (FULL/BROWSE)       */
int flags,                         /*   flag field to check                */
int modflg)                        /*   flag set when "FULL"               */
{
     if (flags&modflg) {
          return("FULL");
     }
     return("BROWSE");
}

char *
cfortvar(void)                     /* current Forum text variable          */
{
     return(getdefp(ucurfor(usrnum))->name);
}

int
foppkey(                           /* Forum-Op (current Forum) pseudokey   */
int unum,                          /*   user number to check on            */
char *lock)                        /*   lock name to check on              */
{
     struct qscfg *qsp;

     if (sameas(lock,"_FORUMOP")) {
          qsp=uqsptr(unum);
          if (*qsp->userid != '\0') {
               return(qforac(qsp,ucurfor(unum)) >= OPAXES);
          }
     }
     return(0);
}

unsigned                           /*   always returns a valid forum ID    */
ucurfor(                           /* get current forum ID                 */
int unum)                          /*   for this user                      */
{
     unsigned fid;
     struct qscfg *qsp;

     qsp=uqsptr(unum);
     fid=qsp->curfor;
     if (*qsp->userid == '\0' || !fidxst(fid)) {
          fid=dftfor;
     }
     return(fid);
}

/* backward-compatibility exports */

BOOL                               /*   returns TRUE if successful         */
oldsend(                           /* backward-compatible to 6.X sendmsg() */
struct oldmsg *msg,                /*   6.X message structure              */
char *to)                          /*   destination address                */
{
     return(_oldsend(msg,to));
}

char *                             /*   pointer to filespec                */
oldafs(                            /* backward-compatible attachment fspec */
struct oldmsg *msg)                /*   old message structure              */
{
     return(_oldafs(msg));
}

char *                             /*   pointer to topic string            */
sigtpc(                            /* backward-compatible forum topic      */
unsigned forum)                    /*   forum ID to get topic for          */
{
     if (fidxst(forum+1)) {
          return(getftpc(forum+1));
     }
     return("");
}

int                                /*   TRUE if access > NOAXES            */
saxxok(                            /* current user has access to Forum?    */
unsigned forum)                    /*   forum ID to get topic for          */
{
     return(faccok(forum+1));
}

BOOL
ouidxst(                           /* backward-compatible uidxst()         */
char *uid)                         /*   User-ID buffer                     */
{
     if (uidxst(uid)) {
          stlcpy(uid,accbb->key,UIDSIZ);
          return(TRUE);
     }
     return(FALSE);
}

