VERSION 4.00
Begin VB.Form frmImpExp 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "VisData Imp/Exp"
   ClientHeight    =   4905
   ClientLeft      =   2190
   ClientTop       =   1410
   ClientWidth     =   4725
   Height          =   5310
   HelpContextID   =   2016092
   Icon            =   "VBIMEX.frx":0000
   Left            =   2130
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4905
   ScaleWidth      =   4725
   Top             =   1065
   Width           =   4845
   Begin VB.CommandButton cmdClose 
      Cancel          =   -1  'True
      Caption         =   "&Close"
      Height          =   375
      Left            =   2400
      TabIndex        =   4
      Top             =   120
      Width           =   2055
   End
   Begin VB.CommandButton cmdExportSQL 
      Caption         =   "Export &SQL Results"
      Enabled         =   0   'False
      Height          =   375
      Left            =   2400
      TabIndex        =   0
      Top             =   600
      Width           =   2055
   End
   Begin VB.CommandButton cmdImport 
      Caption         =   "&Import"
      Height          =   375
      Left            =   240
      TabIndex        =   1
      Top             =   120
      Width           =   2055
   End
   Begin VB.ListBox lstTables 
      Height          =   3735
      Left            =   120
      MultiSelect     =   2  'Extended
      TabIndex        =   3
      Top             =   1080
      Width           =   4470
   End
   Begin VB.CommandButton cmdExport 
      Caption         =   "&Export Table(s)"
      Enabled         =   0   'False
      Height          =   375
      Left            =   240
      TabIndex        =   2
      Top             =   600
      Width           =   2055
   End
End
Attribute VB_Name = "frmImpExp"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdClose_Click()
  Unload Me
End Sub

Private Sub cmdExport_Click()
  On Error GoTo ExpErr
  
  Dim i As Integer

  For i = 0 To lstTables.ListCount - 1
    If lstTables.Selected(i) Then
      frmDataType.Caption = "Export '" & lstTables.List(i) & "'"
      frmDataType.Show vbModal
      lstTables.Selected(i) = False
      If gnDataType <> gnDT_NONE Then
        If gnDataType <> gnDT_SQLDB Then
          SetCommDlg
          If Not (gnDataType = gnDT_JETMDB Or gnDataType = gnDT_BTRIEVE) Then
            frmMDI.dlgCMD1.Flags = FileOpenConstants.cdlOFNHideReadOnly
          End If
          frmMDI.dlgCMD1.ShowSave
          If Len(frmMDI.dlgCMD1.FileName) > 0 Then
            Export (lstTables.List(i)), (frmMDI.dlgCMD1.FileName)
          End If
        Else
          Export (lstTables.List(i)), gsNULL_STR
        End If
      End If
    End If
  Next

  cmdExport.Enabled = False

  Exit Sub

ExpErr:
  If Err = 32755 Then Exit Sub
  ShowError
  Exit Sub

End Sub

Private Sub cmdExportSQL_Click()
  On Error GoTo SQLExpErr
  
  Dim i As Integer

  frmDataType.Caption = "Export '" & lstTables.List(i) & "'"
  frmDataType.Show vbModal
  If gnDataType <> gnDT_NONE Then
    If gnDataType <> gnDT_SQLDB Then
      SetCommDlg
      If Not (gnDataType = gnDT_JETMDB Or gnDataType = gnDT_BTRIEVE) Then
        frmMDI.dlgCMD1.Flags = FileOpenConstants.cdlOFNHideReadOnly
      End If
      frmMDI.dlgCMD1.ShowSave
      If Len(frmMDI.dlgCMD1.FileName) > 0 Then
        Export gsNULL_STR, (frmMDI.dlgCMD1.FileName)
      End If
    Else
      Export gsNULL_STR, gsNULL_STR
    End If
  End If

  Exit Sub

SQLExpErr:
  If Err = 32755 Then Exit Sub
  ShowError
  Exit Sub

End Sub

Private Sub cmdImport_Click()
  On Error GoTo ImpErr

  frmDataType.Caption = "Import"
  frmDataType.Show vbModal

  If gnDataType = gnDT_NONE Then Exit Sub
  
  If gnDataType <> gnDT_SQLDB Then
    SetCommDlg
    frmMDI.dlgCMD1.ShowOpen
    If Len(frmMDI.dlgCMD1.FileName) > 0 Then
      If gnDataType = gnDT_JETMDB Or gnDataType = gnDT_BTRIEVE Then
        If gnDataType = gnDT_JETMDB Then
          Set gImpDB = gwsMainWS.OpenDatabase(frmMDI.dlgCMD1.FileName)
        ElseIf gnDataType = gnDT_EXCEL50 Or gnDataType = gnDT_EXCEL40 Or gnDataType = gnDT_EXCEL30 Then
          'we can use Excel 5.0 for all Excel files because the
          'ISAM will figure out the version from the file itself
          'instead of relying on the connect string
          Set gImpDB = gwsMainWS.OpenDatabase(frmMDI.dlgCMD1.FileName, 0, 0, gsEXCEL50)
        Else
          Set gImpDB = gwsMainWS.OpenDatabase(frmMDI.dlgCMD1.FileName, 0, 0, gsBTRIEVE)
        End If
        If gImpDB Is Nothing Then Exit Sub
        frmImpTbls.Label1.Caption = frmImpTbls.Label1 & gImpDB.Name
        frmImpTbls.Show vbModal
      Else
        Import (frmMDI.dlgCMD1.FileName)
        While Len(frmMDI.dlgCMD1.FileName) > 0
          frmMDI.dlgCMD1.FileName = gsNULL_STR
          frmMDI.dlgCMD1.ShowOpen
          Import (frmMDI.dlgCMD1.FileName)
        Wend
      End If
    End If
  Else
    Set gImpDB = gwsMainWS.OpenDatabase(gsNULL_STR, 0, 0, "odbc;")
    If gImpDB Is Nothing Then Exit Sub
    frmImpTbls.Label1.Caption = frmImpTbls.Label1.Caption & gImpDB.Name
    frmImpTbls.Show vbModal
  End If
  
  Screen.MousePointer = vbDefault
  Exit Sub

ImpErr:
  If Err <> 32755 Then
    ShowError
  End If
  Screen.MousePointer = vbDefault
  Exit Sub

End Sub

Private Sub lstTables_Click()
  cmdExport.Enabled = True
End Sub

Private Sub lstTables_DblClick()
  Call cmdExport_Click
End Sub

Private Sub Form_Load()
  CenterMe Me, gnMDIFORM
  
  If UCase(Mid(frmSQL.txtSQLStatement, 1, 7)) = "SELECT " Then
    cmdExportSQL.Enabled = True
  End If
  GetTableList frmImpExp.lstTables, False, False, True
  
  MsgBar gsNULL_STR, False
End Sub

Private Sub Form_Resize()
  If WindowState <> 2 Then
    lstTables.Width = Width - 340
    Refresh
  End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Unload frmDataType
End Sub

Private Sub SetCommDlg()
   With frmMDI.dlgCMD1
     .DialogTitle = "Select File"
     Select Case gnDataType
       Case gnDT_JETMDB
         .Filter = "Microsoft Access (*.mdb)|*.mdb|All Files (*.*)|*.*"
         .DialogTitle = "Select Microsoft Access Database"
         .Flags = FileOpenConstants.cdlOFNHideReadOnly
       Case gnDT_PARADOX3X, gnDT_PARADOX4X
         .Filter = "Paradox (*.db)|*.db"
         .Flags = FileOpenConstants.cdlOFNOverwritePrompt Or FileOpenConstants.cdlOFNHideReadOnly
       Case gnDT_FOXPRO26, gnDT_FOXPRO25, gnDT_FOXPRO20, gnDT_DBASEIV, gnDT_DBASEIII
         .Filter = "Xbase (*.dbf)|*.dbf"
         .Flags = FileOpenConstants.cdlOFNOverwritePrompt Or FileOpenConstants.cdlOFNHideReadOnly
       Case gnDT_BTRIEVE
         .Filter = "Btrieve (FILE.DDF)|FILE.DDF"
         .Flags = FileOpenConstants.cdlOFNHideReadOnly
       Case gnDT_EXCEL50, gnDT_EXCEL40, gnDT_EXCEL30
         .Filter = "Excel (*.xls)|*.xls"
         .Flags = FileOpenConstants.cdlOFNOverwritePrompt Or FileOpenConstants.cdlOFNHideReadOnly
       Case gnDT_TEXTFILE
         .Filter = "Text Files (*.txt)|*.txt|All Files (*.*)|*.*"
         .DialogTitle = "Select Text File"
         .Flags = FileOpenConstants.cdlOFNOverwritePrompt Or FileOpenConstants.cdlOFNHideReadOnly
     End Select

     .FilterIndex = 1
     .FileName = gsNULL_STR
     .CancelError = True
  End With
End Sub
