VERSION 4.00
Begin VB.Form frmOpenDB 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Open ODBC Datasource"
   ClientHeight    =   2550
   ClientLeft      =   2460
   ClientTop       =   3855
   ClientWidth     =   5070
   ForeColor       =   &H00000000&
   Height          =   2955
   HelpContextID   =   2016138
   Icon            =   "OPENDB.frx":0000
   Left            =   2400
   LinkTopic       =   "Form2"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2502.457
   ScaleMode       =   0  'User
   ScaleWidth      =   5130.082
   Top             =   3510
   Width           =   5190
   Begin VB.ComboBox cboDatasource 
      BackColor       =   &H00FFFFFF&
      Height          =   300
      Left            =   120
      Sorted          =   -1  'True
      TabIndex        =   0
      Top             =   360
      Width           =   2655
   End
   Begin VB.TextBox txtDatabase 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   120
      TabIndex        =   1
      Top             =   960
      Width           =   2655
   End
   Begin VB.TextBox txtUserName 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   120
      TabIndex        =   2
      Top             =   1530
      Width           =   2655
   End
   Begin VB.TextBox txtPassword 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   120
      PasswordChar    =   "*"
      TabIndex        =   3
      Top             =   2160
      Width           =   2655
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "&Open"
      Default         =   -1  'True
      Height          =   375
      Left            =   3000
      TabIndex        =   4
      Top             =   360
      Width           =   1935
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   3000
      TabIndex        =   5
      Top             =   840
      Width           =   1935
   End
   Begin VB.Label lblLabels 
      Height          =   1095
      Index           =   0
      Left            =   3000
      TabIndex        =   10
      Top             =   1320
      Width           =   1935
   End
   Begin VB.Label lblLabels 
      AutoSize        =   -1  'True
      Caption         =   "Database: "
      Height          =   195
      Index           =   1
      Left            =   120
      TabIndex        =   9
      Top             =   720
      Width           =   780
   End
   Begin VB.Label lblLabels 
      AutoSize        =   -1  'True
      Caption         =   "Datasource: "
      Height          =   195
      Index           =   2
      Left            =   120
      TabIndex        =   6
      Top             =   105
      Width           =   915
   End
   Begin VB.Label lblLabels 
      AutoSize        =   -1  'True
      Caption         =   "User ID: "
      Height          =   195
      Index           =   3
      Left            =   120
      TabIndex        =   7
      Top             =   1320
      Width           =   630
   End
   Begin VB.Label lblLabels 
      AutoSize        =   -1  'True
      Caption         =   "Password: "
      Height          =   195
      Index           =   4
      Left            =   120
      TabIndex        =   8
      Top             =   1890
      Width           =   780
   End
End
Attribute VB_Name = "frmOpenDB"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Dim mbBeenLoaded As Integer

Private Sub cmdCancel_Click()
  gbDBOpenFlag = False
  gsDBName = gsNULL_STR
  Unload Me
End Sub

Private Sub cboDatasource_Click()
  On Error Resume Next

  Dim sTmp As String
  Dim x As Integer

  txtDatabase.Text = gsNULL_STR
  txtUserName.Text = gsNULL_STR
  txtPassword.Text = gsNULL_STR

  'get the datasource if there is one
  sTmp = String(255, 32)
  x = OSGetPrivateProfileString(cboDatasource.Text, "database", gsNULL_STR, sTmp, Len(sTmp), "ODBC.INI")
  txtDatabase.Text = Mid(sTmp, 1, x)

  'get the last user name is there is one
  sTmp = String(255, 32)
  x = OSGetPrivateProfileString(cboDatasource.Text, "lastuser", gsNULL_STR, sTmp, Len(sTmp), "ODBC.INI")
  txtUserName.Text = Mid(sTmp, 1, x)

  txtPassword.Text = gsNULL_STR

  If Len(txtUserName.Text) > 0 Then
    txtPassword.SetFocus
  Else
    txtDatabase.SetFocus
  End If

End Sub

Private Sub Form_Load()
  CenterMe Me, gnMDIFORM
  
  GetDataSources cboDatasource

  cboDatasource.Text = gsODBCDatasource
  txtDatabase.Text = gsODBCDatabase
  txtUserName.Text = gsODBCUserName
  txtPassword.Text = gsODBCPassword

  MsgBar "Enter ODBC Database Parameters", False

  mbBeenLoaded = True

End Sub

Private Sub Form_Unload(Cancel As Integer)
  MsgBar gsNULL_STR, False
End Sub

'
'this routine fills a list box with all available
'ODBC data sources found in ODBC.INI
'
Private Sub GetDataSources(rlstListObject As Object)
  Dim sDataSource As String, sDescription As String
  Dim nDataSourceLen As Integer, nDescriptionLen As Integer
  Dim nRet As Integer
  Dim lHenv As Long     'handle to the environment

  If SQLAllocEnv(lHenv) <> -1 Then
    sDataSource = String(32, 32)
    sDescription = String(255, 32)
    'get the first one
    nRet = SQLDataSources(lHenv, 2, sDataSource, Len(sDataSource), nDataSourceLen, sDescription, Len(sDescription), nDescriptionLen)
    While nRet = 0 Or nRet = 1
      rlstListObject.AddItem Mid(sDataSource, 1, nDataSourceLen)
      sDataSource = String(32, 32)
      sDescription = String(255, 32)
      'get all the others
      nRet = SQLDataSources(lHenv, 1, sDataSource, Len(sDataSource), nDataSourceLen, sDescription, Len(sDescription), nDescriptionLen)
    Wend
  End If

End Sub

Private Sub lblLabels_DblClick(Index As Integer)
  If Index > 0 Then Exit Sub
  If Len(lblLabels(0).Caption) = 0 Then
    lblLabels(0).Caption = "E"           'special case for RAID
  Else
    lblLabels(0).Caption = gsNULL_STR
  End If
End Sub

Private Sub cmdOK_Click()
   On Error GoTo OpenError

   Dim sConnect As String, sDataSource As String
   Dim x As Integer
   Dim i As Integer
   Dim sTmp1 As String, sTmp2 As String

   MsgBar "Opening ODBC Database", True

   If frmMDI.mnuPOpenOnStartup.Checked = True Then
     Me.Refresh
   End If

   SetHourglass

   'check for blank server name and clear other parms
   If Len(cboDatasource.Text) = 0 Then
     txtDatabase.Text = gsNULL_STR
     txtUserName.Text = gsNULL_STR
     txtPassword.Text = gsNULL_STR
   End If

   'build connect string
   sConnect = "ODBC;"
   If Len(txtUserName.Text) > 0 Then
     sConnect = sConnect & "UID=" & txtUserName.Text & ";PWD=" & txtPassword.Text
   End If
   If Len(txtDatabase.Text) > 0 Then
     sConnect = sConnect & ";DATABASE=" & txtDatabase.Text
   End If
    
   'add login timeout
   sConnect = sConnect
   
   '====================================================
   'special case to make RAID databases updatable
   If lblLabels(0) = "E" Then sConnect = sConnect & ";APP=Einstein"
   '====================================================

   sDataSource = cboDatasource.Text

   'save the values
   gsODBCDatasource = cboDatasource.Text
   gsDBName = gsODBCDatasource
   gsODBCDatabase = txtDatabase.Text
   gsODBCUserName = txtUserName.Text
   gsODBCPassword = txtPassword.Text
   gsDataType = gsSQLDB

   Me.Hide
   Set gdbCurrentDB = gwsMainWS.OpenDatabase(sDataSource, False, False, sConnect)
   If gbDBOpenFlag = True Then
     UnloadAllForms
   End If
   gbTransPending = False

   GetODBCConnectParts gdbCurrentDB.Connect

   cboDatasource.Text = gsODBCDatasource
   txtDatabase.Text = gsODBCDatabase
   txtUserName.Text = gsODBCUserName
   txtPassword.Text = gsODBCPassword

   x = OSWritePrivateProfileString(gsDBName, "ODBCDatabase", gsODBCDatabase, "ODBC.INI")
   x = OSWritePrivateProfileString(gsDBName, "LastUser", gsODBCUserName, "ODBC.INI")

   frmMDI.Caption = "VisData:" & gsDBName & "." & gsODBCDatabase
   gdbCurrentDB.QueryTimeout = glQueryTimeout

   'success
   gbDBOpenFlag = True
   AddMRU

   Screen.MousePointer = vbDefault
   Unload Me
   
   Exit Sub

OpenError:
   Screen.MousePointer = vbDefault
   gbDBOpenFlag = False
   If Len(cboDatasource.Text) > 0 Then
     If InStr(1, Error, "ODBC--connection to '" & cboDatasource.Text & "' failed") > 0 Then
       Beep
       MsgBox "This Datasource has not been Registered, this will now be attempted for you!", 48
       txtDatabase.Text = gsNULL_STR
       txtUserName.Text = gsNULL_STR
       txtPassword.Text = gsNULL_STR
       If RegisterDB((cboDatasource.Text)) = True Then
         MsgBox "'" & cboDatasource.Text & "' has been Registered, proceed with Open.", 48
       End If
     ElseIf InStr(1, Error, "Login failed") > 0 Then
       Beep
       MsgBox "Invalid Parameter(s), Please try again!", 48
     ElseIf InStr(1, Error, "QueryTimeout property") > 0 Then
       If glQueryTimeout <> 5 Then
         Beep
         MsgBox "Query Timeout Could not be set, default will be used!", 48
       End If
       Resume Next
     Else
       ShowError
     End If
   End If

   MsgBar "Enter ODBC Database Parameters", False
   Me.Show vbModal
   Exit Sub

End Sub

Private Function RegisterDB(rsDatasource As String) As Integer
   On Error GoTo RDBErr

   Dim sDriver As String

   sDriver = InputBox("Enter Driver Name from ODBCINST.INI File:", "Driver Name", gsDEFAULT_DRIVER)
   If sDriver <> gsDEFAULT_DRIVER Then
     DBEngine.RegisterDatabase rsDatasource, sDriver, False, gsNULL_STR
   Else
     DBEngine.RegisterDatabase rsDatasource, sDriver, True, gsNULL_STR
   End If

   RegisterDB = True
   Exit Function

RDBErr:
   RegisterDB = False
   Exit Function
   
End Function

Private Sub txtDatabase_GotFocus()
  SendKeys "+{end}"
End Sub

Private Sub txtPassword_GotFocus()
  SendKeys "+{end}"
End Sub

Private Sub txtUserName_GotFocus()
  SendKeys "+{end}"
End Sub
