VERSION 4.00
Begin VB.Form DIALER 
   Caption         =   "MSComm Phone Dialer"
   ClientHeight    =   2205
   ClientLeft      =   4005
   ClientTop       =   3270
   ClientWidth     =   3270
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   0
      weight          =   400
      size            =   8.25
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   Height          =   2610
   Left            =   3945
   LinkTopic       =   "Form2"
   ScaleHeight     =   2205
   ScaleWidth      =   3270
   Top             =   2925
   Width           =   3390
   Begin VB.CommandButton CancelButton 
      Caption         =   "Cancel"
      Enabled         =   0   'False
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   348
      Left            =   1200
      TabIndex        =   4
      Top             =   1728
      Width           =   852
   End
   Begin VB.CommandButton QuitButton 
      Cancel          =   -1  'True
      Caption         =   "Quit"
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   348
      Left            =   2160
      TabIndex        =   2
      Top             =   1728
      Width           =   852
   End
   Begin VB.CommandButton DialButton 
      Caption         =   "Dial"
      Default         =   -1  'True
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   348
      Left            =   240
      TabIndex        =   1
      Top             =   1728
      Width           =   852
   End
   Begin VB.ListBox List1 
      Height          =   1005
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   2775
   End
   Begin MSCommLib.MSComm Comm1 
      Height          =   480
      Left            =   105
      TabIndex        =   5
      Top             =   105
      Visible         =   0   'False
      Width           =   480
      _version        =   65536
      _extentx        =   847
      _extenty        =   847
      _stockprops     =   0
      cdtimeout       =   0
      commport        =   1
      ctstimeout      =   0
      dsrtimeout      =   0
      dtrenable       =   -1  'True
      handshaking     =   0
      inbuffersize    =   1024
      inputlen        =   0
      interval        =   1000
      nulldiscard     =   0   'False
      outbuffersize   =   512
      parityreplace   =   "?"
      rthreshold      =   0
      rtsenable       =   0   'False
      settings        =   "9600,N,8,1"
      sthreshold      =   0
   End
   Begin VB.Label Status 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Select a party to call"
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   252
      Left            =   240
      TabIndex        =   3
      Top             =   1296
      Width           =   2772
   End
End
Attribute VB_Name = "DIALER"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
'--------------------------------------------------------
'   DIALER.FRM
'   Copyright (c) 1994 Crescent Software, Inc.
'   by Carl Franklin
'
'   Demonstrates how to dial phone numbers with a modem.
'
'   For this program to work, your telephone and
'   modem must be connected to the same phone line.
'--------------------------------------------------------
Option Explicit

DefInt A-Z

' Phone numbers are stored here.
Dim PhoneNumbers$()

' This flag is set when the user chooses Cancel.
Dim CancelFlag

Private Sub CancelButton_Click()
    ' CancelFlag tells the Dial procedure to exit.
    CancelFlag = True
    CancelButton.Enabled = False
End Sub

Private Sub Dial(Number$)
    Dim DialString$, FromModem$, dummy

    ' AT is the Hayes compatible ATTENTION command and is required to send commands to the modem.
    ' DT means "Dial Tone." The Dial command uses touch tones, as opposed to pulse (DP = Dial Pulse).
    ' PhoneNumbers$(Index) is the phone number being dialed.
    ' A semicolon tells the modem to return to command mode after dialing (important).
    ' A carriage return, Chr$(13), is required when sending commands to the modem.
    DialString$ = "ATDT" + Number$ + ";" + Chr$(13)

    ' Communications port settings.
    Comm1.Settings = "300,N,8,1"
    
    ' Open the communications port.
    On Error Resume Next
    Comm1.PortOpen = True
    If Err Then
       MsgBox "COM1: not available. Change the CommPort property to another port."
       Exit Sub
    End If
    
    ' Flush the input buffer.
    Comm1.InBufferCount = 0
    
    ' Dial the number.
    Comm1.Output = DialString$
    
    ' Wait for "OK" to come back from the modem.
    Do
       dummy = DoEvents()
       ' If there is data in the buffer, then read it.
       If Comm1.InBufferCount Then
          FromModem$ = FromModem$ + Comm1.Input
          ' Check for "OK".
          If InStr(FromModem$, "OK") Then
             ' Notify the user to pick up the phone.
             Beep
             MsgBox "Please pick up the phone and either press Enter or click OK"
             Exit Do
          End If
       End If
        
       ' Did the user choose Cancel?
       If CancelFlag Then
          CancelFlag = False
          Exit Do
       End If
    Loop
    
    ' Disconnect the modem.
    Comm1.Output = "ATH" + Chr$(13)
    
    ' Close the port.
    Comm1.PortOpen = False
End Sub

Private Sub DialButton_Click()
    Dim Number$, Temp$
    
    DialButton.Enabled = False
    QuitButton.Enabled = False
    CancelButton.Enabled = True
    
    ' Get the number to dial.
    Number$ = PhoneNumbers$(List1.ListIndex)

    Temp$ = Status
    Status = "Dialing - " + Number$
    
    ' Dial the selected phone number.
    Dial Number$

    DialButton.Enabled = True
    QuitButton.Enabled = True
    CancelButton.Enabled = False

    Status = Temp$
End Sub

Private Sub Form_Load()
    ' Setting InputLen to 0 tells MSComm to read the entire
    ' contents of the input buffer when the Input property
    ' is used.
    Comm1.InputLen = 0
    
    DIALER.Show

    ' Load the list box with names.
    List1.AddItem "Information"
    List1.AddItem "800 Information"

    ' Phone numbers.
    ReDim PhoneNumbers$(0 To List1.ListCount - 1)
    PhoneNumbers$(0) = "1-555-1212"
    PhoneNumbers$(1) = "1-800-555-1212"

    ' Select the first name as the default.
    List1.ListIndex = 0
End Sub

Private Sub List1_DblClick()
    ' Invoke the Dial button.
    DialButton_Click
End Sub

Private Sub QuitButton_Click()
    End
End Sub

