VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "SpyEvents"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit
Public SpyMenuLine As VBIDE.MenuLine
Private SpyEnabled As Boolean

'Converter for FileType variables to a string explanation
Private Function ConvertFileType(FileType As Integer) As String
    Select Case FileType
        Case 0
            ConvertFileType = "Form"
        Case 1
            ConvertFileType = "Module"
        Case 2
            ConvertFileType = "Class"
        Case 3
            ConvertFileType = "Project"
        Case 4
            ConvertFileType = ".EXE"
        Case Else
            ConvertFileType = "Unknown"
    End Select
End Function

'Converter for Success variables to a string explanation
Private Function ConvertSuccess(Success As Integer) As String
    Select Case Success
        Case 0
            ConvertSuccess = "Yes"
        Case 1
            ConvertSuccess = "Write was cancelled"
        Case 2
            ConvertSuccess = "Write failed"
        Case Else
            ConvertSuccess = "Unknown"
    End Select
End Function

'If our menu line is clicked, toggle the state of the Checked property
Public Sub AfterClick()
    With SpyMenuLine
        SpyEnabled = Not .Checked
        .Checked = SpyEnabled
        If SpyEnabled Then SpyShow.Visible = True
    End With
End Sub

'Each of the following event handlers takes all the parameters of the event and prints them out
'into the list box to be displayed.  This is done only if the add-in menu line is Checked,
'enabling us.

Public Sub AfterAddFile(FileName As String)
    If SpyEnabled Then
        AddEntry "AfterAddFile Event           FileName       = " & FileName
    End If
End Sub

Public Sub AfterChangeFileName(FileType As Integer, NewName As String, OldName As String)
    If SpyEnabled Then
        AddEntry "AfterChangeFileName Event    FileType       = " & _
                 Format$(FileType, "0") & " for " & ConvertFileType(FileType)
        AddEntry "                             NewName        = " & NewName
        AddEntry "                             OldName        = " & OldName
    End If
End Sub

Public Sub AfterCloseFile(FileNames() As String)
Dim i%
    If SpyEnabled Then
        AddEntry "AfterCloseFile Event         FileNames(" & _
                 Format$(LBound(FileNames), "000") & ") = " & FileNames(LBound(FileNames))
        For i% = LBound(FileNames) + 1 To UBound(FileNames)
            AddEntry "                             FileNames(" & _
                     Format$(i%, "000") & ") = " & FileNames(i%)
        Next i%
    End If
End Sub

Public Sub AfterRemoveFile(FileName As String)
    If SpyEnabled Then
        AddEntry "AfterRemoveFile Event        FileName       = " & FileName
    End If
End Sub

Public Sub AfterWriteFile(FileName As String, Success As Integer)
    If SpyEnabled Then
        AddEntry "AfterWriteFile Event         FileName       = " & FileName
        AddEntry "                             Success        = " & _
                 Format$(Success, "0") & " for " & ConvertSuccess(Success)
    End If
End Sub

Public Sub BeforeLoadFile(FileNames() As String)
Dim i%
    If SpyEnabled Then
        AddEntry "BeforeLoadFile Event         FileNames(" & _
                 Format$(LBound(FileNames), "000") & ") = " & FileNames(LBound(FileNames))
        For i% = LBound(FileNames) + 1 To UBound(FileNames)
            AddEntry "                             FileNames(" & _
                     Format(i%, "000") & ") = " & FileNames(i%)
        Next i%
    End If
End Sub

Public Sub DoGetAddFileName(FileNames() As String, CancelDefault As Boolean)
Dim i%
    If SpyEnabled Then
        AddEntry "DoGetAddFileName Event       FileNames(" & _
                 Format$(LBound(FileNames), "000") & ") = " & FileNames(LBound(FileNames))
        For i% = LBound(FileNames) + 1 To UBound(FileNames)
            AddEntry "                             FileNames(" & _
                     Format$(i%, "000") & ") = " & FileNames(i%)
        Next i%
        AddEntry "                             CancelDefault  = " & CancelDefault
    End If
End Sub

Public Sub DoGetNewFileName(FileType As Integer, NewName As String, OldName As String, CancelDefault As Boolean)
    If SpyEnabled Then
        AddEntry "DoGetNewFileName Event       FileType       = " & _
                 Format$(FileType, "0") & " for " & ConvertFileType(FileType)
        AddEntry "                             NewName        = " & NewName
        AddEntry "                             OldName        = " & OldName
        AddEntry "                             CancelDefault  = " & CancelDefault
    End If
End Sub

Public Sub DoGetOpenProjectName(ProjectName As String, CancelDefault As Boolean)
    If SpyEnabled Then
        AddEntry "DoGetOpenProjectName Event   ProjectName    = " & ProjectName
        AddEntry "                             CancelDefault  = " & CancelDefault
    End If
End Sub

Public Sub RequestChangeFileName(FileType As Integer, NewName As String, OldName As String, Cancel As Boolean)
    If SpyEnabled Then
        AddEntry "RequestChangeFileName Event  FileType       = " & _
                 Format$(FileType, "0") & " for " & ConvertFileType(FileType)
        AddEntry "                             NewName        = " & NewName
        AddEntry "                             OldName        = " & OldName
        AddEntry "                             Cancel         = " & Cancel
    End If
End Sub

Public Sub RequestWriteFile(FileName As String, Cancel As Boolean)
    If SpyEnabled = True Then
        AddEntry "RequestWriteFile Event       FileName       = " & FileName
        AddEntry "                             Cancel         = " & Cancel
    End If
End Sub
