VERSION 4.00
Begin VB.Form Form1 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Soccer League"
   ClientHeight    =   5928
   ClientLeft      =   1920
   ClientTop       =   1920
   ClientWidth     =   8892
   Height          =   6348
   Left            =   1872
   LinkTopic       =   "Form1"
   ScaleHeight     =   5928
   ScaleWidth      =   8892
   Top             =   1548
   Width           =   8988
   Begin VB.CommandButton btnClear 
      Caption         =   "Clear"
      Height          =   375
      Left            =   7200
      TabIndex        =   33
      Top             =   5040
      Width           =   1335
   End
   Begin VB.CommandButton btnLoad 
      Caption         =   "Load"
      Height          =   375
      Left            =   5760
      TabIndex        =   32
      Top             =   5040
      Width           =   1335
   End
   Begin VB.CommandButton btnSave 
      Caption         =   "Save"
      Height          =   390
      Left            =   4440
      TabIndex        =   31
      Top             =   5052
      Width           =   1215
   End
   Begin VB.ComboBox listPlayerName 
      Height          =   288
      Left            =   4440
      Style           =   2  'Dropdown List
      TabIndex        =   23
      Top             =   2640
      Width           =   2364
   End
   Begin VB.CommandButton buttonAddPlayer 
      Caption         =   "Add"
      Height          =   375
      Left            =   6960
      TabIndex        =   22
      Top             =   2640
      Width           =   855
   End
   Begin VB.CommandButton buttonRemovePlayer 
      Caption         =   "Remove"
      Height          =   375
      Left            =   7920
      TabIndex        =   21
      Top             =   2640
      Width           =   855
   End
   Begin VB.ComboBox listPlayerTeam 
      Height          =   288
      Left            =   4440
      Style           =   2  'Dropdown List
      TabIndex        =   20
      Top             =   3240
      Width           =   2364
   End
   Begin VB.ComboBox listPlayerPosition 
      Height          =   288
      Left            =   4440
      Style           =   2  'Dropdown List
      TabIndex        =   19
      Top             =   3960
      Width           =   2364
   End
   Begin VB.CommandButton buttonAddTeam 
      Caption         =   "Add"
      Height          =   372
      Left            =   6960
      TabIndex        =   7
      Top             =   1080
      Width           =   1800
   End
   Begin VB.PictureBox Picture1 
      BackColor       =   &H00000000&
      Height          =   5376
      Left            =   240
      ScaleHeight     =   5352
      ScaleWidth      =   3720
      TabIndex        =   2
      Top             =   252
      Width           =   3744
      Begin VB.PictureBox Picture2 
         BackColor       =   &H00C0C0C0&
         Height          =   5016
         Left            =   204
         ScaleHeight     =   4992
         ScaleWidth      =   3252
         TabIndex        =   3
         Top             =   156
         Width           =   3276
         Begin VB.Label LabelStriker 
            AutoSize        =   -1  'True
            BackColor       =   &H00C0C0C0&
            BackStyle       =   0  'Transparent
            Caption         =   "Striker"
            Height          =   252
            Left            =   1320
            TabIndex        =   18
            Top             =   4680
            Width           =   492
         End
         Begin VB.Label LabelRightFullback 
            AutoSize        =   -1  'True
            BackColor       =   &H00C0C0C0&
            BackStyle       =   0  'Transparent
            Caption         =   "Right Fullback"
            Height          =   195
            Left            =   2040
            TabIndex        =   17
            Top             =   1200
            Width           =   1260
         End
         Begin VB.Label LabelSweeper 
            AutoSize        =   -1  'True
            BackColor       =   &H00C0C0C0&
            BackStyle       =   0  'Transparent
            Caption         =   "Sweeper"
            Height          =   195
            Left            =   1200
            TabIndex        =   16
            Top             =   720
            Width           =   645
         End
         Begin VB.Label LabelLeftFullback 
            AutoSize        =   -1  'True
            BackColor       =   &H00C0C0C0&
            BackStyle       =   0  'Transparent
            Caption         =   "Left Fullback"
            Height          =   195
            Left            =   240
            TabIndex        =   15
            Top             =   1200
            Width           =   1335
         End
         Begin VB.Label LabelRightWing 
            AutoSize        =   -1  'True
            BackColor       =   &H00C0C0C0&
            BackStyle       =   0  'Transparent
            Caption         =   "Right Wing"
            Height          =   195
            Left            =   2040
            TabIndex        =   14
            Top             =   2160
            Width           =   1095
         End
         Begin VB.Label LabelCenterMidfielder 
            BackColor       =   &H00C0C0C0&
            BackStyle       =   0  'Transparent
            Caption         =   "Center Midfielder"
            Height          =   252
            Left            =   960
            TabIndex        =   13
            Top             =   2880
            Width           =   1332
         End
         Begin VB.Label LabelLeftWing 
            AutoSize        =   -1  'True
            BackColor       =   &H00C0C0C0&
            BackStyle       =   0  'Transparent
            Caption         =   "Left Wing"
            Height          =   195
            Left            =   240
            TabIndex        =   12
            Top             =   2160
            Width           =   1215
         End
         Begin VB.Label labelRightForward 
            AutoSize        =   -1  'True
            BackColor       =   &H00C0C0C0&
            BackStyle       =   0  'Transparent
            Caption         =   "Right Forward"
            Height          =   192
            Left            =   2040
            TabIndex        =   11
            Top             =   3960
            Width           =   996
         End
         Begin VB.Label LabelLeftForward 
            AutoSize        =   -1  'True
            BackColor       =   &H00C0C0C0&
            BackStyle       =   0  'Transparent
            Caption         =   "Left Forward"
            Height          =   192
            Left            =   240
            TabIndex        =   10
            Top             =   3960
            Width           =   876
         End
         Begin VB.Label LabelCenter 
            AutoSize        =   -1  'True
            BackColor       =   &H00C0C0C0&
            BackStyle       =   0  'Transparent
            Caption         =   "Center"
            Height          =   192
            Left            =   1320
            TabIndex        =   9
            Top             =   4080
            Width           =   468
         End
         Begin VB.Label LabelGoalie 
            AutoSize        =   -1  'True
            BackColor       =   &H00C0C0C0&
            BackStyle       =   0  'Transparent
            Caption         =   "Goalie"
            Height          =   195
            Left            =   1320
            TabIndex        =   8
            Top             =   240
            Width           =   480
         End
         Begin VB.Shape Shape4 
            Height          =   975
            Left            =   960
            Shape           =   3  'Circle
            Top             =   3840
            Width           =   1095
         End
         Begin VB.Shape Shape3 
            Height          =   4812
            Left            =   120
            Top             =   120
            Width           =   3012
         End
         Begin VB.Shape Shape2 
            Height          =   855
            Left            =   840
            Top             =   120
            Width           =   1575
         End
         Begin VB.Shape Shape1 
            Height          =   495
            Left            =   1080
            Top             =   120
            Width           =   1095
         End
      End
   End
   Begin VB.ComboBox listTeams 
      Height          =   288
      Left            =   4440
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   1080
      Width           =   2364
   End
   Begin VB.Label lblLeague 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "League:"
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   1
         weight          =   700
         size            =   12
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Left            =   4440
      TabIndex        =   30
      Top             =   4644
      Width           =   960
   End
   Begin VB.Line Line1 
      X1              =   4440
      X2              =   8508
      Y1              =   4524
      Y2              =   4524
   End
   Begin VB.Label lblPlayers 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "Players:"
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   1
         weight          =   700
         size            =   12
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   348
      Left            =   4440
      TabIndex        =   29
      Top             =   1920
      Width           =   1140
   End
   Begin VB.Label lblTeam 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "Teams:"
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   1
         weight          =   700
         size            =   12
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   348
      Left            =   4440
      TabIndex        =   28
      Top             =   360
      Width           =   1056
   End
   Begin VB.Label capPlayerName 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "Total Number of Players:"
      Height          =   192
      Left            =   4440
      TabIndex        =   27
      Top             =   2400
      Width           =   1776
   End
   Begin VB.Label Label3 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Team:"
      Height          =   252
      Left            =   4440
      TabIndex        =   26
      Top             =   3000
      Width           =   1452
   End
   Begin VB.Label Label4 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Position:"
      Height          =   252
      Left            =   4440
      TabIndex        =   25
      Top             =   3720
      Width           =   1452
   End
   Begin VB.Label labelNumberPlayers 
      BackColor       =   &H00C0C0C0&
      Caption         =   "0"
      Height          =   252
      Left            =   6360
      TabIndex        =   24
      Top             =   2400
      Width           =   480
   End
   Begin VB.Line IvoWilliamSalmre 
      X1              =   4200
      X2              =   4200
      Y1              =   240
      Y2              =   5640
   End
   Begin VB.Label labelPlayersOnTeam 
      BackColor       =   &H00C0C0C0&
      Caption         =   "0"
      Height          =   252
      Left            =   5760
      TabIndex        =   6
      Top             =   1560
      Width           =   348
   End
   Begin VB.Label Label2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Players on Team:"
      Height          =   240
      Left            =   4440
      TabIndex        =   5
      Top             =   1560
      Width           =   1344
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Number of Teams:"
      Height          =   240
      Left            =   4440
      TabIndex        =   4
      Top             =   840
      Width           =   1344
   End
   Begin VB.Label labelNumberTeams 
      BackColor       =   &H00C0C0C0&
      Caption         =   "0"
      Height          =   252
      Left            =   5880
      TabIndex        =   0
      Top             =   840
      Width           =   348
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

Private Sub btnClear_Click()
    If (MsgBox("Delete all the teams and players in the league", vbOKCancel) = vbOK) Then
        gServerApp.ClearLeague
    End If
    fillTeamsList
    fillPlayersList
End Sub


Private Sub btnLoad_Click()
    Dim Response
    Const MB_IDCANCEL = 3
    Response = InputBox("If a file containing player and team information is available, enter the file's name:")
    If Response = IDCANCEL Then
        Exit Sub
    Else
        gServerApp.Load Response
        fillTeamsList
        fillPlayersList
    End If
End Sub

Private Sub btnSave_Click()
    Dim Response
    Const MB_IDCANCEL = 3
    Response = InputBox("Enter file name:")
    If Response = IDCANCEL Then
        Exit Sub
    Else
        gServerApp.Save Response
    End If
End Sub



Private Sub Form_Load()
    GetAppRef
    fillTeamsList
    fillPoitionsList
    fillPlayersList
    MsgBox "To create players and teams, first add one or more teams." & Chr$(10) & "Then add players, and for each player select a team and position.", 64, "Soccer/Client"
End Sub

Private Sub buttonAddPlayer_Click()
    
    Dim player
    Set player = gServerApp.Players.Add(InputBox("Enter the name of the new player." & Chr(10) & "Click OK, then select a team and position for the player"))
    
    On Error Resume Next
    If (Not (player Is Nothing)) Then
        Dim team As Object
        ' Put the new player on the 'NO TEAM' team.
        Set team = gServerApp.Teams.Item("NO TEAM")
        team.addplayer player
        
        ' Set the position to NO POSITION.
        player.position = "NO POSITION"
        
        ' Update the list.
        fillPlayersList
        
        ' Select the player's name from the combo box.
        Form1.listPlayerName.Text = player.Name
    End If
End Sub

Private Sub buttonAddTeam_Click()
Dim newTeamName As String
    
    ' Get the team's name from an input box and add the team.
    newTeamName = InputBox("Enter Name of new team:")
    gServerApp.Teams.Add newTeamName
    
    ' Add it to the Teams list.
    Form1.listTeams.AddItem newTeamName
    ' Add it to the player's team list.
    Form1.listPlayerTeam.AddItem newTeamName
        
    ' Update the number of teams.
    Form1.labelNumberTeams.Caption = gServerApp.Teams.Count - 1
End Sub


Private Sub buttonRemovePlayer_Click()
    gServerApp.Players.Remove listPlayerName.Text
    
    ' Update the list.
    fillPlayersList

    ' Reset the visual field representation.
    listTeams_Click
End Sub

Private Sub buttonRemoveTeam_Click()
    gServerApp.Teams.Remove listTeams.Text
    ' Update the list.
    fillTeamsList
    
    ' Update the existing player (the player's team may have been deleted).
    listPlayerName_Click
End Sub



' Handle the user selecting a new player from the player list.
Private Sub listPlayerName_Click()
    ' Add the new player's position to the Position list.
    ' Note: this will implicitly call listPlayerPosition_Click.
    Form1!listPlayerPosition.Text = _
            gServerApp.Players.Item(Form1!listPlayerName.Text).position

    ' Add the player's team name to the team list.
    ' Note: this will implicitly call listPlayerTeam_Click.
    Form1!listPlayerTeam.Text = gServerApp.Players.Item(Form1!listPlayerName.Text).team.Name
End Sub

' Change the player's position.
Private Sub listPlayerPosition_Click()
Dim player

    ' Only do something if there's a player.
    If (Form1.listPlayerName <> "") Then
        
        Set player = gServerApp.Players.Item(Form1!listPlayerName.Text)
        ' Change the current player's position to match what was
        ' selected in the list box.
        player.position = Form1!listPlayerPosition.Text
        
        ' Update the field positions.
        If (UCase(player.team.Name) = UCase(Form1.listTeams)) Then
            listTeams_Click
        End If
    End If
End Sub

' Change the current player's team affiliation.
Private Sub listPlayerTeam_Click()
    Dim player
    Dim team
    
    ' Only do something if there's a player.
    If (Form1.listPlayerName <> "") Then
        Set player = gServerApp.Players.Item(Form1!listPlayerName.Text)
        
        ' Add the current player to the team just selected in this box.
        Set team = gServerApp.Teams.Item(Form1!listPlayerTeam.Text)
        team.addplayer player
    
        ' Update the field positions.
        If (UCase(player.team.Name) = UCase(Form1.listTeams)) Then
            listTeams_Click
        End If
    End If
End Sub

Private Sub listTeams_Click()
    Dim newTeam As Object
    Dim aplayer As Object
    Dim loop1
    Dim players_on_Team
    
    ResetPositionNames
    ' Get the Team object corresponding to the current team.
    Set newTeam = gServerApp.Teams.Item(Form1.listTeams.Text)
    
    ' Iterate through all the players and see which ones are on this team.
    players_on_Team = 0
    For loop1 = 1 To gServerApp.Players.Count
        ' Get a player.
        Set aplayer = gServerApp.Players.Item(loop1)
        ' Check to see if the player is on this team.
        If (aplayer.team Is newTeam) Then
            ' Update the counter.
            players_on_Team = players_on_Team + 1
            ' If the player is assigned a position, add the player's name to the field.
            If (UCase(aplayer.position) = "GOALIE") Then Form1.LabelGoalie.Caption = aplayer.Name
            If (UCase(aplayer.position) = "CENTER") Then Form1.LabelCenter.Caption = aplayer.Name
            If (UCase(aplayer.position) = "RIGHT FORWARD") Then Form1.labelRightForward.Caption = aplayer.Name
            If (UCase(aplayer.position) = "LEFT FORWARD") Then Form1.LabelLeftForward.Caption = aplayer.Name
            If (UCase(aplayer.position) = "LEFT WING") Then Form1.LabelLeftWing.Caption = aplayer.Name
            If (UCase(aplayer.position) = "CENTER MIDFIELDER") Then Form1.LabelCenterMidfielder.Caption = aplayer.Name
            If (UCase(aplayer.position) = "RIGHT WING") Then Form1.labelRightWing.Caption = aplayer.Name
            If (UCase(aplayer.position) = "LEFT FULLBACK") Then Form1.LabelLeftFullback.Caption = aplayer.Name
            If (UCase(aplayer.position) = "SWEEPER") Then Form1.LabelSweeper.Caption = aplayer.Name
            If (UCase(aplayer.position) = "RIGHT FULLBACK") Then Form1.LabelRightFullback.Caption = aplayer.Name
            If (UCase(aplayer.position) = "STRIKER") Then Form1.LabelStriker.Caption = aplayer.Name
        End If
    Next

    ' Update the number of players on the team.
    Form1.labelPlayersOnTeam.Caption = Trim(Str(players_on_Team))
End Sub

