VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Ball"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
Attribute VB_Description = "Gravity Ball--Sample OLE Server"
Option Explicit

' *************************************************************************
' GRAVITY.MAK demonstrates how to use OLE Automation.
' It is a sample application that should be used with GRAVTEST.MAK.
' This sample application is the object application, and GRAVTEST.MAK is the
' controlling application.
' Once you run this application, start a second instance of Visual Basic,
' open GRAVTEST.MAK, and then run it.  GRAVTEST.MAK
' uses the Ball object defined in this class module.
' *************************************************************************

' Declare private variables.
Private mdblXVelocity As Double
Private mdblYVelocity As Double
Private mdblStartTime As Double

Public Sub Throw(ByVal dblHorizontalVelocity As Double, ByVal dblVerticalVelocity As Double)
    ' Set read-only variables.
    mdblXVelocity = dblHorizontalVelocity
    mdblYVelocity = dblVerticalVelocity
    
    ' Establishes the time the ball was thrown in the mtti user-defined type variable.
    Dim mtti As Long
    mtti = timeGetTime()
    ' Time is measured in milliseconds (since system start.)
    mdblStartTime = CDbl(mtti) / 1000
End Sub

' The read-only Distance property stores the distance from the throwing point
' for each timer interval after the throw.
Property Get Distance(ByVal dblCurrentTime As Double) As Double
    Dim dblElapsed As Double
    dblElapsed = dblCurrentTime - mdblStartTime
    Distance = dblElapsed * mdblXVelocity
End Property

' The read-only Height property stores the height from the throwing point
' for each timer interval after the throw.
Property Get Height(ByVal dblCurrentTime As Double) As Double
    Dim dblElapsed As Double
    dblElapsed = dblCurrentTime - mdblStartTime
    Height = mdblYVelocity * dblElapsed - 16 * dblElapsed * dblElapsed
End Property
