VERSION 4.00
Begin VB.Form LoanSheet 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "LoanSheet"
   ClientHeight    =   5115
   ClientLeft      =   420
   ClientTop       =   1845
   ClientWidth     =   7065
   ClipControls    =   0   'False
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   1
      weight          =   700
      size            =   8.25
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   Height          =   5805
   Icon            =   "LOAN.frx":0000
   Left            =   360
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5115
   ScaleWidth      =   7065
   Top             =   1215
   Width           =   7185
   Begin VB.CommandButton cmdCalcAmort 
      Caption         =   "Show Amortization"
      Enabled         =   0   'False
      Height          =   375
      Left            =   120
      TabIndex        =   16
      Top             =   4560
      Width           =   2295
   End
   Begin VB.CommandButton cmdCalcPmts 
      Caption         =   "Show Payments"
      Default         =   -1  'True
      Height          =   375
      Left            =   120
      TabIndex        =   7
      Top             =   4065
      Width           =   2295
   End
   Begin VB.Frame frmLoanLen 
      Caption         =   "Years in Loan"
      Height          =   1335
      Left            =   120
      TabIndex        =   13
      Top             =   1200
      Width           =   2295
      Begin VB.TextBox txtLenMax 
         Height          =   285
         Left            =   1440
         TabIndex        =   3
         Top             =   360
         Width           =   615
      End
      Begin VB.TextBox txtLenMin 
         Height          =   285
         Left            =   1440
         TabIndex        =   4
         Top             =   840
         Width           =   615
      End
      Begin VB.Label lblLen 
         Caption         =   "Maximum"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   15
         Top             =   390
         Width           =   855
      End
      Begin VB.Label lblLen 
         Caption         =   "Minimum"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   14
         Top             =   840
         Width           =   855
      End
   End
   Begin VB.TextBox txtDwnPay 
      Alignment       =   1  'Right Justify
      Height          =   375
      Left            =   1200
      TabIndex        =   2
      Top             =   720
      Width           =   1215
   End
   Begin VB.Frame frmIntr 
      Caption         =   "Interest Rates"
      Height          =   1335
      Left            =   120
      TabIndex        =   8
      Top             =   2640
      Width           =   2295
      Begin VB.ComboBox comIntrMax 
         Height          =   300
         Left            =   1440
         Style           =   2  'Dropdown List
         TabIndex        =   5
         Top             =   360
         Width           =   735
      End
      Begin VB.ComboBox comIntrMin 
         Height          =   300
         Left            =   1440
         Style           =   2  'Dropdown List
         TabIndex        =   6
         Top             =   840
         Width           =   735
      End
      Begin VB.Label lblIntr 
         Caption         =   "Minimum %"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   10
         Top             =   885
         Width           =   1095
      End
      Begin VB.Label lblIntr 
         Caption         =   "Maximum %"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   9
         Top             =   405
         Width           =   1095
      End
   End
   Begin VB.TextBox txtPurchTotl 
      Alignment       =   1  'Right Justify
      Height          =   375
      Left            =   1200
      TabIndex        =   1
      Top             =   120
      Width           =   1215
   End
   Begin MSGrid.Grid grdPayments 
      Height          =   4815
      Left            =   2655
      TabIndex        =   11
      Top             =   120
      Width           =   4290
      _version        =   65536
      _extentx        =   7567
      _extenty        =   8493
      _stockprops     =   77
      forecolor       =   0
      backcolor       =   16777215
      rows            =   17
      cols            =   4
      scrollbars      =   0
      highlight       =   0   'False
      mouseicon       =   "LOAN.frx":030A
   End
   Begin VB.Image imgGraphic 
      Height          =   750
      Left            =   1845
      Picture         =   "LOAN.frx":0326
      Top             =   165
      Visible         =   0   'False
      Width           =   750
   End
   Begin VB.Label lblDwnPay 
      Caption         =   "Percent Down"
      Height          =   435
      Left            =   120
      TabIndex        =   12
      Top             =   720
      Width           =   900
   End
   Begin VB.Label lblPurchTotl 
      Caption         =   "Purchase Amount"
      Height          =   435
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   900
   End
   Begin VB.Menu mnuOptions 
      Caption         =   "&Options"
      Begin VB.Menu mnuOptCopy 
         Caption         =   "&Copy"
         Enabled         =   0   'False
      End
      Begin VB.Menu mnuOptInstruct 
         Caption         =   "&Instructions..."
      End
      Begin VB.Menu mnuOptSep 
         Caption         =   "-"
      End
      Begin VB.Menu mnuOptExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuDwnPay 
      Caption         =   "&Down Payment"
      Begin VB.Menu mnuOptDwn 
         Caption         =   "&Percent Down"
         Checked         =   -1  'True
         Index           =   0
      End
      Begin VB.Menu mnuOptDwn 
         Caption         =   "&Amount Down"
         Index           =   1
      End
   End
   Begin VB.Menu mnuLoanLen 
      Caption         =   "&Loan Length"
      Begin VB.Menu mnuOptLen 
         Caption         =   "&Years"
         Checked         =   -1  'True
         Index           =   0
      End
      Begin VB.Menu mnuOptLen 
         Caption         =   "&Months"
         Index           =   1
      End
   End
End
Attribute VB_Name = "LoanSheet"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit
' Form variables for purchase/down payment.
Dim PurchAmt
Dim DPAmt
' Form variable for loan amount.
Dim LoanAmt
' Form variables for the minimum and maximum loan lengths.
Dim LenMin
Dim LenMax
' Form variables for the minimum and maximum interest rates.
Dim IntrMin
Dim IntrMax
' Dynamic array for payments.
Dim Payments()
' Form variables to track the number of rows and columns.
Dim Periods
Dim Rates
' Form variables for the current interest rate and period values.
Dim Interest
Dim Months
' Array for amortization information.
Dim AmortData()
' Form variable to hold the payment for the amortization calculation.
Dim AmortPmnt
' Form variable flag to tell if the grid shows the amortization.
Dim AmortFlag

Private Sub CalcAmort()
    ' Declare local variables.
    Dim Count
    ' Save the monthly payment from the selected cell.
    AmortPmnt = Payments(grdPayments.Row, grdPayments.Col)
    ' Save the interest rate from the selected row.
    Interest = Payments(grdPayments.Row, 0) / 1200
    ' If period = years...
    If mnuOptLen(0).Checked = True Then
        ' Make the loan length match the selected cell.
        Months = Payments(0, grdPayments.Col) * 12
    Else
        Months = Payments(0, grdPayments.Col)
    End If
    ' Size the array holding the amortization data.
    ReDim AmortData(Months, 3)
    ' Save the original loan amount to calculate the remaining principal.
    AmortData(0, 1) = LoanAmt
    ' For each month in the loan period...
    For Count = 1 To Months
        ' Calculate the interest paid for the current month.
        AmortData(Count, 2) = Int((AmortData(Count - 1, 1) * Interest + 0.005) * 100) / 100
        ' Calculate the remaining balance.
        AmortData(Count, 1) = AmortData(Count - 1, 1) - AmortPmnt + AmortData(Count, 2)
    Next Count
End Sub

Private Sub CalcPmnts()
    ' Declare local variables.
    Dim RowData
    Dim ColData
    ' Calculate the number of periods and interest rates to display.
    Periods = (LenMax - LenMin) + 1
    Rates = ((IntrMax - IntrMin) * 2) + 1
    ' Size the array for payments.
    ReDim Payments(Rates + 1, Periods + 1)
    ' Store the row headings (rates) in the array.
    For RowData = 1 To Rates
        Payments(RowData, 0) = IntrMin + ((RowData - 1) / 2)
    Next RowData
    ' Store the column headings (loan lengths) in the array.
    For ColData = 1 To Periods
        Payments(0, ColData) = LenMin + (ColData - 1)
    Next ColData
    ' If periods = years...
    If mnuOptLen(0).Checked = True Then
        ' For each interest rate/loan length, calculate the payments.
        For RowData = 1 To Rates
            Interest = Val(Payments(RowData, 0)) / 1200
            For ColData = 1 To Periods
                Months = Payments(0, ColData) * 12
                Payments(RowData, ColData) = MonthPay(Interest, Months)
            Next ColData
        Next RowData
    ' If periods = months...
    Else
        ' For each interest rate/loan length, calculate the payments.
        For RowData = 1 To Rates
            Interest = Val(Payments(RowData, 0)) / 1200
            For ColData = 1 To Periods
                Months = Payments(0, ColData)
                Payments(RowData, ColData) = MonthPay(Interest, Months)
            Next ColData
        Next RowData
    End If
End Sub

Private Sub ClearGrid()
    ' Declare local variables.
    Dim Count As Integer
    ' Clear text from the first column.
    grdPayments.Col = 0
    For Count = 1 To grdPayments.Rows - 1
        grdPayments.Row = Count
        grdPayments.Text = " "
    Next Count
    ' Clear text from the first row.
    grdPayments.Row = 0
    For Count = 1 To grdPayments.Cols - 1
        grdPayments.Col = Count
        grdPayments.Text = " "
    Next Count
    ' Clear text from the nonfixed cells.
    grdPayments.SelStartCol = 1
    grdPayments.SelStartRow = 1
    grdPayments.SelEndCol = grdPayments.Cols - 1
    grdPayments.SelEndRow = grdPayments.Rows - 1
    grdPayments.FillStyle = 1
    grdPayments.Text = ""
    grdPayments.FillStyle = 0
    grdPayments.SelEndCol = 1
    grdPayments.SelEndRow = 1
End Sub

Private Sub ClipCopy()
    ' Declare local variables.
    Dim ClipText
    Dim CopyText
    Dim NC
    Dim NR
    Dim Count
    Dim ColStrt
    Dim ColEnd
    Dim RowStrt
    Dim RowEnd
    Dim HeadTxt
    ' Initialize the new column (NC) & row (NR) variables.
    NC = Chr(9)
    NR = Chr(13) & Chr(10)
    ' Initialize variables for the selected rows and columns.
    ColStrt = grdPayments.SelStartCol
    ColEnd = grdPayments.SelEndCol
    RowStrt = grdPayments.SelStartRow
    RowEnd = grdPayments.SelEndRow
    ' Initialize the variable that gets input from the grid.
    ClipText = grdPayments.Clip
    ' Initialize the variable that holds output that is copied onto the Clipboard.
    CopyText = ""
    ' Header row = current row.
    grdPayments.Row = 0
    ' For each cell in the header row...
    For Count = ColStrt To ColEnd
        ' Set the current column.
        grdPayments.Col = Count
        ' Does the grid display payment or amortization information?
        Select Case AmortFlag
        ' If payments are displayed...
        Case False
            ' Is the loan length in years or months?
            Select Case mnuOptLen(0).Checked
            ' If loan length = years...
            Case True
                HeadTxt = Payments(0, Count) & " Years"
            ' If loan length = months...
            Case False
                HeadTxt = Payments(0, Count) & " Months"
            End Select
        ' If amortization information is displayed...
        Case True
            ' Define the heading text.
            HeadTxt = Mid(grdPayments.Text, 2, Len(grdPayments.Text) - 1)
        End Select
        ' Copy the column header to the output variable.
        CopyText = CopyText & NC & HeadTxt
    Next Count
    CopyText = CopyText & NR
    ' Add the first row header to the output variable.
    grdPayments.Col = 0
    grdPayments.Row = RowStrt
    CopyText = CopyText & grdPayments.Text & NC
    ' Copy text from the input variable to the output variable.
    For Count = 1 To Len(ClipText)
        ' If the current character isn't a carriage return...
        If Mid(ClipText, Count, 1) <> Chr(13) Then
            ' Concatenate the character to the output variable.
            CopyText = CopyText & Mid(ClipText, Count, 1)
        ' If the current character is a carriage return...
        Else
            ' Concatenate a carriage return/linefeed to the output variable.
            grdPayments.Row = grdPayments.Row + 1
            CopyText = CopyText & NR & grdPayments.Text & NC
        End If
    Next Count
    ' Copy the contents of the output variable onto the Clipboard.
    Clipboard.SetText CopyText
End Sub

Private Sub cmdCalcAmort_Click()
    ' Change the mouse pointer to an hourglass.
    MousePointer = 11
    ' Calculate the amortization.
    CalcAmort
    ' Display the amortization.
    ShowAmort
    ' Return the mouse pointer to the default.
    MousePointer = 0
End Sub

Private Sub cmdCalcPmts_Click()
    ' Disable the Show Amortization button.
    cmdCalcAmort.Enabled = False
    ' Does the Purchase Amount have a value?
    If PurchAmt <= 0 Then
        MsgBox "You must enter a valid purchase amount.", 48, "LoanSheet Error"
        txtPurchTotl.Text = ""
        txtPurchTotl.SetFocus
        Exit Sub
    End If
    ' Does Maximum Length of Loan have a value?
    If txtLenMax.Text = "" Then
        MsgBox "You must enter a maximum length of loan.", 48, "LoanSheet Error"
        txtLenMax.SetFocus
        Exit Sub
    End If
    ' If the maximum loan length is less than the minimum loan length...
    If txtLenMax.Text <> "" And LenMax < LenMin Then
        MsgBox "Maximum length of loan must be greater than the minimum length of loan.", 48, "LoanSheet Error"
        txtLenMax.Text = ""
        txtLenMax.SetFocus
        Exit Sub
    End If
    ' If the minimum loan length has no value, set it equal to 1.
    If txtLenMin.Text = "" Then
        MsgBox "The minimum length of loan must be one month or year.", 48, "LoanSheet Error"
        txtLenMin.Text = "1"
        LenMin = 1
    End If
    ' If the maximum interest rate is less than the minimum interest rate...
    If IntrMax < IntrMin Then
        MsgBox "Maximum interest rate must be greater than the minimum interest rate.", 48, "LoanSheet Error"
        comIntrMax.SetFocus
        Exit Sub
    End If
    ' Is the maximum interest rate entered?
    If IntrMax < 0.5 Then
        MsgBox "You must specify a maximum interest rate greater than zero.", 48, "LoanSheet Error"
        comIntrMax.SetFocus
        Exit Sub
    End If
    ' If no minimum rate is entered, the minimum rate = the maximum rate.
    If IntrMin < 0.5 Then
        comIntrMin.ListIndex = comIntrMax.ListIndex
        IntrMin = IntrMax
    End If
    ' Calculate the loan amount.
    If mnuOptDwn(0).Checked = True Then
        LoanAmt = PurchAmt * (1 - (DPAmt / 100))
    ElseIf mnuOptDwn(1).Checked = True Then
        LoanAmt = PurchAmt - DPAmt
    End If
    ' Change the mouse pointer to an hourglass.
    MousePointer = 11
    ' Calculate the payments for all the loan lengths and interest rates.
    CalcPmnts
    ' Display payments in the grid.
    ShowPmnts
    ' Change the mouse pointer to the default.
    MousePointer = 0
End Sub

Private Sub comIntrMax_Click()
    IntrMax = Val(comIntrMax.Text)
    ' If the maximum interest rate is less than the minimum interest rate...
    If IntrMax < IntrMin Then
        MsgBox "Maximum interest rate must be greater than or equal to the minimum interest rate.", 48, "LoanSheet Error"
        comIntrMax.ListIndex = comIntrMin.ListIndex
        comIntrMax.SetFocus
    End If
End Sub

Private Sub comIntrMin_Click()
    IntrMin = Val(comIntrMin.Text)
    ' If the maximum interest rate is less than minimum interest rate...
    If IntrMax < IntrMin Then
        MsgBox "Minimum interest rate must be less than or equal to the maximum interest rate.", 48, "LoanSheet Error"
        comIntrMin.ListIndex = comIntrMin.ListIndex
        comIntrMin.SetFocus
    End If
End Sub

Private Sub Form_Load()
    ' Declare local variables.
    Dim iRate
    Dim Count
    ' Set the down payment to 0.
    DPAmt = 0
    ' Put the application in the center of the screen.
    LoanSheet.Left = (Screen.Width - LoanSheet.Width) / 2
    LoanSheet.Top = (Screen.Height - LoanSheet.Height) / 2
    ' Put allowed interest rates in list boxes.
    For iRate = 0 To 25 Step 0.5
        comIntrMin.AddItem Format(iRate, "0.0")
        comIntrMax.AddItem Format(iRate, "0.0")
    Next iRate
    ' Set the maximum and minimum interest rates to 0 and 0.
    comIntrMin.ListIndex = 0
    comIntrMax.ListIndex = 0
    ' Place a graphic in the cell 0,0.
    grdPayments.Row = 0
    grdPayments.Col = 0
    grdPayments.ColWidth(0) = imgGraphic.Width
    grdPayments.RowHeight(0) = imgGraphic.Height
    grdPayments.Picture = imgGraphic.Picture
    ' Set the default number of rates and periods.
    Rates = 16
    Periods = 3
    ' Set the width of the nonfixed columns.
    SizeCells grdPayments
End Sub

Private Sub Form_Unload(Cancel As Integer)
    End
End Sub

Private Sub grdPayments_Click()
    ' Only act if a cell contains a payment.
    If grdPayments.Text <> "" And AmortFlag = False Then
        ' Enable the Show Amortization button.
        cmdCalcAmort.Enabled = True
    Else
        ' Disable the Show Amortization button.
        cmdCalcAmort.Enabled = False
    End If
End Sub

Private Sub grdPayments_DblClick()
    ' Only act if a cell contains a payment.
    If grdPayments.Text <> "" And AmortFlag = False Then
        ' Enable the Show Amortization button.
        cmdCalcAmort.Enabled = True
        ' Change the mouse pointer to an hourglass.
        MousePointer = 11
        ' Calculate the amortization.
        CalcAmort
        ' Display the amortization.
        ShowAmort
        ' Change the mouse pointer to the default pointer.
        MousePointer = 0
    Else
        ' Disable the Show Amortization button.
        cmdCalcAmort.Enabled = False
    End If
End Sub

Private Sub mnuOptCopy_Click()
    ClipCopy
End Sub

Private Sub mnuOptDwn_Click(Index As Integer)
    Select Case Index
        Case 0
            mnuOptDwn(0).Checked = True
            mnuOptDwn(1).Checked = False
            lblDwnPay.Caption = "Percent Down"
        Case 1
            mnuOptDwn(0).Checked = False
            mnuOptDwn(1).Checked = True
            lblDwnPay.Caption = "Amount Down"
    End Select
End Sub

Private Sub mnuOptExit_Click()
    End
End Sub

Private Sub mnuOptInstruct_Click()
    ' Declare local variables.
    Dim MsgText
    Dim PB
    ' Initialize the paragraph break variable.
    PB = Chr(10) & Chr(13) & Chr(10) & Chr(13)
    ' Display the instructions.
    MsgText = "Enter the purchase amount, down payment, length of loan, and interest rates. Click the Show Payments button to display monthly payments in the grid on the right."
    MsgText = MsgText & PB & "Select a monthly payment and click the Show Amortization button to display an amortization schedule for the selected interest rate and length of loan in the grid."
    MsgText = MsgText & PB & "Select cells in the grid and choose Copy from the Options menu to copy data onto the Clipboard."
    MsgBox MsgText, 64, "LoanSheet Instructions"
End Sub

Private Sub mnuOptLen_Click(Index As Integer)
    Select Case Index
        ' Loan length = years...
        Case 0
            mnuOptLen(0).Checked = True
            mnuOptLen(1).Checked = False
            frmLoanLen.Caption = "Years in Loan"
        ' Loan length = months...
        Case 1
            mnuOptLen(0).Checked = False
            mnuOptLen(1).Checked = True
            frmLoanLen.Caption = "Months in Loan"
    End Select
End Sub

Private Function MonthPay(Interest, Months)
    MonthPay = LoanAmt * (Interest / (1 - (1 / ((1 + Interest) ^ Months))))
End Function

Private Sub ShowAmort()
    ' Declare local variables.
    Dim Count
    Dim Row2Fill
    Dim Col2Fill
    Dim GridHgt
    Dim GridWid
    Dim NL
    Dim IntrTotl
    ' Clear the contents of the grid.
    ClearGrid
    ' Initialize the line break variable.
    NL = Chr(10) & Chr(13)
    ' Set the number of nonfixed columns (4).
    grdPayments.Cols = 5
    ' Replace picture in the 0,0 cell with text.
    grdPayments.Row = 0
    grdPayments.Col = 0
    grdPayments.Picture = LoadPicture()
    grdPayments.Text = NL & "Payment" & NL & Format(AmortPmnt, "Currency")
    grdPayments.ColWidth(0) = 1.1 * TextWidth(grdPayments.Text)
    ' Set the remaining column headings.
    grdPayments.Col = 1
    grdPayments.Text = NL & "Principal Paid"
    grdPayments.Col = 2
    grdPayments.Text = NL & "Interest Paid"
    grdPayments.Col = 3
    grdPayments.Text = NL & "Principal Balance"
    grdPayments.Col = 4
    grdPayments.Text = NL & "Total Interest"
    ' Display the vertical scroll bar.
    grdPayments.ScrollBars = 3
    ' Initialize variables for nonfixed height and width of grid less fixed
    ' rows and columns and grid border (30).
    GridHgt = grdPayments.Height - grdPayments.RowHeight(0) - 30
    GridWid = grdPayments.Width - grdPayments.ColWidth(0) - 30
    ' Set the number of nonfixed rows.
    If Months > 16 Then
        grdPayments.Rows = Months + 1
    Else
        grdPayments.Rows = 16
    End If
    ' First column = current column.
    grdPayments.Col = 0
    ' Set the height of rows to evenly display 16 rows in nonfixed height and
    ' show payment number in the first column.
    For Count = 1 To Months
        grdPayments.RowHeight(Count) = GridHgt / 16
        grdPayments.Row = Count
        grdPayments.Text = Count
    Next Count
    ' Set column widths to evenly display 2 columns in nonfixed width
    ' less the width of the vertical scroll bar.
    For Count = 1 To 4
        grdPayments.ColWidth(Count) = (GridWid - 255) / 2
    Next Count
    ' Set the initial interest value.
    IntrTotl = 0
    ' Place values of the nonfixed rows in the grid.
    For Row2Fill = 1 To Months
        ' For each month in the repayment period...
        grdPayments.Row = Row2Fill
        ' Display part of the payment applied to the principal in the first nonfixed column.
        grdPayments.Col = 1
        grdPayments.Text = Format(AmortPmnt - AmortData(Row2Fill, 2), "Currency")
        ' Display the interest paid for this payment in the second nonfixed column.
        grdPayments.Col = 2
        grdPayments.Text = Format(AmortData(Row2Fill, 2), "Currency")
        ' Display the balance remaining on the principal in the third nonfixed column.
        grdPayments.Col = 3
        grdPayments.Text = Format(AmortData(Row2Fill, 1), "Currency")
        ' Display the total interest paid to date in the last nonfixed column.
        grdPayments.Col = 4
        IntrTotl = IntrTotl + AmortData(Row2Fill, 2)
        grdPayments.Text = Format(IntrTotl, "Currency")
    Next Row2Fill
    ' Disable the Show Amortization button.
    cmdCalcAmort.Enabled = False
    ' Enable the amortization flag.
    AmortFlag = True
End Sub

Private Sub ShowPmnts()
    ' Declare local variables.
    Dim Row2Fill
    Dim Col2Fill
    Dim NL As String
    Dim PeriodTxt As String
    ' Clear the contents of the grid.
    ClearGrid
    ' Reset the picture in cell 0,0.
    grdPayments.Row = 0
    grdPayments.Col = 0
    grdPayments.Picture = imgGraphic.Picture
    grdPayments.ColWidth(0) = imgGraphic.Width
    ' Size the nonfixed cells.
    SizeCells grdPayments
    ' Initialize the line break variable.
    NL = Chr(10) & Chr(13)
    ' Initialize the variable for the loan period (years or months).
    If mnuOptLen(0).Checked = True Then
        PeriodTxt = "Years"
    Else
        PeriodTxt = "Months"
    End If
    ' First row = current row.
    grdPayments.Row = 0
    ' Put column headings in the first row.
    For Col2Fill = 1 To Periods
        grdPayments.Col = Col2Fill
        grdPayments.FixedAlignment(Col2Fill) = 2
        grdPayments.Text = NL & Payments(0, Col2Fill) & NL & PeriodTxt
    Next Col2Fill
    ' Center text in the first column.
    grdPayments.FixedAlignment(0) = 2
    ' Put row headings in the first column.
    grdPayments.Col = 0
    For Row2Fill = 1 To Rates
        grdPayments.Row = Row2Fill
        grdPayments.Text = Format(Payments(Row2Fill, 0), "0.0") & "%"
    Next Row2Fill
    ' Fill the grid with payments from the array.
    For Row2Fill = 1 To Rates
        For Col2Fill = 1 To Periods
            grdPayments.Row = Row2Fill
            grdPayments.Col = Col2Fill
            grdPayments.ColAlignment(Col2Fill) = 2
            grdPayments.Text = Format(Payments(Row2Fill, Col2Fill), "Currency")
        Next Col2Fill
    Next Row2Fill
    ' Allow the user to highlight cells.
    grdPayments.HighLight = True
    ' Enable copying from cells onto the Clipboard.
    mnuOptCopy.Enabled = True
    ' Set the amortization flag to False.
    AmortFlag = False
End Sub

Private Sub SizeCells(ThisGrid As Control)
    ' Declare local variables.
    Dim Count
    Dim GridHgt
    Dim GridWid
    Dim ScrollHgt
    Dim ScrollWid
    ' Initialize variables for nonfixed height/width of grid less
    ' fixed row/column and grid border (30).
    GridHgt = ThisGrid.Height - ThisGrid.RowHeight(0) - 30
    GridWid = ThisGrid.Width - ThisGrid.ColWidth(0) - 30
    ' Initialize variables for the scroll bar height and width.
    ScrollHgt = 255
    ScrollWid = 255
    ' If data fits in the default number of rows (16) and columns (3)...
    If Rates <= 16 And Periods <= 3 Then
        ' Don't display scroll bars.
        ThisGrid.ScrollBars = 0
        ' Set the number of nonfixed rows and columns to the default.
        ThisGrid.Rows = 17
        ThisGrid.Cols = 4
        ' Set the height of the rows to evenly display 16 rows in nonfixed grid height.
        For Count = 1 To 16
            ThisGrid.RowHeight(Count) = GridHgt / 16
        Next Count
        ' Set the width of the columns to evenly display 3 columns in nonfixed grid width.
        For Count = 1 To 3
            ThisGrid.ColWidth(Count) = GridWid / 3
        Next Count
    ' If data needs more columns, but no more rows...
    ElseIf Rates <= 16 And Periods > 3 Then
        ' Display the horizontal scroll bar only.
        ThisGrid.ScrollBars = 1
        ' Set the number of nonfixed rows and columns.
        ThisGrid.Rows = 17
        ThisGrid.Cols = Periods + 1
        ' Set the height of the rows to evenly display 16 rows in nonfixed grid height
        ' minus the height of the scroll bar.
        For Count = 1 To 16
            ThisGrid.RowHeight(Count) = (GridHgt - ScrollHgt) / 16
        Next Count
        ' Set the column widths to evenly display 3 columns in nonfixed grid width.
        For Count = 1 To Periods
            ThisGrid.ColWidth(Count) = GridWid / 3
        Next Count
    ' If data needs more rows, but no more columns...
    ElseIf Rates > 16 And Periods <= 3 Then
        ' Display the vertical scroll bar only.
        ThisGrid.ScrollBars = 2
        ' Set the number of nonfixed rows and columns.
        ThisGrid.Rows = Rates + 1
        ThisGrid.Cols = 4
        ' Set the height of the rows to evenly display 16 rows in nonfixed grid height.
        For Count = 1 To Rates
            ThisGrid.RowHeight(Count) = GridHgt / 16
        Next Count
        ' Set column widths to evenly display 3 columns in nonfixed grid width
        ' minus the width of the scroll bar.
        For Count = 1 To 3
            ThisGrid.ColWidth(Count) = (GridWid - ScrollWid) / 3
        Next Count
    ElseIf Rates > 16 And Periods > 3 Then
        ' Display both scroll bars.
        ThisGrid.ScrollBars = 3
        ' Set the number of nonfixed rows and columns.
        ThisGrid.Rows = Rates + 1
        ThisGrid.Cols = Periods + 1
        ' Set the height of rows to evenly display 16 rows in nonfixed grid height
        ' minus the scroll bar height.
        For Count = 1 To Rates
            ThisGrid.RowHeight(Count) = (GridHgt - ScrollHgt) / 16
        Next Count
        ' Set the width of columns to evenly display 3 columns in nonfixed grid width
        ' minus the width of the scroll bar.
        For Count = 1 To Periods
            ThisGrid.ColWidth(Count) = (GridWid - ScrollWid) / 3
        Next Count
    End If
End Sub

Private Sub txtDwnPay_Change()
    ' Store the number in a form variable.
    DPAmt = Val(txtDwnPay.Text)
    ' Validate that DPAmt doesn't exceed 100% or the Purchase Amount.
    If mnuOptDwn(0).Checked = True And DPAmt > 99 Then
        MsgBox "Down payment percentage cannot exceed 99 percent.", 48, "LoanSheet Error"
        txtDwnPay.Text = ""
        txtDwnPay.SetFocus
    ElseIf mnuOptDwn(1).Checked = True And DPAmt > PurchAmt Then
        MsgBox "Down payment amount cannot exceed purchase amount.", 48, "LoanSheet Error"
        txtDwnPay.Text = ""
        txtDwnPay.SetFocus
    ElseIf DPAmt < 0 Then
        MsgBox "Down payment amount must be zero or greater.", 48, "LoanSheet Error"
        txtDwnPay.Text = ""
        txtDwnPay.SetFocus
    End If
End Sub

Private Sub txtLenMax_Change()
    LenMax = Val(txtLenMax.Text)
End Sub

Private Sub txtLenMin_Change()
    LenMin = Val(txtLenMin.Text)
End Sub

Private Sub txtPurchTotl_Change()
    PurchAmt = Val(txtPurchTotl.Text)
End Sub

