VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Connector"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
Attribute VB_Description = "Align Sample Add-In"
'This class is used to connect this addin to the Visual Basic
'design environment.  It must the Public property set to True, and the
'Instancing property set to '2 - Createable MultiUse' (recommended for addins)
'or '1 - Createble SingleUse'
Option Explicit
'Storage for the menu and menuline objects created when the add-in adds its own menu
'and menulines to Visual Basic
Const AlignLeft = 0
Const AlignRight = 1
Const AlignTop = 2
Const AlignBottom = 3
Const AlignAbout = 4
Const SizeWidth = 5
Const SizeHeight = 6
Const SizeBoth = 7

Dim AlignMenu As VBIDE.SubMenu
Dim SizeMenu As VBIDE.SubMenu
Dim MenuLines(AlignLeft To SizeBoth) As VBIDE.MenuLine
Dim AlignHandler(AlignLeft To AlignBottom) As AlignAll
Dim SizeHandler(SizeWidth To SizeBoth) As SizeAll
Dim ConnectID(AlignLeft To SizeBoth) As Long
Dim VBInstance As VBIDE.Application

Sub ConnectAddIn(VBDriverInstance As VBIDE.Application)
Dim i%
    'This method is called when this add-in is installed in an instance
    'of Visual Basic.  Choose "Align Sample Add-In" from the Add-In manager
    'on another instance of VB. VBInstance will be the object representation
    'of the instance of Visual Basic which installed the add-in.  To change
    'the name of the addin in the addin manager, select the Align project in the
    'object browser, click on the Connector class, and choose Options.

    'Save the instance of Visual Basic so we can refer to it later.
    Set VBInstance = VBDriverInstance
    
    With VBInstance.AddInMenu.MenuItems
        'Add our Align menu and menu lines to the Visual Basic Add-In menu.
        Set AlignMenu = .AddMenu("A&lign")
        With AlignMenu.MenuItems
            Set MenuLines(AlignLeft) = .Add("&Left Align")
            Set MenuLines(AlignRight) = .Add("&Right Align")
            Set MenuLines(AlignTop) = .Add("&Top Align")
            Set MenuLines(AlignBottom) = .Add("&Bottom Align")
            Set MenuLines(AlignAbout) = .Add("About...")
        End With
        'Add our Align menu and menu lines to the Visual Basic Add-In menu.
        Set SizeMenu = .AddMenu("Si&ze")
        With SizeMenu.MenuItems
            Set MenuLines(SizeWidth) = .Add("&Width")
            Set MenuLines(SizeHeight) = .Add("&Height")
            Set MenuLines(SizeBoth) = .Add("&Both")
        End With
    End With
    
    'Connect the corresponding event handler object to the correct menu line.
    For i% = AlignLeft To AlignBottom
        'Create a new handler for each direction.
        Set AlignHandler(i%) = New AlignAll
        'Save the ID for each connected event.
        ConnectID(i%) = MenuLines(i%).ConnectEvents(AlignHandler(i%))
        'Pass the VBInstance to the child objects.
        Set AlignHandler(i%).VBInstance = VBInstance
    Next i%
    
    'Set the AfterClick handler for the about box.
    ConnectID(AlignAbout) = MenuLines(AlignAbout).ConnectEvents(Me)
    
    'Connect the SizeHandler events.  Same as hooking up Align events.
    For i% = SizeWidth To SizeBoth
        Set SizeHandler(i%) = New SizeAll
        ConnectID(i%) = MenuLines(i%).ConnectEvents(SizeHandler(i%))
        Set SizeHandler(i%).VBInstance = VBInstance
    Next i%
    
    'Initialize the directional Align instances.
    AlignHandler(AlignLeft).MainProp = "Left"
    AlignHandler(AlignRight).MainProp = "Left"
    AlignHandler(AlignRight).ShiftProp = "Width"
    AlignHandler(AlignTop).MainProp = "Top"
    AlignHandler(AlignBottom).MainProp = "Top"
    AlignHandler(AlignBottom).ShiftProp = "Height"
    
    'Initialize SizeFlags on Size instances.
    SizeHandler(SizeWidth).SizeFlags = 1
    SizeHandler(SizeHeight).SizeFlags = 2
    SizeHandler(SizeBoth).SizeFlags = 3
End Sub

Sub DisconnectAddIn(Mode As Integer)
Dim i%
Dim mnuItems As VBIDE.MenuItems
    'Remove AlignMenu items.
    Set mnuItems = AlignMenu.MenuItems
    For i% = AlignLeft To AlignAbout
        'Disconnect the event handlers from the menu lines
        MenuLines(i%).DisconnectEvents ConnectID(i%)
        'Remove the menu and menu lines we installed in Visual Basic
        mnuItems.Remove MenuLines(i%)
    Next i%
        
    'Remove SizeMenu items.
    Set mnuItems = SizeMenu.MenuItems
    For i% = SizeWidth To SizeBoth
        MenuLines(i%).DisconnectEvents ConnectID(i%)
        mnuItems.Remove MenuLines(i%)
    Next i%
    
    'Remove items from Addins menu.
    With VBInstance.AddInMenu.MenuItems
        .Remove AlignMenu
        .Remove SizeMenu
    End With
End Sub

'Use this class to provide an AfterClick handler for About...
Public Sub AfterClick()
    About.Show vbModal
End Sub

