//---------------------------------------------------------------------------
// VBOCXINT.H
//---------------------------------------------------------------------------
// Copyright (c) 1991-1995, Microsoft Corp.  All Rights Reserved.
//---------------------------------------------------------------------------
// Include file for the OLE Custom Controls Visual Basic
// programming interface.
//---------------------------------------------------------------------------

#if !defined (_VBOCXINT_H_)
#define _VBOCXINT_H_
        
//---------------------------------------------------------------------------
// Data xfer structure for VBM_LINKGETDATA or VBM_LINKSETDATA
//---------------------------------------------------------------------------
typedef struct tagVBLINKDATA
  {
  WORD     wReserved;
  DWORD	   cb;		  // Size of data
  HANDLE   hData;	  // Handle to data
  DWORD    dwReserved;
  } VBLINKDATA;

typedef VBLINKDATA FAR *LPLINKDATA;


#define LPDDEDATA LPLINKDATA
#define LINKSRCTELL                      1
#define LINKSRCASK                       0
#define MAXLINKITEMNAME                 256

//---------------------------------------------------------------------------
// IVBDDESite
//---------------------------------------------------------------------------
DECLARE_INTERFACE_(IVBDDESite, IUnknown)
{
    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    //(CLIENT) pass in a string and we will add the index
    STDMETHOD_(VOID, VBLinkMakeItemName)(THIS_ LPSZ lpszBuff) PURE;
    //(SERVER) notifies the server that the data exposed by this control
    // has changed.
    STDMETHOD_(ERR,  VBLinkPostAdvise)(THIS_ VOID) PURE;
    //(CLIENT) design time only. default implementation of LinkPasteLinkOk
    STDMETHOD_(BOOL, VBPasteLinkOk)(THIS_ HANDLE FAR * phTriplet) PURE;
    //(CLIENT) default implementation of GetItemName
    STDMETHOD_(ERR,  LinkGetItemNameDefault)(THIS_ int ls, LPSZ lpszlinkitem) PURE;
};

//---------------------------------------------------------------------------
// IVBDDE
//---------------------------------------------------------------------------
DECLARE_INTERFACE_(IVBDDE, IUnknown)
{
    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    //(BOTH)
    STDMETHOD_(LRESULT, LinkEnumFormats)(THIS_ UINT df, UINT i) PURE;
    //both?
    STDMETHOD_(LRESULT, LinkGetData)    (THIS_ int cf, LPDDEDATA lpddedata) PURE;
    STDMETHOD_(LRESULT, LinkSetData)    (THIS_ int cf, LPDDEDATA lpddedata) PURE;
    STDMETHOD_(LRESULT, LinkGetItemName)(THIS_ int ls, LPSZ lpszlinkitem) PURE;
    //(CLIENT)
    STDMETHOD_(BOOL, QPasteLinkOK)      (THIS) PURE;
};


//---------------------------------------------------------------------------
// IVBGetControl
//---------------------------------------------------------------------------

// Constants for dwWhich parameter:
#define GC_WCH_SIBLING	    0x00000001L
#define GC_WCH_CONTAINER    0x00000002L   // no FONLYNEXT/PREV
#define GC_WCH_CONTAINED    0x00000003L   // no FONLYNEXT/PREV
#define GC_WCH_ALL	    0x00000004L
#define GC_WCH_FREVERSEDIR  0x08000000L   // OR'd with others
#define GC_WCH_FONLYNEXT    0x10000000L   // OR'd with others
#define GC_WCH_FONLYPREV    0x20000000L   // OR'd with others
#define GC_WCH_FSELECTED    0x40000000L   // OR'd with others

DECLARE_INTERFACE_(IVBGetControl, IUnknown)
    {
    // *** IUnknown methods ****
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    // *** IVBGetControl methods ****
    STDMETHOD(EnumControls)(THIS_ DWORD dwOleContF, DWORD dwWhich, 
                            LPENUMUNKNOWN FAR *ppenumUnk) PURE;
    };

//---------------------------------------------------------------------------
// IGetOleObject
//---------------------------------------------------------------------------
DECLARE_INTERFACE_(IGetOleObject, IUnknown)
    {
    // *** IUnknown methods ****
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    // *** IGetOleObject methods ****
    STDMETHOD(GetOleObject)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    };

//---------------------------------------------------------------------------
// IGetVBAObject
//---------------------------------------------------------------------------
#undef INTERFACE
#define INTERFACE IGetVBAObject
DECLARE_INTERFACE_(IGetVBAObject,IUnknown)
  {
  /* IUnknown methods */
  STDMETHOD(QueryInterface)(THIS_ REFIID riid, void FAR* FAR* ppvObj) PURE;
  STDMETHOD_(unsigned long, AddRef)(THIS) PURE;
  STDMETHOD_(unsigned long, Release)(THIS) PURE;

  STDMETHOD(GetObject)(THIS_ REFIID riid, void FAR* FAR* ppvObj, DWORD dwReserved) PURE;
  };

#undef INTERFACE
#define INTERFACE IVBFormat
DECLARE_INTERFACE_( IVBFormat, IUnknown )
{
    BEGIN_INTERFACE

    STDMETHOD(QueryInterface) (THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef) (THIS) PURE; 
    STDMETHOD_(ULONG, Release) (THIS) PURE;

    STDMETHOD_( HRESULT, Format ) (THIS_ LPVARIANT lpVarData, 
			                             LPOLESTR  szFormat,
                                   LPVOID    lpBuffer, 
                                   USHORT    cbBuffer, 
                                   LCID      lcid,
                                   USHORT    sFirstDayOfWeek,
                                   USHORT    sFirstWeekOfYear,
                                   USHORT   *pcbResult) PURE;
};


#undef INTERFACE
#define INTERFACE IVBFiles

DECLARE_INTERFACE_( IVBFiles, IUnknown )
{
    BEGIN_INTERFACE

    STDMETHOD(QueryInterface) (THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef) (THIS) PURE;
    STDMETHOD_(ULONG, Release) (THIS) PURE;

    STDMETHOD_( HRESULT, Read ) (THIS_ USHORT  usFileNo, 
                                 LPVOID  lpBuffer, 
                                 UINT    cb) PURE;

    STDMETHOD_( HRESULT, Write ) (THIS_ USHORT  usFileNo, 
                                  LPVOID  lpBuffer, 
                                  UINT    cb) PURE;

    STDMETHOD_( HRESULT, Seek ) (THIS_ USHORT usFileNo, 
                                 LONG   lOffset, 
                                 LONG  *plPos) PURE;

    STDMETHOD_( HRESULT, SeekRel ) (THIS_ USHORT usFileNo, 
                                    LONG   lOffset, 
                                    LONG  *plPos) PURE;
};

#endif //_VBOCXINT_H_
