/***************************************************************************
 *                                                                         *
 *   SIGNUP.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS signup module.                                  *
 *                                                                         *
 *                                            - T. Stryker 6/24/86         *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "btvstf.h"
#include "signup.h"
#include "dosface.h"
#include "portable.h"
 
FILE *supmb;                  /* signup named-message file pointer         */
extern
BTVFILE *accbb;               /* user accounts btrieve data file           */
 
/*--- OPTIONS FROM SIGNUP.MSG ---*/
 
int sgnaud;                   /* make audit trail entry for new signups?   */
int sgnbel;                   /* period and duration of new-signup beep    */
long fresup;                  /* free credits given upon signup            */
 
#define ASTSIZ 11             /* number of entries in asktbl[]             */
 
static int newstt,asktbl[ASTSIZ][3]={
   0,0,0,
   0,GSCNWID,3,
   0,GUSRNAM,NADSIZ-1,
   0,GUSRAD1,NADSIZ-1,
   0,GUSRAD2,NADSIZ-1,
   0,GUSRAD3,NADSIZ-1,
   0,GUSRPHO,PHOSIZ-1,
   0,GSYSTYP,1,
   0,GAGE,2,
   0,GSEX,6,
   1,PREUID,9
};
 
inisup()                           /* initialize signup stuff              */
{
     long lngopt();
 
     supmb=opnmsg("signup.mcv");
     sgnaud=ynopt(SGNAUD);
     sgnbel=numopt(SGNBEL,0,2000);
     fresup=lngopt(FRESUP,0L,1000000000L);
     asktbl[1][0]=ynopt(ASKSCW);
     asktbl[2][0]=ynopt(ASKNAM);
     asktbl[3][0]=ynopt(ASKCOM);
     asktbl[4][0]=ynopt(ASKADR);
     asktbl[5][0]=ynopt(ASKADR);
     asktbl[6][0]=ynopt(ASKPHO);
     asktbl[7][0]=ynopt(ASKSYS);
     asktbl[8][0]=ynopt(ASKAGE);
     asktbl[9][0]=ynopt(ASKSEX);
}
 
nxtask(tstart)                     /* find next question to ask user       */
int tstart;
{
     int i,foot=0;
 
     for (i=0 ; i < ASTSIZ ; i++) {
          if (!foot) {
               foot=asktbl[i][1] == newstt;       /* Phase 1: where are we? */
          }
          else if (asktbl[i][0]) {            /* Phase 2: where to go next? */
               newstt=asktbl[i][1];
               prfmsg(newstt == PREUID && digalw ? PREDID : newstt);
               usrptr->usetmr=tstart;
               btumil(usrnum,asktbl[i][2]);
               return;
          }
     }
}
 
signup()                           /* signup main input handler            */
{
     int intguy;
 
     setmbk(supmb);
     bgncnc();
     switch (newstt=usrptr->substt) {
     case 0:
          prfmsg(INTRO);
          nxtask(0);
          btutsw(usrnum,usaptr->scnwid=80);
          usaptr->scnlen=24;
          rstrxf();
          break;
     case GSCNWID:
          if (unumok(GSCNWID,20,136,&intguy)) {
               btutsw(usrnum,usaptr->scnwid=intguy);
               prfmsg(SWDEPI);
               nxtask(0);
          }
          break;
     case GUSRNAM:
          if (uinfok(GUSRNAM,5,NADSIZ,usaptr->usrnam)) {
               nxtask(0);
          }
          break;
     case GUSRAD1:
          if (uinfok(GUSRAD1,0,NADSIZ,usaptr->usrad1)) {
               nxtask(0);
          }
          break;
     case GUSRAD2:
          if (uinfok(GUSRAD2,5,NADSIZ,usaptr->usrad2)) {
               nxtask(0);
          }
          break;
     case GUSRAD3:
          if (uinfok(GUSRAD3,5,NADSIZ,usaptr->usrad3)) {
               nxtask(0);
          }
          break;
     case GUSRPHO:
          if (uinfok(GUSRPHO,7,PHOSIZ,usaptr->usrpho)) {
               nxtask(0);
          }
          break;
     case GSYSTYP:
          if (unumok(GSYSTYP,0,7,&intguy)) {
               usaptr->systyp=intguy;
               nxtask(0);
          }
          break;
     case GAGE:
          if (unumok(GAGE,5,99,&usaptr->age)) {
               nxtask(0);
          }
          break;
     case GSEX:
          if (usexok()) {
               nxtask(-8);
          }
          break;
     case PREUID:
     case GUSERID:
          if (hdlok()) {
               prfmsg(newstt=UIDOK,usaptr->userid);
               usrptr->usetmr=0;
          }
          break;
     case UIDOK:
          if (cncchr() == 'Y') {
               prfmsg(PSWIRO,usaptr->userid);
               prfmsg(newstt=GPSWORD);
          }
          else {
               prfmsg(newstt=GUSERID);
          }
          usrptr->usetmr=0;
          break;
     case GPSWORD:
          if (uinfok(GPSWORD,1,PSWSIZ,usaptr->psword)) {
               prfmsg(newstt=PSWEPI,usaptr->userid,usaptr->psword);
               usrptr->usetmr=0;
          }
          break;
     case PSWEPI:
          btumil(usrnum,DFTIMX);
          strcpy(usaptr->credat,ncdate(today()));
          strcpy(usaptr->usedat,usaptr->credat);
          setbtv(accbb);
          insbtv(usaptr);
          if (sgnaud) {
               shocst(1,"NEW SIGNUP: %s",usaptr->userid);
          }
          belper(sgnbel);
          printf("\7");
          belper(emubel);
          usrptr->usetmr=0;
          usrptr->class=FRELOA;
          accacct(usaptr,1);
          if (fresup > 0L) {
               addcrd(usaptr->userid,ltoa(fresup),0);
          }
          redisp();
          if (imbump(0)) {
               usrptr->class=SUPIPG;
               return(1);
          }
          usaptr->usedat[0]='\0';
          prfmsg(WELCOME,bbsttl);
          return(0);
     }
     btuclo(usrnum);
     outprf(usrnum);
     usrptr->substt=newstt;
     return(1);
}
 
hdlok()                            /* is inputted handle ok?               */
{
     char *inpptr;
     static int plnmsg[4]={PL1UID,PL1UID,PL2UID,PL3UID};
 
     for (inpptr=input ; isuidc(*inpptr) ; inpptr++) {
     }
     if (*inpptr != '\0') {
          prfmsg(digalw ? NAADID : NAAUID);
     }
     else if (pfnlvl != 0
       || sameas(input,"new") || sameas(input,"the") || sameas(input,"off")) {
          prfmsg(plnmsg[pfnlvl]);
     }
     else if (inplen < 3) {
          prfmsg(SMLUID);
     }
     else if (inplen >= UIDSIZ) {
          prfmsg(BIGUID,UIDSIZ-1);
     }
     else {
          makhdl();
          setbtv(accbb);
          if (qeqbtv(input,0) || uinsys(input)) {
               prfmsg(UIDINU,input);
          }
          else {
               movmem(input,usaptr->userid,UIDSIZ);
               return(1);
          }
     }
     prfmsg(GUSERID);
     return(0);
}
 
uinfok(pmtmsn,minlen,maxsiz,stgptr)     /* enter a user-information string */
int pmtmsn,minlen,maxsiz;
char *stgptr;
{
     stripb();
     if (inplen >= minlen) {
          if (inplen >= maxsiz) {
               prfmsg(TOOBIG,maxsiz-1);
          }
          else if (pfnlvl > 1) {
               prfmsg(UINPFN);
          }
          else {
               strcpy(stgptr,cncall());
               return(1);
          }
     }
     prfmsg(pmtmsn);
     return(0);
}
 
unumok(pmtmsn,minnum,maxnum,number)     /* enter a user-information number */
int pmtmsn,minnum,maxnum,*number;
{
     int val;
 
     if ((val=atoi(cncall())) >= minnum && val <= maxnum) {
          *number=val;
          return(1);
     }
     prfmsg(NUMOOR,minnum,maxnum);
     prfmsg(pmtmsn);
     return(0);
}
 
usexok()                           /* check for "ok" sex                   */
{
     if (margc == 0) {
          prfmsg(GSEX);
     }
     else {
          switch (cncchr()) {
          case 'M':
               usaptr->sex=77;
               return(1);
          case 'F':
               usaptr->sex=70;
               return(1);
          default:
               prfmsg(MRFPLS);
               prfmsg(GSEX);
          }
     }
     return(0);
}
 
stripb()                           /* "strip" blank spaces after input     */
{
     char *inpptr;
 
     for (inpptr=input+inplen-1 ; inpptr >= input && isspace(*inpptr) ; ) {
          *inpptr--='\0';
     }
     inplen=strlen(input);
}
 
makhdl()                           /* "make handle" for use w/ Btrieve     */
{
     stripb();
     zonkhl(input);
}
 
zonkhl(stg)                        /* "zonk" string for use w/ Btrieve     */
char *stg;
{
     char *inpptr;
 
     stg[0]=toupper(stg[0]);
     for (inpptr=stg+1 ; *inpptr != '\0' ; inpptr++) {
          *inpptr=tolower(*inpptr);
     }
     while (++inpptr-stg < UIDSIZ) {
          *inpptr='\0';
     }
}
 
loadup()                           /* load-up a user's account             */
{
     char temp;
 
     makhdl();
     setbtv(accbb);
     temp=usaptr->ansifl;
     if (acqbtv(usaptr,input,0)) {
          btutsw(usrnum,usaptr->scnwid);
          if (usaptr->scnlen == 0) {
               usaptr->scnlen=24;
          }
          if (!(usaptr->ansifl&ANSMAN)) {
               accacct(usaptr,-1);
               usaptr->ansifl=temp;
               accacct(usaptr,1);
          }
          stansi();
          rstrxf();
          return(1);
     }
     return(0);
}
 
finsup()                           /* close signup files for shutdown      */
{
     clsmsg(supmb);
}
