/***************************************************************************
 *                                                                         *
 *   RTKICK.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the real-time kicktable handler, used to kick off a selected  *
 *   subroutine a specified number of seconds from the present time.       *
 *                                                                         *
 *                                            - T. Stryker 6/24/86         *
 *                                                                         *
 ***************************************************************************/
 
#define KTSIZE 30                  /* kicktable size                       */
 
struct kook {                      /* kicktable entry layout               */
     int countr;                   /*   number of seconds yet to go        */
     int (*dest)();                /*   subroutine address to invoke       */
} kcktbl[KTSIZE];
 
inirtk()                           /* initialize real-time kicktable       */
{
     int i;
     struct kook *kckptr;
 
     for (i=0,kckptr=kcktbl ; i < KTSIZE ; i++,kckptr++) {
          kckptr->countr=0;
     }
}
 
rtkick(delay,dstrou)               /* real-time kicktable handler          */
int delay;
int (*dstrou)();
{
     int i;
     struct kook *kckptr;
 
     for (i=0,kckptr=kcktbl ; i < KTSIZE ; i++,kckptr++) {
          if (kckptr->countr == 0) {
               kckptr->countr=delay;
               kckptr->dest=dstrou;
               return;
          }
     }
     catastro("RTKICK: KCKTBL OVERFLOW");
}
 
prcrtk()                           /* call an rtkick's specified routine   */
{
     int i;
     struct kook *kckptr;
 
     for (i=0,kckptr=kcktbl ; i < KTSIZE ; i++,kckptr++) {
          if (kckptr->countr != 0 && --(kckptr->countr) == 0) {
               (*(kckptr->dest))();
          }
     }
}
 
