/***************************************************************************
 *                                                                         *
 *   REGISTRY.C                                                            *
 *                                                                         *
 *   Copyright (C) 1988-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS user "registry" module.                         *
 *                                                                         *
 *                                  - T. Stryker & S. Brinker 1/24/88      *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "btvstf.h"
#include "registry.h"
#include "portable.h"
 
int inireg(),regnot(),regrou(),reglst(),dfsthn(),delreg(),clsreg();
 
#define REGSTT      18        /* User Registry state                  */
struct module module18={      /* module interface block               */
     '*',                     /*    main menu select character (config'able) */
     "",                      /*    description for main menu  (config'able) */
     inireg,                  /*    system initialization routine     */
     regnot,                  /*    user logon supplemental routine   */
     regrou,                  /*    input routine if selected         */
     reglst,                  /*    status-input routine if selected  */
     NULL,                    /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     delreg,                  /*    delete-account routine            */
     clsreg                   /*    finish-up (sys shutdown) routine  */
};
 
static
FILE *regmb;                  /* registry named-message file block pointer */
static
BTVFILE *regbb;               /* registry btrieve message file block ptr.  */
 
#define PROSIZ 900            /* profile size (gen purp. text block)       */
#define SUMSIZ 40             /* number of bytes allowed for summary       */
 
struct regrec {               /* user registry structures                  */
     char userid[UIDSIZ];     /* user-id of registry record                */
     char sumlin[SUMSIZ];     /* one-line summary for directory            */
     char profil[PROSIZ];     /* user's "profile"                          */
     char spare[1002-950];    /* spare space, decrease when adding         */
};
struct regusr {
     int fldidx;              /* current field index for creation, editing */
     int flags;               /* registry user's bit-definable flags       */
     long fpos;               /* file position for directory output        */
     struct regrec regblk;    /* user's current registry record in mem.    */
};                            /* dynamically allocated regusr array        */
 
                              /* definition of registry bit "flags"        */
#define CRTMNU 1              /* show create menu                          */
#define UPDYOU 2              /* need to update "your" user file           */
#define GOTONE 4              /* gotten a user-id lookup once already      */
 
#define MAXFLD 30             /* maximum number of fields in profile       */
#define MAXLIN 20             /* maximum number of lines per directory page*/
 
static
struct regidx {
     int fidx;                /* index for prf messages                    */
     int fsiz;                /* size for btumils, etc.                    */
} regidx[MAXFLD];
 
static
int numfds,                   /* number of configured fields               */
    regnlv;                   /* registry allows non-live entry flag       */
extern
struct module *module[NMODS]; /* array of module ptrs                      */
 
#define regptr ((struct regusr *)vdaptr)
 
inireg()                           /* initialize registry module           */
{
     int gloreg();
 
     regmb=opnmsg("registry.mcv");
     inimid(REGSTT,REGSEL,REGMNU);
     regnlv=ynopt(REGNLV);
     dclvda(sizeof(struct regusr));
     makrar();
     regbb=opnbtv("registry.dat",sizeof(struct regrec));
     globalcmd(gloreg);
}
 
makrar()                           /* make registry array from msg. file   */
{
     int curidx;
 
     curidx=0;
     for (numfds=0 ; numfds < MAXFLD ; numfds++) {
          if ((regidx[numfds].fsiz=atoi(getmsg(FLDSIZ1+2*numfds))) != 0) {
               regidx[numfds].fidx=curidx;
               curidx+=regidx[numfds].fsiz+1;
          }
          else if (curidx > PROSIZ) {
               catastro("MAKRAR: BYTE COUNT TOO LARGE!");
          }
          else {
               break;
          }
     }
}
 
regnot()                           /* notify user to fill out registry     */
{
     setbtv(regbb);
     setmbk(regmb);
     if (usaptr->usedat[0] != '\0' && !qeqbtv(usaptr->userid,0)
      && module[REGSTT]->select != '\0' && (regnlv || usrptr->class > FRELOA)) {
          prfmsg(REGPLS);
          outprf(usrnum);
     }
}
 
static int
gloreg()                           /* global registry-lookup command       */
{
     if (margc == 2 && sameas(margv[0],"/r")) {
          setmbk(regmb);
          setbtv(regbb);
          nxtcmd=margv[1];
          if (acqbtv(vdatmp,cncuid(),0)) {
               prfmsg(ENTFOR,((struct regrec *)vdatmp)->userid);
               shwprop(RENTRY,SUMDSP,vdatmp);
          }
          else {
               prfmsg(NOSUID);
          }
          outprf(usrnum);
          return(1);
     }
     return(0);
}
 
regrou()                           /* main registry input handler          */
{
     setmbk(regmb);
     setbtv(regbb);
     if (margc > 0 && (sameas(margv[0],"x") || sameas(margv[0],"exit"))) {
          if (regptr->flags&UPDYOU) {
               regptr->flags&=~UPDYOU;
               geqbtv(NULL,usaptr->userid,0);
               updbtv(&regptr->regblk);
          }
          switch (usrptr->substt) {
          case 1:
               prfmsg(EXIREG);
               return(0);
          case 4:
          case 5:
               prfmsg(NOTDUN);
          case 2:
          case 3:
          case 6:
          case 9:
               btumil(usrnum,DFTIMX);
               go2mai();
               break;
          case 7:
          case 8:
               btumil(usrnum,DFTIMX);
               prfmsg(EDTWHT);
               usrptr->substt=6;
               break;
          }
     }
     else {
          do {
               bgncnc();
               switch (usrptr->substt) {
               case 0:
                    setmem(regptr,vdasiz,0);
                    cncchr();
                    usrptr->flags&=~X2MAIN;
                    if (!acqbtv(&(regptr->regblk),usaptr->userid,0)) {
                         regptr->flags|=CRTMNU;
                         prfmsg(GENINF);
                    }
                    regmnu();
                    usrptr->substt=1;
                    break;
               case 1:
                    regrou1();
                    break;
               case 2:
                    regrou2();
                    break;
               case 3:
                    regrou3();
                    break;
               case 4:
                    regrou4();
                    break;
               case 5:
                    regrou5();
                    break;
               case 6:
                    regrou6();
                    break;
               case 7:
                    regrou7();
                    break;
               case 8:
                    regrou8();
                    break;
               case 9:
                    regrou9();
                    break;
               }
          } while (!endcnc());
     }
     outprf(usrnum);
     return(1);
}
 
regrou1()                          /* registry menu sub-state handler      */
{
     if (margc == 0) {
          prfmsg(SHRMNU);
     }
     else {
          switch (cncchr()) {
          case 'G':
               prfmsg(GENINF);
          case '?':
               regmnu();
               break;
          case 'D':
               prfmsg(DIRPMT);
               btumil(usrnum,4);
               usrptr->substt=2;
               break;
          case 'Y':
               if (!regnlv && usrptr->class < PAYING) {
                    prfmsg(NOYSIR);
                    regmnu();
               }
               else if (regptr->flags&CRTMNU) {
                    btumil(usrnum,regidx[0].fsiz);
                    regptr->fldidx=0;
                    prfmsg(BGNCRT);
                    prfmsg(FLDPMT1);
                    usrptr->substt=4;
               }
               else {
                    geqbtv(&regptr->regblk,usaptr->userid,0);
                    prfmsg(YOUARE);
                    shwpro(EDTENT,SUMEDT);
                    prfmsg(EDTWHT);
                    usrptr->substt=6;
               }
               break;
          case 'L':
               prfmsg(UIDTOL);
               usrptr->substt=9;
               break;
          default:
               prfmsg(NOSUCH);
               cncall();
               go2mai();
          }
     }
}
 
regrou2()                          /* begin directory sub-state handler    */
{
     if (margc == 0) {
          prfmsg(DIRPMT);
     }
     else if (sameas(margv[0],"?")) {
          prfmsg(DINTRO,MAXLIN);
     }
     else {
          if (qgebtv(cncuid(),0)) {
               btumil(usrnum,DFTIMX);
               gcrbtv(&regptr->regblk,0);
               prfmsg(TITLIN);
               prf("%-9s ... %s\r",
                   regptr->regblk.userid,regptr->regblk.sumlin);
               usrptr->substt=3;
               btuinj(usrnum,CYCLE);
               regptr->fpos=absbtv();
          }
          else {
               prfmsg(NEXIST);
               prfmsg(DIRPMT);
          }
     }
     cncall();
}
 
regrou3()                          /* listing directory sub-state handler  */
{
     btuclo(usrnum);
     prfmsg(ABORTD);
     go2mai();
     cncall();
}
 
regrou4()                          /* fill out registry sub-state handler  */
{
     if (margc == 0 || sameas(margv[0],"?")) {
          prfmsg(FLDPMT1+2*(regptr->fldidx));
     }
     else if (pfnlvl > 1) {
          prfmsg(BCLEAN);
          prfmsg(FLDPMT1+2*(regptr->fldidx));
     }
     else {
          movmem(cncall(),
               regptr->regblk.profil+regidx[regptr->fldidx].fidx,
               regidx[regptr->fldidx].fsiz);
          regptr->fldidx++;
          if (regptr->fldidx < numfds) {
               btumil(usrnum,regidx[regptr->fldidx].fsiz);
               prfmsg(FLDPMT1+2*(regptr->fldidx));
          }
          else {
               prfmsg(ENTSUM);
               btumil(usrnum,SUMSIZ-1);
               usrptr->substt=5;
          }
     }
     cncall();
}
 
regrou5()                          /* fill out summary sub-state handler   */
{
     if (margc == 0 || sameas(margv[0],"?")) {
          prfmsg(ENTSUM);
     }
     else if (pfnlvl > 1) {
          prfmsg(BCLEAN);
          prfmsg(ENTSUM);
     }
     else {
          movmem(cncall(),regptr->regblk.sumlin,SUMSIZ-1);
          movmem(usaptr->userid,regptr->regblk.userid,UIDSIZ);
          insbtv(&regptr->regblk);
          btumil(usrnum,DFTIMX);
          regptr->flags&=~CRTMNU;
          prfmsg(THANKS);
          go2mai();
     }
     cncall();
}
 
regrou6()                          /* edit registry sub-state handler      */
{
     int temp;
 
     if (margc == 0) {
          prfmsg(EDTWHT);
     }
     else if (sameas(margv[0],"?")) {
          prfmsg(YOUARE);
          shwpro(EDTENT,SUMEDT);
          prfmsg(EDTWHT);
          cncall();
     }
     else {
          if ((temp=cncint()) == 99) {
               prfmsg(ENTNSM);
               btumil(usrnum,SUMSIZ-1);
               usrptr->substt=8;
          }
          else if (temp < 1 || temp > numfds) {
               prfmsg(NOSUCH);
               prfmsg(EDTWHT);
               cncall();
          }
          else {
               regptr->fldidx=temp-1;
               btumil(usrnum,regidx[regptr->fldidx].fsiz);
               prfmsg(ENTNEW,temp);
               usrptr->substt=7;
          }
     }
}
 
regrou7()                          /* enter new info sub-state handler     */
{
     if (margc == 0 || sameas(margv[0],"?")) {
          prfmsg(NEWINF);
          cncall();
     }
     else if (pfnlvl > 1) {
          prfmsg(BCLEAN);
          prfmsg(NEWINF);
          cncall();
     }
     else {
          movmem(cncall(),
               regptr->regblk.profil+regidx[regptr->fldidx].fidx,
               regidx[regptr->fldidx].fsiz);
          regptr->flags|=UPDYOU;
          btumil(usrnum,DFTIMX);
          prfmsg(UPDATD);
          prfmsg(EDTWHT);
          usrptr->substt=6;
     }
}
 
regrou8()                          /* enter new summary sub-state handler  */
{
     if (margc == 0 || sameas(margv[0],"?")) {
          prfmsg(ENTNSM);
          cncall();
     }
     else if (pfnlvl > 1) {
          prfmsg(BCLEAN);
          prfmsg(ENTNSM);
          cncall();
     }
     else {
          movmem(cncall(),regptr->regblk.sumlin,SUMSIZ-1);
          btumil(usrnum,DFTIMX);
          regptr->flags|=UPDYOU;
          prfmsg(UPDATD);
          prfmsg(EDTWHT);
          usrptr->substt=6;
     }
}
 
regrou9()                          /* look-up a user sub-state handler     */
{
     if (margc == 0 || sameas(margv[0],"?")) {
          prfmsg((regptr->flags&GOTONE) ? UIDTLN : UIDTOL);
     }
     else if (strlen(margv[0]) < 3 && cncchr() == 'N') {
          if (agtbtv(&regptr->regblk,regptr->regblk.userid,0)) {
               prfmsg(ENTFOR,regptr->regblk.userid);
               shwpro(RENTRY,SUMDSP);
               regptr->flags|=GOTONE;
               prfmsg(UIDTLN);
          }
          else {
               btumil(usrnum,DFTIMX);
               prfmsg(ALDONE);
               go2mai();
          }
     }
     else {
          if (acqbtv(&regptr->regblk,cncuid(),0)) {
               prfmsg(ENTFOR,regptr->regblk.userid);
               shwpro(RENTRY,SUMDSP);
               regptr->flags|=GOTONE;
               prfmsg(UIDTLN);
          }
          else {
               prfmsg(NOSUID);
               prfmsg((regptr->flags&GOTONE) ? UIDTLN : UIDTOL);
          }
     }
     cncall();
}
 
regmnu()                           /* display main registry menu           */
{
     prfmsg((regptr->flags&CRTMNU) ? CREMNU : EDTMNU);
}
 
shwpro(msg,msg2)                   /* display a user's profile             */
int msg,msg2;
{
     shwprop(msg,msg2,&regptr->regblk);
}
 
shwprop(msg,msg2,rblkpt)           /* display a profile pointed to by rblkpt */
int msg,msg2;
struct regrec *rblkpt;
{
     char *datptr,*orgbuf,*buf;
     int i,hold,skount;
 
     datptr=rblkpt->profil;
     buf=getmsg(msg);
     orgbuf=buf;
     i=0;
     while (*buf != '\0') {
          if ((skount=pcts(buf)) > 0) {
               buf+=skount;
               hold=*buf;
               *buf='\0';
               prf(orgbuf,datptr+regidx[i++].fidx);
               *buf=hold;
               orgbuf=buf;
          }
          else {
               if (*buf == '\n') {
                    *buf='\r';
               }
               buf+=1;
          }
     }
     prf(orgbuf);
     prfmsg(msg2,rblkpt->sumlin);
}
 
pcts(buf)                          /* prf() utility for shwpro()           */
char *buf;
{
     int i;
 
     if (*buf == '%') {
          i=2;
          while (*++buf == '-' || isdigit(*buf)) {
               i+=1;
          }
          if (*buf == 's') {
               return(i);
          }
          catastro("PCTS: %%-TOKEN NOT %%S IN DISPLAY MESSAGE");
     }
     return(0);
}
 
reglst()                           /* status handler: registry listing     */
{
     setmbk(regmb);
     if (usrptr->substt == 3 && status == CYCLE) {
          setbtv(regbb);
          getdir();
     }
}
 
getdir()                           /* get records in registry directory    */
{
     if ((btuoba(usrnum)) >= 500) {
          gabbtv(NULL,regptr->fpos,0);
          if (qnxbtv()) {
               movmem(regbb->data,&regptr->regblk,sizeof(struct regrec));
               prf("%-9s ... %s\r",
                   regptr->regblk.userid,regptr->regblk.sumlin);
               outprf(usrnum);
               regptr->fpos=absbtv();
          }
          else {
               prfmsg(DIREND);
               go2mai();
               outprf(usrnum);
               return;
          }
     }
     btuinj(usrnum,CYCLE);
}
 
static
go2mai()                           /* go back to main registry menu, or exit */
{
     condex();
     prfmsg(SHRMNU);
     usrptr->substt=1;
}
 
delreg(uid)                        /* delete utility: delete registry entry*/
char *uid;
{
     setbtv(regbb);
     if (acqbtv(NULL,uid,0)) {
          delbtv();
     }
}
 
clsreg()                           /* close registry files for shutdown    */
{
     clsmsg(regmb);
     clsbtv(regbb);
}
