/***************************************************************************
 *                                                                         *
 *   POLLSTER.C                                                            *
 *                                                                         *
 *   Copyright (C) 1988-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS pollster's paradise module.                     *
 *                                                                         *
 *                                          - T. Stryker 7/19/87           *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "majorbbs.h"
#include "usracc.h"
#include "pollster.h"
#include "portable.h"
 
int inipol(),pollster(),dfsthn(),clspol();
 
#define POLSTT      16        /* pollster state                       */
struct module module16={      /* module interface block               */
     '*',                     /*    main menu select character (config'able) */
     "",                      /*    description for main menu  (config'able) */
     inipol,                  /*    system initialization routine     */
     NULL,                    /*    user logon supplemental routine   */
     pollster,                /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     clspol                   /*    finish-up (sys shutdown) routine  */
};
 
static
FILE *polmb;                  /* pollster named-message file block pointer */
static
FILE *polrsp;                 /* regular DOS file for poll responses       */
static
char *pmprmt;                 /* poll menu prompt string (in pool)         */
 
#define POLCNT 10             /* maximum number of different polls active  */
#define QPERPL 20             /* maximum number of questions per poll      */
#define NCHPOL 8              /* num of chars from QID for use as Q name   */
 
static
char polnam[POLCNT][NCHPOL+1];/* names of questionaires (first NCHPOL chrs)*/
 
inipol()                           /* initialize pollster module           */
{
     int flushp();
 
     makpmt();
     opnprs();
     rtkick(120,flushp);
}
 
makpmt()                           /* create polls from message file       */
{
     char *idstg;
     int i;
 
     polmb=opnmsg("pollster.mcv");
     inimid(POLSTT,POLSEL,POLMNU);
     prfnpct(INTRO);
     setmem(polnam,POLCNT*(NCHPOL+1),0);
     for (i=0 ; i < POLCNT ; i++) {
          if (*(idstg=getmsg(QID1+i)) != '\0') {
               movmem(idstg,polnam[i],NCHPOL);
               prf("  %2d. %s\r",i+1,idstg);
          }
     }
     prfnpct(INTRAIL);
     pmprmt=alcmem(strlen(prfbuf)+1);
     strcpy(pmprmt,prfbuf);
     clrprf();
}
 
prfnpct(msgno)                     /* prf() without percents               */
int msgno;
{
     if (msgno == PMSHORT && (usrptr->flags&CONCEX)) {
          prfmsg(EXIPOL);
          longjmp(ADDR_OFeximod,1);
     }
     prf("%s",getmsg(msgno));
}
 
flushp()                           /* save pollster replies                */
{
     fclose(polrsp);
     opnprs();
     rtkick(120,flushp);
}
 
opnprs()                           /* open pollster response file          */
{
     if ((polrsp=fopen("pollrsps.txt",FOPAA)) == NULL) {
          catastro("CAN'T OPEN POLLRSPS.TXT FOR APPEND!");
     }
}
 
pollster()                         /* pollster main input handler          */
{
     int polsel;
 
     setmbk(polmb);
     do {
          bgncnc();
          switch (usrptr->substt) {
          case 0:
               prf("%s",pmprmt);
               usrptr->substt=-1;
               cncchr();
               usrptr->flags&=~X2MAIN;
               break;
          case -1:
               cncall();
               if (margc == 0) {
                    prfnpct(PMSHORT);
               }
               else if (margc == 1) {
                    if (sameas(margv[0],"?")) {
                         prf("%s",pmprmt);
                    }
                    else if (sameas(margv[0],"r")) {
                         prfnpct(RESULTS);
                         prfnpct(PMSHORT);
                    }
                    else if (sameas(margv[0],"x")) {
                         prfnpct(EXIPOL);
                         return(0);
                    }
                    else if (sameas(margv[0],"update") && (usrptr->flags&ISYSOP)) {
                         newmcv();
                    }
                    else if (sameas(margv[0],"clear") && (usrptr->flags&ISYSOP)) {
                         fclose(polrsp);
                         unlink("pollrsps.txt");
                         opnprs();
                         prfnpct(PMSHORT);
                    }
                    else if ((polsel=atoi(margv[0])) > 0
                       && polsel <= POLCNT
                       && polnam[polsel-1][0] != '\0') {
                         usrptr->substt=polsel;
                         usrptr->countr=1;
                         prf("\r");
                         prfcurq();
                    }
                    else {
                         prfmsg(PMERR,margv[0]);
                         prfnpct(PMSHORT);
                    }
               }
               else {
                    prfnpct(JSTONE);
                    prfnpct(PMSHORT);
               }
               break;
          default:
               cncall();
               if (margc == 0) {
                    prfcurq();
               }
               else if (margc == 1 && sameas(margv[0],"x")) {
                    prfnpct(EXIQES);
                    prfnpct(PMSHORT);
                    usrptr->substt=-1;
               }
               else {
                    rstrin();
                    fprintf(polrsp,"%-8s%02d %-9s %c %c %s\n",
                         polnam[usrptr->substt-1],usrptr->countr,usaptr->userid,
                         usaptr->sex,(usrptr->class == PAYING ? 'P' : 'F'),margv[0]);
                    if (usrptr->countr++ >= QPERPL || !prfcurq()) {
                         clrprf();
                         if (usrptr->flags&CONCEX) {
                              prfmsg(EXIPOL);
                              longjmp(ADDR_OFeximod,1);
                         }
                         prfmsg(POLDUN,usrptr->substt);
                         usrptr->substt=-1;
                    }
               }
          }
     } while (!endcnc());
     outprf(usrnum);
     return(1);
}
 
prfcurq()                          /* displays current poll question       */
{
     prfnpct(Q1TXT1+(usrptr->substt-1)*QPERPL+usrptr->countr-1);
     return(prfbuf[0] != '\0');
}
 
newmcv()                           /* install new pollster.mcv file        */
{
     int i;
     struct user *uptr;
     FILE *fp;
 
     for (i=0,uptr=user ; i < nterms ; i++,uptr++) {
          if (uptr->state == POLSTT && i != usrnum) {
               prfnpct(NONEWM);
               prfnpct(PMSHORT);
               return;
          }
     }
     if ((fp=fopen("pollster.upd",FOPRA)) == NULL) {
          prfnpct(NOUPDF);
          prfnpct(PMSHORT);
          return;
     }
     fclose(fp);
     clsmsg(polmb);
     free(pmprmt);
     unlink("pollster.xxx");
     rename("pollster.mcv","pollster.xxx");
     rename("pollster.upd","pollster.mcv");
     rename("pollster.xxx","pollster.upd");
     makpmt();
     prf("%s",pmprmt);
}
 
clspol()                           /* close pollster files for shutdown    */
{
     clsmsg(polmb);
     if (polrsp != NULL) {
          fclose(polrsp);
     }
}
