/***************************************************************************
 *                                                                         *
 *   POLLREPT.C                                                            *
 *                                                                         *
 *   Copyright (C) 1988 GALACTICOMM, Inc.      All Rights Reserved.        *
 *                                                                         *
 *   This is the Major BBS pollster's paradise reporting program.          *
 *                                                                         *
 *                                          - T. Stryker 7/19/87           *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "portable.h"
#include "dosface.h"
 
#define QPERPL 20             /* maximum number of questions per poll      */
#define NCHPOL 8              /* num of chars from QID for use as Q name   */
#define UIDSIZ 10             /* user-id size (including trailing zero)    */
#define ANSOFF 25             /* answer offset from start of record in rsps*/
 
struct pollid {                         /* data structure for each poll    */
     struct pollid *fwd;                /*   linked list (LL) fwd pointer  */
     char polnam[NCHPOL+1];             /*   poll name                     */
     struct user *usrhdr,*ustail;       /*   users-who-answ'd LL head/tail */
     struct answer *anshdr[QPERPL];     /*   actual answer text LL headers */
     struct answer *antail[QPERPL];     /*   actual answer text LL tails   */
} *polhdr,*potail;                 /* poll linked list header and tail     */
 
struct user {                      /* data structure per user in pollid LL */
     struct user *fwd;             /*   linked list forward pointer        */
     char userid[UIDSIZ];          /*   userid of user who answered poll   */
};
 
struct answer {                    /* data structure per answer class      */
     struct answer *fwd;           /*   linked list forward pointer        */
     char *anstxt;                 /*   answer text (alc'd from mem pool)  */
     int occurs;                   /*   total number of occurrences        */
     int malocc;                   /*   number of male occurrences         */
     int payocc;                   /*   number of paying-user occurrences  */
};
                                   /* vbls common to rsetup & rdrsps       */
char buffer[255];                  /*   input disk-record buffer           */
char pname[NCHPOL+1];              /*   poll name read in from disk record */
int qnum;                          /*   questionnaire no. from disk record */
struct pollid *thspol;             /*   pollid pointer holder once found   */
struct answer *thsans;             /*   answer-class ptr holder once found */
 
int buildg;                        /* "building" phase (rsetup in progress)*/
int linesl,pageno;                 /* lines left on page, and page number  */
 
FILE *foop(),*fopen();
char *foogets(),*fgets();
char *alcmem();
struct pollid *getpol(),*fndpol();
struct answer *getans(),*fndans();
 
main()
{
     rsetup();                     /* read-in "setup" file (POLLREPT.SPC)  */
     rdrsps();                     /* read-in responses    (POLLRSPS.TXT)  */
     outrpt();                     /* output report to stdout              */
}
 
rsetup()
{
     FILE *blfp;
     char spcstg[10][41];
     int nspcs,i;
 
     buildg=1;
     if ((blfp=fopen("pollrept.spc",FOPRA)) != NULL) {
          while (fgets(buffer,sizeof(buffer),blfp) != NULL) {
               buffer[strlen(buffer)-1]='\0';
               cvttab(buffer,sizeof(buffer));
               if (strlen(buffer) > NCHPOL) {
                    whatup("Setting up: %.11s",buffer);
                    if ((nspcs=sscanf(buffer,
                     "%8c%d%40s%40s%40s%40s%40s%40s%40s%40s%40s%40s",
                     pname,&qnum,
                     spcstg[0],spcstg[1],spcstg[2],spcstg[3],spcstg[4],
                     spcstg[5],spcstg[6],spcstg[7],spcstg[8],spcstg[9])-2) < 0
                     || qnum < 1 || qnum > QPERPL) {
                         printf("\nError in SPC file: %s",buffer);
                         exit();
                    }
                    qnum-=1;
                    thspol=getpol(pname);
                    for (i=0 ; i < nspcs ; i++) {
                         cvtspc(spcstg[i]);
                         getans(thspol,qnum,spcstg[i]);
                    }
               }
          }
          fclose(blfp);
     }
}
 
whatup(ctlstg,parm1,parm2)
char *ctlstg,*parm1,*parm2;
{
     locate(0,curcury());
     printf(ctlstg,parm1,parm2);
     clreol();
}
 
rdrsps()
{
     FILE *infp;
     char handle[UIDSIZ],gender[2],porf[2];
     int ssnum;
 
     buildg=0;
     infp=foop("pollrsps.txt");
     while (foogets(buffer,sizeof(buffer),infp) != NULL) {
          cvttab(buffer,sizeof(buffer));
          if (strlen(buffer) > NCHPOL) {
               whatup("Reading in: %.11s",buffer);
               if (((ssnum=sscanf(buffer,"%8c%d%9s%1s%1s",
                pname,&qnum,handle,gender,porf)) != 5 && ssnum != 4)
                || qnum < 1 || qnum > QPERPL) {
                    printf("\nError in TXT file: %s\n",buffer);
                    exit();
               }
               if (ssnum == 4) {
                    porf[0]=gender[0];
                    gender[0]=' ';
               }
               qnum-=1;
               thspol=getpol(pname);
               if (!uidinl(thspol,handle)) {
                    thsans=getans(thspol,qnum,buffer+ANSOFF);
                    thsans->occurs+=1;
                    thsans->malocc+=(gender[0] != 'F');
                    thsans->payocc+=(porf[0]   == 'P');
                    if (qnum == 0) {
                         lstuid(thspol,handle);
                    }
               }
          }
     }
     fclose(infp);
}
 
cvttab(buf,siz)
char *buf;
int siz;
{
     char *bp;
     int ntoadd;
 
     for (bp=buf ; *bp != '\0' ; bp++) {
          if (*bp == 9 && strlen(buf)+(ntoadd=(7-((bp-buf)&7))) < siz) {
               movmem(bp,bp+ntoadd,strlen(bp)+1);
               setmem(bp,ntoadd+1,32);
               bp+=ntoadd;
          }
     }
}
 
cvtspc(buf)
char *buf;
{
     while (*buf != '\0') {
          if (*buf == '^') {
               *buf=' ';
          }
          buf+=1;
     }
}
 
uidinl(thspol,handle)
struct pollid *thspol;
char *handle;
{
     struct user *uptr;
 
     for (uptr=thspol->usrhdr ; uptr != NULL ; uptr=uptr->fwd) {
          if (strcmp(uptr->userid,handle) == 0) {
               return(1);
          }
     }
     return(0);
}
 
lstuid(thspol,handle)
struct pollid *thspol;
char *handle;
{
     struct user *uptr;
 
     uptr=(struct user *)alcmem(sizeof(struct user));
     setmem(uptr,sizeof(struct user),0);
     strcpy(uptr->userid,handle);
     if (thspol->ustail == NULL) {
          thspol->usrhdr=uptr;
     }
     else {
          thspol->ustail->fwd=uptr;
     }
     thspol->ustail=uptr;
}
 
struct pollid *getpol(pname)
char *pname;
{
     struct pollid *thspol;
 
     if ((thspol=fndpol(pname)) == NULL) {
          thspol=(struct pollid *)alcmem(sizeof(struct pollid));
          setmem(thspol,sizeof(struct pollid),0);
          strcpy(thspol->polnam,pname);
          if (potail == NULL) {
               polhdr=thspol;
          }
          else {
               potail->fwd=thspol;
          }
          potail=thspol;
     }
     return(thspol);
}
 
struct pollid *fndpol(pname)
char *pname;
{
     struct pollid *pptr;
 
     for (pptr=polhdr ; pptr != NULL ; pptr=pptr->fwd) {
          if (strcmp(pname,pptr->polnam) == 0) {
               return(pptr);
          }
     }
     return(NULL);
}
 
struct answer *getans(thspol,qnum,buffer)
struct pollid *thspol;
int qnum;
char *buffer;
{
     struct answer *thsans;
 
     if (buildg || (thsans=fndans(thspol,qnum,buffer)) == NULL) {
          thsans=(struct answer *)alcmem(sizeof(struct answer));
          setmem(thsans,sizeof(struct answer),0);
          thsans->anstxt=alcmem(strlen(buffer)+1);
          strcpy(thsans->anstxt,buffer);
          if (thspol->antail[qnum] == NULL) {
               thspol->anshdr[qnum]=thsans;
          }
          else {
               thspol->antail[qnum]->fwd=thsans;
          }
          thspol->antail[qnum]=thsans;
     }
     return(thsans);
}
 
struct answer *fndans(thspol,qnum,buffer)
struct pollid *thspol;
int qnum;
char *buffer;
{
     struct answer *aptr;
 
     for (aptr=thspol->anshdr[qnum] ; aptr != NULL ; aptr=aptr->fwd) {
          if (pcmtch(buffer,aptr->anstxt)) {
               return(aptr);
          }
     }
     return(NULL);
}
 
pcmtch(input,picstg)
char *input,*picstg;
{
     char c,pc;
     char *lanypc=NULL,*lanyin;
 
     while ((c=*input++) != '\0') {
          if ((pc=*picstg++) == '*') {
               while ((pc=*picstg) == '*') {
                    picstg+=1;
               }
               while (!cmtch(c,pc)) {
                    if (c == '\0') {
                         return(0);
                    }
                    c=*input++;
               }
               lanypc=picstg-1;
               lanyin=input;
               input-=1;
          }
          else {
               if (!cmtch(c,pc)) {
                    if (lanypc != NULL) {
                         picstg=lanypc;
                         input=lanyin;
                    }
                    else {
                         return(0);
                    }
               }
          }
     }
     while (*picstg == '*') {
          picstg+=1;
     }
     return(*picstg == '\0');
}
 
cmtch(c,pc)
char c,pc;
{
     switch (pc) {
     case '@':                        /* any-char */
          return(1);
     default:
          return(tolower(c) == tolower(pc));
     }
}
 
FILE *foop(filnam)
char *filnam;
{
     FILE *fp,*fopen();
 
     if ((fp=fopen(filnam,FOPRB)) == NULL) {
          printf("\nCAN'T OPEN %s\n",filnam);
          exit();
     }
     if (fseek(fp,0L,2) != 0) {
          printf("\nCAN'T FSEEK TO END OF %s\n",filnam);
          exit();
     }
     return(fp);
}
 
char *foogets(buf,siz,fp)
char *buf;
int siz;
FILE *fp;
{
     char intbuf[255],*ibfptr;
     int i,c;
 
     for (ibfptr=intbuf ; (c=foogetc(fp)) != '\n' && c != EOF ; ) {
          *ibfptr++=c;
     }
     if (c == EOF && ibfptr == intbuf) {
          return(NULL);
     }
     for (i=1 ; i < siz && ibfptr != intbuf ; i++) {
          *buf++=*--ibfptr;
     }
     *buf='\0';
     return(buf);
}
 
foogetc(fp)
FILE *fp;
{
     int c;
 
     do {
          if (fseek(fp,-2L,1) != 0) {
               return(EOF);
          }
     } while ((c=fgetc(fp)) == '\r');
     return(c == '\0' ? ' ' : c);
}
 
outrpt()
{
     struct pollid *pptr;
     struct answer *aptr;
     int i,nlins;
     char leadin[12],ansbuf[30];
     int mtot,ftot,ptot,etot,otot,focc,eocc;
     char *pct();
 
     whatup("Outputting Report... ");
     for (pptr=polhdr ; pptr != NULL ; pptr=pptr->fwd) {
          frcpag(0);
          for (i=0 ; i < QPERPL ; i++) {
               mtot=ftot=ptot=etot=otot=nlins=0;
               for (aptr=pptr->anshdr[i] ; aptr != NULL ; aptr=aptr->fwd) {
                    mtot+=aptr->malocc;
                    ftot+=aptr->occurs-aptr->malocc;
                    ptot+=aptr->payocc;
                    etot+=aptr->occurs-aptr->payocc;
                    otot+=aptr->occurs;
                    nlins+=1;
               }
               sprintf(leadin,"%-8s %02d",pptr->polnam,i+1);
               if (nlins != 0) {
                    pospag(nlins+3);
               }
               for (aptr=pptr->anshdr[i] ; aptr != NULL ; aptr=aptr->fwd) {
                    focc=aptr->occurs-aptr->malocc;
                    eocc=aptr->occurs-aptr->payocc;
                    sprintf(ansbuf,"%.14s .............",aptr->anstxt);
                    fprintf(stdout,"\n%11s   %.14s",leadin,ansbuf);
                    fprintf(stdout," %4d(%3s)",aptr->malocc,pct(aptr->malocc,mtot));
                    fprintf(stdout," %4d(%3s)",focc,        pct(focc,ftot));
                    fprintf(stdout," %4d(%3s)",aptr->payocc,pct(aptr->payocc,ptot));
                    fprintf(stdout," %4d(%3s)",eocc,        pct(eocc,etot));
                    fprintf(stdout," %5d(%3s)",aptr->occurs,pct(aptr->occurs,otot));
                    leadin[0]='\0';
               }
               if (nlins != 0) {
                    fprintf(stdout,"\n%34s %9s %9s %9s %10s",
                           "----","----","----","----","-----");
                    fprintf(stdout,"\n%33d %9d %9d %9d %10d\n",
                           mtot,ftot,ptot,etot,otot);
               }
          }
     }
}
 
char *spr(ctlstg,parm1,parm2,parm3)
char *ctlstg,*parm1,*parm2,*parm3;
{
     static char result[80];
 
     sprintf(result,ctlstg,parm1,parm2,parm3);
     return(result);
}
 
frcpag(noff)
int noff;
{
     static char curtim[20],curdat[20];
 
     if (++pageno == 1) {
          sprintf(curtim,"%-5.5s",nctime(now()));
          strcpy(curdat,ncedat(today()));
     }
     else {
          fprintf(stdout,"\14");
     }
     fprintf(stdout,"\nPOLLSTER'S PARADISE REPORT %33s   %s %10s\n\n\n\n",
                     curdat,curtim,spr("Page %d",pageno));
     fprintf(stdout,"%79s\n", "Male     Female     Paid      Free     Overall");
     fprintf(stdout,"%79s\n","-------   -------   -------   -------    -------");
     linesl=52-noff;
}
 
pospag(nlins)
int nlins;
{
     if (linesl != 52 && (linesl-=nlins) < 0) {
          frcpag(nlins);
     }
}
 
char *pct(num,denom)
int num,denom;
{
     static char buf[5];
     int amt;
 
     if ((amt=(num*100L+denom/2)/(denom == 0 ? 1 : denom)) < 100) {
          sprintf(buf,"%2d%%",amt);
     }
     else if (amt > 100 || amt < 0) {
          strcpy(buf,"***");
     }
     else {
          strcpy(buf,"100");
     }
     return(buf);
}
 
char *alcmem(nbytes)
int nbytes;
{
     char *addr;
 
     if ((addr=malloc(nbytes)) == NULL) {
          printf("\nOUT OF MEMORY ERROR!\n");
          exit();
     }
     return(addr);
}
