/***************************************************************************
 *                                                                         *
 *   MSGUTL.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This file contains a library of routines for dealing with .MCV files  *
 *   (output from MSGIDX).  These routines allow the converted messages    *
 *   to be retrieved by message number, which will generally be done thru  *
 *   the symbolic names "#defined" in MSGIDX's output header file.         *
 *                                                                         *
 *   There are also some utility routines for extracting options or        *
 *   parameters from these messages files, of type:  numeric, yes/no,      *
 *   and keyword identified.                                               *
 *                                                                         *
 *                                            - T. Stryker 6/10/86         *
 *                                            - R. Stein 1/31/88           *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "portable.h"
 
#define MBFSIZ 2001                /* maximum size of each msg (incl '\0') */
 
struct msgblk {                    /* named-message file block             */
     FILE *msgfp;                  /*   fopen()-style file block pointer   */
     int msgcnt;                   /*   count of messages in this file     */
     long *msgloc;                 /*   dynam-alloc'd fseek() msg offsets  */
     char *filnam;                 /*   message file name for error reports*/
};
 
static char *msgbuf=NULL;          /* message text buffer                  */
struct msgblk *curmbk=NULL;        /* set by setmbk()                      */
int lstmsg=-1;
 
struct msgblk *opnmsg(mcvfil)      /* open a message file                  */
char *mcvfil;
{
     char *alcmem();
 
     curmbk=(struct msgblk *)alcmem(sizeof(struct msgblk));
     if ((curmbk->msgfp=fopen(mcvfil,FOPRB)) == NULL) {
          catastro("INIMSG: CAN'T OPEN \"%s\" FOR INPUT",mcvfil);
     }
     if (fread(&(curmbk->msgcnt),sizeof(int),1,curmbk->msgfp) != 1) {
          catastro("INIMSG: CAN'T READ COUNT IN \"%s\"",mcvfil);
     }
     curmbk->msgloc=(long *)alcmem(curmbk->msgcnt*sizeof(long));
     if (fread(curmbk->msgloc,sizeof(long),curmbk->msgcnt,curmbk->msgfp) != curmbk->msgcnt) {
          catastro("INIMSG: CAN'T READ POINTERS IN \"%s\"",mcvfil);
     }
     curmbk->msgcnt-=1;
     curmbk->filnam=alcmem(strlen(mcvfil)+1);
     strcpy(curmbk->filnam,mcvfil);
     lstmsg=-1;
     return(curmbk);
}
 
setmbk(mb)                         /* set message block                    */
struct msgblk *mb;
{
     curmbk=mb;
     lstmsg=-1;
}
 
char *getmsg(msgnum)               /* get a message (by number)            */
int msgnum;
{
     char *alcmem();
     long msgbgn;
 
     if (msgbuf == NULL) {
          msgbuf=alcmem(MBFSIZ);
     }
     if (msgnum < 0 || msgnum >= curmbk->msgcnt) {
          catastro("GETMSG: MSG NO. %d OUT OF RANGE IN %s",msgnum,curmbk->filnam);
     }
     msgbgn=curmbk->msgloc[msgnum];
     if (fseek(curmbk->msgfp,msgbgn,0) != 0) {
          catastro("GETMSG: ERROR SEEKING MSG NO. %d IN %s",msgnum,curmbk->filnam);
     }
     if (fread(msgbuf,(int)(curmbk->msgloc[msgnum+1]-msgbgn),1,curmbk->msgfp) != 1) {
          catastro("GETMSG: ERROR READING MSG NO. %d IN %s",msgnum,curmbk->filnam);
     }
     lstmsg=msgnum;
     return(msgbuf);
}
 
char *catfix2()                    /* catfix2() for catamsg()              */
{
     static char mfbuff[30]={""};
 
     if (curmbk != NULL && curmbk->filnam != NULL) {
          sprintf(mfbuff,"MSG:%s/%d",curmbk->filnam,lstmsg);
     }
     return(mfbuff);
}
 
clsmsg(mb)                         /* close message file                   */
struct msgblk *mb;
{
     if (mb != NULL && mb->filnam != NULL) {
          curmbk=mb;
          fclose(mb->msgfp);
          free(mb->msgloc);
          free(mb->filnam);
          mb->filnam=NULL;
          free(mb);
          if (msgbuf != NULL) {
               free(msgbuf);
               msgbuf=NULL;
          }
     }
}
 
sameas(stg1,stg2)             /* Are strings identical? (ignoring U/L case) */
char *stg1,*stg2;
{
     while (*stg1 != '\0') {
          if (tolower(*stg1) != tolower(*stg2)) {
               return(0);
          }
          stg1+=1;
          stg2+=1;
     }
     return(*stg2 == '\0');
}
 
char *lastwd(string)                          /* Find last word of a string */
char *string;               /* (does not remove trailing blanks after word) */
{
     char *cp;
 
     if (*string == '\0') {
          return(string);
     }
     for (cp=string+strlen(string)-1 ; cp >= string && isspace(*cp) ; cp--) {
          if (cp == string) {
               return(cp);
          }
     }
     for ( ; cp >= string && !isspace(*cp) ; cp--) {
          if (cp == string) {
               return(cp);
          }
     }
     return(cp+1);
}
 
long lngopt(msgnum,floor,ceiling)       /* Get numeric option from msg file */
int msgnum;
long floor,ceiling;                          /* specified limits for number */
{
     long ln;
 
     if (sscanf(lastwd(getmsg(msgnum)),"%ld",&ln)) {
          if (ln >= floor && ln <= ceiling) {
               return(ln);
          }
          catastro("NUMERIC OPTION %d IN %s OUT OF RANGE",msgnum,curmbk->filnam);
     }
     catastro("BAD FORMAT FOR NUMERIC OPTION %d IN %s",msgnum,curmbk->filnam);
}
 
unsigned hexopt(msgnum,floor,ceiling)/* Get hexadecimal option from msg file */
int msgnum;
unsigned floor,ceiling;                      /* specified limits for number */
{
     long ln;
 
     if (sscanf(lastwd(getmsg(msgnum)),"%lx",&ln)) {
          if (ln >= floor && ln <= ceiling) {
               return((unsigned)ln);
          }
          catastro("HEX OPTION %d IN %s OUT OF RANGE",msgnum,curmbk->filnam);
     }
     catastro("BAD FORMAT FOR HEX OPTION %d IN %s",msgnum,curmbk->filnam);
}
 
int numopt(msgnum,floor,ceiling)        /* Get numeric option from msg file */
int msgnum;
int floor,ceiling;                           /* specified limits for number */
{
     return((int)lngopt(msgnum,floor+0L,ceiling+0L));
}
 
int ynopt(msgnum)                     /* Get yes/no option from msg file */
int msgnum;
{
     int rc=0;
 
     switch (toupper(*lastwd(getmsg(msgnum)))) {
     case 'Y':
          rc=1;
     case 'N':
          return(rc);
     }
     catastro("BAD FORMAT FOR YES/NO OPTION %d IN %s",msgnum,curmbk->filnam);
}
 
chropt(msgnum)                /* Get single-character option from msg file */
int msgnum;
{
     return(*lastwd(getmsg(msgnum)));
}
 
char *stgopt(msgnum)               /* get a string from a message file     */
int msgnum;
{
     char *cp,*mp,*alcmem();
 
     cp=alcmem(strlen(mp=getmsg(msgnum))+1);
     strcpy(cp,mp);
     return(cp);
}
 
