/***************************************************************************
 *                                                                         *
 *   MAJORBBS.C                                                            *
 *                                                                         *
 *   Copyright (C) 1987-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS mainline.                                       *
 *                                                                         *
 *                                            - T. Stryker 6/24/86         *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "dos.h"
#include "btvstf.h"
#include "majorbbs.h"
#include "usracc.h"
#include "majormsg.h"
#include "dosface.h"
#include "portable.h"
 
char version[5],              /* main version code, in form X.YY      */
     subvers[40];             /* sub-version info, ext ed rls letters */
 
int mainu(),acsthn(),loscar(),midnit(),mjrfin();
 
struct module module00={      /* module interface block               */
     0,                       /*    main menu select character        */
     "Main menu",             /*    description for main menu         */
     NULL,                    /*    system initialization routine     */
     NULL,                    /*    user logon supplemental routine   */
     mainu,                   /*    input routine if selected         */
     acsthn,                  /*    status-input routine if selected  */
     loscar,                  /*    hangup (lost carrier) routine     */
     midnit,                  /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     mjrfin                   /*    finish-up (sys shutdown) routine  */
};
 
extern struct module          module01,module02,module03,module04,
                     module05,module06,module07,module08,module09,
                     module10,module11,module12,module13,module14,
                     module15,module16,module17,module18,module19,
                     module20,module21,module22,module23,module24,
                     module25,module26,module27,module28,module29,
                     module30,module31,module32,module33,module34,
                     module35,module36,module37,module38,module39,
                     module40,module41,module42,module43,module44,
                     module45,module46,module47,module48,module49;
struct module *module[NMODS]={
                     &module00,&module01,&module02,&module03,&module04,
                     &module05,&module06,&module07,&module08,&module09,
                     &module10,&module11,&module12,&module13,&module14,
                     &module15,&module16,&module17,&module18,&module19,
                     &module20,&module21,&module22,&module23,&module24,
                     &module25,&module26,&module27,&module28,&module29,
                     &module30,&module31,&module32,&module33,&module34,
                     &module35,&module36,&module37,&module38,&module39,
                     &module40,&module41,&module42,&module43,&module44,
                     &module45,&module46,&module47,&module48,&module49
};
 
int nterms,                   /* This many simultaneous users are supported*/
    hichp1,                   /* highest channel number in use, plus 1     */
    usrnum,                   /* global user-number (channel) in effect    */
    othusn,                   /* general purpose other-user channel number */
    uisusn;                   /* uinsys() other-user channel number        */
struct user *user,            /* user volatile-data structure array        */
            *usrptr,          /* global pointer to user data in effect     */
            *othusp;          /* gen purp other-user user structure ptr    */
 
char input[INPSIZ],           /* raw user input data buffer                */
     *margv[INPSIZ/2],        /* array of ptrs to word starts, a la argv[] */
     *margn[INPSIZ/2];        /* array of ptrs to word ends, for rstrin()  */
 
#define GLBMAX 10             /* max number of global command handlers     */
int nglobs,                   /* # of global command handlers in operation */
    (*globs[GLBMAX])();       /* array of ptrs to glbl cmd hdlr functions  */
 
int margc,                    /* number of words in margv[], a la argc     */
    inplen,                   /* overall raw input string length           */
    status,                   /* raw status from btusts, where appropriate */
    pfnlvl;                   /* profanity level of current input (0-3)    */
 
jmp_buf eximod;               /* exit-module longjmp save block            */
 
FILE *mjrmb;                  /* executive named-message file block ptr    */
int mbdone;                   /* main-loop exit flag                       */
int rsmode,                   /* reset-mode code for channels              */
    *rsmodes;                 /* reset-mode array by channel number        */
int kilipg;                   /* kill-system command in progress           */
int kilctr;                   /* number of minutes to shutdown             */
int kilsrc;                   /* kill-command source (-1=console, -2=MCU)  */
int horiz;                    /* horizontal function keys flag             */
int color;                    /* color display adapter in use flag         */
char dots[]={"\371\371\371\371\371\371\371\371\371"}; /* quiescent box dots*/
int iusers;                   /* tells mjrfin ok to reset users            */
int mcuctr=-1;                /* auto-cleanup minute counter               */
int lasthr;                   /* last hour reading sensed by ckmcu()       */
 
int _stack=4096;              /* allow a little extra stack space          */
 
int errcod;                   /* MS-DOS exit codes (for batch files)       */
                              /*    errorlevel  0 - auto-cleanup (mcukil)  */
                              /*    errorlevel  1 - operator "kill-system" */
                              /*    errorlevel  2 - out of memory (alcmem) */
                              /*    errorlevel  3 - catastro()             */
                              /*    errorlevel  4 - multiple catastro()'s  */
                              /*    errorlevel 11 - mail shutdown #1       */
                              /*    errorlevel 12 - mail shutdown #2       */
                              /*    errorlevel 13 - mail shutdown #3       */
                              /*    errorlevel 14 - mail shutdown #4       */
 
int *shterc;                  /* auto-shutdown errorlevels as a function   */
                              /*    of the hour of the day                 */
 
int *channel;                 /* array of channel codes (as displayed)     */
int *grpnum;                  /* array of group numbers, by channel number */
 
#define NGROUPS 8             /* number of channel groups fm MAJORMSG.MSG  */
unsigned maxspd=2400;         /* overall maximum speed of all channels     */
unsigned mxbaud[NGROUPS]={    /* array of maximum baud rates, by chan group*/
     2400,2400,2400,2400,2400,2400,2400,2400};
int echtyp[NGROUPS];          /* array of echo options:                    */
#define ECHNON 0              /*    no echo at all of user keystrokes      */
#define ECHPLX 1              /*    echo comes from user's PAD             */
#define ECHBBS 2              /*    echo comes from the BBS thru X.25 net  */
char *startv[NGROUPS];        /* array of pointers to startup AT-commands  */
 
char grtype[NGROUPS];         /* array of Group Type codes:                */
#define GTMODEM  1            /* group type code:  Modem channels          */
#define GTMLOCK  2            /* group type code:  Locked modem channels   */
#define GTSERIAL 3            /* group type code:  Serial channels         */
#define GTX25    4            /* group type code:  X.25 channels           */
#define GTNONE   5            /* group type code:  No channels             */
 
                              /* line charges for X.25 lines:              */
long ksec[NGROUPS];           /* credits consumed per minute               */
long kpak[NGROUPS];           /* credits consumed per kilo-packet          */
long kchar[NGROUPS];          /* credits consumed per kilo-character       */
 
char huge *vdarea;            /* volatile data area table (vdasiz per user)*/
char      *vdaptr;            /* user's pointer to volatile data area      */
char      *vdatmp;            /* general-purpose temporary vda-size area   */
int vdasiz=0;                 /* max. size requirement of volatile data    */
int eclvdabas;                /* vda base selector if ECLIPSE active       */
char *region;                 /* GSBL channel data region                  */
 
extern jmp_buf disaster;      /* master error-recovery longjmp save block  */
 
extern int ticker;            /* seconds-ticker from brkthu                */
 
extern
int stthue,                   /* system status display attribute code      */
    lblhue,                   /* soft-key labels display attribute code    */
    dsphue,                   /* data display box attribute code           */
    manhue,                   /* monitor-all normal display attribute code */
    mashue,                   /* monitor-all "special" disp attribute code */
    emthue,                   /* emulation text display attribute code     */
    emshue;                   /* emulation status display attribute code   */
 
extern int atoggl;            /* ANSI-display toggle (defaults to ON)      */
 
/*--- OPTIONS FROM MAJORMSG.MSG ---*/
 
int outbsz,                   /* output buffer size per channel             */
    sampln,                   /* number of non-live (free-sample) channels */
    exicnc,                   /* concatenation implies module exit?        */
    ansiop,                   /* ANSI option: on=N; off=F; ask=K; auto=O   */
    rsetop,                   /* reset option: busy=B; no-answer=N         */
    digalw,                   /* digits allowed in User-IDs?               */
    pfceil,                   /* profanity-detection ceiling               */
    emubel,                   /* emulation bell period                     */
    outata,                   /* output ATA to modems when answering?      */
    vispsw,                   /* make passwords visible in detail displays?*/
    idlzap,                   /* the idle user zap interval                */
    zapser,                   /* whether or not to idle-zap serial ports   */
    mcumin,                   /* max grace period minutes on auto-cleanup  */
    mcuwrn,                   /* number of warning messages before hangup  */
    lonaud,                   /* make audit trail entry for each logon?    */
    lofaud,                   /* make audit trail entry for each logoff?   */
    mmuaud,                   /* make audit trail entry for main menu sels?*/
    mmucrr,                   /* Main menu credit consumption rate per min */
    svrate;                   /* System-variable save rate (seconds/save)  */
char *bbsttl,                 /* Title of your BBS                         */
     *company,                /* Your company name                         */
     *addres1,                /* Company address line 1 (street)           */
     *addres2,                /* Company address line 2 (city,state,zip)   */
     *city,                   /* City where the BBS is running             */
     *opnam1,                 /* name of 1st auxillary Sysop               */
     *opnam2,                 /* name of 2nd auxillary Sysop               */
     *opnam3,                 /* name of 3rd auxillary Sysop               */
     *dataph,                 /* The first phone line connected to BBS     */
     *liveph,                 /* The first phone line reserved 4 live users*/
     *chghour,                /* Connect time charge per hour              */
     *chgmin,                 /* Minimum charge                            */
     *chgtime;                /* Minimum connect time                      */
 
char eurmsk=0x7F;             /* 0x7F if U.S.A. only, 0xFF if European     */
 
#define SDFX25 4         /* btusdf() code for X.25 channels                */
#define CNTCHR 0         /* bturep()/btuset() code for character count     */
#define CNTPAK 1         /* bturep()/btuset() code for packet count        */
#define NOTX25 -13       /* btusdf() return code -- no GSBL/X25 linked     */
#define X25CLO 0x500     /* btux29() return code for window-full error     */
 
main()                             /* The Major BBS main program loop      */
{
     sprintf(version,"%d.%02d",BBSVER/100,BBSVER%100);
     if ((errcod=setjmp(disaster)) != 0) {
          (*module00.finrou)();
     }
     errcod=1;
     init();
     usrnum=-1;
     shocst(1,"BBS UP: V%s%s",version,subvers);
     iniaud();
     while (!mbdone) {
          if ((usrnum=btuscn()) >= 0) {
               usrptr=&user[usrnum];
               usaptr=&usracc[usrnum];
               vdaptr=vdaoff(usrnum);
               if ((status=btusts(usrnum)) != CRSTG && status != CYCLE) {
                    shomal();
               }
               if ((usrptr->flags&BYEBYE) && status == OUTMT) {
                    if (usrptr->class >= FRELOA) {
                         (*(module00.huprou))();
                    }
                    else {
                         rstchn();
                    }
               }
               else {
                    if (status < 250) {
                         usrptr->flags|=ACTIVE;
                         if (status != OUTMT) {
                              usrptr->nazapc=0;
                         }
                    }
                    switch (usrptr->class) {
                    case VACANT:
                         svacant();
                         break;
                    case ONLINE:
                         sonline();
                         break;
                    case SUPIPG:
                         ssupipg();
                         break;
                    default:
                         susing();
                    }
               }
          }
          dwopr();
          while (ticker) {
               ticker-=1;
               prcrtk();
          }
          unfrez();
     }
     usrnum=kilsrc;
     shocst(1,"BBS SHUTDOWN");
     (*(module00.finrou))();
}
 
init()                             /* initialize the hardware and software */
{
     char *frzseg(),*lastwd(),*stgopt(),*cp,*crtadr;
     long btulsz(),memreq,lngopt();
     int i,group,chan,msg,iobase,numchn,rc;
     char grt;
     int ckmcu();
 
     fclose(stdaux);
     fclose(stderr);
     fclose(stdprn);
     mjrmb=opnmsg("majormsg.mcv");
     horiz=strcmp(lastwd(getmsg(FUNKEY)),"5x2") != 0;
     ckddos(strcmp(lastwd(getmsg(DDORNW)),"D-DOS") == 0);
     crtadr=frzseg();
     cp=lastwd(getmsg(CRT));
     color=strcmp(cp,"COLOR") == 0 ||
           (strcmp(cp,"MONO") != 0 && crtadr != (char *)0xB0000000L
                                   && crtadr != (char *)0xB00000L);
     nterms=0;
     for (group=0,msg=GROUP1 ; group < NGROUPS ; group++,msg+=GROUP2-GROUP1) {
          cp=lastwd(getmsg(msg));
          grtype[group]=strcmp(cp,"SERIAL")  == 0 ? GTSERIAL :
                        (strcmp(cp,"X.25")   == 0 ? GTX25 :
                         (strcmp(cp,"MODEM") == 0 ? GTMODEM : GTNONE));
          if (grtype[group] == GTMODEM) {
               if (ynopt(msg+LOCK1-GROUP1)) {
                    grtype[group]=GTMLOCK;
               }
          }
          if (grtype[group] != GTNONE) {
               nterms+=numopt(msg+NUMBR1-GROUP1,1,256);
          }
     }
     if (nterms < 1 || nterms > 256) {
          catastro("ERROR IN LEVEL 2 CONFIGURATION: YOU MUST DEFINE 1 TO 256 CHANNELS -- NOT %d",nterms);
     }
     outbsz=numopt(OUTBSZ,2048,16384);
     sampln=numopt(SAMPLN,0,256);
     exicnc=ynopt(EXICNC);
     mmucrr=numopt(MMUCRR,0,32767);
     shterc=(int *)alcmem(25*sizeof(int));
     shterc+=1;
     setmem(shterc,24*sizeof(int),-1);
     shterc[numopt(MCUHR,-1,23)]=0;
     for (i=1 ; i <= 4 ; i++) {
          shterc[numopt(MSHHR1-1+i,-1,23)]=10+i;
     }
     mcumin=numopt(MCUMIN,0,59);
     mcuwrn=numopt(MCUWRN,0,59);
     maxcat=numopt(MAXCAT,1,32767);
     pfceil=numopt(PFCEIL,0,3);
     emubel=numopt(EMUBEL,0,2000);
     outata=ynopt(OUTATA);
     vispsw=ynopt(VISPSW);
     idlzap=numopt(IDLZAP,0,32767);
     zapser=ynopt(ZAPSER);
     svrate=numopt(SVRATE,0,32767);
     lonaud=ynopt(LONAUD);
     lofaud=ynopt(LOFAUD);
     mmuaud=ynopt(MMUAUD);
     bbsttl=stgopt(BBSTTL);
     company=stgopt(COMPANY);
     addres1=stgopt(ADDRES1);
     addres2=stgopt(ADDRES2);
     city=stgopt(CITY);
     opnam1=stgopt(OPNAM1);
     opnam2=stgopt(OPNAM2);
     opnam3=stgopt(OPNAM3);
     dataph=stgopt(DATAPH);
     liveph=stgopt(LIVEPH);
     chghour=stgopt(CHGHOUR);
     chgmin=stgopt(CHGMIN);
     chgtime=stgopt(CHGTIME);
 
     cp=lastwd(getmsg(ANSIOP));
     ansiop=*(cp+strlen(cp)-1);
     rsetop=chropt(RSETOP);
     digalw=ynopt(DIGALW);
     if (ynopt(ENAEUR)) {
          eurmsk=0xFF;
          for (i=128 ; i < 256 ; i++) {
               btuxlt(i,i);
          }
     }
     belper(emubel);
 
     if ((memreq=btulsz(nterms,INPSIZ,outbsz)) < 0L) {
          catastro("BTULSZ ERROR");
     }
     if ((region=getml(memreq)) == NULL) {
          catastro("MEMORY ERROR DURING STARTUP");
     }
     btuitz(region);
     user=(struct user *)alcmem(nterms*sizeof(struct user));
     rsmodes=(int *)alcmem(nterms*sizeof(int));
     grpnum=(int *)alcmem(nterms*sizeof(int));
     setmem(channel=(int *)alcmem((nterms+3)*2),(nterms+3)*2,-1);
     *channel++=-3;     /* note: channel[-3] == -3 */
     *channel++=-2;     /*       channel[-2] == -2 */
     *channel++=-1;     /*       channel[-1] == -1 */
 
     inirtk();
     iniacc();
 
     setmbk(mjrmb);
     usrnum=0;
     for (group=0,msg=GROUP1 ; group < NGROUPS ; group++,msg+=GROUP2-GROUP1) {
          if ((grt=grtype[group]) != GTNONE) {
               numchn=numopt(msg+NUMBR1-GROUP1,1,256);
               chan=hexopt(msg+START1-GROUP1,0x00,0xFF);
               if (grt == GTX25) {
                    cp=lastwd(getmsg(msg+ECHO1-GROUP1));
                    echtyp[group]=strcmp(cp,"BBS")   == 0 ? ECHBBS :
                                  (strcmp(cp,"PLEX") == 0 ? ECHPLX : ECHNON);
                    strcpy(prfbuf,getmsg(msg+X3PAR1-GROUP1));
                    strcat(prfbuf," ");
                    strcat(prfbuf,getmsg(msg+X3MOR1-GROUP1));
                    strcpy(startv[group]=alcmem(strlen(prfbuf)+1),prfbuf);
                    if (fmtx3(startv[group]) == 0) {
                         catastro("ERROR IN LEVEL 2 CONFIGURATION OPTION \"X3PAR%d\" OR \"X3MOR%d\":\nBAD X.3 PARAMETER(S)",group+1,group+1);
                    }
                    ksec[group]=lngopt(msg+KSEC1-GROUP1,-1000000L,1000000L);
                    kpak[group]=lngopt(msg+KPAK1-GROUP1,-1000000L,1000000L);
                    kchar[group]=lngopt(msg+KCHAR1-GROUP1,-1000000L,1000000L);
                    rc=btusdf(usrnum,numchn,SDFX25,numopt(msg+CARD1-GROUP1,0,7),
                                                   numopt(msg+LINE1-GROUP1,0,1),
                                                   numopt(msg+LCN1-GROUP1,0,255));
                    if (rc == NOTX25) {
                         catastro("ERROR IN LEVEL 2 CONFIGURATION OPTION \"GROUP%d\":  X.25 NOT SUPPORTED",group+1);
                    }
               }
               else {
                    iobase=hexopt(msg+ADDR1-GROUP1,0x0000,0xFFFF);
                    mxbaud[group]=(unsigned)lngopt(msg+BAUD1-GROUP1,300L,38400L);
                    if (mxbaud[group] > maxspd) {
                         btumxs(maxspd=mxbaud[group]);
                    }
                    echtyp[group]=ynopt(msg+DUPLX1-GROUP1);
                    startv[group]=stgopt(msg+INIT1-GROUP1);
                    btudef(usrnum,iobase,numchn);
               }
               for (i=0 ; i < numchn ; i++) {
                    if (usridx(chan) >= 0) {
                         catastro("ERROR IN LEVEL 2 CONFIGURATION NEAR OPTION \"GROUP%d\":  CHANNEL NUMBER %02x OVERLAPS",group+1,chan);
                    }
                    hichp1=max(hichp1,chan+1);
                    channel[usrnum]=chan;
                    grpnum[usrnum]=group;
                    usrnum++;
                    chan++;
               }
          }
     }
     inisho();
     iusers=1;
     inisup();
     inimod();
     iniedt();
     alcvda();
     lasthr=dthour(now());
     rtkick(50,ckmcu);
     for (usrnum=0 ; usrnum < nterms ; usrnum++) {
          rsmodes[usrnum]=NORMRS;
          rstchn();
     }
     if (idlzap) {
          inirel();
          inirch();
     }
     ckrsch();
}
 
int fmtx3(prmstg)               /* Format X.3 PAD-config string into prfbuf */
char *prmstg;                  /* (returns length of X.29 string in prfbuf) */
{                          /* warning: copies to input[] buffer for parsing */
     int i;
     int parm,val;
     char *cp;
 
     strcpy(input,prmstg);
     parsin();
     cp=prfbuf;
     *cp++=2;
     for (i=0 ; i < margc ; i++) {
          if (sscanf(margv[i],"%d:%d",&parm,&val) != 2+CNTLIT) {
               return(0);
          }
          *cp++=parm;
          *cp++=val;
     }
     return(margc*2+1);
}
 
ckrsch()                           /* dis-inhibit sending of modem commands*/
{
     for (usrnum=0,usrptr=user ; usrnum < nterms ; usrnum++,usrptr++) {
          if (usrptr->class == VACANT) {
               if (usrptr->state == AUTANS && !(usrptr->flags&IS2698)) {
                    if (usrptr->countr-- == 0) {
                         btuinj(usrnum,CMDOK);
                    }
               }
          }
     }
     rtkick(1,ckrsch);
}
 
globalcmd(rouptr)                  /* install global command handler       */
int (*rouptr)();
{
     if (nglobs >= GLBMAX) {
          catastro("TOO MANY GLOBAL COMMAND HANDLERS");
     }
     globs[nglobs++]=rouptr;
}
 
xltctls(txtbuf)               /* translate up-arrow seqs to CTRL chars    */
char *txtbuf;
{
     char *cp,c;
 
     for (cp=txtbuf ; *cp != '\0' ; cp++) {
          if (*cp == '^') {
               switch (c=*(cp+1)) {
               case '\0':
                    break;
               case '^':
                    movmem(cp+1,cp,strlen(cp));
                    break;
               default:
                    *cp=(c&~0x40);
                    movmem(cp+2,cp+1,strlen(cp+1));
                    break;
               }
          }
     }
}
 
int usridx(chan)                   /* find "usrnum", given visible chan #  */
int chan;
{
     int idx;
 
     for (idx=0 ; idx < nterms ; idx++) {
          if (channel[idx] == chan) {
               return(idx);
          }
     }
     return(-1);
}
 
inimid(sttnum,sttsel,sttmnu)       /* init. main menu from message files   */
int sttnum,sttsel,sttmnu;
{
     char *stgopt();
     char c;
 
     if ((c=chropt(sttsel)) == '0') {
          c='\0';
     }
     module[sttnum]->select=c;
     module[sttnum]->descrp=stgopt(sttmnu);
}
 
dclvda(size)                       /* module declaration for vdarea        */
int size;
{
     if (size > vdasiz) {
          vdasiz=size;
     }
}
 
alcvda()                           /* allocate volatile data area          */
{
     if (vdasiz != 0) {
          if ((vdarea=getml(nterms*(long)vdasiz)) == NULL
           || (vdatmp=getml((long)vdasiz)) == NULL) {
               catastro("ALCVDA: NOT ENOUGH MEMORY");
          }
#ifdef ECLIPSE
          if ((eclvdabas=ecltile(vdarea,vdasiz)) == 0) {
               catastro("ALCVDA: NOT ENOUGH SELECTORS");
          }
#endif
     }
}
 
char *
vdaoff(unum)                       /* vdaptr calculation routine           */
int unum;
{
#ifdef ECLIPSE
     return((char *)((long)(eclvdabas+(unum<<3))<<16));
#else
     return((char *)(vdarea+(unum*(long)vdasiz)));
#endif
}
 
svacant()                          /* vacant channel status handler        */
{
     setmbk(mjrmb);
     switch (usrptr->state) {
     case JSTRST:
          btulok(usrnum,0);
          if (status == CMN2OK) {
               usrptr->flags|=IS2698;
               btuoes(usrnum,1);
               if (grtype[grpnum[usrnum]] == GTSERIAL) {
                    usrptr->flags|=ISRIAL;
               }
               switch (rsmodes[usrnum]) {
               case NORMRS:
                    if (usrptr->flags&ISRIAL) {
                         prf("%s\r",startv[grpnum[usrnum]]);
                         usrptr->state=ESTVEC;
                    }
                    else {
                         prf("ATZ\r");
                         usrptr->state=EMTATZ;
                    }
                    break;
               case BUSYRS:
                    prf("ATH1\r");
                    usrptr->state=EKLVEC;
                    break;
               case NANSRS:
                    prf("ATS0=0\r");
                    usrptr->state=EKLVEC;
                    break;
               }
               powprf();
          }
          else if (status == CMDOK) {
               switch (rsmodes[usrnum]) {
               case NORMRS:
                    usrptr->state=AWAITC;
                    break;
               case BUSYRS:
                    btucmd(usrnum,"D");
                    usrptr->state=EKLVEC;
                    break;
               case NANSRS:
                    kiletc("NO-ANSWER");
                    break;
               }
          }
          else {
               rstchn();
          }
          break;
     case EMTATZ:
          if (status == OUTMT) {
               btucmd(usrnum,"p");
          }
          else if (status == CRSTG) {
               if (sameas(getin(),"OK") || sameas(margv[0],"0")) {
                    usrptr->state=W4DLAY;
                    shochn(dots);
               }
          }
          else if (status != LOST2C) {
               rstchn();
               shochn("+++++++++");
          }
          break;
     case W4DLAY:
          if (status == CMN2OK) {
               prf("%s\r",startv[grpnum[usrnum]]);
               powprf();
               usrptr->state=ESTVEC;
          }
          else if (status != LOST2C) {
               rstchn();
          }
          break;
     case EKLVEC:
          if (status == OUTMT) {
               btuoes(usrnum,0);
               if (usrptr->flags&ISRIAL) {
                    kiletc("INACTIVE");
               }
               else {
                    btucmd(usrnum,"p");
               }
          }
          else if (status == CRSTG) {
               if (sameas(getin(),"OK")) {
                    kiletc(rsmodes[usrnum] == BUSYRS ? "BUSY-OUT" : "NO-ANSWER");
               }
          }
          else if (status == CMDOK) {
               kiletc("BUSY-OUT");
          }
          else if (status == CMN2OK) {
               kiletc("--RESET--");
          }
          else {
               rstchn();
          }
          break;
     case W4KILL:
          if ((usrptr->flags&ISX25) && status == CRSTG) {
               rstchn();
          }
          break;
     case ESTVEC:
          if (status == OUTMT) {
               btuoes(usrnum,0);
               if (usrptr->flags&ISRIAL) {
                    usrptr->state=AWAITC;
                    shochn(dots);
               }
               else {
                    btucmd(usrnum,"p");
               }
          }
          else if (status == CRSTG) {
               if (sameas(getin(),"OK")) {
                    usrptr->state=AWAITC;
                    shochn(dots);
               }
          }
          else if (status != LOST2C) {
               rstchn();
               shochn("*********");
          }
          break;
     case AWAITC:
          if (status == RING) {
               if (usrptr->flags&ISX25) {       /* (non-hardware X.25 chan) */
                    gtansi();
               }
               else {                                    /* (XECOM channel) */
                    shochn(" ANSWER  ");
                    btucmd(usrnum,"Ap^H");
                    usrptr->state=XERING;
               }
          }
          else if (status == CRSTG) {
               if (sameas(getin(),"RING")) {
                    if (usrptr->flags&ISX25) {            /* (X.25 channel) */
                         btucmd(usrnum,"A");
                         if (startv[grpnum[usrnum]] == '\0') {
                              gtansi();
                         }
                         else {
                              btuinj(usrnum,CYCLE);
                              usrptr->state=WAIT29;
                         }
                    }
                    else {                               /* (HAYES channel) */
                         shochn(" ANSWER  ");
                         usrptr->state=HARING;
                         if (outata) {
                              btucmd(usrnum,"^E=A");
                         }
                    }
               }
               else if (usrptr->flags&ISRIAL) {           /* (UART channel) */
                    gtansi();
               }
          }
          else if (status != LOST2C && status != CMN2OK) {
               rstchn();
          }
          break;
     case WAIT29:
          switch (status) {
          case CM25OK:
               break;
          case CYCLE:
          case CLOX29:
               switch (btux29(usrnum,fmtx3(startv[grpnum[usrnum]]),prfbuf)) {
               case 0:
                    gtansi();
                    break;
               case X25CLO:
                    btuinj(usrnum,CLOX29);
                    break;
               default:
                    btuinj(usrnum,ERRX29);
                    break;
               }
               break;
          default:
               rstchn();
               break;
          }
          break;
     case XERING:
          if (status == CMDOK) {
               if (!(usrptr->flags&NOHDWE)) {
                    usrptr->baud=1200;
               }
               gtansi();
          }
          else if (status == INAPP) {
               usrptr->baud=300;
               gtansi();
          }
          else if (status != CRSTG) {
               rstchn();
          }
          break;
     case HARING:
          if (status == CRSTG) {
               if (*getin() != '\0') {
                    if (bdspec()) {
                         btucmd(usrnum,"p");
                         usrptr->state=HPAUSE;
                    }
                    else {
                         rstchn();
                    }
               }
          }
          else if (status != CMN2OK) {
               rstchn();
          }
          break;
     case HPAUSE:
          if (status == CMN2OK) {
               gtansi();
          }
          else if (status != CRSTG || *getin() != '\0') {
               rstchn();
          }
          break;
     case ASKANS:
          if (status == CM25OK) {
               break;
          }
          if (status == CRSTG) {
               switch (*getin()) {
               case 'y':
               case 'Y':
                    gotcar(ANSON);
                    break;
               case 'n':
               case 'N':
                    gotcar(0);
                    break;
               default:
                    prfmsg(QANSI);
                    powprf();
               }
          }
          else {
               rstchn();
          }
          break;
     case AUTANS:
          if (status == CM25OK) {
               break;
          }
          btuchi(usrnum,NULL);
          if (status == CRSTG) {
               paccin();
               gotcar(ANSON);
          }
          else if (status == CMDOK || status == CMN2OK) {
               gotcar(0);
          }
          else if (status != OUTMT) {
               rstchn();
          }
          break;
     }
}
 
powprf()                           /* "power" outprf() - cut through input  */
{
     btuxct(usrnum,strlen(prfbuf),prfbuf);
     clrprf();
     btucli(usrnum);
}
 
bdspec()                           /* goto baud rate given in input, if any */
{
     int baud;
 
     if (sameas(margv[0],"CONNECT")) {
          if (margc == 1) {
               baud=300;
          }
          else if (sameas(margv[1],"FAST")) {        /* for Telebit */
               baud=mxbaud[grpnum[usrnum]];          /* Trailblazer */
          }
          else {
               baud=atoi(margv[1]);
          }
          usrptr->baud=baud;
          if (grtype[grpnum[usrnum]] == GTMODEM) {
               btubrt(usrnum,baud);
          }
          return(1);
     }
     return(0);
}
 
kiletc(legend)                     /* kill a channel, and poss the system  */
char *legend;
{
     int unum;
     struct user *uptr;
 
     shochn(legend);
     usrptr->state=W4KILL;
     if (errcod != 1 || kilipg) {
          for (unum=0,uptr=user ; unum < nterms ; unum++,uptr++) {
               if (uptr->class != VACANT || uptr->state != W4KILL) {
                    return;
               }
          }
          failsf();
     }
}
 
failsf()                           /* failsafe cleanup and shutdown routine  */
{
     int savusn;
     struct user *savusp;
 
     if (errcod == 0) {
          mcuctr=-1;
          savusn=usrnum;
          savusp=usrptr;
          (*(module00.mcurou))();
          usrnum=savusn;
          usrptr=savusp;
          kilsrc=-2;
     }
     else if (errcod >= 11 && errcod <= 14) {
          kilsrc=-3;
     }
     ticker=0;
     kilipg=1;
     mbdone=1;
}
 
gtansi()                           /* get initial ANSI cond: on/off/ask/auto */
{
     int xrtocr();
     static char *strtst[]={" CARRIER "," CARRIER ","ACTIVITY "," CONTACT "};
 
     shochn(strtst[grtype[grpnum[usrnum]]-1]);
     switch (ansiop) {
     case 'N':
          gotcar(ANSON);
          break;
     case 'F':
          gotcar(0);
          break;
     case 'K':
          prfmsg(QANSI);
          powprf();
          usrptr->state=ASKANS;
          echon();
          break;
     default:
          if (usrptr->flags&NOHDWE) {
               gotcar(atoggl);
          }
          else {
               btuchi(usrnum,xrtocr);
               prfmsg(SANSI);
               powprf();
               if (usrptr->flags&IS2698) {
                    btucmd(usrnum,"p");
               }
               else {
                    usrptr->countr=2;
               }
               usrptr->state=AUTANS;
          }
     }
     btucli(usrnum);
}
 
xrtocr(chan,c)                     /* translate 'R' to <CR> for ANSI test  */
int chan;
char c;
{
     return((c&0x7F) == 'R' ? '\r' : (chan&0)); /* use of chan suppresses    */
}                                               /* spurious compiler warning */
 
gotcar(ansivl)                     /* after carrier presents log in stuff  */
char ansivl;
{
     extern char bturno[];
 
     usaptr->ansifl=ansivl;
     stansi();
     if (usrptr->flags&ISX25) {
          prfmsg(HELLO25,bbsttl,bturno,nctime(now()),ncedat(today()));
     }
     else {
          prfmsg(HELLO,bbsttl,bturno,usrptr->baud,nctime(now()),ncedat(today()));
     }
     if (strlen(sv.lonmsg) != 0) {
          prf("\r%s\r",sv.lonmsg);
     }
     prfmsg(sampok() ? ENTUSID : LOGUID);
     outprf(usrnum);
     usrptr->class=ONLINE;
     usrptr->state=0;
     usrptr->countr=0;
     echon();
     btucli(usrnum);
}
 
sonline()                          /* "online" channel status handler      */
{
     int i;
     char *cp;
 
     setmbk(mjrmb);
     switch (status) {
     case CMDOK:
     case CMN2OK:
     case CM25OK:
          break;
     case CRSTG:
          switch (usrptr->substt) {
          case 0:
               if (*getin() == '\0') {
                    prfmsg(sampok() ? ENTUSID : LOGUID);
                    outprf(usrnum);
               }
               else if (sampok()
                    && (sameas(margv[0],"new")
                     || sameas(margv[0],"\"new\""))) {
                    shochn(" SIGNUP  ");
                    usrptr->class=SUPIPG;
                    sv.ctdtot+=1;
                    signup();
               }
               else if (uinsys(margv[0])) {
                    prfmsg(sampok() ? ALRDON : LOGDON);
                    outprf(usrnum);
               }
               else if (loadup()) {
                    if (usaptr->tckavl <= 0 && !sampok()) {
                         shochn("DEADBEAT ");
                         byenow(MEMONL,liveph,dataph,chghour);
                    }
                    else {
                         shochn("  LOGON  ");
                         prfmsg(ENTPSW);
                         outprf(usrnum);
                         usrptr->usetmr=0;
                         btuech(usrnum,0);
                         usrptr->substt=1;
                         usrptr->countr=0;
                    }
               }
               else if (++(usrptr->countr) < 3) {
                    if (!sampok()) {
                         prfmsg(LOGNOG,dataph);
                    }
                    else {
                         prfmsg(UIDNOG);
                    }
                    outprf(usrnum);
               }
               else {
                    byenow(STRUKO);
               }
               break;
          case 1:
               inplen=btuinp(usrnum,input);
               if (sameas(input,usaptr->psword)) {
                    strcpy(input,"<password>");
                    shomal();
                    shochn(usaptr->userid);
                    echon();
                    sv.ctdtot+=1;
                    if (!imbump(1)) {
                         if (usaptr->tckavl > 0) {
                              usrptr->class=PAYING;
                              sv.ctdpai+=1;
                         }
                         else {
                              usrptr->usetmr=0;
                              usrptr->class=FRELOA;
                         }
                         prfmsg(HITHAR,cp=usaptr->userid);
                         if (sameas(cp,"Sysop")
                          || sameas(cp,opnam1)
                          || sameas(cp,opnam2)
                          || sameas(cp,opnam3)) {
                              for (i=0 ; i < nterms ; i++) {
                                   if (user[i].flags&ISYSOP) {
                                        break;
                                   }
                              }
                              if (i == nterms) {
                                   usrptr->flags|=ISYSOP;
                              }
                              else {
                                   prfmsg(URNOTS);
                              }
                         }
                         outprf(usrnum);
                         lonstf();
                         usrptr->substt=-1;
                         (*(module00.sttrou))();
                    }
               }
               else {
                    strcpy(input,"<invalid password>");
                    shomal();
                    if (++(usrptr->countr) < 3) {
                         prfmsg(PSWNOG);
                         outprf(usrnum);
                    }
                    else {
                         byenow(STRUKO);
                         shocst(1,"Hack Attempt on \"%s\"",usaptr->userid);
                    }
               }
               break;
          }
          break;
     default:
          rstchn();
     }
}
 
ssupipg()                          /* sign-up is in progress               */
{
     switch (status) {
     case CRSTG:
          getin();
          if (!signup()) {
               shochn(usaptr->userid);
               lonstf();
               usrptr->substt=-1;
               (*(module00.sttrou))();
          }
          break;
     case 251:
          break;
     default:
          rstchn();
     }
}
 
susing()                           /* "using" channel status handler       */
{
     if (setjmp(eximod)) {
          usrptr->substt=0;
          (*(module00.sttrou))();
     }
     else {
          switch (status) {
          case RING:
          case LOST2C:
          case LOST25:
               (*(module00.huprou))();
               break;
          case CRSTG:
               if (usrptr->flags&INJOIP) {
                    btuoes(usrnum,0);
                    usrptr->flags&=~INJOIP;
               }
               getin();
               if (!(usrptr->flags&OPCHAT)) {
                    hdlinp();
               }
               break;
          case OUTMT:
               if (usrptr->flags&INJOIP) {
                    btuoes(usrnum,0);
                    injacr();
                    break;
               }
          default:
               (*(module[usrptr->state]->stsrou))();
          }
     }
}
 
condex()                           /* conditional module-exit              */
{
     if (usrptr->flags&CONCEX) {
          longjmp(eximod,1);
     }
}
 
injacr()                           /* inject a <CR> to current channel     */
{                                  /*    (re-prompt current text)          */
     usrptr->flags|=INJOIP;
     status=CRSTG;
     clrinp();
     hdlinp();
     usrptr->flags&=~INJOIP;
}
 
clrinp()                           /* clear user-input buffer and qtys     */
{
     input[0]='\0';
     inplen=0;
     margc=0;
}
 
inirel()                           /* real-time check for idle channels    */
{
     setmbk(mjrmb);
     for (usrnum=0,usrptr=user ; usrnum < nterms ; usrnum++,usrptr++) {
          if (!(usrptr->flags&NOHDWE)) {
               switch (usrptr->class) {
               case VACANT:
                    if (usrptr->state != W4KILL) {
                         rstchn();
                    }
                    break;
               default:
                    if (!(usrptr->flags&(ACTIVE+ISYSOP))
                      && isuidc(usracc[usrnum].userid[0])
                      && !((usrptr->flags&ISRIAL) && !zapser)) {
                         prfmsg(NOTACV,idlzap/60);
                         outprf(usrnum);
                         btucli(usrnum);
                         usrptr->nazapc=4;
                    }
                    usrptr->flags&=~ACTIVE;
                    break;
               }
          }
     }
     rtkick(idlzap,inirel);
}
 
inirch()                           /* real-time check for idle log-offs    */
{
     setmbk(mjrmb);
     for (usrnum=0,usrptr=user ; usrnum < nterms ; usrnum++,usrptr++) {
          if (usrptr->nazapc > 0 && --(usrptr->nazapc) == 0) {
               byenow(NAZAPM);
          }
     }
     rtkick(15,inirch);
}
 
sampok()                           /* is this line a free sample one?      */
{
     return(usrnum < sampln || (usrptr->flags&NOHDWE));
}
 
hdlinp()                           /* handle CR-terminated input           */
{
     int i;
 
     numcat=0;
     if (!(usrptr->flags&NOGLOB)) {
          for (i=0 ; i < nglobs ; i++) {
               if ((*globs[i])()) {
                    injacr();
                    return;
               }
          }
     }
     if (!(*(module[usrptr->state]->sttrou))()) {
          usrptr->substt=0;
          (*(module00.sttrou))();
     }
}
 
onsys(uid)                         /* is a given userid on the system?     */
char *uid;
{
     othuap=usracc;
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (othusp->class > SUPIPG && sameas(uid,othuap->userid)) {
               return(1);
          }
          othuap+=1;
     }
     return(0);
}
 
uinsys(uid)         /* is a userid ANYWHERE on system? (even logging in)   */
char *uid;
{
     for (uisusn=0 ; uisusn < nterms ; uisusn++) {
          if (uisusn != usrnum && sameas(uid,usracc[uisusn].userid)) {
               return(1);
          }
     }
     return(0);
}
 
instat(uid,qstate)                 /* is userid in a given state?          */
char *uid;
int qstate;
{
     othuap=usracc;
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (othusp->state == qstate && sameas(uid,othuap->userid)) {
               return(1);
          }
          othuap+=1;
     }
     return(0);
}
 
char *
catfix1()                          /* MajorBBS catfix1() for catamsg()     */
{
     static char ufbuff[30]={""};
 
     if (usracc != NULL && usaptr != NULL) {
          sprintf(ufbuff,"CH%02X=%s:%d/%d",
                  channel[usrnum],usaptr->userid,usrptr->state,usrptr->substt);
     }
     return(ufbuff);
}
 
sameto(shorts,longs)               /* compare short string to long string  */
char *shorts,*longs;
{
     while (*shorts != '\0') {
          if (tolower(*shorts) != tolower(*longs)) {
               return(0);
          }
          shorts+=1;
          longs+=1;
     }
     return(1);
}
 
stzcpy(dst,src,num)               /* copy a string with limit and zero fill */
char *dst,*src;
int num;
{
     int i;
 
     for (i=0 ; i < num-1 && *src != '\0' ; i++) {
          *dst++=*src++;
     }
     for ( ; i < num ; i++) {
          *dst++='\0';
     }
}
 
uprcse(stg)                   /* turn stg into upper-case                  */
char *stg;
{
     while ((*stg=toupper(*stg)) != '\0') {
          stg+=1;
     }
}
 
char *
spr(ctlstg,parm1,parm2,parm3)           /* MajorBBS flavor of sprintf()    */
char *ctlstg,*parm1,*parm2,*parm3;
{
     static char result[4][40];
     static int cycle=0;
 
     cycle=((cycle+1)&3);
     sprintf(result[cycle],ctlstg,parm1,parm2,parm3);
     return(result[cycle]);
}
 
char *
ltoa(longin)                            /* MajorBBS flavor of ltoa()       */
long longin;
{
     static char tkastg[4][12];
     static int cycle=0;
 
     cycle=((cycle+1)&3);
     sprintf(tkastg[cycle],"%ld",longin);
     return(tkastg[cycle]);
}
 
inimod()                           /* initialize the MajorBBS modules      */
{
     int i,(*rouptr)();
     extern int btux25,btusrs;
 
     for (i=1 ; i < NMODS ; i++) {
          if ((rouptr=module[i]->inirou) != NULL) {
               (*rouptr)();
          }
     }
     if (btux25) {
          strcat(subvers,"/X25");
     }
     strcat(subvers,spr("-%d",btusrs));
}
 
prepff()                           /* prepare vacant chans for further stuff */
{
     for (usrnum=0,usrptr=user ; usrnum < nterms ; usrnum++,usrptr++) {
          rsmodes[usrnum]=rsmode;
          if (usrptr->class == VACANT
            && (rsmode == NORMRS || usrptr->state != W4KILL)) {
               rstchn();
          }
     }
}
 
ckmcu()                            /* check for time for midnight cleanup  */
{
     int hr;
 
     if ((hr=dthour(now())) != lasthr) {
          lasthr=hr;
          if (shterc[hr] >= 0) {
               mcuctr=0;
               errcod=shterc[dthour(now())];
               rsmode=rsetop;
               prepff();
          }
     }
     if (mcuctr >= 0 && mcuctr <= mcumin) {
          if (mcuctr == mcumin) {
               hupall();
          }
          else if (mcuctr >= mcumin-mcuwrn) {
               kalert(errcod == 0 ? GOINGD2 : GOINGM,mcumin-mcuctr);
          }
          mcuctr+=1;
     }
     rtkick(60,ckmcu);
}
 
kalert(msgnum,nmins)               /* system shutdown alert                */
int msgnum,nmins;
{
     setmbk(mjrmb);
     prfmsg(msgnum,nmins,(nmins == 1 ? "" : "s"));
     for (othusn=0 ; othusn < nterms ; othusn++) {
          if (user[othusn].class > SUPIPG) {
               injoth();
          }
     }
     clrprf();
}
 
midnit()                           /* MajorBBS midnight cleanup function   */
{
     int i,(*rouptr)();
 
     if (accmcu()) {
          for (i=1 ; i < NMODS ; i++) {
               if ((rouptr=module[i]->mcurou) != NULL) {
                    (*rouptr)();
               }
          }
     }
}
 
char *
getin()                            /* get input, parse, return first arg   */
{
     paccin();
     parsin();
     return(margv[0]) ;
}
 
parsin()                           /* parse input into margv[], etc.       */
{
     char *inpptr;
 
     margc=0;
     inplen=0;
     inpptr=input-1;
     while (1) {
          while (*++inpptr == ' ') {
          }
          if (*inpptr == '\0') {
               break;
          }
          margv[margc]=inpptr;
          while (*++inpptr != ' ') {
               if (*inpptr == '\0') {
                    margn[margc++]=inpptr;
                    inplen=(int)(inpptr-input);
                    return;
               }
          }
          *inpptr='\0';
          margn[margc++]=inpptr;
     }
     if (margc != 0) {
          inplen=(int)(margn[margc-1]-input);
          setmem(margn[margc-1],sizeof(input)-inplen,0);
     }
     else {
          margv[0]="";
     }
}
 
paccin()                 /* show input on modem monitor, check profanity   */
{
     inplen=btuinp(usrnum,input);
     shomal();
     if (usrptr->flags&(ISYSOP+NOHDWE)) {
          pfnlvl=0;
     }
     else {
          if ((pfnlvl=profan(input)) > pfceil) {
               pfnlvl=pfceil;
          }
          if (pfnlvl > 1) {
               usrptr->pfnacc+=pfnlvl;
          }
     }
}
 
rstrin()                      /* restore parsed input to a single string   */
{
     int i;
 
     for (i=0 ; i < margc-1 ; i++) {
          *margn[i]=' ';
     }
}
 
chkdft(c)                     /* check for default (<CR>) input            */
char c;
{
     if (margc == 0) {
          if (c != '\0') {
               input[0]=c;
               input[1]='\0';
               margn[0]=input+1;
               margc=1;
          }
          margv[0]=input;
          inplen=strlen(input);
     }
}
 
byenow(msgnum,p1,p2,p3)            /* log-off a user w/ message utility    */
int msgnum;
long p1,p2,p3;
{
     btulok(usrnum,1);
     btucli(usrnum);
     btuclo(usrnum);
     btuoes(usrnum,1);
     prfmsg(msgnum,p1,p2,p3);
     outprf(usrnum);
     prf("");
     user[usrnum].flags|=BYEBYE;
}
 
long
lincst(unum)                /* find cost of using X.25 line for 15 seconds */
int unum;                               /* for this user                   */
{
     int grp;
     long btuset(),deltap,deltab,rc;
 
     if (user[unum].flags&ISX25) {
          grp=grpnum[unum];
          rc=(ksec[grp]>>2)+((user[unum].minut4&3)<(ksec[grp]&3));
          deltab=btuset(unum,CNTCHR,0L);
          deltap=btuset(unum,CNTPAK,0L);
          rc+=(deltab*kchar[grp]+500)/1000+
              (deltap*kpak[grp]+500)/1000;
          deltab+=sv2.x25bs;
          sv2.x25mbs+=deltab/1000000L;
          sv2.x25bs  =deltab%1000000L;
          deltap+=sv2.x25ps;
          sv2.x25kps+=deltap/1000L;
          sv2.x25ps  =deltap%1000L;
          return(rc);
     }
     return(0L);
}
 
rstchn()                           /* completely reset a modem channel     */
{
     usrptr=&user[usrnum];
     setmem(usrptr,sizeof(struct user),0);
     setmem(&usracc[usrnum],sizeof(struct usracc),0);
     usrptr->baud=mxbaud[grpnum[usrnum]];
     lincst(usrnum);
     switch (bturst(usrnum)) {
     case 2:
          rstx25(dots);
          break;
     case 1:
          btubrt(usrnum,usrptr->baud);
          btuhwh(usrnum,outbsz-20);
     case 0:
          shochn(dots);
          break;
     default:
          usrptr->flags|=NOHDWE;
          if (grtype[grpnum[usrnum]] == GTX25) {
               rstx25("---------");
          }
          else {
               usrptr->baud=maxspd;
               shochn("---------");
          }
     }
     btuscr(usrnum,'\n');
     btutru(usrnum,'O'&0x1F);
     btumil(usrnum,DFTIMX);
     rseman();
     btuech(usrnum,0);
     if (!(usrptr->flags&ISX25)) {
          btulok(usrnum,1);
          btucmd(usrnum,"^E=");
     }
     btucli(usrnum);
}
 
rstx25(dspstg)                     /* reset-related x.25 activity          */
char *dspstg;
{
     usrptr->flags|=ISX25;
     usrptr->baud=38400;
     if (rsmodes[usrnum]) {
          kiletc("  CLEAR  ");
     }
     else {
          shochn(dspstg);
          usrptr->state=AWAITC;
     }
}
 
rstrxf()                           /* restore screen-length to usracc setting */
{
     btuxnf(usrnum,0,-19,usaptr->scnlen-CTNUOS,"   << hit any key >>");
}
 
stansi()                           /* set ANSI handling to usracc setting  */
{
     btucmd(usrnum,(usaptr->ansifl&ANSON) ? "[" : "]");
}
 
echon()                                                     /* turn echo on */
{
     echonu(usrnum);
}
 
echonu(usrnum)                                      /* turn echo on utility */
int usrnum;
{
     btuech(usrnum,echtyp[grpnum[usrnum]]);
}
 
injoth()                           /* inject a message into othusn's chan. */
{
     if (user[othusn].flags&NOINJO) {
          clrprf();
          return(0);
     }
     outprf(othusn);
     btuoes(othusn,1);
     user[othusn].flags|=INJOIP;
     return(1);
}
 
lonstf()                           /* supplemental log-on stuff            */
{
     int i,(*rouptr)();
 
     for (i=1 ; i < NMODS ; i++) {
          if ((rouptr=module[i]->lonrou) != NULL) {
               usrptr->state=i;
               (*rouptr)();
          }
     }
     usrptr->state=0;
     if (lonaud) {
          if (usrptr->flags&ISX25) {
               shocst(1,"%s LOGON X.25",usaptr->userid);
          }
          else {
               shocst(1,"%s LOGON @%ubps",usaptr->userid,usrptr->baud);
          }
     }
}
 
mainu()                            /* main menu command handler            */
{
     int i,c,newstt;
 
     setmbk(mjrmb);
     btumil(usrnum,DFTIMX);
     newstt=1;
     usrptr->crdrat=mmucrr;
     usrptr->flags&=~NOZAP;
     switch (usrptr->substt) {
     case -1:
          mbmenu();
          break;
     case 0:
          shrtmu();
          break;
     case 1:
          if (margc == 0) {
               if (usrptr->flags&INJOIP) {
                    shrtmu();
               }
               else {
                    prfmsg(HLPMSG,bbsttl);
                    mbmenu();
               }
          }
          else if (sameas(margv[0],"account") && account(1)) {
               newstt=2;
          }
          else if ((c=margv[0][0]) == '?') {
               prfmsg(HLPMSG,bbsttl);
               mbmenu();
          }
          else {
               for (i=1 ; i < NMODS ; i++) {
                    if (tolower(c) == tolower(module[i]->select)) {
                         usrptr->state=i;
                         usrptr->substt=0;
                         usrptr->flags|=X2MAIN;
                         if (exicnc && (margc > 1 || strlen(margv[0]) > 1)) {
                              usrptr->flags|=CONCEX;
                         }
                         else {
                              usrptr->flags&=~CONCEX;
                         }
                         if (mmuaud) {
                              shocst(1,"%s MAIN MENU SELECT '%c'",
                                     usaptr->userid,toupper(c));
                         }
                         setmem(vdaptr,vdasiz,0);
                         return((*(module[i]->sttrou))());
                    }
               }
               prfmsg(NOTINL,c);
               shrtmu();
          }
          break;
     case 2:
          if (account(0)) {
               newstt=2;
          }
          else {
               shrtmu();
          }
          break;
     }
     outprf(usrnum);
     usrptr->state=0;
     usrptr->substt=newstt;
     return(1);
}
 
shrtmu()                           /* generate and display short menu      */
{
     int i,c;
 
     prf("\rPlease select a letter (");
 
     for (i=1 ; i < NMODS ; i++) {
          if ((c=module[i]->select) != '\0') {
               prf("%c,",c);
          }
     }
     prf(" or ? for menu): ");
}
 
mbmenu()                           /* generate and display main menu       */
{
     int i,c;
 
     prfmsg(SVCAVL);
     for (i=1 ; i < NMODS ; i++) {
          if ((c=module[i]->select) != '\0') {
               prf("   %c ... %s\r",c,module[i]->descrp);
          }
     }
     prfmsg(PLSSEL);
}
 
isuidc(c)                               /* char is a valid user-id char?   */
int c;
{
     return(digalw ? isalnum(c) : isalpha(c));
}
 
usrson()                                /* display-users-online utility    */
{
     othusp=user;
     othuap=usracc;
     prf("\rLINE ... USER-ID ...... OPTION SELECTED\r");
     for (othusn=0 ; othusn < nterms ; othusn++) {
          switch (othusp->class) {
          case VACANT:
               break;
          case ONLINE:
               prf(" %02x  ... (log-on)\r",channel[othusn]);
               outprf(usrnum);
               break;
          case SUPIPG:
               prf(" %02x  ... (sign-up)\r",channel[othusn]);
               outprf(usrnum);
               break;
          default:
               prf(" %02x  ... %-11s... %s\r",channel[othusn],othuap->userid,
                   module[othusp->state]->descrp);
               outprf(usrnum);
               break;
          }
          othusp+=1;
          othuap+=1;
     }
     prf("");
}
 
dfsthn()                                /* default status handler          */
{
     switch (status) {
     case CMDOK:
     case INBLK:
     case OUTMT:
     case CMN2OK:
     case CM25OK:
     case CYCLE:
     case 251:
     case 252:
     case 253:
          break;
     default:
          loscar();
     }
}
 
loscar()                           /* lost carrier "hang up" routine       */
{
     int i,(*rouptr)(),svflgs,svbaud;
 
     if (isuidc(usaptr->userid[0])) {
          for (i=1 ; i < NMODS ; i++) {
               if ((rouptr=module[i]->huprou) != NULL) {
                    (*rouptr)();
               }
          }
          zapacn();
          strcpy(usaptr->usedat,ncdate(today()));
          updacc();
          if (lofaud) {
               shocst(1,"%s LOGOFF",usaptr->userid);
          }
          if (status == RELOG) {
               svflgs=(usrptr->flags&(NOHDWE+ACTIVE+IS2698+ISRIAL+ISX25));
               svbaud=usrptr->baud;
               setmem(usrptr,sizeof(struct user),0);
               setmem(usaptr,sizeof(struct usracc),0);
               usrptr->flags=svflgs;
               usrptr->baud=svbaud;
               setmbk(mjrmb);
               gtansi();
          }
          else {
               rstchn();
          }
     }
     else {
          (*(module[usrptr->state]->stsrou))();
     }
}
 
hupall()                           /* hang-up on all users                 */
{
     int failsf();
 
     for (usrnum=0 ; usrnum < nterms ; usrnum++) {
          usrptr=&user[usrnum];
          usaptr=&usracc[usrnum];
          vdaptr=vdaoff(usrnum);
          rsmodes[usrnum]=rsetop;
          if (usrptr->class > SUPIPG) {
               status=RING;
               (*(module00.huprou))();
          }
          else if (usrptr->class != VACANT || usrptr->state != W4KILL) {
               rstchn();
          }
     }
     rtkick(20,failsf);
}
 
mjrfin()                           /* finish up stuff; shutdown system     */
{
     int i,(*rouptr)();
 
     if (iusers) {
          hupall();
          for (i=1 ; i < NMODS ; i++) {
               if ((rouptr=module[i]->finrou) != NULL) {
                    (*rouptr)();
               }
          }
     }
     clsedt();
     btuend();
     free(region);
     clsmsg(mjrmb);
     finsup();
     clsacc();
     finsho();
     free(vdarea);
     exit(errcod);
}
 
