/***************************************************************************
 *                                                                         *
 *   GENUTL.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This file contains miscellaneous utility functions.                   *
 *                                                                         *
 *                                            - T. Stryker 6/10/86         *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "setjmp.h"
#include "dosface.h"
#include "portable.h"
 
jmp_buf disaster;             /* master error-recovery longjmp save block  */
static int catact=0;          /* catastrophe count, for ripple-effect stop */
 
char *alcmem(size)                 /* allocate dynamic memory              */
unsigned size;
{
     char *retval;
 
     if ((retval=malloc(size)) == NULL) {
#ifdef ECLIPSE
          catamsg("OUT OF MEMORY OR SELECTORS");
#else
          catamsg("FREE MEMORY POOL EXHAUSTED");
#endif
          longjmp(ADDR_OFdisaster,2);
     }
     return(retval);
}
 
catamsg(string,parm1,parm2)         /* catastro. msg w/ catfix1(),catafix2()*/
char *string;
long parm1,parm2;
{
     FILE *fp;
     char *catfix1(),*cp1,*catfix2(),*cp2;
 
     setwin(0L,0,0,79,24,1);
     locate(0,18+catact*3);
     setatr(0x8D);
     printf("*** %s %s ",ncedat(today()),nctime(now()));
     printf(string,parm1,parm2);
     printf(" ***\n");
     if ((fp=fopen("CATASTRO.TXT",FOPAA)) == NULL) {
          printf("\n(Can't open CATASTRO.TXT)\n");
          exit(4);
     }
     fprintf(fp,"*** %s %s ",ncedat(today()),nctime(now()));
     fprintf(fp,string,parm1,parm2);
     fprintf(fp," ***\n");
     fclose(fp);
     if (catact == 0) {
          cp1=catfix1();
          cp2=catfix2();
          if (*cp1 != '\0' || *cp2 != '\0') {
               printf("<<< %s,%s >>>\7\n",cp1,cp2);
          }
          if ((fp=fopen("CATASTRO.TXT",FOPAA)) == NULL) {
               printf("\n(Can't re-open CATASTRO.TXT)\n");
               exit(4);
          }
          if (*cp1 != '\0' || *cp2 != '\0') {
               fprintf(fp,"<<< %s,%s >>>\n",cp1,cp2);
          }
          fclose(fp);
     }
}
 
catastro(string,parm1,parm2)       /* catastrophe message display utility  */
char *string;
long parm1,parm2;
{
     catamsg(string,parm1,parm2);
     if (++catact > 1) {
          printf("\nYOU SHOULD REBOOT YOUR COMPUTER\n");
          locate(0,23);
          exit(4);
     }
     longjmp(ADDR_OFdisaster,3);
}
