/***************************************************************************
 *                                                                         *
 *   FEEDBACK.C                                                            *
 *                                                                         *
 *   Copyright (C) 1989 GALACTICOMM, Inc.      All Rights Reserved.        *
 *                                                                         *
 *   Feedback to Sysop (sample module discussed in the                     *
 *                      Programmer's Guide to The Major BBS)               *
 *                                                                         *
 *                                            - RNStein, January 1989      *
 *                                                                         *
 ***************************************************************************/

#include "stdio.h"
#include "ctype.h"
#include "feedback.h"
#include "majorbbs.h"
#include "usracc.h"
#include "dosface.h"
#include "portable.h"

int inifbk(),feedbk(),dfsthn();

#define FBKSTT      15        /* feedback to Sysop state              */
struct module module15={      /* module interface block               */
     '*',                     /*    main menu select character (config'able) */
     "",                      /*    description for main menu  (config'able) */
     inifbk,                  /*    system initialization routine     */
     NULL,                    /*    user logon supplemental routine   */
     feedbk,                  /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     NULL,                    /*    finish-up (sys shutdown) routine  */
};

static
FILE *fbkmb,                  /* feedback configuration variables          */
     *fbkfp;                  /* feedback text file                        */

#define TPCSIZ 40             /* maximum characters in topic               */
#define FBKSIZ 1921           /* maximum characters in user's feedback     */

struct fbkusr {                    /* feedback to sysop user data block    */
     int edting;                   /*   using editor flag                  */
     char text[FBKSIZ];            /*   text buffer                        */
     char topic[TPCSIZ];           /*   topic buffer                       */
};

#define fbkptr ((struct fbkusr *)vdaptr)

int nlvfbk;                   /* allow non-live users to make feedback?    */

inifbk()                      /* initialize feedback stuff                 */
{
     fbkmb=opnmsg("feedback.mcv");
     nlvfbk=ynopt(NLVFBK);
     inimid(FBKSTT,FBKSEL,FBKMNU);
     dclvda(sizeof(struct fbkusr));
}

feedbk()                      /* feedback handler                          */
{
     char *cp;

     setmbk(fbkmb);
     if (margc == 1 && sameas(margv[0],"x")) {
          prfmsg(GOODBY);
          return(0);
     }
     do {
          bgncnc();
          switch(usrptr->substt) {
          case 0:
               cncchr();
               prfmsg(HELLO);
               if (!nlvfbk && usrptr->class < PAYING) {
                    prfmsg(REJECT);
                    prfmsg(GOODBY);
                    return(0);
               }
               usrptr->substt=1;
               outprf(usrnum);
               bgnedt(1,FBKSIZ,fbkptr->text,TPCSIZ,fbkptr->topic);
               break;
          case 1:
               if (dunedt()) {
                    for (cp=fbkptr->text ; *cp != '\0' ; cp++) {
                         if (*cp == '\r') *cp='\n';
                    }
                    if ((fbkfp=fopen("FEEDBACK.TXT",FOPAA)) == NULL) {
                         catastro("Cannot open FEEDBACK.TXT for append!");
                    }
                    fprintf(fbkfp,"*** From %s on %s at %-5.5s   %s\n%s\n\n\n",
                        usaptr->userid,ncdate(today()),nctime(now()),
                        fbkptr->topic,fbkptr->text);
                    fclose(fbkfp);
                    prfmsg(THANKS,usaptr->userid);
                    prfmsg(GOODBY);
                    return(0);
               }
               break;
          }
     } while (!endcnc());
     outprf(usrnum);
     return(1);
}
