/***************************************************************************
 *                                                                         *
 *   ESGUTL.C                                                              *
 *                                                                         *
 *   Copyright (C) 1988-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   E-Mail and SIG utilities and common-code segments.                    *
 *                                                                         *
 *                                  - T. Stryker 7/28/88                   *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "btvstf.h"
#include "esigs.h"
#include "message.h"
#include "dosface.h"
#include "portable.h"
 
FILE *esgmb;                  /* esigs named-message file block ptr        */
BTVFILE *esgbb;               /* vesigs btrieve message file block ptr     */
BTVFILE *qscbb;               /* esigs quickscan/config btrieve file ptr   */
struct compos compos;         /* concrete allocation of composite struct   */
long filen;                   /* length of attachment found, from opnatt() */
int esgstt;                   /* current/new usrptr->substt hold register  */
int msgbyts;                  /* maximum number of bytes in message texts  */
int esgvda=0;                 /* max number of bytes required by email/sigs*/
struct sigdat *sigdat,        /* ram-resident SIG data tables base address */
              *sdtptr;        /* scratch ptr for scanning thru sigdat      */
char huge    *qsarea;         /* base ptr to dynam alloc'd quickscan area  */
struct qscfg *sopqsc,         /* singular SYSOP/SIG-Op scratch area        */
             *qscptr;         /* ptr to current user's qsarea entry        */
struct usracc *sopusa;        /* singular SYSOP/SIG-Op scratch acct        */
 
char dftnlv[MAXSIG/2],       /* default non-live SIG access bits     */
     dftliv[MAXSIG/2],       /* default live SIG access bits         */
     maxnlv[MAXSIG/2];       /* maximum non-live SIG access bits     */
 
char *accstg[]={"Zero","","Read","","Download","","Write","",
                "Upload","","Co-Op","","SIG-Op","","SYSOP","<unassigned>"};
 
#define MEMENU REPRMT
#define MSMENU (readac() >= OPAXES ? ORSPRMT : RSPRMT)
#define MMENU  either(MEMENU,MSMENU)
#define HUH    either(EMLHUH,SIGHUH)
 
iniesg()                      /* initialize email and sigs                 */
{
     if (esgmb == NULL) {
          esgmb=opnmsg("esigs.mcv");
          msgbyts=(outbsz <= 2048 ? outbsz-128 : outbsz-384);
          dclvda(esgvda=sizeof(struct esgusr)+msgbyts);
          qscbb=opnbtv("bqscfg.dat",sizeof(struct qscfg));
          esgbb=opnbtv("vesigs.dat",sizeof(struct message)+msgbyts);
          iniprot();
          emrtcy();
          inieml();
          inisig();
     }
}
 
fireup()                      /* fire up status 3 input handling           */
{
     setmbk(esgmb);
     setbtv(esgbb);
     esgstt=usrptr->substt;
     qscptr=qscoff(usrnum);
     libpsp();
 
     if (usrptr->flags&INJOIP) {
          prompt(esgstt);
     }
     else if (esgstt == UPASC) {
          usrptr->pfnacc=0;
          return(1);
     }
     else if (usrptr->pfnacc > MAXPFN) {
          byenow(MUCH2P);
     }
     else if (usrptr->pfnacc > WRNPFN && pfnlvl > 0) {
          errmsg(RAUNCH);
     }
     else if (pfnlvl > 2) {
          errmsg(PFNMSG);
     }
     else {
          chkdft(esgptr->dftinp);
          return(1);
     }
     return(0);
}
 
hdlesg()                      /* handle common email/sigs substates        */
{
     switch (esgstt) {
     case SCOSIG:
     case SCDSIG:
          sscosig();
          break;
     case GONUM:
          sgonum();
          break;
     case REPSIG:
     case REPOP:
          srepsig();
          break;
     case REPOPX:
     case REPOPU:
     case REPOPA:
          srepopx();
          break;
     case OPFWD:
          sopfwd();
          break;
     case THRFBP:
          sthrfbp();
          break;
     case DNLNOW:
     case DWNAGN:
          sdnldq();
          break;
     case EDITING:
          sediting();
          break;
     case ATTFIQ:
     case UPLAGN:
          sattfiq();
          break;
     default:
          if (!protih()) {
               catastro("E/SIGS STATE ERROR (esgstt=%d)",esgstt);
          }
     }
}
 
char
*tpcfnm()        /* extract file name from topic, if any (else return NULL) */
{
     static char fname[8+1+3+1];
     char *sp,*cp;
     int i;
 
     sp=cp=esgptr->msg.topic;
     for (i=0 ; *cp != '\0' && *cp != '.' && !isspace(*cp) ; cp++,i++) {
     }
     if (i < 1 || i > 8 || *cp != '.') {
          return(NULL);
     }
     cp++;
     for (i=0 ; *cp != '\0' && *cp != '.' && !isspace(*cp) ; cp++,i++) {
     }
     if (i < 1 || i > 3 || *cp == '.') {
          return(NULL);
     }
     stzcpy(fname,sp,cp-sp+1);
     return(fname);
}
 
dnload(whndun)                /* download attachment, invoke arg when done */
int (*whndun)();
{
     char *fnm;
 
     if (attfs() != NULL && filen >= 0) {
          if ((fnm=tpcfnm()) != NULL) {
               prfmsg(ATTMNT2,fnm,ltoa(filen));
          }
          else if (esgptr->msg.flags&INDRCT) {
               prfmsg(ATTMNT2,attfsn(),ltoa(filen));
          }
          else {
               prfmsg(ATTMNT,ltoa(filen));
          }
          prompt(DNLNOW);
          esgptr->whndun=whndun;
     }
     else {
          prfmsg(ATTNF,ltoa(esgptr->msg.msgno));
          cncall();
          (*whndun)();
     }
}
 
sdnldq()                      /* state: do you want to download file now?  */
{
     switch (cncyesno()) {
     case 'Y':
          prompt(ASCORX);
          break;
     case 'N':
          (*esgptr->whndun)();
          break;
     default:
          errmsg(YORN);
     }
}
 
dnloff()                      /* turn downloading process off              */
{
     btuoes(usrnum,0);
     btutru(usrnum,'O'&0x1F);
     if (esgptr->fxftyp) {
          esgptr->fxftyp=0;
          btuoes(usrnum,0);
          btutrg(usrnum,0);
          echon();
          btucli(usrnum);
          usrptr->flags&=~(NOINJO+NOZAP);
          if (esgptr->sflags&NOPGBK) {
               esgptr->sflags&=~NOPGBK;
               rstrxf();
          }
          udfilex();
     }
}
 
emrtcy()                      /* once-a-second real-time cycler            */
{
     int emrtcy();
 
     protcy();
     rtkick(1,emrtcy);
}
 
emsthn()                      /* email/sigs status handler                 */
{
     setmbk(esgmb);
     setbtv(esgbb);
     qscptr=qscoff(usrnum);
     libpsp();
     esgstt=usrptr->substt;
     cncall();
     if (status == OUTMT) {
          btuoes(usrnum,0);
          btutru(usrnum,'O'&0x1F);
     }
     if (protsh()) {
     }
     else if (status == CYCLE) {
          cycmed();
     }
     else {
          dfsthn();
     }
     usrptr->substt=esgstt;
}
 
possat(rouptr)                /* possibly begin attachment proceedings     */
int (*rouptr)();
{
     int sn;
 
     if ((sn=findsig(esgptr->msg.to)) == NOSIG || rdautl(sn) >= ULAXES) {
          prompt(ATTFIQ);
          esgptr->whndun=rouptr;
     }
     else {
          (*rouptr)();
     }
}
 
sattfiq()                     /* state: attach file to this msg?           */
{
     switch (cncyesno()) {
     case 'Y':
          if (either(credok(nlveat,eattck),credsf(esgptr->sattck))) {
               prompt(UPMODE);
          }
          break;
     case 'N':
          if (esgstt != ATTFIQ) {
               prfmsg(NUPLD);
          }
          (*esgptr->whndun)();
          break;
     default:
          errmsg(YORN);
     }
}
 
ssopfsp()                     /* state: SYSOP file spec entry (opt 5)      */
{
     FILE *fp;
 
     setmem(prfbuf,FSPSIZ,0);
     strcpy(prfbuf,cncall());
     if ((fp=fopen(prfbuf,FOPRA)) == NULL) {
          esgstt=UPLAGN;
          errmsg(SFSNXS);
     }
     else {
          fclose(fp);
          if ((fp=fopen(attfsd(),FOPWA)) == NULL) {
               esgstt=UPLAGN;
               errmsg(SOPFER);
          }
          else {
               fwrite(prfbuf,1,FSPSIZ-1,fp);
               fclose(fp);
               esgptr->msg.flags|=INDRCT+FILATT+APPVED;
               prfmsg(IATTAP);
               (*esgptr->whndun)();
          }
     }
}
 
uploff(keep)                  /* turn uploading off, keep or delete file   */
int keep;
{
     btumil(usrnum,DFTIMX);
     btuffo(usrnum,0);
     if (esgptr->fxftyp > UPLTYPS) {
          btubsz(usrnum,INPSIZ,outbsz);
          donupl(keep,"");
     }
}
 
donupl(keep,why)               /* done with upload, keep or delete file     */
int keep;                                     /* 1=keep file, 0=delete file */
char *why;                     /* if delete file, this says why delete file */
{
     int sn;
 
     esgptr->fxftyp=0;
     usrptr->flags&=~NOINJO;
     btutrg(usrnum,0);
     if (udfilex()) {
          if (keep) {
               if ((sn=findsig(esgptr->msg.to)) == NOSIG) {
                    esgptr->msg.flags|=FILATT+APPVED;
                    prfmsg(UPDONE);
               }
               else if (rdautl(sn) >= COAXES) {
                    esgptr->msg.flags|=FILATT+APPVED;
                    prfmsg(FILAVL);
               }
               else {
                    esgptr->msg.flags|=FILATT;
                    prfmsg(FILNVL);
               }
               sv.uplds+=1;
               if (meither(eupaud,supaud)) {
                    shocst(1,"%s U:%s",usaptr->userid,attfs());
               }
          }
          else {
               prfmsg(UPLCAN1,why);
               unlink(attfsd());
          }
     }
}
 
edimsg(clr,tpc,whndun,ffv)    /* fire up editor, invoke whndun when done   */
int clr,tpc,(*whndun)();
int ffv;                           /* file flavor of edit if set           */
{
     int esgimr();
 
     if (clr) {
          mkmsgn();
          esgptr->msg.flags=0;
     }
     bgnedt(clr,msgbyts+1,esgptr->msg.text,
            ffv ? -TPCSIZ : TPCSIZ,tpc ? esgptr->msg.topic : NULL);
     edtimr(esgimr);
     esgptr->whndun=whndun;
     esgstt=EDITING;
     esgptr->dftinp='\0';
}
 
sediting()                    /* state: in the editor                      */
{
     if (dunedt()) {
          (*esgptr->whndun)();
     }
     else {
          prf("");
     }
}
 
esgimr(mno)                   /* e/sigs message importer utility           */
long mno;
{
     char temp[TPCSIZ+AXTSIZ];
     char tempto[UIDSIZ];
     char temputo[UIDSIZ];
     int koldtp,ftemp;
     long ltemp;
 
     compos.msgno=mno;
     movmem(usaptr->userid,compos.userid,UIDSIZ);
     movmem(esgptr->msg.topic,temp,TPCSIZ+AXTSIZ);
     movmem(esgptr->msg.to,tempto,UIDSIZ);
     movmem(esgptr->msg.userto,temputo,UIDSIZ);
     koldtp=(strlen(esgptr->msg.topic) > 1);
     ltemp=esgptr->msg.msgno;
     ftemp=esgptr->msg.flags;
     if (acqbtv(&esgptr->msg,&compos,FROMNUM)
      || acqbtv(&esgptr->msg,&compos,UTONUM)) {
          movmem(tempto,esgptr->msg.to,UIDSIZ);
          movmem(temputo,esgptr->msg.userto,UIDSIZ);
          esgptr->msg.msgno=ltemp;
          if (koldtp) {
               movmem(temp,esgptr->msg.topic,TPCSIZ+AXTSIZ);
          }
          else {
               movmem(temp+TPCSIZ,esgptr->msg.auxtpc,AXTSIZ);
          }
          esgptr->msg.flags=ftemp;
          esgptr->msg.nreply=0;
          return(1);
     }
     return(0);
}
 
uidxst(uid)                   /* does this User-ID exist?                  */
char *uid;
{
     int retval;
 
     setbtv(accbb);
     retval=qeqbtv(uid,0);
     setbtv(esgbb);
     return(retval);
}
 
char *
attfsn()                      /* attachment filespec, name part only       */
{
     char *alias,*cp;
 
     for (alias=cp=attfs() ; *cp != '\0' ; cp++) {
          if (*cp == '\\' || *cp == ':') {
               alias=cp+1;
          }
     }
     return(alias);
}
 
char *
attfsd()                      /* attachment filespec, "direct" only        */
{
     static char filespec[FSPSIZ];
     char *fnp;
     int fnplen;
 
     strcpy(filespec,esgptr->msg.to[0] == SIGIDC ? esgptr->msg.to+1 : "email");
     fnp=spr("\\%ld.att",esgptr->msg.msgno);
     while ((fnplen=strlen(fnp)) >= 14) {         /* ensures over 2 billion */
          fnp[fnplen-2]=fnp[fnplen-1];            /*   unique filenames     */
          fnp[fnplen-1]=fnp[1];
          movmem(fnp+2,fnp+1,strlen(fnp+1));
     }
     strcat(filespec,fnp);
     return(filespec);
}
 
char *
attfs()                       /* attachment filespec, net (may be indirect)*/
{
     FILE *indrfp;
     struct fndblk fb;
     char *filespec;
 
     filespec=attfsd();
     if (esgptr->msg.flags&INDRCT) {
          if ((indrfp=fopen(filespec,FOPRA)) == NULL) {
               return(NULL);
          }
          if (fread(filespec,1,FSPSIZ-1,indrfp) != FSPSIZ-1) {
               fclose(indrfp);
               return(NULL);
          }
          fclose(indrfp);
     }
     if (fnd1st(&fb,filespec,0)) {
          filen=fb.size;
     }
     else {
          filen=-1L;
     }
     uprcse(filespec);
     return(filespec);
}
 
findsig(name)                 /* find sig number, given name and access    */
char *name;
{
     return(findsigu(name,1));
}
 
findsigu(name,cond)           /* find sig number utility, conditionally    */
char *name;
int cond;
{
     int retval;
 
     for (retval=0,sdtptr=sigdat ; retval < nsigs ; retval++,sdtptr++) {
          if (sameas(name,sdtptr->signam)) {
               movmem(sdtptr->signam,name,UIDSIZ);
               if (!cond) {
                    return(retval);
               }
               return(rdautl(retval) == NOAXES ? NOSIG : retval);
          }
     }
     return(NOSIG);
}
 
addaux(newaux)                /* add on to existing auxillary msg topic    */
char *newaux;
{
     char auxbuf[AXTSIZ*2];
 
     strcpy(auxbuf,newaux);
     if (strlen(esgptr->msg.auxtpc) != 0 && !(esgptr->msg.flags&ISSHDR)) {
          strcat(auxbuf,", ");
          strcat(auxbuf,esgptr->msg.auxtpc);
          if (strlen(auxbuf) > AXTSIZ-1) {
               auxbuf[AXTSIZ-2]='*';
               auxbuf[AXTSIZ-1]='\0';
          }
     }
     strcpy(esgptr->msg.auxtpc,auxbuf);
}
 
char *
formax(leader)                /* form aux topic fragment, 15 chars max     */
char *leader;
{
     static char auxbuf[AXTSIZ/2+1],*ltoap;
 
     strcpy(auxbuf,leader);
     ltoap=ltoa(esgptr->msg.msgno);
     strcpy(auxbuf+min(strlen(auxbuf),AXTSIZ/2-strlen(ltoap)-1),ltoap);
     return(auxbuf);
}
 
mkmsgn()                      /* make msg number                           */
{
     esgptr->msg.msgno=++sv.msgtot;
}
 
postit()                      /* post the msg built                        */
{
     movmem(usaptr->userid,esgptr->msg.from,UIDSIZ);
     esgptr->msg.crdate=today();
     esgptr->msg.crtime=now();
     esgptr->msg.nreply=0;
     setbtv(esgbb);
     invbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
}
 
stdcnf()                      /* standard confirmation after posting       */
{
     prfmsg(WCONFM,ltoa(esgptr->msg.msgno));
     if (esgptr->msg.to[0] == SIGIDC) {
          pstpst(SWRITSU,SNOTIFD);
     }
     else {
          pstpst(SWRITU,SNOTIFD);
     }
}
 
pstpst(recip,sender)          /* "post-posting" cleanup                    */
int recip,sender;
{
     outprf(usrnum);
     figin(1);
     if (onsys(esgptr->msg.userto)) {
          prfmsg(recip,usaptr->userid,esgptr->msg.to);
          if (injoth()) {
               prfmsg(sender,esgptr->msg.userto);
               outprf(usrnum);
          }
     }
}
 
figin(addend)                 /* figure in the current msg to totals       */
int addend;
{
     if (esgptr->msg.to[0] == SIGIDC) {
          sv.sigopn+=addend;
          if (findsigu(esgptr->msg.to,0) == NOSIG) {
               catastro("FIGIN: NO SIG!");
          }
          sdtptr->nmsgs+=addend;
          switch (esgptr->msg.flags&(FILATT+APPVED)) {
          case FILATT:
               sdtptr->nw4app+=addend;
               break;
          case FILATT+APPVED:
               sdtptr->nfiles+=addend;
               break;
          }
     }
     else {
          sv.emlopn+=addend;
     }
}
 
sgonum()                      /* state: email go-to-message number         */
{
     if (strtup(GNMHLP)) {
          sumscn(morcnc() == 'P');
     }
}
 
strtup(hlpmsn)                /* start up a scan or list utility           */
int hlpmsn;
{
     long begin;
 
     if (isdigit(morcnc())) {
          begin=cnclon();
          alomsg(esgptr->keynum,begin);
          if (esgptr->msg.msgno != begin) {
               prfmsg(MISS2,ltoa(begin));
          }
     }
     else {
          switch (cncchr()) {
          case '?':
               prohlp(hlpmsn);
               return(0);
          case '.':
               estabc();
               break;
          default:
               errmsg(HUH);
               return(0);
          }
     }
     return(1);
}
 
estabc()                      /* establish current vesigs.dat msg again    */
{
     gabbtv(&esgptr->msg,esgptr->fpos,esgptr->keynum);
}
 
estabn()                      /* establish position but don't load text    */
{
     gabbtv(NULL,esgptr->fpos,esgptr->keynum);
}
 
estaab()                      /* establish current vesigs.dat msg, if ok   */
{
     return(aabbtv(&esgptr->msg,esgptr->fpos,esgptr->keynum));
}
 
/* The following routine spits out the message summary lines like this:
 
E-Mail #88888  04-JUN-88 14:03  (Reply to #45678, Reply to #65555)
From: Tiponiell
  To: ColdDuck (private message) *RETURN RECEIPT REQUESTED*
FILE: HAMBURG.WAF - a whale of a recipe (23 replies)
 
   or this (SIG mail viewed from E-Mail):
 
SIG msg #88888  04-JUN-88 14:03  *EXEMPT* (Reply to #34567)
From: Tiponiell
  To: ColdDuck (in SIG /Flippers)
  Re: Hamburger Waffles in the Sunshine (23 replies)
 
   or this (SIG mail viewed from SIGs):
 
/Flippers #88888  04-JUN-88 14:03  *EXEMPT* (Reply to #76543, Reply to #78990)
From: Tiponiell
  To: ColdDuck
  Re: Hamburger Waffles in the Sunshine (32 Replies)
 
   or this (SIG file viewed from SIGs):
 
/Flippers #88888  04-JUN-88 14:03  *EXEMPT* (Reply to #76543, Reply to #78990)
From: Tiponiell
  To: ColdDuck
FILE: HAMBURG.WAF - a recipe fit for kings (32 replies)                     */
 
sumams()
{
     int flags,nr;
     char *nrstg,*rxstg,*restg;
     char tmpto,*tmptop;
 
     flags=esgptr->msg.flags;
     if (flags&ISSHDR) {
          prf("\r#%s   SIG HEADER: %s   SIG-Op: %s   Created %s %02d:%02d\rSIG Topic: %s\r",
            ltoa(esgptr->msg.msgno),
            esgptr->msg.to,
            esgptr->msg.from,
            ncedat(esgptr->msg.crdate),
            dthour(esgptr->msg.crtime),
            dtmin(esgptr->msg.crtime),
            esgptr->msg.topic);
     }
     else {
          tmptop=esgptr->msg.userto;
          tmpto=*tmptop;
          *tmptop=uclchr(*tmptop);
          nr=esgptr->msg.nreply;
          restg=((flags&APPVED) ? "FILE" : "  Re");
          nrstg=((nr == 0) ? "" : spr(" (%d repl%s)",nr,(nr == 1) ? "y" : "ies"));
          if (esgptr->msg.to[0] == SIGIDC) {
               rxstg=((flags&EXEMPT) ? " *EXEMPT*" : "");
               if (usrptr->state == SIGSTT) {
                    prf("\r%s #%s %s %02d:%02d %s %s\rFrom: %s\r  To: %s\r%s: %s  %s\r",
                      esgptr->msg.to,
                      ltoa(esgptr->msg.msgno),
                      ncedat(esgptr->msg.crdate),
                      dthour(esgptr->msg.crtime),
                      dtmin(esgptr->msg.crtime),
                      rxstg,
                      axtstg(),
                      esgptr->msg.from,
                      esgptr->msg.userto,
                      restg,
                      esgptr->msg.topic,
                      nrstg);
               }
               else {
                    prf("\rSIG msg #%s %s %02d:%02d %s %s\rFrom: %s\r  To: %s (in SIG %s)\r%s: %s  %s\r",
                      ltoa(esgptr->msg.msgno),
                      ncedat(esgptr->msg.crdate),
                      dthour(esgptr->msg.crtime),
                      dtmin(esgptr->msg.crtime),
                      rxstg,
                      axtstg(),
                      esgptr->msg.from,
                      esgptr->msg.userto,
                      esgptr->msg.to,
                      restg,
                      esgptr->msg.topic,
                      nrstg);
               }
          }
          else if (!sameas(usaptr->userid,esgptr->msg.from)
                && !sameas(usaptr->userid,esgptr->msg.userto)) {
               catastro("SUMAMS ERROR");
          }
          else {
               prf("\rE-Mail #%s %s %02d:%02d %s\rFrom: %s\r  To: %s (private message) %s\r%s: %s  %s\r",
                 ltoa(esgptr->msg.msgno),
                 ncedat(esgptr->msg.crdate),
                 dthour(esgptr->msg.crtime),
                 dtmin(esgptr->msg.crtime),
                 axtstg(),
                 esgptr->msg.from,
                 esgptr->msg.userto,
                 (flags&RECREQ) ? " *RETURN RECEIPT REQUESTED*" : "",
                 restg,
                 esgptr->msg.topic,
                 nrstg);
          }
          *tmptop=tmpto;
     }
}
 
char *
axtstg()                      /* auxillary topic string formatter          */
{
     return(esgptr->msg.auxtpc[0] == '\0' ? ""
                                          : spr("(%s)",esgptr->msg.auxtpc));
}
 
sumnew()                      /* summarize new msg, set fpos, prompt       */
{
     esgptr->fpos=absbtv();
     sumams();
     esgptr->usigno=findsig(esgptr->msg.to);
     prompt(meither(SCOSCN,scoscd()));
}
 
sumscn(dsifmore)              /* sumnew(), but don't show if more input    */
int dsifmore;
{
     sumnew();
     if (dsifmore && morcnc()) {
          clrprf();
     }
     else {
          outprf(usrnum);
     }
     prf("");
}
 
refclr(cflmsg)                /* clear current msg (w/check), go on        */
int cflmsg;
{
     int isanxt;
     long temp,ultdest;
 
     estabc();
     cncall();
     if (esgcfl()) {
          prfmsg(cflmsg);
          isanxt=aqnxut();
     }
     else {
          temp=esgptr->fpos;
          isanxt=aqnxut();
          ultdest=absbtv();
          esgptr->fpos=temp;
          estabc();
          if (sameas(usaptr->userid,esgptr->msg.userto)) {
               esgptr->msg.userto[0]=clrchr(esgptr->msg.userto[0]);
          }
          if (sameas(usaptr->userid,esgptr->msg.to)) {
               esgptr->msg.to[0]=clrchr(esgptr->msg.to[0]);
          }
          upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
          esgptr->fpos=ultdest;
          estaab();
     }
     if (!isanxt) {
          blwoff(RPREND);
     }
}
 
aqnxut()                      /* acquire next message utility for refclr() */
{
     if (aqnbtv(&esgptr->msg)) {
          sumnew();
          return(1);
     }
     return(0);
}
 
alomsg(keyno,msgno)           /* acquire highest msg less than msgno, or?  */
int keyno;
long msgno;
{
     char *tffield;
 
     tffield=either(usaptr->userid,sigdat[esgptr->usigno].signam);
     movmem(tffield,compos.userid,UIDSIZ);
     compos.msgno=msgno;
     if (msgno == FIRSTM
       || !alebtv(&esgptr->msg,&compos,keyno)
       || !sameas(esgbb->key,compos.userid)) {
          if (!agebtv(&esgptr->msg,&compos,keyno)
            || !sameas(esgbb->key,compos.userid)) {
               return(0);
          }
     }
     esgptr->fpos=absbtv();
     esgptr->keynum=keyno;
     return(1);
}
 
prompt(news)                  /* prompt user, set new state, default input */
int news;
{
     int i;
     char *lstchp,*cp;
 
     esgstt=news;
     if (!morcnc() || (usrptr->flags&INJOIP)) {
          sdtptr=&sigdat[esgptr->usigno];
          switch (news) {
          case REPRMT:
          case RSPRMT:
          case ORSPRMT:
               if (usrptr->flags&CONCEX) {
                    prfmsg(either(MAINEX,MAINSX));
                    btuoes(usrnum,0);
                    btutru(usrnum,'O'&0x1F);
                    condex();
               }
               prfmsg(news);
               break;
          case EINFO:
               prfmsg(news,emltck,eattck,rrrtck,emllif);
               break;
          case GOASC:
               prfmsg(news,bbsttl,ncedat(today()),nctime(now()));
               break;
          case ERTFQ:
          case ERFHLP:
          case ERTHLP2:
          case ERPHLP:
          case STARTS:
          case STARTL:
          case RTSHLP:
          case RTLHLP:
               prfmsg(news,ltoa(esgptr->msg.msgno));
               break;
          case EDITING:
               dunedt();
               break;
          case OPSTART:
               if (usrptr->flags&ISYSOP) {
                    news=SYSTART;
               }
          case SSTART:
               prfmsg(news,sdtptr->signam,sdtptr->descrp,sdtptr->nw4app);
               usrptr->flags&=~CONCEX;
               break;
          case SRKEY:
               prfmsg(esgptr->keywds[0] == '\0' ? SRKEY : SRKYWD,esgptr->keywds);
               break;
          case SRCHNG:
               if (!(esgptr->sflags&SCNQUI)) {
                    prfmsg(news,sdtptr->signam,esgptr->keywds);
                    break;
               }
               news=SRCHQS;
          case SCANNG:
          case LISTNG:
               prfmsg(news,sdtptr->signam);
               break;
          case QUICKC:
               prfmsg(news);
               for (i=0 ; i < nsigs ; i++) {
                    if ((i=qsignx(i)) != NOSIG) {
                         prf("%-9s ",sigdat[i].signam);
                    }
               }
               prf("\r");
               prfmsg(QUICKC4);
               break;
          case QCKWDS:
               prfmsg(news);
               for (i=0 ; i < NQSKWG ; i++) {
                    prf("   %d. %s\r",i+1,qscptr->qskwds[i]);
               }
               prfmsg(QCKWDS2);
               break;
          case SIGCON:
          case SIGCONH:
          case SIG123H:
          case SYS123H:
               prfmsg(news,accstg[dftlvl(dftnlv)],
                           accstg[dftlvl(dftliv)],
                           accstg[dftlvl(maxnlv)]);
               break;
          case DELRUS:
               sdtptr=&sigdat[esgptr->blknum];
               prfmsg(news,sdtptr->signam,sdtptr->descrp,
                           sdtptr->nmsgs,sdtptr->nfiles);
               break;
          case ASCORX:
               pmtdnp();
               break;
          case UPMODE:
          case UPMSOP:
               pmtupp();
               break;
          case GODNLDD:
               prfmsg(news,((cp=tpcfnm()) != NULL ? cp : attfsn()));
               break;
          default:
               prfmsg(news);
          }
          lstchp=prfptr-1;
          if (!isspace(*lstchp)) {
               esgptr->dftinp=*lstchp;
               *(prfptr=lstchp)='\0';
          }
          else {
               esgptr->dftinp='\0';
          }
     }
}
 
prohlp(news)                  /* prompt with help msg (don't change state) */
int news;
{
     int xstt;
 
     cncall();
     xstt=esgstt;
     prompt(news);
     esgstt=xstt;
}
 
errmsg(msgnum,parm1,parm2)    /* error msg, then re-prompt current state   */
int msgnum;
long parm1,parm2;
{
     prfmsg(msgnum,parm1,parm2);
     outprf(usrnum);
     cncall();
     btucli(usrnum);
     clrinp();
     prompt(esgstt);
}
 
blwoff(msgnum,parm)           /* blow off back to main e/s menu, with msg  */
int msgnum;
long parm;
{
     esgstt=MMENU;
     errmsg(msgnum,parm);
}
 
xtext()                       /* transmit text of current msg to user      */
{
     char *cp;
     int sn;
 
     for (cp=esgptr->msg.text ; *cp != '\0' ; cp++) {
          if (*cp == '\r' && isalnum(*(cp+1))) {
               *cp='\n';
          }
     }
     btuoes(usrnum,1);
     btutru(usrnum,'\r');
     btuxmt(usrnum,esgptr->msg.text);
     btuxmt(usrnum,"\r");
     if (esgptr->prethr == 0L) {
          if (usrptr->state == EMLSTT) {
               if (esgptr->keynum != FROMNUM
                 && usaptr->emllim < esgptr->msg.msgno) {
                    usaptr->emllim=esgptr->msg.msgno;
               }
          }
          else if (qscptr->lsofar[esgptr->usigno] < esgptr->msg.msgno) {
               qscptr->lsofar[esgptr->usigno]=esgptr->msg.msgno;
          }
     }
}
 
tovalid()                     /* check if proposed msg recipient is valid  */
{
     sendto(cncuid());
     return(validwr(esgptr->msg.to));
}
 
validwr(dest)                 /* ck if msg destination is ok, leave "to" be */
char *dest;
{
     int signo,attach;
 
     if ((signo=findsig(dest)) != NOSIG) {
          attach=(esgptr->msg.flags&FILATT);
          if (rdautl(signo) < (attach ? ULAXES : WRAXES)) {
               errmsg(attach ? FWUNUP : FWUNWR,either("E-Mail","SIG"));
               return(0);
          }
          return(1);
     }
     if (!uidxst(dest)) {
          errmsg(FWUNXI,either("E-Mail","SIG"));
          return(0);
     }
     return(1);
}
 
isalon()                      /* check if input is a "long", prep compos   */
{
     if (!isdigit(morcnc())) {
          errmsg(HUH);
          return(0);
     }
     compos.msgno=cnclon();
     movmem(either(usaptr->userid,sigdat[esgptr->usigno].signam),
            compos.userid,UIDSIZ);
     return(1);
}
 
moddun()                      /* modify-msg done, update and go on         */
{
     wrtmod();
     prompt(MMENU);
}
 
wrtmod()                      /* write modified record to disk (&ck SIGHDR)*/
{
     struct sighdr *hdrptr;
 
     if (!esgcfl()) {
          if (esgptr->msg.flags&ISSHDR) {
               hdrptr=(struct sighdr *)(&esgptr->msg);
               movmem(esgptr->msg.topic,sigdat[hdrptr->signo].descrp,TPCSIZ);
          }
          estabn();
          upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
          prfmsg(WCONFM,ltoa(esgptr->msg.msgno));
     }
}
 
fwdit(recip)                  /* forward current message to new recipient  */
char *recip;
{
     long tmno;
     char oldnam[FSPSIZ];
 
     estabc();
     strcpy(oldnam,attfsd());
     sendto(recip);
     addaux(spr("Fw by %s",usaptr->userid));
     tmno=esgptr->msg.msgno;
     mkmsgn();
     if (esgptr->msg.flags&FILATT) {
          rename(oldnam,attfsd());
          dwfwdf();
     }
     invbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
     prfmsg(FWDCNF,ltoa(tmno),ltoa(esgptr->msg.msgno),esgptr->msg.to);
     pstpst(SFWDDU,SNOTIFD);
}
 
sendto(recip)                 /* send current message to spec'd recipient  */
char *recip;
{
     char *cp;
 
     movmem(recip,esgptr->msg.to,UIDSIZ);
     if (*recip == SIGIDC) {
          if (morcnc() == '-') {
               cncchr();
               if (*(cp=cncuid()) != '\0') {
                    movmem(cp,esgptr->msg.userto,UIDSIZ);
                    return;
               }
          }
          movmem(ALL,esgptr->msg.userto,UIDSIZ);
     }
     else {
          movmem(recip,esgptr->msg.userto,UIDSIZ);
     }
}
 
dwfwdf()                      /* deal with forwarding of file              */
{
     int sn;
 
     esgptr->msg.flags|=APPVED;
     if ((sn=findsig(esgptr->msg.to)) != NOSIG) {
          if (rdautl(sn) >= COAXES) {
               prfmsg(FWDCAP);
          }
          else {
               esgptr->msg.flags&=~APPVED;
               prfmsg(FWDCNA);
          }
     }
}
 
delwck()                      /* delete msg, with sighdr and collision cks */
{
     esgptr->fpos=absbtv();
     if (esgptr->msg.flags&ISSHDR) {
          blwoff(NDELHD);
     }
     else if (esgcfl()) {
          blwoff(USING);
     }
     else {
          delmsg();
          prfmsg(OKGONE,ltoa(compos.msgno));
          prompt(MMENU);
     }
}
 
delmsg()                      /* delete msg and any direct attachment      */
{
     delbtv();
     unlink(attfsd());
     figin(-1);
}
 
esgmcu()                      /* email/sigs midnight cleanup               */
{
     int ctoday,age,smslif;
 
     ctoday=cofdat(today());
     setbtv(esgbb);
     esgptr=((struct esgusr *)vdarea);
     usrptr=user;
     if (qlobtv(TONUM)) {
          do {
               gcrbtv(&esgptr->msg,TONUM);
               age=ctoday-cofdat(esgptr->msg.crdate);
               if (esgptr->msg.to[0] == SIGIDC) {
                    if (esgptr->msg.flags&ISSHDR) {
                         smslif=sigopt("message-lifetime:",siglif);
                    }
                    else if (!(esgptr->msg.flags&EXEMPT)
                      && smslif >= 0 && age > smslif) {
                         delmsg();
                    }
               }
               else if (emllif >= 0 && age > emllif) {
                    delmsg();
               }
          } while (qnxbtv());
     }
}
 
char *
sigtpc(signo)                 /* sig topic (for use by teleconference)     */
int signo;
{
     if (signo <= 0 || signo >= nsigs) {
          return("");
     }
     else {
          return(sigdat[signo].descrp);
     }
}
 
esgmod(whndun)                /* email/sigs modify-msg utility             */
int (*whndun)();
{
     esgptr->fpos=absbtv();
     if (esgcfl()) {
          prfmsg(USING);
          cncall();
          (*whndun)();
     }
     else {
          if (esgptr->msg.flags&ISSHDR) {
               if (!sopmhd && !(usrptr->flags&ISYSOP)) {
                    blwoff(NOMODH);
                    return;
               }
               if (!morcnc()) {
                    prfmsg(EHDPFX,sigccr,siglif,sigtck,sattck);
                    outprf(usrnum);
               }
          }
          edimsg(0,1,whndun,(esgptr->msg.flags&FILATT));
     }
}
 
esgcfl()                      /* email/sigs "conflict" (collision) detect  */
{
     long recpos;
     struct esgusr *othesg;
 
     recpos=esgptr->fpos;
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (othusn != usrnum
           && othusp->class > SUPIPG
           && (othusp->state == EMLSTT || othusp->state == SIGSTT)) {
               switch (othusp->substt) {
               case ESTART:
               case REPRMT:
               case SSTART:
               case RSPRMT:
               case OPSTART:
               case ORSPRMT:
                    break;
               default:
                    othesg=esgarr(othusn);
                    if (recpos == othesg->fpos
                     || recpos == othesg->prethr) {
                         return(1);
                    }
               }
          }
     }
     return(0);
}
 
esghup()                      /* email/sigs hang-up-phone vector           */
{
     setmbk(esgmb);
     libpsp();
     if (usrptr->state == EMLSTT || usrptr->state == SIGSTT) {
          if (usrptr->substt == RRRQ) {
               postit();
          }
          uploff(0);
          dnloff();
          cpyoff();
          clrprf();
     }
     qscptr=qscoff(usrnum);
     if (qscptr->userid[0] != '\0') {
          setbtv(qscbb);
          geqbtv(NULL,usaptr->userid,0);
          updbtv(qscptr);
          setmem(qscptr,sizeof(struct qscfg),0);
     }
}
 
credok(nlvflg,howmny)         /* credits ok for this operation?            */
int nlvflg;
int howmny;
{
     if (nlvflg) {
          return(1);
     }
     if (usrptr->class > FRELOA && usaptr->tckavl >= howmny) {
          usaptr->tckavl-=howmny;
          return(1);
     }
     if (howmny == 0) {
          errmsg(NOTLIV,either("E-Mail","SIG"));
     }
     else {
          errmsg(usrptr->class == FRELOA ? NOCREDS : NECREDS,
                                           howmny,either("E-Mail","SIG"));
     }
     return(0);
}
 
credsf(howmny)                /* credits sufficient for this operation?  */
int howmny;
{
     if (usaptr->tckavl >= howmny) {
          usaptr->tckavl-=howmny;
          return(1);
     }
     errmsg(usrptr->class == FRELOA ? NOCREDS : NECREDS,
                                      howmny,either("E-Mail","SIG"));
     return(0);
}
 
