/***************************************************************************
 *                                                                         *
 *   EMAIL.C                                                               *
 *                                                                         *
 *   Copyright (C) 1988-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is The Major BBS electronic mail service handler.                *
 *                                                                         *
 *                                  - T. Stryker 7/26/88                   *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "setjmp.h"
#include "majorbbs.h"
#include "usracc.h"
#include "btvstf.h"
#include "esigs.h"
#include "message.h"
#include "dosface.h"
#include "portable.h"
 
int iniesg(),ealert(),email(),emsthn(),esghup(),esgmcu();
 
/* note first few lines in MESSAGE.H before changing the following name */
 
struct module module11={      /* module interface block               */
     '*',                     /*    main menu select character (config'able) */
     "",                      /*    description for main menu  (config'able) */
     iniesg,                  /*    system initialization routine     */
     ealert,                  /*    user logon supplemental routine   */
     email,                   /*    input routine if selected         */
     emsthn,                  /*    status-input routine if selected  */
     esghup,                  /*    hangup (lost carrier) routine     */
     esgmcu,                  /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     NULL                     /*    finish-up (sys shutdown) routine  */
};
 
/*--- OPTIONS FROM ESIGS.MSG ---*/
 
int emllif,                   /* lifetime of an E-Mail message, in days    */
    nlveml,                   /* flag: may non-live users write E-Mail?    */
    nlveat,                   /* flag: may non-live users make attachments?*/
    nlvrrr,                   /* flag: may non-live users write RRR msgs?  */
    emltck,                   /* "ticks" (credits) eaten per E-Mail msg    */
    eattck,                   /* "ticks" (credits) eaten per attachment    */
    rrrtck,                   /* "ticks" (credits) eaten per return receipt*/
    ednaud,                   /* Do audit trail entry per E-Mail download? */
    eupaud,                   /* Do audit trail entry per E-Mail upload?   */
    ccmax;                    /* maximum number of carbon copies per msg   */
 
#define MMENU  REPRMT
#define HUH    EMLHUH
 
inieml()                      /* initialize E-Mail                         */
{
     mkdir("email");
     emllif=numopt(EMLLIF,-1,32767);
     nlveml=ynopt(NLVEML);
     nlveat=ynopt(NLVEAT);
     nlvrrr=ynopt(NLVRRR);
     emltck=numopt(EMLTCK,-32767,32767);
     eattck=numopt(EATTCK,-32767,32767);
     rrrtck=numopt(RRRTCK,-32767,32767);
     ednaud=ynopt(EDNAUD);
     eupaud=ynopt(EUPAUD);
     ccmax=numopt(CCMAX,0,32767);
     inimid(EMLSTT,EMLSEL,EMLMNU);
}
 
ealert()                      /* alert user to E-Mail waiting              */
{
     int em=0,nem=0,nsm=0;
 
     setbtv(esgbb);
     esgptr->usigno=NOSIG;
     if (alomsg(UTONUM,usaptr->emllim)) {
          if (usaptr->emllim < esgptr->msg.msgno || aqnbtv(&esgptr->msg)) {
               nsm=1;
          }
          if (alomsg(TONUM,usaptr->emllim)) {
               em=1;
               if (usaptr->emllim < esgptr->msg.msgno || aqnbtv(&esgptr->msg)) {
                    nem=1;
               }
          }
          setmbk(esgmb);
          if (nem) {
               prfmsg(NEWMAIL);
          }
          else if (nsm) {
               prfmsg(NEWSIGM);
          }
          else if (em) {
               prfmsg(OLDMAIL);
          }
          else {
               prfmsg(OLDSIGM);
          }
          prfmsg(EITHWY);
          outprf(usrnum);
     }
}
 
email()                       /* main E-Mail status-3 input handler        */
{
     if (fireup()) {
          if (margc == 1 && sameas(input,"x")) {
               uploff(0);
               dnloff();
               cpyoff();
               esgptr->sflags&=~RAFIPG;
               if (esgstt <= MMENU) {
                    prfmsg(MAINEX);
                    return(0);
               }
               esgptr->usigno=NOSIG;
               cncall();
               prfmsg(EX2MAI);
               prompt(MMENU);
          }
          else {
               do {
                    bgncnc();
                    switch (esgstt) {
                    case 0:
                         cncchr();
                         usrptr->flags&=~X2MAIN;
                         iniqsc();
                         esgptr->usigno=NOSIG;
                         prompt(ESTART);
                         break;
                    case ESTART:
                    case REPRMT:
                         sestart();
                         break;
                    case REWHAT3:
                         srewhat();
                         break;
                    case ERTFQ:
                         sertfq();
                         break;
                    case SCOSCN:
                    case NXTGUY2:
                         sscoscn();
                         break;
                    case REFBPN:
                    case REFPNQ:
                         srfvpn();
                         break;
                    case REPSEM:
                    case RESOP:
                         srepsig();
                         break;
                    case RRRQ:
                         srrrq();
                         break;
                    case COPYQ:
                    case MORCPQ:
                         scopyq();
                         break;
                    case CPYING:
                         prompt(esgstt);
                         break;
                    case CPYUID:
                    case MORCPU:
                         scpyuid();
                         break;
                    case WHOFWD:
                         swhofwd();
                         break;
                    case WHOTO:
                         swhoto();
                         break;
                    case MODWHT:
                         smodwht();
                         break;
                    case DELMSN:
                         sdelmsn();
                         break;
                    default:
                         hdlesg();
                    }
               } while (!endcnc());
          }
     }
     outprf(usrnum);
     usrptr->substt=esgstt;
     return(1);
}
 
sestart()                     /* state: sitting at the main E-Mail menu    */
{
     switch (cncchr()) {
     case '?':
          if (esgstt == ESTART) {
               prompt(EINFO);
               esgstt=MMENU;
          }
          else {
               prompt(ESTART);
          }
          break;
     case 'R':
          prompt(REWHAT3);
          break;
     case 'W':
          if (!nlveml && usaptr->tckavl <= emltck) {
               prfmsg(WSYSOP);
          }
          prompt(WHOTO);
          break;
     case 'M':
          prfmsg(MODWRN);
          prompt(MODWHT);
          break;
     case 'E':
          prompt(DELMSN);
          break;
     default:
          errmsg(CNOTIL);
     }
}
 
srewhat()                     /* state: read what? (mail TO or FROM you?)  */
{
     switch (cncchr()) {
     case '?':
          prohlp(REWHLP3);
          break;
     case 'T':
          ertphd(UTONUM,NOMSGT2);
          break;
     case 'P':
          ertphd(TONUM,NOMSGP2);
          break;
     case 'F':
          if (!alomsg(FROMNUM,FIRSTM)) {
               blwoff(NOMSGF);
          }
          else {
               prompt(ERTFQ);
          }
          break;
     default:
          errmsg(HUH);
     }
}
 
ertphd(keynum,blomsg)         /* e-mail read to/private handler utility    */
int keynum;
int blomsg;
{
     if (!alomsg(keynum,usaptr->emllim)) {
          blwoff(blomsg);
     }
     else {
          if (usaptr->emllim >= esgptr->msg.msgno) {
               if (aqnbtv(&esgptr->msg)) {
                    esgptr->fpos=absbtv();
               }
               else {
                    estabc();
               }
          }
          prompt(ERTFQ);
     }
}
 
sertfq()                      /* state: email read to or from you?         */
{
     static int hlpnum[]={0,ERFHLP,ERPHLP,ERTHLP2};
 
     if (strtup(hlpnum[esgptr->keynum])) {
          sumscn(morcnc() == 'P');
     }
}
 
sscoscn()                     /* state: next, previous, or read?           */
{
     int attwrn(),modfrm();
 
     switch (cncchr()) {
     case 'N':
          gonext();
          break;
     case 'P':
          goprev();
          break;
     case 'R':
          xtext();
          dwrrr();
          if (esgptr->msg.flags&APPVED) {
               dnload(attwrn);
          }
          else {
               attwrn();
          }
          break;
     case '#':
          prompt(GONUM);
          break;
     case 'E':
          if (esgstt == NXTGUY2) {
               rfdwck();
               break;
          }
     case 'M':
          if (esgstt == NXTGUY2) {
               estabc();
               esgmod(modfrm);
               break;
          }
     default:
          errmsg(HUH);
     }
}
 
modfrm()                      /* done modifying a message from the guy     */
{
     wrtmod();
     gonext();
}
 
gonext()                      /* go to next email msg in sequence          */
{
     estabc();
     if (aqnbtv(&esgptr->msg)) {
          sumscn(0);
     }
     else {
          estabc();
          cncall();
          prompt(SCNEND2);
          esgstt=meither(SCOSCN,scoscd());
     }
}
 
goprev()                      /* go to previous email msg in sequence      */
{
     estabc();
     if (aqpbtv(&esgptr->msg)) {
          sumscn(1);
     }
     else {
          estabc();
          cncall();
          prompt(SCNBGN2);
          esgstt=meither(SCOSCN,scoscd());
     }
}
 
attwrn()                      /* post-download opportunity state director  */
{
     prompt(esgptr->keynum == FROMNUM ? NXTGUY2 : REFBPN);
}
 
dwrrr()                       /* deal with return receipt request          */
{
     if ((esgptr->msg.flags&RECREQ)
       && sameas(usaptr->userid,esgptr->msg.userto)) {
          esgptr->msg.auxtpc[0]='\0';
          esgptr->msg.flags=0;
          prfmsg(RRRTXT2,usaptr->userid,ltoa(esgptr->msg.msgno),
                 ncedat(esgptr->msg.crdate),nctime(esgptr->msg.crtime),
                 esgptr->msg.topic,axtstg());
          strcpy(esgptr->msg.text,prfbuf);
          clrprf();
          prfmsg(RRRTPC,ltoa(esgptr->msg.msgno));
          strncpy(esgptr->msg.topic,prfbuf,TPCSIZ-1);
          clrprf();
          sendto(esgptr->msg.from);
          mkmsgn();
          postit();
          prfmsg(RRRGEN);
          pstpst(SRRRU,SRRRD);
          estabc();
          esgptr->msg.flags&=~RECREQ;
          upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
     }
}
 
srfvpn()                     /* state: after reading email, what next?    */
{
     char *sptr;
     long temp;
 
     switch (cncchr()) {
     case 'R':
          dorply();
          break;
     case 'E':
          rfdwck();
          break;
     case 'F':
          prompt(WHOFWD);
          break;
     case 'B':
          cncall();
          sptr=esgptr->msg.auxtpc;
          if (sameto("Rep",sptr)) {
               while (!isdigit(*sptr) && *sptr != '\0') {
                    sptr+=1;
               }
               movmem(esgptr->msg.userto,compos.userid,UIDSIZ);
               compos.msgno=atol(sptr);
               if (acqbtv(&esgptr->msg,&compos,FROMNUM)) {
                    temp=usaptr->emllim;
                    sumams();
                    outprf(usrnum);
                    xtext();
                    usaptr->emllim=temp;
                    estabc();
                    prompt(REFPNQ);
               }
               else {
                    errmsg(NOEPAR);
               }
          }
          else {
               errmsg(NOEPAR);
          }
          break;
     case 'P':
          goprev();
          break;
     case 'N':
          gonext();
          break;
     case '#':
          prompt(GONUM);
          break;
     default:
          errmsg(HUH);
     }
}
 
dorply()                      /* do reply to e-mail message                */
{
     int rpedun();
 
     esgstt=REFBPN;
     if (credok(nlveml,emltck)) {
          sendto(esgptr->msg.from);
          addaux(formax("Reply to #"));
          edimsg(2,1,rpedun,0);
     }
}
 
rpedun()                      /* reply to email done, possible attachment? */
{
     int rpadun();
 
     possat(rpadun);
}
 
rpadun()                      /* reply attachment done, req ret receipt?   */
{
     if (esgptr->msg.to[0] == SIGIDC) {
          pmail();
     }
     else {
          prompt(RRRQ);
     }
}
 
srrrq()                       /* state: return receipt requested?          */
{
     switch (cncyesno()) {
     case 'Y':
          if (!credok(nlvrrr,rrrtck)) {
               break;
          }
          esgptr->msg.flags|=RECREQ;
     case 'N':
          pmail();
          break;
     default:
          errmsg(YORN);
     }
}
 
pmail()                       /* post email, with standard follow-up       */
{
     postit();
     stdcnf();
     if (ccmax == 0 && !(usrptr->flags&ISYSOP)) {
          rprdun();
     }
     else {
          esgptr->ccount=0;
          esgptr->prethr=absbtv();
          prompt(COPYQ);
     }
}
 
scopyq()                      /* state: make (another) copy of email msg?  */
{
     switch (cncyesno()) {
     case 'Y':
          prompt(esgstt == COPYQ ? CPYUID : MORCPU);
          break;
     case 'N':
          rprdun();
          break;
     default:
          errmsg(YORN);
     }
}
 
scpyuid()                     /* state: copy email destination User-ID     */
{
     char oldnam[FSPSIZ];
     int cpudun();
     int nlvflg,cpytck;
 
     nlvflg=nlveml;
     cpytck=emltck;
     if (esgptr->msg.flags&FILATT) {
          nlvflg&=nlveat;
          cpytck+=eattck;
     }
     if (esgptr->msg.flags&RECREQ) {
          nlvflg&=nlvrrr;
          cpytck+=rrrtck;
     }
     strcpy(oldnam,attfsd());
     if (tovalid() && credok(nlvflg,cpytck)) {
          addaux(formax("cc: of #"));
          esgptr->curpos=esgptr->msg.msgno;
          mkmsgn();
          if (esgptr->msg.flags&FILATT) {
               if ((esgptr->fp=fopen(oldnam,FOPRB)) == NULL) {
                    blwoff(ATTNF,ltoa(esgptr->msg.msgno));
               }
               else if ((esgptr->fpout=fopen(attfsd(),FOPWB)) == NULL) {
                    fclose(esgptr->fp);
                    blwoff(CPYFER);
               }
               else {
                    esgptr->whndun=cpudun;
                    fupqs(CPYING,CPYIPG);
               }
          }
          else {
               cpudun2();
          }
     }
     else {
          gabbtv(&esgptr->msg,esgptr->prethr,esgptr->keynum);
     }
}
 
cpudun()                      /* copy-msg cleanup when attachment involved */
{
     dwfwdf();
     cpudun2();
}
 
cpudun2()                     /* copy-msg finalization                     */
{
     postit();
     prfmsg(CPYCNF,ltoa(esgptr->curpos),ltoa(esgptr->msg.msgno),esgptr->msg.to);
     pstpst(SCOPYU,SNOTIFD);
     if (++(esgptr->ccount) >= ccmax && !(usrptr->flags&ISYSOP)) {
          prfmsg(CCDONE,ccmax);
          rprdun();
     }
     else {
          gabbtv(&esgptr->msg,esgptr->prethr,esgptr->keynum);
          prompt(MORCPQ);
     }
}
 
rprdun()                      /* write/reply RRRQ/COPYQ sequence done      */
{
     cncall();
     esgptr->prethr=0L;
     if (esgptr->keynum == 0) {         /* i.e. if W from main email menu  */
          prompt(MMENU);
     }
     else if (esgptr->sflags&RAFIPG) {
          esgptr->sflags&=~RAFIPG;
          refdel(ARCONF2);
     }
     else {
          refclr(ARCONF3);
     }
}
 
rfdwck()                      /* reply/erase-type delete msg, with move-on */
{
     if (esgptr->msg.flags&ISSHDR) {
          errmsg(NDELHD);
     }
     else {
          refdel(USING);
     }
}
 
refdel(cflmsg)                /* delete current msg (w/check), go on       */
int cflmsg;
{
     estabc();
     if (esgcfl()) {
          prfmsg(cflmsg);
     }
     else {
          delmsg();
     }
     cncall();
     if (aqnbtv(&esgptr->msg)) {
          sumnew();
     }
     else {
          blwoff(RPREND);
     }
}
 
swhofwd()                     /* state: to whom is msg to be forwarded?    */
{
     char *uid,uid1ch;
 
     if (validwr(uid=cncuid())) {
          if (esgcfl()) {
               blwoff(USING);
          }
          else {
               uid1ch=*uid;
               fwdit(uid);
               if (morcnc() == 'R') {
                    cncchr();
                    prf("\rReply-after-forward option activated!\r");
                    outprf(usrnum);
                    if (uid1ch == SIGIDC) {
                         esgstt=REFBPN;
                         if (credok(nlveml,emltck)) {
                              movmem(esgptr->msg.from,esgptr->msg.userto,UIDSIZ);
                              addaux(formax("Reply to #"));
                              edimsg(2,1,rpedun,0);
                              esgptr->sflags|=RAFIPG;
                         }
                    }
                    else {
                         estabc();
                         dorply();
                         esgptr->sflags|=RAFIPG;
                    }
               }
               else {
                    refdel(0);
               }
          }
     }
}
 
swhoto()                      /* state: who to write this msg to?          */
{
     int rpedun();
 
     if (morcnc() == '.') {
          cncchr();
          sendto("Sysop\0\0\0\0");
     }
     else if (!tovalid() || !credok(nlveml,emltck)) {
          return;
     }
     esgptr->msg.auxtpc[0]='\0';
     esgptr->keynum=0;
     edimsg(1,1,rpedun,0);
}
 
smodwht()                     /* state: modify what msg number?            */
{
     int moddun();
 
     if (isalon()) {
          if (acqbtv(&esgptr->msg,&compos,FROMNUM)) {
               esgmod(moddun);
          }
          else {
               errmsg(UDONTO,ltoa(compos.msgno));
          }
     }
}
 
sdelmsn()                     /* state: delete (erase) what msg number?    */
{
     if (isalon()) {
          if (acqbtv(&esgptr->msg,&compos,FROMNUM)
           || acqbtv(&esgptr->msg,&compos,TONUM)) {
               cncall();
               delwck();
          }
          else {
               errmsg(UCANTD2,ltoa(compos.msgno));
          }
     }
}
 
