/***************************************************************************
 *                                                                         *
 *   CLASSI.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS classified-ad service handler.                  *
 *                                                                         *
 *                                            - T. Stryker 7/2/86          *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "btvstf.h"
#include "classi.h"
#include "dosface.h"
#include "portable.h"
 
int inicsi(),rsalrt(),classi(),dfsthn(),csimcu(),clscsi();
 
#define CSISTT      10        /* classified ad state                  */
struct module module10={      /* module interface block               */
     '*',                     /*    main menu select character (config'able) */
     "",                      /*    description for main menu  (config'able) */
     inicsi,                  /*    system initialization routine     */
     rsalrt,                  /*    user logon supplemental routine   */
     classi,                  /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    hangup (lost carrier) routine     */
     csimcu,                  /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     clscsi                   /*    finish-up (sys shutdown) routine  */
};
 
static
FILE *csimb;                  /* classi named-message file block pointer   */
static
BTVFILE *adbb,                /* btrieve ad text file block pointer        */
        *rspbb;               /* btrieve response text file block pointer  */
 
#define TPCSIZ 65             /* maximum ad topic length                   */
#define RSLSIZ 40             /* maximum response text length              */
 
struct csiad {                     /* classified ad btrieve record layout  */
     long adno;                    /*   ad number from csitot              */
     char topic[TPCSIZ];           /*   ad topic                           */
     char advrtr[UIDSIZ];          /*   advertiser's user-id               */
     int crdate;                   /*   ad creation date                   */
     char spare[88-82];            /*   spare space; decrease when adding  */
     char adtext[1];               /*   ad text block (vbl length)         */
};
 
struct csirsp {                    /* response btrieve file record layout  */
     char resper[UIDSIZ];          /*   responder's user-id                */
     long adno;                    /*   ad number this is in response to   */
     char advrtr[UIDSIZ];          /*   user-id who placed that ad         */
     int rspdat;                   /*   date of response                   */
     char rsptxt[RSLSIZ];          /*   text of response                   */
};
struct csiusr {                    /* classified ad user data block        */
     int edting;                   /*   using editor flag                  */
     long fpos;                    /*   current file position              */
     char dftinp;                  /*   default input char from last prompt*/
     struct csirsp rspblk;         /*   response data block                */
     struct csiad adblk;           /*   ad data block                      */
};
static
int newstt;                   /* new substate for this state               */
static
int msgbyts;                  /* maximum number of bytes in ad texts       */
 
#define csiptr ((struct csiusr *)vdaptr)
#define csiarr(u) ((struct csiusr *)vdaoff(u))
 
/*--- OPTIONS FROM CLASSI.MSG ---*/
 
int cadlif,                   /* Lifetime of a Classified Ad, in days      */
    carlif,                   /* Lifetime of a response to an Ad, in days  */
    nlvcad,                   /* Allow non-live users to place ads?        */
    cadtck,                   /* Credits deducted per classified ad        */
    nlvcar,                   /* Allow non-live users to respond to ads?   */
    cartck;                   /* Credits deducted per response             */
 
inicsi()                      /* initialize classified ads stuff           */
{
     csimb=opnmsg("classi.mcv");
     msgbyts=(outbsz <= 2048 ? outbsz-128 : outbsz-384);
     dclvda(sizeof(struct csiusr)+msgbyts);
     adbb=opnbtv("classadv.dat",sizeof(struct csiad)+msgbyts);
     rspbb=opnbtv("classrsn.dat",sizeof(struct csirsp));
     cadlif=numopt(CADLIF,-1,32767);
     carlif=numopt(CARLIF,-1,32767);
     nlvcad=ynopt(NLVCAD);
     cadtck=numopt(CADTCK,-32767,32767);
     nlvcar=ynopt(NLVCAR);
     cartck=numopt(CARTCK,-32767,32767);
     inimid(CSISTT,CSISEL,CSIMNU);
}
 
rsalrt()                      /* alert user of classi. responses waiting   */
{
     setbtv(rspbb);
     if (qeqbtv(usaptr->userid,1)) {
          setmbk(csimb);
          prfmsg(RSALRT);
     }
}
 
classi()                      /* classified ads MajorBBS interface handler */
{
     setmbk(csimb);
     newstt=usrptr->substt;
     if (usrptr->flags&INJOIP) {
          prfmsg(newstt);
     }
     else {
          chkdft(csiptr->dftinp);
          if (margc == 0 && newstt != PRSRET && !csiptr->edting) {
               prfmsg(newstt);
          }
          else if (margc == 1 && sameas(margv[0],"x")) {
               if (newstt == REPRMT) {
                    prfmsg(MAINEX);
                    return(0);
               }
               csiptr->edting=0;
               btumil(usrnum,DFTIMX);
               prfmsg((usrptr->flags&CONCEX) ? MAINEX : EX2MAI);
               go2mai();
          }
          else if (usrptr->pfnacc > MAXPFN) {
               btuinj(usrnum,RING);
               return(1);
          }
          else if (pfnlvl > 2) {
               errmsg(PFNMSG);
          }
          else if (pfnlvl == 2) {
               errmsg(RAUNCH);
          }
          else {
               do {
                    bgncnc();
                    if (!csiptr->edting) {
                         btumil(usrnum,DFTIMX);
                    }
                    switch (newstt) {
                    case 0:
                         cncchr();
                         usrptr->flags&=~X2MAIN;
                         prfmsg(INTRO);
                         newstt=REPRMT;
                         break;
                    case REPRMT:
                         switch (cncchr()) {
                         case 'G':
                              errmsg(GENINF2);
                              break;
                         case 'S':
                              prfmsg(newstt=SCORDA);
                              break;
                         case 'P':
                              place();
                              break;
                         case 'M':
                              prfmsg(newstt=MODIFA);
                              break;
                         case 'D':
                              prfmsg(newstt=DELADN);
                              break;
                         case 'C':
                              crr1();
                              break;
                         case '?':
                              prfmsg(INTRO);
                              break;
                         default:
                              errmsg(CNOTIL);
                         }
                         break;
                    case SCORDA:
                         sscorda();
                         break;
                    case SCOSCN:
                         sscoscn();
                         break;
                    case SCORCQ:
                         sscorcq();
                         break;
                    case SCORSQ:
                         sscorsq();
                         break;
                    case SCORSC:
                         sscorsc();
                         break;
                    case SCORSP:
                         sscorsp();
                         break;
                    case ENTADT:
                         sentadt();
                         outprf(usrnum);
                         usrptr->substt=newstt;
                         return(1);
                    case MODIFA:
                         smodifa();
                         break;
                    case EDTAD:
                         sedtad();
                         outprf(usrnum);
                         usrptr->substt=newstt;
                         return(1);
                    case DELADN:
                         sdeladn();
                         break;
                    case PRSRET:
                         rsputl(" << more >> ");
                         break;
                    case CLRRDR:
                         sclrrdr();
                         break;
                    default:
                         catastro("CLASSI SUBSTT ERROR");
                    }
               } while (!endcnc());
          }
     }
     csidfi();
     outprf(usrnum);
     usrptr->substt=newstt;
     return(1);
}
 
static
sscorda()                          /* begin classified ad scanning         */
{
     setbtv(adbb);
     if (sameas(margv[0],"?")) {
          errmsg(SCOHLP);
          return;
     }
     if (margc != 1 || !isdigit(*nxtcmd)) {
          cpykey(csiptr->adblk.topic,cncall(),TPCSIZ);
          if (qgebtv(csiptr->adblk.topic,1)
           || qltbtv(csiptr->adblk.topic,1)) {
               gcrbtv(&(csiptr->adblk),1);
          }
          else {
               blwoff(NOADS);
               return;
          }
     }
     else {
          csiptr->adblk.adno=cnclon();
          if (!acqbtv(&(csiptr->adblk),&(csiptr->adblk.adno),0)) {
               errmsg(NSUCHN);
               return;
          }
     }
     showad();
     prfmsg(newstt=SCOSCN);
}
 
static
sscoscn()                          /* scanning classified ad database      */
{
     setbtv(adbb);
     gabbtv(&(csiptr->adblk),csiptr->fpos,1);
     switch (cncchr()) {
     case 'F':
          if (!qnxbtv()) {
               errmsg(SCOEND);
          }
          else {
               gcrbtv(&(csiptr->adblk),1);
               showad();
               prfmsg(SCOSCN);
          }
          break;
     case 'B':
          if (!qprbtv()) {
               errmsg(SCOBEG);
          }
          else {
               gcrbtv(&(csiptr->adblk),1);
               showad();
               prfmsg(SCOSCN);
          }
          break;
     case 'R':
          btuxmt(usrnum,csiptr->adblk.adtext);
          prf("\r");
          if (!nlvcar && usrptr->class < PAYING) {
               prfmsg(SCOAFR);
               break;
          }
          movmem(usaptr->userid,csiptr->rspblk.resper,UIDSIZ);
          csiptr->rspblk.adno=csiptr->adblk.adno;
          setbtv(rspbb);
          if (acqbtv(&csiptr->rspblk,csiptr->rspblk.resper,0)) {
               prfmsg(SCOCRR,csiptr->rspblk.rsptxt);
               prfmsg(newstt=SCORCQ);
          }
          else {
               prfmsg(newstt=SCORSQ);
          }
          break;
     default:
          errmsg(CNOTIL);
     }
}
 
static                        /* ask user if he wishes to update response  */
sscorcq()
{
     switch (cncchr()) {
     case 'Y':
          prfmsg(newstt=SCORSC);
          btumil(usrnum,RSLSIZ-1);
          break;
     case 'N':
          prfmsg(SCOAFR);
          newstt=SCOSCN;
          break;
     default:
          errmsg(YORN);
     }
}
 
static
sscorsq()                     /* ask user if he/she wishes to respond to ad*/
{
     switch (cncchr()) {
     case 'Y':
          prfmsg(newstt=SCORSP);
          btumil(usrnum,RSLSIZ-1);
          break;
     case 'N':
          prfmsg(SCOAFR);
          newstt=SCOSCN;
          break;
     default:
          errmsg(YORN);
     }
}
 
static
sscorsc()                     /* update response; continue scanning        */
{
     setbtv(rspbb);
     geqbtv(NULL,csiptr->rspblk.resper,0);
     cpykey(csiptr->rspblk.rsptxt,cncall(),RSLSIZ);
     csiptr->rspblk.rspdat=today();
     updbtv(&(csiptr->rspblk));
     prfmsg(SCOAFR);
     newstt=SCOSCN;
}
 
static
sscorsp()                     /* save response; continue with scanning     */
{
     setbtv(rspbb);
     movmem(usaptr->userid,csiptr->rspblk.resper,UIDSIZ);
     csiptr->rspblk.adno=csiptr->adblk.adno;
     movmem(csiptr->adblk.advrtr,csiptr->rspblk.advrtr,UIDSIZ);
     csiptr->rspblk.rspdat=today();
     cpykey(csiptr->rspblk.rsptxt,cncall(),RSLSIZ);
     insbtv(&(csiptr->rspblk));
     usaptr->tckavl-=nlvcar ? 0 : cartck;
     if (onsys(csiptr->adblk.advrtr)) {
          prfmsg(GTRSPO,usaptr->userid,ltoa(csiptr->adblk.adno));
          if (injoth()) {
               prfmsg(PNOTIF,csiptr->adblk.advrtr);
               outprf(usrnum);
          }
     }
     prfmsg(SCOAFR);
     newstt=SCOSCN;
}
 
sentadt()                     /* editor interface while creating an ad     */
{
     if (dunedt()) {
          makad();
          prfmsg(SAVEAD,ltoa(csiptr->adblk.adno));
          csiptr->edting=0;
          go2mai();
          csidfi();
     }
}
 
static
smodifa()                     /* select a classified ad to modify          */
{
     setbtv(adbb);
     csiptr->adblk.adno=cnclon();
     if (!acqbtv(&(csiptr->adblk),&(csiptr->adblk.adno),0)) {
          blwoff(NSUCHN);
          return;
     }
     if (!(sameas(csiptr->adblk.advrtr,usaptr->userid)
        || (usrptr->flags&ISYSOP))) {
          blwoff(UDONTO,ltoa(csiptr->adblk.adno));
          return;
     }
     if (confli()) {
          blwoff(USING);
          return;
     }
     newstt=EDTAD;
     csiptr->edting=1;
     bgnedt(0,msgbyts+1,csiptr->adblk.adtext,TPCSIZ,csiptr->adblk.topic);
}
 
sedtad()                      /* editor interface while modifying an ad    */
{
     if (dunedt()) {
          setbtv(adbb);
          geqbtv(NULL,&(csiptr->adblk.adno),0);
          upvbtv(&(csiptr->adblk),
                 sizeof(struct csiad)+strlen(csiptr->adblk.adtext));
          csiptr->edting=0;
          go2mai();
          csidfi();
     }
}
 
static
sdeladn()                          /* delete a given classified ad         */
{
     setbtv(adbb);
     csiptr->adblk.adno=cnclon();
     if (!acqbtv(&(csiptr->adblk),&(csiptr->adblk.adno),0)) {
          blwoff(NSUCHN);
          return;
     }
     if (!(sameas(csiptr->adblk.advrtr,usaptr->userid)
        || (usrptr->flags&ISYSOP))) {
          blwoff(UCANTD,ltoa(csiptr->adblk.adno));
          return;
     }
     if (confli()) {
          blwoff(USING);
          return;
     }
     delbtv();
     sv.csiopn-=1;
     blwoff(OKGONE);
}
 
static
sclrrdr()                     /* verify deletion of a user's ad repsonses  */
{
     switch (cncchr()) {
     case 'Y':
          zaprdr();
          blwoff(RSPCLD);
          break;
     case 'N':
          blwoff(RSPNCL,carlif);
          break;
     default:
          errmsg(YORN);
     }
}
 
makad()                            /* creates ad in the database           */
{
     setbtv(adbb);
     csiptr->adblk.crdate=today();
     csiptr->adblk.adno=sv.csitot;
     movmem(usaptr->userid,csiptr->adblk.advrtr,UIDSIZ);
     invbtv(&(csiptr->adblk),sizeof(struct csiad)+strlen(csiptr->adblk.adtext));
     usaptr->csicnt+=1;
     usaptr->tckavl-=nlvcad ? 0 : cadtck;
     sv.csitot+=1;
     sv.csiopn+=1;
}
 
confli()                      /* check for a conflict in deleting an ad    */
{
     long recpos;
 
     recpos=absbtv();
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (othusn != usrnum
           && othusp->class > SUPIPG
           && othusp->state == CSISTT
           && othusp->substt != REPRMT
           && csiarr(othusn)->fpos == recpos) {
               return(1);
          }
     }
     return(0);
}
 
static
errmsg(msgnum,p1)                  /* prf() error message utility          */
int msgnum;
long p1;
{
     prfmsg(msgnum,p1);
     if (!csiptr->edting) {
          prfmsg(newstt);
     }
     cncall();
}
 
static
blwoff(msgnum,parm)                /* prf() message; return to classi menu */
int msgnum;
long parm;
{
     prfmsg(msgnum,parm);
     go2mai();
     cncall();
}
 
static
go2mai()                           /* go back to main classi menu, or exit */
{
     condex();
     prfmsg(newstt=REPRMT);
}
 
showad()                           /* display a classified ad              */
{
     long absbtv();
 
     setbtv(adbb);
     prfmsg(ADDISP,ltoa(csiptr->adblk.adno),csiptr->adblk.advrtr);
     prf("%s\r",csiptr->adblk.topic);
     csiptr->fpos=absbtv();
}
 
place()                            /* place a classified ad                */
{
     if (!nlvcad) {
          if (usaptr->tckavl <= cadtck) {
               blwoff(NOLIVE);
               return;
          }
     }
     prfmsg(newstt=ENTADT);
     outprf(usrnum);
     csiptr->edting=1;
     bgnedt(1,msgbyts+1,csiptr->adblk.adtext,TPCSIZ,csiptr->adblk.topic);
}
 
crr1()                        /* display responses to your ads (if any)    */
{
     setbtv(rspbb);
     if (!acqbtv(&(csiptr->rspblk),usaptr->userid,1)) {
          blwoff(NORDRS);
     }
     else {
          prfmsg(RDRRSP);
          rsputl(NULL);
     }
}
 
rsputl(morstg)                /* display ad responses to a user            */
char *morstg;
{
     int i;
 
     setbtv(rspbb);
     if (morstg != NULL) {
          gabbtv(&(csiptr->rspblk),csiptr->fpos,1);
     }
     for (i=0 ; i < 4 ; i++) {
          prf(" From %-9s RE:#%s on %s: %s\r",csiptr->rspblk.resper,
              ltoa(csiptr->rspblk.adno),ncdate(csiptr->rspblk.rspdat),
              csiptr->rspblk.rsptxt);
          if (!aqnbtv(&(csiptr->rspblk))) {
               prfmsg(newstt=CLRRDR);
               return;
          }
     }
     if (morstg != NULL) {
          prf(morstg);
     }
     else {
          prfmsg(PRSRET);
     }
     csiptr->fpos=absbtv();
     newstt=PRSRET;
}
 
zaprdr()                           /* delete a user's responses            */
{
     setbtv(rspbb);
     if (!acqbtv(&(csiptr->rspblk),usaptr->userid,1)) {
          catastro("ZAPRDR: NO FIRST ENTRY");
     }
     delbtv();
     while (aqnbtv(&(csiptr->rspblk))) {
          delbtv();
     }
}
 
csidfi()                           /* default input character grabber      */
{
     char *lstchp;
 
     lstchp=prfptr-1;
     if (!isspace(*lstchp)) {
          csiptr->dftinp=*lstchp;
          *(prfptr=lstchp)='\0';
     }
     else {
          csiptr->dftinp='\0';
     }
}
 
csimcu()                      /* classified ads midnight cleanup routine   */
{
 
     #define CSIUSR ((struct csiusr *)vdarea)
     int ctoday;
 
     ctoday=cofdat(today());
     setbtv(adbb);
     sv.csiopn=0;
     if (qlobtv(0)) {
          do {
               gcrbtv(&CSIUSR->adblk,0);
               if (cadlif >= 0
                && ctoday-cofdat(CSIUSR->adblk.crdate) > cadlif) {
                    delbtv();
               }
               else {
                    sv.csiopn+=1;
               }
          } while (qnxbtv());
     }
     setbtv(rspbb);
     if (qlobtv(0)) {
          do {
               gcrbtv(&CSIUSR->rspblk,0);
               if (carlif >= 0
                && ctoday-cofdat(CSIUSR->rspblk.rspdat) > carlif) {
                    delbtv();
               }
          } while (qnxbtv());
     }
}
 
clscsi()                      /* close classified ads files for shutdown   */
{
     clsmsg(csimb);
     clsbtv(adbb);
     clsbtv(rspbb);
}
