/***************************************************************************
   KYRANDIA.H (K.H) - game structures, definitions, and declarations
 ***************************************************************************/
#include "bbsutils.h"
#include "gamutils.h"

#define NGSPLS 67        /* number of spells in wizards' spell array       */

extern
struct spell {                /* game spell/prayer structure definition    */
     char name[10];           /*   spell/prayer's name/invocation          */
     void (*splrou)();        /*   routine invoked when spell is cast      */
     int sbkref;
     long bitdef;
     int level;               /*   level required of player to cast spell  */
} spells[NGSPLS],             /* general purpose pointer for spells        */
   *splptr;

#define OFFENS 1
#define DEFENS 2
#define OTHERS 3

#define APNSIZ 20        /* maximum size of alternate name for players     */
#define MXPOBS 6         /* maximum number of objects held by a player     */
#define MAXSPL 10        /* maximum number of spells memorized by player   */
#define NCHARM 6         /* number of "charm" timer-related stuff          */

#define ALSSIZ 10        /* size of alias name for within game             */

#define CINVIS 0
#define FIRPRO 1
#define ICEPRO 2
#define LIGPRO 3
#define OBJPRO 4
#define ALTNAM 5

extern
struct kplayer {               /* game player structure definition          */
     char uidnam[UIDSIZ];      /*   player's name from User-ID              */
     char alias[ALSSIZ];       /*   player's alias name within the game     */
     char altnam[APNSIZ];      /*   player's alternate game name            */
     char attacknam[APNSIZ];   /*   player's attackable name                */
     struct gamobj *pobjs[MXPOBS];  /* array of player's objects            */
     int pdescr;               /*   player's description                    */
     int modno;                /*   player's BREAKTHROUGH modem channel no. */
     int level;                /*   player's experience "level"             */
     int gamloc;               /*   player's current game location number   */
     int pgploc;               /*   player's permanant game location        */
     long flags;               /*   player's gaming bit flags               */
     unsigned gold;            /*   number of gold pieces held by player    */
     int npobjs;               /*   number of objects held by player        */
     int obvals[MXPOBS];       /*   array of player's objects' values       */
     int nspells;              /*   number of spells currently memorized    */
     int spts;                 /*   number of spell points available        */
     int hitpts;               /*   player's "hit point" count              */
     int charms[NCHARM];       /*   array of timer-related stuff (pros,invs)*/
     long offspls;             /*   spellbook's offensive spell bit flags   */
     long defspls;             /*   spellbook's defensive spell bit flags   */
     long othspls;             /*   spellbook's "other" spell bit flags     */
     struct spell *spells[MAXSPL];/* array of spells currently memorized    */
     int gemidx;
     int stones[4];            /*   player's four birthstones               */
     int macros;
     int stumpi;
     char spouse[ALSSIZ];
     char spare[252-228];     /*   spare space, decrease when adding       */
} *Players,                   /* dynamically allocated player array        */
  *PlayPtr,                   /* general purpose game player pointer       */
  *OthPtr,                    /* second general purpose game player ptr.   */
  *EditPtr;                   /* general purpose pointer for player editor */

#define LOADED 0x00000001L    /* game record has been loaded into memory   */
#define FEMALE 0x00000002L    /* player is female in the game              */
#define INVISF 0x00000004L    /* player is invisible                       */
#define BRFSTF 0x00000008L
#define MARRYD 0x00000010L
#define PEGASU 0x00000020L
#define WILLOW 0x00000040L
#define GOTKYG 0x00000080L
#define PDRAGN 0x00000100L
#define BLESSD 0x00000200L

#define NGLOCS 305       /* number of locations in game array              */
#define MXLOBS 6         /* maximum number of objects at a location        */

extern
struct gamloc {               /* game location structure definition        */
     char brfdes[40];         /*   location's brief text description       */
     char objlds[30];
     int nlobjs;              /*   number of objects at location           */
     struct gamobj *lcobjs[MXLOBS];/* array of objects at location         */
     int gi_north;            /*   location number to the north            */
     int gi_south;            /*   location number to the south            */
     int gi_east;             /*   location number to the east             */
     int gi_west;             /*   location number to the west             */
} *LocArr,                    /* dynamically allocated locations array     */
  *CurLoc,                    /* current player's location pointer         */
  *OthLoc;                    /* general purpose location pointer          */

extern
struct glcrou {               /* game location routine structure definition*/
     int londes;
     int (*locrou)();         /*   location's specific routine handler     */
} lcrous[NGLOCS],             /* array of location routines (not dynamic)  */
  *lcrptr;                    /* current player's location routine pointer */

#define NGOBJS 54        /* number of objects in game array                */

extern
struct gamobj {               /* game object structure definition          */
     char *name;              /*   object's name                           */
     int objdes;              /*   object's description message number     */
     int auxmsg;              /*   object's auxillary message number       */
     int flags;               /*   object's bit "flags"                    */
     void (*objrou)();        /*   object's routine                        */
} Objects[NGOBJS],             /* array of game objects (not dynamic)       */
  *objptr;                    /* general purpose object pointer            */

#define NEEDAN 0x0001    /* requires "an" instead of "a" flag              */
#define VISIBL 0x0002
#define PICKUP 0x0004
#define REDABL 0x0008
#define AIMABL 0x0010
#define THIABL 0x0020
#define RUBABL 0x0040
#define DRIABL 0x0080

extern
struct cmdwrd {               /* command word structure definition         */
     char *command;           /*   command word                            */
     void (*cmdrou)();        /*   command's invoked routine               */
     int payonl;              /*   for paying users only flag              */
};

extern
struct binwrd {               /* command structure for bincmp()'s          */
     char *word;              /*   word                                    */
     int (*wrdrou)();         /*   word's specific invoked routine         */
} *wrdptr;                    /* general purpose bincmp() word pointer     */

extern
int objno,               /* used for an object's array position            */
    objno2;              /* another object array position holder           */

extern
int givrcrd;             /* give system credits for game gold              */

extern
char *titles[26];        /* titles for player levels                       */

extern
int zloc,dloc,kyrasub,kinuse;

extern
char *kyratr;            /* attribute for displayed Kyrandia text          */

extern
FILE *kmb,*klmb,*ksmb;

extern
BTVFILE *kbb;

/* KYRANDIA.C 12/03/92 16.07.16 */
void EXPORT init__kyrandia(void);
int kyloin(void);
int kyrand(void);
void initgp(struct kplayer *gp,char *alias);
void kyhup(void);
void kydela(char *userid);
void kysdn(void);

/* KYRALOC.C 12/03/92 14.15.00 */
void creatl(char *locfil);

/* KYRANIM.C 12/03/92 14.27.46 */
void inianm(void);
void animat(void);
void chkzar(void);
void zaritm(void);

/* KYRCMDS.C 12/03/92 14.41.50 */
void gi_north(void);
void gi_south(void);
void gi_east(void);
void gi_west(void);
void kyra(void);

/* KYRLOWR.C 12/03/92 14.56.34 */
void lowright(char *userid);

/* KYROBJR.C 12/03/92 14.58.42 */
void youmsg(int msgnum);
void rubber(void);
void thinkr(void);
void aimer(void);
void drinkr(void);

/* KYRPROT.C 12/03/92 15.08.38 */
int loadkp(void);
void rights(void);
void gi_prep4d(struct kplayer *gp);
void gi_rest4p(struct kplayer *gp);

/* KYRROUS.C 12/03/92 15.31.36 */
int willow(void);
int getgol(void);
int buyspl(void);
int temple(void);
int vhealr(void);
int gquest(void);
int terrac(void);
int waterf(void);
int gpcone(void);
int stumpr(void);
int silver(void);
int rubies(void);
int druids(void);
int fthick(void);
int fearno(void);
int swrock(void);
int ashtre(void);
int spring(void);
int rosutl(void);
int magicf(void);
int hnsrou(void);
int tashas(void);
int refpoo(void);
int panthe(void);
int portal(void);
int waller(void);
int slotma(void);
int mistyr(void);
int sanman(void);
int tulips(void);
int crystt(void);
int rainbo(void);
int sunshi(void);
int demong(void);
int bodyma(void);
int mindma(void);
int heartm(void);
int soulma(void);
int devote(void);
int truthy(void);
int fouris(void);
int singer(void);
int forgtr(void);
int oflove(void);
int believ(void);
int philos(void);
int fanbel(void);
int wingam(void);

/* KYRSPEL.C 12/03/92 15.48.04 */
void insrtk(void);
void splrtk(void);
void hitoth(int nhits);
void msgutl2(int yourmsg,int othmsg);
void shwpsp(void);
void seesbk(void);
void memori(void);
void caster(void);

/* KYRSYSP.C 12/03/92 15.53.24 */
void kyraedit(void);

/* KYRUTIL.C 12/03/92 15.58.54 */
void iniutl(void);
char *himher(struct kplayer *gp);
char *kheshe(struct kplayer *gp);
char *hisher(struct kplayer *gp);
int ckinvs(struct kplayer *gp);
void sndoth(void);
void sndutl(char *stg);
void sndbt2(void);
void sndcgp(struct kplayer *gp);
void sndloc(int loc);
void sndnear(void);
void sndgam(void);
void remvgp(struct kplayer *gp,char *rmvtxt);
void entrgp(int loc,struct kplayer *gp,char *enttxt);
void locobjs(int locno);
void gi_invrou(void);
void gi_invutl(struct kplayer *gp,int you);
char *dobutl(struct gamobj *object);
void locogps(struct kplayer *gp);
int ngpscn(struct kplayer *gp);
int ngpslc(int locno);
int findgp(char *stg);
int fgamgp(char *stg);
int chkobj(struct gamobj *obj);
struct gamobj *fndpobj(struct kplayer *gp,char *stg);
struct gamobj *fgmpobj(char *stg);
struct gamobj *fndlobj(struct gamloc *loc,char *stg);
struct gamobj *fgmlobj(char *stg);
void takpobj(struct kplayer *gp,int objino);
void tgmpobj(int objino);
void taklobj(struct gamloc *loc,int objino);
void tgmlobj(int objino);
void putpobj(struct kplayer *gp,struct gamobj *obj,int value);
void pgmpobj(struct gamobj *obj,int value);
void putlobj(struct gamloc *loc,struct gamobj *obj);
void pgmlobj(struct gamobj *obj);
char *upperc(char *stg);
struct binwrd *binchk(char *stgptr,struct binwrd table[],int length);
