/***************************************************************************
 *                                                                         *
 *   KYRANDIA, Fantasy-world of Legends                     Version 7.00   *
 *                                                                         *
 *   Copyright (C) 1988-1992 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   KYRANDIA.C (K.C) - Game mainline and Major BBS interface module       *
 *                                                                         *
 *   Designed/Programmed by: Scott Brinker & Richard Skurnick   03/18/88   *
 *                                    6.00 Converstion - E. Bush 3/12/92   *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "kyrandia.h"
#include "galkyrm.h"
#undef LEVEL6
#include "galkyrl.h"

STATIC void fixmargc(void);
STATIC int kyrinj(void);

char gamver[]={"7.00"};

int kyrstt;                   /* Kyrandia state number                     */
struct module kyrandia={      /* module interface block                    */
     "",                      /*    name used to refer to this module      */
     kyloin,                  /*    user log-on suplement                  */
     kyrand,                  /*    input routine if selected              */
     dfsthn,                  /*    status-input routine                   */
     kyrinj,                  /*    "injoth" routine for this module       */
     NULL,                    /*    user logoff supplemental routine       */
     kyhup,                   /*    hang-up routine                        */
     NULL,                    /*    midnight clean-up                      */
     kydela,                  /*    delete account routine                 */
     kysdn                    /*    system shut-down routine               */
};

struct kplayer *Players,*PlayPtr,*OthPtr,*EditPtr;
struct gamloc *LocArr,*CurLoc,*OthLoc;

int objno,               /* used for an object's array position       */
    objno2;              /* another object array position holder      */

int givrcrd;             /* give system credits for game gold         */

char *kyratr;            /* attribute for displayed Kyrandia text     */

BTVFILE *kbb;
FILE *kmb,*klmb,*ksmb;

char *titles[26]={
     "",
     "Apprentice",
     "Magic-user",
     "Evoker",
     "Conjurer",
     "Magician",
     "Mystic",
     "Enchanter",
     "Warlock",
     "Sorcerer",
     "Green Wizard",
     "Blue Wizard",
     "Red Wizard",
     "Grey Wizard",
     "White Wizard",
     "Mage",
     "Mage of Ice",
     "Mage of Wind",
     "Mage of Fire",
     "Mage of Light",
     "Arch-Mage",
     "Arch-Mage of Wands",
     "Arch Mage of Staves",
     "Arch-Mage of Swords",
     "Arch-Mage of Jewels",
     "Arch-Mage of Legends"
};

void EXPORT
init__kyrandia(void)               /* initialize Kyrandia */
{
    int n;

    stzcpy(kyrandia.descrp,gmdnam("GALKYR.MDF"),MNMSIZ);
    kyrstt=register_module(&kyrandia);
    klmb=opnmsg("galkyrl.mcv");
    ksmb=opnmsg("galkyrs.mcv");
    kmb=opnmsg("galkyrm.mcv");
    kyratr=stgopt(KYRATR);
    givrcrd=ynopt(GIVCRD);
    kbb=opnbtv("galkyr.dat",sizeof(struct kplayer));
    Players=(struct kplayer *)alczer(nterms*sizeof(struct kplayer));
    for (n=0 ; n < nterms ; n++) {
       Players[n].gamloc=-1;
    }
    iniutl();                /* utilities initialization  */
    creatl("galkyran.lcs");  /* dynaloc room array        */
    insrtk();                /* begin splrtk()            */
    inianm();                /* animator initialization   */
    kinuse=kyrasub=0;        /* Initialize Editor Package */
    fixmargc();
}

STATIC void
fixmargc(void)                     /* Prevents GP's with invalid margv[x]  */
{
    strcpy(input,"A B C D E F G H I J K L M N O P Q R S T U V W X Y Z");
    parsin();
}

int
kyloin(void)                       /* Kyrandia Supplemental Logon          */
{
    setbtv(kbb);
    if (!qeqbtv(usaptr->userid,0)) {
       setmbk(kmb);
       prfmsg(KLOGO);
       outprf(usrnum);
    }
    return(0);
}

int
kyrand(void)                       /* main game <CR>-input entry point     */
{
    int i,len,bad=0;

    setmbk(kmb);
    setbtv(kbb);
    PlayPtr=&Players[usrnum];
    PlayPtr->modno=usrnum;
    if (sameas(margv[0],"x") && usrptr->substt < 90) {
       remvgp(PlayPtr,"vanished in sparkling light");
       prfmsg(EXIKYR);
       btupmt(usrnum,0);
       return(0);
    }
    switch (usrptr->substt) {
    case 0:
       btuxmt(usrnum,kyratr);
       btuxmt(usrnum,"\r");
       if (PlayPtr->flags&LOADED) {
          dspmsg(CREDITS,(usaptr->sex == 'M' ? "Lord" : "Lady"),
                           PlayPtr->alias,gamver);
          gi_invrou();
          entrgp(PlayPtr->pgploc,PlayPtr,
                  "appeared in a cloud of mists");
          usrptr->substt=7;
       }
       else if (loadkp()) {
          prfmsg(KINM00);
          sndgam();
          dspmsg(CREDITS,(usaptr->sex == 'M' ? "Lord" : "Lady"),
                        PlayPtr->alias,gamver);
          rights();
       }
       else {
          btumil(usrnum,ALSSIZ-1);
          usrptr->substt++;
          prfmsg(GETALS);
          outprf(usrnum);
          break;
       }
       btupmt(usrnum,'>');
       break;
    case 1:
       btumil(usrnum,DFTIMX);
       setmbk(kmb);
       strlwr(margv[0]);
       margv[0][0]=toupper(margv[0][0]);
       len=strlen(margv[0]);
       setbtv(kbb);
       if (pfnlvl > 0) {
          prfmsg(FOULID);
          outprf(usrnum);
          break;
       }
       if (margc != 1) {
          bad=1;
       }
       else {
          for (i=0 ; i < len ; i++) {
             if (digalw ? !isalnum(margv[0][i]) : !isalpha(margv[0][i])) {
                bad=1;
                break;
             }
          }
       }
       if (bad || len < 3 || len > (ALSSIZ-1)) {
          prfmsg(BADPID);
          prfmsg(B4PLA2);
       }
       else if ((sameas(margv[0],"Sysop")
                   && !sameas(usaptr->userid,"Sysop"))
                || qeqbtv(margv[0],1)) {
          prfmsg(NTGOOD);
          prfmsg(B4PLA2);
       }
       else {
          btupmt(usrnum,'>');
          initgp(PlayPtr,margv[0]);
          gi_prep4d(PlayPtr);
          insbtv(PlayPtr);
          gi_rest4p(PlayPtr);
          prfmsg(GOODPD,margv[0]);
          usrptr->substt++;
       }
       outprf(usrnum);
       break;
    case 2:
       prfmsg(INTROA);
       outprf(usrnum);
       usrptr->substt++;
       break;
    case 3:
       prfmsg(INTROB);
       outprf(usrnum);
       usrptr->substt++;
       break;
    case 4:
       prfmsg(INTROC);
       outprf(usrnum);
       usrptr->substt++;
       break;
    case 5:
       prfmsg(INTROD,gamver);
       outprf(usrnum);
       usrptr->substt++;
       break;
    case 6:
       entrgp(0,PlayPtr,"appeared in a flash");
       usrptr->substt++;
       break;
    case 7:
       if (PlayPtr->macros != 19) {
          PlayPtr->macros++;
          kyra();
       }
       else {
          prfmsg(TIRED);
          outprf(usrnum);
       }
       break;
    case 90:
       kyraedit();
       break;
    }
    return(1);
}

STATIC int
kyrinj(void)                       /* Kyrandia injoth() routine handler */
{
    dftinj();
    btuxmn(othusn,kyratr);
    return(1);
}

void
initgp(                                 /* initialize player data */
struct kplayer *gp,
char *alias);                           /* alias id pass through  */
{
    int tmp,i;

    tmp=gp->modno;
    usaptr=uacoff(tmp);
    setmem(gp,sizeof(struct kplayer),0);
    strcpy(gp->uidnam,usaptr->userid);
    strcpy(gp->altnam,alias);
    strcpy(gp->attacknam,alias);
    strcpy(gp->alias,alias);
    gp->gamloc=-1;
    gp->level=1;
    gp->hitpts=4;
    gp->spts=2;
    gp->modno=tmp;
    gp->flags=(usaptr->sex == 'M' ? 0 : FEMALE);
    if (usaptr->sex == 'M') {
       gp->pdescr=MDES00;
    }
    else {
       gp->pdescr=FDES00;
    }
    gp->flags|=LOADED;
    for (i=0 ; i < 4 ; i++) {
       gp->stones[i]=genrdn(0,12);
    }
}

void
kyhup(void)                        /* Kyrandia hangup routine */
{
    PlayPtr=&Players[usrnum];
    if (PlayPtr->flags&LOADED) {
       setmbk(kmb);
       setbtv(kbb);
       if (PlayPtr->gamloc != -1) {
          remvgp(PlayPtr,"been sucked, screaming, into a dark void");
       }
       gi_prep4d(PlayPtr);
       geqbtv(NULL,usaptr->userid,0);
       updbtv(PlayPtr);
       setmem(PlayPtr,sizeof(struct kplayer),0);
       PlayPtr->gamloc=-1;
    }
    if (user[usrnum].state == kyrstt && user[usrnum].substt == 90) {
       kinuse=kyrasub=0;
       free(EditPtr);
    }
}

void
kydela(                        /* Kyrandia delete account routine */
char *userid;
{
    setbtv(kbb);
    if (acqbtv(NULL,userid,0)) {
       delbtv();
    }
}

void
kysdn(void)                        /* Kyrandia shutdown routine            */
{
    clsmsg(kmb);
    clsmsg(klmb);
    clsmsg(ksmb);
    clsbtv(kbb);
}

