/***************************************************************************
 *                                                                         *
 *   FAZUUL.C                                                              *
 *                                                                         *
 *   Copyright (C) 1984, 1986, 1991 GALACTICOMM, Inc. All Rights Reserved. *
 *                                                                         *
 *   This is the mainline of the FAZUUL game.      - T. Stryker 2/15/84    *
 *   Modified to act as a module of The Major BBS  - T. Stryker 7/5/86     *
 *   Modified to be a shippable add-on for version 5.2+ of The Major BBS   *
 *                                                 - T. Stryker 1/24/91    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "fazdat.h"
#include "galfaz.h"

STATIC void zrtkdo(void);
STATIC int fazinp(void);
STATIC int fazinj(void);
STATIC void zuuhup(void);
STATIC void zuuenc(void);
STATIC void encwrt(int intqty,int *dstbuf);
STATIC void zuudcd(void);
STATIC int dcdrd(int *srcbuf);
STATIC void delfaz(char *userid);
STATIC void finzuu(void);

int zuustt;                   /* Fazuul state number                       */
struct module fazuul={        /* module interface block                    */
     "",                      /*    name used to refer to this module      */
     NULL,                    /*    user log-on suplement                  */
     fazinp,                  /*    input routine if selected         */
     dfsthn,                  /*    status-input routine                   */
     fazinj,                  /*    "injoth" routine for this module       */
     NULL,                    /*    user logoff supplemental routine       */
     zuuhup,                  /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight clean-up                      */
     delfaz,                  /*    delete-account routine            */
     finzuu                   /*    finish-up (sys shutdown) routine  */
};

STATIC
BTVFILE *zuulbb;              /* Fazuul Btrieve user data file block ptr   */
STATIC
FILE *zuulmb;                 /* Fazuul message file block ptr             */

struct player *pyrarr,        /* dynam alloc'd player data structure array */
              *pyrptr,        /* ptr to current user's pyrarr element      */
              *othpyr;        /* "other" player ptr -- for actions etc.    */

struct state  *sttptr;        /* global scratch vbl for room structure ptr */
struct object *zbjptr;        /* global scratch vbl for object (item) ptr  */

int pyrctr,                   /* "player counter" - same as usrnum in BBS  */
    urgc;                     /* argument count - same as margc in BBS     */

char pyrcmd[256],             /* "player command" - same as input in BBS   */
     *fzcptr,                 /* global scratch vbl for scanning pyrcmd    */
     *urgv[64],               /* argument values - same as margv in BBS    */
     *arge[65];               /* argument ends - same as marge in BBS      */

int intmp1,                   /* scratch temporary vbl 1                   */
    intmp2,                   /* scratch temporary vbl 2                   */
    objidx,                   /* global scratch vbl for object indexes     */
    noistt;                   /* flag to whther() for uncond output        */

char *fazatr;                 /* attribute for displayed FAZUUL text       */
char *fazcant;                /* not allowed to play FAZUUL fully (msg)    */

void EXPORT
init__fazuul(void)            /* initialize the Fazuul game                */
{
     stzcpy(fazuul.descrp,gmdnam("GALFAZ.MDF"),MNMSIZ);
     zuustt=register_module(&fazuul);
     zinirtk();
     zuulmb=opnmsg("galfaz.mcv");
     fazatr=stgopt(FAZATR);
     fazcant=stgopt(FAZCANT);
     inists();
     zuulbb=opnbtv("galfaz.dat",sizeof(struct player));
     rtkick(1,zrtkdo);
     pyrarr=(struct player *)alczer(nterms*sizeof(struct player));
}

STATIC void
zrtkdo(void)                  /* 'zuul "real-time kicktable" servicer      */
{
     setmbk(zuulmb);
     zrtksvc();
     rtkick(1,zrtkdo);
}

STATIC int
fazinp(void)                  /* main fazuul game <CR>-input entry point   */
{
     char *inpptr,*pycmdp;
     int i,len,bad=0;

     setmbk(zuulmb);
     pyrctr=usrnum;
     pyrptr=&(pyrarr[pyrctr]);
     if (usrptr->substt != 0 && margc > 0 &&
         (sameas(margv[0],"x") || sameas(margv[0],"exit"))) {
          if (pyrptr->logon&INGAME) {
               lvstt("dematerialized");
          }
          btupmt(pyrctr,0);
          prf("...Exiting FAZUUL, returning to main menu...\r");
          usrptr->pfnacc=0;
          return(0);
     }
     switch (usrptr->substt) {
     case 0:
          setbtv(zuulbb);
          btuxmt(pyrctr,fazatr);
          btuxmt(pyrctr,"\r");
          if (pyrptr->logon&SGOBIT) {
               ntrstt(pyrptr->sttptr,"materialized next to you");
               btupmt(pyrctr,'>');
               usrptr->substt=6;
          }
          else if (acqbtv(pyrptr,usaptr->userid,0)) {
               pyrptr->portno=pyrctr;
               zuudcd();
               prfmsg(FAZ47);
               fazall();
               setmem(pyrptr->vsttes,2*NVSTMN*sizeof(int),0);
               invrtn();
               ntrstt(pyrptr->sttptr,"popped into existence next to you");
               btupmt(pyrctr,'>');
               usrptr->substt=6;
          }
          else {
               btumil(usrnum,ALSSIZ-1);
               usrptr->substt++;
               prfmsg(GETALS);
               outprf(usrnum);
          }
          break;
     case 1:
          setmbk(zuulmb);
          setbtv(zuulbb);
          strlwr(margv[0]);
          margv[0][0]=toupper(margv[0][0]);
          len=strlen(margv[0]);
          if (pfnlvl > 0) {
               prfmsg(FOULID);
               outprf(usrnum);
               break;
          }
          if (margc != 1) {
               bad=1;
          }
          else {
               for (i=0 ; i < len ; i++) {
                    if (digalw ? !isalnum(margv[0][i])
                        : !isalpha(margv[0][i])) {
                         bad=1;
                         break;
                    }
               }
          }
          if (bad || len < 3 || len > (ALSSIZ-1)) {
               prfmsg(BADPID);
               prfmsg(B4PLA2);
          }
          else if ((sameas(margv[0],"Sysop")
                && !sameas(usaptr->userid,"Sysop")) || qeqbtv(margv[0],1)) {
               prfmsg(NTGOOD);
               prfmsg(B4PLA2);
          }
          else {
               strcpy(pyrptr->plyrid,margv[0]);
               prfmsg(GOODPD,margv[0]);
               btumil(usrnum,DFTIMX);
               usrptr->substt++;
          }
          outprf(usrnum);
          break;
     case 2:
          setbtv(zuulbb);
          jabber(FAZ26);
          pyrptr->logon=(usaptr->sex == 'M' ? SEXBIT+SGOBIT : SGOBIT);
          strcpy(pyrptr->handle,usaptr->userid);
          strcpy(pyrptr->auxhdl,pyrptr->plyrid);
          pyrptr->newflg=FLOBIT;
          pyrptr->sttptr=&states[1];
          insbtv(pyrptr);
          pyrptr->portno=pyrctr;
          usrptr->substt++;
          break;
     case 3:
          jabber(FAZ27);
          usrptr->substt++;
          break;
     case 4:
          jabber(FAZ28);
          usrptr->substt++;
          break;
     case 5:
          prfmsg(FAZ49);
          fazall();
          ntrstt(&states[1],"beamed in from off-planet");
          btupmt(pyrctr,'>');
          usrptr->substt++;
          break;
     case 6:
          rstrin();
          for (inpptr=input,pycmdp=pyrcmd ; *inpptr != '\0' ; ) {
               *pycmdp++=tolower(*inpptr);
               inpptr+=1;
          }
          *pycmdp='\0';
          prscmd();
          game();
          break;
     }
     return(1);
}

STATIC int
fazinj(void)                  /* 'zuul injoth() routine handler            */
{
     dftinj();
     btuxmn(othusn,fazatr);
     return(1);
}

STATIC void
zuuhup(void)                  /* 'zuul loss-of-carrier entry point         */
{
     pyrctr=usrnum;
     pyrptr=&(pyrarr[pyrctr]);
     if (pyrptr->logon&SGOBIT) {
          if (pyrptr->logon&INGAME) {
               lvstt("vanished");
          }
          zuuenc();
          setbtv(zuulbb);
          geqbtv(NULL,pyrptr->handle,0);
          updbtv(pyrptr);
     }
     setmem(pyrptr,sizeof(struct player),0);
}

STATIC void
zuuenc(void)                  /* "encode" player state and object ptrs     */
{
     int i;

     encwrt((int)((pyrptr->sttptr)-states),(int *)(&(pyrptr->sttptr)));
     for (i=0 ; i < NOBJHD ; i++) {
          encwrt((int)((pyrptr->pyrobj[i])-objcts),
                 (int *)(&(pyrptr->pyrobj[i])));
     }
}

STATIC void
encwrt(intqty,dstbuf)         /* utility routine to avoid compile warnings */
int intqty;
int *dstbuf;
{
     *dstbuf=intqty;
}

STATIC void
zuudcd(void)                  /* "decode" player state and object ptrs     */
{
     int i;

     pyrptr->sttptr=&states[dcdrd((int *)(&(pyrptr->sttptr)))];
     for (i=0 ; i < NOBJHD ; i++) {
          pyrptr->pyrobj[i]=&objcts[dcdrd((int *)(&(pyrptr->pyrobj[i])))];
     }
}

STATIC int
dcdrd(srcbuf)                 /* utility routine to avoid compile warnings */
int *srcbuf;
{
     return(*srcbuf);
}

STATIC void
delfaz(userid)                /* 'zuul delete-account entry point          */
char *userid;
{
     setbtv(zuulbb);
     if (acqbtv(NULL,userid,0)) {
          delbtv();
     }
}

STATIC void
finzuu(void)                  /* finish-up 'zuul entry point for shutdown  */
{
     clsmsg(zuulmb);
     clsbtv(zuulbb);
}
